/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spark.bigquery.repackaged.com.google.auto.value.processor;

import com.google.cloud.spark.bigquery.repackaged.autovalue.shaded.com.google.auto.common.MoreTypes;
import com.google.cloud.spark.bigquery.repackaged.autovalue.shaded.com.google.common.base.Strings;
import com.google.cloud.spark.bigquery.repackaged.autovalue.shaded.com.google.common.collect.ImmutableList;
import com.google.cloud.spark.bigquery.repackaged.autovalue.shaded.com.google.common.collect.ImmutableMap;
import com.google.cloud.spark.bigquery.repackaged.com.google.auto.value.processor.TypeMirrorSet;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.IntersectionType;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.type.TypeVariable;
import javax.lang.model.type.WildcardType;
import javax.lang.model.util.SimpleTypeVisitor8;

class Nullables {
    static final String NULLABLE_OPTION = "com.google.cloud.spark.bigquery.repackaged.com.google.auto.value.NullableTypeAnnotation";
    private static final String DEFAULT_NULLABLE = "org".concat(".jspecify.nullness.Nullable");
    private final Optional<AnnotationMirror> nullableTypeAnnotation;

    private Nullables(Optional<AnnotationMirror> nullableTypeAnnotation) {
        this.nullableTypeAnnotation = nullableTypeAnnotation;
    }

    static Nullables fromMethods(ProcessingEnvironment processingEnv, Collection<ExecutableElement> methods) {
        Optional nullableTypeAnnotation = methods.stream().flatMap(method -> Stream.concat(Stream.of(method.getReturnType()), method.getParameters().stream().map(Element::asType))).map(Nullables::nullableIn).filter(Optional::isPresent).findFirst().orElseGet(() -> Nullables.defaultNullableTypeAnnotation(processingEnv));
        return new Nullables(nullableTypeAnnotation);
    }

    ImmutableList<AnnotationMirror> nullableTypeAnnotations() {
        return this.nullableTypeAnnotation.map(ImmutableList::of).orElse(ImmutableList.of());
    }

    private static Optional<AnnotationMirror> defaultNullableTypeAnnotation(ProcessingEnvironment processingEnv) {
        if (processingEnv == null) {
            return Optional.empty();
        }
        String nullableOption = Strings.nullToEmpty(processingEnv.getOptions().getOrDefault(NULLABLE_OPTION, DEFAULT_NULLABLE));
        return !nullableOption.isEmpty() && processingEnv.getSourceVersion().ordinal() >= SourceVersion.RELEASE_8.ordinal() ? Optional.ofNullable(processingEnv.getElementUtils().getTypeElement(nullableOption)).map(t2 -> Nullables.annotationMirrorOf(MoreTypes.asDeclared(t2.asType()))) : Optional.empty();
    }

    private static AnnotationMirror annotationMirrorOf(final DeclaredType annotationType) {
        return new AnnotationMirror(){

            @Override
            public DeclaredType getAnnotationType() {
                return annotationType;
            }

            public ImmutableMap<? extends ExecutableElement, ? extends AnnotationValue> getElementValues() {
                return ImmutableMap.of();
            }
        };
    }

    private static Optional<AnnotationMirror> nullableIn(TypeMirror type) {
        return (Optional)new NullableFinder().visit(type);
    }

    private static Optional<AnnotationMirror> nullableIn(List<? extends AnnotationMirror> annotations) {
        return annotations.stream().filter(a -> a.getAnnotationType().asElement().getSimpleName().contentEquals("Nullable")).map(a -> a).findFirst();
    }

    private static class NullableFinder
    extends SimpleTypeVisitor8<Optional<AnnotationMirror>, Void> {
        private final TypeMirrorSet visiting = new TypeMirrorSet();

        NullableFinder() {
            super(Optional.empty());
        }

        @Override
        public Optional<AnnotationMirror> visitDeclared(DeclaredType t2, Void unused) {
            if (!this.visiting.add(t2)) {
                return Optional.empty();
            }
            return Nullables.nullableIn(t2.getAnnotationMirrors()).map(Optional::of).orElseGet(() -> this.visitAll(t2.getTypeArguments()));
        }

        @Override
        public Optional<AnnotationMirror> visitTypeVariable(TypeVariable t2, Void unused) {
            if (!this.visiting.add(t2)) {
                return Optional.empty();
            }
            return Nullables.nullableIn(t2.getAnnotationMirrors()).map(Optional::of).orElseGet(() -> this.visitAll(ImmutableList.of(t2.getUpperBound(), t2.getLowerBound())));
        }

        @Override
        public Optional<AnnotationMirror> visitArray(ArrayType t2, Void unused) {
            return Nullables.nullableIn(t2.getAnnotationMirrors()).map(Optional::of).orElseGet(() -> (Optional)this.visit(t2.getComponentType()));
        }

        @Override
        public Optional<AnnotationMirror> visitWildcard(WildcardType t2, Void unused) {
            return Nullables.nullableIn(t2.getAnnotationMirrors()).map(Optional::of).orElseGet(() -> this.visitAll(Stream.of(t2.getExtendsBound(), t2.getSuperBound()).filter(Objects::nonNull).collect(Collectors.toList())));
        }

        @Override
        public Optional<AnnotationMirror> visitIntersection(IntersectionType t2, Void unused) {
            return Nullables.nullableIn(t2.getAnnotationMirrors()).map(Optional::of).orElseGet(() -> this.visitAll(t2.getBounds()));
        }

        private Optional<AnnotationMirror> visitAll(List<? extends TypeMirror> types) {
            return types.stream().map(this::visit).filter(Optional::isPresent).findFirst().orElse(Optional.empty());
        }
    }
}

