/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spark.bigquery;

import com.google.cloud.spark.bigquery.SparkBigQueryConfig;
import com.google.cloud.spark.bigquery.repackaged.com.google.common.base.Objects;
import java.io.Serializable;

public class SchemaConvertersConfiguration
implements Serializable {
    private static final long serialVersionUID = -5971771984509805208L;
    private final boolean allowMapTypeConversion;
    private int bigNumericDefaultPrecision;
    private int bigNumericDefaultScale;

    private SchemaConvertersConfiguration(boolean allowMapTypeConversion, int bigNumericDefaultPrecision, int bigNumericDefaultScale) {
        this.allowMapTypeConversion = allowMapTypeConversion;
        this.bigNumericDefaultPrecision = bigNumericDefaultPrecision;
        this.bigNumericDefaultScale = bigNumericDefaultScale;
    }

    public static SchemaConvertersConfiguration from(SparkBigQueryConfig config) {
        return SchemaConvertersConfiguration.of(config.getAllowMapTypeConversion(), config.getBigNumericDefaultPrecision(), config.getBigNumericDefaultScale());
    }

    public static SchemaConvertersConfiguration of(boolean allowMapTypeConversion) {
        return new SchemaConvertersConfiguration(allowMapTypeConversion, 76, 38);
    }

    public static SchemaConvertersConfiguration of(boolean allowMapTypeConversion, int bigNumericDefaultPrecision, int bigNumericDefaultScale) {
        return new SchemaConvertersConfiguration(allowMapTypeConversion, bigNumericDefaultPrecision, bigNumericDefaultScale);
    }

    public static SchemaConvertersConfiguration createDefault() {
        return new SchemaConvertersConfiguration(SparkBigQueryConfig.ALLOW_MAP_TYPE_CONVERSION_DEFAULT, 76, 38);
    }

    public boolean getAllowMapTypeConversion() {
        return this.allowMapTypeConversion;
    }

    public int getBigNumericDefaultPrecision() {
        return this.bigNumericDefaultPrecision;
    }

    public int getBigNumericDefaultScale() {
        return this.bigNumericDefaultScale;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SchemaConvertersConfiguration that = (SchemaConvertersConfiguration)o;
        return Objects.equal(this.allowMapTypeConversion, that.allowMapTypeConversion) && Objects.equal(this.bigNumericDefaultPrecision, that.bigNumericDefaultPrecision) && Objects.equal(this.bigNumericDefaultScale, that.bigNumericDefaultScale);
    }

    public int hashCode() {
        return Objects.hashCode(this.allowMapTypeConversion, this.bigNumericDefaultPrecision, this.bigNumericDefaultScale);
    }

    public String toString() {
        return "SchemaConvertersConfiguration{allowMapTypeConversion=" + this.allowMapTypeConversion + '}';
    }
}

