/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigquery.connector.common;

import com.google.cloud.spark.bigquery.repackaged.com.google.auth.oauth2.GoogleCredentials;
import com.google.cloud.spark.bigquery.repackaged.com.google.auth.oauth2.IdTokenCredentials;
import com.google.cloud.spark.bigquery.repackaged.com.google.auth.oauth2.IdTokenProvider;
import java.io.IOException;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IdentityTokenSupplier
implements Serializable {
    private static final Logger log = LoggerFactory.getLogger(IdentityTokenSupplier.class);
    private static final IdTokenProvider.Option FORMAT = IdTokenProvider.Option.FORMAT_FULL;
    private static final IdTokenProvider.Option LICENSE = IdTokenProvider.Option.LICENSES_TRUE;
    private static final long serialVersionUID = 532621593482642874L;

    public static Optional<String> fetchIdentityToken(String audience) {
        try {
            GoogleCredentials googleCredentials = GoogleCredentials.getApplicationDefault();
            IdTokenCredentials idTokenCredentials = IdTokenCredentials.newBuilder().setIdTokenProvider((IdTokenProvider)((Object)googleCredentials)).setTargetAudience(audience).setOptions(Arrays.asList(FORMAT, LICENSE)).build();
            return Optional.ofNullable(idTokenCredentials.refreshAccessToken().getTokenValue());
        }
        catch (IOException | RuntimeException ex) {
            log.info("Unable to obtain identity token");
            log.debug("Exception while fetching identity token", (Throwable)ex);
            return Optional.empty();
        }
    }
}

