/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigquery.connector.common;

import com.google.cloud.bigquery.connector.common.BigQueryConfigurationUtil;
import com.google.common.base.Optional;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.Collection;
import java.util.Map;

public class MaterializationConfiguration {
    public static final int DEFAULT_MATERIALIZATION_EXPIRATION_TIME_IN_MINUTES = 1440;
    private final Optional<String> materializationProject;
    private final Optional<String> materializationDataset;
    private final int materializationExpirationTimeInMinutes;

    public static MaterializationConfiguration from(ImmutableMap<String, String> globalOptions, Map<String, String> options) {
        Optional<String> materializationProject = BigQueryConfigurationUtil.getAnyOption(globalOptions, options, (Collection<String>)ImmutableList.of((Object)"materializationProject", (Object)"viewMaterializationProject"));
        Optional<String> materializationDataset = BigQueryConfigurationUtil.getAnyOption(globalOptions, options, (Collection<String>)ImmutableList.of((Object)"materializationDataset", (Object)"viewMaterializationDataset"));
        int materializationExpirationTimeInMinutes = (Integer)BigQueryConfigurationUtil.getAnyOption(globalOptions, options, "materializationExpirationTimeInMinutes").transform(Integer::parseInt).or((Object)1440);
        if (materializationExpirationTimeInMinutes < 1) {
            throw new IllegalArgumentException("materializationExpirationTimeInMinutes must have a positive value, the configured value is " + materializationExpirationTimeInMinutes);
        }
        return new MaterializationConfiguration(materializationProject, materializationDataset, materializationExpirationTimeInMinutes);
    }

    private MaterializationConfiguration(Optional<String> materializationProject, Optional<String> materializationDataset, int materializationExpirationTimeInMinutes) {
        this.materializationProject = materializationProject;
        this.materializationDataset = materializationDataset;
        this.materializationExpirationTimeInMinutes = materializationExpirationTimeInMinutes;
    }

    public Optional<String> getMaterializationProject() {
        return this.materializationProject;
    }

    public Optional<String> getMaterializationDataset() {
        return this.materializationDataset;
    }

    public int getMaterializationExpirationTimeInMinutes() {
        return this.materializationExpirationTimeInMinutes;
    }
}

