/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigquery.connector.common;

import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import javax.annotation.CheckForNull;

public class LazyInitializationSupplier<T>
implements Supplier<T> {
    final Supplier<T> delegate;
    volatile boolean initialized;
    @CheckForNull
    transient T value;

    public LazyInitializationSupplier(Supplier<T> delegate) {
        this.delegate = (Supplier)Preconditions.checkNotNull(delegate);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T get() {
        if (!this.initialized) {
            LazyInitializationSupplier lazyInitializationSupplier = this;
            synchronized (lazyInitializationSupplier) {
                if (!this.initialized) {
                    Object t = this.delegate.get();
                    this.value = t;
                    this.initialized = true;
                    return (T)t;
                }
            }
        }
        return this.value;
    }

    public String toString() {
        return "Suppliers.memoize(" + (this.initialized ? "<supplier that returned " + this.value + ">" : this.delegate) + ")";
    }

    public boolean isInitialized() {
        return this.initialized;
    }
}

