/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigquery.connector.common;

import com.google.auth.Credentials;
import com.google.auth.oauth2.ExternalAccountCredentials;
import com.google.cloud.bigquery.BigQueryError;
import com.google.cloud.bigquery.BigQueryException;
import com.google.cloud.bigquery.Clustering;
import com.google.cloud.bigquery.ExternalTableDefinition;
import com.google.cloud.bigquery.Field;
import com.google.cloud.bigquery.FieldList;
import com.google.cloud.bigquery.FieldValue;
import com.google.cloud.bigquery.FieldValueList;
import com.google.cloud.bigquery.HivePartitioningOptions;
import com.google.cloud.bigquery.LegacySQLTypeName;
import com.google.cloud.bigquery.QueryParameterValue;
import com.google.cloud.bigquery.RangePartitioning;
import com.google.cloud.bigquery.Schema;
import com.google.cloud.bigquery.StandardSQLTypeName;
import com.google.cloud.bigquery.StandardTableDefinition;
import com.google.cloud.bigquery.TableDefinition;
import com.google.cloud.bigquery.TableId;
import com.google.cloud.bigquery.TableInfo;
import com.google.cloud.bigquery.TableResult;
import com.google.cloud.bigquery.TimePartitioning;
import com.google.cloud.bigquery.connector.common.ComparisonResult;
import com.google.cloud.bigquery.connector.common.ParameterMode;
import com.google.cloud.bigquery.connector.common.QueryParameterHelper;
import com.google.cloud.bigquery.storage.v1.ReadSession;
import com.google.cloud.bigquery.storage.v1.ReadStream;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multimap;
import io.grpc.Status;
import io.grpc.StatusRuntimeException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.lang.reflect.InvocationTargetException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.TreeMap;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.annotation.Nullable;

public class BigQueryUtil {
    public static final int DEFAULT_NUMERIC_PRECISION = 38;
    public static final int DEFAULT_NUMERIC_SCALE = 9;
    public static final int DEFAULT_BIG_NUMERIC_PRECISION = 76;
    public static final int DEFAULT_BIG_NUMERIC_SCALE = 38;
    private static final int NO_VALUE = -1;
    private static final long BIGQUERY_INTEGER_MIN_VALUE = Long.MIN_VALUE;
    static final ImmutableSet<String> INTERNAL_ERROR_MESSAGES = ImmutableSet.of((Object)"HTTP/2 error code: INTERNAL_ERROR", (Object)"Connection closed with unknown cause", (Object)"Received unexpected EOS on DATA frame from server");
    static final String READ_SESSION_EXPIRED_ERROR_MESSAGE = "session expired at";
    private static final String PROJECT_PATTERN = "\\S+";
    private static final String DATASET_PATTERN = "\\w+";
    private static final String TABLE_PATTERN = "[^.:]+";
    private static final String NAMED_PARAM_PREFIX = "namedparameters.";
    private static final String POSITIONAL_PARAM_PREFIX = "positionalparameters.";
    private static final Pattern QUALIFIED_TABLE_REGEX = Pattern.compile(String.format("^(((%s)[:.])?(%s)\\.)?(%s)$$", "\\S+", "\\w+", "[^.:]+"));
    private static final int MAX_FILTER_LENGTH_IN_BYTES = 0x200000;

    private BigQueryUtil() {
    }

    public static boolean isRetryable(Throwable cause) {
        return Throwables.getCausalChain((Throwable)cause).stream().anyMatch(BigQueryUtil::isRetryableInternalError);
    }

    static boolean isRetryableInternalError(Throwable t) {
        if (t instanceof StatusRuntimeException) {
            StatusRuntimeException statusRuntimeException = (StatusRuntimeException)t;
            return statusRuntimeException.getStatus().getCode() == Status.Code.INTERNAL && INTERNAL_ERROR_MESSAGES.stream().anyMatch(message -> statusRuntimeException.getMessage().contains((CharSequence)message));
        }
        return false;
    }

    public static boolean isReadSessionExpired(Throwable cause) {
        return Throwables.getCausalChain((Throwable)cause).stream().anyMatch(BigQueryUtil::isReadSessionExpiredInternalError);
    }

    static boolean isReadSessionExpiredInternalError(Throwable t) {
        if (t instanceof StatusRuntimeException) {
            StatusRuntimeException statusRuntimeException = (StatusRuntimeException)t;
            return statusRuntimeException.getStatus().getCode() == Status.Code.FAILED_PRECONDITION && statusRuntimeException.getMessage().contains(READ_SESSION_EXPIRED_ERROR_MESSAGE);
        }
        return false;
    }

    static BigQueryException convertToBigQueryException(BigQueryError error) {
        return new BigQueryException(0, error.getMessage(), error);
    }

    static boolean areCredentialsEqual(Credentials credentials1, Credentials credentials2) {
        if (!(credentials1 instanceof ExternalAccountCredentials) && !(credentials2 instanceof ExternalAccountCredentials)) {
            return Objects.equal((Object)credentials1, (Object)credentials2);
        }
        return Arrays.equals(BigQueryUtil.getCredentialsByteArray(credentials1), BigQueryUtil.getCredentialsByteArray(credentials2));
    }

    static byte[] getCredentialsByteArray(Credentials credentials) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
            objectOutputStream.writeObject(credentials);
            objectOutputStream.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return byteArrayOutputStream.toByteArray();
    }

    static Credentials getCredentialsFromByteArray(byte[] byteArray) {
        try {
            ObjectInputStream objectInputStream = new ObjectInputStream(new ByteArrayInputStream(byteArray));
            return (Credentials)objectInputStream.readObject();
        }
        catch (IOException | ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    public static <T> Optional<T> firstPresent(Optional<T> ... optionals) {
        for (Optional<T> o : optionals) {
            if (!o.isPresent()) continue;
            return o;
        }
        return Optional.empty();
    }

    public static TableId parseTableId(String rawTable) {
        return BigQueryUtil.parseTableId(rawTable, Optional.empty(), Optional.empty(), Optional.empty());
    }

    public static TableId parseTableId(String rawTable, Optional<String> dataset, Optional<String> project) {
        return BigQueryUtil.parseTableId(rawTable, dataset, project, Optional.empty());
    }

    public static TableId parseTableId(String rawTable, Optional<String> dataset, Optional<String> project, Optional<String> datePartition) {
        Matcher matcher;
        String effectiveTable = rawTable.trim();
        if (effectiveTable.length() >= 2 && effectiveTable.startsWith("`") && effectiveTable.endsWith("`")) {
            effectiveTable = effectiveTable.substring(1, effectiveTable.length() - 1);
        }
        if (!(matcher = QUALIFIED_TABLE_REGEX.matcher(effectiveTable)).matches()) {
            throw new IllegalArgumentException(String.format("Invalid Table ID '%s'. Must match '%s'", rawTable, QUALIFIED_TABLE_REGEX));
        }
        String table = matcher.group(5);
        Optional<String> parsedDataset = Optional.ofNullable(matcher.group(4));
        Optional<String> parsedProject = Optional.ofNullable(matcher.group(3));
        String tableAndPartition = datePartition.map(date -> String.format("%s$%s", table, date)).orElse(table);
        String actualDataset = (String)BigQueryUtil.firstPresent(parsedDataset, dataset).orElseThrow(() -> new IllegalArgumentException("'dataset' not parsed or provided."));
        return BigQueryUtil.firstPresent(parsedProject, project).map(p -> TableId.of((String)p, (String)actualDataset, (String)tableAndPartition)).orElse(TableId.of((String)actualDataset, (String)tableAndPartition));
    }

    public static String friendlyTableName(TableId tableId) {
        return tableId.getProject() != null ? String.format("%s.%s.%s", tableId.getProject(), tableId.getDataset(), tableId.getTable()) : String.format("%s.%s", tableId.getDataset(), tableId.getTable());
    }

    public static void convertAndThrow(BigQueryError error) {
        throw new BigQueryException(0, error.getMessage(), error);
    }

    public static List<String> optimizeLoadUriList(List<String> uris, String prefixRegex, String suffixRegex) {
        Pattern pattern = Pattern.compile("(" + prefixRegex + "\\d*)\\d\\**(" + suffixRegex + ")");
        ImmutableList.Builder result = ImmutableList.builder();
        List<String> workingList = uris;
        while (!workingList.isEmpty()) {
            Multimap<String, String> trimmedUriMap = BigQueryUtil.trimUris(pattern, workingList);
            ArrayList<String> nextList = new ArrayList<String>();
            for (String trimmedUri : trimmedUriMap.keySet()) {
                Collection mappedUris = trimmedUriMap.get((Object)trimmedUri);
                if (mappedUris.size() == 10) {
                    nextList.add(trimmedUri);
                    continue;
                }
                result.addAll((Iterable)mappedUris);
            }
            trimmedUriMap.clear();
            workingList = nextList;
        }
        return result.build();
    }

    private static Multimap<String, String> trimUris(Pattern pattern, List<String> workingList) {
        HashMultimap trimmedUriMap = HashMultimap.create();
        for (String uri : workingList) {
            String trimmedUri = pattern.matcher(uri).replaceFirst("$1*$2");
            trimmedUriMap.put((Object)trimmedUri, (Object)uri);
        }
        return trimmedUriMap;
    }

    public static ComparisonResult schemaWritable(Schema sourceSchema, Schema destinationSchema, boolean regardFieldOrder, boolean enableModeCheckForSchemaFields) {
        if (sourceSchema == destinationSchema) {
            return ComparisonResult.equal();
        }
        if (sourceSchema == null || destinationSchema == null) {
            return ComparisonResult.differentNoDescription();
        }
        if (regardFieldOrder) {
            boolean equalsResult = sourceSchema.equals((Object)destinationSchema);
            return ComparisonResult.fromEqualsResult(equalsResult);
        }
        return BigQueryUtil.fieldListWritable(sourceSchema.getFields(), destinationSchema.getFields(), enableModeCheckForSchemaFields);
    }

    public static List<String> getStreamNames(ReadSession readSession) {
        return readSession == null ? new ArrayList<String>() : (List)readSession.getStreamsList().stream().map(ReadStream::getName).collect(Collectors.toCollection(ArrayList::new));
    }

    @VisibleForTesting
    static ComparisonResult fieldWritable(Field sourceField, Field destinationField, boolean enableModeCheckForSchemaFields) {
        boolean sourcePrecisionLessThanEqualsDestPrecision;
        boolean sourceMaxLenLessThanEqualsDestMaxLen;
        if (sourceField == destinationField) {
            return ComparisonResult.equal();
        }
        if (sourceField == null) {
            if (destinationField.getMode() == Field.Mode.REQUIRED) {
                return ComparisonResult.differentWithDescription((List<String>)ImmutableList.of((Object)("Required field not found in source: " + destinationField.getName())));
            }
            return ComparisonResult.equal();
        }
        if (destinationField == null) {
            return ComparisonResult.differentWithDescription((List<String>)ImmutableList.of((Object)("Field not found in destination: " + sourceField.getName())));
        }
        if (!Objects.equal((Object)sourceField.getName(), (Object)destinationField.getName())) {
            return ComparisonResult.differentWithDescription((List<String>)ImmutableList.of((Object)"Wrong field name", (Object)("expected source field name: " + destinationField.getName() + " but was: " + sourceField.getName())));
        }
        ComparisonResult subFieldsResult = BigQueryUtil.fieldListWritable(sourceField.getSubFields(), destinationField.getSubFields(), enableModeCheckForSchemaFields);
        if (!subFieldsResult.valuesAreEqual()) {
            return ComparisonResult.differentWithDescription((List<String>)ImmutableList.of((Object)("Subfields mismatch for: " + destinationField.getName()), (Object)subFieldsResult.makeMessage()));
        }
        if (!BigQueryUtil.typeWriteable(sourceField.getType(), destinationField.getType())) {
            return ComparisonResult.differentWithDescription((List<String>)ImmutableList.of((Object)("Incompatible type for field: " + destinationField.getName()), (Object)("cannot write source type: " + sourceField.getType() + " to destination type: " + destinationField.getType())));
        }
        if (enableModeCheckForSchemaFields && !BigQueryUtil.isModeWritable(BigQueryUtil.nullableIfNull(sourceField.getMode()), BigQueryUtil.nullableIfNull(destinationField.getMode()))) {
            return ComparisonResult.differentWithDescription((List<String>)ImmutableList.of((Object)("Incompatible mode for field: " + destinationField.getName()), (Object)("cannot write source field mode: " + BigQueryUtil.nullableIfNull(sourceField.getMode()).name() + " to destination field mode: " + BigQueryUtil.nullableIfNull(destinationField.getMode()).name())));
        }
        boolean sourceAndDestMaxLengthNull = sourceField.getMaxLength() == null && destinationField.getMaxLength() == null;
        boolean bl = sourceMaxLenLessThanEqualsDestMaxLen = sourceField.getMaxLength() != null && destinationField.getMaxLength() != null && sourceField.getMaxLength() <= destinationField.getMaxLength();
        if (!sourceAndDestMaxLengthNull && !sourceMaxLenLessThanEqualsDestMaxLen) {
            return ComparisonResult.differentWithDescription((List<String>)ImmutableList.of((Object)("Incompatible max length for field: " + destinationField.getName()), (Object)("cannot write source field with max length: " + sourceField.getMaxLength() + " to destination field with max length: " + destinationField.getMaxLength())));
        }
        boolean sourceScaleLessThanEqualsDestScale = sourceField.getScale() == destinationField.getScale() || BigQueryUtil.getScale(sourceField) <= BigQueryUtil.getScale(destinationField);
        boolean bl2 = sourcePrecisionLessThanEqualsDestPrecision = sourceField.getPrecision() == destinationField.getPrecision() || BigQueryUtil.getPrecision(sourceField) <= BigQueryUtil.getPrecision(destinationField);
        if (!sourceScaleLessThanEqualsDestScale || !sourcePrecisionLessThanEqualsDestPrecision) {
            return ComparisonResult.differentWithDescription((List<String>)ImmutableList.of((Object)("Incompatible precision, scale for field: " + destinationField.getName()), (Object)("cannot write source field with precision, scale: " + BigQueryUtil.formatPrecisionAndScale(sourceField) + " to destination field with precision, scale: " + BigQueryUtil.formatPrecisionAndScale(destinationField))));
        }
        return ComparisonResult.equal();
    }

    private static String formatPrecisionAndScale(Field field) {
        return String.format("(%s, %s)", field.getPrecision(), field.getScale());
    }

    @VisibleForTesting
    static boolean typeWriteable(LegacySQLTypeName sourceType, LegacySQLTypeName destinationType) {
        return sourceType.equals((Object)LegacySQLTypeName.NUMERIC) && destinationType.equals((Object)LegacySQLTypeName.BIGNUMERIC) || sourceType.equals((Object)LegacySQLTypeName.STRING) && destinationType.equals((Object)LegacySQLTypeName.TIME) || sourceType.equals((Object)LegacySQLTypeName.STRING) && destinationType.equals((Object)LegacySQLTypeName.DATETIME) || sourceType.equals((Object)destinationType);
    }

    @VisibleForTesting
    static int getPrecision(Field field) {
        return BigQueryUtil.getValueOrDefault(field.getPrecision(), field.getType(), 38, 76);
    }

    @VisibleForTesting
    static int getScale(Field field) {
        return BigQueryUtil.getValueOrDefault(field.getScale(), field.getType(), 9, 38);
    }

    private static int getValueOrDefault(Long value, LegacySQLTypeName type, int numericValue, int bigNumericValue) {
        if (value != null) {
            return value.intValue();
        }
        if (LegacySQLTypeName.NUMERIC.equals((Object)type)) {
            return numericValue;
        }
        if (LegacySQLTypeName.BIGNUMERIC.equals((Object)type)) {
            return bigNumericValue;
        }
        return -1;
    }

    @VisibleForTesting
    static boolean isModeWritable(Field.Mode sourceMode, Field.Mode destinationMode) {
        switch (destinationMode) {
            case REPEATED: {
                return sourceMode == Field.Mode.REPEATED;
            }
            case REQUIRED: 
            case NULLABLE: {
                return sourceMode != Field.Mode.REPEATED;
            }
        }
        return false;
    }

    @VisibleForTesting
    static ComparisonResult fieldListWritable(FieldList sourceFieldList, FieldList destinationFieldList, boolean enableModeCheckForSchemaFields) {
        if (sourceFieldList == destinationFieldList) {
            return ComparisonResult.equal();
        }
        if (sourceFieldList == null || destinationFieldList == null) {
            return ComparisonResult.differentNoDescription();
        }
        if (sourceFieldList.size() > destinationFieldList.size()) {
            return ComparisonResult.differentWithDescription((List<String>)ImmutableList.of((Object)("Number of source fields: " + sourceFieldList.size() + " is larger than number of destination fields: " + destinationFieldList.size())));
        }
        Map sourceFieldsMap = sourceFieldList.stream().collect(Collectors.toMap(Field::getName, Function.identity()));
        Map destinationFieldsMap = destinationFieldList.stream().collect(Collectors.toMap(Field::getName, Function.identity()));
        for (Map.Entry e : destinationFieldsMap.entrySet()) {
            Field f2;
            Field f1 = (Field)sourceFieldsMap.get(e.getKey());
            ComparisonResult result = BigQueryUtil.fieldWritable(f1, f2 = (Field)e.getValue(), enableModeCheckForSchemaFields);
            if (result.valuesAreEqual()) continue;
            return result;
        }
        return ComparisonResult.equal();
    }

    static Field.Mode nullableIfNull(Field.Mode mode) {
        return mode == null ? Field.Mode.NULLABLE : mode;
    }

    public static Optional<String> emptyIfNeeded(String value) {
        return value == null || value.length() == 0 ? Optional.empty() : Optional.of(value);
    }

    public static <T> T createVerifiedInstance(String fullyQualifiedClassName, Class<T> requiredClass, Object ... constructorArgs) {
        try {
            Class<?> clazz = Class.forName(fullyQualifiedClassName);
            Object result = clazz.getDeclaredConstructor((Class[])Arrays.stream(constructorArgs).map(Object::getClass).toArray(Class[]::new)).newInstance(constructorArgs);
            if (!requiredClass.isInstance(result)) {
                throw new IllegalArgumentException(String.format("% does not implement %s", clazz.getCanonicalName(), requiredClass.getCanonicalName()));
            }
            return (T)result;
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new IllegalArgumentException(String.format("Could not instantiate class [%s], implementing %s", fullyQualifiedClassName, requiredClass.getCanonicalName()), e);
        }
    }

    public static <T> T verifySerialization(T obj) {
        try {
            ByteArrayOutputStream buffer = new ByteArrayOutputStream();
            ObjectOutputStream out = new ObjectOutputStream(buffer);
            out.writeObject(obj);
            out.flush();
            out.close();
            ObjectInputStream in = new ObjectInputStream(new ByteArrayInputStream(buffer.toByteArray()));
            Object result = in.readObject();
            in.close();
            return (T)result;
        }
        catch (IOException | ClassNotFoundException e) {
            throw new IllegalArgumentException("Serialization test of " + obj.getClass().getCanonicalName() + " failed", e);
        }
    }

    public static ImmutableList<String> getPartitionFields(TableInfo tableInfo) {
        List fields;
        ExternalTableDefinition edt;
        HivePartitioningOptions hivePartitioningOptions;
        TableDefinition definition = tableInfo.getDefinition();
        if (definition instanceof StandardTableDefinition) {
            StandardTableDefinition sdt = (StandardTableDefinition)definition;
            TimePartitioning timePartitioning = sdt.getTimePartitioning();
            if (timePartitioning != null) {
                if (timePartitioning.getField() == null) {
                    ArrayList<String> timePartitionFields = new ArrayList<String>();
                    timePartitionFields.add("_PARTITIONTIME");
                    if (timePartitioning.getType().equals((Object)TimePartitioning.Type.DAY)) {
                        timePartitionFields.add("_PARTITIONDATE");
                    }
                    return ImmutableList.copyOf(timePartitionFields);
                }
                return ImmutableList.of((Object)timePartitioning.getField());
            }
            RangePartitioning rangePartitioning = sdt.getRangePartitioning();
            if (rangePartitioning != null) {
                return ImmutableList.of((Object)rangePartitioning.getField());
            }
        }
        if (definition instanceof ExternalTableDefinition && (hivePartitioningOptions = (edt = (ExternalTableDefinition)definition).getHivePartitioningOptions()) != null && (fields = hivePartitioningOptions.getFields()) != null && !fields.isEmpty()) {
            return ImmutableList.copyOf((Collection)fields);
        }
        return ImmutableList.of();
    }

    public static ImmutableList<String> getClusteringFields(TableInfo tableInfo) {
        TableDefinition definition = tableInfo.getDefinition();
        if (!(definition instanceof StandardTableDefinition)) {
            return ImmutableList.of();
        }
        Clustering clustering = ((StandardTableDefinition)definition).getClustering();
        if (clustering == null || clustering.getFields() == null) {
            return ImmutableList.of();
        }
        return ImmutableList.copyOf((Collection)clustering.getFields());
    }

    public static boolean filterLengthInLimit(Optional<String> filter) {
        return filter.map(f -> f.getBytes(StandardCharsets.UTF_8).length < 0x200000).orElse(Boolean.TRUE);
    }

    public static Schema adjustSchemaIfNeeded(Schema wantedSchema, Schema existingTableSchema, boolean allowFieldRelaxation) {
        FieldList fields = wantedSchema.getFields();
        FieldList existingFields = existingTableSchema.getFields();
        Map existingFieldsMap = existingFields.stream().collect(Collectors.toMap(Field::getName, Function.identity()));
        List adjustedFields = fields.stream().map(field -> BigQueryUtil.adjustField(field, (Field)existingFieldsMap.get(field.getName()), allowFieldRelaxation)).collect(Collectors.toList());
        return Schema.of(adjustedFields);
    }

    @VisibleForTesting
    static Field adjustField(Field field, @Nullable Field existingField, boolean allowFieldRelaxation) {
        Field.Mode fieldMode;
        if (existingField == null) {
            return field;
        }
        Field.Mode mode = fieldMode = existingField.getMode() != null ? existingField.getMode() : Field.Mode.NULLABLE;
        if (allowFieldRelaxation && field.getMode() == Field.Mode.NULLABLE) {
            fieldMode = Field.Mode.NULLABLE;
        }
        if (field.getType().equals((Object)LegacySQLTypeName.RECORD) && existingField.getType().equals((Object)LegacySQLTypeName.RECORD)) {
            FieldList subFields = field.getSubFields();
            FieldList exitingSubFields = existingField.getSubFields();
            Map existingSubFieldsMap = exitingSubFields.stream().collect(Collectors.toMap(Field::getName, Function.identity()));
            FieldList adjustedSubFields = FieldList.of((Iterable)subFields.stream().map(subField -> BigQueryUtil.adjustField(subField, (Field)existingSubFieldsMap.get(subField.getName()), allowFieldRelaxation)).collect(Collectors.toList()));
            return existingField.toBuilder().setType(LegacySQLTypeName.RECORD, adjustedSubFields).build();
        }
        return existingField.toBuilder().setMode(fieldMode).build();
    }

    public static String prepareQueryForLog(String query, int maxLength) {
        String noNewLinesQuery = query.replace("\n", "\\n");
        return noNewLinesQuery.length() > maxLength ? noNewLinesQuery.substring(0, maxLength) + '\u2026' : noNewLinesQuery;
    }

    static String getQueryForTimePartitionedTable(String destinationTableName, String temporaryTableName, StandardTableDefinition destinationDefinition, TimePartitioning timePartitioning) {
        TimePartitioning.Type partitionType = timePartitioning.getType();
        String partitionField = timePartitioning.getField();
        FieldList allFields = destinationDefinition.getSchema().getFields();
        Optional<LegacySQLTypeName> partitionFieldType = allFields.stream().filter(field -> partitionField.equals(field.getName())).map(field -> field.getType()).findFirst();
        String truncFuntion = partitionFieldType.isPresent() && partitionFieldType.get().equals((Object)LegacySQLTypeName.DATE) ? "date_trunc" : "timestamp_trunc";
        String extractedPartitionedSource = String.format("%s(`%s`, %s)", truncFuntion, partitionField, partitionType.toString());
        String extractedPartitionedTarget = String.format("%s(`target`.`%s`, %s)", truncFuntion, partitionField, partitionType.toString());
        String commaSeparatedFields = allFields.stream().map(Field::getName).collect(Collectors.joining("`,`", "`", "`"));
        String queryFormat = "DECLARE partitions_to_delete DEFAULT (SELECT ARRAY_AGG(DISTINCT(%s) IGNORE NULLS) FROM `%s`); \nMERGE `%s` AS target\nUSING `%s` AS source\nON FALSE\nWHEN NOT MATCHED BY SOURCE AND %s IN UNNEST(partitions_to_delete) THEN DELETE\nWHEN NOT MATCHED BY TARGET THEN\nINSERT(%s) VALUES(%s)";
        return String.format(queryFormat, extractedPartitionedSource, temporaryTableName, destinationTableName, temporaryTableName, extractedPartitionedTarget, commaSeparatedFields, commaSeparatedFields);
    }

    static String getQueryForRangePartitionedTable(String destinationTableName, String temporaryTableName, StandardTableDefinition destinationDefinition, RangePartitioning rangePartitioning) {
        long start = rangePartitioning.getRange().getStart();
        long end = rangePartitioning.getRange().getEnd();
        long interval = rangePartitioning.getRange().getInterval();
        String partitionField = rangePartitioning.getField();
        String extractedPartitioned = "IFNULL(IF(%s.%s >= %s, 0, RANGE_BUCKET(%s.%s, GENERATE_ARRAY(%s, %s, %s))), -1)";
        String extractedPartitionedSource = String.format(extractedPartitioned, "source", partitionField, end, "source", partitionField, start, end, interval);
        String extractedPartitionedTarget = String.format(extractedPartitioned, "target", partitionField, end, "target", partitionField, start, end, interval);
        FieldList allFields = destinationDefinition.getSchema().getFields();
        String commaSeparatedFields = allFields.stream().map(Field::getName).collect(Collectors.joining("`,`", "`", "`"));
        String booleanInjectedColumn = "_" + Long.toString(1234567890123456789L);
        String queryFormat = "MERGE `%s` AS target\nUSING (SELECT * FROM `%s` CROSS JOIN UNNEST([true, false])  %s) AS source\nON %s = %s AND %s AND (target.%s >= %d OR target.%s IS NULL )\nWHEN MATCHED THEN DELETE\nWHEN NOT MATCHED AND NOT %s THEN\nINSERT(%s) VALUES(%s)";
        return String.format(queryFormat, destinationTableName, temporaryTableName, booleanInjectedColumn, extractedPartitionedSource, extractedPartitionedTarget, booleanInjectedColumn, partitionField, Long.MIN_VALUE, partitionField, booleanInjectedColumn, commaSeparatedFields, commaSeparatedFields);
    }

    public static String sanitizeLabelValue(String value) {
        int resultLength = Math.min(value.length(), 63);
        StringBuilder buf = new StringBuilder(value.length());
        for (int i = 0; i < resultLength; ++i) {
            char ch = Character.toLowerCase(value.charAt(i));
            if (Character.isLetterOrDigit(ch) || ch == '-' || ch == '_') {
                buf.append(ch);
                continue;
            }
            buf.append('_');
        }
        return buf.toString();
    }

    public static boolean isBigLakeManagedTable(TableInfo table) {
        TableDefinition tableDefinition = table.getDefinition();
        return tableDefinition.getType() == TableDefinition.Type.TABLE && tableDefinition instanceof StandardTableDefinition && ((StandardTableDefinition)tableDefinition).getBigLakeConfiguration() != null;
    }

    public static boolean isBigQueryNativeTable(TableInfo table) {
        return table.getDefinition().getType() == TableDefinition.Type.TABLE && !BigQueryUtil.isBigLakeManagedTable(table);
    }

    public static QueryParameterHelper parseQueryParameters(Map<String, String> options) {
        HashMap<String, QueryParameterValue> namedParameters = new HashMap<String, QueryParameterValue>();
        TreeMap<Integer, QueryParameterValue> positionalParametersTemp = new TreeMap<Integer, QueryParameterValue>();
        ParameterMode currentMode = ParameterMode.NONE;
        for (Map.Entry<String, String> entry : options.entrySet()) {
            String key = entry.getKey();
            String keyLower = key.toLowerCase(Locale.ROOT);
            String value = entry.getValue();
            if (keyLower.startsWith(NAMED_PARAM_PREFIX)) {
                Preconditions.checkArgument((currentMode == ParameterMode.NAMED || currentMode == ParameterMode.NONE ? 1 : 0) != 0, (Object)"Cannot mix NamedParameters.* and PositionalParameters.* options.");
                currentMode = ParameterMode.NAMED;
                BigQueryUtil.processNamedParameter(key, value, namedParameters);
                continue;
            }
            if (!keyLower.startsWith(POSITIONAL_PARAM_PREFIX)) continue;
            Preconditions.checkArgument((currentMode == ParameterMode.POSITIONAL || currentMode == ParameterMode.NONE ? 1 : 0) != 0, (Object)"Cannot mix NamedParameters.* and PositionalParameters.* options.");
            currentMode = ParameterMode.POSITIONAL;
            BigQueryUtil.processPositionalParameter(key, value, positionalParametersTemp);
        }
        switch (currentMode) {
            case NAMED: {
                return QueryParameterHelper.named(namedParameters);
            }
            case POSITIONAL: {
                List<QueryParameterValue> positionalList = BigQueryUtil.buildPositionalParameterList(positionalParametersTemp);
                return QueryParameterHelper.positional(positionalList);
            }
        }
        return QueryParameterHelper.none();
    }

    private static void processNamedParameter(String key, String value, Map<String, QueryParameterValue> namedParams) {
        String paramName = key.substring(NAMED_PARAM_PREFIX.length());
        Preconditions.checkArgument((!paramName.isEmpty() ? 1 : 0) != 0, (Object)String.format("Named parameter name cannot be empty. Option key: '%s'", key));
        QueryParameterValue qpv = BigQueryUtil.parseSingleParameterValue(paramName, value);
        Preconditions.checkArgument((!namedParams.containsKey(paramName) ? 1 : 0) != 0, (Object)String.format("Duplicate named parameter definition for '%s'. Option key: '%s'", paramName, key));
        namedParams.put(paramName, qpv);
    }

    private static void processPositionalParameter(String key, String value, Map<Integer, QueryParameterValue> positionalParamsTemp) {
        int index;
        String indexStr = key.substring(POSITIONAL_PARAM_PREFIX.length());
        Preconditions.checkArgument((!indexStr.isEmpty() ? 1 : 0) != 0, (Object)String.format("Positional parameter index cannot be empty. Option key: '%s'", key));
        try {
            index = Integer.parseInt(indexStr);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException(String.format("Invalid positional parameter index: '%s' must be an integer. Option key: '%s'", indexStr, key), e);
        }
        Preconditions.checkArgument((index >= 1 ? 1 : 0) != 0, (Object)String.format("Invalid positional parameter index: %d. Indices must be 1-based. Option key: '%s'", index, key));
        QueryParameterValue qpv = BigQueryUtil.parseSingleParameterValue(String.valueOf(index), value);
        Preconditions.checkArgument((!positionalParamsTemp.containsKey(index) ? 1 : 0) != 0, (Object)String.format("Duplicate positional parameter definition for index: %d. Option key: '%s'", index, key));
        positionalParamsTemp.put(index, qpv);
    }

    private static List<QueryParameterValue> buildPositionalParameterList(Map<Integer, QueryParameterValue> positionalParamsTemp) {
        ArrayList<QueryParameterValue> positionalList = new ArrayList<QueryParameterValue>();
        int maxIndex = (Integer)((TreeMap)positionalParamsTemp).lastKey();
        for (int i = 1; i <= maxIndex; ++i) {
            QueryParameterValue currentParam = positionalParamsTemp.get(i);
            Preconditions.checkNotNull((Object)currentParam, (Object)String.format("Missing positional parameter for index: %d. Parameters must be contiguous starting from 1.", i));
            positionalList.add(currentParam);
        }
        return positionalList;
    }

    private static QueryParameterValue parseSingleParameterValue(String identifier, String typeValueString) {
        StandardSQLTypeName type;
        Preconditions.checkNotNull((Object)typeValueString, (Object)String.format("Parameter value string cannot be null for identifier: %s", identifier));
        int colonIndex = typeValueString.indexOf(58);
        Preconditions.checkArgument((colonIndex > 0 ? 1 : 0) != 0, (Object)String.format("Invalid parameter value format for identifier '%s': '%s'. Expected 'TYPE:value' with non-empty TYPE before ':'.", identifier, typeValueString));
        String typeStr = typeValueString.substring(0, colonIndex).trim().toUpperCase(Locale.ROOT);
        String valueStr = typeValueString.substring(colonIndex + 1);
        try {
            type = StandardSQLTypeName.valueOf((String)typeStr);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException(String.format("Unknown query parameter type: '%s' for identifier: '%s'. Supported types: %s", typeStr, identifier, Arrays.stream(StandardSQLTypeName.values()).map(Enum::name).collect(Collectors.joining(", "))), e);
        }
        Preconditions.checkArgument((type != StandardSQLTypeName.ARRAY && type != StandardSQLTypeName.STRUCT ? 1 : 0) != 0, (Object)String.format("Unsupported query parameter type: %s for identifier: '%s'. ARRAY and STRUCT types are not currently supported as query parameters.", type, identifier));
        return QueryParameterValue.newBuilder().setValue(valueStr.trim()).setType(type).build();
    }

    public static String[] formatTableResult(TableResult result, boolean withHeader) {
        ArrayList<String> resultList = new ArrayList<String>();
        Schema schema = result.getSchema();
        if (schema == null) {
            return new String[0];
        }
        FieldList fields = schema.getFields();
        if (withHeader) {
            resultList.add(fields.stream().map(Field::getName).collect(Collectors.joining("\t")));
        }
        for (FieldValueList row : result.iterateAll()) {
            String formattedRow = fields.stream().map(field -> row.get(field.getName())).map(BigQueryUtil::fieldValueToString).collect(Collectors.joining("\t"));
            resultList.add(formattedRow);
        }
        return resultList.toArray(new String[0]);
    }

    private static String fieldValueToString(FieldValue fieldValue) {
        if (null == fieldValue || fieldValue.isNull()) {
            return "NULL";
        }
        return String.valueOf(fieldValue.getValue());
    }
}

