/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.opentelemetry.resource;

import com.google.auto.value.AutoValue;
import com.google.cloud.opentelemetry.resource.AutoValue_ResourceTranslator_AttributeMapping;
import com.google.cloud.opentelemetry.resource.GcpResource;
import com.google.cloud.opentelemetry.shadow.semconv.ServiceAttributes;
import com.google.cloud.opentelemetry.shadow.semconv.incubating.CloudIncubatingAttributes;
import com.google.cloud.opentelemetry.shadow.semconv.incubating.FaasIncubatingAttributes;
import com.google.cloud.opentelemetry.shadow.semconv.incubating.HostIncubatingAttributes;
import com.google.cloud.opentelemetry.shadow.semconv.incubating.K8sIncubatingAttributes;
import com.google.cloud.opentelemetry.shadow.semconv.incubating.ServiceIncubatingAttributes;
import io.opentelemetry.api.common.AttributeKey;
import io.opentelemetry.sdk.resources.Resource;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class ResourceTranslator {
    private static final String UNKNOWN_SERVICE_PREFIX = "unknown_service";
    private static final List<AttributeMapping> GCE_INSTANCE_LABELS = Arrays.asList(AttributeMapping.create("zone", CloudIncubatingAttributes.CLOUD_AVAILABILITY_ZONE), AttributeMapping.create("instance_id", HostIncubatingAttributes.HOST_ID));
    private static final List<AttributeMapping> K8S_CONTAINER_LABELS = Arrays.asList(AttributeMapping.create("location", Arrays.asList(CloudIncubatingAttributes.CLOUD_AVAILABILITY_ZONE, CloudIncubatingAttributes.CLOUD_REGION)), AttributeMapping.create("cluster_name", K8sIncubatingAttributes.K8S_CLUSTER_NAME), AttributeMapping.create("namespace_name", K8sIncubatingAttributes.K8S_NAMESPACE_NAME), AttributeMapping.create("container_name", K8sIncubatingAttributes.K8S_CONTAINER_NAME), AttributeMapping.create("pod_name", K8sIncubatingAttributes.K8S_POD_NAME));
    private static final List<AttributeMapping> K8S_POD_LABELS = Arrays.asList(AttributeMapping.create("location", Arrays.asList(CloudIncubatingAttributes.CLOUD_AVAILABILITY_ZONE, CloudIncubatingAttributes.CLOUD_REGION)), AttributeMapping.create("cluster_name", K8sIncubatingAttributes.K8S_CLUSTER_NAME), AttributeMapping.create("namespace_name", K8sIncubatingAttributes.K8S_NAMESPACE_NAME), AttributeMapping.create("pod_name", K8sIncubatingAttributes.K8S_POD_NAME));
    private static final List<AttributeMapping> K8S_NODE_LABELS = Arrays.asList(AttributeMapping.create("location", Arrays.asList(CloudIncubatingAttributes.CLOUD_AVAILABILITY_ZONE, CloudIncubatingAttributes.CLOUD_REGION)), AttributeMapping.create("cluster_name", K8sIncubatingAttributes.K8S_CLUSTER_NAME), AttributeMapping.create("node_name", K8sIncubatingAttributes.K8S_NODE_NAME));
    private static final List<AttributeMapping> K8S_CLUSTER_LABELS = Arrays.asList(AttributeMapping.create("location", Arrays.asList(CloudIncubatingAttributes.CLOUD_AVAILABILITY_ZONE, CloudIncubatingAttributes.CLOUD_REGION)), AttributeMapping.create("cluster_name", K8sIncubatingAttributes.K8S_CLUSTER_NAME));
    private static final List<AttributeMapping> AWS_EC2_INSTANCE_LABELS = Arrays.asList(AttributeMapping.create("instance_id", HostIncubatingAttributes.HOST_ID), AttributeMapping.create("region", CloudIncubatingAttributes.CLOUD_AVAILABILITY_ZONE), AttributeMapping.create("aws_account", CloudIncubatingAttributes.CLOUD_ACCOUNT_ID));
    private static final List<AttributeMapping> GOOGLE_CLOUD_APP_ENGINE_INSTANCE_LABELS = Arrays.asList(AttributeMapping.create("module_id", FaasIncubatingAttributes.FAAS_NAME), AttributeMapping.create("version_id", FaasIncubatingAttributes.FAAS_VERSION), AttributeMapping.create("instance_id", FaasIncubatingAttributes.FAAS_INSTANCE), AttributeMapping.create("location", CloudIncubatingAttributes.CLOUD_REGION));
    private static final List<AttributeMapping> GENERIC_TASK_LABELS = Arrays.asList(AttributeMapping.create("location", Arrays.asList(CloudIncubatingAttributes.CLOUD_AVAILABILITY_ZONE, CloudIncubatingAttributes.CLOUD_REGION), "global"), AttributeMapping.create("namespace", ServiceIncubatingAttributes.SERVICE_NAMESPACE, ""), AttributeMapping.create("job", Arrays.asList(ServiceAttributes.SERVICE_NAME, FaasIncubatingAttributes.FAAS_NAME), ""), AttributeMapping.create("task_id", Arrays.asList(ServiceIncubatingAttributes.SERVICE_INSTANCE_ID, FaasIncubatingAttributes.FAAS_INSTANCE), ""));
    private static final List<AttributeMapping> GENERIC_NODE_LABELS = Arrays.asList(AttributeMapping.create("location", Arrays.asList(CloudIncubatingAttributes.CLOUD_AVAILABILITY_ZONE, CloudIncubatingAttributes.CLOUD_REGION), "global"), AttributeMapping.create("namespace", ServiceIncubatingAttributes.SERVICE_NAMESPACE, ""), AttributeMapping.create("node_id", Arrays.asList(HostIncubatingAttributes.HOST_ID, HostIncubatingAttributes.HOST_NAME), ""));

    private ResourceTranslator() {
    }

    public static GcpResource mapResource(Resource resource) {
        String platform = (String)resource.getAttribute(CloudIncubatingAttributes.CLOUD_PLATFORM);
        if (platform == null) {
            return ResourceTranslator.mapK8sResourceOrGenericTaskOrNode(resource);
        }
        switch (platform) {
            case "gcp_compute_engine": {
                return ResourceTranslator.mapBase(resource, "gce_instance", GCE_INSTANCE_LABELS);
            }
            case "aws_ec2": {
                return ResourceTranslator.mapBase(resource, "aws_ec2_instance", AWS_EC2_INSTANCE_LABELS);
            }
            case "gcp_app_engine": {
                return ResourceTranslator.mapBase(resource, "gae_instance", GOOGLE_CLOUD_APP_ENGINE_INSTANCE_LABELS);
            }
        }
        return ResourceTranslator.mapK8sResourceOrGenericTaskOrNode(resource);
    }

    private static GcpResource mapK8sResourceOrGenericTaskOrNode(Resource resource) {
        if (resource.getAttribute(K8sIncubatingAttributes.K8S_CLUSTER_NAME) != null) {
            if (resource.getAttribute(K8sIncubatingAttributes.K8S_CONTAINER_NAME) != null) {
                return ResourceTranslator.mapBase(resource, "k8s_container", K8S_CONTAINER_LABELS);
            }
            if (resource.getAttribute(K8sIncubatingAttributes.K8S_POD_NAME) != null) {
                return ResourceTranslator.mapBase(resource, "k8s_pod", K8S_POD_LABELS);
            }
            if (resource.getAttribute(K8sIncubatingAttributes.K8S_NODE_NAME) != null) {
                return ResourceTranslator.mapBase(resource, "k8s_node", K8S_NODE_LABELS);
            }
            return ResourceTranslator.mapBase(resource, "k8s_cluster", K8S_CLUSTER_LABELS);
        }
        return ResourceTranslator.genericTaskOrNode(resource);
    }

    private static GcpResource genericTaskOrNode(Resource resource) {
        Map attrMap = resource.getAttributes().asMap();
        if ((attrMap.containsKey(ServiceAttributes.SERVICE_NAME) || attrMap.containsKey(FaasIncubatingAttributes.FAAS_NAME)) && (attrMap.containsKey(ServiceIncubatingAttributes.SERVICE_INSTANCE_ID) || attrMap.containsKey(FaasIncubatingAttributes.FAAS_INSTANCE))) {
            return ResourceTranslator.mapBase(resource, "generic_task", GENERIC_TASK_LABELS);
        }
        return ResourceTranslator.mapBase(resource, "generic_node", GENERIC_NODE_LABELS);
    }

    private static GcpResource mapBase(Resource resource, String mrType, List<AttributeMapping> mappings) {
        GcpResource.Builder mr = GcpResource.builder();
        mr.setResourceType(mrType);
        for (AttributeMapping mapping : mappings) {
            mapping.fill(resource, mr);
        }
        return mr.build();
    }

    @AutoValue
    public static abstract class AttributeMapping {
        public abstract String getLabelName();

        public abstract List<AttributeKey<?>> getOtelKeys();

        public abstract Optional<String> fallbackLiteral();

        public void fill(Resource resource, GcpResource.Builder builder) {
            for (AttributeKey<?> key : this.getOtelKeys()) {
                Object value2 = resource.getAttribute(key);
                if (value2 == null) continue;
                String stringValue = value2.toString();
                if (key.equals(ServiceAttributes.SERVICE_NAME) && stringValue.startsWith(ResourceTranslator.UNKNOWN_SERVICE_PREFIX)) continue;
                builder.addResourceLabels(this.getLabelName(), stringValue);
                return;
            }
            if (this.getOtelKeys().contains(ServiceAttributes.SERVICE_NAME) && Objects.nonNull(resource.getAttribute(ServiceAttributes.SERVICE_NAME))) {
                builder.addResourceLabels(this.getLabelName(), (String)resource.getAttribute(ServiceAttributes.SERVICE_NAME));
                return;
            }
            this.fallbackLiteral().ifPresent(value -> builder.addResourceLabels(this.getLabelName(), (String)value));
        }

        public static AttributeMapping create(String labelName, AttributeKey<?> otelKey) {
            return new AutoValue_ResourceTranslator_AttributeMapping(labelName, Collections.singletonList(otelKey), Optional.empty());
        }

        public static AttributeMapping create(String labelName, AttributeKey<?> otelKey, String fallbackLiteral) {
            return new AutoValue_ResourceTranslator_AttributeMapping(labelName, Collections.singletonList(otelKey), Optional.of(fallbackLiteral));
        }

        public static AttributeMapping create(String labelName, List<AttributeKey<?>> otelKeys) {
            return new AutoValue_ResourceTranslator_AttributeMapping(labelName, otelKeys, Optional.empty());
        }

        public static AttributeMapping create(String labelName, List<AttributeKey<?>> otelKeys, String fallbackLiteral) {
            return new AutoValue_ResourceTranslator_AttributeMapping(labelName, otelKeys, Optional.of(fallbackLiteral));
        }
    }
}

