/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.opentelemetry.trace;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.devtools.cloudtrace.v2.AttributeValue;
import com.google.devtools.cloudtrace.v2.Span;
import com.google.devtools.cloudtrace.v2.SpanName;
import com.google.devtools.cloudtrace.v2.TruncatableString;
import com.google.protobuf.BoolValue;
import com.google.protobuf.Timestamp;
import com.google.rpc.Status;
import io.opentelemetry.common.ReadableAttributes;
import io.opentelemetry.sdk.trace.data.SpanData;
import io.opentelemetry.trace.Span;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;

class TraceTranslator {
    private static final String OPEN_TELEMETRY_LIBRARY_VERSION = "0.6.0";
    private static final String EXPORTER_VERSION = "0.1.0";
    private static final String AGENT_LABEL_KEY = "g.co/agent";
    private static final String AGENT_LABEL_VALUE_STRING = "opentelemetry-java 0.6.0; google-cloud-trace-exporter 0.1.0";
    private static final AttributeValue AGENT_LABEL_VALUE = AttributeValue.newBuilder().setStringValue(TraceTranslator.toTruncatableStringProto("opentelemetry-java 0.6.0; google-cloud-trace-exporter 0.1.0")).build();
    private static final String SERVER_PREFIX = "Recv.";
    private static final String CLIENT_PREFIX = "Sent.";
    private static final ImmutableMap<String, String> HTTP_ATTRIBUTE_MAPPING = ImmutableMap.builder().put((Object)"http.host", (Object)"/http/host").put((Object)"http.method", (Object)"/http/method").put((Object)"http.path", (Object)"/http/path").put((Object)"http.route", (Object)"/http/route").put((Object)"http.user_agent", (Object)"/http/user_agent").put((Object)"http.status_code", (Object)"/http/status_code").build();

    @VisibleForTesting
    static Span generateSpan(SpanData spanData, String projectId, Map<String, AttributeValue> constAttributes) {
        Boolean hasRemoteParent;
        long end;
        String traceIdHex = spanData.getTraceId().toLowerBase16();
        String spanIdHex = spanData.getSpanId().toLowerBase16();
        SpanName spanName = SpanName.newBuilder().setProject(projectId).setTrace(traceIdHex).setSpan(spanIdHex).build();
        Span.Builder spanBuilder = Span.newBuilder().setName(spanName.toString()).setSpanId(spanIdHex).setDisplayName(TraceTranslator.toTruncatableStringProto(TraceTranslator.toDisplayName(spanData.getName(), spanData.getKind()))).setStartTime(TraceTranslator.toTimestampProto(spanData.getStartEpochNanos())).setAttributes(TraceTranslator.toAttributesProto(spanData.getAttributes(), constAttributes)).setTimeEvents(TraceTranslator.toTimeEventsProto(spanData.getEvents()));
        io.opentelemetry.trace.Status status = spanData.getStatus();
        if (status != null) {
            spanBuilder.setStatus(TraceTranslator.toStatusProto(status));
        }
        if ((end = spanData.getEndEpochNanos()) != 0L) {
            spanBuilder.setEndTime(TraceTranslator.toTimestampProto(end));
        }
        spanBuilder.setLinks(TraceTranslator.toLinksProto(spanData.getLinks(), spanData.getTotalRecordedLinks()));
        if (spanData.getParentSpanId() != null && spanData.getParentSpanId().isValid()) {
            spanBuilder.setParentSpanId(spanData.getParentSpanId().toLowerBase16());
        }
        if ((hasRemoteParent = Boolean.valueOf(spanData.getHasRemoteParent())) != null) {
            spanBuilder.setSameProcessAsParentSpan(BoolValue.of((hasRemoteParent == false ? 1 : 0) != 0));
        }
        return spanBuilder.build();
    }

    @VisibleForTesting
    static String toDisplayName(String spanName, @Nullable Span.Kind spanKind) {
        if (spanKind == Span.Kind.SERVER && !spanName.startsWith(SERVER_PREFIX)) {
            String string = String.valueOf(SERVER_PREFIX);
            String string2 = String.valueOf(spanName);
            return string2.length() != 0 ? string.concat(string2) : new String(string);
        }
        if (spanKind == Span.Kind.CLIENT && !spanName.startsWith(CLIENT_PREFIX)) {
            String string = String.valueOf(CLIENT_PREFIX);
            String string3 = String.valueOf(spanName);
            return string3.length() != 0 ? string.concat(string3) : new String(string);
        }
        return spanName;
    }

    @VisibleForTesting
    static TruncatableString toTruncatableStringProto(String string) {
        return TruncatableString.newBuilder().setValue(string).setTruncatedByteCount(0).build();
    }

    @VisibleForTesting
    static Timestamp toTimestampProto(long epochNanos) {
        long seconds = TimeUnit.NANOSECONDS.toSeconds(epochNanos);
        int nanos = (int)(epochNanos - TimeUnit.SECONDS.toNanos(seconds));
        return Timestamp.newBuilder().setSeconds(seconds).setNanos(nanos).build();
    }

    @VisibleForTesting
    static Span.Attributes toAttributesProto(ReadableAttributes attributes, Map<String, AttributeValue> fixedAttributes) {
        Span.Attributes.Builder attributesBuilder = TraceTranslator.toAttributesBuilderProto(attributes);
        attributesBuilder.putAttributeMap(AGENT_LABEL_KEY, AGENT_LABEL_VALUE);
        for (Map.Entry<String, AttributeValue> entry : fixedAttributes.entrySet()) {
            attributesBuilder.putAttributeMap(entry.getKey(), entry.getValue());
        }
        return attributesBuilder.build();
    }

    private static Span.Attributes toAttributesProto(ReadableAttributes attributes) {
        return TraceTranslator.toAttributesProto(attributes, (Map<String, AttributeValue>)ImmutableMap.of());
    }

    private static Span.Attributes.Builder toAttributesBuilderProto(ReadableAttributes attributes) {
        Span.Attributes.Builder attributesBuilder = Span.Attributes.newBuilder().setDroppedAttributesCount(0);
        attributes.forEach((key, value) -> {
            AttributeValue attributeValue = TraceTranslator.toAttributeValueProto(value);
            attributesBuilder.putAttributeMap(TraceTranslator.mapKey(key), attributeValue);
        });
        return attributesBuilder;
    }

    private static AttributeValue toAttributeValueProto(io.opentelemetry.common.AttributeValue attributeValue) {
        AttributeValue.Builder builder = AttributeValue.newBuilder();
        switch (attributeValue.getType()) {
            case STRING: {
                builder.setStringValue(TraceTranslator.toTruncatableStringProto(attributeValue.getStringValue()));
                break;
            }
            case BOOLEAN: {
                builder.setBoolValue(attributeValue.getBooleanValue());
                break;
            }
            case LONG: {
                builder.setIntValue(attributeValue.getLongValue());
                break;
            }
            case DOUBLE: {
                builder.setStringValue(TraceTranslator.toTruncatableStringProto(String.valueOf(attributeValue.getDoubleValue())));
            }
        }
        return builder.build();
    }

    private static String mapKey(String key) {
        if (HTTP_ATTRIBUTE_MAPPING.containsKey((Object)key)) {
            return (String)HTTP_ATTRIBUTE_MAPPING.get((Object)key);
        }
        return key;
    }

    @VisibleForTesting
    static Span.TimeEvents toTimeEventsProto(List<SpanData.Event> events) {
        Span.TimeEvents.Builder timeEventsBuilder = Span.TimeEvents.newBuilder();
        for (SpanData.Event event : events) {
            timeEventsBuilder.addTimeEvent(Span.TimeEvent.newBuilder().setTime(TraceTranslator.toTimestampProto(event.getEpochNanos())).setAnnotation(Span.TimeEvent.Annotation.newBuilder().setDescription(TraceTranslator.toTruncatableStringProto(event.getName())).setAttributes(TraceTranslator.toAttributesProto((ReadableAttributes)event.getAttributes()))));
        }
        return timeEventsBuilder.build();
    }

    @VisibleForTesting
    static Status toStatusProto(io.opentelemetry.trace.Status status) {
        Status.Builder statusBuilder = Status.newBuilder().setCode(status.getCanonicalCode().value());
        if (status.getDescription() != null) {
            statusBuilder.setMessage(status.getDescription());
        }
        return statusBuilder.build();
    }

    @VisibleForTesting
    static Span.Links toLinksProto(List<SpanData.Link> links, int totalRecordedLinks) {
        Span.Links.Builder linksBuilder = Span.Links.newBuilder().setDroppedLinksCount(Math.max(0, totalRecordedLinks - links.size()));
        for (SpanData.Link link : links) {
            linksBuilder.addLink(TraceTranslator.toLinkProto(link));
        }
        return linksBuilder.build();
    }

    private static Span.Link toLinkProto(SpanData.Link link) {
        Preconditions.checkNotNull((Object)link);
        return Span.Link.newBuilder().setTraceId(link.getContext().getTraceId().toLowerBase16()).setSpanId(link.getContext().getSpanId().toLowerBase16()).setType(Span.Link.Type.TYPE_UNSPECIFIED).setAttributes(TraceTranslator.toAttributesBuilderProto((ReadableAttributes)link.getAttributes())).build();
    }

    @VisibleForTesting
    static Map<String, AttributeValue> getResourceLabels(Map<String, String> resource) {
        if (resource == null) {
            return Collections.emptyMap();
        }
        LinkedHashMap<String, AttributeValue> resourceLabels = new LinkedHashMap<String, AttributeValue>();
        for (Map.Entry<String, String> entry : resource.entrySet()) {
            TraceTranslator.putToResourceAttributeMap(resourceLabels, entry.getKey(), entry.getValue());
        }
        return Collections.unmodifiableMap(resourceLabels);
    }

    private static void putToResourceAttributeMap(Map<String, AttributeValue> map, String attributeName, String attributeValue) {
        map.put(TraceTranslator.createResourceLabelKey(attributeName), TraceTranslator.toStringAttributeValueProto(attributeValue));
    }

    @VisibleForTesting
    static String createResourceLabelKey(String resourceAttribute) {
        String string = String.valueOf(resourceAttribute);
        return string.length() != 0 ? "g.co/r/".concat(string) : new String("g.co/r/");
    }

    @VisibleForTesting
    static AttributeValue toStringAttributeValueProto(String value) {
        return AttributeValue.newBuilder().setStringValue(TraceTranslator.toTruncatableStringProto(value)).build();
    }

    private TraceTranslator() {
    }
}

