/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.opentelemetry.trace;

import com.google.auth.Credentials;
import com.google.cloud.opentelemetry.trace.TraceConfiguration;
import com.google.cloud.trace.v2.stub.TraceServiceStub;
import com.google.devtools.cloudtrace.v2.AttributeValue;
import java.time.Duration;
import java.util.Map;
import javax.annotation.Nullable;

final class AutoValue_TraceConfiguration
extends TraceConfiguration {
    private final Credentials credentials;
    private final String projectId;
    private final TraceServiceStub traceServiceStub;
    private final Map<String, AttributeValue> fixedAttributes;
    private final Duration deadline;

    private AutoValue_TraceConfiguration(@Nullable Credentials credentials, String projectId, @Nullable TraceServiceStub traceServiceStub, Map<String, AttributeValue> fixedAttributes, Duration deadline) {
        this.credentials = credentials;
        this.projectId = projectId;
        this.traceServiceStub = traceServiceStub;
        this.fixedAttributes = fixedAttributes;
        this.deadline = deadline;
    }

    @Override
    @Nullable
    public Credentials getCredentials() {
        return this.credentials;
    }

    @Override
    public String getProjectId() {
        return this.projectId;
    }

    @Override
    @Nullable
    public TraceServiceStub getTraceServiceStub() {
        return this.traceServiceStub;
    }

    @Override
    public Map<String, AttributeValue> getFixedAttributes() {
        return this.fixedAttributes;
    }

    @Override
    public Duration getDeadline() {
        return this.deadline;
    }

    public String toString() {
        String string = String.valueOf(this.credentials);
        String string2 = this.projectId;
        String string3 = String.valueOf(this.traceServiceStub);
        String string4 = String.valueOf(this.fixedAttributes);
        String string5 = String.valueOf(this.deadline);
        return new StringBuilder(92 + String.valueOf(string).length() + String.valueOf(string2).length() + String.valueOf(string3).length() + String.valueOf(string4).length() + String.valueOf(string5).length()).append("TraceConfiguration{credentials=").append(string).append(", projectId=").append(string2).append(", traceServiceStub=").append(string3).append(", fixedAttributes=").append(string4).append(", deadline=").append(string5).append("}").toString();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof TraceConfiguration) {
            TraceConfiguration that = (TraceConfiguration)o;
            return (this.credentials == null ? that.getCredentials() == null : this.credentials.equals(that.getCredentials())) && this.projectId.equals(that.getProjectId()) && (this.traceServiceStub == null ? that.getTraceServiceStub() == null : this.traceServiceStub.equals(that.getTraceServiceStub())) && this.fixedAttributes.equals(that.getFixedAttributes()) && this.deadline.equals(that.getDeadline());
        }
        return false;
    }

    public int hashCode() {
        int h$ = 1;
        h$ *= 1000003;
        h$ ^= this.credentials == null ? 0 : this.credentials.hashCode();
        h$ *= 1000003;
        h$ ^= this.projectId.hashCode();
        h$ *= 1000003;
        h$ ^= this.traceServiceStub == null ? 0 : this.traceServiceStub.hashCode();
        h$ *= 1000003;
        h$ ^= this.fixedAttributes.hashCode();
        h$ *= 1000003;
        return h$ ^= this.deadline.hashCode();
    }

    static final class Builder
    extends TraceConfiguration.Builder {
        private Credentials credentials;
        private String projectId;
        private TraceServiceStub traceServiceStub;
        private Map<String, AttributeValue> fixedAttributes;
        private Duration deadline;

        Builder() {
        }

        @Override
        public TraceConfiguration.Builder setCredentials(Credentials credentials) {
            this.credentials = credentials;
            return this;
        }

        @Override
        public TraceConfiguration.Builder setProjectId(String projectId) {
            if (projectId == null) {
                throw new NullPointerException("Null projectId");
            }
            this.projectId = projectId;
            return this;
        }

        @Override
        String getProjectId() {
            if (this.projectId == null) {
                throw new IllegalStateException("Property \"projectId\" has not been set");
            }
            return this.projectId;
        }

        @Override
        public TraceConfiguration.Builder setTraceServiceStub(TraceServiceStub traceServiceStub) {
            this.traceServiceStub = traceServiceStub;
            return this;
        }

        @Override
        public TraceConfiguration.Builder setFixedAttributes(Map<String, AttributeValue> fixedAttributes) {
            if (fixedAttributes == null) {
                throw new NullPointerException("Null fixedAttributes");
            }
            this.fixedAttributes = fixedAttributes;
            return this;
        }

        @Override
        Map<String, AttributeValue> getFixedAttributes() {
            if (this.fixedAttributes == null) {
                throw new IllegalStateException("Property \"fixedAttributes\" has not been set");
            }
            return this.fixedAttributes;
        }

        @Override
        public TraceConfiguration.Builder setDeadline(Duration deadline) {
            if (deadline == null) {
                throw new NullPointerException("Null deadline");
            }
            this.deadline = deadline;
            return this;
        }

        @Override
        Duration getDeadline() {
            if (this.deadline == null) {
                throw new IllegalStateException("Property \"deadline\" has not been set");
            }
            return this.deadline;
        }

        @Override
        TraceConfiguration autoBuild() {
            String missing = "";
            if (this.projectId == null) {
                missing = String.valueOf(missing).concat(" projectId");
            }
            if (this.fixedAttributes == null) {
                missing = String.valueOf(missing).concat(" fixedAttributes");
            }
            if (this.deadline == null) {
                missing = String.valueOf(missing).concat(" deadline");
            }
            if (!missing.isEmpty()) {
                String string = String.valueOf(missing);
                throw new IllegalStateException(string.length() != 0 ? "Missing required properties:".concat(string) : new String("Missing required properties:"));
            }
            return new AutoValue_TraceConfiguration(this.credentials, this.projectId, this.traceServiceStub, this.fixedAttributes, this.deadline);
        }
    }
}

