/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.opentelemetry.trace;

import io.opentelemetry.sdk.resources.Resource;
import io.opentelemetry.semconv.resource.attributes.ResourceAttributes;
import java.util.Properties;
import javax.annotation.Nullable;

public class TraceVersions {
    public static final String SDK_VERSION = TraceVersions.readSdkVersion();
    public static final String EXPORTER_VERSION = TraceVersions.readVersion();

    @Nullable
    private static String readSdkVersion() {
        return (String)Resource.getDefault().getAttributes().get(ResourceAttributes.TELEMETRY_SDK_VERSION);
    }

    @Nullable
    private static String readVersion() {
        Properties properties = new Properties();
        try {
            properties.load(TraceVersions.class.getResourceAsStream("/com/google/cloud/opentelemetry/trace/version.properties"));
        }
        catch (Exception e) {
            return "unknown";
        }
        String result = properties.getProperty("exporter.version");
        if (result != null && result.endsWith("-SNAPSHOT")) {
            return result.substring(0, result.length() - 9);
        }
        return result;
    }
}

