/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.opentelemetry.example.metrics;

import com.google.cloud.opentelemetry.metric.MetricExporter;
import io.opentelemetry.api.metrics.GlobalMetricsProvider;
import io.opentelemetry.api.metrics.LongUpDownCounter;
import io.opentelemetry.api.metrics.Meter;
import io.opentelemetry.sdk.metrics.SdkMeterProvider;
import io.opentelemetry.sdk.metrics.export.IntervalMetricReader;
import java.io.IOException;
import java.util.Collections;
import java.util.Random;

public class MetricsExporterExample {
    private static final Meter METER = GlobalMetricsProvider.getMeter((String)"instrumentation-library-name", (String)"semver:1.0.0");
    private static final Random RANDOM = new Random();
    private static io.opentelemetry.sdk.metrics.export.MetricExporter metricExporter;
    private static IntervalMetricReader intervalMetricReader;

    private static void setupMetricExporter() {
        try {
            metricExporter = MetricExporter.createWithDefaultConfiguration();
            intervalMetricReader = IntervalMetricReader.builder().setExportIntervalMillis(20000L).setMetricExporter(metricExporter).setMetricProducers(Collections.singleton(SdkMeterProvider.builder().buildAndRegisterGlobal())).build();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static void myUseCase() {
        LongUpDownCounter counter = METER.longUpDownCounterBuilder("processed_jobs").setDescription("Processed jobs").setUnit("1").build();
        MetricsExporterExample.doWork(counter);
    }

    private static void doWork(LongUpDownCounter counter) {
        try {
            for (int i = 0; i < 10; ++i) {
                counter.add((long)RANDOM.nextInt(100));
                Thread.sleep(RANDOM.nextInt(1000));
            }
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    public static void main(String[] args) throws InterruptedException {
        MetricsExporterExample.setupMetricExporter();
        MetricsExporterExample.myUseCase();
        Thread.sleep(10000L);
        intervalMetricReader.shutdown();
        metricExporter.flush();
        metricExporter.shutdown();
    }
}

