/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.opentelemetry.detectors;

import com.google.cloud.opentelemetry.detectors.AttributesExtractorUtil;
import com.google.cloud.opentelemetry.detectors.EnvVars;
import com.google.cloud.opentelemetry.detectors.GCPMetadataConfig;
import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.api.common.AttributesBuilder;
import io.opentelemetry.api.internal.StringUtils;
import io.opentelemetry.sdk.autoconfigure.spi.ConfigProperties;
import io.opentelemetry.sdk.autoconfigure.spi.ResourceProvider;
import io.opentelemetry.sdk.resources.Resource;
import io.opentelemetry.semconv.ResourceAttributes;
import java.util.logging.Logger;

public class GCPResource
implements ResourceProvider {
    private final GCPMetadataConfig metadata;
    private final EnvVars envVars;
    private static final Logger LOGGER = Logger.getLogger(GCPResource.class.getSimpleName());

    public GCPResource() {
        this.metadata = GCPMetadataConfig.DEFAULT_INSTANCE;
        this.envVars = EnvVars.DEFAULT_INSTANCE;
    }

    GCPResource(GCPMetadataConfig metadata, EnvVars envVars) {
        this.metadata = metadata;
        this.envVars = envVars;
    }

    public Attributes getAttributes() {
        if (!this.metadata.isRunningOnGcp()) {
            return Attributes.empty();
        }
        AttributesBuilder attrBuilder = Attributes.builder();
        attrBuilder.put(ResourceAttributes.CLOUD_PROVIDER, (Object)"gcp");
        if (!(this.generateGKEAttributesIfApplicable(attrBuilder) || this.generateGCRAttributesIfApplicable(attrBuilder) || this.generateGCFAttributesIfApplicable(attrBuilder) || this.generateGAEAttributesIfApplicable(attrBuilder))) {
            this.addGCEAttributes(attrBuilder);
        }
        return attrBuilder.build();
    }

    public Resource createResource(ConfigProperties config) {
        return Resource.create((Attributes)this.getAttributes());
    }

    private void addGCEAttributes(AttributesBuilder attrBuilder) {
        String hostType;
        String instanceName;
        attrBuilder.put(ResourceAttributes.CLOUD_PLATFORM, (Object)"gcp_compute_engine");
        String projectId = this.metadata.getProjectId();
        if (projectId != null) {
            attrBuilder.put(ResourceAttributes.CLOUD_ACCOUNT_ID, (Object)projectId);
        }
        AttributesExtractorUtil.addAvailabilityZoneFromMetadata(attrBuilder, this.metadata);
        AttributesExtractorUtil.addCloudRegionFromMetadataUsingZone(attrBuilder, this.metadata);
        String instanceId = this.metadata.getInstanceId();
        if (instanceId != null) {
            attrBuilder.put(ResourceAttributes.HOST_ID, (Object)instanceId);
        }
        if ((instanceName = this.metadata.getInstanceName()) != null) {
            attrBuilder.put(ResourceAttributes.HOST_NAME, (Object)instanceName);
        }
        if ((hostType = this.metadata.getMachineType()) != null) {
            attrBuilder.put(ResourceAttributes.HOST_TYPE, (Object)hostType);
        }
    }

    private boolean generateGKEAttributesIfApplicable(AttributesBuilder attrBuilder) {
        if (this.envVars.get("KUBERNETES_SERVICE_HOST") != null) {
            String instanceId;
            String containerName;
            attrBuilder.put(ResourceAttributes.CLOUD_PLATFORM, (Object)"gcp_kubernetes_engine");
            String podName = this.envVars.get("POD_NAME");
            if (podName != null && !podName.isEmpty()) {
                attrBuilder.put(ResourceAttributes.K8S_POD_NAME, (Object)podName);
            } else {
                attrBuilder.put(ResourceAttributes.K8S_POD_NAME, (Object)this.envVars.get("HOSTNAME"));
            }
            String namespace = this.envVars.get("NAMESPACE");
            if (namespace != null && !namespace.isEmpty()) {
                attrBuilder.put(ResourceAttributes.K8S_NAMESPACE_NAME, (Object)namespace);
            }
            if ((containerName = this.envVars.get("CONTAINER_NAME")) != null && !containerName.isEmpty()) {
                attrBuilder.put(ResourceAttributes.K8S_CONTAINER_NAME, (Object)containerName);
            }
            if ((instanceId = this.metadata.getInstanceId()) != null) {
                attrBuilder.put(ResourceAttributes.HOST_ID, (Object)instanceId);
            }
            String clusterLocation = this.metadata.getClusterLocation();
            this.assignGKEAvailabilityZoneOrRegion(clusterLocation, attrBuilder);
            String clusterName = this.metadata.getClusterName();
            if (clusterName != null && !clusterName.isEmpty()) {
                attrBuilder.put(ResourceAttributes.K8S_CLUSTER_NAME, (Object)clusterName);
            }
            return true;
        }
        return false;
    }

    private void assignGKEAvailabilityZoneOrRegion(String clusterLocation, AttributesBuilder attributesBuilder) {
        long dashCount = StringUtils.isNullOrEmpty((String)clusterLocation) ? 0L : clusterLocation.chars().filter(ch -> ch == 45).count();
        switch ((int)dashCount) {
            case 1: {
                attributesBuilder.put(ResourceAttributes.CLOUD_REGION, (Object)clusterLocation);
                break;
            }
            case 2: {
                attributesBuilder.put(ResourceAttributes.CLOUD_AVAILABILITY_ZONE, (Object)clusterLocation);
                break;
            }
            default: {
                LOGGER.severe(String.format("Unrecognized format for cluster location: %s", clusterLocation));
            }
        }
    }

    private boolean generateGCRAttributesIfApplicable(AttributesBuilder attrBuilder) {
        if (this.envVars.get("K_CONFIGURATION") != null && this.envVars.get("FUNCTION_TARGET") == null) {
            attrBuilder.put(ResourceAttributes.CLOUD_PLATFORM, (Object)"gcp_cloud_run");
            this.updateCommonAttributesForServerlessCompute(attrBuilder);
            return true;
        }
        return false;
    }

    private boolean generateGCFAttributesIfApplicable(AttributesBuilder attrBuilder) {
        if (this.envVars.get("FUNCTION_TARGET") != null) {
            attrBuilder.put(ResourceAttributes.CLOUD_PLATFORM, (Object)"gcp_cloud_functions");
            this.updateCommonAttributesForServerlessCompute(attrBuilder);
            return true;
        }
        return false;
    }

    private void updateCommonAttributesForServerlessCompute(AttributesBuilder attrBuilder) {
        String serverlessComputeVersion;
        String serverlessComputeName = this.envVars.get("K_SERVICE");
        if (serverlessComputeName != null) {
            attrBuilder.put(ResourceAttributes.FAAS_NAME, (Object)serverlessComputeName);
        }
        if ((serverlessComputeVersion = this.envVars.get("K_REVISION")) != null) {
            attrBuilder.put(ResourceAttributes.FAAS_VERSION, (Object)serverlessComputeVersion);
        }
        AttributesExtractorUtil.addAvailabilityZoneFromMetadata(attrBuilder, this.metadata);
        AttributesExtractorUtil.addCloudRegionFromMetadataUsingZone(attrBuilder, this.metadata);
        AttributesExtractorUtil.addInstanceIdFromMetadata(attrBuilder, this.metadata);
    }

    private boolean generateGAEAttributesIfApplicable(AttributesBuilder attrBuilder) {
        if (this.envVars.get("GAE_SERVICE") != null) {
            String appInstanceId;
            String appVersionId;
            attrBuilder.put(ResourceAttributes.CLOUD_PLATFORM, (Object)"gcp_app_engine");
            String appModuleName = this.envVars.get("GAE_SERVICE");
            if (appModuleName != null) {
                attrBuilder.put(ResourceAttributes.FAAS_NAME, (Object)appModuleName);
            }
            if ((appVersionId = this.envVars.get("GAE_VERSION")) != null) {
                attrBuilder.put(ResourceAttributes.FAAS_VERSION, (Object)appVersionId);
            }
            if ((appInstanceId = this.envVars.get("GAE_INSTANCE")) != null) {
                attrBuilder.put(ResourceAttributes.FAAS_INSTANCE, (Object)appInstanceId);
            }
            this.updateAttributesWithRegion(attrBuilder);
            AttributesExtractorUtil.addAvailabilityZoneFromMetadata(attrBuilder, this.metadata);
            return true;
        }
        return false;
    }

    private void updateAttributesWithRegion(AttributesBuilder attributesBuilder) {
        if (this.envVars.get("GAE_ENV") != null && this.envVars.get("GAE_ENV").equals("standard")) {
            AttributesExtractorUtil.addCloudRegionFromMetadataUsingRegion(attributesBuilder, this.metadata);
        } else {
            AttributesExtractorUtil.addCloudRegionFromMetadataUsingZone(attributesBuilder, this.metadata);
        }
    }
}

