/*
 * Decompiled with CFR 0.152.
 */
package com.google.identity.accesscontextmanager.v1.stub;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.GaxProperties;
import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.api.gax.grpc.GaxGrpcProperties;
import com.google.api.gax.grpc.GrpcTransportChannel;
import com.google.api.gax.grpc.InstantiatingGrpcChannelProvider;
import com.google.api.gax.grpc.ProtoOperationTransformers;
import com.google.api.gax.httpjson.GaxHttpJsonProperties;
import com.google.api.gax.httpjson.HttpJsonTransportChannel;
import com.google.api.gax.httpjson.InstantiatingHttpJsonChannelProvider;
import com.google.api.gax.longrunning.OperationTimedPollAlgorithm;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.retrying.TimedRetryAlgorithm;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.OperationCallSettings;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.PagedCallSettings;
import com.google.api.gax.rpc.PagedListDescriptor;
import com.google.api.gax.rpc.PagedListResponseFactory;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.iam.v1.GetIamPolicyRequest;
import com.google.iam.v1.Policy;
import com.google.iam.v1.SetIamPolicyRequest;
import com.google.iam.v1.TestIamPermissionsRequest;
import com.google.iam.v1.TestIamPermissionsResponse;
import com.google.identity.accesscontextmanager.v1.AccessContextManagerClient;
import com.google.identity.accesscontextmanager.v1.AccessContextManagerOperationMetadata;
import com.google.identity.accesscontextmanager.v1.AccessLevel;
import com.google.identity.accesscontextmanager.v1.AccessPolicy;
import com.google.identity.accesscontextmanager.v1.CommitServicePerimetersRequest;
import com.google.identity.accesscontextmanager.v1.CommitServicePerimetersResponse;
import com.google.identity.accesscontextmanager.v1.CreateAccessLevelRequest;
import com.google.identity.accesscontextmanager.v1.CreateGcpUserAccessBindingRequest;
import com.google.identity.accesscontextmanager.v1.CreateServicePerimeterRequest;
import com.google.identity.accesscontextmanager.v1.DeleteAccessLevelRequest;
import com.google.identity.accesscontextmanager.v1.DeleteAccessPolicyRequest;
import com.google.identity.accesscontextmanager.v1.DeleteGcpUserAccessBindingRequest;
import com.google.identity.accesscontextmanager.v1.DeleteServicePerimeterRequest;
import com.google.identity.accesscontextmanager.v1.GcpUserAccessBinding;
import com.google.identity.accesscontextmanager.v1.GcpUserAccessBindingOperationMetadata;
import com.google.identity.accesscontextmanager.v1.GetAccessLevelRequest;
import com.google.identity.accesscontextmanager.v1.GetAccessPolicyRequest;
import com.google.identity.accesscontextmanager.v1.GetGcpUserAccessBindingRequest;
import com.google.identity.accesscontextmanager.v1.GetServicePerimeterRequest;
import com.google.identity.accesscontextmanager.v1.ListAccessLevelsRequest;
import com.google.identity.accesscontextmanager.v1.ListAccessLevelsResponse;
import com.google.identity.accesscontextmanager.v1.ListAccessPoliciesRequest;
import com.google.identity.accesscontextmanager.v1.ListAccessPoliciesResponse;
import com.google.identity.accesscontextmanager.v1.ListGcpUserAccessBindingsRequest;
import com.google.identity.accesscontextmanager.v1.ListGcpUserAccessBindingsResponse;
import com.google.identity.accesscontextmanager.v1.ListServicePerimetersRequest;
import com.google.identity.accesscontextmanager.v1.ListServicePerimetersResponse;
import com.google.identity.accesscontextmanager.v1.ReplaceAccessLevelsRequest;
import com.google.identity.accesscontextmanager.v1.ReplaceAccessLevelsResponse;
import com.google.identity.accesscontextmanager.v1.ReplaceServicePerimetersRequest;
import com.google.identity.accesscontextmanager.v1.ReplaceServicePerimetersResponse;
import com.google.identity.accesscontextmanager.v1.ServicePerimeter;
import com.google.identity.accesscontextmanager.v1.UpdateAccessLevelRequest;
import com.google.identity.accesscontextmanager.v1.UpdateAccessPolicyRequest;
import com.google.identity.accesscontextmanager.v1.UpdateGcpUserAccessBindingRequest;
import com.google.identity.accesscontextmanager.v1.UpdateServicePerimeterRequest;
import com.google.identity.accesscontextmanager.v1.stub.AccessContextManagerStub;
import com.google.identity.accesscontextmanager.v1.stub.GrpcAccessContextManagerStub;
import com.google.identity.accesscontextmanager.v1.stub.HttpJsonAccessContextManagerStub;
import com.google.longrunning.Operation;
import com.google.protobuf.Empty;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.threeten.bp.Duration;

public class AccessContextManagerStubSettings
extends StubSettings<AccessContextManagerStubSettings> {
    private static final ImmutableList<String> DEFAULT_SERVICE_SCOPES = ImmutableList.builder().add((Object)"https://www.googleapis.com/auth/cloud-platform").build();
    private final PagedCallSettings<ListAccessPoliciesRequest, ListAccessPoliciesResponse, AccessContextManagerClient.ListAccessPoliciesPagedResponse> listAccessPoliciesSettings;
    private final UnaryCallSettings<GetAccessPolicyRequest, AccessPolicy> getAccessPolicySettings;
    private final UnaryCallSettings<AccessPolicy, Operation> createAccessPolicySettings;
    private final OperationCallSettings<AccessPolicy, AccessPolicy, AccessContextManagerOperationMetadata> createAccessPolicyOperationSettings;
    private final UnaryCallSettings<UpdateAccessPolicyRequest, Operation> updateAccessPolicySettings;
    private final OperationCallSettings<UpdateAccessPolicyRequest, AccessPolicy, AccessContextManagerOperationMetadata> updateAccessPolicyOperationSettings;
    private final UnaryCallSettings<DeleteAccessPolicyRequest, Operation> deleteAccessPolicySettings;
    private final OperationCallSettings<DeleteAccessPolicyRequest, Empty, AccessContextManagerOperationMetadata> deleteAccessPolicyOperationSettings;
    private final PagedCallSettings<ListAccessLevelsRequest, ListAccessLevelsResponse, AccessContextManagerClient.ListAccessLevelsPagedResponse> listAccessLevelsSettings;
    private final UnaryCallSettings<GetAccessLevelRequest, AccessLevel> getAccessLevelSettings;
    private final UnaryCallSettings<CreateAccessLevelRequest, Operation> createAccessLevelSettings;
    private final OperationCallSettings<CreateAccessLevelRequest, AccessLevel, AccessContextManagerOperationMetadata> createAccessLevelOperationSettings;
    private final UnaryCallSettings<UpdateAccessLevelRequest, Operation> updateAccessLevelSettings;
    private final OperationCallSettings<UpdateAccessLevelRequest, AccessLevel, AccessContextManagerOperationMetadata> updateAccessLevelOperationSettings;
    private final UnaryCallSettings<DeleteAccessLevelRequest, Operation> deleteAccessLevelSettings;
    private final OperationCallSettings<DeleteAccessLevelRequest, Empty, AccessContextManagerOperationMetadata> deleteAccessLevelOperationSettings;
    private final UnaryCallSettings<ReplaceAccessLevelsRequest, Operation> replaceAccessLevelsSettings;
    private final OperationCallSettings<ReplaceAccessLevelsRequest, ReplaceAccessLevelsResponse, AccessContextManagerOperationMetadata> replaceAccessLevelsOperationSettings;
    private final PagedCallSettings<ListServicePerimetersRequest, ListServicePerimetersResponse, AccessContextManagerClient.ListServicePerimetersPagedResponse> listServicePerimetersSettings;
    private final UnaryCallSettings<GetServicePerimeterRequest, ServicePerimeter> getServicePerimeterSettings;
    private final UnaryCallSettings<CreateServicePerimeterRequest, Operation> createServicePerimeterSettings;
    private final OperationCallSettings<CreateServicePerimeterRequest, ServicePerimeter, AccessContextManagerOperationMetadata> createServicePerimeterOperationSettings;
    private final UnaryCallSettings<UpdateServicePerimeterRequest, Operation> updateServicePerimeterSettings;
    private final OperationCallSettings<UpdateServicePerimeterRequest, ServicePerimeter, AccessContextManagerOperationMetadata> updateServicePerimeterOperationSettings;
    private final UnaryCallSettings<DeleteServicePerimeterRequest, Operation> deleteServicePerimeterSettings;
    private final OperationCallSettings<DeleteServicePerimeterRequest, Empty, AccessContextManagerOperationMetadata> deleteServicePerimeterOperationSettings;
    private final UnaryCallSettings<ReplaceServicePerimetersRequest, Operation> replaceServicePerimetersSettings;
    private final OperationCallSettings<ReplaceServicePerimetersRequest, ReplaceServicePerimetersResponse, AccessContextManagerOperationMetadata> replaceServicePerimetersOperationSettings;
    private final UnaryCallSettings<CommitServicePerimetersRequest, Operation> commitServicePerimetersSettings;
    private final OperationCallSettings<CommitServicePerimetersRequest, CommitServicePerimetersResponse, AccessContextManagerOperationMetadata> commitServicePerimetersOperationSettings;
    private final PagedCallSettings<ListGcpUserAccessBindingsRequest, ListGcpUserAccessBindingsResponse, AccessContextManagerClient.ListGcpUserAccessBindingsPagedResponse> listGcpUserAccessBindingsSettings;
    private final UnaryCallSettings<GetGcpUserAccessBindingRequest, GcpUserAccessBinding> getGcpUserAccessBindingSettings;
    private final UnaryCallSettings<CreateGcpUserAccessBindingRequest, Operation> createGcpUserAccessBindingSettings;
    private final OperationCallSettings<CreateGcpUserAccessBindingRequest, GcpUserAccessBinding, GcpUserAccessBindingOperationMetadata> createGcpUserAccessBindingOperationSettings;
    private final UnaryCallSettings<UpdateGcpUserAccessBindingRequest, Operation> updateGcpUserAccessBindingSettings;
    private final OperationCallSettings<UpdateGcpUserAccessBindingRequest, GcpUserAccessBinding, GcpUserAccessBindingOperationMetadata> updateGcpUserAccessBindingOperationSettings;
    private final UnaryCallSettings<DeleteGcpUserAccessBindingRequest, Operation> deleteGcpUserAccessBindingSettings;
    private final OperationCallSettings<DeleteGcpUserAccessBindingRequest, Empty, GcpUserAccessBindingOperationMetadata> deleteGcpUserAccessBindingOperationSettings;
    private final UnaryCallSettings<SetIamPolicyRequest, Policy> setIamPolicySettings;
    private final UnaryCallSettings<GetIamPolicyRequest, Policy> getIamPolicySettings;
    private final UnaryCallSettings<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsSettings;
    private static final PagedListDescriptor<ListAccessPoliciesRequest, ListAccessPoliciesResponse, AccessPolicy> LIST_ACCESS_POLICIES_PAGE_STR_DESC = new PagedListDescriptor<ListAccessPoliciesRequest, ListAccessPoliciesResponse, AccessPolicy>(){

        public String emptyToken() {
            return "";
        }

        public ListAccessPoliciesRequest injectToken(ListAccessPoliciesRequest payload, String token) {
            return ListAccessPoliciesRequest.newBuilder((ListAccessPoliciesRequest)payload).setPageToken(token).build();
        }

        public ListAccessPoliciesRequest injectPageSize(ListAccessPoliciesRequest payload, int pageSize) {
            return ListAccessPoliciesRequest.newBuilder((ListAccessPoliciesRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListAccessPoliciesRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListAccessPoliciesResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<AccessPolicy> extractResources(ListAccessPoliciesResponse payload) {
            return payload.getAccessPoliciesList() == null ? ImmutableList.of() : payload.getAccessPoliciesList();
        }
    };
    private static final PagedListDescriptor<ListAccessLevelsRequest, ListAccessLevelsResponse, AccessLevel> LIST_ACCESS_LEVELS_PAGE_STR_DESC = new PagedListDescriptor<ListAccessLevelsRequest, ListAccessLevelsResponse, AccessLevel>(){

        public String emptyToken() {
            return "";
        }

        public ListAccessLevelsRequest injectToken(ListAccessLevelsRequest payload, String token) {
            return ListAccessLevelsRequest.newBuilder((ListAccessLevelsRequest)payload).setPageToken(token).build();
        }

        public ListAccessLevelsRequest injectPageSize(ListAccessLevelsRequest payload, int pageSize) {
            return ListAccessLevelsRequest.newBuilder((ListAccessLevelsRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListAccessLevelsRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListAccessLevelsResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<AccessLevel> extractResources(ListAccessLevelsResponse payload) {
            return payload.getAccessLevelsList() == null ? ImmutableList.of() : payload.getAccessLevelsList();
        }
    };
    private static final PagedListDescriptor<ListServicePerimetersRequest, ListServicePerimetersResponse, ServicePerimeter> LIST_SERVICE_PERIMETERS_PAGE_STR_DESC = new PagedListDescriptor<ListServicePerimetersRequest, ListServicePerimetersResponse, ServicePerimeter>(){

        public String emptyToken() {
            return "";
        }

        public ListServicePerimetersRequest injectToken(ListServicePerimetersRequest payload, String token) {
            return ListServicePerimetersRequest.newBuilder((ListServicePerimetersRequest)payload).setPageToken(token).build();
        }

        public ListServicePerimetersRequest injectPageSize(ListServicePerimetersRequest payload, int pageSize) {
            return ListServicePerimetersRequest.newBuilder((ListServicePerimetersRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListServicePerimetersRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListServicePerimetersResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<ServicePerimeter> extractResources(ListServicePerimetersResponse payload) {
            return payload.getServicePerimetersList() == null ? ImmutableList.of() : payload.getServicePerimetersList();
        }
    };
    private static final PagedListDescriptor<ListGcpUserAccessBindingsRequest, ListGcpUserAccessBindingsResponse, GcpUserAccessBinding> LIST_GCP_USER_ACCESS_BINDINGS_PAGE_STR_DESC = new PagedListDescriptor<ListGcpUserAccessBindingsRequest, ListGcpUserAccessBindingsResponse, GcpUserAccessBinding>(){

        public String emptyToken() {
            return "";
        }

        public ListGcpUserAccessBindingsRequest injectToken(ListGcpUserAccessBindingsRequest payload, String token) {
            return ListGcpUserAccessBindingsRequest.newBuilder((ListGcpUserAccessBindingsRequest)payload).setPageToken(token).build();
        }

        public ListGcpUserAccessBindingsRequest injectPageSize(ListGcpUserAccessBindingsRequest payload, int pageSize) {
            return ListGcpUserAccessBindingsRequest.newBuilder((ListGcpUserAccessBindingsRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListGcpUserAccessBindingsRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListGcpUserAccessBindingsResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<GcpUserAccessBinding> extractResources(ListGcpUserAccessBindingsResponse payload) {
            return payload.getGcpUserAccessBindingsList() == null ? ImmutableList.of() : payload.getGcpUserAccessBindingsList();
        }
    };
    private static final PagedListResponseFactory<ListAccessPoliciesRequest, ListAccessPoliciesResponse, AccessContextManagerClient.ListAccessPoliciesPagedResponse> LIST_ACCESS_POLICIES_PAGE_STR_FACT = new PagedListResponseFactory<ListAccessPoliciesRequest, ListAccessPoliciesResponse, AccessContextManagerClient.ListAccessPoliciesPagedResponse>(){

        public ApiFuture<AccessContextManagerClient.ListAccessPoliciesPagedResponse> getFuturePagedResponse(UnaryCallable<ListAccessPoliciesRequest, ListAccessPoliciesResponse> callable, ListAccessPoliciesRequest request, ApiCallContext context, ApiFuture<ListAccessPoliciesResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_ACCESS_POLICIES_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return AccessContextManagerClient.ListAccessPoliciesPagedResponse.createAsync((PageContext<ListAccessPoliciesRequest, ListAccessPoliciesResponse, AccessPolicy>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<ListAccessLevelsRequest, ListAccessLevelsResponse, AccessContextManagerClient.ListAccessLevelsPagedResponse> LIST_ACCESS_LEVELS_PAGE_STR_FACT = new PagedListResponseFactory<ListAccessLevelsRequest, ListAccessLevelsResponse, AccessContextManagerClient.ListAccessLevelsPagedResponse>(){

        public ApiFuture<AccessContextManagerClient.ListAccessLevelsPagedResponse> getFuturePagedResponse(UnaryCallable<ListAccessLevelsRequest, ListAccessLevelsResponse> callable, ListAccessLevelsRequest request, ApiCallContext context, ApiFuture<ListAccessLevelsResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_ACCESS_LEVELS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return AccessContextManagerClient.ListAccessLevelsPagedResponse.createAsync((PageContext<ListAccessLevelsRequest, ListAccessLevelsResponse, AccessLevel>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<ListServicePerimetersRequest, ListServicePerimetersResponse, AccessContextManagerClient.ListServicePerimetersPagedResponse> LIST_SERVICE_PERIMETERS_PAGE_STR_FACT = new PagedListResponseFactory<ListServicePerimetersRequest, ListServicePerimetersResponse, AccessContextManagerClient.ListServicePerimetersPagedResponse>(){

        public ApiFuture<AccessContextManagerClient.ListServicePerimetersPagedResponse> getFuturePagedResponse(UnaryCallable<ListServicePerimetersRequest, ListServicePerimetersResponse> callable, ListServicePerimetersRequest request, ApiCallContext context, ApiFuture<ListServicePerimetersResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_SERVICE_PERIMETERS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return AccessContextManagerClient.ListServicePerimetersPagedResponse.createAsync((PageContext<ListServicePerimetersRequest, ListServicePerimetersResponse, ServicePerimeter>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<ListGcpUserAccessBindingsRequest, ListGcpUserAccessBindingsResponse, AccessContextManagerClient.ListGcpUserAccessBindingsPagedResponse> LIST_GCP_USER_ACCESS_BINDINGS_PAGE_STR_FACT = new PagedListResponseFactory<ListGcpUserAccessBindingsRequest, ListGcpUserAccessBindingsResponse, AccessContextManagerClient.ListGcpUserAccessBindingsPagedResponse>(){

        public ApiFuture<AccessContextManagerClient.ListGcpUserAccessBindingsPagedResponse> getFuturePagedResponse(UnaryCallable<ListGcpUserAccessBindingsRequest, ListGcpUserAccessBindingsResponse> callable, ListGcpUserAccessBindingsRequest request, ApiCallContext context, ApiFuture<ListGcpUserAccessBindingsResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_GCP_USER_ACCESS_BINDINGS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return AccessContextManagerClient.ListGcpUserAccessBindingsPagedResponse.createAsync((PageContext<ListGcpUserAccessBindingsRequest, ListGcpUserAccessBindingsResponse, GcpUserAccessBinding>)pageContext, futureResponse);
        }
    };

    public PagedCallSettings<ListAccessPoliciesRequest, ListAccessPoliciesResponse, AccessContextManagerClient.ListAccessPoliciesPagedResponse> listAccessPoliciesSettings() {
        return this.listAccessPoliciesSettings;
    }

    public UnaryCallSettings<GetAccessPolicyRequest, AccessPolicy> getAccessPolicySettings() {
        return this.getAccessPolicySettings;
    }

    public UnaryCallSettings<AccessPolicy, Operation> createAccessPolicySettings() {
        return this.createAccessPolicySettings;
    }

    public OperationCallSettings<AccessPolicy, AccessPolicy, AccessContextManagerOperationMetadata> createAccessPolicyOperationSettings() {
        return this.createAccessPolicyOperationSettings;
    }

    public UnaryCallSettings<UpdateAccessPolicyRequest, Operation> updateAccessPolicySettings() {
        return this.updateAccessPolicySettings;
    }

    public OperationCallSettings<UpdateAccessPolicyRequest, AccessPolicy, AccessContextManagerOperationMetadata> updateAccessPolicyOperationSettings() {
        return this.updateAccessPolicyOperationSettings;
    }

    public UnaryCallSettings<DeleteAccessPolicyRequest, Operation> deleteAccessPolicySettings() {
        return this.deleteAccessPolicySettings;
    }

    public OperationCallSettings<DeleteAccessPolicyRequest, Empty, AccessContextManagerOperationMetadata> deleteAccessPolicyOperationSettings() {
        return this.deleteAccessPolicyOperationSettings;
    }

    public PagedCallSettings<ListAccessLevelsRequest, ListAccessLevelsResponse, AccessContextManagerClient.ListAccessLevelsPagedResponse> listAccessLevelsSettings() {
        return this.listAccessLevelsSettings;
    }

    public UnaryCallSettings<GetAccessLevelRequest, AccessLevel> getAccessLevelSettings() {
        return this.getAccessLevelSettings;
    }

    public UnaryCallSettings<CreateAccessLevelRequest, Operation> createAccessLevelSettings() {
        return this.createAccessLevelSettings;
    }

    public OperationCallSettings<CreateAccessLevelRequest, AccessLevel, AccessContextManagerOperationMetadata> createAccessLevelOperationSettings() {
        return this.createAccessLevelOperationSettings;
    }

    public UnaryCallSettings<UpdateAccessLevelRequest, Operation> updateAccessLevelSettings() {
        return this.updateAccessLevelSettings;
    }

    public OperationCallSettings<UpdateAccessLevelRequest, AccessLevel, AccessContextManagerOperationMetadata> updateAccessLevelOperationSettings() {
        return this.updateAccessLevelOperationSettings;
    }

    public UnaryCallSettings<DeleteAccessLevelRequest, Operation> deleteAccessLevelSettings() {
        return this.deleteAccessLevelSettings;
    }

    public OperationCallSettings<DeleteAccessLevelRequest, Empty, AccessContextManagerOperationMetadata> deleteAccessLevelOperationSettings() {
        return this.deleteAccessLevelOperationSettings;
    }

    public UnaryCallSettings<ReplaceAccessLevelsRequest, Operation> replaceAccessLevelsSettings() {
        return this.replaceAccessLevelsSettings;
    }

    public OperationCallSettings<ReplaceAccessLevelsRequest, ReplaceAccessLevelsResponse, AccessContextManagerOperationMetadata> replaceAccessLevelsOperationSettings() {
        return this.replaceAccessLevelsOperationSettings;
    }

    public PagedCallSettings<ListServicePerimetersRequest, ListServicePerimetersResponse, AccessContextManagerClient.ListServicePerimetersPagedResponse> listServicePerimetersSettings() {
        return this.listServicePerimetersSettings;
    }

    public UnaryCallSettings<GetServicePerimeterRequest, ServicePerimeter> getServicePerimeterSettings() {
        return this.getServicePerimeterSettings;
    }

    public UnaryCallSettings<CreateServicePerimeterRequest, Operation> createServicePerimeterSettings() {
        return this.createServicePerimeterSettings;
    }

    public OperationCallSettings<CreateServicePerimeterRequest, ServicePerimeter, AccessContextManagerOperationMetadata> createServicePerimeterOperationSettings() {
        return this.createServicePerimeterOperationSettings;
    }

    public UnaryCallSettings<UpdateServicePerimeterRequest, Operation> updateServicePerimeterSettings() {
        return this.updateServicePerimeterSettings;
    }

    public OperationCallSettings<UpdateServicePerimeterRequest, ServicePerimeter, AccessContextManagerOperationMetadata> updateServicePerimeterOperationSettings() {
        return this.updateServicePerimeterOperationSettings;
    }

    public UnaryCallSettings<DeleteServicePerimeterRequest, Operation> deleteServicePerimeterSettings() {
        return this.deleteServicePerimeterSettings;
    }

    public OperationCallSettings<DeleteServicePerimeterRequest, Empty, AccessContextManagerOperationMetadata> deleteServicePerimeterOperationSettings() {
        return this.deleteServicePerimeterOperationSettings;
    }

    public UnaryCallSettings<ReplaceServicePerimetersRequest, Operation> replaceServicePerimetersSettings() {
        return this.replaceServicePerimetersSettings;
    }

    public OperationCallSettings<ReplaceServicePerimetersRequest, ReplaceServicePerimetersResponse, AccessContextManagerOperationMetadata> replaceServicePerimetersOperationSettings() {
        return this.replaceServicePerimetersOperationSettings;
    }

    public UnaryCallSettings<CommitServicePerimetersRequest, Operation> commitServicePerimetersSettings() {
        return this.commitServicePerimetersSettings;
    }

    public OperationCallSettings<CommitServicePerimetersRequest, CommitServicePerimetersResponse, AccessContextManagerOperationMetadata> commitServicePerimetersOperationSettings() {
        return this.commitServicePerimetersOperationSettings;
    }

    public PagedCallSettings<ListGcpUserAccessBindingsRequest, ListGcpUserAccessBindingsResponse, AccessContextManagerClient.ListGcpUserAccessBindingsPagedResponse> listGcpUserAccessBindingsSettings() {
        return this.listGcpUserAccessBindingsSettings;
    }

    public UnaryCallSettings<GetGcpUserAccessBindingRequest, GcpUserAccessBinding> getGcpUserAccessBindingSettings() {
        return this.getGcpUserAccessBindingSettings;
    }

    public UnaryCallSettings<CreateGcpUserAccessBindingRequest, Operation> createGcpUserAccessBindingSettings() {
        return this.createGcpUserAccessBindingSettings;
    }

    public OperationCallSettings<CreateGcpUserAccessBindingRequest, GcpUserAccessBinding, GcpUserAccessBindingOperationMetadata> createGcpUserAccessBindingOperationSettings() {
        return this.createGcpUserAccessBindingOperationSettings;
    }

    public UnaryCallSettings<UpdateGcpUserAccessBindingRequest, Operation> updateGcpUserAccessBindingSettings() {
        return this.updateGcpUserAccessBindingSettings;
    }

    public OperationCallSettings<UpdateGcpUserAccessBindingRequest, GcpUserAccessBinding, GcpUserAccessBindingOperationMetadata> updateGcpUserAccessBindingOperationSettings() {
        return this.updateGcpUserAccessBindingOperationSettings;
    }

    public UnaryCallSettings<DeleteGcpUserAccessBindingRequest, Operation> deleteGcpUserAccessBindingSettings() {
        return this.deleteGcpUserAccessBindingSettings;
    }

    public OperationCallSettings<DeleteGcpUserAccessBindingRequest, Empty, GcpUserAccessBindingOperationMetadata> deleteGcpUserAccessBindingOperationSettings() {
        return this.deleteGcpUserAccessBindingOperationSettings;
    }

    public UnaryCallSettings<SetIamPolicyRequest, Policy> setIamPolicySettings() {
        return this.setIamPolicySettings;
    }

    public UnaryCallSettings<GetIamPolicyRequest, Policy> getIamPolicySettings() {
        return this.getIamPolicySettings;
    }

    public UnaryCallSettings<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsSettings() {
        return this.testIamPermissionsSettings;
    }

    public AccessContextManagerStub createStub() throws IOException {
        if (this.getTransportChannelProvider().getTransportName().equals(GrpcTransportChannel.getGrpcTransportName())) {
            return GrpcAccessContextManagerStub.create(this);
        }
        if (this.getTransportChannelProvider().getTransportName().equals(HttpJsonTransportChannel.getHttpJsonTransportName())) {
            return HttpJsonAccessContextManagerStub.create(this);
        }
        throw new UnsupportedOperationException(String.format("Transport not supported: %s", this.getTransportChannelProvider().getTransportName()));
    }

    public String getServiceName() {
        return "accesscontextmanager";
    }

    public static InstantiatingExecutorProvider.Builder defaultExecutorProviderBuilder() {
        return InstantiatingExecutorProvider.newBuilder();
    }

    public static String getDefaultEndpoint() {
        return "accesscontextmanager.googleapis.com:443";
    }

    public static String getDefaultMtlsEndpoint() {
        return "accesscontextmanager.mtls.googleapis.com:443";
    }

    public static List<String> getDefaultServiceScopes() {
        return DEFAULT_SERVICE_SCOPES;
    }

    public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
        return GoogleCredentialsProvider.newBuilder().setScopesToApply(DEFAULT_SERVICE_SCOPES).setUseJwtAccessWithScope(true);
    }

    public static InstantiatingGrpcChannelProvider.Builder defaultGrpcTransportProviderBuilder() {
        return InstantiatingGrpcChannelProvider.newBuilder().setMaxInboundMessageSize(Integer.valueOf(Integer.MAX_VALUE));
    }

    @BetaApi
    public static InstantiatingHttpJsonChannelProvider.Builder defaultHttpJsonTransportProviderBuilder() {
        return InstantiatingHttpJsonChannelProvider.newBuilder();
    }

    public static TransportChannelProvider defaultTransportChannelProvider() {
        return AccessContextManagerStubSettings.defaultGrpcTransportProviderBuilder().build();
    }

    @BetaApi(value="The surface for customizing headers is not stable yet and may change in the future.")
    public static ApiClientHeaderProvider.Builder defaultGrpcApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(AccessContextManagerStubSettings.class)).setTransportToken(GaxGrpcProperties.getGrpcTokenName(), GaxGrpcProperties.getGrpcVersion());
    }

    @BetaApi(value="The surface for customizing headers is not stable yet and may change in the future.")
    public static ApiClientHeaderProvider.Builder defaultHttpJsonApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(AccessContextManagerStubSettings.class)).setTransportToken(GaxHttpJsonProperties.getHttpJsonTokenName(), GaxHttpJsonProperties.getHttpJsonVersion());
    }

    public static ApiClientHeaderProvider.Builder defaultApiClientHeaderProviderBuilder() {
        return AccessContextManagerStubSettings.defaultGrpcApiClientHeaderProviderBuilder();
    }

    public static Builder newBuilder() {
        return Builder.createDefault();
    }

    public static Builder newHttpJsonBuilder() {
        return Builder.createHttpJsonDefault();
    }

    public static Builder newBuilder(ClientContext clientContext) {
        return new Builder(clientContext);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    protected AccessContextManagerStubSettings(Builder settingsBuilder) throws IOException {
        super((StubSettings.Builder)settingsBuilder);
        this.listAccessPoliciesSettings = settingsBuilder.listAccessPoliciesSettings().build();
        this.getAccessPolicySettings = settingsBuilder.getAccessPolicySettings().build();
        this.createAccessPolicySettings = settingsBuilder.createAccessPolicySettings().build();
        this.createAccessPolicyOperationSettings = settingsBuilder.createAccessPolicyOperationSettings().build();
        this.updateAccessPolicySettings = settingsBuilder.updateAccessPolicySettings().build();
        this.updateAccessPolicyOperationSettings = settingsBuilder.updateAccessPolicyOperationSettings().build();
        this.deleteAccessPolicySettings = settingsBuilder.deleteAccessPolicySettings().build();
        this.deleteAccessPolicyOperationSettings = settingsBuilder.deleteAccessPolicyOperationSettings().build();
        this.listAccessLevelsSettings = settingsBuilder.listAccessLevelsSettings().build();
        this.getAccessLevelSettings = settingsBuilder.getAccessLevelSettings().build();
        this.createAccessLevelSettings = settingsBuilder.createAccessLevelSettings().build();
        this.createAccessLevelOperationSettings = settingsBuilder.createAccessLevelOperationSettings().build();
        this.updateAccessLevelSettings = settingsBuilder.updateAccessLevelSettings().build();
        this.updateAccessLevelOperationSettings = settingsBuilder.updateAccessLevelOperationSettings().build();
        this.deleteAccessLevelSettings = settingsBuilder.deleteAccessLevelSettings().build();
        this.deleteAccessLevelOperationSettings = settingsBuilder.deleteAccessLevelOperationSettings().build();
        this.replaceAccessLevelsSettings = settingsBuilder.replaceAccessLevelsSettings().build();
        this.replaceAccessLevelsOperationSettings = settingsBuilder.replaceAccessLevelsOperationSettings().build();
        this.listServicePerimetersSettings = settingsBuilder.listServicePerimetersSettings().build();
        this.getServicePerimeterSettings = settingsBuilder.getServicePerimeterSettings().build();
        this.createServicePerimeterSettings = settingsBuilder.createServicePerimeterSettings().build();
        this.createServicePerimeterOperationSettings = settingsBuilder.createServicePerimeterOperationSettings().build();
        this.updateServicePerimeterSettings = settingsBuilder.updateServicePerimeterSettings().build();
        this.updateServicePerimeterOperationSettings = settingsBuilder.updateServicePerimeterOperationSettings().build();
        this.deleteServicePerimeterSettings = settingsBuilder.deleteServicePerimeterSettings().build();
        this.deleteServicePerimeterOperationSettings = settingsBuilder.deleteServicePerimeterOperationSettings().build();
        this.replaceServicePerimetersSettings = settingsBuilder.replaceServicePerimetersSettings().build();
        this.replaceServicePerimetersOperationSettings = settingsBuilder.replaceServicePerimetersOperationSettings().build();
        this.commitServicePerimetersSettings = settingsBuilder.commitServicePerimetersSettings().build();
        this.commitServicePerimetersOperationSettings = settingsBuilder.commitServicePerimetersOperationSettings().build();
        this.listGcpUserAccessBindingsSettings = settingsBuilder.listGcpUserAccessBindingsSettings().build();
        this.getGcpUserAccessBindingSettings = settingsBuilder.getGcpUserAccessBindingSettings().build();
        this.createGcpUserAccessBindingSettings = settingsBuilder.createGcpUserAccessBindingSettings().build();
        this.createGcpUserAccessBindingOperationSettings = settingsBuilder.createGcpUserAccessBindingOperationSettings().build();
        this.updateGcpUserAccessBindingSettings = settingsBuilder.updateGcpUserAccessBindingSettings().build();
        this.updateGcpUserAccessBindingOperationSettings = settingsBuilder.updateGcpUserAccessBindingOperationSettings().build();
        this.deleteGcpUserAccessBindingSettings = settingsBuilder.deleteGcpUserAccessBindingSettings().build();
        this.deleteGcpUserAccessBindingOperationSettings = settingsBuilder.deleteGcpUserAccessBindingOperationSettings().build();
        this.setIamPolicySettings = settingsBuilder.setIamPolicySettings().build();
        this.getIamPolicySettings = settingsBuilder.getIamPolicySettings().build();
        this.testIamPermissionsSettings = settingsBuilder.testIamPermissionsSettings().build();
    }

    public static class Builder
    extends StubSettings.Builder<AccessContextManagerStubSettings, Builder> {
        private final ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders;
        private final PagedCallSettings.Builder<ListAccessPoliciesRequest, ListAccessPoliciesResponse, AccessContextManagerClient.ListAccessPoliciesPagedResponse> listAccessPoliciesSettings;
        private final UnaryCallSettings.Builder<GetAccessPolicyRequest, AccessPolicy> getAccessPolicySettings;
        private final UnaryCallSettings.Builder<AccessPolicy, Operation> createAccessPolicySettings;
        private final OperationCallSettings.Builder<AccessPolicy, AccessPolicy, AccessContextManagerOperationMetadata> createAccessPolicyOperationSettings;
        private final UnaryCallSettings.Builder<UpdateAccessPolicyRequest, Operation> updateAccessPolicySettings;
        private final OperationCallSettings.Builder<UpdateAccessPolicyRequest, AccessPolicy, AccessContextManagerOperationMetadata> updateAccessPolicyOperationSettings;
        private final UnaryCallSettings.Builder<DeleteAccessPolicyRequest, Operation> deleteAccessPolicySettings;
        private final OperationCallSettings.Builder<DeleteAccessPolicyRequest, Empty, AccessContextManagerOperationMetadata> deleteAccessPolicyOperationSettings;
        private final PagedCallSettings.Builder<ListAccessLevelsRequest, ListAccessLevelsResponse, AccessContextManagerClient.ListAccessLevelsPagedResponse> listAccessLevelsSettings;
        private final UnaryCallSettings.Builder<GetAccessLevelRequest, AccessLevel> getAccessLevelSettings;
        private final UnaryCallSettings.Builder<CreateAccessLevelRequest, Operation> createAccessLevelSettings;
        private final OperationCallSettings.Builder<CreateAccessLevelRequest, AccessLevel, AccessContextManagerOperationMetadata> createAccessLevelOperationSettings;
        private final UnaryCallSettings.Builder<UpdateAccessLevelRequest, Operation> updateAccessLevelSettings;
        private final OperationCallSettings.Builder<UpdateAccessLevelRequest, AccessLevel, AccessContextManagerOperationMetadata> updateAccessLevelOperationSettings;
        private final UnaryCallSettings.Builder<DeleteAccessLevelRequest, Operation> deleteAccessLevelSettings;
        private final OperationCallSettings.Builder<DeleteAccessLevelRequest, Empty, AccessContextManagerOperationMetadata> deleteAccessLevelOperationSettings;
        private final UnaryCallSettings.Builder<ReplaceAccessLevelsRequest, Operation> replaceAccessLevelsSettings;
        private final OperationCallSettings.Builder<ReplaceAccessLevelsRequest, ReplaceAccessLevelsResponse, AccessContextManagerOperationMetadata> replaceAccessLevelsOperationSettings;
        private final PagedCallSettings.Builder<ListServicePerimetersRequest, ListServicePerimetersResponse, AccessContextManagerClient.ListServicePerimetersPagedResponse> listServicePerimetersSettings;
        private final UnaryCallSettings.Builder<GetServicePerimeterRequest, ServicePerimeter> getServicePerimeterSettings;
        private final UnaryCallSettings.Builder<CreateServicePerimeterRequest, Operation> createServicePerimeterSettings;
        private final OperationCallSettings.Builder<CreateServicePerimeterRequest, ServicePerimeter, AccessContextManagerOperationMetadata> createServicePerimeterOperationSettings;
        private final UnaryCallSettings.Builder<UpdateServicePerimeterRequest, Operation> updateServicePerimeterSettings;
        private final OperationCallSettings.Builder<UpdateServicePerimeterRequest, ServicePerimeter, AccessContextManagerOperationMetadata> updateServicePerimeterOperationSettings;
        private final UnaryCallSettings.Builder<DeleteServicePerimeterRequest, Operation> deleteServicePerimeterSettings;
        private final OperationCallSettings.Builder<DeleteServicePerimeterRequest, Empty, AccessContextManagerOperationMetadata> deleteServicePerimeterOperationSettings;
        private final UnaryCallSettings.Builder<ReplaceServicePerimetersRequest, Operation> replaceServicePerimetersSettings;
        private final OperationCallSettings.Builder<ReplaceServicePerimetersRequest, ReplaceServicePerimetersResponse, AccessContextManagerOperationMetadata> replaceServicePerimetersOperationSettings;
        private final UnaryCallSettings.Builder<CommitServicePerimetersRequest, Operation> commitServicePerimetersSettings;
        private final OperationCallSettings.Builder<CommitServicePerimetersRequest, CommitServicePerimetersResponse, AccessContextManagerOperationMetadata> commitServicePerimetersOperationSettings;
        private final PagedCallSettings.Builder<ListGcpUserAccessBindingsRequest, ListGcpUserAccessBindingsResponse, AccessContextManagerClient.ListGcpUserAccessBindingsPagedResponse> listGcpUserAccessBindingsSettings;
        private final UnaryCallSettings.Builder<GetGcpUserAccessBindingRequest, GcpUserAccessBinding> getGcpUserAccessBindingSettings;
        private final UnaryCallSettings.Builder<CreateGcpUserAccessBindingRequest, Operation> createGcpUserAccessBindingSettings;
        private final OperationCallSettings.Builder<CreateGcpUserAccessBindingRequest, GcpUserAccessBinding, GcpUserAccessBindingOperationMetadata> createGcpUserAccessBindingOperationSettings;
        private final UnaryCallSettings.Builder<UpdateGcpUserAccessBindingRequest, Operation> updateGcpUserAccessBindingSettings;
        private final OperationCallSettings.Builder<UpdateGcpUserAccessBindingRequest, GcpUserAccessBinding, GcpUserAccessBindingOperationMetadata> updateGcpUserAccessBindingOperationSettings;
        private final UnaryCallSettings.Builder<DeleteGcpUserAccessBindingRequest, Operation> deleteGcpUserAccessBindingSettings;
        private final OperationCallSettings.Builder<DeleteGcpUserAccessBindingRequest, Empty, GcpUserAccessBindingOperationMetadata> deleteGcpUserAccessBindingOperationSettings;
        private final UnaryCallSettings.Builder<SetIamPolicyRequest, Policy> setIamPolicySettings;
        private final UnaryCallSettings.Builder<GetIamPolicyRequest, Policy> getIamPolicySettings;
        private final UnaryCallSettings.Builder<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsSettings;
        private static final ImmutableMap<String, ImmutableSet<StatusCode.Code>> RETRYABLE_CODE_DEFINITIONS;
        private static final ImmutableMap<String, RetrySettings> RETRY_PARAM_DEFINITIONS;

        protected Builder() {
            this((ClientContext)null);
        }

        protected Builder(ClientContext clientContext) {
            super(clientContext);
            this.listAccessPoliciesSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_ACCESS_POLICIES_PAGE_STR_FACT);
            this.getAccessPolicySettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.createAccessPolicySettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.createAccessPolicyOperationSettings = OperationCallSettings.newBuilder();
            this.updateAccessPolicySettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.updateAccessPolicyOperationSettings = OperationCallSettings.newBuilder();
            this.deleteAccessPolicySettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.deleteAccessPolicyOperationSettings = OperationCallSettings.newBuilder();
            this.listAccessLevelsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_ACCESS_LEVELS_PAGE_STR_FACT);
            this.getAccessLevelSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.createAccessLevelSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.createAccessLevelOperationSettings = OperationCallSettings.newBuilder();
            this.updateAccessLevelSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.updateAccessLevelOperationSettings = OperationCallSettings.newBuilder();
            this.deleteAccessLevelSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.deleteAccessLevelOperationSettings = OperationCallSettings.newBuilder();
            this.replaceAccessLevelsSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.replaceAccessLevelsOperationSettings = OperationCallSettings.newBuilder();
            this.listServicePerimetersSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_SERVICE_PERIMETERS_PAGE_STR_FACT);
            this.getServicePerimeterSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.createServicePerimeterSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.createServicePerimeterOperationSettings = OperationCallSettings.newBuilder();
            this.updateServicePerimeterSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.updateServicePerimeterOperationSettings = OperationCallSettings.newBuilder();
            this.deleteServicePerimeterSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.deleteServicePerimeterOperationSettings = OperationCallSettings.newBuilder();
            this.replaceServicePerimetersSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.replaceServicePerimetersOperationSettings = OperationCallSettings.newBuilder();
            this.commitServicePerimetersSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.commitServicePerimetersOperationSettings = OperationCallSettings.newBuilder();
            this.listGcpUserAccessBindingsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_GCP_USER_ACCESS_BINDINGS_PAGE_STR_FACT);
            this.getGcpUserAccessBindingSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.createGcpUserAccessBindingSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.createGcpUserAccessBindingOperationSettings = OperationCallSettings.newBuilder();
            this.updateGcpUserAccessBindingSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.updateGcpUserAccessBindingOperationSettings = OperationCallSettings.newBuilder();
            this.deleteGcpUserAccessBindingSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.deleteGcpUserAccessBindingOperationSettings = OperationCallSettings.newBuilder();
            this.setIamPolicySettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.getIamPolicySettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.testIamPermissionsSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.listAccessPoliciesSettings, this.getAccessPolicySettings, this.createAccessPolicySettings, this.updateAccessPolicySettings, this.deleteAccessPolicySettings, this.listAccessLevelsSettings, this.getAccessLevelSettings, this.createAccessLevelSettings, this.updateAccessLevelSettings, this.deleteAccessLevelSettings, this.replaceAccessLevelsSettings, this.listServicePerimetersSettings, (Object[])new UnaryCallSettings.Builder[]{this.getServicePerimeterSettings, this.createServicePerimeterSettings, this.updateServicePerimeterSettings, this.deleteServicePerimeterSettings, this.replaceServicePerimetersSettings, this.commitServicePerimetersSettings, this.listGcpUserAccessBindingsSettings, this.getGcpUserAccessBindingSettings, this.createGcpUserAccessBindingSettings, this.updateGcpUserAccessBindingSettings, this.deleteGcpUserAccessBindingSettings, this.setIamPolicySettings, this.getIamPolicySettings, this.testIamPermissionsSettings});
            Builder.initDefaults(this);
        }

        protected Builder(AccessContextManagerStubSettings settings) {
            super((StubSettings)settings);
            this.listAccessPoliciesSettings = settings.listAccessPoliciesSettings.toBuilder();
            this.getAccessPolicySettings = settings.getAccessPolicySettings.toBuilder();
            this.createAccessPolicySettings = settings.createAccessPolicySettings.toBuilder();
            this.createAccessPolicyOperationSettings = settings.createAccessPolicyOperationSettings.toBuilder();
            this.updateAccessPolicySettings = settings.updateAccessPolicySettings.toBuilder();
            this.updateAccessPolicyOperationSettings = settings.updateAccessPolicyOperationSettings.toBuilder();
            this.deleteAccessPolicySettings = settings.deleteAccessPolicySettings.toBuilder();
            this.deleteAccessPolicyOperationSettings = settings.deleteAccessPolicyOperationSettings.toBuilder();
            this.listAccessLevelsSettings = settings.listAccessLevelsSettings.toBuilder();
            this.getAccessLevelSettings = settings.getAccessLevelSettings.toBuilder();
            this.createAccessLevelSettings = settings.createAccessLevelSettings.toBuilder();
            this.createAccessLevelOperationSettings = settings.createAccessLevelOperationSettings.toBuilder();
            this.updateAccessLevelSettings = settings.updateAccessLevelSettings.toBuilder();
            this.updateAccessLevelOperationSettings = settings.updateAccessLevelOperationSettings.toBuilder();
            this.deleteAccessLevelSettings = settings.deleteAccessLevelSettings.toBuilder();
            this.deleteAccessLevelOperationSettings = settings.deleteAccessLevelOperationSettings.toBuilder();
            this.replaceAccessLevelsSettings = settings.replaceAccessLevelsSettings.toBuilder();
            this.replaceAccessLevelsOperationSettings = settings.replaceAccessLevelsOperationSettings.toBuilder();
            this.listServicePerimetersSettings = settings.listServicePerimetersSettings.toBuilder();
            this.getServicePerimeterSettings = settings.getServicePerimeterSettings.toBuilder();
            this.createServicePerimeterSettings = settings.createServicePerimeterSettings.toBuilder();
            this.createServicePerimeterOperationSettings = settings.createServicePerimeterOperationSettings.toBuilder();
            this.updateServicePerimeterSettings = settings.updateServicePerimeterSettings.toBuilder();
            this.updateServicePerimeterOperationSettings = settings.updateServicePerimeterOperationSettings.toBuilder();
            this.deleteServicePerimeterSettings = settings.deleteServicePerimeterSettings.toBuilder();
            this.deleteServicePerimeterOperationSettings = settings.deleteServicePerimeterOperationSettings.toBuilder();
            this.replaceServicePerimetersSettings = settings.replaceServicePerimetersSettings.toBuilder();
            this.replaceServicePerimetersOperationSettings = settings.replaceServicePerimetersOperationSettings.toBuilder();
            this.commitServicePerimetersSettings = settings.commitServicePerimetersSettings.toBuilder();
            this.commitServicePerimetersOperationSettings = settings.commitServicePerimetersOperationSettings.toBuilder();
            this.listGcpUserAccessBindingsSettings = settings.listGcpUserAccessBindingsSettings.toBuilder();
            this.getGcpUserAccessBindingSettings = settings.getGcpUserAccessBindingSettings.toBuilder();
            this.createGcpUserAccessBindingSettings = settings.createGcpUserAccessBindingSettings.toBuilder();
            this.createGcpUserAccessBindingOperationSettings = settings.createGcpUserAccessBindingOperationSettings.toBuilder();
            this.updateGcpUserAccessBindingSettings = settings.updateGcpUserAccessBindingSettings.toBuilder();
            this.updateGcpUserAccessBindingOperationSettings = settings.updateGcpUserAccessBindingOperationSettings.toBuilder();
            this.deleteGcpUserAccessBindingSettings = settings.deleteGcpUserAccessBindingSettings.toBuilder();
            this.deleteGcpUserAccessBindingOperationSettings = settings.deleteGcpUserAccessBindingOperationSettings.toBuilder();
            this.setIamPolicySettings = settings.setIamPolicySettings.toBuilder();
            this.getIamPolicySettings = settings.getIamPolicySettings.toBuilder();
            this.testIamPermissionsSettings = settings.testIamPermissionsSettings.toBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.listAccessPoliciesSettings, this.getAccessPolicySettings, this.createAccessPolicySettings, this.updateAccessPolicySettings, this.deleteAccessPolicySettings, this.listAccessLevelsSettings, this.getAccessLevelSettings, this.createAccessLevelSettings, this.updateAccessLevelSettings, this.deleteAccessLevelSettings, this.replaceAccessLevelsSettings, this.listServicePerimetersSettings, (Object[])new UnaryCallSettings.Builder[]{this.getServicePerimeterSettings, this.createServicePerimeterSettings, this.updateServicePerimeterSettings, this.deleteServicePerimeterSettings, this.replaceServicePerimetersSettings, this.commitServicePerimetersSettings, this.listGcpUserAccessBindingsSettings, this.getGcpUserAccessBindingSettings, this.createGcpUserAccessBindingSettings, this.updateGcpUserAccessBindingSettings, this.deleteGcpUserAccessBindingSettings, this.setIamPolicySettings, this.getIamPolicySettings, this.testIamPermissionsSettings});
        }

        private static Builder createDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider(AccessContextManagerStubSettings.defaultTransportChannelProvider());
            builder.setCredentialsProvider((CredentialsProvider)AccessContextManagerStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)AccessContextManagerStubSettings.defaultApiClientHeaderProviderBuilder().build());
            builder.setEndpoint(AccessContextManagerStubSettings.getDefaultEndpoint());
            builder.setMtlsEndpoint(AccessContextManagerStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder createHttpJsonDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider((TransportChannelProvider)AccessContextManagerStubSettings.defaultHttpJsonTransportProviderBuilder().build());
            builder.setCredentialsProvider((CredentialsProvider)AccessContextManagerStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)AccessContextManagerStubSettings.defaultHttpJsonApiClientHeaderProviderBuilder().build());
            builder.setEndpoint(AccessContextManagerStubSettings.getDefaultEndpoint());
            builder.setMtlsEndpoint(AccessContextManagerStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder initDefaults(Builder builder) {
            builder.listAccessPoliciesSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_0_params"));
            builder.getAccessPolicySettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_0_params"));
            builder.createAccessPolicySettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_0_params"));
            builder.updateAccessPolicySettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_0_params"));
            builder.deleteAccessPolicySettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_0_params"));
            builder.listAccessLevelsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_0_params"));
            builder.getAccessLevelSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_0_params"));
            builder.createAccessLevelSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_0_params"));
            builder.updateAccessLevelSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_0_params"));
            builder.deleteAccessLevelSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_0_params"));
            builder.replaceAccessLevelsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_0_params"));
            builder.listServicePerimetersSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_0_params"));
            builder.getServicePerimeterSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_0_params"));
            builder.createServicePerimeterSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_0_params"));
            builder.updateServicePerimeterSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_0_params"));
            builder.deleteServicePerimeterSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_0_params"));
            builder.replaceServicePerimetersSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_0_params"));
            builder.commitServicePerimetersSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_0_params"));
            builder.listGcpUserAccessBindingsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_0_params"));
            builder.getGcpUserAccessBindingSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_0_params"));
            builder.createGcpUserAccessBindingSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_0_params"));
            builder.updateGcpUserAccessBindingSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_0_params"));
            builder.deleteGcpUserAccessBindingSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_0_params"));
            builder.setIamPolicySettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_0_params"));
            builder.getIamPolicySettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_0_params"));
            builder.testIamPermissionsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_0_params"));
            builder.createAccessPolicyOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_0_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(AccessPolicy.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(AccessContextManagerOperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            builder.updateAccessPolicyOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_0_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(AccessPolicy.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(AccessContextManagerOperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            builder.deleteAccessPolicyOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_0_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Empty.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(AccessContextManagerOperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            builder.createAccessLevelOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_0_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(AccessLevel.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(AccessContextManagerOperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            builder.updateAccessLevelOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_0_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(AccessLevel.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(AccessContextManagerOperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            builder.deleteAccessLevelOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_0_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Empty.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(AccessContextManagerOperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            builder.replaceAccessLevelsOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_0_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(ReplaceAccessLevelsResponse.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(AccessContextManagerOperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            builder.createServicePerimeterOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_0_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(ServicePerimeter.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(AccessContextManagerOperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            builder.updateServicePerimeterOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_0_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(ServicePerimeter.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(AccessContextManagerOperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            builder.deleteServicePerimeterOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_0_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Empty.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(AccessContextManagerOperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            builder.replaceServicePerimetersOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_0_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(ReplaceServicePerimetersResponse.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(AccessContextManagerOperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            builder.commitServicePerimetersOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_0_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(CommitServicePerimetersResponse.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(AccessContextManagerOperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            builder.createGcpUserAccessBindingOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_0_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(GcpUserAccessBinding.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(GcpUserAccessBindingOperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            builder.updateGcpUserAccessBindingOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_0_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(GcpUserAccessBinding.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(GcpUserAccessBindingOperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            builder.deleteGcpUserAccessBindingOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_0_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Empty.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(GcpUserAccessBindingOperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            return builder;
        }

        public Builder applyToAllUnaryMethods(ApiFunction<UnaryCallSettings.Builder<?, ?>, Void> settingsUpdater) {
            StubSettings.Builder.applyToAllUnaryMethods(this.unaryMethodSettingsBuilders, settingsUpdater);
            return this;
        }

        public ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders() {
            return this.unaryMethodSettingsBuilders;
        }

        public PagedCallSettings.Builder<ListAccessPoliciesRequest, ListAccessPoliciesResponse, AccessContextManagerClient.ListAccessPoliciesPagedResponse> listAccessPoliciesSettings() {
            return this.listAccessPoliciesSettings;
        }

        public UnaryCallSettings.Builder<GetAccessPolicyRequest, AccessPolicy> getAccessPolicySettings() {
            return this.getAccessPolicySettings;
        }

        public UnaryCallSettings.Builder<AccessPolicy, Operation> createAccessPolicySettings() {
            return this.createAccessPolicySettings;
        }

        @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
        public OperationCallSettings.Builder<AccessPolicy, AccessPolicy, AccessContextManagerOperationMetadata> createAccessPolicyOperationSettings() {
            return this.createAccessPolicyOperationSettings;
        }

        public UnaryCallSettings.Builder<UpdateAccessPolicyRequest, Operation> updateAccessPolicySettings() {
            return this.updateAccessPolicySettings;
        }

        @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
        public OperationCallSettings.Builder<UpdateAccessPolicyRequest, AccessPolicy, AccessContextManagerOperationMetadata> updateAccessPolicyOperationSettings() {
            return this.updateAccessPolicyOperationSettings;
        }

        public UnaryCallSettings.Builder<DeleteAccessPolicyRequest, Operation> deleteAccessPolicySettings() {
            return this.deleteAccessPolicySettings;
        }

        @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
        public OperationCallSettings.Builder<DeleteAccessPolicyRequest, Empty, AccessContextManagerOperationMetadata> deleteAccessPolicyOperationSettings() {
            return this.deleteAccessPolicyOperationSettings;
        }

        public PagedCallSettings.Builder<ListAccessLevelsRequest, ListAccessLevelsResponse, AccessContextManagerClient.ListAccessLevelsPagedResponse> listAccessLevelsSettings() {
            return this.listAccessLevelsSettings;
        }

        public UnaryCallSettings.Builder<GetAccessLevelRequest, AccessLevel> getAccessLevelSettings() {
            return this.getAccessLevelSettings;
        }

        public UnaryCallSettings.Builder<CreateAccessLevelRequest, Operation> createAccessLevelSettings() {
            return this.createAccessLevelSettings;
        }

        @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
        public OperationCallSettings.Builder<CreateAccessLevelRequest, AccessLevel, AccessContextManagerOperationMetadata> createAccessLevelOperationSettings() {
            return this.createAccessLevelOperationSettings;
        }

        public UnaryCallSettings.Builder<UpdateAccessLevelRequest, Operation> updateAccessLevelSettings() {
            return this.updateAccessLevelSettings;
        }

        @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
        public OperationCallSettings.Builder<UpdateAccessLevelRequest, AccessLevel, AccessContextManagerOperationMetadata> updateAccessLevelOperationSettings() {
            return this.updateAccessLevelOperationSettings;
        }

        public UnaryCallSettings.Builder<DeleteAccessLevelRequest, Operation> deleteAccessLevelSettings() {
            return this.deleteAccessLevelSettings;
        }

        @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
        public OperationCallSettings.Builder<DeleteAccessLevelRequest, Empty, AccessContextManagerOperationMetadata> deleteAccessLevelOperationSettings() {
            return this.deleteAccessLevelOperationSettings;
        }

        public UnaryCallSettings.Builder<ReplaceAccessLevelsRequest, Operation> replaceAccessLevelsSettings() {
            return this.replaceAccessLevelsSettings;
        }

        @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
        public OperationCallSettings.Builder<ReplaceAccessLevelsRequest, ReplaceAccessLevelsResponse, AccessContextManagerOperationMetadata> replaceAccessLevelsOperationSettings() {
            return this.replaceAccessLevelsOperationSettings;
        }

        public PagedCallSettings.Builder<ListServicePerimetersRequest, ListServicePerimetersResponse, AccessContextManagerClient.ListServicePerimetersPagedResponse> listServicePerimetersSettings() {
            return this.listServicePerimetersSettings;
        }

        public UnaryCallSettings.Builder<GetServicePerimeterRequest, ServicePerimeter> getServicePerimeterSettings() {
            return this.getServicePerimeterSettings;
        }

        public UnaryCallSettings.Builder<CreateServicePerimeterRequest, Operation> createServicePerimeterSettings() {
            return this.createServicePerimeterSettings;
        }

        @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
        public OperationCallSettings.Builder<CreateServicePerimeterRequest, ServicePerimeter, AccessContextManagerOperationMetadata> createServicePerimeterOperationSettings() {
            return this.createServicePerimeterOperationSettings;
        }

        public UnaryCallSettings.Builder<UpdateServicePerimeterRequest, Operation> updateServicePerimeterSettings() {
            return this.updateServicePerimeterSettings;
        }

        @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
        public OperationCallSettings.Builder<UpdateServicePerimeterRequest, ServicePerimeter, AccessContextManagerOperationMetadata> updateServicePerimeterOperationSettings() {
            return this.updateServicePerimeterOperationSettings;
        }

        public UnaryCallSettings.Builder<DeleteServicePerimeterRequest, Operation> deleteServicePerimeterSettings() {
            return this.deleteServicePerimeterSettings;
        }

        @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
        public OperationCallSettings.Builder<DeleteServicePerimeterRequest, Empty, AccessContextManagerOperationMetadata> deleteServicePerimeterOperationSettings() {
            return this.deleteServicePerimeterOperationSettings;
        }

        public UnaryCallSettings.Builder<ReplaceServicePerimetersRequest, Operation> replaceServicePerimetersSettings() {
            return this.replaceServicePerimetersSettings;
        }

        @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
        public OperationCallSettings.Builder<ReplaceServicePerimetersRequest, ReplaceServicePerimetersResponse, AccessContextManagerOperationMetadata> replaceServicePerimetersOperationSettings() {
            return this.replaceServicePerimetersOperationSettings;
        }

        public UnaryCallSettings.Builder<CommitServicePerimetersRequest, Operation> commitServicePerimetersSettings() {
            return this.commitServicePerimetersSettings;
        }

        @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
        public OperationCallSettings.Builder<CommitServicePerimetersRequest, CommitServicePerimetersResponse, AccessContextManagerOperationMetadata> commitServicePerimetersOperationSettings() {
            return this.commitServicePerimetersOperationSettings;
        }

        public PagedCallSettings.Builder<ListGcpUserAccessBindingsRequest, ListGcpUserAccessBindingsResponse, AccessContextManagerClient.ListGcpUserAccessBindingsPagedResponse> listGcpUserAccessBindingsSettings() {
            return this.listGcpUserAccessBindingsSettings;
        }

        public UnaryCallSettings.Builder<GetGcpUserAccessBindingRequest, GcpUserAccessBinding> getGcpUserAccessBindingSettings() {
            return this.getGcpUserAccessBindingSettings;
        }

        public UnaryCallSettings.Builder<CreateGcpUserAccessBindingRequest, Operation> createGcpUserAccessBindingSettings() {
            return this.createGcpUserAccessBindingSettings;
        }

        @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
        public OperationCallSettings.Builder<CreateGcpUserAccessBindingRequest, GcpUserAccessBinding, GcpUserAccessBindingOperationMetadata> createGcpUserAccessBindingOperationSettings() {
            return this.createGcpUserAccessBindingOperationSettings;
        }

        public UnaryCallSettings.Builder<UpdateGcpUserAccessBindingRequest, Operation> updateGcpUserAccessBindingSettings() {
            return this.updateGcpUserAccessBindingSettings;
        }

        @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
        public OperationCallSettings.Builder<UpdateGcpUserAccessBindingRequest, GcpUserAccessBinding, GcpUserAccessBindingOperationMetadata> updateGcpUserAccessBindingOperationSettings() {
            return this.updateGcpUserAccessBindingOperationSettings;
        }

        public UnaryCallSettings.Builder<DeleteGcpUserAccessBindingRequest, Operation> deleteGcpUserAccessBindingSettings() {
            return this.deleteGcpUserAccessBindingSettings;
        }

        @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
        public OperationCallSettings.Builder<DeleteGcpUserAccessBindingRequest, Empty, GcpUserAccessBindingOperationMetadata> deleteGcpUserAccessBindingOperationSettings() {
            return this.deleteGcpUserAccessBindingOperationSettings;
        }

        public UnaryCallSettings.Builder<SetIamPolicyRequest, Policy> setIamPolicySettings() {
            return this.setIamPolicySettings;
        }

        public UnaryCallSettings.Builder<GetIamPolicyRequest, Policy> getIamPolicySettings() {
            return this.getIamPolicySettings;
        }

        public UnaryCallSettings.Builder<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsSettings() {
            return this.testIamPermissionsSettings;
        }

        public AccessContextManagerStubSettings build() throws IOException {
            return new AccessContextManagerStubSettings(this);
        }

        static {
            ImmutableMap.Builder definitions = ImmutableMap.builder();
            definitions.put((Object)"no_retry_0_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList()));
            RETRYABLE_CODE_DEFINITIONS = definitions.build();
            definitions = ImmutableMap.builder();
            RetrySettings settings = null;
            settings = RetrySettings.newBuilder().setInitialRpcTimeout(Duration.ofMillis((long)60000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ofMillis((long)60000L)).setTotalTimeout(Duration.ofMillis((long)60000L)).build();
            definitions.put((Object)"no_retry_0_params", (Object)settings);
            RETRY_PARAM_DEFINITIONS = definitions.build();
        }
    }
}

