/*
 * Decompiled with CFR 0.152.
 */
package com.google.iam.v3beta.stub;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.BetaApi;
import com.google.api.core.ObsoleteApi;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.GaxProperties;
import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.api.gax.grpc.GaxGrpcProperties;
import com.google.api.gax.grpc.GrpcTransportChannel;
import com.google.api.gax.grpc.InstantiatingGrpcChannelProvider;
import com.google.api.gax.grpc.ProtoOperationTransformers;
import com.google.api.gax.httpjson.GaxHttpJsonProperties;
import com.google.api.gax.httpjson.HttpJsonTransportChannel;
import com.google.api.gax.httpjson.InstantiatingHttpJsonChannelProvider;
import com.google.api.gax.longrunning.OperationTimedPollAlgorithm;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.retrying.TimedRetryAlgorithm;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.OperationCallSettings;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.PagedCallSettings;
import com.google.api.gax.rpc.PagedListDescriptor;
import com.google.api.gax.rpc.PagedListResponseFactory;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.iam.v3beta.CreatePolicyBindingRequest;
import com.google.iam.v3beta.DeletePolicyBindingRequest;
import com.google.iam.v3beta.GetPolicyBindingRequest;
import com.google.iam.v3beta.ListPolicyBindingsRequest;
import com.google.iam.v3beta.ListPolicyBindingsResponse;
import com.google.iam.v3beta.OperationMetadata;
import com.google.iam.v3beta.PolicyBinding;
import com.google.iam.v3beta.PolicyBindingsClient;
import com.google.iam.v3beta.SearchTargetPolicyBindingsRequest;
import com.google.iam.v3beta.SearchTargetPolicyBindingsResponse;
import com.google.iam.v3beta.UpdatePolicyBindingRequest;
import com.google.iam.v3beta.stub.GrpcPolicyBindingsStub;
import com.google.iam.v3beta.stub.HttpJsonPolicyBindingsStub;
import com.google.iam.v3beta.stub.PolicyBindingsStub;
import com.google.longrunning.Operation;
import com.google.protobuf.Empty;
import java.io.IOException;
import java.time.Duration;
import java.util.Collection;
import java.util.List;
import java.util.Set;

@BetaApi
public class PolicyBindingsStubSettings
extends StubSettings<PolicyBindingsStubSettings> {
    private static final ImmutableList<String> DEFAULT_SERVICE_SCOPES = ImmutableList.builder().add((Object)"https://www.googleapis.com/auth/cloud-platform").build();
    private final UnaryCallSettings<CreatePolicyBindingRequest, Operation> createPolicyBindingSettings;
    private final OperationCallSettings<CreatePolicyBindingRequest, PolicyBinding, OperationMetadata> createPolicyBindingOperationSettings;
    private final UnaryCallSettings<GetPolicyBindingRequest, PolicyBinding> getPolicyBindingSettings;
    private final UnaryCallSettings<UpdatePolicyBindingRequest, Operation> updatePolicyBindingSettings;
    private final OperationCallSettings<UpdatePolicyBindingRequest, PolicyBinding, OperationMetadata> updatePolicyBindingOperationSettings;
    private final UnaryCallSettings<DeletePolicyBindingRequest, Operation> deletePolicyBindingSettings;
    private final OperationCallSettings<DeletePolicyBindingRequest, Empty, OperationMetadata> deletePolicyBindingOperationSettings;
    private final PagedCallSettings<ListPolicyBindingsRequest, ListPolicyBindingsResponse, PolicyBindingsClient.ListPolicyBindingsPagedResponse> listPolicyBindingsSettings;
    private final PagedCallSettings<SearchTargetPolicyBindingsRequest, SearchTargetPolicyBindingsResponse, PolicyBindingsClient.SearchTargetPolicyBindingsPagedResponse> searchTargetPolicyBindingsSettings;
    private static final PagedListDescriptor<ListPolicyBindingsRequest, ListPolicyBindingsResponse, PolicyBinding> LIST_POLICY_BINDINGS_PAGE_STR_DESC = new PagedListDescriptor<ListPolicyBindingsRequest, ListPolicyBindingsResponse, PolicyBinding>(){

        public String emptyToken() {
            return "";
        }

        public ListPolicyBindingsRequest injectToken(ListPolicyBindingsRequest payload, String token) {
            return ListPolicyBindingsRequest.newBuilder((ListPolicyBindingsRequest)payload).setPageToken(token).build();
        }

        public ListPolicyBindingsRequest injectPageSize(ListPolicyBindingsRequest payload, int pageSize) {
            return ListPolicyBindingsRequest.newBuilder((ListPolicyBindingsRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListPolicyBindingsRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListPolicyBindingsResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<PolicyBinding> extractResources(ListPolicyBindingsResponse payload) {
            return payload.getPolicyBindingsList();
        }
    };
    private static final PagedListDescriptor<SearchTargetPolicyBindingsRequest, SearchTargetPolicyBindingsResponse, PolicyBinding> SEARCH_TARGET_POLICY_BINDINGS_PAGE_STR_DESC = new PagedListDescriptor<SearchTargetPolicyBindingsRequest, SearchTargetPolicyBindingsResponse, PolicyBinding>(){

        public String emptyToken() {
            return "";
        }

        public SearchTargetPolicyBindingsRequest injectToken(SearchTargetPolicyBindingsRequest payload, String token) {
            return SearchTargetPolicyBindingsRequest.newBuilder((SearchTargetPolicyBindingsRequest)payload).setPageToken(token).build();
        }

        public SearchTargetPolicyBindingsRequest injectPageSize(SearchTargetPolicyBindingsRequest payload, int pageSize) {
            return SearchTargetPolicyBindingsRequest.newBuilder((SearchTargetPolicyBindingsRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(SearchTargetPolicyBindingsRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(SearchTargetPolicyBindingsResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<PolicyBinding> extractResources(SearchTargetPolicyBindingsResponse payload) {
            return payload.getPolicyBindingsList();
        }
    };
    private static final PagedListResponseFactory<ListPolicyBindingsRequest, ListPolicyBindingsResponse, PolicyBindingsClient.ListPolicyBindingsPagedResponse> LIST_POLICY_BINDINGS_PAGE_STR_FACT = new PagedListResponseFactory<ListPolicyBindingsRequest, ListPolicyBindingsResponse, PolicyBindingsClient.ListPolicyBindingsPagedResponse>(){

        public ApiFuture<PolicyBindingsClient.ListPolicyBindingsPagedResponse> getFuturePagedResponse(UnaryCallable<ListPolicyBindingsRequest, ListPolicyBindingsResponse> callable, ListPolicyBindingsRequest request, ApiCallContext context, ApiFuture<ListPolicyBindingsResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_POLICY_BINDINGS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return PolicyBindingsClient.ListPolicyBindingsPagedResponse.createAsync((PageContext<ListPolicyBindingsRequest, ListPolicyBindingsResponse, PolicyBinding>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<SearchTargetPolicyBindingsRequest, SearchTargetPolicyBindingsResponse, PolicyBindingsClient.SearchTargetPolicyBindingsPagedResponse> SEARCH_TARGET_POLICY_BINDINGS_PAGE_STR_FACT = new PagedListResponseFactory<SearchTargetPolicyBindingsRequest, SearchTargetPolicyBindingsResponse, PolicyBindingsClient.SearchTargetPolicyBindingsPagedResponse>(){

        public ApiFuture<PolicyBindingsClient.SearchTargetPolicyBindingsPagedResponse> getFuturePagedResponse(UnaryCallable<SearchTargetPolicyBindingsRequest, SearchTargetPolicyBindingsResponse> callable, SearchTargetPolicyBindingsRequest request, ApiCallContext context, ApiFuture<SearchTargetPolicyBindingsResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)SEARCH_TARGET_POLICY_BINDINGS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return PolicyBindingsClient.SearchTargetPolicyBindingsPagedResponse.createAsync((PageContext<SearchTargetPolicyBindingsRequest, SearchTargetPolicyBindingsResponse, PolicyBinding>)pageContext, futureResponse);
        }
    };

    public UnaryCallSettings<CreatePolicyBindingRequest, Operation> createPolicyBindingSettings() {
        return this.createPolicyBindingSettings;
    }

    public OperationCallSettings<CreatePolicyBindingRequest, PolicyBinding, OperationMetadata> createPolicyBindingOperationSettings() {
        return this.createPolicyBindingOperationSettings;
    }

    public UnaryCallSettings<GetPolicyBindingRequest, PolicyBinding> getPolicyBindingSettings() {
        return this.getPolicyBindingSettings;
    }

    public UnaryCallSettings<UpdatePolicyBindingRequest, Operation> updatePolicyBindingSettings() {
        return this.updatePolicyBindingSettings;
    }

    public OperationCallSettings<UpdatePolicyBindingRequest, PolicyBinding, OperationMetadata> updatePolicyBindingOperationSettings() {
        return this.updatePolicyBindingOperationSettings;
    }

    public UnaryCallSettings<DeletePolicyBindingRequest, Operation> deletePolicyBindingSettings() {
        return this.deletePolicyBindingSettings;
    }

    public OperationCallSettings<DeletePolicyBindingRequest, Empty, OperationMetadata> deletePolicyBindingOperationSettings() {
        return this.deletePolicyBindingOperationSettings;
    }

    public PagedCallSettings<ListPolicyBindingsRequest, ListPolicyBindingsResponse, PolicyBindingsClient.ListPolicyBindingsPagedResponse> listPolicyBindingsSettings() {
        return this.listPolicyBindingsSettings;
    }

    public PagedCallSettings<SearchTargetPolicyBindingsRequest, SearchTargetPolicyBindingsResponse, PolicyBindingsClient.SearchTargetPolicyBindingsPagedResponse> searchTargetPolicyBindingsSettings() {
        return this.searchTargetPolicyBindingsSettings;
    }

    public PolicyBindingsStub createStub() throws IOException {
        if (this.getTransportChannelProvider().getTransportName().equals(GrpcTransportChannel.getGrpcTransportName())) {
            return GrpcPolicyBindingsStub.create(this);
        }
        if (this.getTransportChannelProvider().getTransportName().equals(HttpJsonTransportChannel.getHttpJsonTransportName())) {
            return HttpJsonPolicyBindingsStub.create(this);
        }
        throw new UnsupportedOperationException(String.format("Transport not supported: %s", this.getTransportChannelProvider().getTransportName()));
    }

    public String getServiceName() {
        return "iam";
    }

    public static InstantiatingExecutorProvider.Builder defaultExecutorProviderBuilder() {
        return InstantiatingExecutorProvider.newBuilder();
    }

    @ObsoleteApi(value="Use getEndpoint() instead")
    public static String getDefaultEndpoint() {
        return "iam.googleapis.com:443";
    }

    public static String getDefaultMtlsEndpoint() {
        return "iam.mtls.googleapis.com:443";
    }

    public static List<String> getDefaultServiceScopes() {
        return DEFAULT_SERVICE_SCOPES;
    }

    public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
        return GoogleCredentialsProvider.newBuilder().setScopesToApply(DEFAULT_SERVICE_SCOPES).setUseJwtAccessWithScope(true);
    }

    public static InstantiatingGrpcChannelProvider.Builder defaultGrpcTransportProviderBuilder() {
        return InstantiatingGrpcChannelProvider.newBuilder().setMaxInboundMessageSize(Integer.valueOf(Integer.MAX_VALUE));
    }

    @BetaApi
    public static InstantiatingHttpJsonChannelProvider.Builder defaultHttpJsonTransportProviderBuilder() {
        return InstantiatingHttpJsonChannelProvider.newBuilder();
    }

    public static TransportChannelProvider defaultTransportChannelProvider() {
        return PolicyBindingsStubSettings.defaultGrpcTransportProviderBuilder().build();
    }

    public static ApiClientHeaderProvider.Builder defaultGrpcApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(PolicyBindingsStubSettings.class)).setTransportToken(GaxGrpcProperties.getGrpcTokenName(), GaxGrpcProperties.getGrpcVersion());
    }

    public static ApiClientHeaderProvider.Builder defaultHttpJsonApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(PolicyBindingsStubSettings.class)).setTransportToken(GaxHttpJsonProperties.getHttpJsonTokenName(), GaxHttpJsonProperties.getHttpJsonVersion());
    }

    public static ApiClientHeaderProvider.Builder defaultApiClientHeaderProviderBuilder() {
        return PolicyBindingsStubSettings.defaultGrpcApiClientHeaderProviderBuilder();
    }

    public static Builder newBuilder() {
        return Builder.createDefault();
    }

    public static Builder newHttpJsonBuilder() {
        return Builder.createHttpJsonDefault();
    }

    public static Builder newBuilder(ClientContext clientContext) {
        return new Builder(clientContext);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    protected PolicyBindingsStubSettings(Builder settingsBuilder) throws IOException {
        super((StubSettings.Builder)settingsBuilder);
        this.createPolicyBindingSettings = settingsBuilder.createPolicyBindingSettings().build();
        this.createPolicyBindingOperationSettings = settingsBuilder.createPolicyBindingOperationSettings().build();
        this.getPolicyBindingSettings = settingsBuilder.getPolicyBindingSettings().build();
        this.updatePolicyBindingSettings = settingsBuilder.updatePolicyBindingSettings().build();
        this.updatePolicyBindingOperationSettings = settingsBuilder.updatePolicyBindingOperationSettings().build();
        this.deletePolicyBindingSettings = settingsBuilder.deletePolicyBindingSettings().build();
        this.deletePolicyBindingOperationSettings = settingsBuilder.deletePolicyBindingOperationSettings().build();
        this.listPolicyBindingsSettings = settingsBuilder.listPolicyBindingsSettings().build();
        this.searchTargetPolicyBindingsSettings = settingsBuilder.searchTargetPolicyBindingsSettings().build();
    }

    public static class Builder
    extends StubSettings.Builder<PolicyBindingsStubSettings, Builder> {
        private final ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders;
        private final UnaryCallSettings.Builder<CreatePolicyBindingRequest, Operation> createPolicyBindingSettings;
        private final OperationCallSettings.Builder<CreatePolicyBindingRequest, PolicyBinding, OperationMetadata> createPolicyBindingOperationSettings;
        private final UnaryCallSettings.Builder<GetPolicyBindingRequest, PolicyBinding> getPolicyBindingSettings;
        private final UnaryCallSettings.Builder<UpdatePolicyBindingRequest, Operation> updatePolicyBindingSettings;
        private final OperationCallSettings.Builder<UpdatePolicyBindingRequest, PolicyBinding, OperationMetadata> updatePolicyBindingOperationSettings;
        private final UnaryCallSettings.Builder<DeletePolicyBindingRequest, Operation> deletePolicyBindingSettings;
        private final OperationCallSettings.Builder<DeletePolicyBindingRequest, Empty, OperationMetadata> deletePolicyBindingOperationSettings;
        private final PagedCallSettings.Builder<ListPolicyBindingsRequest, ListPolicyBindingsResponse, PolicyBindingsClient.ListPolicyBindingsPagedResponse> listPolicyBindingsSettings;
        private final PagedCallSettings.Builder<SearchTargetPolicyBindingsRequest, SearchTargetPolicyBindingsResponse, PolicyBindingsClient.SearchTargetPolicyBindingsPagedResponse> searchTargetPolicyBindingsSettings;
        private static final ImmutableMap<String, ImmutableSet<StatusCode.Code>> RETRYABLE_CODE_DEFINITIONS;
        private static final ImmutableMap<String, RetrySettings> RETRY_PARAM_DEFINITIONS;

        protected Builder() {
            this((ClientContext)null);
        }

        protected Builder(ClientContext clientContext) {
            super(clientContext);
            this.createPolicyBindingSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.createPolicyBindingOperationSettings = OperationCallSettings.newBuilder();
            this.getPolicyBindingSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.updatePolicyBindingSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.updatePolicyBindingOperationSettings = OperationCallSettings.newBuilder();
            this.deletePolicyBindingSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.deletePolicyBindingOperationSettings = OperationCallSettings.newBuilder();
            this.listPolicyBindingsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_POLICY_BINDINGS_PAGE_STR_FACT);
            this.searchTargetPolicyBindingsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)SEARCH_TARGET_POLICY_BINDINGS_PAGE_STR_FACT);
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.createPolicyBindingSettings, this.getPolicyBindingSettings, this.updatePolicyBindingSettings, this.deletePolicyBindingSettings, this.listPolicyBindingsSettings, this.searchTargetPolicyBindingsSettings);
            Builder.initDefaults(this);
        }

        protected Builder(PolicyBindingsStubSettings settings) {
            super((StubSettings)settings);
            this.createPolicyBindingSettings = settings.createPolicyBindingSettings.toBuilder();
            this.createPolicyBindingOperationSettings = settings.createPolicyBindingOperationSettings.toBuilder();
            this.getPolicyBindingSettings = settings.getPolicyBindingSettings.toBuilder();
            this.updatePolicyBindingSettings = settings.updatePolicyBindingSettings.toBuilder();
            this.updatePolicyBindingOperationSettings = settings.updatePolicyBindingOperationSettings.toBuilder();
            this.deletePolicyBindingSettings = settings.deletePolicyBindingSettings.toBuilder();
            this.deletePolicyBindingOperationSettings = settings.deletePolicyBindingOperationSettings.toBuilder();
            this.listPolicyBindingsSettings = settings.listPolicyBindingsSettings.toBuilder();
            this.searchTargetPolicyBindingsSettings = settings.searchTargetPolicyBindingsSettings.toBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.createPolicyBindingSettings, this.getPolicyBindingSettings, this.updatePolicyBindingSettings, this.deletePolicyBindingSettings, this.listPolicyBindingsSettings, this.searchTargetPolicyBindingsSettings);
        }

        private static Builder createDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider(PolicyBindingsStubSettings.defaultTransportChannelProvider());
            builder.setCredentialsProvider((CredentialsProvider)PolicyBindingsStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)PolicyBindingsStubSettings.defaultApiClientHeaderProviderBuilder().build());
            builder.setMtlsEndpoint(PolicyBindingsStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder createHttpJsonDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider((TransportChannelProvider)PolicyBindingsStubSettings.defaultHttpJsonTransportProviderBuilder().build());
            builder.setCredentialsProvider((CredentialsProvider)PolicyBindingsStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)PolicyBindingsStubSettings.defaultHttpJsonApiClientHeaderProviderBuilder().build());
            builder.setMtlsEndpoint(PolicyBindingsStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder initDefaults(Builder builder) {
            builder.createPolicyBindingSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.getPolicyBindingSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.updatePolicyBindingSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.deletePolicyBindingSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.listPolicyBindingsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.searchTargetPolicyBindingsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.createPolicyBindingOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(PolicyBinding.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelayDuration(Duration.ofMillis(5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelayDuration(Duration.ofMillis(45000L)).setInitialRpcTimeoutDuration(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeoutDuration(Duration.ZERO).setTotalTimeoutDuration(Duration.ofMillis(300000L)).build()));
            builder.updatePolicyBindingOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(PolicyBinding.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelayDuration(Duration.ofMillis(5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelayDuration(Duration.ofMillis(45000L)).setInitialRpcTimeoutDuration(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeoutDuration(Duration.ZERO).setTotalTimeoutDuration(Duration.ofMillis(300000L)).build()));
            builder.deletePolicyBindingOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Empty.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelayDuration(Duration.ofMillis(5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelayDuration(Duration.ofMillis(45000L)).setInitialRpcTimeoutDuration(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeoutDuration(Duration.ZERO).setTotalTimeoutDuration(Duration.ofMillis(300000L)).build()));
            return builder;
        }

        public Builder applyToAllUnaryMethods(ApiFunction<UnaryCallSettings.Builder<?, ?>, Void> settingsUpdater) {
            StubSettings.Builder.applyToAllUnaryMethods(this.unaryMethodSettingsBuilders, settingsUpdater);
            return this;
        }

        public ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders() {
            return this.unaryMethodSettingsBuilders;
        }

        public UnaryCallSettings.Builder<CreatePolicyBindingRequest, Operation> createPolicyBindingSettings() {
            return this.createPolicyBindingSettings;
        }

        public OperationCallSettings.Builder<CreatePolicyBindingRequest, PolicyBinding, OperationMetadata> createPolicyBindingOperationSettings() {
            return this.createPolicyBindingOperationSettings;
        }

        public UnaryCallSettings.Builder<GetPolicyBindingRequest, PolicyBinding> getPolicyBindingSettings() {
            return this.getPolicyBindingSettings;
        }

        public UnaryCallSettings.Builder<UpdatePolicyBindingRequest, Operation> updatePolicyBindingSettings() {
            return this.updatePolicyBindingSettings;
        }

        public OperationCallSettings.Builder<UpdatePolicyBindingRequest, PolicyBinding, OperationMetadata> updatePolicyBindingOperationSettings() {
            return this.updatePolicyBindingOperationSettings;
        }

        public UnaryCallSettings.Builder<DeletePolicyBindingRequest, Operation> deletePolicyBindingSettings() {
            return this.deletePolicyBindingSettings;
        }

        public OperationCallSettings.Builder<DeletePolicyBindingRequest, Empty, OperationMetadata> deletePolicyBindingOperationSettings() {
            return this.deletePolicyBindingOperationSettings;
        }

        public PagedCallSettings.Builder<ListPolicyBindingsRequest, ListPolicyBindingsResponse, PolicyBindingsClient.ListPolicyBindingsPagedResponse> listPolicyBindingsSettings() {
            return this.listPolicyBindingsSettings;
        }

        public PagedCallSettings.Builder<SearchTargetPolicyBindingsRequest, SearchTargetPolicyBindingsResponse, PolicyBindingsClient.SearchTargetPolicyBindingsPagedResponse> searchTargetPolicyBindingsSettings() {
            return this.searchTargetPolicyBindingsSettings;
        }

        public PolicyBindingsStubSettings build() throws IOException {
            return new PolicyBindingsStubSettings(this);
        }

        static {
            ImmutableMap.Builder definitions = ImmutableMap.builder();
            definitions.put((Object)"no_retry_1_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList()));
            definitions.put((Object)"retry_policy_0_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList((Object[])new StatusCode.Code[]{StatusCode.Code.UNAVAILABLE})));
            RETRYABLE_CODE_DEFINITIONS = definitions.build();
            definitions = ImmutableMap.builder();
            RetrySettings settings = null;
            settings = RetrySettings.newBuilder().setInitialRpcTimeoutDuration(Duration.ofMillis(30000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeoutDuration(Duration.ofMillis(30000L)).setTotalTimeoutDuration(Duration.ofMillis(30000L)).build();
            definitions.put((Object)"no_retry_1_params", (Object)settings);
            settings = RetrySettings.newBuilder().setInitialRetryDelayDuration(Duration.ofMillis(1000L)).setRetryDelayMultiplier(1.3).setMaxRetryDelayDuration(Duration.ofMillis(10000L)).setInitialRpcTimeoutDuration(Duration.ofMillis(60000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeoutDuration(Duration.ofMillis(60000L)).setTotalTimeoutDuration(Duration.ofMillis(60000L)).build();
            definitions.put((Object)"retry_policy_0_params", (Object)settings);
            RETRY_PARAM_DEFINITIONS = definitions.build();
        }
    }
}

