/*
 * Decompiled with CFR 0.152.
 */
package com.google.iam.v2.stub;

import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.core.BackgroundResourceAggregation;
import com.google.api.gax.grpc.GrpcCallSettings;
import com.google.api.gax.grpc.GrpcStubCallableFactory;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.OperationCallable;
import com.google.api.gax.rpc.RequestParamsBuilder;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.iam.v2.CreatePolicyRequest;
import com.google.iam.v2.DeletePolicyRequest;
import com.google.iam.v2.GetPolicyRequest;
import com.google.iam.v2.ListPoliciesRequest;
import com.google.iam.v2.ListPoliciesResponse;
import com.google.iam.v2.PoliciesClient;
import com.google.iam.v2.Policy;
import com.google.iam.v2.PolicyOperationMetadata;
import com.google.iam.v2.UpdatePolicyRequest;
import com.google.iam.v2.stub.GrpcPoliciesCallableFactory;
import com.google.iam.v2.stub.PoliciesStub;
import com.google.iam.v2.stub.PoliciesStubSettings;
import com.google.longrunning.Operation;
import com.google.longrunning.stub.GrpcOperationsStub;
import com.google.longrunning.stub.OperationsStub;
import com.google.protobuf.Message;
import io.grpc.MethodDescriptor;
import io.grpc.protobuf.ProtoUtils;
import java.io.IOException;
import java.util.concurrent.TimeUnit;

public class GrpcPoliciesStub
extends PoliciesStub {
    private static final MethodDescriptor<ListPoliciesRequest, ListPoliciesResponse> listPoliciesMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.iam.v2.Policies/ListPolicies").setRequestMarshaller(ProtoUtils.marshaller((Message)ListPoliciesRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)ListPoliciesResponse.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private static final MethodDescriptor<GetPolicyRequest, Policy> getPolicyMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.iam.v2.Policies/GetPolicy").setRequestMarshaller(ProtoUtils.marshaller((Message)GetPolicyRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Policy.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private static final MethodDescriptor<CreatePolicyRequest, Operation> createPolicyMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.iam.v2.Policies/CreatePolicy").setRequestMarshaller(ProtoUtils.marshaller((Message)CreatePolicyRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Operation.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private static final MethodDescriptor<UpdatePolicyRequest, Operation> updatePolicyMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.iam.v2.Policies/UpdatePolicy").setRequestMarshaller(ProtoUtils.marshaller((Message)UpdatePolicyRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Operation.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private static final MethodDescriptor<DeletePolicyRequest, Operation> deletePolicyMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.iam.v2.Policies/DeletePolicy").setRequestMarshaller(ProtoUtils.marshaller((Message)DeletePolicyRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Operation.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private final UnaryCallable<ListPoliciesRequest, ListPoliciesResponse> listPoliciesCallable;
    private final UnaryCallable<ListPoliciesRequest, PoliciesClient.ListPoliciesPagedResponse> listPoliciesPagedCallable;
    private final UnaryCallable<GetPolicyRequest, Policy> getPolicyCallable;
    private final UnaryCallable<CreatePolicyRequest, Operation> createPolicyCallable;
    private final OperationCallable<CreatePolicyRequest, Policy, PolicyOperationMetadata> createPolicyOperationCallable;
    private final UnaryCallable<UpdatePolicyRequest, Operation> updatePolicyCallable;
    private final OperationCallable<UpdatePolicyRequest, Policy, PolicyOperationMetadata> updatePolicyOperationCallable;
    private final UnaryCallable<DeletePolicyRequest, Operation> deletePolicyCallable;
    private final OperationCallable<DeletePolicyRequest, Policy, PolicyOperationMetadata> deletePolicyOperationCallable;
    private final BackgroundResource backgroundResources;
    private final GrpcOperationsStub operationsStub;
    private final GrpcStubCallableFactory callableFactory;

    public static final GrpcPoliciesStub create(PoliciesStubSettings settings) throws IOException {
        return new GrpcPoliciesStub(settings, ClientContext.create((StubSettings)settings));
    }

    public static final GrpcPoliciesStub create(ClientContext clientContext) throws IOException {
        return new GrpcPoliciesStub(PoliciesStubSettings.newBuilder().build(), clientContext);
    }

    public static final GrpcPoliciesStub create(ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        return new GrpcPoliciesStub(PoliciesStubSettings.newBuilder().build(), clientContext, callableFactory);
    }

    protected GrpcPoliciesStub(PoliciesStubSettings settings, ClientContext clientContext) throws IOException {
        this(settings, clientContext, new GrpcPoliciesCallableFactory());
    }

    protected GrpcPoliciesStub(PoliciesStubSettings settings, ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        this.callableFactory = callableFactory;
        this.operationsStub = GrpcOperationsStub.create((ClientContext)clientContext, (GrpcStubCallableFactory)callableFactory);
        GrpcCallSettings listPoliciesTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(listPoliciesMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parent", String.valueOf(request.getParent()));
            return builder.build();
        }).build();
        GrpcCallSettings getPolicyTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(getPolicyMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        GrpcCallSettings createPolicyTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(createPolicyMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parent", String.valueOf(request.getParent()));
            return builder.build();
        }).build();
        GrpcCallSettings updatePolicyTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(updatePolicyMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("policy.name", String.valueOf(request.getPolicy().getName()));
            return builder.build();
        }).build();
        GrpcCallSettings deletePolicyTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(deletePolicyMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        this.listPoliciesCallable = callableFactory.createUnaryCallable(listPoliciesTransportSettings, settings.listPoliciesSettings(), clientContext);
        this.listPoliciesPagedCallable = callableFactory.createPagedCallable(listPoliciesTransportSettings, settings.listPoliciesSettings(), clientContext);
        this.getPolicyCallable = callableFactory.createUnaryCallable(getPolicyTransportSettings, settings.getPolicySettings(), clientContext);
        this.createPolicyCallable = callableFactory.createUnaryCallable(createPolicyTransportSettings, settings.createPolicySettings(), clientContext);
        this.createPolicyOperationCallable = callableFactory.createOperationCallable(createPolicyTransportSettings, settings.createPolicyOperationSettings(), clientContext, (OperationsStub)this.operationsStub);
        this.updatePolicyCallable = callableFactory.createUnaryCallable(updatePolicyTransportSettings, settings.updatePolicySettings(), clientContext);
        this.updatePolicyOperationCallable = callableFactory.createOperationCallable(updatePolicyTransportSettings, settings.updatePolicyOperationSettings(), clientContext, (OperationsStub)this.operationsStub);
        this.deletePolicyCallable = callableFactory.createUnaryCallable(deletePolicyTransportSettings, settings.deletePolicySettings(), clientContext);
        this.deletePolicyOperationCallable = callableFactory.createOperationCallable(deletePolicyTransportSettings, settings.deletePolicyOperationSettings(), clientContext, (OperationsStub)this.operationsStub);
        this.backgroundResources = new BackgroundResourceAggregation(clientContext.getBackgroundResources());
    }

    public GrpcOperationsStub getOperationsStub() {
        return this.operationsStub;
    }

    @Override
    public UnaryCallable<ListPoliciesRequest, ListPoliciesResponse> listPoliciesCallable() {
        return this.listPoliciesCallable;
    }

    @Override
    public UnaryCallable<ListPoliciesRequest, PoliciesClient.ListPoliciesPagedResponse> listPoliciesPagedCallable() {
        return this.listPoliciesPagedCallable;
    }

    @Override
    public UnaryCallable<GetPolicyRequest, Policy> getPolicyCallable() {
        return this.getPolicyCallable;
    }

    @Override
    public UnaryCallable<CreatePolicyRequest, Operation> createPolicyCallable() {
        return this.createPolicyCallable;
    }

    @Override
    public OperationCallable<CreatePolicyRequest, Policy, PolicyOperationMetadata> createPolicyOperationCallable() {
        return this.createPolicyOperationCallable;
    }

    @Override
    public UnaryCallable<UpdatePolicyRequest, Operation> updatePolicyCallable() {
        return this.updatePolicyCallable;
    }

    @Override
    public OperationCallable<UpdatePolicyRequest, Policy, PolicyOperationMetadata> updatePolicyOperationCallable() {
        return this.updatePolicyOperationCallable;
    }

    @Override
    public UnaryCallable<DeletePolicyRequest, Operation> deletePolicyCallable() {
        return this.deletePolicyCallable;
    }

    @Override
    public OperationCallable<DeletePolicyRequest, Policy, PolicyOperationMetadata> deletePolicyOperationCallable() {
        return this.deletePolicyOperationCallable;
    }

    @Override
    public final void close() {
        try {
            this.backgroundResources.close();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to close resource", e);
        }
    }

    public void shutdown() {
        this.backgroundResources.shutdown();
    }

    public boolean isShutdown() {
        return this.backgroundResources.isShutdown();
    }

    public boolean isTerminated() {
        return this.backgroundResources.isTerminated();
    }

    public void shutdownNow() {
        this.backgroundResources.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.backgroundResources.awaitTermination(duration, unit);
    }
}

