/*
 * Decompiled with CFR 0.152.
 */
package com.google.iam.v3beta;

import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.httpjson.longrunning.stub.OperationsStub;
import com.google.api.gax.longrunning.OperationFuture;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.OperationCallable;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.iam.v3beta.CreatePolicyBindingRequest;
import com.google.iam.v3beta.DeletePolicyBindingRequest;
import com.google.iam.v3beta.FolderLocationName;
import com.google.iam.v3beta.GetPolicyBindingRequest;
import com.google.iam.v3beta.ListPolicyBindingsRequest;
import com.google.iam.v3beta.ListPolicyBindingsResponse;
import com.google.iam.v3beta.LocationName;
import com.google.iam.v3beta.OperationMetadata;
import com.google.iam.v3beta.OrganizationLocationName;
import com.google.iam.v3beta.PolicyBinding;
import com.google.iam.v3beta.PolicyBindingName;
import com.google.iam.v3beta.PolicyBindingsSettings;
import com.google.iam.v3beta.SearchTargetPolicyBindingsRequest;
import com.google.iam.v3beta.SearchTargetPolicyBindingsResponse;
import com.google.iam.v3beta.UpdatePolicyBindingRequest;
import com.google.iam.v3beta.stub.PolicyBindingsStub;
import com.google.iam.v3beta.stub.PolicyBindingsStubSettings;
import com.google.longrunning.Operation;
import com.google.longrunning.OperationsClient;
import com.google.protobuf.Empty;
import com.google.protobuf.FieldMask;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

@BetaApi
public class PolicyBindingsClient
implements BackgroundResource {
    private final PolicyBindingsSettings settings;
    private final PolicyBindingsStub stub;
    private final com.google.api.gax.httpjson.longrunning.OperationsClient httpJsonOperationsClient;
    private final OperationsClient operationsClient;

    public static final PolicyBindingsClient create() throws IOException {
        return PolicyBindingsClient.create(PolicyBindingsSettings.newBuilder().build());
    }

    public static final PolicyBindingsClient create(PolicyBindingsSettings settings) throws IOException {
        return new PolicyBindingsClient(settings);
    }

    public static final PolicyBindingsClient create(PolicyBindingsStub stub) {
        return new PolicyBindingsClient(stub);
    }

    protected PolicyBindingsClient(PolicyBindingsSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((PolicyBindingsStubSettings)settings.getStubSettings()).createStub();
        this.operationsClient = OperationsClient.create((com.google.longrunning.stub.OperationsStub)this.stub.getOperationsStub());
        this.httpJsonOperationsClient = com.google.api.gax.httpjson.longrunning.OperationsClient.create((OperationsStub)this.stub.getHttpJsonOperationsStub());
    }

    protected PolicyBindingsClient(PolicyBindingsStub stub) {
        this.settings = null;
        this.stub = stub;
        this.operationsClient = OperationsClient.create((com.google.longrunning.stub.OperationsStub)this.stub.getOperationsStub());
        this.httpJsonOperationsClient = com.google.api.gax.httpjson.longrunning.OperationsClient.create((OperationsStub)this.stub.getHttpJsonOperationsStub());
    }

    public final PolicyBindingsSettings getSettings() {
        return this.settings;
    }

    public PolicyBindingsStub getStub() {
        return this.stub;
    }

    public final OperationsClient getOperationsClient() {
        return this.operationsClient;
    }

    @BetaApi
    public final com.google.api.gax.httpjson.longrunning.OperationsClient getHttpJsonOperationsClient() {
        return this.httpJsonOperationsClient;
    }

    public final OperationFuture<PolicyBinding, OperationMetadata> createPolicyBindingAsync(FolderLocationName parent, PolicyBinding policyBinding, String policyBindingId) {
        CreatePolicyBindingRequest request = CreatePolicyBindingRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setPolicyBinding(policyBinding).setPolicyBindingId(policyBindingId).build();
        return this.createPolicyBindingAsync(request);
    }

    public final OperationFuture<PolicyBinding, OperationMetadata> createPolicyBindingAsync(LocationName parent, PolicyBinding policyBinding, String policyBindingId) {
        CreatePolicyBindingRequest request = CreatePolicyBindingRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setPolicyBinding(policyBinding).setPolicyBindingId(policyBindingId).build();
        return this.createPolicyBindingAsync(request);
    }

    public final OperationFuture<PolicyBinding, OperationMetadata> createPolicyBindingAsync(OrganizationLocationName parent, PolicyBinding policyBinding, String policyBindingId) {
        CreatePolicyBindingRequest request = CreatePolicyBindingRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setPolicyBinding(policyBinding).setPolicyBindingId(policyBindingId).build();
        return this.createPolicyBindingAsync(request);
    }

    public final OperationFuture<PolicyBinding, OperationMetadata> createPolicyBindingAsync(String parent, PolicyBinding policyBinding, String policyBindingId) {
        CreatePolicyBindingRequest request = CreatePolicyBindingRequest.newBuilder().setParent(parent).setPolicyBinding(policyBinding).setPolicyBindingId(policyBindingId).build();
        return this.createPolicyBindingAsync(request);
    }

    public final OperationFuture<PolicyBinding, OperationMetadata> createPolicyBindingAsync(CreatePolicyBindingRequest request) {
        return this.createPolicyBindingOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<CreatePolicyBindingRequest, PolicyBinding, OperationMetadata> createPolicyBindingOperationCallable() {
        return this.stub.createPolicyBindingOperationCallable();
    }

    public final UnaryCallable<CreatePolicyBindingRequest, Operation> createPolicyBindingCallable() {
        return this.stub.createPolicyBindingCallable();
    }

    public final PolicyBinding getPolicyBinding(PolicyBindingName name) {
        GetPolicyBindingRequest request = GetPolicyBindingRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getPolicyBinding(request);
    }

    public final PolicyBinding getPolicyBinding(String name) {
        GetPolicyBindingRequest request = GetPolicyBindingRequest.newBuilder().setName(name).build();
        return this.getPolicyBinding(request);
    }

    public final PolicyBinding getPolicyBinding(GetPolicyBindingRequest request) {
        return (PolicyBinding)this.getPolicyBindingCallable().call((Object)request);
    }

    public final UnaryCallable<GetPolicyBindingRequest, PolicyBinding> getPolicyBindingCallable() {
        return this.stub.getPolicyBindingCallable();
    }

    public final OperationFuture<PolicyBinding, OperationMetadata> updatePolicyBindingAsync(PolicyBinding policyBinding, FieldMask updateMask) {
        UpdatePolicyBindingRequest request = UpdatePolicyBindingRequest.newBuilder().setPolicyBinding(policyBinding).setUpdateMask(updateMask).build();
        return this.updatePolicyBindingAsync(request);
    }

    public final OperationFuture<PolicyBinding, OperationMetadata> updatePolicyBindingAsync(UpdatePolicyBindingRequest request) {
        return this.updatePolicyBindingOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<UpdatePolicyBindingRequest, PolicyBinding, OperationMetadata> updatePolicyBindingOperationCallable() {
        return this.stub.updatePolicyBindingOperationCallable();
    }

    public final UnaryCallable<UpdatePolicyBindingRequest, Operation> updatePolicyBindingCallable() {
        return this.stub.updatePolicyBindingCallable();
    }

    public final OperationFuture<Empty, OperationMetadata> deletePolicyBindingAsync(PolicyBindingName name) {
        DeletePolicyBindingRequest request = DeletePolicyBindingRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.deletePolicyBindingAsync(request);
    }

    public final OperationFuture<Empty, OperationMetadata> deletePolicyBindingAsync(String name) {
        DeletePolicyBindingRequest request = DeletePolicyBindingRequest.newBuilder().setName(name).build();
        return this.deletePolicyBindingAsync(request);
    }

    public final OperationFuture<Empty, OperationMetadata> deletePolicyBindingAsync(DeletePolicyBindingRequest request) {
        return this.deletePolicyBindingOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<DeletePolicyBindingRequest, Empty, OperationMetadata> deletePolicyBindingOperationCallable() {
        return this.stub.deletePolicyBindingOperationCallable();
    }

    public final UnaryCallable<DeletePolicyBindingRequest, Operation> deletePolicyBindingCallable() {
        return this.stub.deletePolicyBindingCallable();
    }

    public final ListPolicyBindingsPagedResponse listPolicyBindings(FolderLocationName parent) {
        ListPolicyBindingsRequest request = ListPolicyBindingsRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listPolicyBindings(request);
    }

    public final ListPolicyBindingsPagedResponse listPolicyBindings(LocationName parent) {
        ListPolicyBindingsRequest request = ListPolicyBindingsRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listPolicyBindings(request);
    }

    public final ListPolicyBindingsPagedResponse listPolicyBindings(OrganizationLocationName parent) {
        ListPolicyBindingsRequest request = ListPolicyBindingsRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listPolicyBindings(request);
    }

    public final ListPolicyBindingsPagedResponse listPolicyBindings(String parent) {
        ListPolicyBindingsRequest request = ListPolicyBindingsRequest.newBuilder().setParent(parent).build();
        return this.listPolicyBindings(request);
    }

    public final ListPolicyBindingsPagedResponse listPolicyBindings(ListPolicyBindingsRequest request) {
        return (ListPolicyBindingsPagedResponse)((Object)this.listPolicyBindingsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListPolicyBindingsRequest, ListPolicyBindingsPagedResponse> listPolicyBindingsPagedCallable() {
        return this.stub.listPolicyBindingsPagedCallable();
    }

    public final UnaryCallable<ListPolicyBindingsRequest, ListPolicyBindingsResponse> listPolicyBindingsCallable() {
        return this.stub.listPolicyBindingsCallable();
    }

    public final SearchTargetPolicyBindingsPagedResponse searchTargetPolicyBindings(FolderLocationName parent, String target) {
        SearchTargetPolicyBindingsRequest request = SearchTargetPolicyBindingsRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setTarget(target).build();
        return this.searchTargetPolicyBindings(request);
    }

    public final SearchTargetPolicyBindingsPagedResponse searchTargetPolicyBindings(LocationName parent, String target) {
        SearchTargetPolicyBindingsRequest request = SearchTargetPolicyBindingsRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setTarget(target).build();
        return this.searchTargetPolicyBindings(request);
    }

    public final SearchTargetPolicyBindingsPagedResponse searchTargetPolicyBindings(OrganizationLocationName parent, String target) {
        SearchTargetPolicyBindingsRequest request = SearchTargetPolicyBindingsRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setTarget(target).build();
        return this.searchTargetPolicyBindings(request);
    }

    public final SearchTargetPolicyBindingsPagedResponse searchTargetPolicyBindings(String parent, String target) {
        SearchTargetPolicyBindingsRequest request = SearchTargetPolicyBindingsRequest.newBuilder().setParent(parent).setTarget(target).build();
        return this.searchTargetPolicyBindings(request);
    }

    public final SearchTargetPolicyBindingsPagedResponse searchTargetPolicyBindings(SearchTargetPolicyBindingsRequest request) {
        return (SearchTargetPolicyBindingsPagedResponse)((Object)this.searchTargetPolicyBindingsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<SearchTargetPolicyBindingsRequest, SearchTargetPolicyBindingsPagedResponse> searchTargetPolicyBindingsPagedCallable() {
        return this.stub.searchTargetPolicyBindingsPagedCallable();
    }

    public final UnaryCallable<SearchTargetPolicyBindingsRequest, SearchTargetPolicyBindingsResponse> searchTargetPolicyBindingsCallable() {
        return this.stub.searchTargetPolicyBindingsCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class SearchTargetPolicyBindingsFixedSizeCollection
    extends AbstractFixedSizeCollection<SearchTargetPolicyBindingsRequest, SearchTargetPolicyBindingsResponse, PolicyBinding, SearchTargetPolicyBindingsPage, SearchTargetPolicyBindingsFixedSizeCollection> {
        private SearchTargetPolicyBindingsFixedSizeCollection(List<SearchTargetPolicyBindingsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static SearchTargetPolicyBindingsFixedSizeCollection createEmptyCollection() {
            return new SearchTargetPolicyBindingsFixedSizeCollection(null, 0);
        }

        protected SearchTargetPolicyBindingsFixedSizeCollection createCollection(List<SearchTargetPolicyBindingsPage> pages, int collectionSize) {
            return new SearchTargetPolicyBindingsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class SearchTargetPolicyBindingsPage
    extends AbstractPage<SearchTargetPolicyBindingsRequest, SearchTargetPolicyBindingsResponse, PolicyBinding, SearchTargetPolicyBindingsPage> {
        private SearchTargetPolicyBindingsPage(PageContext<SearchTargetPolicyBindingsRequest, SearchTargetPolicyBindingsResponse, PolicyBinding> context, SearchTargetPolicyBindingsResponse response) {
            super(context, (Object)response);
        }

        private static SearchTargetPolicyBindingsPage createEmptyPage() {
            return new SearchTargetPolicyBindingsPage(null, null);
        }

        protected SearchTargetPolicyBindingsPage createPage(PageContext<SearchTargetPolicyBindingsRequest, SearchTargetPolicyBindingsResponse, PolicyBinding> context, SearchTargetPolicyBindingsResponse response) {
            return new SearchTargetPolicyBindingsPage(context, response);
        }

        public ApiFuture<SearchTargetPolicyBindingsPage> createPageAsync(PageContext<SearchTargetPolicyBindingsRequest, SearchTargetPolicyBindingsResponse, PolicyBinding> context, ApiFuture<SearchTargetPolicyBindingsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class SearchTargetPolicyBindingsPagedResponse
    extends AbstractPagedListResponse<SearchTargetPolicyBindingsRequest, SearchTargetPolicyBindingsResponse, PolicyBinding, SearchTargetPolicyBindingsPage, SearchTargetPolicyBindingsFixedSizeCollection> {
        public static ApiFuture<SearchTargetPolicyBindingsPagedResponse> createAsync(PageContext<SearchTargetPolicyBindingsRequest, SearchTargetPolicyBindingsResponse, PolicyBinding> context, ApiFuture<SearchTargetPolicyBindingsResponse> futureResponse) {
            ApiFuture<SearchTargetPolicyBindingsPage> futurePage = SearchTargetPolicyBindingsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new SearchTargetPolicyBindingsPagedResponse((SearchTargetPolicyBindingsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private SearchTargetPolicyBindingsPagedResponse(SearchTargetPolicyBindingsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)SearchTargetPolicyBindingsFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListPolicyBindingsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListPolicyBindingsRequest, ListPolicyBindingsResponse, PolicyBinding, ListPolicyBindingsPage, ListPolicyBindingsFixedSizeCollection> {
        private ListPolicyBindingsFixedSizeCollection(List<ListPolicyBindingsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListPolicyBindingsFixedSizeCollection createEmptyCollection() {
            return new ListPolicyBindingsFixedSizeCollection(null, 0);
        }

        protected ListPolicyBindingsFixedSizeCollection createCollection(List<ListPolicyBindingsPage> pages, int collectionSize) {
            return new ListPolicyBindingsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListPolicyBindingsPage
    extends AbstractPage<ListPolicyBindingsRequest, ListPolicyBindingsResponse, PolicyBinding, ListPolicyBindingsPage> {
        private ListPolicyBindingsPage(PageContext<ListPolicyBindingsRequest, ListPolicyBindingsResponse, PolicyBinding> context, ListPolicyBindingsResponse response) {
            super(context, (Object)response);
        }

        private static ListPolicyBindingsPage createEmptyPage() {
            return new ListPolicyBindingsPage(null, null);
        }

        protected ListPolicyBindingsPage createPage(PageContext<ListPolicyBindingsRequest, ListPolicyBindingsResponse, PolicyBinding> context, ListPolicyBindingsResponse response) {
            return new ListPolicyBindingsPage(context, response);
        }

        public ApiFuture<ListPolicyBindingsPage> createPageAsync(PageContext<ListPolicyBindingsRequest, ListPolicyBindingsResponse, PolicyBinding> context, ApiFuture<ListPolicyBindingsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListPolicyBindingsPagedResponse
    extends AbstractPagedListResponse<ListPolicyBindingsRequest, ListPolicyBindingsResponse, PolicyBinding, ListPolicyBindingsPage, ListPolicyBindingsFixedSizeCollection> {
        public static ApiFuture<ListPolicyBindingsPagedResponse> createAsync(PageContext<ListPolicyBindingsRequest, ListPolicyBindingsResponse, PolicyBinding> context, ApiFuture<ListPolicyBindingsResponse> futureResponse) {
            ApiFuture<ListPolicyBindingsPage> futurePage = ListPolicyBindingsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListPolicyBindingsPagedResponse((ListPolicyBindingsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListPolicyBindingsPagedResponse(ListPolicyBindingsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListPolicyBindingsFixedSizeCollection.createEmptyCollection());
        }
    }
}

