/*
 * Decompiled with CFR 0.152.
 */
package com.google.iam.v2beta;

import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.httpjson.longrunning.stub.OperationsStub;
import com.google.api.gax.longrunning.OperationFuture;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.OperationCallable;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.iam.v2beta.CreatePolicyRequest;
import com.google.iam.v2beta.DeletePolicyRequest;
import com.google.iam.v2beta.GetPolicyRequest;
import com.google.iam.v2beta.ListPoliciesRequest;
import com.google.iam.v2beta.ListPoliciesResponse;
import com.google.iam.v2beta.PoliciesSettings;
import com.google.iam.v2beta.Policy;
import com.google.iam.v2beta.PolicyOperationMetadata;
import com.google.iam.v2beta.UpdatePolicyRequest;
import com.google.iam.v2beta.stub.PoliciesStub;
import com.google.iam.v2beta.stub.PoliciesStubSettings;
import com.google.longrunning.Operation;
import com.google.longrunning.OperationsClient;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

@BetaApi
public class PoliciesClient
implements BackgroundResource {
    private final PoliciesSettings settings;
    private final PoliciesStub stub;
    private final com.google.api.gax.httpjson.longrunning.OperationsClient httpJsonOperationsClient;
    private final OperationsClient operationsClient;

    public static final PoliciesClient create() throws IOException {
        return PoliciesClient.create(PoliciesSettings.newBuilder().build());
    }

    public static final PoliciesClient create(PoliciesSettings settings) throws IOException {
        return new PoliciesClient(settings);
    }

    public static final PoliciesClient create(PoliciesStub stub) {
        return new PoliciesClient(stub);
    }

    protected PoliciesClient(PoliciesSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((PoliciesStubSettings)settings.getStubSettings()).createStub();
        this.operationsClient = OperationsClient.create((com.google.longrunning.stub.OperationsStub)this.stub.getOperationsStub());
        this.httpJsonOperationsClient = com.google.api.gax.httpjson.longrunning.OperationsClient.create((OperationsStub)this.stub.getHttpJsonOperationsStub());
    }

    protected PoliciesClient(PoliciesStub stub) {
        this.settings = null;
        this.stub = stub;
        this.operationsClient = OperationsClient.create((com.google.longrunning.stub.OperationsStub)this.stub.getOperationsStub());
        this.httpJsonOperationsClient = com.google.api.gax.httpjson.longrunning.OperationsClient.create((OperationsStub)this.stub.getHttpJsonOperationsStub());
    }

    public final PoliciesSettings getSettings() {
        return this.settings;
    }

    public PoliciesStub getStub() {
        return this.stub;
    }

    public final OperationsClient getOperationsClient() {
        return this.operationsClient;
    }

    @BetaApi
    public final com.google.api.gax.httpjson.longrunning.OperationsClient getHttpJsonOperationsClient() {
        return this.httpJsonOperationsClient;
    }

    public final ListPoliciesPagedResponse listPolicies(String parent) {
        ListPoliciesRequest request = ListPoliciesRequest.newBuilder().setParent(parent).build();
        return this.listPolicies(request);
    }

    public final ListPoliciesPagedResponse listPolicies(ListPoliciesRequest request) {
        return (ListPoliciesPagedResponse)((Object)this.listPoliciesPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListPoliciesRequest, ListPoliciesPagedResponse> listPoliciesPagedCallable() {
        return this.stub.listPoliciesPagedCallable();
    }

    public final UnaryCallable<ListPoliciesRequest, ListPoliciesResponse> listPoliciesCallable() {
        return this.stub.listPoliciesCallable();
    }

    public final Policy getPolicy(String name) {
        GetPolicyRequest request = GetPolicyRequest.newBuilder().setName(name).build();
        return this.getPolicy(request);
    }

    public final Policy getPolicy(GetPolicyRequest request) {
        return (Policy)this.getPolicyCallable().call((Object)request);
    }

    public final UnaryCallable<GetPolicyRequest, Policy> getPolicyCallable() {
        return this.stub.getPolicyCallable();
    }

    public final OperationFuture<Policy, PolicyOperationMetadata> createPolicyAsync(String parent, Policy policy, String policyId) {
        CreatePolicyRequest request = CreatePolicyRequest.newBuilder().setParent(parent).setPolicy(policy).setPolicyId(policyId).build();
        return this.createPolicyAsync(request);
    }

    public final OperationFuture<Policy, PolicyOperationMetadata> createPolicyAsync(CreatePolicyRequest request) {
        return this.createPolicyOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<CreatePolicyRequest, Policy, PolicyOperationMetadata> createPolicyOperationCallable() {
        return this.stub.createPolicyOperationCallable();
    }

    public final UnaryCallable<CreatePolicyRequest, Operation> createPolicyCallable() {
        return this.stub.createPolicyCallable();
    }

    public final OperationFuture<Policy, PolicyOperationMetadata> updatePolicyAsync(UpdatePolicyRequest request) {
        return this.updatePolicyOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<UpdatePolicyRequest, Policy, PolicyOperationMetadata> updatePolicyOperationCallable() {
        return this.stub.updatePolicyOperationCallable();
    }

    public final UnaryCallable<UpdatePolicyRequest, Operation> updatePolicyCallable() {
        return this.stub.updatePolicyCallable();
    }

    public final OperationFuture<Policy, PolicyOperationMetadata> deletePolicyAsync(String name) {
        DeletePolicyRequest request = DeletePolicyRequest.newBuilder().setName(name).build();
        return this.deletePolicyAsync(request);
    }

    public final OperationFuture<Policy, PolicyOperationMetadata> deletePolicyAsync(DeletePolicyRequest request) {
        return this.deletePolicyOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<DeletePolicyRequest, Policy, PolicyOperationMetadata> deletePolicyOperationCallable() {
        return this.stub.deletePolicyOperationCallable();
    }

    public final UnaryCallable<DeletePolicyRequest, Operation> deletePolicyCallable() {
        return this.stub.deletePolicyCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class ListPoliciesFixedSizeCollection
    extends AbstractFixedSizeCollection<ListPoliciesRequest, ListPoliciesResponse, Policy, ListPoliciesPage, ListPoliciesFixedSizeCollection> {
        private ListPoliciesFixedSizeCollection(List<ListPoliciesPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListPoliciesFixedSizeCollection createEmptyCollection() {
            return new ListPoliciesFixedSizeCollection(null, 0);
        }

        protected ListPoliciesFixedSizeCollection createCollection(List<ListPoliciesPage> pages, int collectionSize) {
            return new ListPoliciesFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListPoliciesPage
    extends AbstractPage<ListPoliciesRequest, ListPoliciesResponse, Policy, ListPoliciesPage> {
        private ListPoliciesPage(PageContext<ListPoliciesRequest, ListPoliciesResponse, Policy> context, ListPoliciesResponse response) {
            super(context, (Object)response);
        }

        private static ListPoliciesPage createEmptyPage() {
            return new ListPoliciesPage(null, null);
        }

        protected ListPoliciesPage createPage(PageContext<ListPoliciesRequest, ListPoliciesResponse, Policy> context, ListPoliciesResponse response) {
            return new ListPoliciesPage(context, response);
        }

        public ApiFuture<ListPoliciesPage> createPageAsync(PageContext<ListPoliciesRequest, ListPoliciesResponse, Policy> context, ApiFuture<ListPoliciesResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListPoliciesPagedResponse
    extends AbstractPagedListResponse<ListPoliciesRequest, ListPoliciesResponse, Policy, ListPoliciesPage, ListPoliciesFixedSizeCollection> {
        public static ApiFuture<ListPoliciesPagedResponse> createAsync(PageContext<ListPoliciesRequest, ListPoliciesResponse, Policy> context, ApiFuture<ListPoliciesResponse> futureResponse) {
            ApiFuture<ListPoliciesPage> futurePage = ListPoliciesPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListPoliciesPagedResponse((ListPoliciesPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListPoliciesPagedResponse(ListPoliciesPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListPoliciesFixedSizeCollection.createEmptyCollection());
        }
    }
}

