/*
 * Decompiled with CFR 0.152.
 */
package com.google.apps.events.subscriptions.v1.stub;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.GaxProperties;
import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.api.gax.grpc.GaxGrpcProperties;
import com.google.api.gax.grpc.GrpcTransportChannel;
import com.google.api.gax.grpc.InstantiatingGrpcChannelProvider;
import com.google.api.gax.grpc.ProtoOperationTransformers;
import com.google.api.gax.httpjson.GaxHttpJsonProperties;
import com.google.api.gax.httpjson.HttpJsonTransportChannel;
import com.google.api.gax.httpjson.InstantiatingHttpJsonChannelProvider;
import com.google.api.gax.longrunning.OperationTimedPollAlgorithm;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.retrying.TimedRetryAlgorithm;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.OperationCallSettings;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.PagedCallSettings;
import com.google.api.gax.rpc.PagedListDescriptor;
import com.google.api.gax.rpc.PagedListResponseFactory;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.apps.events.subscriptions.v1.CreateSubscriptionMetadata;
import com.google.apps.events.subscriptions.v1.CreateSubscriptionRequest;
import com.google.apps.events.subscriptions.v1.DeleteSubscriptionMetadata;
import com.google.apps.events.subscriptions.v1.DeleteSubscriptionRequest;
import com.google.apps.events.subscriptions.v1.GetSubscriptionRequest;
import com.google.apps.events.subscriptions.v1.ListSubscriptionsRequest;
import com.google.apps.events.subscriptions.v1.ListSubscriptionsResponse;
import com.google.apps.events.subscriptions.v1.ReactivateSubscriptionMetadata;
import com.google.apps.events.subscriptions.v1.ReactivateSubscriptionRequest;
import com.google.apps.events.subscriptions.v1.Subscription;
import com.google.apps.events.subscriptions.v1.SubscriptionsServiceClient;
import com.google.apps.events.subscriptions.v1.UpdateSubscriptionMetadata;
import com.google.apps.events.subscriptions.v1.UpdateSubscriptionRequest;
import com.google.apps.events.subscriptions.v1.stub.GrpcSubscriptionsServiceStub;
import com.google.apps.events.subscriptions.v1.stub.HttpJsonSubscriptionsServiceStub;
import com.google.apps.events.subscriptions.v1.stub.SubscriptionsServiceStub;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.longrunning.Operation;
import com.google.protobuf.Empty;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.threeten.bp.Duration;

public class SubscriptionsServiceStubSettings
extends StubSettings<SubscriptionsServiceStubSettings> {
    private static final ImmutableList<String> DEFAULT_SERVICE_SCOPES = ImmutableList.builder().add((Object)"https://www.googleapis.com/auth/chat.bot").add((Object)"https://www.googleapis.com/auth/chat.memberships").add((Object)"https://www.googleapis.com/auth/chat.memberships.readonly").add((Object)"https://www.googleapis.com/auth/chat.messages").add((Object)"https://www.googleapis.com/auth/chat.messages.reactions").add((Object)"https://www.googleapis.com/auth/chat.messages.reactions.readonly").add((Object)"https://www.googleapis.com/auth/chat.messages.readonly").add((Object)"https://www.googleapis.com/auth/chat.spaces").add((Object)"https://www.googleapis.com/auth/chat.spaces.readonly").add((Object)"https://www.googleapis.com/auth/meetings.space.created").add((Object)"https://www.googleapis.com/auth/meetings.space.readonly").build();
    private final UnaryCallSettings<CreateSubscriptionRequest, Operation> createSubscriptionSettings;
    private final OperationCallSettings<CreateSubscriptionRequest, Subscription, CreateSubscriptionMetadata> createSubscriptionOperationSettings;
    private final UnaryCallSettings<DeleteSubscriptionRequest, Operation> deleteSubscriptionSettings;
    private final OperationCallSettings<DeleteSubscriptionRequest, Empty, DeleteSubscriptionMetadata> deleteSubscriptionOperationSettings;
    private final UnaryCallSettings<GetSubscriptionRequest, Subscription> getSubscriptionSettings;
    private final PagedCallSettings<ListSubscriptionsRequest, ListSubscriptionsResponse, SubscriptionsServiceClient.ListSubscriptionsPagedResponse> listSubscriptionsSettings;
    private final UnaryCallSettings<UpdateSubscriptionRequest, Operation> updateSubscriptionSettings;
    private final OperationCallSettings<UpdateSubscriptionRequest, Subscription, UpdateSubscriptionMetadata> updateSubscriptionOperationSettings;
    private final UnaryCallSettings<ReactivateSubscriptionRequest, Operation> reactivateSubscriptionSettings;
    private final OperationCallSettings<ReactivateSubscriptionRequest, Subscription, ReactivateSubscriptionMetadata> reactivateSubscriptionOperationSettings;
    private static final PagedListDescriptor<ListSubscriptionsRequest, ListSubscriptionsResponse, Subscription> LIST_SUBSCRIPTIONS_PAGE_STR_DESC = new PagedListDescriptor<ListSubscriptionsRequest, ListSubscriptionsResponse, Subscription>(){

        public String emptyToken() {
            return "";
        }

        public ListSubscriptionsRequest injectToken(ListSubscriptionsRequest payload, String token) {
            return ListSubscriptionsRequest.newBuilder((ListSubscriptionsRequest)payload).setPageToken(token).build();
        }

        public ListSubscriptionsRequest injectPageSize(ListSubscriptionsRequest payload, int pageSize) {
            return ListSubscriptionsRequest.newBuilder((ListSubscriptionsRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListSubscriptionsRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListSubscriptionsResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<Subscription> extractResources(ListSubscriptionsResponse payload) {
            return payload.getSubscriptionsList() == null ? ImmutableList.of() : payload.getSubscriptionsList();
        }
    };
    private static final PagedListResponseFactory<ListSubscriptionsRequest, ListSubscriptionsResponse, SubscriptionsServiceClient.ListSubscriptionsPagedResponse> LIST_SUBSCRIPTIONS_PAGE_STR_FACT = new PagedListResponseFactory<ListSubscriptionsRequest, ListSubscriptionsResponse, SubscriptionsServiceClient.ListSubscriptionsPagedResponse>(){

        public ApiFuture<SubscriptionsServiceClient.ListSubscriptionsPagedResponse> getFuturePagedResponse(UnaryCallable<ListSubscriptionsRequest, ListSubscriptionsResponse> callable, ListSubscriptionsRequest request, ApiCallContext context, ApiFuture<ListSubscriptionsResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_SUBSCRIPTIONS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return SubscriptionsServiceClient.ListSubscriptionsPagedResponse.createAsync((PageContext<ListSubscriptionsRequest, ListSubscriptionsResponse, Subscription>)pageContext, futureResponse);
        }
    };

    public UnaryCallSettings<CreateSubscriptionRequest, Operation> createSubscriptionSettings() {
        return this.createSubscriptionSettings;
    }

    public OperationCallSettings<CreateSubscriptionRequest, Subscription, CreateSubscriptionMetadata> createSubscriptionOperationSettings() {
        return this.createSubscriptionOperationSettings;
    }

    public UnaryCallSettings<DeleteSubscriptionRequest, Operation> deleteSubscriptionSettings() {
        return this.deleteSubscriptionSettings;
    }

    public OperationCallSettings<DeleteSubscriptionRequest, Empty, DeleteSubscriptionMetadata> deleteSubscriptionOperationSettings() {
        return this.deleteSubscriptionOperationSettings;
    }

    public UnaryCallSettings<GetSubscriptionRequest, Subscription> getSubscriptionSettings() {
        return this.getSubscriptionSettings;
    }

    public PagedCallSettings<ListSubscriptionsRequest, ListSubscriptionsResponse, SubscriptionsServiceClient.ListSubscriptionsPagedResponse> listSubscriptionsSettings() {
        return this.listSubscriptionsSettings;
    }

    public UnaryCallSettings<UpdateSubscriptionRequest, Operation> updateSubscriptionSettings() {
        return this.updateSubscriptionSettings;
    }

    public OperationCallSettings<UpdateSubscriptionRequest, Subscription, UpdateSubscriptionMetadata> updateSubscriptionOperationSettings() {
        return this.updateSubscriptionOperationSettings;
    }

    public UnaryCallSettings<ReactivateSubscriptionRequest, Operation> reactivateSubscriptionSettings() {
        return this.reactivateSubscriptionSettings;
    }

    public OperationCallSettings<ReactivateSubscriptionRequest, Subscription, ReactivateSubscriptionMetadata> reactivateSubscriptionOperationSettings() {
        return this.reactivateSubscriptionOperationSettings;
    }

    public SubscriptionsServiceStub createStub() throws IOException {
        if (this.getTransportChannelProvider().getTransportName().equals(GrpcTransportChannel.getGrpcTransportName())) {
            return GrpcSubscriptionsServiceStub.create(this);
        }
        if (this.getTransportChannelProvider().getTransportName().equals(HttpJsonTransportChannel.getHttpJsonTransportName())) {
            return HttpJsonSubscriptionsServiceStub.create(this);
        }
        throw new UnsupportedOperationException(String.format("Transport not supported: %s", this.getTransportChannelProvider().getTransportName()));
    }

    public String getServiceName() {
        return "workspaceevents";
    }

    public static InstantiatingExecutorProvider.Builder defaultExecutorProviderBuilder() {
        return InstantiatingExecutorProvider.newBuilder();
    }

    public static String getDefaultEndpoint() {
        return "workspaceevents.googleapis.com:443";
    }

    public static String getDefaultMtlsEndpoint() {
        return "workspaceevents.mtls.googleapis.com:443";
    }

    public static List<String> getDefaultServiceScopes() {
        return DEFAULT_SERVICE_SCOPES;
    }

    public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
        return GoogleCredentialsProvider.newBuilder().setScopesToApply(DEFAULT_SERVICE_SCOPES).setUseJwtAccessWithScope(true);
    }

    public static InstantiatingGrpcChannelProvider.Builder defaultGrpcTransportProviderBuilder() {
        return InstantiatingGrpcChannelProvider.newBuilder().setMaxInboundMessageSize(Integer.valueOf(Integer.MAX_VALUE));
    }

    @BetaApi
    public static InstantiatingHttpJsonChannelProvider.Builder defaultHttpJsonTransportProviderBuilder() {
        return InstantiatingHttpJsonChannelProvider.newBuilder();
    }

    public static TransportChannelProvider defaultTransportChannelProvider() {
        return SubscriptionsServiceStubSettings.defaultGrpcTransportProviderBuilder().build();
    }

    public static ApiClientHeaderProvider.Builder defaultGrpcApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(SubscriptionsServiceStubSettings.class)).setTransportToken(GaxGrpcProperties.getGrpcTokenName(), GaxGrpcProperties.getGrpcVersion());
    }

    public static ApiClientHeaderProvider.Builder defaultHttpJsonApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(SubscriptionsServiceStubSettings.class)).setTransportToken(GaxHttpJsonProperties.getHttpJsonTokenName(), GaxHttpJsonProperties.getHttpJsonVersion());
    }

    public static ApiClientHeaderProvider.Builder defaultApiClientHeaderProviderBuilder() {
        return SubscriptionsServiceStubSettings.defaultGrpcApiClientHeaderProviderBuilder();
    }

    public static Builder newBuilder() {
        return Builder.createDefault();
    }

    public static Builder newHttpJsonBuilder() {
        return Builder.createHttpJsonDefault();
    }

    public static Builder newBuilder(ClientContext clientContext) {
        return new Builder(clientContext);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    protected SubscriptionsServiceStubSettings(Builder settingsBuilder) throws IOException {
        super((StubSettings.Builder)settingsBuilder);
        this.createSubscriptionSettings = settingsBuilder.createSubscriptionSettings().build();
        this.createSubscriptionOperationSettings = settingsBuilder.createSubscriptionOperationSettings().build();
        this.deleteSubscriptionSettings = settingsBuilder.deleteSubscriptionSettings().build();
        this.deleteSubscriptionOperationSettings = settingsBuilder.deleteSubscriptionOperationSettings().build();
        this.getSubscriptionSettings = settingsBuilder.getSubscriptionSettings().build();
        this.listSubscriptionsSettings = settingsBuilder.listSubscriptionsSettings().build();
        this.updateSubscriptionSettings = settingsBuilder.updateSubscriptionSettings().build();
        this.updateSubscriptionOperationSettings = settingsBuilder.updateSubscriptionOperationSettings().build();
        this.reactivateSubscriptionSettings = settingsBuilder.reactivateSubscriptionSettings().build();
        this.reactivateSubscriptionOperationSettings = settingsBuilder.reactivateSubscriptionOperationSettings().build();
    }

    public static class Builder
    extends StubSettings.Builder<SubscriptionsServiceStubSettings, Builder> {
        private final ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders;
        private final UnaryCallSettings.Builder<CreateSubscriptionRequest, Operation> createSubscriptionSettings;
        private final OperationCallSettings.Builder<CreateSubscriptionRequest, Subscription, CreateSubscriptionMetadata> createSubscriptionOperationSettings;
        private final UnaryCallSettings.Builder<DeleteSubscriptionRequest, Operation> deleteSubscriptionSettings;
        private final OperationCallSettings.Builder<DeleteSubscriptionRequest, Empty, DeleteSubscriptionMetadata> deleteSubscriptionOperationSettings;
        private final UnaryCallSettings.Builder<GetSubscriptionRequest, Subscription> getSubscriptionSettings;
        private final PagedCallSettings.Builder<ListSubscriptionsRequest, ListSubscriptionsResponse, SubscriptionsServiceClient.ListSubscriptionsPagedResponse> listSubscriptionsSettings;
        private final UnaryCallSettings.Builder<UpdateSubscriptionRequest, Operation> updateSubscriptionSettings;
        private final OperationCallSettings.Builder<UpdateSubscriptionRequest, Subscription, UpdateSubscriptionMetadata> updateSubscriptionOperationSettings;
        private final UnaryCallSettings.Builder<ReactivateSubscriptionRequest, Operation> reactivateSubscriptionSettings;
        private final OperationCallSettings.Builder<ReactivateSubscriptionRequest, Subscription, ReactivateSubscriptionMetadata> reactivateSubscriptionOperationSettings;
        private static final ImmutableMap<String, ImmutableSet<StatusCode.Code>> RETRYABLE_CODE_DEFINITIONS;
        private static final ImmutableMap<String, RetrySettings> RETRY_PARAM_DEFINITIONS;

        protected Builder() {
            this((ClientContext)null);
        }

        protected Builder(ClientContext clientContext) {
            super(clientContext);
            this.createSubscriptionSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.createSubscriptionOperationSettings = OperationCallSettings.newBuilder();
            this.deleteSubscriptionSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.deleteSubscriptionOperationSettings = OperationCallSettings.newBuilder();
            this.getSubscriptionSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.listSubscriptionsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_SUBSCRIPTIONS_PAGE_STR_FACT);
            this.updateSubscriptionSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.updateSubscriptionOperationSettings = OperationCallSettings.newBuilder();
            this.reactivateSubscriptionSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.reactivateSubscriptionOperationSettings = OperationCallSettings.newBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.createSubscriptionSettings, this.deleteSubscriptionSettings, this.getSubscriptionSettings, this.listSubscriptionsSettings, this.updateSubscriptionSettings, this.reactivateSubscriptionSettings);
            Builder.initDefaults(this);
        }

        protected Builder(SubscriptionsServiceStubSettings settings) {
            super((StubSettings)settings);
            this.createSubscriptionSettings = settings.createSubscriptionSettings.toBuilder();
            this.createSubscriptionOperationSettings = settings.createSubscriptionOperationSettings.toBuilder();
            this.deleteSubscriptionSettings = settings.deleteSubscriptionSettings.toBuilder();
            this.deleteSubscriptionOperationSettings = settings.deleteSubscriptionOperationSettings.toBuilder();
            this.getSubscriptionSettings = settings.getSubscriptionSettings.toBuilder();
            this.listSubscriptionsSettings = settings.listSubscriptionsSettings.toBuilder();
            this.updateSubscriptionSettings = settings.updateSubscriptionSettings.toBuilder();
            this.updateSubscriptionOperationSettings = settings.updateSubscriptionOperationSettings.toBuilder();
            this.reactivateSubscriptionSettings = settings.reactivateSubscriptionSettings.toBuilder();
            this.reactivateSubscriptionOperationSettings = settings.reactivateSubscriptionOperationSettings.toBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.createSubscriptionSettings, this.deleteSubscriptionSettings, this.getSubscriptionSettings, this.listSubscriptionsSettings, this.updateSubscriptionSettings, this.reactivateSubscriptionSettings);
        }

        private static Builder createDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider(SubscriptionsServiceStubSettings.defaultTransportChannelProvider());
            builder.setCredentialsProvider((CredentialsProvider)SubscriptionsServiceStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)SubscriptionsServiceStubSettings.defaultApiClientHeaderProviderBuilder().build());
            builder.setMtlsEndpoint(SubscriptionsServiceStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder createHttpJsonDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider((TransportChannelProvider)SubscriptionsServiceStubSettings.defaultHttpJsonTransportProviderBuilder().build());
            builder.setCredentialsProvider((CredentialsProvider)SubscriptionsServiceStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)SubscriptionsServiceStubSettings.defaultHttpJsonApiClientHeaderProviderBuilder().build());
            builder.setMtlsEndpoint(SubscriptionsServiceStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder initDefaults(Builder builder) {
            builder.createSubscriptionSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.deleteSubscriptionSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.getSubscriptionSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.listSubscriptionsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.updateSubscriptionSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.reactivateSubscriptionSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.createSubscriptionOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Subscription.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(CreateSubscriptionMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            builder.deleteSubscriptionOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Empty.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(DeleteSubscriptionMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            builder.updateSubscriptionOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Subscription.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(UpdateSubscriptionMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            builder.reactivateSubscriptionOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Subscription.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(ReactivateSubscriptionMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            return builder;
        }

        public Builder applyToAllUnaryMethods(ApiFunction<UnaryCallSettings.Builder<?, ?>, Void> settingsUpdater) {
            StubSettings.Builder.applyToAllUnaryMethods(this.unaryMethodSettingsBuilders, settingsUpdater);
            return this;
        }

        public ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders() {
            return this.unaryMethodSettingsBuilders;
        }

        public UnaryCallSettings.Builder<CreateSubscriptionRequest, Operation> createSubscriptionSettings() {
            return this.createSubscriptionSettings;
        }

        public OperationCallSettings.Builder<CreateSubscriptionRequest, Subscription, CreateSubscriptionMetadata> createSubscriptionOperationSettings() {
            return this.createSubscriptionOperationSettings;
        }

        public UnaryCallSettings.Builder<DeleteSubscriptionRequest, Operation> deleteSubscriptionSettings() {
            return this.deleteSubscriptionSettings;
        }

        public OperationCallSettings.Builder<DeleteSubscriptionRequest, Empty, DeleteSubscriptionMetadata> deleteSubscriptionOperationSettings() {
            return this.deleteSubscriptionOperationSettings;
        }

        public UnaryCallSettings.Builder<GetSubscriptionRequest, Subscription> getSubscriptionSettings() {
            return this.getSubscriptionSettings;
        }

        public PagedCallSettings.Builder<ListSubscriptionsRequest, ListSubscriptionsResponse, SubscriptionsServiceClient.ListSubscriptionsPagedResponse> listSubscriptionsSettings() {
            return this.listSubscriptionsSettings;
        }

        public UnaryCallSettings.Builder<UpdateSubscriptionRequest, Operation> updateSubscriptionSettings() {
            return this.updateSubscriptionSettings;
        }

        public OperationCallSettings.Builder<UpdateSubscriptionRequest, Subscription, UpdateSubscriptionMetadata> updateSubscriptionOperationSettings() {
            return this.updateSubscriptionOperationSettings;
        }

        public UnaryCallSettings.Builder<ReactivateSubscriptionRequest, Operation> reactivateSubscriptionSettings() {
            return this.reactivateSubscriptionSettings;
        }

        public OperationCallSettings.Builder<ReactivateSubscriptionRequest, Subscription, ReactivateSubscriptionMetadata> reactivateSubscriptionOperationSettings() {
            return this.reactivateSubscriptionOperationSettings;
        }

        public SubscriptionsServiceStubSettings build() throws IOException {
            return new SubscriptionsServiceStubSettings(this);
        }

        static {
            ImmutableMap.Builder definitions = ImmutableMap.builder();
            definitions.put((Object)"no_retry_1_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList()));
            definitions.put((Object)"retry_policy_0_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList((Object[])new StatusCode.Code[]{StatusCode.Code.UNAVAILABLE})));
            RETRYABLE_CODE_DEFINITIONS = definitions.build();
            definitions = ImmutableMap.builder();
            RetrySettings settings = null;
            settings = RetrySettings.newBuilder().setInitialRpcTimeout(Duration.ofMillis((long)60000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ofMillis((long)60000L)).setTotalTimeout(Duration.ofMillis((long)60000L)).build();
            definitions.put((Object)"no_retry_1_params", (Object)settings);
            settings = RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)1000L)).setRetryDelayMultiplier(1.3).setMaxRetryDelay(Duration.ofMillis((long)10000L)).setInitialRpcTimeout(Duration.ofMillis((long)60000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ofMillis((long)60000L)).setTotalTimeout(Duration.ofMillis((long)60000L)).build();
            definitions.put((Object)"retry_policy_0_params", (Object)settings);
            RETRY_PARAM_DEFINITIONS = definitions.build();
        }
    }
}

