/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.vpcaccess.v1.stub;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.GaxProperties;
import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.api.gax.grpc.GaxGrpcProperties;
import com.google.api.gax.grpc.GrpcTransportChannel;
import com.google.api.gax.grpc.InstantiatingGrpcChannelProvider;
import com.google.api.gax.grpc.ProtoOperationTransformers;
import com.google.api.gax.longrunning.OperationTimedPollAlgorithm;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.retrying.TimedRetryAlgorithm;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.OperationCallSettings;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.PagedCallSettings;
import com.google.api.gax.rpc.PagedListDescriptor;
import com.google.api.gax.rpc.PagedListResponseFactory;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.vpcaccess.v1.Connector;
import com.google.cloud.vpcaccess.v1.CreateConnectorRequest;
import com.google.cloud.vpcaccess.v1.DeleteConnectorRequest;
import com.google.cloud.vpcaccess.v1.GetConnectorRequest;
import com.google.cloud.vpcaccess.v1.ListConnectorsRequest;
import com.google.cloud.vpcaccess.v1.ListConnectorsResponse;
import com.google.cloud.vpcaccess.v1.OperationMetadata;
import com.google.cloud.vpcaccess.v1.VpcAccessServiceClient;
import com.google.cloud.vpcaccess.v1.stub.GrpcVpcAccessServiceStub;
import com.google.cloud.vpcaccess.v1.stub.VpcAccessServiceStub;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.longrunning.Operation;
import com.google.protobuf.Empty;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.threeten.bp.Duration;

public class VpcAccessServiceStubSettings
extends StubSettings<VpcAccessServiceStubSettings> {
    private static final ImmutableList<String> DEFAULT_SERVICE_SCOPES = ImmutableList.builder().add((Object)"https://www.googleapis.com/auth/cloud-platform").build();
    private final UnaryCallSettings<CreateConnectorRequest, Operation> createConnectorSettings;
    private final OperationCallSettings<CreateConnectorRequest, Connector, OperationMetadata> createConnectorOperationSettings;
    private final UnaryCallSettings<GetConnectorRequest, Connector> getConnectorSettings;
    private final PagedCallSettings<ListConnectorsRequest, ListConnectorsResponse, VpcAccessServiceClient.ListConnectorsPagedResponse> listConnectorsSettings;
    private final UnaryCallSettings<DeleteConnectorRequest, Operation> deleteConnectorSettings;
    private final OperationCallSettings<DeleteConnectorRequest, Empty, OperationMetadata> deleteConnectorOperationSettings;
    private static final PagedListDescriptor<ListConnectorsRequest, ListConnectorsResponse, Connector> LIST_CONNECTORS_PAGE_STR_DESC = new PagedListDescriptor<ListConnectorsRequest, ListConnectorsResponse, Connector>(){

        public String emptyToken() {
            return "";
        }

        public ListConnectorsRequest injectToken(ListConnectorsRequest payload, String token) {
            return ListConnectorsRequest.newBuilder((ListConnectorsRequest)payload).setPageToken(token).build();
        }

        public ListConnectorsRequest injectPageSize(ListConnectorsRequest payload, int pageSize) {
            return ListConnectorsRequest.newBuilder((ListConnectorsRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListConnectorsRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListConnectorsResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<Connector> extractResources(ListConnectorsResponse payload) {
            return payload.getConnectorsList() == null ? ImmutableList.of() : payload.getConnectorsList();
        }
    };
    private static final PagedListResponseFactory<ListConnectorsRequest, ListConnectorsResponse, VpcAccessServiceClient.ListConnectorsPagedResponse> LIST_CONNECTORS_PAGE_STR_FACT = new PagedListResponseFactory<ListConnectorsRequest, ListConnectorsResponse, VpcAccessServiceClient.ListConnectorsPagedResponse>(){

        public ApiFuture<VpcAccessServiceClient.ListConnectorsPagedResponse> getFuturePagedResponse(UnaryCallable<ListConnectorsRequest, ListConnectorsResponse> callable, ListConnectorsRequest request, ApiCallContext context, ApiFuture<ListConnectorsResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_CONNECTORS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return VpcAccessServiceClient.ListConnectorsPagedResponse.createAsync((PageContext<ListConnectorsRequest, ListConnectorsResponse, Connector>)pageContext, futureResponse);
        }
    };

    public UnaryCallSettings<CreateConnectorRequest, Operation> createConnectorSettings() {
        return this.createConnectorSettings;
    }

    public OperationCallSettings<CreateConnectorRequest, Connector, OperationMetadata> createConnectorOperationSettings() {
        return this.createConnectorOperationSettings;
    }

    public UnaryCallSettings<GetConnectorRequest, Connector> getConnectorSettings() {
        return this.getConnectorSettings;
    }

    public PagedCallSettings<ListConnectorsRequest, ListConnectorsResponse, VpcAccessServiceClient.ListConnectorsPagedResponse> listConnectorsSettings() {
        return this.listConnectorsSettings;
    }

    public UnaryCallSettings<DeleteConnectorRequest, Operation> deleteConnectorSettings() {
        return this.deleteConnectorSettings;
    }

    public OperationCallSettings<DeleteConnectorRequest, Empty, OperationMetadata> deleteConnectorOperationSettings() {
        return this.deleteConnectorOperationSettings;
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public VpcAccessServiceStub createStub() throws IOException {
        if (this.getTransportChannelProvider().getTransportName().equals(GrpcTransportChannel.getGrpcTransportName())) {
            return GrpcVpcAccessServiceStub.create(this);
        }
        throw new UnsupportedOperationException(String.format("Transport not supported: %s", this.getTransportChannelProvider().getTransportName()));
    }

    public static InstantiatingExecutorProvider.Builder defaultExecutorProviderBuilder() {
        return InstantiatingExecutorProvider.newBuilder();
    }

    public static String getDefaultEndpoint() {
        return "vpcaccess.googleapis.com:443";
    }

    public static List<String> getDefaultServiceScopes() {
        return DEFAULT_SERVICE_SCOPES;
    }

    public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
        return GoogleCredentialsProvider.newBuilder().setScopesToApply(DEFAULT_SERVICE_SCOPES);
    }

    public static InstantiatingGrpcChannelProvider.Builder defaultGrpcTransportProviderBuilder() {
        return InstantiatingGrpcChannelProvider.newBuilder().setMaxInboundMessageSize(Integer.valueOf(Integer.MAX_VALUE));
    }

    public static TransportChannelProvider defaultTransportChannelProvider() {
        return VpcAccessServiceStubSettings.defaultGrpcTransportProviderBuilder().build();
    }

    @BetaApi(value="The surface for customizing headers is not stable yet and may change in the future.")
    public static ApiClientHeaderProvider.Builder defaultApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(VpcAccessServiceStubSettings.class)).setTransportToken(GaxGrpcProperties.getGrpcTokenName(), GaxGrpcProperties.getGrpcVersion());
    }

    public static Builder newBuilder() {
        return Builder.createDefault();
    }

    public static Builder newBuilder(ClientContext clientContext) {
        return new Builder(clientContext);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    protected VpcAccessServiceStubSettings(Builder settingsBuilder) throws IOException {
        super((StubSettings.Builder)settingsBuilder);
        this.createConnectorSettings = settingsBuilder.createConnectorSettings().build();
        this.createConnectorOperationSettings = settingsBuilder.createConnectorOperationSettings().build();
        this.getConnectorSettings = settingsBuilder.getConnectorSettings().build();
        this.listConnectorsSettings = settingsBuilder.listConnectorsSettings().build();
        this.deleteConnectorSettings = settingsBuilder.deleteConnectorSettings().build();
        this.deleteConnectorOperationSettings = settingsBuilder.deleteConnectorOperationSettings().build();
    }

    public static class Builder
    extends StubSettings.Builder<VpcAccessServiceStubSettings, Builder> {
        private final ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders;
        private final UnaryCallSettings.Builder<CreateConnectorRequest, Operation> createConnectorSettings;
        private final OperationCallSettings.Builder<CreateConnectorRequest, Connector, OperationMetadata> createConnectorOperationSettings;
        private final UnaryCallSettings.Builder<GetConnectorRequest, Connector> getConnectorSettings;
        private final PagedCallSettings.Builder<ListConnectorsRequest, ListConnectorsResponse, VpcAccessServiceClient.ListConnectorsPagedResponse> listConnectorsSettings;
        private final UnaryCallSettings.Builder<DeleteConnectorRequest, Operation> deleteConnectorSettings;
        private final OperationCallSettings.Builder<DeleteConnectorRequest, Empty, OperationMetadata> deleteConnectorOperationSettings;
        private static final ImmutableMap<String, ImmutableSet<StatusCode.Code>> RETRYABLE_CODE_DEFINITIONS;
        private static final ImmutableMap<String, RetrySettings> RETRY_PARAM_DEFINITIONS;

        protected Builder() {
            this((ClientContext)null);
        }

        protected Builder(ClientContext clientContext) {
            super(clientContext);
            this.createConnectorSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.createConnectorOperationSettings = OperationCallSettings.newBuilder();
            this.getConnectorSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.listConnectorsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_CONNECTORS_PAGE_STR_FACT);
            this.deleteConnectorSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.deleteConnectorOperationSettings = OperationCallSettings.newBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.createConnectorSettings, this.getConnectorSettings, this.listConnectorsSettings, this.deleteConnectorSettings);
            Builder.initDefaults(this);
        }

        protected Builder(VpcAccessServiceStubSettings settings) {
            super((StubSettings)settings);
            this.createConnectorSettings = settings.createConnectorSettings.toBuilder();
            this.createConnectorOperationSettings = settings.createConnectorOperationSettings.toBuilder();
            this.getConnectorSettings = settings.getConnectorSettings.toBuilder();
            this.listConnectorsSettings = settings.listConnectorsSettings.toBuilder();
            this.deleteConnectorSettings = settings.deleteConnectorSettings.toBuilder();
            this.deleteConnectorOperationSettings = settings.deleteConnectorOperationSettings.toBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.createConnectorSettings, this.getConnectorSettings, this.listConnectorsSettings, this.deleteConnectorSettings);
        }

        private static Builder createDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider(VpcAccessServiceStubSettings.defaultTransportChannelProvider());
            builder.setCredentialsProvider((CredentialsProvider)VpcAccessServiceStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)VpcAccessServiceStubSettings.defaultApiClientHeaderProviderBuilder().build());
            builder.setEndpoint(VpcAccessServiceStubSettings.getDefaultEndpoint());
            return Builder.initDefaults(builder);
        }

        private static Builder initDefaults(Builder builder) {
            builder.createConnectorSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.getConnectorSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.listConnectorsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.deleteConnectorSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.createConnectorOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Connector.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            builder.deleteConnectorOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Empty.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            return builder;
        }

        public Builder applyToAllUnaryMethods(ApiFunction<UnaryCallSettings.Builder<?, ?>, Void> settingsUpdater) throws Exception {
            StubSettings.Builder.applyToAllUnaryMethods(this.unaryMethodSettingsBuilders, settingsUpdater);
            return this;
        }

        public ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders() {
            return this.unaryMethodSettingsBuilders;
        }

        public UnaryCallSettings.Builder<CreateConnectorRequest, Operation> createConnectorSettings() {
            return this.createConnectorSettings;
        }

        @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
        public OperationCallSettings.Builder<CreateConnectorRequest, Connector, OperationMetadata> createConnectorOperationSettings() {
            return this.createConnectorOperationSettings;
        }

        public UnaryCallSettings.Builder<GetConnectorRequest, Connector> getConnectorSettings() {
            return this.getConnectorSettings;
        }

        public PagedCallSettings.Builder<ListConnectorsRequest, ListConnectorsResponse, VpcAccessServiceClient.ListConnectorsPagedResponse> listConnectorsSettings() {
            return this.listConnectorsSettings;
        }

        public UnaryCallSettings.Builder<DeleteConnectorRequest, Operation> deleteConnectorSettings() {
            return this.deleteConnectorSettings;
        }

        @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
        public OperationCallSettings.Builder<DeleteConnectorRequest, Empty, OperationMetadata> deleteConnectorOperationSettings() {
            return this.deleteConnectorOperationSettings;
        }

        public VpcAccessServiceStubSettings build() throws IOException {
            return new VpcAccessServiceStubSettings(this);
        }

        static {
            ImmutableMap.Builder definitions = ImmutableMap.builder();
            definitions.put((Object)"no_retry_1_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList()));
            RETRYABLE_CODE_DEFINITIONS = definitions.build();
            definitions = ImmutableMap.builder();
            RetrySettings settings = null;
            settings = RetrySettings.newBuilder().setInitialRpcTimeout(Duration.ofMillis((long)60000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ofMillis((long)60000L)).setTotalTimeout(Duration.ofMillis((long)60000L)).build();
            definitions.put((Object)"no_retry_1_params", (Object)settings);
            RETRY_PARAM_DEFINITIONS = definitions.build();
        }
    }
}

