/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.vmwareengine.v1;

import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.longrunning.OperationFuture;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.OperationCallable;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.location.GetLocationRequest;
import com.google.cloud.location.ListLocationsRequest;
import com.google.cloud.location.ListLocationsResponse;
import com.google.cloud.location.Location;
import com.google.cloud.vmwareengine.v1.Cluster;
import com.google.cloud.vmwareengine.v1.ClusterName;
import com.google.cloud.vmwareengine.v1.CreateClusterRequest;
import com.google.cloud.vmwareengine.v1.CreateExternalAccessRuleRequest;
import com.google.cloud.vmwareengine.v1.CreateExternalAddressRequest;
import com.google.cloud.vmwareengine.v1.CreateHcxActivationKeyRequest;
import com.google.cloud.vmwareengine.v1.CreateLoggingServerRequest;
import com.google.cloud.vmwareengine.v1.CreateManagementDnsZoneBindingRequest;
import com.google.cloud.vmwareengine.v1.CreateNetworkPeeringRequest;
import com.google.cloud.vmwareengine.v1.CreateNetworkPolicyRequest;
import com.google.cloud.vmwareengine.v1.CreatePrivateCloudRequest;
import com.google.cloud.vmwareengine.v1.CreatePrivateConnectionRequest;
import com.google.cloud.vmwareengine.v1.CreateVmwareEngineNetworkRequest;
import com.google.cloud.vmwareengine.v1.Credentials;
import com.google.cloud.vmwareengine.v1.DeleteClusterRequest;
import com.google.cloud.vmwareengine.v1.DeleteExternalAccessRuleRequest;
import com.google.cloud.vmwareengine.v1.DeleteExternalAddressRequest;
import com.google.cloud.vmwareengine.v1.DeleteLoggingServerRequest;
import com.google.cloud.vmwareengine.v1.DeleteManagementDnsZoneBindingRequest;
import com.google.cloud.vmwareengine.v1.DeleteNetworkPeeringRequest;
import com.google.cloud.vmwareengine.v1.DeleteNetworkPolicyRequest;
import com.google.cloud.vmwareengine.v1.DeletePrivateCloudRequest;
import com.google.cloud.vmwareengine.v1.DeletePrivateConnectionRequest;
import com.google.cloud.vmwareengine.v1.DeleteVmwareEngineNetworkRequest;
import com.google.cloud.vmwareengine.v1.DnsBindPermission;
import com.google.cloud.vmwareengine.v1.DnsBindPermissionName;
import com.google.cloud.vmwareengine.v1.DnsForwarding;
import com.google.cloud.vmwareengine.v1.DnsForwardingName;
import com.google.cloud.vmwareengine.v1.ExternalAccessRule;
import com.google.cloud.vmwareengine.v1.ExternalAccessRuleName;
import com.google.cloud.vmwareengine.v1.ExternalAddress;
import com.google.cloud.vmwareengine.v1.ExternalAddressName;
import com.google.cloud.vmwareengine.v1.FetchNetworkPolicyExternalAddressesRequest;
import com.google.cloud.vmwareengine.v1.FetchNetworkPolicyExternalAddressesResponse;
import com.google.cloud.vmwareengine.v1.GetClusterRequest;
import com.google.cloud.vmwareengine.v1.GetDnsBindPermissionRequest;
import com.google.cloud.vmwareengine.v1.GetDnsForwardingRequest;
import com.google.cloud.vmwareengine.v1.GetExternalAccessRuleRequest;
import com.google.cloud.vmwareengine.v1.GetExternalAddressRequest;
import com.google.cloud.vmwareengine.v1.GetHcxActivationKeyRequest;
import com.google.cloud.vmwareengine.v1.GetLoggingServerRequest;
import com.google.cloud.vmwareengine.v1.GetManagementDnsZoneBindingRequest;
import com.google.cloud.vmwareengine.v1.GetNetworkPeeringRequest;
import com.google.cloud.vmwareengine.v1.GetNetworkPolicyRequest;
import com.google.cloud.vmwareengine.v1.GetNodeRequest;
import com.google.cloud.vmwareengine.v1.GetNodeTypeRequest;
import com.google.cloud.vmwareengine.v1.GetPrivateCloudRequest;
import com.google.cloud.vmwareengine.v1.GetPrivateConnectionRequest;
import com.google.cloud.vmwareengine.v1.GetSubnetRequest;
import com.google.cloud.vmwareengine.v1.GetVmwareEngineNetworkRequest;
import com.google.cloud.vmwareengine.v1.GrantDnsBindPermissionRequest;
import com.google.cloud.vmwareengine.v1.HcxActivationKey;
import com.google.cloud.vmwareengine.v1.HcxActivationKeyName;
import com.google.cloud.vmwareengine.v1.ListClustersRequest;
import com.google.cloud.vmwareengine.v1.ListClustersResponse;
import com.google.cloud.vmwareengine.v1.ListExternalAccessRulesRequest;
import com.google.cloud.vmwareengine.v1.ListExternalAccessRulesResponse;
import com.google.cloud.vmwareengine.v1.ListExternalAddressesRequest;
import com.google.cloud.vmwareengine.v1.ListExternalAddressesResponse;
import com.google.cloud.vmwareengine.v1.ListHcxActivationKeysRequest;
import com.google.cloud.vmwareengine.v1.ListHcxActivationKeysResponse;
import com.google.cloud.vmwareengine.v1.ListLoggingServersRequest;
import com.google.cloud.vmwareengine.v1.ListLoggingServersResponse;
import com.google.cloud.vmwareengine.v1.ListManagementDnsZoneBindingsRequest;
import com.google.cloud.vmwareengine.v1.ListManagementDnsZoneBindingsResponse;
import com.google.cloud.vmwareengine.v1.ListNetworkPeeringsRequest;
import com.google.cloud.vmwareengine.v1.ListNetworkPeeringsResponse;
import com.google.cloud.vmwareengine.v1.ListNetworkPoliciesRequest;
import com.google.cloud.vmwareengine.v1.ListNetworkPoliciesResponse;
import com.google.cloud.vmwareengine.v1.ListNodeTypesRequest;
import com.google.cloud.vmwareengine.v1.ListNodeTypesResponse;
import com.google.cloud.vmwareengine.v1.ListNodesRequest;
import com.google.cloud.vmwareengine.v1.ListNodesResponse;
import com.google.cloud.vmwareengine.v1.ListPeeringRoutesRequest;
import com.google.cloud.vmwareengine.v1.ListPeeringRoutesResponse;
import com.google.cloud.vmwareengine.v1.ListPrivateCloudsRequest;
import com.google.cloud.vmwareengine.v1.ListPrivateCloudsResponse;
import com.google.cloud.vmwareengine.v1.ListPrivateConnectionPeeringRoutesRequest;
import com.google.cloud.vmwareengine.v1.ListPrivateConnectionPeeringRoutesResponse;
import com.google.cloud.vmwareengine.v1.ListPrivateConnectionsRequest;
import com.google.cloud.vmwareengine.v1.ListPrivateConnectionsResponse;
import com.google.cloud.vmwareengine.v1.ListSubnetsRequest;
import com.google.cloud.vmwareengine.v1.ListSubnetsResponse;
import com.google.cloud.vmwareengine.v1.ListVmwareEngineNetworksRequest;
import com.google.cloud.vmwareengine.v1.ListVmwareEngineNetworksResponse;
import com.google.cloud.vmwareengine.v1.LocationName;
import com.google.cloud.vmwareengine.v1.LoggingServer;
import com.google.cloud.vmwareengine.v1.LoggingServerName;
import com.google.cloud.vmwareengine.v1.ManagementDnsZoneBinding;
import com.google.cloud.vmwareengine.v1.ManagementDnsZoneBindingName;
import com.google.cloud.vmwareengine.v1.NetworkPeering;
import com.google.cloud.vmwareengine.v1.NetworkPeeringName;
import com.google.cloud.vmwareengine.v1.NetworkPolicy;
import com.google.cloud.vmwareengine.v1.NetworkPolicyName;
import com.google.cloud.vmwareengine.v1.Node;
import com.google.cloud.vmwareengine.v1.NodeName;
import com.google.cloud.vmwareengine.v1.NodeType;
import com.google.cloud.vmwareengine.v1.NodeTypeName;
import com.google.cloud.vmwareengine.v1.OperationMetadata;
import com.google.cloud.vmwareengine.v1.PeeringRoute;
import com.google.cloud.vmwareengine.v1.Principal;
import com.google.cloud.vmwareengine.v1.PrivateCloud;
import com.google.cloud.vmwareengine.v1.PrivateCloudName;
import com.google.cloud.vmwareengine.v1.PrivateConnection;
import com.google.cloud.vmwareengine.v1.PrivateConnectionName;
import com.google.cloud.vmwareengine.v1.RepairManagementDnsZoneBindingRequest;
import com.google.cloud.vmwareengine.v1.ResetNsxCredentialsRequest;
import com.google.cloud.vmwareengine.v1.ResetVcenterCredentialsRequest;
import com.google.cloud.vmwareengine.v1.RevokeDnsBindPermissionRequest;
import com.google.cloud.vmwareengine.v1.ShowNsxCredentialsRequest;
import com.google.cloud.vmwareengine.v1.ShowVcenterCredentialsRequest;
import com.google.cloud.vmwareengine.v1.Subnet;
import com.google.cloud.vmwareengine.v1.SubnetName;
import com.google.cloud.vmwareengine.v1.UndeletePrivateCloudRequest;
import com.google.cloud.vmwareengine.v1.UpdateClusterRequest;
import com.google.cloud.vmwareengine.v1.UpdateDnsForwardingRequest;
import com.google.cloud.vmwareengine.v1.UpdateExternalAccessRuleRequest;
import com.google.cloud.vmwareengine.v1.UpdateExternalAddressRequest;
import com.google.cloud.vmwareengine.v1.UpdateLoggingServerRequest;
import com.google.cloud.vmwareengine.v1.UpdateManagementDnsZoneBindingRequest;
import com.google.cloud.vmwareengine.v1.UpdateNetworkPeeringRequest;
import com.google.cloud.vmwareengine.v1.UpdateNetworkPolicyRequest;
import com.google.cloud.vmwareengine.v1.UpdatePrivateCloudRequest;
import com.google.cloud.vmwareengine.v1.UpdatePrivateConnectionRequest;
import com.google.cloud.vmwareengine.v1.UpdateSubnetRequest;
import com.google.cloud.vmwareengine.v1.UpdateVmwareEngineNetworkRequest;
import com.google.cloud.vmwareengine.v1.VmwareEngineNetwork;
import com.google.cloud.vmwareengine.v1.VmwareEngineNetworkName;
import com.google.cloud.vmwareengine.v1.VmwareEngineSettings;
import com.google.cloud.vmwareengine.v1.stub.VmwareEngineStub;
import com.google.cloud.vmwareengine.v1.stub.VmwareEngineStubSettings;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.iam.v1.GetIamPolicyRequest;
import com.google.iam.v1.Policy;
import com.google.iam.v1.SetIamPolicyRequest;
import com.google.iam.v1.TestIamPermissionsRequest;
import com.google.iam.v1.TestIamPermissionsResponse;
import com.google.longrunning.Operation;
import com.google.longrunning.OperationsClient;
import com.google.longrunning.stub.OperationsStub;
import com.google.protobuf.Empty;
import com.google.protobuf.FieldMask;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

public class VmwareEngineClient
implements BackgroundResource {
    private final VmwareEngineSettings settings;
    private final VmwareEngineStub stub;
    private final com.google.api.gax.httpjson.longrunning.OperationsClient httpJsonOperationsClient;
    private final OperationsClient operationsClient;

    public static final VmwareEngineClient create() throws IOException {
        return VmwareEngineClient.create(VmwareEngineSettings.newBuilder().build());
    }

    public static final VmwareEngineClient create(VmwareEngineSettings settings) throws IOException {
        return new VmwareEngineClient(settings);
    }

    public static final VmwareEngineClient create(VmwareEngineStub stub) {
        return new VmwareEngineClient(stub);
    }

    protected VmwareEngineClient(VmwareEngineSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((VmwareEngineStubSettings)settings.getStubSettings()).createStub();
        this.operationsClient = OperationsClient.create((OperationsStub)this.stub.getOperationsStub());
        this.httpJsonOperationsClient = com.google.api.gax.httpjson.longrunning.OperationsClient.create((com.google.api.gax.httpjson.longrunning.stub.OperationsStub)this.stub.getHttpJsonOperationsStub());
    }

    protected VmwareEngineClient(VmwareEngineStub stub) {
        this.settings = null;
        this.stub = stub;
        this.operationsClient = OperationsClient.create((OperationsStub)this.stub.getOperationsStub());
        this.httpJsonOperationsClient = com.google.api.gax.httpjson.longrunning.OperationsClient.create((com.google.api.gax.httpjson.longrunning.stub.OperationsStub)this.stub.getHttpJsonOperationsStub());
    }

    public final VmwareEngineSettings getSettings() {
        return this.settings;
    }

    public VmwareEngineStub getStub() {
        return this.stub;
    }

    public final OperationsClient getOperationsClient() {
        return this.operationsClient;
    }

    @BetaApi
    public final com.google.api.gax.httpjson.longrunning.OperationsClient getHttpJsonOperationsClient() {
        return this.httpJsonOperationsClient;
    }

    public final ListPrivateCloudsPagedResponse listPrivateClouds(LocationName parent) {
        ListPrivateCloudsRequest request = ListPrivateCloudsRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listPrivateClouds(request);
    }

    public final ListPrivateCloudsPagedResponse listPrivateClouds(String parent) {
        ListPrivateCloudsRequest request = ListPrivateCloudsRequest.newBuilder().setParent(parent).build();
        return this.listPrivateClouds(request);
    }

    public final ListPrivateCloudsPagedResponse listPrivateClouds(ListPrivateCloudsRequest request) {
        return (ListPrivateCloudsPagedResponse)((Object)this.listPrivateCloudsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListPrivateCloudsRequest, ListPrivateCloudsPagedResponse> listPrivateCloudsPagedCallable() {
        return this.stub.listPrivateCloudsPagedCallable();
    }

    public final UnaryCallable<ListPrivateCloudsRequest, ListPrivateCloudsResponse> listPrivateCloudsCallable() {
        return this.stub.listPrivateCloudsCallable();
    }

    public final PrivateCloud getPrivateCloud(PrivateCloudName name) {
        GetPrivateCloudRequest request = GetPrivateCloudRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getPrivateCloud(request);
    }

    public final PrivateCloud getPrivateCloud(String name) {
        GetPrivateCloudRequest request = GetPrivateCloudRequest.newBuilder().setName(name).build();
        return this.getPrivateCloud(request);
    }

    public final PrivateCloud getPrivateCloud(GetPrivateCloudRequest request) {
        return (PrivateCloud)this.getPrivateCloudCallable().call((Object)request);
    }

    public final UnaryCallable<GetPrivateCloudRequest, PrivateCloud> getPrivateCloudCallable() {
        return this.stub.getPrivateCloudCallable();
    }

    public final OperationFuture<PrivateCloud, OperationMetadata> createPrivateCloudAsync(LocationName parent, PrivateCloud privateCloud, String privateCloudId) {
        CreatePrivateCloudRequest request = CreatePrivateCloudRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setPrivateCloud(privateCloud).setPrivateCloudId(privateCloudId).build();
        return this.createPrivateCloudAsync(request);
    }

    public final OperationFuture<PrivateCloud, OperationMetadata> createPrivateCloudAsync(String parent, PrivateCloud privateCloud, String privateCloudId) {
        CreatePrivateCloudRequest request = CreatePrivateCloudRequest.newBuilder().setParent(parent).setPrivateCloud(privateCloud).setPrivateCloudId(privateCloudId).build();
        return this.createPrivateCloudAsync(request);
    }

    public final OperationFuture<PrivateCloud, OperationMetadata> createPrivateCloudAsync(CreatePrivateCloudRequest request) {
        return this.createPrivateCloudOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<CreatePrivateCloudRequest, PrivateCloud, OperationMetadata> createPrivateCloudOperationCallable() {
        return this.stub.createPrivateCloudOperationCallable();
    }

    public final UnaryCallable<CreatePrivateCloudRequest, Operation> createPrivateCloudCallable() {
        return this.stub.createPrivateCloudCallable();
    }

    public final OperationFuture<PrivateCloud, OperationMetadata> updatePrivateCloudAsync(PrivateCloud privateCloud, FieldMask updateMask) {
        UpdatePrivateCloudRequest request = UpdatePrivateCloudRequest.newBuilder().setPrivateCloud(privateCloud).setUpdateMask(updateMask).build();
        return this.updatePrivateCloudAsync(request);
    }

    public final OperationFuture<PrivateCloud, OperationMetadata> updatePrivateCloudAsync(UpdatePrivateCloudRequest request) {
        return this.updatePrivateCloudOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<UpdatePrivateCloudRequest, PrivateCloud, OperationMetadata> updatePrivateCloudOperationCallable() {
        return this.stub.updatePrivateCloudOperationCallable();
    }

    public final UnaryCallable<UpdatePrivateCloudRequest, Operation> updatePrivateCloudCallable() {
        return this.stub.updatePrivateCloudCallable();
    }

    public final OperationFuture<PrivateCloud, OperationMetadata> deletePrivateCloudAsync(PrivateCloudName name) {
        DeletePrivateCloudRequest request = DeletePrivateCloudRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.deletePrivateCloudAsync(request);
    }

    public final OperationFuture<PrivateCloud, OperationMetadata> deletePrivateCloudAsync(String name) {
        DeletePrivateCloudRequest request = DeletePrivateCloudRequest.newBuilder().setName(name).build();
        return this.deletePrivateCloudAsync(request);
    }

    public final OperationFuture<PrivateCloud, OperationMetadata> deletePrivateCloudAsync(DeletePrivateCloudRequest request) {
        return this.deletePrivateCloudOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<DeletePrivateCloudRequest, PrivateCloud, OperationMetadata> deletePrivateCloudOperationCallable() {
        return this.stub.deletePrivateCloudOperationCallable();
    }

    public final UnaryCallable<DeletePrivateCloudRequest, Operation> deletePrivateCloudCallable() {
        return this.stub.deletePrivateCloudCallable();
    }

    public final OperationFuture<PrivateCloud, OperationMetadata> undeletePrivateCloudAsync(PrivateCloudName name) {
        UndeletePrivateCloudRequest request = UndeletePrivateCloudRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.undeletePrivateCloudAsync(request);
    }

    public final OperationFuture<PrivateCloud, OperationMetadata> undeletePrivateCloudAsync(String name) {
        UndeletePrivateCloudRequest request = UndeletePrivateCloudRequest.newBuilder().setName(name).build();
        return this.undeletePrivateCloudAsync(request);
    }

    public final OperationFuture<PrivateCloud, OperationMetadata> undeletePrivateCloudAsync(UndeletePrivateCloudRequest request) {
        return this.undeletePrivateCloudOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<UndeletePrivateCloudRequest, PrivateCloud, OperationMetadata> undeletePrivateCloudOperationCallable() {
        return this.stub.undeletePrivateCloudOperationCallable();
    }

    public final UnaryCallable<UndeletePrivateCloudRequest, Operation> undeletePrivateCloudCallable() {
        return this.stub.undeletePrivateCloudCallable();
    }

    public final ListClustersPagedResponse listClusters(PrivateCloudName parent) {
        ListClustersRequest request = ListClustersRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listClusters(request);
    }

    public final ListClustersPagedResponse listClusters(String parent) {
        ListClustersRequest request = ListClustersRequest.newBuilder().setParent(parent).build();
        return this.listClusters(request);
    }

    public final ListClustersPagedResponse listClusters(ListClustersRequest request) {
        return (ListClustersPagedResponse)((Object)this.listClustersPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListClustersRequest, ListClustersPagedResponse> listClustersPagedCallable() {
        return this.stub.listClustersPagedCallable();
    }

    public final UnaryCallable<ListClustersRequest, ListClustersResponse> listClustersCallable() {
        return this.stub.listClustersCallable();
    }

    public final Cluster getCluster(ClusterName name) {
        GetClusterRequest request = GetClusterRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getCluster(request);
    }

    public final Cluster getCluster(String name) {
        GetClusterRequest request = GetClusterRequest.newBuilder().setName(name).build();
        return this.getCluster(request);
    }

    public final Cluster getCluster(GetClusterRequest request) {
        return (Cluster)this.getClusterCallable().call((Object)request);
    }

    public final UnaryCallable<GetClusterRequest, Cluster> getClusterCallable() {
        return this.stub.getClusterCallable();
    }

    public final OperationFuture<Cluster, OperationMetadata> createClusterAsync(PrivateCloudName parent, Cluster cluster, String clusterId) {
        CreateClusterRequest request = CreateClusterRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setCluster(cluster).setClusterId(clusterId).build();
        return this.createClusterAsync(request);
    }

    public final OperationFuture<Cluster, OperationMetadata> createClusterAsync(String parent, Cluster cluster, String clusterId) {
        CreateClusterRequest request = CreateClusterRequest.newBuilder().setParent(parent).setCluster(cluster).setClusterId(clusterId).build();
        return this.createClusterAsync(request);
    }

    public final OperationFuture<Cluster, OperationMetadata> createClusterAsync(CreateClusterRequest request) {
        return this.createClusterOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<CreateClusterRequest, Cluster, OperationMetadata> createClusterOperationCallable() {
        return this.stub.createClusterOperationCallable();
    }

    public final UnaryCallable<CreateClusterRequest, Operation> createClusterCallable() {
        return this.stub.createClusterCallable();
    }

    public final OperationFuture<Cluster, OperationMetadata> updateClusterAsync(Cluster cluster, FieldMask updateMask) {
        UpdateClusterRequest request = UpdateClusterRequest.newBuilder().setCluster(cluster).setUpdateMask(updateMask).build();
        return this.updateClusterAsync(request);
    }

    public final OperationFuture<Cluster, OperationMetadata> updateClusterAsync(UpdateClusterRequest request) {
        return this.updateClusterOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<UpdateClusterRequest, Cluster, OperationMetadata> updateClusterOperationCallable() {
        return this.stub.updateClusterOperationCallable();
    }

    public final UnaryCallable<UpdateClusterRequest, Operation> updateClusterCallable() {
        return this.stub.updateClusterCallable();
    }

    public final OperationFuture<Empty, OperationMetadata> deleteClusterAsync(ClusterName name) {
        DeleteClusterRequest request = DeleteClusterRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.deleteClusterAsync(request);
    }

    public final OperationFuture<Empty, OperationMetadata> deleteClusterAsync(String name) {
        DeleteClusterRequest request = DeleteClusterRequest.newBuilder().setName(name).build();
        return this.deleteClusterAsync(request);
    }

    public final OperationFuture<Empty, OperationMetadata> deleteClusterAsync(DeleteClusterRequest request) {
        return this.deleteClusterOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<DeleteClusterRequest, Empty, OperationMetadata> deleteClusterOperationCallable() {
        return this.stub.deleteClusterOperationCallable();
    }

    public final UnaryCallable<DeleteClusterRequest, Operation> deleteClusterCallable() {
        return this.stub.deleteClusterCallable();
    }

    public final ListNodesPagedResponse listNodes(ClusterName parent) {
        ListNodesRequest request = ListNodesRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listNodes(request);
    }

    public final ListNodesPagedResponse listNodes(String parent) {
        ListNodesRequest request = ListNodesRequest.newBuilder().setParent(parent).build();
        return this.listNodes(request);
    }

    public final ListNodesPagedResponse listNodes(ListNodesRequest request) {
        return (ListNodesPagedResponse)((Object)this.listNodesPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListNodesRequest, ListNodesPagedResponse> listNodesPagedCallable() {
        return this.stub.listNodesPagedCallable();
    }

    public final UnaryCallable<ListNodesRequest, ListNodesResponse> listNodesCallable() {
        return this.stub.listNodesCallable();
    }

    public final Node getNode(NodeName name) {
        GetNodeRequest request = GetNodeRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getNode(request);
    }

    public final Node getNode(String name) {
        GetNodeRequest request = GetNodeRequest.newBuilder().setName(name).build();
        return this.getNode(request);
    }

    public final Node getNode(GetNodeRequest request) {
        return (Node)this.getNodeCallable().call((Object)request);
    }

    public final UnaryCallable<GetNodeRequest, Node> getNodeCallable() {
        return this.stub.getNodeCallable();
    }

    public final ListExternalAddressesPagedResponse listExternalAddresses(PrivateCloudName parent) {
        ListExternalAddressesRequest request = ListExternalAddressesRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listExternalAddresses(request);
    }

    public final ListExternalAddressesPagedResponse listExternalAddresses(String parent) {
        ListExternalAddressesRequest request = ListExternalAddressesRequest.newBuilder().setParent(parent).build();
        return this.listExternalAddresses(request);
    }

    public final ListExternalAddressesPagedResponse listExternalAddresses(ListExternalAddressesRequest request) {
        return (ListExternalAddressesPagedResponse)((Object)this.listExternalAddressesPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListExternalAddressesRequest, ListExternalAddressesPagedResponse> listExternalAddressesPagedCallable() {
        return this.stub.listExternalAddressesPagedCallable();
    }

    public final UnaryCallable<ListExternalAddressesRequest, ListExternalAddressesResponse> listExternalAddressesCallable() {
        return this.stub.listExternalAddressesCallable();
    }

    public final FetchNetworkPolicyExternalAddressesPagedResponse fetchNetworkPolicyExternalAddresses(NetworkPolicyName networkPolicy) {
        FetchNetworkPolicyExternalAddressesRequest request = FetchNetworkPolicyExternalAddressesRequest.newBuilder().setNetworkPolicy(networkPolicy == null ? null : networkPolicy.toString()).build();
        return this.fetchNetworkPolicyExternalAddresses(request);
    }

    public final FetchNetworkPolicyExternalAddressesPagedResponse fetchNetworkPolicyExternalAddresses(String networkPolicy) {
        FetchNetworkPolicyExternalAddressesRequest request = FetchNetworkPolicyExternalAddressesRequest.newBuilder().setNetworkPolicy(networkPolicy).build();
        return this.fetchNetworkPolicyExternalAddresses(request);
    }

    public final FetchNetworkPolicyExternalAddressesPagedResponse fetchNetworkPolicyExternalAddresses(FetchNetworkPolicyExternalAddressesRequest request) {
        return (FetchNetworkPolicyExternalAddressesPagedResponse)((Object)this.fetchNetworkPolicyExternalAddressesPagedCallable().call((Object)request));
    }

    public final UnaryCallable<FetchNetworkPolicyExternalAddressesRequest, FetchNetworkPolicyExternalAddressesPagedResponse> fetchNetworkPolicyExternalAddressesPagedCallable() {
        return this.stub.fetchNetworkPolicyExternalAddressesPagedCallable();
    }

    public final UnaryCallable<FetchNetworkPolicyExternalAddressesRequest, FetchNetworkPolicyExternalAddressesResponse> fetchNetworkPolicyExternalAddressesCallable() {
        return this.stub.fetchNetworkPolicyExternalAddressesCallable();
    }

    public final ExternalAddress getExternalAddress(ExternalAddressName name) {
        GetExternalAddressRequest request = GetExternalAddressRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getExternalAddress(request);
    }

    public final ExternalAddress getExternalAddress(String name) {
        GetExternalAddressRequest request = GetExternalAddressRequest.newBuilder().setName(name).build();
        return this.getExternalAddress(request);
    }

    public final ExternalAddress getExternalAddress(GetExternalAddressRequest request) {
        return (ExternalAddress)this.getExternalAddressCallable().call((Object)request);
    }

    public final UnaryCallable<GetExternalAddressRequest, ExternalAddress> getExternalAddressCallable() {
        return this.stub.getExternalAddressCallable();
    }

    public final OperationFuture<ExternalAddress, OperationMetadata> createExternalAddressAsync(PrivateCloudName parent, ExternalAddress externalAddress, String externalAddressId) {
        CreateExternalAddressRequest request = CreateExternalAddressRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setExternalAddress(externalAddress).setExternalAddressId(externalAddressId).build();
        return this.createExternalAddressAsync(request);
    }

    public final OperationFuture<ExternalAddress, OperationMetadata> createExternalAddressAsync(String parent, ExternalAddress externalAddress, String externalAddressId) {
        CreateExternalAddressRequest request = CreateExternalAddressRequest.newBuilder().setParent(parent).setExternalAddress(externalAddress).setExternalAddressId(externalAddressId).build();
        return this.createExternalAddressAsync(request);
    }

    public final OperationFuture<ExternalAddress, OperationMetadata> createExternalAddressAsync(CreateExternalAddressRequest request) {
        return this.createExternalAddressOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<CreateExternalAddressRequest, ExternalAddress, OperationMetadata> createExternalAddressOperationCallable() {
        return this.stub.createExternalAddressOperationCallable();
    }

    public final UnaryCallable<CreateExternalAddressRequest, Operation> createExternalAddressCallable() {
        return this.stub.createExternalAddressCallable();
    }

    public final OperationFuture<ExternalAddress, OperationMetadata> updateExternalAddressAsync(ExternalAddress externalAddress, FieldMask updateMask) {
        UpdateExternalAddressRequest request = UpdateExternalAddressRequest.newBuilder().setExternalAddress(externalAddress).setUpdateMask(updateMask).build();
        return this.updateExternalAddressAsync(request);
    }

    public final OperationFuture<ExternalAddress, OperationMetadata> updateExternalAddressAsync(UpdateExternalAddressRequest request) {
        return this.updateExternalAddressOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<UpdateExternalAddressRequest, ExternalAddress, OperationMetadata> updateExternalAddressOperationCallable() {
        return this.stub.updateExternalAddressOperationCallable();
    }

    public final UnaryCallable<UpdateExternalAddressRequest, Operation> updateExternalAddressCallable() {
        return this.stub.updateExternalAddressCallable();
    }

    public final OperationFuture<Empty, OperationMetadata> deleteExternalAddressAsync(ExternalAddressName name) {
        DeleteExternalAddressRequest request = DeleteExternalAddressRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.deleteExternalAddressAsync(request);
    }

    public final OperationFuture<Empty, OperationMetadata> deleteExternalAddressAsync(String name) {
        DeleteExternalAddressRequest request = DeleteExternalAddressRequest.newBuilder().setName(name).build();
        return this.deleteExternalAddressAsync(request);
    }

    public final OperationFuture<Empty, OperationMetadata> deleteExternalAddressAsync(DeleteExternalAddressRequest request) {
        return this.deleteExternalAddressOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<DeleteExternalAddressRequest, Empty, OperationMetadata> deleteExternalAddressOperationCallable() {
        return this.stub.deleteExternalAddressOperationCallable();
    }

    public final UnaryCallable<DeleteExternalAddressRequest, Operation> deleteExternalAddressCallable() {
        return this.stub.deleteExternalAddressCallable();
    }

    public final ListSubnetsPagedResponse listSubnets(PrivateCloudName parent) {
        ListSubnetsRequest request = ListSubnetsRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listSubnets(request);
    }

    public final ListSubnetsPagedResponse listSubnets(String parent) {
        ListSubnetsRequest request = ListSubnetsRequest.newBuilder().setParent(parent).build();
        return this.listSubnets(request);
    }

    public final ListSubnetsPagedResponse listSubnets(ListSubnetsRequest request) {
        return (ListSubnetsPagedResponse)((Object)this.listSubnetsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListSubnetsRequest, ListSubnetsPagedResponse> listSubnetsPagedCallable() {
        return this.stub.listSubnetsPagedCallable();
    }

    public final UnaryCallable<ListSubnetsRequest, ListSubnetsResponse> listSubnetsCallable() {
        return this.stub.listSubnetsCallable();
    }

    public final Subnet getSubnet(SubnetName name) {
        GetSubnetRequest request = GetSubnetRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getSubnet(request);
    }

    public final Subnet getSubnet(String name) {
        GetSubnetRequest request = GetSubnetRequest.newBuilder().setName(name).build();
        return this.getSubnet(request);
    }

    public final Subnet getSubnet(GetSubnetRequest request) {
        return (Subnet)this.getSubnetCallable().call((Object)request);
    }

    public final UnaryCallable<GetSubnetRequest, Subnet> getSubnetCallable() {
        return this.stub.getSubnetCallable();
    }

    public final OperationFuture<Subnet, OperationMetadata> updateSubnetAsync(Subnet subnet, FieldMask updateMask) {
        UpdateSubnetRequest request = UpdateSubnetRequest.newBuilder().setSubnet(subnet).setUpdateMask(updateMask).build();
        return this.updateSubnetAsync(request);
    }

    public final OperationFuture<Subnet, OperationMetadata> updateSubnetAsync(UpdateSubnetRequest request) {
        return this.updateSubnetOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<UpdateSubnetRequest, Subnet, OperationMetadata> updateSubnetOperationCallable() {
        return this.stub.updateSubnetOperationCallable();
    }

    public final UnaryCallable<UpdateSubnetRequest, Operation> updateSubnetCallable() {
        return this.stub.updateSubnetCallable();
    }

    public final ListExternalAccessRulesPagedResponse listExternalAccessRules(NetworkPolicyName parent) {
        ListExternalAccessRulesRequest request = ListExternalAccessRulesRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listExternalAccessRules(request);
    }

    public final ListExternalAccessRulesPagedResponse listExternalAccessRules(String parent) {
        ListExternalAccessRulesRequest request = ListExternalAccessRulesRequest.newBuilder().setParent(parent).build();
        return this.listExternalAccessRules(request);
    }

    public final ListExternalAccessRulesPagedResponse listExternalAccessRules(ListExternalAccessRulesRequest request) {
        return (ListExternalAccessRulesPagedResponse)((Object)this.listExternalAccessRulesPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListExternalAccessRulesRequest, ListExternalAccessRulesPagedResponse> listExternalAccessRulesPagedCallable() {
        return this.stub.listExternalAccessRulesPagedCallable();
    }

    public final UnaryCallable<ListExternalAccessRulesRequest, ListExternalAccessRulesResponse> listExternalAccessRulesCallable() {
        return this.stub.listExternalAccessRulesCallable();
    }

    public final ExternalAccessRule getExternalAccessRule(ExternalAccessRuleName name) {
        GetExternalAccessRuleRequest request = GetExternalAccessRuleRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getExternalAccessRule(request);
    }

    public final ExternalAccessRule getExternalAccessRule(String name) {
        GetExternalAccessRuleRequest request = GetExternalAccessRuleRequest.newBuilder().setName(name).build();
        return this.getExternalAccessRule(request);
    }

    public final ExternalAccessRule getExternalAccessRule(GetExternalAccessRuleRequest request) {
        return (ExternalAccessRule)this.getExternalAccessRuleCallable().call((Object)request);
    }

    public final UnaryCallable<GetExternalAccessRuleRequest, ExternalAccessRule> getExternalAccessRuleCallable() {
        return this.stub.getExternalAccessRuleCallable();
    }

    public final OperationFuture<ExternalAccessRule, OperationMetadata> createExternalAccessRuleAsync(NetworkPolicyName parent, ExternalAccessRule externalAccessRule, String externalAccessRuleId) {
        CreateExternalAccessRuleRequest request = CreateExternalAccessRuleRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setExternalAccessRule(externalAccessRule).setExternalAccessRuleId(externalAccessRuleId).build();
        return this.createExternalAccessRuleAsync(request);
    }

    public final OperationFuture<ExternalAccessRule, OperationMetadata> createExternalAccessRuleAsync(String parent, ExternalAccessRule externalAccessRule, String externalAccessRuleId) {
        CreateExternalAccessRuleRequest request = CreateExternalAccessRuleRequest.newBuilder().setParent(parent).setExternalAccessRule(externalAccessRule).setExternalAccessRuleId(externalAccessRuleId).build();
        return this.createExternalAccessRuleAsync(request);
    }

    public final OperationFuture<ExternalAccessRule, OperationMetadata> createExternalAccessRuleAsync(CreateExternalAccessRuleRequest request) {
        return this.createExternalAccessRuleOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<CreateExternalAccessRuleRequest, ExternalAccessRule, OperationMetadata> createExternalAccessRuleOperationCallable() {
        return this.stub.createExternalAccessRuleOperationCallable();
    }

    public final UnaryCallable<CreateExternalAccessRuleRequest, Operation> createExternalAccessRuleCallable() {
        return this.stub.createExternalAccessRuleCallable();
    }

    public final OperationFuture<ExternalAccessRule, OperationMetadata> updateExternalAccessRuleAsync(ExternalAccessRule externalAccessRule, FieldMask updateMask) {
        UpdateExternalAccessRuleRequest request = UpdateExternalAccessRuleRequest.newBuilder().setExternalAccessRule(externalAccessRule).setUpdateMask(updateMask).build();
        return this.updateExternalAccessRuleAsync(request);
    }

    public final OperationFuture<ExternalAccessRule, OperationMetadata> updateExternalAccessRuleAsync(UpdateExternalAccessRuleRequest request) {
        return this.updateExternalAccessRuleOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<UpdateExternalAccessRuleRequest, ExternalAccessRule, OperationMetadata> updateExternalAccessRuleOperationCallable() {
        return this.stub.updateExternalAccessRuleOperationCallable();
    }

    public final UnaryCallable<UpdateExternalAccessRuleRequest, Operation> updateExternalAccessRuleCallable() {
        return this.stub.updateExternalAccessRuleCallable();
    }

    public final OperationFuture<Empty, OperationMetadata> deleteExternalAccessRuleAsync(ExternalAccessRuleName name) {
        DeleteExternalAccessRuleRequest request = DeleteExternalAccessRuleRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.deleteExternalAccessRuleAsync(request);
    }

    public final OperationFuture<Empty, OperationMetadata> deleteExternalAccessRuleAsync(String name) {
        DeleteExternalAccessRuleRequest request = DeleteExternalAccessRuleRequest.newBuilder().setName(name).build();
        return this.deleteExternalAccessRuleAsync(request);
    }

    public final OperationFuture<Empty, OperationMetadata> deleteExternalAccessRuleAsync(DeleteExternalAccessRuleRequest request) {
        return this.deleteExternalAccessRuleOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<DeleteExternalAccessRuleRequest, Empty, OperationMetadata> deleteExternalAccessRuleOperationCallable() {
        return this.stub.deleteExternalAccessRuleOperationCallable();
    }

    public final UnaryCallable<DeleteExternalAccessRuleRequest, Operation> deleteExternalAccessRuleCallable() {
        return this.stub.deleteExternalAccessRuleCallable();
    }

    public final ListLoggingServersPagedResponse listLoggingServers(PrivateCloudName parent) {
        ListLoggingServersRequest request = ListLoggingServersRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listLoggingServers(request);
    }

    public final ListLoggingServersPagedResponse listLoggingServers(String parent) {
        ListLoggingServersRequest request = ListLoggingServersRequest.newBuilder().setParent(parent).build();
        return this.listLoggingServers(request);
    }

    public final ListLoggingServersPagedResponse listLoggingServers(ListLoggingServersRequest request) {
        return (ListLoggingServersPagedResponse)((Object)this.listLoggingServersPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListLoggingServersRequest, ListLoggingServersPagedResponse> listLoggingServersPagedCallable() {
        return this.stub.listLoggingServersPagedCallable();
    }

    public final UnaryCallable<ListLoggingServersRequest, ListLoggingServersResponse> listLoggingServersCallable() {
        return this.stub.listLoggingServersCallable();
    }

    public final LoggingServer getLoggingServer(LoggingServerName name) {
        GetLoggingServerRequest request = GetLoggingServerRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getLoggingServer(request);
    }

    public final LoggingServer getLoggingServer(String name) {
        GetLoggingServerRequest request = GetLoggingServerRequest.newBuilder().setName(name).build();
        return this.getLoggingServer(request);
    }

    public final LoggingServer getLoggingServer(GetLoggingServerRequest request) {
        return (LoggingServer)this.getLoggingServerCallable().call((Object)request);
    }

    public final UnaryCallable<GetLoggingServerRequest, LoggingServer> getLoggingServerCallable() {
        return this.stub.getLoggingServerCallable();
    }

    public final OperationFuture<LoggingServer, OperationMetadata> createLoggingServerAsync(PrivateCloudName parent, LoggingServer loggingServer, String loggingServerId) {
        CreateLoggingServerRequest request = CreateLoggingServerRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setLoggingServer(loggingServer).setLoggingServerId(loggingServerId).build();
        return this.createLoggingServerAsync(request);
    }

    public final OperationFuture<LoggingServer, OperationMetadata> createLoggingServerAsync(String parent, LoggingServer loggingServer, String loggingServerId) {
        CreateLoggingServerRequest request = CreateLoggingServerRequest.newBuilder().setParent(parent).setLoggingServer(loggingServer).setLoggingServerId(loggingServerId).build();
        return this.createLoggingServerAsync(request);
    }

    public final OperationFuture<LoggingServer, OperationMetadata> createLoggingServerAsync(CreateLoggingServerRequest request) {
        return this.createLoggingServerOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<CreateLoggingServerRequest, LoggingServer, OperationMetadata> createLoggingServerOperationCallable() {
        return this.stub.createLoggingServerOperationCallable();
    }

    public final UnaryCallable<CreateLoggingServerRequest, Operation> createLoggingServerCallable() {
        return this.stub.createLoggingServerCallable();
    }

    public final OperationFuture<LoggingServer, OperationMetadata> updateLoggingServerAsync(LoggingServer loggingServer, FieldMask updateMask) {
        UpdateLoggingServerRequest request = UpdateLoggingServerRequest.newBuilder().setLoggingServer(loggingServer).setUpdateMask(updateMask).build();
        return this.updateLoggingServerAsync(request);
    }

    public final OperationFuture<LoggingServer, OperationMetadata> updateLoggingServerAsync(UpdateLoggingServerRequest request) {
        return this.updateLoggingServerOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<UpdateLoggingServerRequest, LoggingServer, OperationMetadata> updateLoggingServerOperationCallable() {
        return this.stub.updateLoggingServerOperationCallable();
    }

    public final UnaryCallable<UpdateLoggingServerRequest, Operation> updateLoggingServerCallable() {
        return this.stub.updateLoggingServerCallable();
    }

    public final OperationFuture<Empty, OperationMetadata> deleteLoggingServerAsync(LoggingServerName name) {
        DeleteLoggingServerRequest request = DeleteLoggingServerRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.deleteLoggingServerAsync(request);
    }

    public final OperationFuture<Empty, OperationMetadata> deleteLoggingServerAsync(String name) {
        DeleteLoggingServerRequest request = DeleteLoggingServerRequest.newBuilder().setName(name).build();
        return this.deleteLoggingServerAsync(request);
    }

    public final OperationFuture<Empty, OperationMetadata> deleteLoggingServerAsync(DeleteLoggingServerRequest request) {
        return this.deleteLoggingServerOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<DeleteLoggingServerRequest, Empty, OperationMetadata> deleteLoggingServerOperationCallable() {
        return this.stub.deleteLoggingServerOperationCallable();
    }

    public final UnaryCallable<DeleteLoggingServerRequest, Operation> deleteLoggingServerCallable() {
        return this.stub.deleteLoggingServerCallable();
    }

    public final ListNodeTypesPagedResponse listNodeTypes(LocationName parent) {
        ListNodeTypesRequest request = ListNodeTypesRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listNodeTypes(request);
    }

    public final ListNodeTypesPagedResponse listNodeTypes(String parent) {
        ListNodeTypesRequest request = ListNodeTypesRequest.newBuilder().setParent(parent).build();
        return this.listNodeTypes(request);
    }

    public final ListNodeTypesPagedResponse listNodeTypes(ListNodeTypesRequest request) {
        return (ListNodeTypesPagedResponse)((Object)this.listNodeTypesPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListNodeTypesRequest, ListNodeTypesPagedResponse> listNodeTypesPagedCallable() {
        return this.stub.listNodeTypesPagedCallable();
    }

    public final UnaryCallable<ListNodeTypesRequest, ListNodeTypesResponse> listNodeTypesCallable() {
        return this.stub.listNodeTypesCallable();
    }

    public final NodeType getNodeType(NodeTypeName name) {
        GetNodeTypeRequest request = GetNodeTypeRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getNodeType(request);
    }

    public final NodeType getNodeType(String name) {
        GetNodeTypeRequest request = GetNodeTypeRequest.newBuilder().setName(name).build();
        return this.getNodeType(request);
    }

    public final NodeType getNodeType(GetNodeTypeRequest request) {
        return (NodeType)this.getNodeTypeCallable().call((Object)request);
    }

    public final UnaryCallable<GetNodeTypeRequest, NodeType> getNodeTypeCallable() {
        return this.stub.getNodeTypeCallable();
    }

    public final Credentials showNsxCredentials(PrivateCloudName privateCloud) {
        ShowNsxCredentialsRequest request = ShowNsxCredentialsRequest.newBuilder().setPrivateCloud(privateCloud == null ? null : privateCloud.toString()).build();
        return this.showNsxCredentials(request);
    }

    public final Credentials showNsxCredentials(String privateCloud) {
        ShowNsxCredentialsRequest request = ShowNsxCredentialsRequest.newBuilder().setPrivateCloud(privateCloud).build();
        return this.showNsxCredentials(request);
    }

    public final Credentials showNsxCredentials(ShowNsxCredentialsRequest request) {
        return (Credentials)this.showNsxCredentialsCallable().call((Object)request);
    }

    public final UnaryCallable<ShowNsxCredentialsRequest, Credentials> showNsxCredentialsCallable() {
        return this.stub.showNsxCredentialsCallable();
    }

    public final Credentials showVcenterCredentials(PrivateCloudName privateCloud) {
        ShowVcenterCredentialsRequest request = ShowVcenterCredentialsRequest.newBuilder().setPrivateCloud(privateCloud == null ? null : privateCloud.toString()).build();
        return this.showVcenterCredentials(request);
    }

    public final Credentials showVcenterCredentials(String privateCloud) {
        ShowVcenterCredentialsRequest request = ShowVcenterCredentialsRequest.newBuilder().setPrivateCloud(privateCloud).build();
        return this.showVcenterCredentials(request);
    }

    public final Credentials showVcenterCredentials(ShowVcenterCredentialsRequest request) {
        return (Credentials)this.showVcenterCredentialsCallable().call((Object)request);
    }

    public final UnaryCallable<ShowVcenterCredentialsRequest, Credentials> showVcenterCredentialsCallable() {
        return this.stub.showVcenterCredentialsCallable();
    }

    public final OperationFuture<PrivateCloud, OperationMetadata> resetNsxCredentialsAsync(PrivateCloudName privateCloud) {
        ResetNsxCredentialsRequest request = ResetNsxCredentialsRequest.newBuilder().setPrivateCloud(privateCloud == null ? null : privateCloud.toString()).build();
        return this.resetNsxCredentialsAsync(request);
    }

    public final OperationFuture<PrivateCloud, OperationMetadata> resetNsxCredentialsAsync(String privateCloud) {
        ResetNsxCredentialsRequest request = ResetNsxCredentialsRequest.newBuilder().setPrivateCloud(privateCloud).build();
        return this.resetNsxCredentialsAsync(request);
    }

    public final OperationFuture<PrivateCloud, OperationMetadata> resetNsxCredentialsAsync(ResetNsxCredentialsRequest request) {
        return this.resetNsxCredentialsOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<ResetNsxCredentialsRequest, PrivateCloud, OperationMetadata> resetNsxCredentialsOperationCallable() {
        return this.stub.resetNsxCredentialsOperationCallable();
    }

    public final UnaryCallable<ResetNsxCredentialsRequest, Operation> resetNsxCredentialsCallable() {
        return this.stub.resetNsxCredentialsCallable();
    }

    public final OperationFuture<PrivateCloud, OperationMetadata> resetVcenterCredentialsAsync(PrivateCloudName privateCloud) {
        ResetVcenterCredentialsRequest request = ResetVcenterCredentialsRequest.newBuilder().setPrivateCloud(privateCloud == null ? null : privateCloud.toString()).build();
        return this.resetVcenterCredentialsAsync(request);
    }

    public final OperationFuture<PrivateCloud, OperationMetadata> resetVcenterCredentialsAsync(String privateCloud) {
        ResetVcenterCredentialsRequest request = ResetVcenterCredentialsRequest.newBuilder().setPrivateCloud(privateCloud).build();
        return this.resetVcenterCredentialsAsync(request);
    }

    public final OperationFuture<PrivateCloud, OperationMetadata> resetVcenterCredentialsAsync(ResetVcenterCredentialsRequest request) {
        return this.resetVcenterCredentialsOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<ResetVcenterCredentialsRequest, PrivateCloud, OperationMetadata> resetVcenterCredentialsOperationCallable() {
        return this.stub.resetVcenterCredentialsOperationCallable();
    }

    public final UnaryCallable<ResetVcenterCredentialsRequest, Operation> resetVcenterCredentialsCallable() {
        return this.stub.resetVcenterCredentialsCallable();
    }

    public final DnsForwarding getDnsForwarding(DnsForwardingName name) {
        GetDnsForwardingRequest request = GetDnsForwardingRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getDnsForwarding(request);
    }

    public final DnsForwarding getDnsForwarding(String name) {
        GetDnsForwardingRequest request = GetDnsForwardingRequest.newBuilder().setName(name).build();
        return this.getDnsForwarding(request);
    }

    public final DnsForwarding getDnsForwarding(GetDnsForwardingRequest request) {
        return (DnsForwarding)this.getDnsForwardingCallable().call((Object)request);
    }

    public final UnaryCallable<GetDnsForwardingRequest, DnsForwarding> getDnsForwardingCallable() {
        return this.stub.getDnsForwardingCallable();
    }

    public final OperationFuture<DnsForwarding, OperationMetadata> updateDnsForwardingAsync(DnsForwarding dnsForwarding, FieldMask updateMask) {
        UpdateDnsForwardingRequest request = UpdateDnsForwardingRequest.newBuilder().setDnsForwarding(dnsForwarding).setUpdateMask(updateMask).build();
        return this.updateDnsForwardingAsync(request);
    }

    public final OperationFuture<DnsForwarding, OperationMetadata> updateDnsForwardingAsync(UpdateDnsForwardingRequest request) {
        return this.updateDnsForwardingOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<UpdateDnsForwardingRequest, DnsForwarding, OperationMetadata> updateDnsForwardingOperationCallable() {
        return this.stub.updateDnsForwardingOperationCallable();
    }

    public final UnaryCallable<UpdateDnsForwardingRequest, Operation> updateDnsForwardingCallable() {
        return this.stub.updateDnsForwardingCallable();
    }

    public final NetworkPeering getNetworkPeering(NetworkPeeringName name) {
        GetNetworkPeeringRequest request = GetNetworkPeeringRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getNetworkPeering(request);
    }

    public final NetworkPeering getNetworkPeering(String name) {
        GetNetworkPeeringRequest request = GetNetworkPeeringRequest.newBuilder().setName(name).build();
        return this.getNetworkPeering(request);
    }

    public final NetworkPeering getNetworkPeering(GetNetworkPeeringRequest request) {
        return (NetworkPeering)this.getNetworkPeeringCallable().call((Object)request);
    }

    public final UnaryCallable<GetNetworkPeeringRequest, NetworkPeering> getNetworkPeeringCallable() {
        return this.stub.getNetworkPeeringCallable();
    }

    public final ListNetworkPeeringsPagedResponse listNetworkPeerings(LocationName parent) {
        ListNetworkPeeringsRequest request = ListNetworkPeeringsRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listNetworkPeerings(request);
    }

    public final ListNetworkPeeringsPagedResponse listNetworkPeerings(String parent) {
        ListNetworkPeeringsRequest request = ListNetworkPeeringsRequest.newBuilder().setParent(parent).build();
        return this.listNetworkPeerings(request);
    }

    public final ListNetworkPeeringsPagedResponse listNetworkPeerings(ListNetworkPeeringsRequest request) {
        return (ListNetworkPeeringsPagedResponse)((Object)this.listNetworkPeeringsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListNetworkPeeringsRequest, ListNetworkPeeringsPagedResponse> listNetworkPeeringsPagedCallable() {
        return this.stub.listNetworkPeeringsPagedCallable();
    }

    public final UnaryCallable<ListNetworkPeeringsRequest, ListNetworkPeeringsResponse> listNetworkPeeringsCallable() {
        return this.stub.listNetworkPeeringsCallable();
    }

    public final OperationFuture<NetworkPeering, OperationMetadata> createNetworkPeeringAsync(LocationName parent, NetworkPeering networkPeering, String networkPeeringId) {
        CreateNetworkPeeringRequest request = CreateNetworkPeeringRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setNetworkPeering(networkPeering).setNetworkPeeringId(networkPeeringId).build();
        return this.createNetworkPeeringAsync(request);
    }

    public final OperationFuture<NetworkPeering, OperationMetadata> createNetworkPeeringAsync(String parent, NetworkPeering networkPeering, String networkPeeringId) {
        CreateNetworkPeeringRequest request = CreateNetworkPeeringRequest.newBuilder().setParent(parent).setNetworkPeering(networkPeering).setNetworkPeeringId(networkPeeringId).build();
        return this.createNetworkPeeringAsync(request);
    }

    public final OperationFuture<NetworkPeering, OperationMetadata> createNetworkPeeringAsync(CreateNetworkPeeringRequest request) {
        return this.createNetworkPeeringOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<CreateNetworkPeeringRequest, NetworkPeering, OperationMetadata> createNetworkPeeringOperationCallable() {
        return this.stub.createNetworkPeeringOperationCallable();
    }

    public final UnaryCallable<CreateNetworkPeeringRequest, Operation> createNetworkPeeringCallable() {
        return this.stub.createNetworkPeeringCallable();
    }

    public final OperationFuture<Empty, OperationMetadata> deleteNetworkPeeringAsync(NetworkPeeringName name) {
        DeleteNetworkPeeringRequest request = DeleteNetworkPeeringRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.deleteNetworkPeeringAsync(request);
    }

    public final OperationFuture<Empty, OperationMetadata> deleteNetworkPeeringAsync(String name) {
        DeleteNetworkPeeringRequest request = DeleteNetworkPeeringRequest.newBuilder().setName(name).build();
        return this.deleteNetworkPeeringAsync(request);
    }

    public final OperationFuture<Empty, OperationMetadata> deleteNetworkPeeringAsync(DeleteNetworkPeeringRequest request) {
        return this.deleteNetworkPeeringOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<DeleteNetworkPeeringRequest, Empty, OperationMetadata> deleteNetworkPeeringOperationCallable() {
        return this.stub.deleteNetworkPeeringOperationCallable();
    }

    public final UnaryCallable<DeleteNetworkPeeringRequest, Operation> deleteNetworkPeeringCallable() {
        return this.stub.deleteNetworkPeeringCallable();
    }

    public final OperationFuture<NetworkPeering, OperationMetadata> updateNetworkPeeringAsync(NetworkPeering networkPeering, FieldMask updateMask) {
        UpdateNetworkPeeringRequest request = UpdateNetworkPeeringRequest.newBuilder().setNetworkPeering(networkPeering).setUpdateMask(updateMask).build();
        return this.updateNetworkPeeringAsync(request);
    }

    public final OperationFuture<NetworkPeering, OperationMetadata> updateNetworkPeeringAsync(UpdateNetworkPeeringRequest request) {
        return this.updateNetworkPeeringOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<UpdateNetworkPeeringRequest, NetworkPeering, OperationMetadata> updateNetworkPeeringOperationCallable() {
        return this.stub.updateNetworkPeeringOperationCallable();
    }

    public final UnaryCallable<UpdateNetworkPeeringRequest, Operation> updateNetworkPeeringCallable() {
        return this.stub.updateNetworkPeeringCallable();
    }

    public final ListPeeringRoutesPagedResponse listPeeringRoutes(NetworkPeeringName parent) {
        ListPeeringRoutesRequest request = ListPeeringRoutesRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listPeeringRoutes(request);
    }

    public final ListPeeringRoutesPagedResponse listPeeringRoutes(String parent) {
        ListPeeringRoutesRequest request = ListPeeringRoutesRequest.newBuilder().setParent(parent).build();
        return this.listPeeringRoutes(request);
    }

    public final ListPeeringRoutesPagedResponse listPeeringRoutes(ListPeeringRoutesRequest request) {
        return (ListPeeringRoutesPagedResponse)((Object)this.listPeeringRoutesPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListPeeringRoutesRequest, ListPeeringRoutesPagedResponse> listPeeringRoutesPagedCallable() {
        return this.stub.listPeeringRoutesPagedCallable();
    }

    public final UnaryCallable<ListPeeringRoutesRequest, ListPeeringRoutesResponse> listPeeringRoutesCallable() {
        return this.stub.listPeeringRoutesCallable();
    }

    public final OperationFuture<HcxActivationKey, OperationMetadata> createHcxActivationKeyAsync(PrivateCloudName parent, HcxActivationKey hcxActivationKey, String hcxActivationKeyId) {
        CreateHcxActivationKeyRequest request = CreateHcxActivationKeyRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setHcxActivationKey(hcxActivationKey).setHcxActivationKeyId(hcxActivationKeyId).build();
        return this.createHcxActivationKeyAsync(request);
    }

    public final OperationFuture<HcxActivationKey, OperationMetadata> createHcxActivationKeyAsync(String parent, HcxActivationKey hcxActivationKey, String hcxActivationKeyId) {
        CreateHcxActivationKeyRequest request = CreateHcxActivationKeyRequest.newBuilder().setParent(parent).setHcxActivationKey(hcxActivationKey).setHcxActivationKeyId(hcxActivationKeyId).build();
        return this.createHcxActivationKeyAsync(request);
    }

    public final OperationFuture<HcxActivationKey, OperationMetadata> createHcxActivationKeyAsync(CreateHcxActivationKeyRequest request) {
        return this.createHcxActivationKeyOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<CreateHcxActivationKeyRequest, HcxActivationKey, OperationMetadata> createHcxActivationKeyOperationCallable() {
        return this.stub.createHcxActivationKeyOperationCallable();
    }

    public final UnaryCallable<CreateHcxActivationKeyRequest, Operation> createHcxActivationKeyCallable() {
        return this.stub.createHcxActivationKeyCallable();
    }

    public final ListHcxActivationKeysPagedResponse listHcxActivationKeys(PrivateCloudName parent) {
        ListHcxActivationKeysRequest request = ListHcxActivationKeysRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listHcxActivationKeys(request);
    }

    public final ListHcxActivationKeysPagedResponse listHcxActivationKeys(String parent) {
        ListHcxActivationKeysRequest request = ListHcxActivationKeysRequest.newBuilder().setParent(parent).build();
        return this.listHcxActivationKeys(request);
    }

    public final ListHcxActivationKeysPagedResponse listHcxActivationKeys(ListHcxActivationKeysRequest request) {
        return (ListHcxActivationKeysPagedResponse)((Object)this.listHcxActivationKeysPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListHcxActivationKeysRequest, ListHcxActivationKeysPagedResponse> listHcxActivationKeysPagedCallable() {
        return this.stub.listHcxActivationKeysPagedCallable();
    }

    public final UnaryCallable<ListHcxActivationKeysRequest, ListHcxActivationKeysResponse> listHcxActivationKeysCallable() {
        return this.stub.listHcxActivationKeysCallable();
    }

    public final HcxActivationKey getHcxActivationKey(HcxActivationKeyName name) {
        GetHcxActivationKeyRequest request = GetHcxActivationKeyRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getHcxActivationKey(request);
    }

    public final HcxActivationKey getHcxActivationKey(String name) {
        GetHcxActivationKeyRequest request = GetHcxActivationKeyRequest.newBuilder().setName(name).build();
        return this.getHcxActivationKey(request);
    }

    public final HcxActivationKey getHcxActivationKey(GetHcxActivationKeyRequest request) {
        return (HcxActivationKey)this.getHcxActivationKeyCallable().call((Object)request);
    }

    public final UnaryCallable<GetHcxActivationKeyRequest, HcxActivationKey> getHcxActivationKeyCallable() {
        return this.stub.getHcxActivationKeyCallable();
    }

    public final NetworkPolicy getNetworkPolicy(NetworkPolicyName name) {
        GetNetworkPolicyRequest request = GetNetworkPolicyRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getNetworkPolicy(request);
    }

    public final NetworkPolicy getNetworkPolicy(String name) {
        GetNetworkPolicyRequest request = GetNetworkPolicyRequest.newBuilder().setName(name).build();
        return this.getNetworkPolicy(request);
    }

    public final NetworkPolicy getNetworkPolicy(GetNetworkPolicyRequest request) {
        return (NetworkPolicy)this.getNetworkPolicyCallable().call((Object)request);
    }

    public final UnaryCallable<GetNetworkPolicyRequest, NetworkPolicy> getNetworkPolicyCallable() {
        return this.stub.getNetworkPolicyCallable();
    }

    public final ListNetworkPoliciesPagedResponse listNetworkPolicies(LocationName parent) {
        ListNetworkPoliciesRequest request = ListNetworkPoliciesRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listNetworkPolicies(request);
    }

    public final ListNetworkPoliciesPagedResponse listNetworkPolicies(String parent) {
        ListNetworkPoliciesRequest request = ListNetworkPoliciesRequest.newBuilder().setParent(parent).build();
        return this.listNetworkPolicies(request);
    }

    public final ListNetworkPoliciesPagedResponse listNetworkPolicies(ListNetworkPoliciesRequest request) {
        return (ListNetworkPoliciesPagedResponse)((Object)this.listNetworkPoliciesPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListNetworkPoliciesRequest, ListNetworkPoliciesPagedResponse> listNetworkPoliciesPagedCallable() {
        return this.stub.listNetworkPoliciesPagedCallable();
    }

    public final UnaryCallable<ListNetworkPoliciesRequest, ListNetworkPoliciesResponse> listNetworkPoliciesCallable() {
        return this.stub.listNetworkPoliciesCallable();
    }

    public final OperationFuture<NetworkPolicy, OperationMetadata> createNetworkPolicyAsync(LocationName parent, NetworkPolicy networkPolicy, String networkPolicyId) {
        CreateNetworkPolicyRequest request = CreateNetworkPolicyRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setNetworkPolicy(networkPolicy).setNetworkPolicyId(networkPolicyId).build();
        return this.createNetworkPolicyAsync(request);
    }

    public final OperationFuture<NetworkPolicy, OperationMetadata> createNetworkPolicyAsync(String parent, NetworkPolicy networkPolicy, String networkPolicyId) {
        CreateNetworkPolicyRequest request = CreateNetworkPolicyRequest.newBuilder().setParent(parent).setNetworkPolicy(networkPolicy).setNetworkPolicyId(networkPolicyId).build();
        return this.createNetworkPolicyAsync(request);
    }

    public final OperationFuture<NetworkPolicy, OperationMetadata> createNetworkPolicyAsync(CreateNetworkPolicyRequest request) {
        return this.createNetworkPolicyOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<CreateNetworkPolicyRequest, NetworkPolicy, OperationMetadata> createNetworkPolicyOperationCallable() {
        return this.stub.createNetworkPolicyOperationCallable();
    }

    public final UnaryCallable<CreateNetworkPolicyRequest, Operation> createNetworkPolicyCallable() {
        return this.stub.createNetworkPolicyCallable();
    }

    public final OperationFuture<NetworkPolicy, OperationMetadata> updateNetworkPolicyAsync(NetworkPolicy networkPolicy, FieldMask updateMask) {
        UpdateNetworkPolicyRequest request = UpdateNetworkPolicyRequest.newBuilder().setNetworkPolicy(networkPolicy).setUpdateMask(updateMask).build();
        return this.updateNetworkPolicyAsync(request);
    }

    public final OperationFuture<NetworkPolicy, OperationMetadata> updateNetworkPolicyAsync(UpdateNetworkPolicyRequest request) {
        return this.updateNetworkPolicyOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<UpdateNetworkPolicyRequest, NetworkPolicy, OperationMetadata> updateNetworkPolicyOperationCallable() {
        return this.stub.updateNetworkPolicyOperationCallable();
    }

    public final UnaryCallable<UpdateNetworkPolicyRequest, Operation> updateNetworkPolicyCallable() {
        return this.stub.updateNetworkPolicyCallable();
    }

    public final OperationFuture<Empty, OperationMetadata> deleteNetworkPolicyAsync(NetworkPolicyName name) {
        DeleteNetworkPolicyRequest request = DeleteNetworkPolicyRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.deleteNetworkPolicyAsync(request);
    }

    public final OperationFuture<Empty, OperationMetadata> deleteNetworkPolicyAsync(String name) {
        DeleteNetworkPolicyRequest request = DeleteNetworkPolicyRequest.newBuilder().setName(name).build();
        return this.deleteNetworkPolicyAsync(request);
    }

    public final OperationFuture<Empty, OperationMetadata> deleteNetworkPolicyAsync(DeleteNetworkPolicyRequest request) {
        return this.deleteNetworkPolicyOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<DeleteNetworkPolicyRequest, Empty, OperationMetadata> deleteNetworkPolicyOperationCallable() {
        return this.stub.deleteNetworkPolicyOperationCallable();
    }

    public final UnaryCallable<DeleteNetworkPolicyRequest, Operation> deleteNetworkPolicyCallable() {
        return this.stub.deleteNetworkPolicyCallable();
    }

    public final ListManagementDnsZoneBindingsPagedResponse listManagementDnsZoneBindings(PrivateCloudName parent) {
        ListManagementDnsZoneBindingsRequest request = ListManagementDnsZoneBindingsRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listManagementDnsZoneBindings(request);
    }

    public final ListManagementDnsZoneBindingsPagedResponse listManagementDnsZoneBindings(String parent) {
        ListManagementDnsZoneBindingsRequest request = ListManagementDnsZoneBindingsRequest.newBuilder().setParent(parent).build();
        return this.listManagementDnsZoneBindings(request);
    }

    public final ListManagementDnsZoneBindingsPagedResponse listManagementDnsZoneBindings(ListManagementDnsZoneBindingsRequest request) {
        return (ListManagementDnsZoneBindingsPagedResponse)((Object)this.listManagementDnsZoneBindingsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListManagementDnsZoneBindingsRequest, ListManagementDnsZoneBindingsPagedResponse> listManagementDnsZoneBindingsPagedCallable() {
        return this.stub.listManagementDnsZoneBindingsPagedCallable();
    }

    public final UnaryCallable<ListManagementDnsZoneBindingsRequest, ListManagementDnsZoneBindingsResponse> listManagementDnsZoneBindingsCallable() {
        return this.stub.listManagementDnsZoneBindingsCallable();
    }

    public final ManagementDnsZoneBinding getManagementDnsZoneBinding(ManagementDnsZoneBindingName name) {
        GetManagementDnsZoneBindingRequest request = GetManagementDnsZoneBindingRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getManagementDnsZoneBinding(request);
    }

    public final ManagementDnsZoneBinding getManagementDnsZoneBinding(String name) {
        GetManagementDnsZoneBindingRequest request = GetManagementDnsZoneBindingRequest.newBuilder().setName(name).build();
        return this.getManagementDnsZoneBinding(request);
    }

    public final ManagementDnsZoneBinding getManagementDnsZoneBinding(GetManagementDnsZoneBindingRequest request) {
        return (ManagementDnsZoneBinding)this.getManagementDnsZoneBindingCallable().call((Object)request);
    }

    public final UnaryCallable<GetManagementDnsZoneBindingRequest, ManagementDnsZoneBinding> getManagementDnsZoneBindingCallable() {
        return this.stub.getManagementDnsZoneBindingCallable();
    }

    public final OperationFuture<ManagementDnsZoneBinding, OperationMetadata> createManagementDnsZoneBindingAsync(PrivateCloudName parent, ManagementDnsZoneBinding managementDnsZoneBinding, String managementDnsZoneBindingId) {
        CreateManagementDnsZoneBindingRequest request = CreateManagementDnsZoneBindingRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setManagementDnsZoneBinding(managementDnsZoneBinding).setManagementDnsZoneBindingId(managementDnsZoneBindingId).build();
        return this.createManagementDnsZoneBindingAsync(request);
    }

    public final OperationFuture<ManagementDnsZoneBinding, OperationMetadata> createManagementDnsZoneBindingAsync(String parent, ManagementDnsZoneBinding managementDnsZoneBinding, String managementDnsZoneBindingId) {
        CreateManagementDnsZoneBindingRequest request = CreateManagementDnsZoneBindingRequest.newBuilder().setParent(parent).setManagementDnsZoneBinding(managementDnsZoneBinding).setManagementDnsZoneBindingId(managementDnsZoneBindingId).build();
        return this.createManagementDnsZoneBindingAsync(request);
    }

    public final OperationFuture<ManagementDnsZoneBinding, OperationMetadata> createManagementDnsZoneBindingAsync(CreateManagementDnsZoneBindingRequest request) {
        return this.createManagementDnsZoneBindingOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<CreateManagementDnsZoneBindingRequest, ManagementDnsZoneBinding, OperationMetadata> createManagementDnsZoneBindingOperationCallable() {
        return this.stub.createManagementDnsZoneBindingOperationCallable();
    }

    public final UnaryCallable<CreateManagementDnsZoneBindingRequest, Operation> createManagementDnsZoneBindingCallable() {
        return this.stub.createManagementDnsZoneBindingCallable();
    }

    public final OperationFuture<ManagementDnsZoneBinding, OperationMetadata> updateManagementDnsZoneBindingAsync(ManagementDnsZoneBinding managementDnsZoneBinding, FieldMask updateMask) {
        UpdateManagementDnsZoneBindingRequest request = UpdateManagementDnsZoneBindingRequest.newBuilder().setManagementDnsZoneBinding(managementDnsZoneBinding).setUpdateMask(updateMask).build();
        return this.updateManagementDnsZoneBindingAsync(request);
    }

    public final OperationFuture<ManagementDnsZoneBinding, OperationMetadata> updateManagementDnsZoneBindingAsync(UpdateManagementDnsZoneBindingRequest request) {
        return this.updateManagementDnsZoneBindingOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<UpdateManagementDnsZoneBindingRequest, ManagementDnsZoneBinding, OperationMetadata> updateManagementDnsZoneBindingOperationCallable() {
        return this.stub.updateManagementDnsZoneBindingOperationCallable();
    }

    public final UnaryCallable<UpdateManagementDnsZoneBindingRequest, Operation> updateManagementDnsZoneBindingCallable() {
        return this.stub.updateManagementDnsZoneBindingCallable();
    }

    public final OperationFuture<Empty, OperationMetadata> deleteManagementDnsZoneBindingAsync(ManagementDnsZoneBindingName name) {
        DeleteManagementDnsZoneBindingRequest request = DeleteManagementDnsZoneBindingRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.deleteManagementDnsZoneBindingAsync(request);
    }

    public final OperationFuture<Empty, OperationMetadata> deleteManagementDnsZoneBindingAsync(String name) {
        DeleteManagementDnsZoneBindingRequest request = DeleteManagementDnsZoneBindingRequest.newBuilder().setName(name).build();
        return this.deleteManagementDnsZoneBindingAsync(request);
    }

    public final OperationFuture<Empty, OperationMetadata> deleteManagementDnsZoneBindingAsync(DeleteManagementDnsZoneBindingRequest request) {
        return this.deleteManagementDnsZoneBindingOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<DeleteManagementDnsZoneBindingRequest, Empty, OperationMetadata> deleteManagementDnsZoneBindingOperationCallable() {
        return this.stub.deleteManagementDnsZoneBindingOperationCallable();
    }

    public final UnaryCallable<DeleteManagementDnsZoneBindingRequest, Operation> deleteManagementDnsZoneBindingCallable() {
        return this.stub.deleteManagementDnsZoneBindingCallable();
    }

    public final OperationFuture<ManagementDnsZoneBinding, OperationMetadata> repairManagementDnsZoneBindingAsync(ManagementDnsZoneBindingName name) {
        RepairManagementDnsZoneBindingRequest request = RepairManagementDnsZoneBindingRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.repairManagementDnsZoneBindingAsync(request);
    }

    public final OperationFuture<ManagementDnsZoneBinding, OperationMetadata> repairManagementDnsZoneBindingAsync(String name) {
        RepairManagementDnsZoneBindingRequest request = RepairManagementDnsZoneBindingRequest.newBuilder().setName(name).build();
        return this.repairManagementDnsZoneBindingAsync(request);
    }

    public final OperationFuture<ManagementDnsZoneBinding, OperationMetadata> repairManagementDnsZoneBindingAsync(RepairManagementDnsZoneBindingRequest request) {
        return this.repairManagementDnsZoneBindingOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<RepairManagementDnsZoneBindingRequest, ManagementDnsZoneBinding, OperationMetadata> repairManagementDnsZoneBindingOperationCallable() {
        return this.stub.repairManagementDnsZoneBindingOperationCallable();
    }

    public final UnaryCallable<RepairManagementDnsZoneBindingRequest, Operation> repairManagementDnsZoneBindingCallable() {
        return this.stub.repairManagementDnsZoneBindingCallable();
    }

    public final OperationFuture<VmwareEngineNetwork, OperationMetadata> createVmwareEngineNetworkAsync(LocationName parent, VmwareEngineNetwork vmwareEngineNetwork, String vmwareEngineNetworkId) {
        CreateVmwareEngineNetworkRequest request = CreateVmwareEngineNetworkRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setVmwareEngineNetwork(vmwareEngineNetwork).setVmwareEngineNetworkId(vmwareEngineNetworkId).build();
        return this.createVmwareEngineNetworkAsync(request);
    }

    public final OperationFuture<VmwareEngineNetwork, OperationMetadata> createVmwareEngineNetworkAsync(String parent, VmwareEngineNetwork vmwareEngineNetwork, String vmwareEngineNetworkId) {
        CreateVmwareEngineNetworkRequest request = CreateVmwareEngineNetworkRequest.newBuilder().setParent(parent).setVmwareEngineNetwork(vmwareEngineNetwork).setVmwareEngineNetworkId(vmwareEngineNetworkId).build();
        return this.createVmwareEngineNetworkAsync(request);
    }

    public final OperationFuture<VmwareEngineNetwork, OperationMetadata> createVmwareEngineNetworkAsync(CreateVmwareEngineNetworkRequest request) {
        return this.createVmwareEngineNetworkOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<CreateVmwareEngineNetworkRequest, VmwareEngineNetwork, OperationMetadata> createVmwareEngineNetworkOperationCallable() {
        return this.stub.createVmwareEngineNetworkOperationCallable();
    }

    public final UnaryCallable<CreateVmwareEngineNetworkRequest, Operation> createVmwareEngineNetworkCallable() {
        return this.stub.createVmwareEngineNetworkCallable();
    }

    public final OperationFuture<VmwareEngineNetwork, OperationMetadata> updateVmwareEngineNetworkAsync(VmwareEngineNetwork vmwareEngineNetwork, FieldMask updateMask) {
        UpdateVmwareEngineNetworkRequest request = UpdateVmwareEngineNetworkRequest.newBuilder().setVmwareEngineNetwork(vmwareEngineNetwork).setUpdateMask(updateMask).build();
        return this.updateVmwareEngineNetworkAsync(request);
    }

    public final OperationFuture<VmwareEngineNetwork, OperationMetadata> updateVmwareEngineNetworkAsync(UpdateVmwareEngineNetworkRequest request) {
        return this.updateVmwareEngineNetworkOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<UpdateVmwareEngineNetworkRequest, VmwareEngineNetwork, OperationMetadata> updateVmwareEngineNetworkOperationCallable() {
        return this.stub.updateVmwareEngineNetworkOperationCallable();
    }

    public final UnaryCallable<UpdateVmwareEngineNetworkRequest, Operation> updateVmwareEngineNetworkCallable() {
        return this.stub.updateVmwareEngineNetworkCallable();
    }

    public final OperationFuture<Empty, OperationMetadata> deleteVmwareEngineNetworkAsync(VmwareEngineNetworkName name) {
        DeleteVmwareEngineNetworkRequest request = DeleteVmwareEngineNetworkRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.deleteVmwareEngineNetworkAsync(request);
    }

    public final OperationFuture<Empty, OperationMetadata> deleteVmwareEngineNetworkAsync(String name) {
        DeleteVmwareEngineNetworkRequest request = DeleteVmwareEngineNetworkRequest.newBuilder().setName(name).build();
        return this.deleteVmwareEngineNetworkAsync(request);
    }

    public final OperationFuture<Empty, OperationMetadata> deleteVmwareEngineNetworkAsync(DeleteVmwareEngineNetworkRequest request) {
        return this.deleteVmwareEngineNetworkOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<DeleteVmwareEngineNetworkRequest, Empty, OperationMetadata> deleteVmwareEngineNetworkOperationCallable() {
        return this.stub.deleteVmwareEngineNetworkOperationCallable();
    }

    public final UnaryCallable<DeleteVmwareEngineNetworkRequest, Operation> deleteVmwareEngineNetworkCallable() {
        return this.stub.deleteVmwareEngineNetworkCallable();
    }

    public final VmwareEngineNetwork getVmwareEngineNetwork(VmwareEngineNetworkName name) {
        GetVmwareEngineNetworkRequest request = GetVmwareEngineNetworkRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getVmwareEngineNetwork(request);
    }

    public final VmwareEngineNetwork getVmwareEngineNetwork(String name) {
        GetVmwareEngineNetworkRequest request = GetVmwareEngineNetworkRequest.newBuilder().setName(name).build();
        return this.getVmwareEngineNetwork(request);
    }

    public final VmwareEngineNetwork getVmwareEngineNetwork(GetVmwareEngineNetworkRequest request) {
        return (VmwareEngineNetwork)this.getVmwareEngineNetworkCallable().call((Object)request);
    }

    public final UnaryCallable<GetVmwareEngineNetworkRequest, VmwareEngineNetwork> getVmwareEngineNetworkCallable() {
        return this.stub.getVmwareEngineNetworkCallable();
    }

    public final ListVmwareEngineNetworksPagedResponse listVmwareEngineNetworks(LocationName parent) {
        ListVmwareEngineNetworksRequest request = ListVmwareEngineNetworksRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listVmwareEngineNetworks(request);
    }

    public final ListVmwareEngineNetworksPagedResponse listVmwareEngineNetworks(String parent) {
        ListVmwareEngineNetworksRequest request = ListVmwareEngineNetworksRequest.newBuilder().setParent(parent).build();
        return this.listVmwareEngineNetworks(request);
    }

    public final ListVmwareEngineNetworksPagedResponse listVmwareEngineNetworks(ListVmwareEngineNetworksRequest request) {
        return (ListVmwareEngineNetworksPagedResponse)((Object)this.listVmwareEngineNetworksPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListVmwareEngineNetworksRequest, ListVmwareEngineNetworksPagedResponse> listVmwareEngineNetworksPagedCallable() {
        return this.stub.listVmwareEngineNetworksPagedCallable();
    }

    public final UnaryCallable<ListVmwareEngineNetworksRequest, ListVmwareEngineNetworksResponse> listVmwareEngineNetworksCallable() {
        return this.stub.listVmwareEngineNetworksCallable();
    }

    public final OperationFuture<PrivateConnection, OperationMetadata> createPrivateConnectionAsync(LocationName parent, PrivateConnection privateConnection, String privateConnectionId) {
        CreatePrivateConnectionRequest request = CreatePrivateConnectionRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setPrivateConnection(privateConnection).setPrivateConnectionId(privateConnectionId).build();
        return this.createPrivateConnectionAsync(request);
    }

    public final OperationFuture<PrivateConnection, OperationMetadata> createPrivateConnectionAsync(String parent, PrivateConnection privateConnection, String privateConnectionId) {
        CreatePrivateConnectionRequest request = CreatePrivateConnectionRequest.newBuilder().setParent(parent).setPrivateConnection(privateConnection).setPrivateConnectionId(privateConnectionId).build();
        return this.createPrivateConnectionAsync(request);
    }

    public final OperationFuture<PrivateConnection, OperationMetadata> createPrivateConnectionAsync(CreatePrivateConnectionRequest request) {
        return this.createPrivateConnectionOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<CreatePrivateConnectionRequest, PrivateConnection, OperationMetadata> createPrivateConnectionOperationCallable() {
        return this.stub.createPrivateConnectionOperationCallable();
    }

    public final UnaryCallable<CreatePrivateConnectionRequest, Operation> createPrivateConnectionCallable() {
        return this.stub.createPrivateConnectionCallable();
    }

    public final PrivateConnection getPrivateConnection(PrivateConnectionName name) {
        GetPrivateConnectionRequest request = GetPrivateConnectionRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getPrivateConnection(request);
    }

    public final PrivateConnection getPrivateConnection(String name) {
        GetPrivateConnectionRequest request = GetPrivateConnectionRequest.newBuilder().setName(name).build();
        return this.getPrivateConnection(request);
    }

    public final PrivateConnection getPrivateConnection(GetPrivateConnectionRequest request) {
        return (PrivateConnection)this.getPrivateConnectionCallable().call((Object)request);
    }

    public final UnaryCallable<GetPrivateConnectionRequest, PrivateConnection> getPrivateConnectionCallable() {
        return this.stub.getPrivateConnectionCallable();
    }

    public final ListPrivateConnectionsPagedResponse listPrivateConnections(LocationName parent) {
        ListPrivateConnectionsRequest request = ListPrivateConnectionsRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listPrivateConnections(request);
    }

    public final ListPrivateConnectionsPagedResponse listPrivateConnections(String parent) {
        ListPrivateConnectionsRequest request = ListPrivateConnectionsRequest.newBuilder().setParent(parent).build();
        return this.listPrivateConnections(request);
    }

    public final ListPrivateConnectionsPagedResponse listPrivateConnections(ListPrivateConnectionsRequest request) {
        return (ListPrivateConnectionsPagedResponse)((Object)this.listPrivateConnectionsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListPrivateConnectionsRequest, ListPrivateConnectionsPagedResponse> listPrivateConnectionsPagedCallable() {
        return this.stub.listPrivateConnectionsPagedCallable();
    }

    public final UnaryCallable<ListPrivateConnectionsRequest, ListPrivateConnectionsResponse> listPrivateConnectionsCallable() {
        return this.stub.listPrivateConnectionsCallable();
    }

    public final OperationFuture<PrivateConnection, OperationMetadata> updatePrivateConnectionAsync(PrivateConnection privateConnection, FieldMask updateMask) {
        UpdatePrivateConnectionRequest request = UpdatePrivateConnectionRequest.newBuilder().setPrivateConnection(privateConnection).setUpdateMask(updateMask).build();
        return this.updatePrivateConnectionAsync(request);
    }

    public final OperationFuture<PrivateConnection, OperationMetadata> updatePrivateConnectionAsync(UpdatePrivateConnectionRequest request) {
        return this.updatePrivateConnectionOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<UpdatePrivateConnectionRequest, PrivateConnection, OperationMetadata> updatePrivateConnectionOperationCallable() {
        return this.stub.updatePrivateConnectionOperationCallable();
    }

    public final UnaryCallable<UpdatePrivateConnectionRequest, Operation> updatePrivateConnectionCallable() {
        return this.stub.updatePrivateConnectionCallable();
    }

    public final OperationFuture<Empty, OperationMetadata> deletePrivateConnectionAsync(PrivateConnectionName name) {
        DeletePrivateConnectionRequest request = DeletePrivateConnectionRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.deletePrivateConnectionAsync(request);
    }

    public final OperationFuture<Empty, OperationMetadata> deletePrivateConnectionAsync(String name) {
        DeletePrivateConnectionRequest request = DeletePrivateConnectionRequest.newBuilder().setName(name).build();
        return this.deletePrivateConnectionAsync(request);
    }

    public final OperationFuture<Empty, OperationMetadata> deletePrivateConnectionAsync(DeletePrivateConnectionRequest request) {
        return this.deletePrivateConnectionOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<DeletePrivateConnectionRequest, Empty, OperationMetadata> deletePrivateConnectionOperationCallable() {
        return this.stub.deletePrivateConnectionOperationCallable();
    }

    public final UnaryCallable<DeletePrivateConnectionRequest, Operation> deletePrivateConnectionCallable() {
        return this.stub.deletePrivateConnectionCallable();
    }

    public final ListPrivateConnectionPeeringRoutesPagedResponse listPrivateConnectionPeeringRoutes(PrivateConnectionName parent) {
        ListPrivateConnectionPeeringRoutesRequest request = ListPrivateConnectionPeeringRoutesRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listPrivateConnectionPeeringRoutes(request);
    }

    public final ListPrivateConnectionPeeringRoutesPagedResponse listPrivateConnectionPeeringRoutes(String parent) {
        ListPrivateConnectionPeeringRoutesRequest request = ListPrivateConnectionPeeringRoutesRequest.newBuilder().setParent(parent).build();
        return this.listPrivateConnectionPeeringRoutes(request);
    }

    public final ListPrivateConnectionPeeringRoutesPagedResponse listPrivateConnectionPeeringRoutes(ListPrivateConnectionPeeringRoutesRequest request) {
        return (ListPrivateConnectionPeeringRoutesPagedResponse)((Object)this.listPrivateConnectionPeeringRoutesPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListPrivateConnectionPeeringRoutesRequest, ListPrivateConnectionPeeringRoutesPagedResponse> listPrivateConnectionPeeringRoutesPagedCallable() {
        return this.stub.listPrivateConnectionPeeringRoutesPagedCallable();
    }

    public final UnaryCallable<ListPrivateConnectionPeeringRoutesRequest, ListPrivateConnectionPeeringRoutesResponse> listPrivateConnectionPeeringRoutesCallable() {
        return this.stub.listPrivateConnectionPeeringRoutesCallable();
    }

    public final OperationFuture<DnsBindPermission, OperationMetadata> grantDnsBindPermissionAsync(DnsBindPermissionName name, Principal principal) {
        GrantDnsBindPermissionRequest request = GrantDnsBindPermissionRequest.newBuilder().setName(name == null ? null : name.toString()).setPrincipal(principal).build();
        return this.grantDnsBindPermissionAsync(request);
    }

    public final OperationFuture<DnsBindPermission, OperationMetadata> grantDnsBindPermissionAsync(String name, Principal principal) {
        GrantDnsBindPermissionRequest request = GrantDnsBindPermissionRequest.newBuilder().setName(name).setPrincipal(principal).build();
        return this.grantDnsBindPermissionAsync(request);
    }

    public final OperationFuture<DnsBindPermission, OperationMetadata> grantDnsBindPermissionAsync(GrantDnsBindPermissionRequest request) {
        return this.grantDnsBindPermissionOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<GrantDnsBindPermissionRequest, DnsBindPermission, OperationMetadata> grantDnsBindPermissionOperationCallable() {
        return this.stub.grantDnsBindPermissionOperationCallable();
    }

    public final UnaryCallable<GrantDnsBindPermissionRequest, Operation> grantDnsBindPermissionCallable() {
        return this.stub.grantDnsBindPermissionCallable();
    }

    public final DnsBindPermission getDnsBindPermission(DnsBindPermissionName name) {
        GetDnsBindPermissionRequest request = GetDnsBindPermissionRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getDnsBindPermission(request);
    }

    public final DnsBindPermission getDnsBindPermission(String name) {
        GetDnsBindPermissionRequest request = GetDnsBindPermissionRequest.newBuilder().setName(name).build();
        return this.getDnsBindPermission(request);
    }

    public final DnsBindPermission getDnsBindPermission(GetDnsBindPermissionRequest request) {
        return (DnsBindPermission)this.getDnsBindPermissionCallable().call((Object)request);
    }

    public final UnaryCallable<GetDnsBindPermissionRequest, DnsBindPermission> getDnsBindPermissionCallable() {
        return this.stub.getDnsBindPermissionCallable();
    }

    public final OperationFuture<DnsBindPermission, OperationMetadata> revokeDnsBindPermissionAsync(DnsBindPermissionName name, Principal principal) {
        RevokeDnsBindPermissionRequest request = RevokeDnsBindPermissionRequest.newBuilder().setName(name == null ? null : name.toString()).setPrincipal(principal).build();
        return this.revokeDnsBindPermissionAsync(request);
    }

    public final OperationFuture<DnsBindPermission, OperationMetadata> revokeDnsBindPermissionAsync(String name, Principal principal) {
        RevokeDnsBindPermissionRequest request = RevokeDnsBindPermissionRequest.newBuilder().setName(name).setPrincipal(principal).build();
        return this.revokeDnsBindPermissionAsync(request);
    }

    public final OperationFuture<DnsBindPermission, OperationMetadata> revokeDnsBindPermissionAsync(RevokeDnsBindPermissionRequest request) {
        return this.revokeDnsBindPermissionOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<RevokeDnsBindPermissionRequest, DnsBindPermission, OperationMetadata> revokeDnsBindPermissionOperationCallable() {
        return this.stub.revokeDnsBindPermissionOperationCallable();
    }

    public final UnaryCallable<RevokeDnsBindPermissionRequest, Operation> revokeDnsBindPermissionCallable() {
        return this.stub.revokeDnsBindPermissionCallable();
    }

    public final ListLocationsPagedResponse listLocations(ListLocationsRequest request) {
        return (ListLocationsPagedResponse)((Object)this.listLocationsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListLocationsRequest, ListLocationsPagedResponse> listLocationsPagedCallable() {
        return this.stub.listLocationsPagedCallable();
    }

    public final UnaryCallable<ListLocationsRequest, ListLocationsResponse> listLocationsCallable() {
        return this.stub.listLocationsCallable();
    }

    public final Location getLocation(GetLocationRequest request) {
        return (Location)this.getLocationCallable().call((Object)request);
    }

    public final UnaryCallable<GetLocationRequest, Location> getLocationCallable() {
        return this.stub.getLocationCallable();
    }

    public final Policy setIamPolicy(SetIamPolicyRequest request) {
        return (Policy)this.setIamPolicyCallable().call((Object)request);
    }

    public final UnaryCallable<SetIamPolicyRequest, Policy> setIamPolicyCallable() {
        return this.stub.setIamPolicyCallable();
    }

    public final Policy getIamPolicy(GetIamPolicyRequest request) {
        return (Policy)this.getIamPolicyCallable().call((Object)request);
    }

    public final UnaryCallable<GetIamPolicyRequest, Policy> getIamPolicyCallable() {
        return this.stub.getIamPolicyCallable();
    }

    public final TestIamPermissionsResponse testIamPermissions(TestIamPermissionsRequest request) {
        return (TestIamPermissionsResponse)this.testIamPermissionsCallable().call((Object)request);
    }

    public final UnaryCallable<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsCallable() {
        return this.stub.testIamPermissionsCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class ListLocationsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListLocationsRequest, ListLocationsResponse, Location, ListLocationsPage, ListLocationsFixedSizeCollection> {
        private ListLocationsFixedSizeCollection(List<ListLocationsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListLocationsFixedSizeCollection createEmptyCollection() {
            return new ListLocationsFixedSizeCollection(null, 0);
        }

        protected ListLocationsFixedSizeCollection createCollection(List<ListLocationsPage> pages, int collectionSize) {
            return new ListLocationsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListLocationsPage
    extends AbstractPage<ListLocationsRequest, ListLocationsResponse, Location, ListLocationsPage> {
        private ListLocationsPage(PageContext<ListLocationsRequest, ListLocationsResponse, Location> context, ListLocationsResponse response) {
            super(context, (Object)response);
        }

        private static ListLocationsPage createEmptyPage() {
            return new ListLocationsPage(null, null);
        }

        protected ListLocationsPage createPage(PageContext<ListLocationsRequest, ListLocationsResponse, Location> context, ListLocationsResponse response) {
            return new ListLocationsPage(context, response);
        }

        public ApiFuture<ListLocationsPage> createPageAsync(PageContext<ListLocationsRequest, ListLocationsResponse, Location> context, ApiFuture<ListLocationsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListLocationsPagedResponse
    extends AbstractPagedListResponse<ListLocationsRequest, ListLocationsResponse, Location, ListLocationsPage, ListLocationsFixedSizeCollection> {
        public static ApiFuture<ListLocationsPagedResponse> createAsync(PageContext<ListLocationsRequest, ListLocationsResponse, Location> context, ApiFuture<ListLocationsResponse> futureResponse) {
            ApiFuture<ListLocationsPage> futurePage = ListLocationsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListLocationsPagedResponse((ListLocationsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListLocationsPagedResponse(ListLocationsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListLocationsFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListPrivateConnectionPeeringRoutesFixedSizeCollection
    extends AbstractFixedSizeCollection<ListPrivateConnectionPeeringRoutesRequest, ListPrivateConnectionPeeringRoutesResponse, PeeringRoute, ListPrivateConnectionPeeringRoutesPage, ListPrivateConnectionPeeringRoutesFixedSizeCollection> {
        private ListPrivateConnectionPeeringRoutesFixedSizeCollection(List<ListPrivateConnectionPeeringRoutesPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListPrivateConnectionPeeringRoutesFixedSizeCollection createEmptyCollection() {
            return new ListPrivateConnectionPeeringRoutesFixedSizeCollection(null, 0);
        }

        protected ListPrivateConnectionPeeringRoutesFixedSizeCollection createCollection(List<ListPrivateConnectionPeeringRoutesPage> pages, int collectionSize) {
            return new ListPrivateConnectionPeeringRoutesFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListPrivateConnectionPeeringRoutesPage
    extends AbstractPage<ListPrivateConnectionPeeringRoutesRequest, ListPrivateConnectionPeeringRoutesResponse, PeeringRoute, ListPrivateConnectionPeeringRoutesPage> {
        private ListPrivateConnectionPeeringRoutesPage(PageContext<ListPrivateConnectionPeeringRoutesRequest, ListPrivateConnectionPeeringRoutesResponse, PeeringRoute> context, ListPrivateConnectionPeeringRoutesResponse response) {
            super(context, (Object)response);
        }

        private static ListPrivateConnectionPeeringRoutesPage createEmptyPage() {
            return new ListPrivateConnectionPeeringRoutesPage(null, null);
        }

        protected ListPrivateConnectionPeeringRoutesPage createPage(PageContext<ListPrivateConnectionPeeringRoutesRequest, ListPrivateConnectionPeeringRoutesResponse, PeeringRoute> context, ListPrivateConnectionPeeringRoutesResponse response) {
            return new ListPrivateConnectionPeeringRoutesPage(context, response);
        }

        public ApiFuture<ListPrivateConnectionPeeringRoutesPage> createPageAsync(PageContext<ListPrivateConnectionPeeringRoutesRequest, ListPrivateConnectionPeeringRoutesResponse, PeeringRoute> context, ApiFuture<ListPrivateConnectionPeeringRoutesResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListPrivateConnectionPeeringRoutesPagedResponse
    extends AbstractPagedListResponse<ListPrivateConnectionPeeringRoutesRequest, ListPrivateConnectionPeeringRoutesResponse, PeeringRoute, ListPrivateConnectionPeeringRoutesPage, ListPrivateConnectionPeeringRoutesFixedSizeCollection> {
        public static ApiFuture<ListPrivateConnectionPeeringRoutesPagedResponse> createAsync(PageContext<ListPrivateConnectionPeeringRoutesRequest, ListPrivateConnectionPeeringRoutesResponse, PeeringRoute> context, ApiFuture<ListPrivateConnectionPeeringRoutesResponse> futureResponse) {
            ApiFuture<ListPrivateConnectionPeeringRoutesPage> futurePage = ListPrivateConnectionPeeringRoutesPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListPrivateConnectionPeeringRoutesPagedResponse((ListPrivateConnectionPeeringRoutesPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListPrivateConnectionPeeringRoutesPagedResponse(ListPrivateConnectionPeeringRoutesPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListPrivateConnectionPeeringRoutesFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListPrivateConnectionsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListPrivateConnectionsRequest, ListPrivateConnectionsResponse, PrivateConnection, ListPrivateConnectionsPage, ListPrivateConnectionsFixedSizeCollection> {
        private ListPrivateConnectionsFixedSizeCollection(List<ListPrivateConnectionsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListPrivateConnectionsFixedSizeCollection createEmptyCollection() {
            return new ListPrivateConnectionsFixedSizeCollection(null, 0);
        }

        protected ListPrivateConnectionsFixedSizeCollection createCollection(List<ListPrivateConnectionsPage> pages, int collectionSize) {
            return new ListPrivateConnectionsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListPrivateConnectionsPage
    extends AbstractPage<ListPrivateConnectionsRequest, ListPrivateConnectionsResponse, PrivateConnection, ListPrivateConnectionsPage> {
        private ListPrivateConnectionsPage(PageContext<ListPrivateConnectionsRequest, ListPrivateConnectionsResponse, PrivateConnection> context, ListPrivateConnectionsResponse response) {
            super(context, (Object)response);
        }

        private static ListPrivateConnectionsPage createEmptyPage() {
            return new ListPrivateConnectionsPage(null, null);
        }

        protected ListPrivateConnectionsPage createPage(PageContext<ListPrivateConnectionsRequest, ListPrivateConnectionsResponse, PrivateConnection> context, ListPrivateConnectionsResponse response) {
            return new ListPrivateConnectionsPage(context, response);
        }

        public ApiFuture<ListPrivateConnectionsPage> createPageAsync(PageContext<ListPrivateConnectionsRequest, ListPrivateConnectionsResponse, PrivateConnection> context, ApiFuture<ListPrivateConnectionsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListPrivateConnectionsPagedResponse
    extends AbstractPagedListResponse<ListPrivateConnectionsRequest, ListPrivateConnectionsResponse, PrivateConnection, ListPrivateConnectionsPage, ListPrivateConnectionsFixedSizeCollection> {
        public static ApiFuture<ListPrivateConnectionsPagedResponse> createAsync(PageContext<ListPrivateConnectionsRequest, ListPrivateConnectionsResponse, PrivateConnection> context, ApiFuture<ListPrivateConnectionsResponse> futureResponse) {
            ApiFuture<ListPrivateConnectionsPage> futurePage = ListPrivateConnectionsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListPrivateConnectionsPagedResponse((ListPrivateConnectionsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListPrivateConnectionsPagedResponse(ListPrivateConnectionsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListPrivateConnectionsFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListVmwareEngineNetworksFixedSizeCollection
    extends AbstractFixedSizeCollection<ListVmwareEngineNetworksRequest, ListVmwareEngineNetworksResponse, VmwareEngineNetwork, ListVmwareEngineNetworksPage, ListVmwareEngineNetworksFixedSizeCollection> {
        private ListVmwareEngineNetworksFixedSizeCollection(List<ListVmwareEngineNetworksPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListVmwareEngineNetworksFixedSizeCollection createEmptyCollection() {
            return new ListVmwareEngineNetworksFixedSizeCollection(null, 0);
        }

        protected ListVmwareEngineNetworksFixedSizeCollection createCollection(List<ListVmwareEngineNetworksPage> pages, int collectionSize) {
            return new ListVmwareEngineNetworksFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListVmwareEngineNetworksPage
    extends AbstractPage<ListVmwareEngineNetworksRequest, ListVmwareEngineNetworksResponse, VmwareEngineNetwork, ListVmwareEngineNetworksPage> {
        private ListVmwareEngineNetworksPage(PageContext<ListVmwareEngineNetworksRequest, ListVmwareEngineNetworksResponse, VmwareEngineNetwork> context, ListVmwareEngineNetworksResponse response) {
            super(context, (Object)response);
        }

        private static ListVmwareEngineNetworksPage createEmptyPage() {
            return new ListVmwareEngineNetworksPage(null, null);
        }

        protected ListVmwareEngineNetworksPage createPage(PageContext<ListVmwareEngineNetworksRequest, ListVmwareEngineNetworksResponse, VmwareEngineNetwork> context, ListVmwareEngineNetworksResponse response) {
            return new ListVmwareEngineNetworksPage(context, response);
        }

        public ApiFuture<ListVmwareEngineNetworksPage> createPageAsync(PageContext<ListVmwareEngineNetworksRequest, ListVmwareEngineNetworksResponse, VmwareEngineNetwork> context, ApiFuture<ListVmwareEngineNetworksResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListVmwareEngineNetworksPagedResponse
    extends AbstractPagedListResponse<ListVmwareEngineNetworksRequest, ListVmwareEngineNetworksResponse, VmwareEngineNetwork, ListVmwareEngineNetworksPage, ListVmwareEngineNetworksFixedSizeCollection> {
        public static ApiFuture<ListVmwareEngineNetworksPagedResponse> createAsync(PageContext<ListVmwareEngineNetworksRequest, ListVmwareEngineNetworksResponse, VmwareEngineNetwork> context, ApiFuture<ListVmwareEngineNetworksResponse> futureResponse) {
            ApiFuture<ListVmwareEngineNetworksPage> futurePage = ListVmwareEngineNetworksPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListVmwareEngineNetworksPagedResponse((ListVmwareEngineNetworksPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListVmwareEngineNetworksPagedResponse(ListVmwareEngineNetworksPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListVmwareEngineNetworksFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListManagementDnsZoneBindingsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListManagementDnsZoneBindingsRequest, ListManagementDnsZoneBindingsResponse, ManagementDnsZoneBinding, ListManagementDnsZoneBindingsPage, ListManagementDnsZoneBindingsFixedSizeCollection> {
        private ListManagementDnsZoneBindingsFixedSizeCollection(List<ListManagementDnsZoneBindingsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListManagementDnsZoneBindingsFixedSizeCollection createEmptyCollection() {
            return new ListManagementDnsZoneBindingsFixedSizeCollection(null, 0);
        }

        protected ListManagementDnsZoneBindingsFixedSizeCollection createCollection(List<ListManagementDnsZoneBindingsPage> pages, int collectionSize) {
            return new ListManagementDnsZoneBindingsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListManagementDnsZoneBindingsPage
    extends AbstractPage<ListManagementDnsZoneBindingsRequest, ListManagementDnsZoneBindingsResponse, ManagementDnsZoneBinding, ListManagementDnsZoneBindingsPage> {
        private ListManagementDnsZoneBindingsPage(PageContext<ListManagementDnsZoneBindingsRequest, ListManagementDnsZoneBindingsResponse, ManagementDnsZoneBinding> context, ListManagementDnsZoneBindingsResponse response) {
            super(context, (Object)response);
        }

        private static ListManagementDnsZoneBindingsPage createEmptyPage() {
            return new ListManagementDnsZoneBindingsPage(null, null);
        }

        protected ListManagementDnsZoneBindingsPage createPage(PageContext<ListManagementDnsZoneBindingsRequest, ListManagementDnsZoneBindingsResponse, ManagementDnsZoneBinding> context, ListManagementDnsZoneBindingsResponse response) {
            return new ListManagementDnsZoneBindingsPage(context, response);
        }

        public ApiFuture<ListManagementDnsZoneBindingsPage> createPageAsync(PageContext<ListManagementDnsZoneBindingsRequest, ListManagementDnsZoneBindingsResponse, ManagementDnsZoneBinding> context, ApiFuture<ListManagementDnsZoneBindingsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListManagementDnsZoneBindingsPagedResponse
    extends AbstractPagedListResponse<ListManagementDnsZoneBindingsRequest, ListManagementDnsZoneBindingsResponse, ManagementDnsZoneBinding, ListManagementDnsZoneBindingsPage, ListManagementDnsZoneBindingsFixedSizeCollection> {
        public static ApiFuture<ListManagementDnsZoneBindingsPagedResponse> createAsync(PageContext<ListManagementDnsZoneBindingsRequest, ListManagementDnsZoneBindingsResponse, ManagementDnsZoneBinding> context, ApiFuture<ListManagementDnsZoneBindingsResponse> futureResponse) {
            ApiFuture<ListManagementDnsZoneBindingsPage> futurePage = ListManagementDnsZoneBindingsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListManagementDnsZoneBindingsPagedResponse((ListManagementDnsZoneBindingsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListManagementDnsZoneBindingsPagedResponse(ListManagementDnsZoneBindingsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListManagementDnsZoneBindingsFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListNetworkPoliciesFixedSizeCollection
    extends AbstractFixedSizeCollection<ListNetworkPoliciesRequest, ListNetworkPoliciesResponse, NetworkPolicy, ListNetworkPoliciesPage, ListNetworkPoliciesFixedSizeCollection> {
        private ListNetworkPoliciesFixedSizeCollection(List<ListNetworkPoliciesPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListNetworkPoliciesFixedSizeCollection createEmptyCollection() {
            return new ListNetworkPoliciesFixedSizeCollection(null, 0);
        }

        protected ListNetworkPoliciesFixedSizeCollection createCollection(List<ListNetworkPoliciesPage> pages, int collectionSize) {
            return new ListNetworkPoliciesFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListNetworkPoliciesPage
    extends AbstractPage<ListNetworkPoliciesRequest, ListNetworkPoliciesResponse, NetworkPolicy, ListNetworkPoliciesPage> {
        private ListNetworkPoliciesPage(PageContext<ListNetworkPoliciesRequest, ListNetworkPoliciesResponse, NetworkPolicy> context, ListNetworkPoliciesResponse response) {
            super(context, (Object)response);
        }

        private static ListNetworkPoliciesPage createEmptyPage() {
            return new ListNetworkPoliciesPage(null, null);
        }

        protected ListNetworkPoliciesPage createPage(PageContext<ListNetworkPoliciesRequest, ListNetworkPoliciesResponse, NetworkPolicy> context, ListNetworkPoliciesResponse response) {
            return new ListNetworkPoliciesPage(context, response);
        }

        public ApiFuture<ListNetworkPoliciesPage> createPageAsync(PageContext<ListNetworkPoliciesRequest, ListNetworkPoliciesResponse, NetworkPolicy> context, ApiFuture<ListNetworkPoliciesResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListNetworkPoliciesPagedResponse
    extends AbstractPagedListResponse<ListNetworkPoliciesRequest, ListNetworkPoliciesResponse, NetworkPolicy, ListNetworkPoliciesPage, ListNetworkPoliciesFixedSizeCollection> {
        public static ApiFuture<ListNetworkPoliciesPagedResponse> createAsync(PageContext<ListNetworkPoliciesRequest, ListNetworkPoliciesResponse, NetworkPolicy> context, ApiFuture<ListNetworkPoliciesResponse> futureResponse) {
            ApiFuture<ListNetworkPoliciesPage> futurePage = ListNetworkPoliciesPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListNetworkPoliciesPagedResponse((ListNetworkPoliciesPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListNetworkPoliciesPagedResponse(ListNetworkPoliciesPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListNetworkPoliciesFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListHcxActivationKeysFixedSizeCollection
    extends AbstractFixedSizeCollection<ListHcxActivationKeysRequest, ListHcxActivationKeysResponse, HcxActivationKey, ListHcxActivationKeysPage, ListHcxActivationKeysFixedSizeCollection> {
        private ListHcxActivationKeysFixedSizeCollection(List<ListHcxActivationKeysPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListHcxActivationKeysFixedSizeCollection createEmptyCollection() {
            return new ListHcxActivationKeysFixedSizeCollection(null, 0);
        }

        protected ListHcxActivationKeysFixedSizeCollection createCollection(List<ListHcxActivationKeysPage> pages, int collectionSize) {
            return new ListHcxActivationKeysFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListHcxActivationKeysPage
    extends AbstractPage<ListHcxActivationKeysRequest, ListHcxActivationKeysResponse, HcxActivationKey, ListHcxActivationKeysPage> {
        private ListHcxActivationKeysPage(PageContext<ListHcxActivationKeysRequest, ListHcxActivationKeysResponse, HcxActivationKey> context, ListHcxActivationKeysResponse response) {
            super(context, (Object)response);
        }

        private static ListHcxActivationKeysPage createEmptyPage() {
            return new ListHcxActivationKeysPage(null, null);
        }

        protected ListHcxActivationKeysPage createPage(PageContext<ListHcxActivationKeysRequest, ListHcxActivationKeysResponse, HcxActivationKey> context, ListHcxActivationKeysResponse response) {
            return new ListHcxActivationKeysPage(context, response);
        }

        public ApiFuture<ListHcxActivationKeysPage> createPageAsync(PageContext<ListHcxActivationKeysRequest, ListHcxActivationKeysResponse, HcxActivationKey> context, ApiFuture<ListHcxActivationKeysResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListHcxActivationKeysPagedResponse
    extends AbstractPagedListResponse<ListHcxActivationKeysRequest, ListHcxActivationKeysResponse, HcxActivationKey, ListHcxActivationKeysPage, ListHcxActivationKeysFixedSizeCollection> {
        public static ApiFuture<ListHcxActivationKeysPagedResponse> createAsync(PageContext<ListHcxActivationKeysRequest, ListHcxActivationKeysResponse, HcxActivationKey> context, ApiFuture<ListHcxActivationKeysResponse> futureResponse) {
            ApiFuture<ListHcxActivationKeysPage> futurePage = ListHcxActivationKeysPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListHcxActivationKeysPagedResponse((ListHcxActivationKeysPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListHcxActivationKeysPagedResponse(ListHcxActivationKeysPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListHcxActivationKeysFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListPeeringRoutesFixedSizeCollection
    extends AbstractFixedSizeCollection<ListPeeringRoutesRequest, ListPeeringRoutesResponse, PeeringRoute, ListPeeringRoutesPage, ListPeeringRoutesFixedSizeCollection> {
        private ListPeeringRoutesFixedSizeCollection(List<ListPeeringRoutesPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListPeeringRoutesFixedSizeCollection createEmptyCollection() {
            return new ListPeeringRoutesFixedSizeCollection(null, 0);
        }

        protected ListPeeringRoutesFixedSizeCollection createCollection(List<ListPeeringRoutesPage> pages, int collectionSize) {
            return new ListPeeringRoutesFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListPeeringRoutesPage
    extends AbstractPage<ListPeeringRoutesRequest, ListPeeringRoutesResponse, PeeringRoute, ListPeeringRoutesPage> {
        private ListPeeringRoutesPage(PageContext<ListPeeringRoutesRequest, ListPeeringRoutesResponse, PeeringRoute> context, ListPeeringRoutesResponse response) {
            super(context, (Object)response);
        }

        private static ListPeeringRoutesPage createEmptyPage() {
            return new ListPeeringRoutesPage(null, null);
        }

        protected ListPeeringRoutesPage createPage(PageContext<ListPeeringRoutesRequest, ListPeeringRoutesResponse, PeeringRoute> context, ListPeeringRoutesResponse response) {
            return new ListPeeringRoutesPage(context, response);
        }

        public ApiFuture<ListPeeringRoutesPage> createPageAsync(PageContext<ListPeeringRoutesRequest, ListPeeringRoutesResponse, PeeringRoute> context, ApiFuture<ListPeeringRoutesResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListPeeringRoutesPagedResponse
    extends AbstractPagedListResponse<ListPeeringRoutesRequest, ListPeeringRoutesResponse, PeeringRoute, ListPeeringRoutesPage, ListPeeringRoutesFixedSizeCollection> {
        public static ApiFuture<ListPeeringRoutesPagedResponse> createAsync(PageContext<ListPeeringRoutesRequest, ListPeeringRoutesResponse, PeeringRoute> context, ApiFuture<ListPeeringRoutesResponse> futureResponse) {
            ApiFuture<ListPeeringRoutesPage> futurePage = ListPeeringRoutesPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListPeeringRoutesPagedResponse((ListPeeringRoutesPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListPeeringRoutesPagedResponse(ListPeeringRoutesPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListPeeringRoutesFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListNetworkPeeringsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListNetworkPeeringsRequest, ListNetworkPeeringsResponse, NetworkPeering, ListNetworkPeeringsPage, ListNetworkPeeringsFixedSizeCollection> {
        private ListNetworkPeeringsFixedSizeCollection(List<ListNetworkPeeringsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListNetworkPeeringsFixedSizeCollection createEmptyCollection() {
            return new ListNetworkPeeringsFixedSizeCollection(null, 0);
        }

        protected ListNetworkPeeringsFixedSizeCollection createCollection(List<ListNetworkPeeringsPage> pages, int collectionSize) {
            return new ListNetworkPeeringsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListNetworkPeeringsPage
    extends AbstractPage<ListNetworkPeeringsRequest, ListNetworkPeeringsResponse, NetworkPeering, ListNetworkPeeringsPage> {
        private ListNetworkPeeringsPage(PageContext<ListNetworkPeeringsRequest, ListNetworkPeeringsResponse, NetworkPeering> context, ListNetworkPeeringsResponse response) {
            super(context, (Object)response);
        }

        private static ListNetworkPeeringsPage createEmptyPage() {
            return new ListNetworkPeeringsPage(null, null);
        }

        protected ListNetworkPeeringsPage createPage(PageContext<ListNetworkPeeringsRequest, ListNetworkPeeringsResponse, NetworkPeering> context, ListNetworkPeeringsResponse response) {
            return new ListNetworkPeeringsPage(context, response);
        }

        public ApiFuture<ListNetworkPeeringsPage> createPageAsync(PageContext<ListNetworkPeeringsRequest, ListNetworkPeeringsResponse, NetworkPeering> context, ApiFuture<ListNetworkPeeringsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListNetworkPeeringsPagedResponse
    extends AbstractPagedListResponse<ListNetworkPeeringsRequest, ListNetworkPeeringsResponse, NetworkPeering, ListNetworkPeeringsPage, ListNetworkPeeringsFixedSizeCollection> {
        public static ApiFuture<ListNetworkPeeringsPagedResponse> createAsync(PageContext<ListNetworkPeeringsRequest, ListNetworkPeeringsResponse, NetworkPeering> context, ApiFuture<ListNetworkPeeringsResponse> futureResponse) {
            ApiFuture<ListNetworkPeeringsPage> futurePage = ListNetworkPeeringsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListNetworkPeeringsPagedResponse((ListNetworkPeeringsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListNetworkPeeringsPagedResponse(ListNetworkPeeringsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListNetworkPeeringsFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListNodeTypesFixedSizeCollection
    extends AbstractFixedSizeCollection<ListNodeTypesRequest, ListNodeTypesResponse, NodeType, ListNodeTypesPage, ListNodeTypesFixedSizeCollection> {
        private ListNodeTypesFixedSizeCollection(List<ListNodeTypesPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListNodeTypesFixedSizeCollection createEmptyCollection() {
            return new ListNodeTypesFixedSizeCollection(null, 0);
        }

        protected ListNodeTypesFixedSizeCollection createCollection(List<ListNodeTypesPage> pages, int collectionSize) {
            return new ListNodeTypesFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListNodeTypesPage
    extends AbstractPage<ListNodeTypesRequest, ListNodeTypesResponse, NodeType, ListNodeTypesPage> {
        private ListNodeTypesPage(PageContext<ListNodeTypesRequest, ListNodeTypesResponse, NodeType> context, ListNodeTypesResponse response) {
            super(context, (Object)response);
        }

        private static ListNodeTypesPage createEmptyPage() {
            return new ListNodeTypesPage(null, null);
        }

        protected ListNodeTypesPage createPage(PageContext<ListNodeTypesRequest, ListNodeTypesResponse, NodeType> context, ListNodeTypesResponse response) {
            return new ListNodeTypesPage(context, response);
        }

        public ApiFuture<ListNodeTypesPage> createPageAsync(PageContext<ListNodeTypesRequest, ListNodeTypesResponse, NodeType> context, ApiFuture<ListNodeTypesResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListNodeTypesPagedResponse
    extends AbstractPagedListResponse<ListNodeTypesRequest, ListNodeTypesResponse, NodeType, ListNodeTypesPage, ListNodeTypesFixedSizeCollection> {
        public static ApiFuture<ListNodeTypesPagedResponse> createAsync(PageContext<ListNodeTypesRequest, ListNodeTypesResponse, NodeType> context, ApiFuture<ListNodeTypesResponse> futureResponse) {
            ApiFuture<ListNodeTypesPage> futurePage = ListNodeTypesPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListNodeTypesPagedResponse((ListNodeTypesPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListNodeTypesPagedResponse(ListNodeTypesPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListNodeTypesFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListLoggingServersFixedSizeCollection
    extends AbstractFixedSizeCollection<ListLoggingServersRequest, ListLoggingServersResponse, LoggingServer, ListLoggingServersPage, ListLoggingServersFixedSizeCollection> {
        private ListLoggingServersFixedSizeCollection(List<ListLoggingServersPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListLoggingServersFixedSizeCollection createEmptyCollection() {
            return new ListLoggingServersFixedSizeCollection(null, 0);
        }

        protected ListLoggingServersFixedSizeCollection createCollection(List<ListLoggingServersPage> pages, int collectionSize) {
            return new ListLoggingServersFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListLoggingServersPage
    extends AbstractPage<ListLoggingServersRequest, ListLoggingServersResponse, LoggingServer, ListLoggingServersPage> {
        private ListLoggingServersPage(PageContext<ListLoggingServersRequest, ListLoggingServersResponse, LoggingServer> context, ListLoggingServersResponse response) {
            super(context, (Object)response);
        }

        private static ListLoggingServersPage createEmptyPage() {
            return new ListLoggingServersPage(null, null);
        }

        protected ListLoggingServersPage createPage(PageContext<ListLoggingServersRequest, ListLoggingServersResponse, LoggingServer> context, ListLoggingServersResponse response) {
            return new ListLoggingServersPage(context, response);
        }

        public ApiFuture<ListLoggingServersPage> createPageAsync(PageContext<ListLoggingServersRequest, ListLoggingServersResponse, LoggingServer> context, ApiFuture<ListLoggingServersResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListLoggingServersPagedResponse
    extends AbstractPagedListResponse<ListLoggingServersRequest, ListLoggingServersResponse, LoggingServer, ListLoggingServersPage, ListLoggingServersFixedSizeCollection> {
        public static ApiFuture<ListLoggingServersPagedResponse> createAsync(PageContext<ListLoggingServersRequest, ListLoggingServersResponse, LoggingServer> context, ApiFuture<ListLoggingServersResponse> futureResponse) {
            ApiFuture<ListLoggingServersPage> futurePage = ListLoggingServersPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListLoggingServersPagedResponse((ListLoggingServersPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListLoggingServersPagedResponse(ListLoggingServersPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListLoggingServersFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListExternalAccessRulesFixedSizeCollection
    extends AbstractFixedSizeCollection<ListExternalAccessRulesRequest, ListExternalAccessRulesResponse, ExternalAccessRule, ListExternalAccessRulesPage, ListExternalAccessRulesFixedSizeCollection> {
        private ListExternalAccessRulesFixedSizeCollection(List<ListExternalAccessRulesPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListExternalAccessRulesFixedSizeCollection createEmptyCollection() {
            return new ListExternalAccessRulesFixedSizeCollection(null, 0);
        }

        protected ListExternalAccessRulesFixedSizeCollection createCollection(List<ListExternalAccessRulesPage> pages, int collectionSize) {
            return new ListExternalAccessRulesFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListExternalAccessRulesPage
    extends AbstractPage<ListExternalAccessRulesRequest, ListExternalAccessRulesResponse, ExternalAccessRule, ListExternalAccessRulesPage> {
        private ListExternalAccessRulesPage(PageContext<ListExternalAccessRulesRequest, ListExternalAccessRulesResponse, ExternalAccessRule> context, ListExternalAccessRulesResponse response) {
            super(context, (Object)response);
        }

        private static ListExternalAccessRulesPage createEmptyPage() {
            return new ListExternalAccessRulesPage(null, null);
        }

        protected ListExternalAccessRulesPage createPage(PageContext<ListExternalAccessRulesRequest, ListExternalAccessRulesResponse, ExternalAccessRule> context, ListExternalAccessRulesResponse response) {
            return new ListExternalAccessRulesPage(context, response);
        }

        public ApiFuture<ListExternalAccessRulesPage> createPageAsync(PageContext<ListExternalAccessRulesRequest, ListExternalAccessRulesResponse, ExternalAccessRule> context, ApiFuture<ListExternalAccessRulesResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListExternalAccessRulesPagedResponse
    extends AbstractPagedListResponse<ListExternalAccessRulesRequest, ListExternalAccessRulesResponse, ExternalAccessRule, ListExternalAccessRulesPage, ListExternalAccessRulesFixedSizeCollection> {
        public static ApiFuture<ListExternalAccessRulesPagedResponse> createAsync(PageContext<ListExternalAccessRulesRequest, ListExternalAccessRulesResponse, ExternalAccessRule> context, ApiFuture<ListExternalAccessRulesResponse> futureResponse) {
            ApiFuture<ListExternalAccessRulesPage> futurePage = ListExternalAccessRulesPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListExternalAccessRulesPagedResponse((ListExternalAccessRulesPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListExternalAccessRulesPagedResponse(ListExternalAccessRulesPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListExternalAccessRulesFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListSubnetsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListSubnetsRequest, ListSubnetsResponse, Subnet, ListSubnetsPage, ListSubnetsFixedSizeCollection> {
        private ListSubnetsFixedSizeCollection(List<ListSubnetsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListSubnetsFixedSizeCollection createEmptyCollection() {
            return new ListSubnetsFixedSizeCollection(null, 0);
        }

        protected ListSubnetsFixedSizeCollection createCollection(List<ListSubnetsPage> pages, int collectionSize) {
            return new ListSubnetsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListSubnetsPage
    extends AbstractPage<ListSubnetsRequest, ListSubnetsResponse, Subnet, ListSubnetsPage> {
        private ListSubnetsPage(PageContext<ListSubnetsRequest, ListSubnetsResponse, Subnet> context, ListSubnetsResponse response) {
            super(context, (Object)response);
        }

        private static ListSubnetsPage createEmptyPage() {
            return new ListSubnetsPage(null, null);
        }

        protected ListSubnetsPage createPage(PageContext<ListSubnetsRequest, ListSubnetsResponse, Subnet> context, ListSubnetsResponse response) {
            return new ListSubnetsPage(context, response);
        }

        public ApiFuture<ListSubnetsPage> createPageAsync(PageContext<ListSubnetsRequest, ListSubnetsResponse, Subnet> context, ApiFuture<ListSubnetsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListSubnetsPagedResponse
    extends AbstractPagedListResponse<ListSubnetsRequest, ListSubnetsResponse, Subnet, ListSubnetsPage, ListSubnetsFixedSizeCollection> {
        public static ApiFuture<ListSubnetsPagedResponse> createAsync(PageContext<ListSubnetsRequest, ListSubnetsResponse, Subnet> context, ApiFuture<ListSubnetsResponse> futureResponse) {
            ApiFuture<ListSubnetsPage> futurePage = ListSubnetsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListSubnetsPagedResponse((ListSubnetsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListSubnetsPagedResponse(ListSubnetsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListSubnetsFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class FetchNetworkPolicyExternalAddressesFixedSizeCollection
    extends AbstractFixedSizeCollection<FetchNetworkPolicyExternalAddressesRequest, FetchNetworkPolicyExternalAddressesResponse, ExternalAddress, FetchNetworkPolicyExternalAddressesPage, FetchNetworkPolicyExternalAddressesFixedSizeCollection> {
        private FetchNetworkPolicyExternalAddressesFixedSizeCollection(List<FetchNetworkPolicyExternalAddressesPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static FetchNetworkPolicyExternalAddressesFixedSizeCollection createEmptyCollection() {
            return new FetchNetworkPolicyExternalAddressesFixedSizeCollection(null, 0);
        }

        protected FetchNetworkPolicyExternalAddressesFixedSizeCollection createCollection(List<FetchNetworkPolicyExternalAddressesPage> pages, int collectionSize) {
            return new FetchNetworkPolicyExternalAddressesFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class FetchNetworkPolicyExternalAddressesPage
    extends AbstractPage<FetchNetworkPolicyExternalAddressesRequest, FetchNetworkPolicyExternalAddressesResponse, ExternalAddress, FetchNetworkPolicyExternalAddressesPage> {
        private FetchNetworkPolicyExternalAddressesPage(PageContext<FetchNetworkPolicyExternalAddressesRequest, FetchNetworkPolicyExternalAddressesResponse, ExternalAddress> context, FetchNetworkPolicyExternalAddressesResponse response) {
            super(context, (Object)response);
        }

        private static FetchNetworkPolicyExternalAddressesPage createEmptyPage() {
            return new FetchNetworkPolicyExternalAddressesPage(null, null);
        }

        protected FetchNetworkPolicyExternalAddressesPage createPage(PageContext<FetchNetworkPolicyExternalAddressesRequest, FetchNetworkPolicyExternalAddressesResponse, ExternalAddress> context, FetchNetworkPolicyExternalAddressesResponse response) {
            return new FetchNetworkPolicyExternalAddressesPage(context, response);
        }

        public ApiFuture<FetchNetworkPolicyExternalAddressesPage> createPageAsync(PageContext<FetchNetworkPolicyExternalAddressesRequest, FetchNetworkPolicyExternalAddressesResponse, ExternalAddress> context, ApiFuture<FetchNetworkPolicyExternalAddressesResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class FetchNetworkPolicyExternalAddressesPagedResponse
    extends AbstractPagedListResponse<FetchNetworkPolicyExternalAddressesRequest, FetchNetworkPolicyExternalAddressesResponse, ExternalAddress, FetchNetworkPolicyExternalAddressesPage, FetchNetworkPolicyExternalAddressesFixedSizeCollection> {
        public static ApiFuture<FetchNetworkPolicyExternalAddressesPagedResponse> createAsync(PageContext<FetchNetworkPolicyExternalAddressesRequest, FetchNetworkPolicyExternalAddressesResponse, ExternalAddress> context, ApiFuture<FetchNetworkPolicyExternalAddressesResponse> futureResponse) {
            ApiFuture<FetchNetworkPolicyExternalAddressesPage> futurePage = FetchNetworkPolicyExternalAddressesPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new FetchNetworkPolicyExternalAddressesPagedResponse((FetchNetworkPolicyExternalAddressesPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private FetchNetworkPolicyExternalAddressesPagedResponse(FetchNetworkPolicyExternalAddressesPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)FetchNetworkPolicyExternalAddressesFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListExternalAddressesFixedSizeCollection
    extends AbstractFixedSizeCollection<ListExternalAddressesRequest, ListExternalAddressesResponse, ExternalAddress, ListExternalAddressesPage, ListExternalAddressesFixedSizeCollection> {
        private ListExternalAddressesFixedSizeCollection(List<ListExternalAddressesPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListExternalAddressesFixedSizeCollection createEmptyCollection() {
            return new ListExternalAddressesFixedSizeCollection(null, 0);
        }

        protected ListExternalAddressesFixedSizeCollection createCollection(List<ListExternalAddressesPage> pages, int collectionSize) {
            return new ListExternalAddressesFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListExternalAddressesPage
    extends AbstractPage<ListExternalAddressesRequest, ListExternalAddressesResponse, ExternalAddress, ListExternalAddressesPage> {
        private ListExternalAddressesPage(PageContext<ListExternalAddressesRequest, ListExternalAddressesResponse, ExternalAddress> context, ListExternalAddressesResponse response) {
            super(context, (Object)response);
        }

        private static ListExternalAddressesPage createEmptyPage() {
            return new ListExternalAddressesPage(null, null);
        }

        protected ListExternalAddressesPage createPage(PageContext<ListExternalAddressesRequest, ListExternalAddressesResponse, ExternalAddress> context, ListExternalAddressesResponse response) {
            return new ListExternalAddressesPage(context, response);
        }

        public ApiFuture<ListExternalAddressesPage> createPageAsync(PageContext<ListExternalAddressesRequest, ListExternalAddressesResponse, ExternalAddress> context, ApiFuture<ListExternalAddressesResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListExternalAddressesPagedResponse
    extends AbstractPagedListResponse<ListExternalAddressesRequest, ListExternalAddressesResponse, ExternalAddress, ListExternalAddressesPage, ListExternalAddressesFixedSizeCollection> {
        public static ApiFuture<ListExternalAddressesPagedResponse> createAsync(PageContext<ListExternalAddressesRequest, ListExternalAddressesResponse, ExternalAddress> context, ApiFuture<ListExternalAddressesResponse> futureResponse) {
            ApiFuture<ListExternalAddressesPage> futurePage = ListExternalAddressesPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListExternalAddressesPagedResponse((ListExternalAddressesPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListExternalAddressesPagedResponse(ListExternalAddressesPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListExternalAddressesFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListNodesFixedSizeCollection
    extends AbstractFixedSizeCollection<ListNodesRequest, ListNodesResponse, Node, ListNodesPage, ListNodesFixedSizeCollection> {
        private ListNodesFixedSizeCollection(List<ListNodesPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListNodesFixedSizeCollection createEmptyCollection() {
            return new ListNodesFixedSizeCollection(null, 0);
        }

        protected ListNodesFixedSizeCollection createCollection(List<ListNodesPage> pages, int collectionSize) {
            return new ListNodesFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListNodesPage
    extends AbstractPage<ListNodesRequest, ListNodesResponse, Node, ListNodesPage> {
        private ListNodesPage(PageContext<ListNodesRequest, ListNodesResponse, Node> context, ListNodesResponse response) {
            super(context, (Object)response);
        }

        private static ListNodesPage createEmptyPage() {
            return new ListNodesPage(null, null);
        }

        protected ListNodesPage createPage(PageContext<ListNodesRequest, ListNodesResponse, Node> context, ListNodesResponse response) {
            return new ListNodesPage(context, response);
        }

        public ApiFuture<ListNodesPage> createPageAsync(PageContext<ListNodesRequest, ListNodesResponse, Node> context, ApiFuture<ListNodesResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListNodesPagedResponse
    extends AbstractPagedListResponse<ListNodesRequest, ListNodesResponse, Node, ListNodesPage, ListNodesFixedSizeCollection> {
        public static ApiFuture<ListNodesPagedResponse> createAsync(PageContext<ListNodesRequest, ListNodesResponse, Node> context, ApiFuture<ListNodesResponse> futureResponse) {
            ApiFuture<ListNodesPage> futurePage = ListNodesPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListNodesPagedResponse((ListNodesPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListNodesPagedResponse(ListNodesPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListNodesFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListClustersFixedSizeCollection
    extends AbstractFixedSizeCollection<ListClustersRequest, ListClustersResponse, Cluster, ListClustersPage, ListClustersFixedSizeCollection> {
        private ListClustersFixedSizeCollection(List<ListClustersPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListClustersFixedSizeCollection createEmptyCollection() {
            return new ListClustersFixedSizeCollection(null, 0);
        }

        protected ListClustersFixedSizeCollection createCollection(List<ListClustersPage> pages, int collectionSize) {
            return new ListClustersFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListClustersPage
    extends AbstractPage<ListClustersRequest, ListClustersResponse, Cluster, ListClustersPage> {
        private ListClustersPage(PageContext<ListClustersRequest, ListClustersResponse, Cluster> context, ListClustersResponse response) {
            super(context, (Object)response);
        }

        private static ListClustersPage createEmptyPage() {
            return new ListClustersPage(null, null);
        }

        protected ListClustersPage createPage(PageContext<ListClustersRequest, ListClustersResponse, Cluster> context, ListClustersResponse response) {
            return new ListClustersPage(context, response);
        }

        public ApiFuture<ListClustersPage> createPageAsync(PageContext<ListClustersRequest, ListClustersResponse, Cluster> context, ApiFuture<ListClustersResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListClustersPagedResponse
    extends AbstractPagedListResponse<ListClustersRequest, ListClustersResponse, Cluster, ListClustersPage, ListClustersFixedSizeCollection> {
        public static ApiFuture<ListClustersPagedResponse> createAsync(PageContext<ListClustersRequest, ListClustersResponse, Cluster> context, ApiFuture<ListClustersResponse> futureResponse) {
            ApiFuture<ListClustersPage> futurePage = ListClustersPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListClustersPagedResponse((ListClustersPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListClustersPagedResponse(ListClustersPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListClustersFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListPrivateCloudsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListPrivateCloudsRequest, ListPrivateCloudsResponse, PrivateCloud, ListPrivateCloudsPage, ListPrivateCloudsFixedSizeCollection> {
        private ListPrivateCloudsFixedSizeCollection(List<ListPrivateCloudsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListPrivateCloudsFixedSizeCollection createEmptyCollection() {
            return new ListPrivateCloudsFixedSizeCollection(null, 0);
        }

        protected ListPrivateCloudsFixedSizeCollection createCollection(List<ListPrivateCloudsPage> pages, int collectionSize) {
            return new ListPrivateCloudsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListPrivateCloudsPage
    extends AbstractPage<ListPrivateCloudsRequest, ListPrivateCloudsResponse, PrivateCloud, ListPrivateCloudsPage> {
        private ListPrivateCloudsPage(PageContext<ListPrivateCloudsRequest, ListPrivateCloudsResponse, PrivateCloud> context, ListPrivateCloudsResponse response) {
            super(context, (Object)response);
        }

        private static ListPrivateCloudsPage createEmptyPage() {
            return new ListPrivateCloudsPage(null, null);
        }

        protected ListPrivateCloudsPage createPage(PageContext<ListPrivateCloudsRequest, ListPrivateCloudsResponse, PrivateCloud> context, ListPrivateCloudsResponse response) {
            return new ListPrivateCloudsPage(context, response);
        }

        public ApiFuture<ListPrivateCloudsPage> createPageAsync(PageContext<ListPrivateCloudsRequest, ListPrivateCloudsResponse, PrivateCloud> context, ApiFuture<ListPrivateCloudsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListPrivateCloudsPagedResponse
    extends AbstractPagedListResponse<ListPrivateCloudsRequest, ListPrivateCloudsResponse, PrivateCloud, ListPrivateCloudsPage, ListPrivateCloudsFixedSizeCollection> {
        public static ApiFuture<ListPrivateCloudsPagedResponse> createAsync(PageContext<ListPrivateCloudsRequest, ListPrivateCloudsResponse, PrivateCloud> context, ApiFuture<ListPrivateCloudsResponse> futureResponse) {
            ApiFuture<ListPrivateCloudsPage> futurePage = ListPrivateCloudsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListPrivateCloudsPagedResponse((ListPrivateCloudsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListPrivateCloudsPagedResponse(ListPrivateCloudsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListPrivateCloudsFixedSizeCollection.createEmptyCollection());
        }
    }
}

