/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.vision.v1;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.longrunning.OperationFuture;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.OperationCallable;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.api.pathtemplate.PathTemplate;
import com.google.cloud.vision.v1.AddProductToProductSetRequest;
import com.google.cloud.vision.v1.BatchOperationMetadata;
import com.google.cloud.vision.v1.CreateProductRequest;
import com.google.cloud.vision.v1.CreateProductSetRequest;
import com.google.cloud.vision.v1.CreateReferenceImageRequest;
import com.google.cloud.vision.v1.DeleteProductRequest;
import com.google.cloud.vision.v1.DeleteProductSetRequest;
import com.google.cloud.vision.v1.DeleteReferenceImageRequest;
import com.google.cloud.vision.v1.GetProductRequest;
import com.google.cloud.vision.v1.GetProductSetRequest;
import com.google.cloud.vision.v1.GetReferenceImageRequest;
import com.google.cloud.vision.v1.ImportProductSetsInputConfig;
import com.google.cloud.vision.v1.ImportProductSetsRequest;
import com.google.cloud.vision.v1.ImportProductSetsResponse;
import com.google.cloud.vision.v1.ListProductSetsRequest;
import com.google.cloud.vision.v1.ListProductSetsResponse;
import com.google.cloud.vision.v1.ListProductsInProductSetRequest;
import com.google.cloud.vision.v1.ListProductsInProductSetResponse;
import com.google.cloud.vision.v1.ListProductsRequest;
import com.google.cloud.vision.v1.ListProductsResponse;
import com.google.cloud.vision.v1.ListReferenceImagesRequest;
import com.google.cloud.vision.v1.ListReferenceImagesResponse;
import com.google.cloud.vision.v1.Product;
import com.google.cloud.vision.v1.ProductSearchSettings;
import com.google.cloud.vision.v1.ProductSet;
import com.google.cloud.vision.v1.ReferenceImage;
import com.google.cloud.vision.v1.RemoveProductFromProductSetRequest;
import com.google.cloud.vision.v1.UpdateProductRequest;
import com.google.cloud.vision.v1.UpdateProductSetRequest;
import com.google.cloud.vision.v1.stub.ProductSearchStub;
import com.google.cloud.vision.v1.stub.ProductSearchStubSettings;
import com.google.longrunning.Operation;
import com.google.longrunning.OperationsClient;
import com.google.longrunning.stub.OperationsStub;
import com.google.protobuf.Empty;
import com.google.protobuf.FieldMask;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.TimeUnit;

public class ProductSearchClient
implements BackgroundResource {
    private final ProductSearchSettings settings;
    private final ProductSearchStub stub;
    private final OperationsClient operationsClient;
    private static final PathTemplate LOCATION_PATH_TEMPLATE = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}");
    private static final PathTemplate PRODUCT_PATH_TEMPLATE = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/products/{product}");
    private static final PathTemplate PRODUCT_SET_PATH_TEMPLATE = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/productSets/{product_set}");
    private static final PathTemplate IMAGE_PATH_TEMPLATE = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/products/{product}/referenceImages/{image}");

    public static final String formatLocationName(String project, String location) {
        return LOCATION_PATH_TEMPLATE.instantiate(new String[]{"project", project, "location", location});
    }

    public static final String formatProductName(String project, String location, String product) {
        return PRODUCT_PATH_TEMPLATE.instantiate(new String[]{"project", project, "location", location, "product", product});
    }

    public static final String formatProductSetName(String project, String location, String productSet) {
        return PRODUCT_SET_PATH_TEMPLATE.instantiate(new String[]{"project", project, "location", location, "product_set", productSet});
    }

    public static final String formatImageName(String project, String location, String product, String image) {
        return IMAGE_PATH_TEMPLATE.instantiate(new String[]{"project", project, "location", location, "product", product, "image", image});
    }

    public static final String parseProjectFromLocationName(String locationName) {
        return LOCATION_PATH_TEMPLATE.parse(locationName).get((Object)"project");
    }

    public static final String parseLocationFromLocationName(String locationName) {
        return LOCATION_PATH_TEMPLATE.parse(locationName).get((Object)"location");
    }

    public static final String parseProjectFromProductName(String productName) {
        return PRODUCT_PATH_TEMPLATE.parse(productName).get((Object)"project");
    }

    public static final String parseLocationFromProductName(String productName) {
        return PRODUCT_PATH_TEMPLATE.parse(productName).get((Object)"location");
    }

    public static final String parseProductFromProductName(String productName) {
        return PRODUCT_PATH_TEMPLATE.parse(productName).get((Object)"product");
    }

    public static final String parseProjectFromProductSetName(String productSetName) {
        return PRODUCT_SET_PATH_TEMPLATE.parse(productSetName).get((Object)"project");
    }

    public static final String parseLocationFromProductSetName(String productSetName) {
        return PRODUCT_SET_PATH_TEMPLATE.parse(productSetName).get((Object)"location");
    }

    public static final String parseProductSetFromProductSetName(String productSetName) {
        return PRODUCT_SET_PATH_TEMPLATE.parse(productSetName).get((Object)"product_set");
    }

    public static final String parseProjectFromImageName(String imageName) {
        return IMAGE_PATH_TEMPLATE.parse(imageName).get((Object)"project");
    }

    public static final String parseLocationFromImageName(String imageName) {
        return IMAGE_PATH_TEMPLATE.parse(imageName).get((Object)"location");
    }

    public static final String parseProductFromImageName(String imageName) {
        return IMAGE_PATH_TEMPLATE.parse(imageName).get((Object)"product");
    }

    public static final String parseImageFromImageName(String imageName) {
        return IMAGE_PATH_TEMPLATE.parse(imageName).get((Object)"image");
    }

    public static final ProductSearchClient create() throws IOException {
        return ProductSearchClient.create(ProductSearchSettings.newBuilder().build());
    }

    public static final ProductSearchClient create(ProductSearchSettings settings) throws IOException {
        return new ProductSearchClient(settings);
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public static final ProductSearchClient create(ProductSearchStub stub) {
        return new ProductSearchClient(stub);
    }

    protected ProductSearchClient(ProductSearchSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((ProductSearchStubSettings)settings.getStubSettings()).createStub();
        this.operationsClient = OperationsClient.create((OperationsStub)this.stub.getOperationsStub());
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    protected ProductSearchClient(ProductSearchStub stub) {
        this.settings = null;
        this.stub = stub;
        this.operationsClient = OperationsClient.create((OperationsStub)this.stub.getOperationsStub());
    }

    public final ProductSearchSettings getSettings() {
        return this.settings;
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public ProductSearchStub getStub() {
        return this.stub;
    }

    @BetaApi(value="The surface for long-running operations is not stable yet and may change in the future.")
    public final OperationsClient getOperationsClient() {
        return this.operationsClient;
    }

    public final Product createProduct(String parent, Product product, String productId) {
        LOCATION_PATH_TEMPLATE.validate(parent, "createProduct");
        CreateProductRequest request = CreateProductRequest.newBuilder().setParent(parent).setProduct(product).setProductId(productId).build();
        return this.createProduct(request);
    }

    public final Product createProduct(CreateProductRequest request) {
        return (Product)this.createProductCallable().call((Object)request);
    }

    public final UnaryCallable<CreateProductRequest, Product> createProductCallable() {
        return this.stub.createProductCallable();
    }

    public final ListProductsPagedResponse listProducts(String parent) {
        LOCATION_PATH_TEMPLATE.validate(parent, "listProducts");
        ListProductsRequest request = ListProductsRequest.newBuilder().setParent(parent).build();
        return this.listProducts(request);
    }

    public final ListProductsPagedResponse listProducts(ListProductsRequest request) {
        return (ListProductsPagedResponse)((Object)this.listProductsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListProductsRequest, ListProductsPagedResponse> listProductsPagedCallable() {
        return this.stub.listProductsPagedCallable();
    }

    public final UnaryCallable<ListProductsRequest, ListProductsResponse> listProductsCallable() {
        return this.stub.listProductsCallable();
    }

    public final Product getProduct(String name) {
        PRODUCT_PATH_TEMPLATE.validate(name, "getProduct");
        GetProductRequest request = GetProductRequest.newBuilder().setName(name).build();
        return this.getProduct(request);
    }

    public final Product getProduct(GetProductRequest request) {
        return (Product)this.getProductCallable().call((Object)request);
    }

    public final UnaryCallable<GetProductRequest, Product> getProductCallable() {
        return this.stub.getProductCallable();
    }

    public final Product updateProduct(Product product, FieldMask updateMask) {
        UpdateProductRequest request = UpdateProductRequest.newBuilder().setProduct(product).setUpdateMask(updateMask).build();
        return this.updateProduct(request);
    }

    public final Product updateProduct(UpdateProductRequest request) {
        return (Product)this.updateProductCallable().call((Object)request);
    }

    public final UnaryCallable<UpdateProductRequest, Product> updateProductCallable() {
        return this.stub.updateProductCallable();
    }

    public final void deleteProduct(String name) {
        PRODUCT_PATH_TEMPLATE.validate(name, "deleteProduct");
        DeleteProductRequest request = DeleteProductRequest.newBuilder().setName(name).build();
        this.deleteProduct(request);
    }

    public final void deleteProduct(DeleteProductRequest request) {
        this.deleteProductCallable().call((Object)request);
    }

    public final UnaryCallable<DeleteProductRequest, Empty> deleteProductCallable() {
        return this.stub.deleteProductCallable();
    }

    public final ListReferenceImagesPagedResponse listReferenceImages(String parent) {
        PRODUCT_PATH_TEMPLATE.validate(parent, "listReferenceImages");
        ListReferenceImagesRequest request = ListReferenceImagesRequest.newBuilder().setParent(parent).build();
        return this.listReferenceImages(request);
    }

    public final ListReferenceImagesPagedResponse listReferenceImages(ListReferenceImagesRequest request) {
        return (ListReferenceImagesPagedResponse)((Object)this.listReferenceImagesPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListReferenceImagesRequest, ListReferenceImagesPagedResponse> listReferenceImagesPagedCallable() {
        return this.stub.listReferenceImagesPagedCallable();
    }

    public final UnaryCallable<ListReferenceImagesRequest, ListReferenceImagesResponse> listReferenceImagesCallable() {
        return this.stub.listReferenceImagesCallable();
    }

    public final ReferenceImage getReferenceImage(String name) {
        IMAGE_PATH_TEMPLATE.validate(name, "getReferenceImage");
        GetReferenceImageRequest request = GetReferenceImageRequest.newBuilder().setName(name).build();
        return this.getReferenceImage(request);
    }

    public final ReferenceImage getReferenceImage(GetReferenceImageRequest request) {
        return (ReferenceImage)this.getReferenceImageCallable().call((Object)request);
    }

    public final UnaryCallable<GetReferenceImageRequest, ReferenceImage> getReferenceImageCallable() {
        return this.stub.getReferenceImageCallable();
    }

    public final void deleteReferenceImage(String name) {
        IMAGE_PATH_TEMPLATE.validate(name, "deleteReferenceImage");
        DeleteReferenceImageRequest request = DeleteReferenceImageRequest.newBuilder().setName(name).build();
        this.deleteReferenceImage(request);
    }

    public final void deleteReferenceImage(DeleteReferenceImageRequest request) {
        this.deleteReferenceImageCallable().call((Object)request);
    }

    public final UnaryCallable<DeleteReferenceImageRequest, Empty> deleteReferenceImageCallable() {
        return this.stub.deleteReferenceImageCallable();
    }

    public final ReferenceImage createReferenceImage(String parent, ReferenceImage referenceImage, String referenceImageId) {
        PRODUCT_PATH_TEMPLATE.validate(parent, "createReferenceImage");
        CreateReferenceImageRequest request = CreateReferenceImageRequest.newBuilder().setParent(parent).setReferenceImage(referenceImage).setReferenceImageId(referenceImageId).build();
        return this.createReferenceImage(request);
    }

    public final ReferenceImage createReferenceImage(CreateReferenceImageRequest request) {
        return (ReferenceImage)this.createReferenceImageCallable().call((Object)request);
    }

    public final UnaryCallable<CreateReferenceImageRequest, ReferenceImage> createReferenceImageCallable() {
        return this.stub.createReferenceImageCallable();
    }

    public final ProductSet createProductSet(String parent, ProductSet productSet, String productSetId) {
        LOCATION_PATH_TEMPLATE.validate(parent, "createProductSet");
        CreateProductSetRequest request = CreateProductSetRequest.newBuilder().setParent(parent).setProductSet(productSet).setProductSetId(productSetId).build();
        return this.createProductSet(request);
    }

    public final ProductSet createProductSet(CreateProductSetRequest request) {
        return (ProductSet)this.createProductSetCallable().call((Object)request);
    }

    public final UnaryCallable<CreateProductSetRequest, ProductSet> createProductSetCallable() {
        return this.stub.createProductSetCallable();
    }

    public final ListProductSetsPagedResponse listProductSets(String parent) {
        LOCATION_PATH_TEMPLATE.validate(parent, "listProductSets");
        ListProductSetsRequest request = ListProductSetsRequest.newBuilder().setParent(parent).build();
        return this.listProductSets(request);
    }

    public final ListProductSetsPagedResponse listProductSets(ListProductSetsRequest request) {
        return (ListProductSetsPagedResponse)((Object)this.listProductSetsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListProductSetsRequest, ListProductSetsPagedResponse> listProductSetsPagedCallable() {
        return this.stub.listProductSetsPagedCallable();
    }

    public final UnaryCallable<ListProductSetsRequest, ListProductSetsResponse> listProductSetsCallable() {
        return this.stub.listProductSetsCallable();
    }

    public final ProductSet getProductSet(String name) {
        PRODUCT_SET_PATH_TEMPLATE.validate(name, "getProductSet");
        GetProductSetRequest request = GetProductSetRequest.newBuilder().setName(name).build();
        return this.getProductSet(request);
    }

    public final ProductSet getProductSet(GetProductSetRequest request) {
        return (ProductSet)this.getProductSetCallable().call((Object)request);
    }

    public final UnaryCallable<GetProductSetRequest, ProductSet> getProductSetCallable() {
        return this.stub.getProductSetCallable();
    }

    public final ProductSet updateProductSet(ProductSet productSet, FieldMask updateMask) {
        UpdateProductSetRequest request = UpdateProductSetRequest.newBuilder().setProductSet(productSet).setUpdateMask(updateMask).build();
        return this.updateProductSet(request);
    }

    public final ProductSet updateProductSet(UpdateProductSetRequest request) {
        return (ProductSet)this.updateProductSetCallable().call((Object)request);
    }

    public final UnaryCallable<UpdateProductSetRequest, ProductSet> updateProductSetCallable() {
        return this.stub.updateProductSetCallable();
    }

    public final void deleteProductSet(String name) {
        PRODUCT_SET_PATH_TEMPLATE.validate(name, "deleteProductSet");
        DeleteProductSetRequest request = DeleteProductSetRequest.newBuilder().setName(name).build();
        this.deleteProductSet(request);
    }

    public final void deleteProductSet(DeleteProductSetRequest request) {
        this.deleteProductSetCallable().call((Object)request);
    }

    public final UnaryCallable<DeleteProductSetRequest, Empty> deleteProductSetCallable() {
        return this.stub.deleteProductSetCallable();
    }

    public final void addProductToProductSet(String name, String product) {
        PRODUCT_SET_PATH_TEMPLATE.validate(name, "addProductToProductSet");
        AddProductToProductSetRequest request = AddProductToProductSetRequest.newBuilder().setName(name).setProduct(product).build();
        this.addProductToProductSet(request);
    }

    public final void addProductToProductSet(AddProductToProductSetRequest request) {
        this.addProductToProductSetCallable().call((Object)request);
    }

    public final UnaryCallable<AddProductToProductSetRequest, Empty> addProductToProductSetCallable() {
        return this.stub.addProductToProductSetCallable();
    }

    public final void removeProductFromProductSet(String name, String product) {
        PRODUCT_SET_PATH_TEMPLATE.validate(name, "removeProductFromProductSet");
        RemoveProductFromProductSetRequest request = RemoveProductFromProductSetRequest.newBuilder().setName(name).setProduct(product).build();
        this.removeProductFromProductSet(request);
    }

    public final void removeProductFromProductSet(RemoveProductFromProductSetRequest request) {
        this.removeProductFromProductSetCallable().call((Object)request);
    }

    public final UnaryCallable<RemoveProductFromProductSetRequest, Empty> removeProductFromProductSetCallable() {
        return this.stub.removeProductFromProductSetCallable();
    }

    public final ListProductsInProductSetPagedResponse listProductsInProductSet(String name) {
        PRODUCT_SET_PATH_TEMPLATE.validate(name, "listProductsInProductSet");
        ListProductsInProductSetRequest request = ListProductsInProductSetRequest.newBuilder().setName(name).build();
        return this.listProductsInProductSet(request);
    }

    public final ListProductsInProductSetPagedResponse listProductsInProductSet(ListProductsInProductSetRequest request) {
        return (ListProductsInProductSetPagedResponse)((Object)this.listProductsInProductSetPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListProductsInProductSetRequest, ListProductsInProductSetPagedResponse> listProductsInProductSetPagedCallable() {
        return this.stub.listProductsInProductSetPagedCallable();
    }

    public final UnaryCallable<ListProductsInProductSetRequest, ListProductsInProductSetResponse> listProductsInProductSetCallable() {
        return this.stub.listProductsInProductSetCallable();
    }

    @BetaApi(value="The surface for long-running operations is not stable yet and may change in the future.")
    public final OperationFuture<ImportProductSetsResponse, BatchOperationMetadata> importProductSetsAsync(String parent, ImportProductSetsInputConfig inputConfig) {
        LOCATION_PATH_TEMPLATE.validate(parent, "importProductSets");
        ImportProductSetsRequest request = ImportProductSetsRequest.newBuilder().setParent(parent).setInputConfig(inputConfig).build();
        return this.importProductSetsAsync(request);
    }

    @BetaApi(value="The surface for long-running operations is not stable yet and may change in the future.")
    public final OperationFuture<ImportProductSetsResponse, BatchOperationMetadata> importProductSetsAsync(ImportProductSetsRequest request) {
        return this.importProductSetsOperationCallable().futureCall((Object)request);
    }

    @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
    public final OperationCallable<ImportProductSetsRequest, ImportProductSetsResponse, BatchOperationMetadata> importProductSetsOperationCallable() {
        return this.stub.importProductSetsOperationCallable();
    }

    public final UnaryCallable<ImportProductSetsRequest, Operation> importProductSetsCallable() {
        return this.stub.importProductSetsCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class ListProductsInProductSetFixedSizeCollection
    extends AbstractFixedSizeCollection<ListProductsInProductSetRequest, ListProductsInProductSetResponse, Product, ListProductsInProductSetPage, ListProductsInProductSetFixedSizeCollection> {
        private ListProductsInProductSetFixedSizeCollection(List<ListProductsInProductSetPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListProductsInProductSetFixedSizeCollection createEmptyCollection() {
            return new ListProductsInProductSetFixedSizeCollection(null, 0);
        }

        protected ListProductsInProductSetFixedSizeCollection createCollection(List<ListProductsInProductSetPage> pages, int collectionSize) {
            return new ListProductsInProductSetFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListProductsInProductSetPage
    extends AbstractPage<ListProductsInProductSetRequest, ListProductsInProductSetResponse, Product, ListProductsInProductSetPage> {
        private ListProductsInProductSetPage(PageContext<ListProductsInProductSetRequest, ListProductsInProductSetResponse, Product> context, ListProductsInProductSetResponse response) {
            super(context, (Object)response);
        }

        private static ListProductsInProductSetPage createEmptyPage() {
            return new ListProductsInProductSetPage(null, null);
        }

        protected ListProductsInProductSetPage createPage(PageContext<ListProductsInProductSetRequest, ListProductsInProductSetResponse, Product> context, ListProductsInProductSetResponse response) {
            return new ListProductsInProductSetPage(context, response);
        }

        public ApiFuture<ListProductsInProductSetPage> createPageAsync(PageContext<ListProductsInProductSetRequest, ListProductsInProductSetResponse, Product> context, ApiFuture<ListProductsInProductSetResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListProductsInProductSetPagedResponse
    extends AbstractPagedListResponse<ListProductsInProductSetRequest, ListProductsInProductSetResponse, Product, ListProductsInProductSetPage, ListProductsInProductSetFixedSizeCollection> {
        public static ApiFuture<ListProductsInProductSetPagedResponse> createAsync(PageContext<ListProductsInProductSetRequest, ListProductsInProductSetResponse, Product> context, ApiFuture<ListProductsInProductSetResponse> futureResponse) {
            ApiFuture<ListProductsInProductSetPage> futurePage = ListProductsInProductSetPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, (ApiFunction)new ApiFunction<ListProductsInProductSetPage, ListProductsInProductSetPagedResponse>(){

                public ListProductsInProductSetPagedResponse apply(ListProductsInProductSetPage input) {
                    return new ListProductsInProductSetPagedResponse(input);
                }
            });
        }

        private ListProductsInProductSetPagedResponse(ListProductsInProductSetPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListProductsInProductSetFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListProductSetsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListProductSetsRequest, ListProductSetsResponse, ProductSet, ListProductSetsPage, ListProductSetsFixedSizeCollection> {
        private ListProductSetsFixedSizeCollection(List<ListProductSetsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListProductSetsFixedSizeCollection createEmptyCollection() {
            return new ListProductSetsFixedSizeCollection(null, 0);
        }

        protected ListProductSetsFixedSizeCollection createCollection(List<ListProductSetsPage> pages, int collectionSize) {
            return new ListProductSetsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListProductSetsPage
    extends AbstractPage<ListProductSetsRequest, ListProductSetsResponse, ProductSet, ListProductSetsPage> {
        private ListProductSetsPage(PageContext<ListProductSetsRequest, ListProductSetsResponse, ProductSet> context, ListProductSetsResponse response) {
            super(context, (Object)response);
        }

        private static ListProductSetsPage createEmptyPage() {
            return new ListProductSetsPage(null, null);
        }

        protected ListProductSetsPage createPage(PageContext<ListProductSetsRequest, ListProductSetsResponse, ProductSet> context, ListProductSetsResponse response) {
            return new ListProductSetsPage(context, response);
        }

        public ApiFuture<ListProductSetsPage> createPageAsync(PageContext<ListProductSetsRequest, ListProductSetsResponse, ProductSet> context, ApiFuture<ListProductSetsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListProductSetsPagedResponse
    extends AbstractPagedListResponse<ListProductSetsRequest, ListProductSetsResponse, ProductSet, ListProductSetsPage, ListProductSetsFixedSizeCollection> {
        public static ApiFuture<ListProductSetsPagedResponse> createAsync(PageContext<ListProductSetsRequest, ListProductSetsResponse, ProductSet> context, ApiFuture<ListProductSetsResponse> futureResponse) {
            ApiFuture<ListProductSetsPage> futurePage = ListProductSetsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, (ApiFunction)new ApiFunction<ListProductSetsPage, ListProductSetsPagedResponse>(){

                public ListProductSetsPagedResponse apply(ListProductSetsPage input) {
                    return new ListProductSetsPagedResponse(input);
                }
            });
        }

        private ListProductSetsPagedResponse(ListProductSetsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListProductSetsFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListReferenceImagesFixedSizeCollection
    extends AbstractFixedSizeCollection<ListReferenceImagesRequest, ListReferenceImagesResponse, ReferenceImage, ListReferenceImagesPage, ListReferenceImagesFixedSizeCollection> {
        private ListReferenceImagesFixedSizeCollection(List<ListReferenceImagesPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListReferenceImagesFixedSizeCollection createEmptyCollection() {
            return new ListReferenceImagesFixedSizeCollection(null, 0);
        }

        protected ListReferenceImagesFixedSizeCollection createCollection(List<ListReferenceImagesPage> pages, int collectionSize) {
            return new ListReferenceImagesFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListReferenceImagesPage
    extends AbstractPage<ListReferenceImagesRequest, ListReferenceImagesResponse, ReferenceImage, ListReferenceImagesPage> {
        private ListReferenceImagesPage(PageContext<ListReferenceImagesRequest, ListReferenceImagesResponse, ReferenceImage> context, ListReferenceImagesResponse response) {
            super(context, (Object)response);
        }

        private static ListReferenceImagesPage createEmptyPage() {
            return new ListReferenceImagesPage(null, null);
        }

        protected ListReferenceImagesPage createPage(PageContext<ListReferenceImagesRequest, ListReferenceImagesResponse, ReferenceImage> context, ListReferenceImagesResponse response) {
            return new ListReferenceImagesPage(context, response);
        }

        public ApiFuture<ListReferenceImagesPage> createPageAsync(PageContext<ListReferenceImagesRequest, ListReferenceImagesResponse, ReferenceImage> context, ApiFuture<ListReferenceImagesResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListReferenceImagesPagedResponse
    extends AbstractPagedListResponse<ListReferenceImagesRequest, ListReferenceImagesResponse, ReferenceImage, ListReferenceImagesPage, ListReferenceImagesFixedSizeCollection> {
        public static ApiFuture<ListReferenceImagesPagedResponse> createAsync(PageContext<ListReferenceImagesRequest, ListReferenceImagesResponse, ReferenceImage> context, ApiFuture<ListReferenceImagesResponse> futureResponse) {
            ApiFuture<ListReferenceImagesPage> futurePage = ListReferenceImagesPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, (ApiFunction)new ApiFunction<ListReferenceImagesPage, ListReferenceImagesPagedResponse>(){

                public ListReferenceImagesPagedResponse apply(ListReferenceImagesPage input) {
                    return new ListReferenceImagesPagedResponse(input);
                }
            });
        }

        private ListReferenceImagesPagedResponse(ListReferenceImagesPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListReferenceImagesFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListProductsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListProductsRequest, ListProductsResponse, Product, ListProductsPage, ListProductsFixedSizeCollection> {
        private ListProductsFixedSizeCollection(List<ListProductsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListProductsFixedSizeCollection createEmptyCollection() {
            return new ListProductsFixedSizeCollection(null, 0);
        }

        protected ListProductsFixedSizeCollection createCollection(List<ListProductsPage> pages, int collectionSize) {
            return new ListProductsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListProductsPage
    extends AbstractPage<ListProductsRequest, ListProductsResponse, Product, ListProductsPage> {
        private ListProductsPage(PageContext<ListProductsRequest, ListProductsResponse, Product> context, ListProductsResponse response) {
            super(context, (Object)response);
        }

        private static ListProductsPage createEmptyPage() {
            return new ListProductsPage(null, null);
        }

        protected ListProductsPage createPage(PageContext<ListProductsRequest, ListProductsResponse, Product> context, ListProductsResponse response) {
            return new ListProductsPage(context, response);
        }

        public ApiFuture<ListProductsPage> createPageAsync(PageContext<ListProductsRequest, ListProductsResponse, Product> context, ApiFuture<ListProductsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListProductsPagedResponse
    extends AbstractPagedListResponse<ListProductsRequest, ListProductsResponse, Product, ListProductsPage, ListProductsFixedSizeCollection> {
        public static ApiFuture<ListProductsPagedResponse> createAsync(PageContext<ListProductsRequest, ListProductsResponse, Product> context, ApiFuture<ListProductsResponse> futureResponse) {
            ApiFuture<ListProductsPage> futurePage = ListProductsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, (ApiFunction)new ApiFunction<ListProductsPage, ListProductsPagedResponse>(){

                public ListProductsPagedResponse apply(ListProductsPage input) {
                    return new ListProductsPagedResponse(input);
                }
            });
        }

        private ListProductsPagedResponse(ListProductsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListProductsFixedSizeCollection.createEmptyCollection());
        }
    }
}

