/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.vision.v1.stub;

import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.core.BackgroundResourceAggregation;
import com.google.api.gax.grpc.GrpcCallSettings;
import com.google.api.gax.grpc.GrpcStubCallableFactory;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.OperationCallable;
import com.google.api.gax.rpc.RequestParamsExtractor;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.vision.v1.AddProductToProductSetRequest;
import com.google.cloud.vision.v1.BatchOperationMetadata;
import com.google.cloud.vision.v1.CreateProductRequest;
import com.google.cloud.vision.v1.CreateProductSetRequest;
import com.google.cloud.vision.v1.CreateReferenceImageRequest;
import com.google.cloud.vision.v1.DeleteProductRequest;
import com.google.cloud.vision.v1.DeleteProductSetRequest;
import com.google.cloud.vision.v1.DeleteReferenceImageRequest;
import com.google.cloud.vision.v1.GetProductRequest;
import com.google.cloud.vision.v1.GetProductSetRequest;
import com.google.cloud.vision.v1.GetReferenceImageRequest;
import com.google.cloud.vision.v1.ImportProductSetsRequest;
import com.google.cloud.vision.v1.ImportProductSetsResponse;
import com.google.cloud.vision.v1.ListProductSetsRequest;
import com.google.cloud.vision.v1.ListProductSetsResponse;
import com.google.cloud.vision.v1.ListProductsInProductSetRequest;
import com.google.cloud.vision.v1.ListProductsInProductSetResponse;
import com.google.cloud.vision.v1.ListProductsRequest;
import com.google.cloud.vision.v1.ListProductsResponse;
import com.google.cloud.vision.v1.ListReferenceImagesRequest;
import com.google.cloud.vision.v1.ListReferenceImagesResponse;
import com.google.cloud.vision.v1.Product;
import com.google.cloud.vision.v1.ProductSearchClient;
import com.google.cloud.vision.v1.ProductSet;
import com.google.cloud.vision.v1.PurgeProductsRequest;
import com.google.cloud.vision.v1.ReferenceImage;
import com.google.cloud.vision.v1.RemoveProductFromProductSetRequest;
import com.google.cloud.vision.v1.UpdateProductRequest;
import com.google.cloud.vision.v1.UpdateProductSetRequest;
import com.google.cloud.vision.v1.stub.GrpcProductSearchCallableFactory;
import com.google.cloud.vision.v1.stub.ProductSearchStub;
import com.google.cloud.vision.v1.stub.ProductSearchStubSettings;
import com.google.common.collect.ImmutableMap;
import com.google.longrunning.Operation;
import com.google.longrunning.stub.GrpcOperationsStub;
import com.google.longrunning.stub.OperationsStub;
import com.google.protobuf.Empty;
import com.google.protobuf.Message;
import io.grpc.MethodDescriptor;
import io.grpc.protobuf.ProtoUtils;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.TimeUnit;

public class GrpcProductSearchStub
extends ProductSearchStub {
    private static final MethodDescriptor<CreateProductSetRequest, ProductSet> createProductSetMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.vision.v1.ProductSearch/CreateProductSet").setRequestMarshaller(ProtoUtils.marshaller((Message)CreateProductSetRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)ProductSet.getDefaultInstance())).build();
    private static final MethodDescriptor<ListProductSetsRequest, ListProductSetsResponse> listProductSetsMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.vision.v1.ProductSearch/ListProductSets").setRequestMarshaller(ProtoUtils.marshaller((Message)ListProductSetsRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)ListProductSetsResponse.getDefaultInstance())).build();
    private static final MethodDescriptor<GetProductSetRequest, ProductSet> getProductSetMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.vision.v1.ProductSearch/GetProductSet").setRequestMarshaller(ProtoUtils.marshaller((Message)GetProductSetRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)ProductSet.getDefaultInstance())).build();
    private static final MethodDescriptor<UpdateProductSetRequest, ProductSet> updateProductSetMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.vision.v1.ProductSearch/UpdateProductSet").setRequestMarshaller(ProtoUtils.marshaller((Message)UpdateProductSetRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)ProductSet.getDefaultInstance())).build();
    private static final MethodDescriptor<DeleteProductSetRequest, Empty> deleteProductSetMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.vision.v1.ProductSearch/DeleteProductSet").setRequestMarshaller(ProtoUtils.marshaller((Message)DeleteProductSetRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Empty.getDefaultInstance())).build();
    private static final MethodDescriptor<CreateProductRequest, Product> createProductMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.vision.v1.ProductSearch/CreateProduct").setRequestMarshaller(ProtoUtils.marshaller((Message)CreateProductRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Product.getDefaultInstance())).build();
    private static final MethodDescriptor<ListProductsRequest, ListProductsResponse> listProductsMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.vision.v1.ProductSearch/ListProducts").setRequestMarshaller(ProtoUtils.marshaller((Message)ListProductsRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)ListProductsResponse.getDefaultInstance())).build();
    private static final MethodDescriptor<GetProductRequest, Product> getProductMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.vision.v1.ProductSearch/GetProduct").setRequestMarshaller(ProtoUtils.marshaller((Message)GetProductRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Product.getDefaultInstance())).build();
    private static final MethodDescriptor<UpdateProductRequest, Product> updateProductMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.vision.v1.ProductSearch/UpdateProduct").setRequestMarshaller(ProtoUtils.marshaller((Message)UpdateProductRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Product.getDefaultInstance())).build();
    private static final MethodDescriptor<DeleteProductRequest, Empty> deleteProductMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.vision.v1.ProductSearch/DeleteProduct").setRequestMarshaller(ProtoUtils.marshaller((Message)DeleteProductRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Empty.getDefaultInstance())).build();
    private static final MethodDescriptor<CreateReferenceImageRequest, ReferenceImage> createReferenceImageMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.vision.v1.ProductSearch/CreateReferenceImage").setRequestMarshaller(ProtoUtils.marshaller((Message)CreateReferenceImageRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)ReferenceImage.getDefaultInstance())).build();
    private static final MethodDescriptor<DeleteReferenceImageRequest, Empty> deleteReferenceImageMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.vision.v1.ProductSearch/DeleteReferenceImage").setRequestMarshaller(ProtoUtils.marshaller((Message)DeleteReferenceImageRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Empty.getDefaultInstance())).build();
    private static final MethodDescriptor<ListReferenceImagesRequest, ListReferenceImagesResponse> listReferenceImagesMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.vision.v1.ProductSearch/ListReferenceImages").setRequestMarshaller(ProtoUtils.marshaller((Message)ListReferenceImagesRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)ListReferenceImagesResponse.getDefaultInstance())).build();
    private static final MethodDescriptor<GetReferenceImageRequest, ReferenceImage> getReferenceImageMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.vision.v1.ProductSearch/GetReferenceImage").setRequestMarshaller(ProtoUtils.marshaller((Message)GetReferenceImageRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)ReferenceImage.getDefaultInstance())).build();
    private static final MethodDescriptor<AddProductToProductSetRequest, Empty> addProductToProductSetMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.vision.v1.ProductSearch/AddProductToProductSet").setRequestMarshaller(ProtoUtils.marshaller((Message)AddProductToProductSetRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Empty.getDefaultInstance())).build();
    private static final MethodDescriptor<RemoveProductFromProductSetRequest, Empty> removeProductFromProductSetMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.vision.v1.ProductSearch/RemoveProductFromProductSet").setRequestMarshaller(ProtoUtils.marshaller((Message)RemoveProductFromProductSetRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Empty.getDefaultInstance())).build();
    private static final MethodDescriptor<ListProductsInProductSetRequest, ListProductsInProductSetResponse> listProductsInProductSetMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.vision.v1.ProductSearch/ListProductsInProductSet").setRequestMarshaller(ProtoUtils.marshaller((Message)ListProductsInProductSetRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)ListProductsInProductSetResponse.getDefaultInstance())).build();
    private static final MethodDescriptor<ImportProductSetsRequest, Operation> importProductSetsMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.vision.v1.ProductSearch/ImportProductSets").setRequestMarshaller(ProtoUtils.marshaller((Message)ImportProductSetsRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Operation.getDefaultInstance())).build();
    private static final MethodDescriptor<PurgeProductsRequest, Operation> purgeProductsMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.vision.v1.ProductSearch/PurgeProducts").setRequestMarshaller(ProtoUtils.marshaller((Message)PurgeProductsRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Operation.getDefaultInstance())).build();
    private final UnaryCallable<CreateProductSetRequest, ProductSet> createProductSetCallable;
    private final UnaryCallable<ListProductSetsRequest, ListProductSetsResponse> listProductSetsCallable;
    private final UnaryCallable<ListProductSetsRequest, ProductSearchClient.ListProductSetsPagedResponse> listProductSetsPagedCallable;
    private final UnaryCallable<GetProductSetRequest, ProductSet> getProductSetCallable;
    private final UnaryCallable<UpdateProductSetRequest, ProductSet> updateProductSetCallable;
    private final UnaryCallable<DeleteProductSetRequest, Empty> deleteProductSetCallable;
    private final UnaryCallable<CreateProductRequest, Product> createProductCallable;
    private final UnaryCallable<ListProductsRequest, ListProductsResponse> listProductsCallable;
    private final UnaryCallable<ListProductsRequest, ProductSearchClient.ListProductsPagedResponse> listProductsPagedCallable;
    private final UnaryCallable<GetProductRequest, Product> getProductCallable;
    private final UnaryCallable<UpdateProductRequest, Product> updateProductCallable;
    private final UnaryCallable<DeleteProductRequest, Empty> deleteProductCallable;
    private final UnaryCallable<CreateReferenceImageRequest, ReferenceImage> createReferenceImageCallable;
    private final UnaryCallable<DeleteReferenceImageRequest, Empty> deleteReferenceImageCallable;
    private final UnaryCallable<ListReferenceImagesRequest, ListReferenceImagesResponse> listReferenceImagesCallable;
    private final UnaryCallable<ListReferenceImagesRequest, ProductSearchClient.ListReferenceImagesPagedResponse> listReferenceImagesPagedCallable;
    private final UnaryCallable<GetReferenceImageRequest, ReferenceImage> getReferenceImageCallable;
    private final UnaryCallable<AddProductToProductSetRequest, Empty> addProductToProductSetCallable;
    private final UnaryCallable<RemoveProductFromProductSetRequest, Empty> removeProductFromProductSetCallable;
    private final UnaryCallable<ListProductsInProductSetRequest, ListProductsInProductSetResponse> listProductsInProductSetCallable;
    private final UnaryCallable<ListProductsInProductSetRequest, ProductSearchClient.ListProductsInProductSetPagedResponse> listProductsInProductSetPagedCallable;
    private final UnaryCallable<ImportProductSetsRequest, Operation> importProductSetsCallable;
    private final OperationCallable<ImportProductSetsRequest, ImportProductSetsResponse, BatchOperationMetadata> importProductSetsOperationCallable;
    private final UnaryCallable<PurgeProductsRequest, Operation> purgeProductsCallable;
    private final OperationCallable<PurgeProductsRequest, Empty, BatchOperationMetadata> purgeProductsOperationCallable;
    private final BackgroundResource backgroundResources;
    private final GrpcOperationsStub operationsStub;
    private final GrpcStubCallableFactory callableFactory;

    public static final GrpcProductSearchStub create(ProductSearchStubSettings settings) throws IOException {
        return new GrpcProductSearchStub(settings, ClientContext.create((StubSettings)settings));
    }

    public static final GrpcProductSearchStub create(ClientContext clientContext) throws IOException {
        return new GrpcProductSearchStub(ProductSearchStubSettings.newBuilder().build(), clientContext);
    }

    public static final GrpcProductSearchStub create(ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        return new GrpcProductSearchStub(ProductSearchStubSettings.newBuilder().build(), clientContext, callableFactory);
    }

    protected GrpcProductSearchStub(ProductSearchStubSettings settings, ClientContext clientContext) throws IOException {
        this(settings, clientContext, new GrpcProductSearchCallableFactory());
    }

    protected GrpcProductSearchStub(ProductSearchStubSettings settings, ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        this.callableFactory = callableFactory;
        this.operationsStub = GrpcOperationsStub.create((ClientContext)clientContext, (GrpcStubCallableFactory)callableFactory);
        GrpcCallSettings createProductSetTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(createProductSetMethodDescriptor).setParamsExtractor((RequestParamsExtractor)new RequestParamsExtractor<CreateProductSetRequest>(){

            public Map<String, String> extract(CreateProductSetRequest request) {
                ImmutableMap.Builder params = ImmutableMap.builder();
                params.put((Object)"parent", (Object)String.valueOf(request.getParent()));
                return params.build();
            }
        }).build();
        GrpcCallSettings listProductSetsTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(listProductSetsMethodDescriptor).setParamsExtractor((RequestParamsExtractor)new RequestParamsExtractor<ListProductSetsRequest>(){

            public Map<String, String> extract(ListProductSetsRequest request) {
                ImmutableMap.Builder params = ImmutableMap.builder();
                params.put((Object)"parent", (Object)String.valueOf(request.getParent()));
                return params.build();
            }
        }).build();
        GrpcCallSettings getProductSetTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(getProductSetMethodDescriptor).setParamsExtractor((RequestParamsExtractor)new RequestParamsExtractor<GetProductSetRequest>(){

            public Map<String, String> extract(GetProductSetRequest request) {
                ImmutableMap.Builder params = ImmutableMap.builder();
                params.put((Object)"name", (Object)String.valueOf(request.getName()));
                return params.build();
            }
        }).build();
        GrpcCallSettings updateProductSetTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(updateProductSetMethodDescriptor).setParamsExtractor((RequestParamsExtractor)new RequestParamsExtractor<UpdateProductSetRequest>(){

            public Map<String, String> extract(UpdateProductSetRequest request) {
                ImmutableMap.Builder params = ImmutableMap.builder();
                params.put((Object)"product_set.name", (Object)String.valueOf(request.getProductSet().getName()));
                return params.build();
            }
        }).build();
        GrpcCallSettings deleteProductSetTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(deleteProductSetMethodDescriptor).setParamsExtractor((RequestParamsExtractor)new RequestParamsExtractor<DeleteProductSetRequest>(){

            public Map<String, String> extract(DeleteProductSetRequest request) {
                ImmutableMap.Builder params = ImmutableMap.builder();
                params.put((Object)"name", (Object)String.valueOf(request.getName()));
                return params.build();
            }
        }).build();
        GrpcCallSettings createProductTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(createProductMethodDescriptor).setParamsExtractor((RequestParamsExtractor)new RequestParamsExtractor<CreateProductRequest>(){

            public Map<String, String> extract(CreateProductRequest request) {
                ImmutableMap.Builder params = ImmutableMap.builder();
                params.put((Object)"parent", (Object)String.valueOf(request.getParent()));
                return params.build();
            }
        }).build();
        GrpcCallSettings listProductsTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(listProductsMethodDescriptor).setParamsExtractor((RequestParamsExtractor)new RequestParamsExtractor<ListProductsRequest>(){

            public Map<String, String> extract(ListProductsRequest request) {
                ImmutableMap.Builder params = ImmutableMap.builder();
                params.put((Object)"parent", (Object)String.valueOf(request.getParent()));
                return params.build();
            }
        }).build();
        GrpcCallSettings getProductTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(getProductMethodDescriptor).setParamsExtractor((RequestParamsExtractor)new RequestParamsExtractor<GetProductRequest>(){

            public Map<String, String> extract(GetProductRequest request) {
                ImmutableMap.Builder params = ImmutableMap.builder();
                params.put((Object)"name", (Object)String.valueOf(request.getName()));
                return params.build();
            }
        }).build();
        GrpcCallSettings updateProductTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(updateProductMethodDescriptor).setParamsExtractor((RequestParamsExtractor)new RequestParamsExtractor<UpdateProductRequest>(){

            public Map<String, String> extract(UpdateProductRequest request) {
                ImmutableMap.Builder params = ImmutableMap.builder();
                params.put((Object)"product.name", (Object)String.valueOf(request.getProduct().getName()));
                return params.build();
            }
        }).build();
        GrpcCallSettings deleteProductTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(deleteProductMethodDescriptor).setParamsExtractor((RequestParamsExtractor)new RequestParamsExtractor<DeleteProductRequest>(){

            public Map<String, String> extract(DeleteProductRequest request) {
                ImmutableMap.Builder params = ImmutableMap.builder();
                params.put((Object)"name", (Object)String.valueOf(request.getName()));
                return params.build();
            }
        }).build();
        GrpcCallSettings createReferenceImageTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(createReferenceImageMethodDescriptor).setParamsExtractor((RequestParamsExtractor)new RequestParamsExtractor<CreateReferenceImageRequest>(){

            public Map<String, String> extract(CreateReferenceImageRequest request) {
                ImmutableMap.Builder params = ImmutableMap.builder();
                params.put((Object)"parent", (Object)String.valueOf(request.getParent()));
                return params.build();
            }
        }).build();
        GrpcCallSettings deleteReferenceImageTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(deleteReferenceImageMethodDescriptor).setParamsExtractor((RequestParamsExtractor)new RequestParamsExtractor<DeleteReferenceImageRequest>(){

            public Map<String, String> extract(DeleteReferenceImageRequest request) {
                ImmutableMap.Builder params = ImmutableMap.builder();
                params.put((Object)"name", (Object)String.valueOf(request.getName()));
                return params.build();
            }
        }).build();
        GrpcCallSettings listReferenceImagesTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(listReferenceImagesMethodDescriptor).setParamsExtractor((RequestParamsExtractor)new RequestParamsExtractor<ListReferenceImagesRequest>(){

            public Map<String, String> extract(ListReferenceImagesRequest request) {
                ImmutableMap.Builder params = ImmutableMap.builder();
                params.put((Object)"parent", (Object)String.valueOf(request.getParent()));
                return params.build();
            }
        }).build();
        GrpcCallSettings getReferenceImageTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(getReferenceImageMethodDescriptor).setParamsExtractor((RequestParamsExtractor)new RequestParamsExtractor<GetReferenceImageRequest>(){

            public Map<String, String> extract(GetReferenceImageRequest request) {
                ImmutableMap.Builder params = ImmutableMap.builder();
                params.put((Object)"name", (Object)String.valueOf(request.getName()));
                return params.build();
            }
        }).build();
        GrpcCallSettings addProductToProductSetTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(addProductToProductSetMethodDescriptor).setParamsExtractor((RequestParamsExtractor)new RequestParamsExtractor<AddProductToProductSetRequest>(){

            public Map<String, String> extract(AddProductToProductSetRequest request) {
                ImmutableMap.Builder params = ImmutableMap.builder();
                params.put((Object)"name", (Object)String.valueOf(request.getName()));
                return params.build();
            }
        }).build();
        GrpcCallSettings removeProductFromProductSetTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(removeProductFromProductSetMethodDescriptor).setParamsExtractor((RequestParamsExtractor)new RequestParamsExtractor<RemoveProductFromProductSetRequest>(){

            public Map<String, String> extract(RemoveProductFromProductSetRequest request) {
                ImmutableMap.Builder params = ImmutableMap.builder();
                params.put((Object)"name", (Object)String.valueOf(request.getName()));
                return params.build();
            }
        }).build();
        GrpcCallSettings listProductsInProductSetTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(listProductsInProductSetMethodDescriptor).setParamsExtractor((RequestParamsExtractor)new RequestParamsExtractor<ListProductsInProductSetRequest>(){

            public Map<String, String> extract(ListProductsInProductSetRequest request) {
                ImmutableMap.Builder params = ImmutableMap.builder();
                params.put((Object)"name", (Object)String.valueOf(request.getName()));
                return params.build();
            }
        }).build();
        GrpcCallSettings importProductSetsTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(importProductSetsMethodDescriptor).setParamsExtractor((RequestParamsExtractor)new RequestParamsExtractor<ImportProductSetsRequest>(){

            public Map<String, String> extract(ImportProductSetsRequest request) {
                ImmutableMap.Builder params = ImmutableMap.builder();
                params.put((Object)"parent", (Object)String.valueOf(request.getParent()));
                return params.build();
            }
        }).build();
        GrpcCallSettings purgeProductsTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(purgeProductsMethodDescriptor).setParamsExtractor((RequestParamsExtractor)new RequestParamsExtractor<PurgeProductsRequest>(){

            public Map<String, String> extract(PurgeProductsRequest request) {
                ImmutableMap.Builder params = ImmutableMap.builder();
                params.put((Object)"parent", (Object)String.valueOf(request.getParent()));
                return params.build();
            }
        }).build();
        this.createProductSetCallable = callableFactory.createUnaryCallable(createProductSetTransportSettings, settings.createProductSetSettings(), clientContext);
        this.listProductSetsCallable = callableFactory.createUnaryCallable(listProductSetsTransportSettings, settings.listProductSetsSettings(), clientContext);
        this.listProductSetsPagedCallable = callableFactory.createPagedCallable(listProductSetsTransportSettings, settings.listProductSetsSettings(), clientContext);
        this.getProductSetCallable = callableFactory.createUnaryCallable(getProductSetTransportSettings, settings.getProductSetSettings(), clientContext);
        this.updateProductSetCallable = callableFactory.createUnaryCallable(updateProductSetTransportSettings, settings.updateProductSetSettings(), clientContext);
        this.deleteProductSetCallable = callableFactory.createUnaryCallable(deleteProductSetTransportSettings, settings.deleteProductSetSettings(), clientContext);
        this.createProductCallable = callableFactory.createUnaryCallable(createProductTransportSettings, settings.createProductSettings(), clientContext);
        this.listProductsCallable = callableFactory.createUnaryCallable(listProductsTransportSettings, settings.listProductsSettings(), clientContext);
        this.listProductsPagedCallable = callableFactory.createPagedCallable(listProductsTransportSettings, settings.listProductsSettings(), clientContext);
        this.getProductCallable = callableFactory.createUnaryCallable(getProductTransportSettings, settings.getProductSettings(), clientContext);
        this.updateProductCallable = callableFactory.createUnaryCallable(updateProductTransportSettings, settings.updateProductSettings(), clientContext);
        this.deleteProductCallable = callableFactory.createUnaryCallable(deleteProductTransportSettings, settings.deleteProductSettings(), clientContext);
        this.createReferenceImageCallable = callableFactory.createUnaryCallable(createReferenceImageTransportSettings, settings.createReferenceImageSettings(), clientContext);
        this.deleteReferenceImageCallable = callableFactory.createUnaryCallable(deleteReferenceImageTransportSettings, settings.deleteReferenceImageSettings(), clientContext);
        this.listReferenceImagesCallable = callableFactory.createUnaryCallable(listReferenceImagesTransportSettings, settings.listReferenceImagesSettings(), clientContext);
        this.listReferenceImagesPagedCallable = callableFactory.createPagedCallable(listReferenceImagesTransportSettings, settings.listReferenceImagesSettings(), clientContext);
        this.getReferenceImageCallable = callableFactory.createUnaryCallable(getReferenceImageTransportSettings, settings.getReferenceImageSettings(), clientContext);
        this.addProductToProductSetCallable = callableFactory.createUnaryCallable(addProductToProductSetTransportSettings, settings.addProductToProductSetSettings(), clientContext);
        this.removeProductFromProductSetCallable = callableFactory.createUnaryCallable(removeProductFromProductSetTransportSettings, settings.removeProductFromProductSetSettings(), clientContext);
        this.listProductsInProductSetCallable = callableFactory.createUnaryCallable(listProductsInProductSetTransportSettings, settings.listProductsInProductSetSettings(), clientContext);
        this.listProductsInProductSetPagedCallable = callableFactory.createPagedCallable(listProductsInProductSetTransportSettings, settings.listProductsInProductSetSettings(), clientContext);
        this.importProductSetsCallable = callableFactory.createUnaryCallable(importProductSetsTransportSettings, settings.importProductSetsSettings(), clientContext);
        this.importProductSetsOperationCallable = callableFactory.createOperationCallable(importProductSetsTransportSettings, settings.importProductSetsOperationSettings(), clientContext, (OperationsStub)this.operationsStub);
        this.purgeProductsCallable = callableFactory.createUnaryCallable(purgeProductsTransportSettings, settings.purgeProductsSettings(), clientContext);
        this.purgeProductsOperationCallable = callableFactory.createOperationCallable(purgeProductsTransportSettings, settings.purgeProductsOperationSettings(), clientContext, (OperationsStub)this.operationsStub);
        this.backgroundResources = new BackgroundResourceAggregation(clientContext.getBackgroundResources());
    }

    public GrpcOperationsStub getOperationsStub() {
        return this.operationsStub;
    }

    @Override
    public UnaryCallable<CreateProductSetRequest, ProductSet> createProductSetCallable() {
        return this.createProductSetCallable;
    }

    @Override
    public UnaryCallable<ListProductSetsRequest, ListProductSetsResponse> listProductSetsCallable() {
        return this.listProductSetsCallable;
    }

    @Override
    public UnaryCallable<ListProductSetsRequest, ProductSearchClient.ListProductSetsPagedResponse> listProductSetsPagedCallable() {
        return this.listProductSetsPagedCallable;
    }

    @Override
    public UnaryCallable<GetProductSetRequest, ProductSet> getProductSetCallable() {
        return this.getProductSetCallable;
    }

    @Override
    public UnaryCallable<UpdateProductSetRequest, ProductSet> updateProductSetCallable() {
        return this.updateProductSetCallable;
    }

    @Override
    public UnaryCallable<DeleteProductSetRequest, Empty> deleteProductSetCallable() {
        return this.deleteProductSetCallable;
    }

    @Override
    public UnaryCallable<CreateProductRequest, Product> createProductCallable() {
        return this.createProductCallable;
    }

    @Override
    public UnaryCallable<ListProductsRequest, ListProductsResponse> listProductsCallable() {
        return this.listProductsCallable;
    }

    @Override
    public UnaryCallable<ListProductsRequest, ProductSearchClient.ListProductsPagedResponse> listProductsPagedCallable() {
        return this.listProductsPagedCallable;
    }

    @Override
    public UnaryCallable<GetProductRequest, Product> getProductCallable() {
        return this.getProductCallable;
    }

    @Override
    public UnaryCallable<UpdateProductRequest, Product> updateProductCallable() {
        return this.updateProductCallable;
    }

    @Override
    public UnaryCallable<DeleteProductRequest, Empty> deleteProductCallable() {
        return this.deleteProductCallable;
    }

    @Override
    public UnaryCallable<CreateReferenceImageRequest, ReferenceImage> createReferenceImageCallable() {
        return this.createReferenceImageCallable;
    }

    @Override
    public UnaryCallable<DeleteReferenceImageRequest, Empty> deleteReferenceImageCallable() {
        return this.deleteReferenceImageCallable;
    }

    @Override
    public UnaryCallable<ListReferenceImagesRequest, ListReferenceImagesResponse> listReferenceImagesCallable() {
        return this.listReferenceImagesCallable;
    }

    @Override
    public UnaryCallable<ListReferenceImagesRequest, ProductSearchClient.ListReferenceImagesPagedResponse> listReferenceImagesPagedCallable() {
        return this.listReferenceImagesPagedCallable;
    }

    @Override
    public UnaryCallable<GetReferenceImageRequest, ReferenceImage> getReferenceImageCallable() {
        return this.getReferenceImageCallable;
    }

    @Override
    public UnaryCallable<AddProductToProductSetRequest, Empty> addProductToProductSetCallable() {
        return this.addProductToProductSetCallable;
    }

    @Override
    public UnaryCallable<RemoveProductFromProductSetRequest, Empty> removeProductFromProductSetCallable() {
        return this.removeProductFromProductSetCallable;
    }

    @Override
    public UnaryCallable<ListProductsInProductSetRequest, ListProductsInProductSetResponse> listProductsInProductSetCallable() {
        return this.listProductsInProductSetCallable;
    }

    @Override
    public UnaryCallable<ListProductsInProductSetRequest, ProductSearchClient.ListProductsInProductSetPagedResponse> listProductsInProductSetPagedCallable() {
        return this.listProductsInProductSetPagedCallable;
    }

    @Override
    public UnaryCallable<ImportProductSetsRequest, Operation> importProductSetsCallable() {
        return this.importProductSetsCallable;
    }

    @Override
    public OperationCallable<ImportProductSetsRequest, ImportProductSetsResponse, BatchOperationMetadata> importProductSetsOperationCallable() {
        return this.importProductSetsOperationCallable;
    }

    @Override
    public UnaryCallable<PurgeProductsRequest, Operation> purgeProductsCallable() {
        return this.purgeProductsCallable;
    }

    @Override
    public OperationCallable<PurgeProductsRequest, Empty, BatchOperationMetadata> purgeProductsOperationCallable() {
        return this.purgeProductsOperationCallable;
    }

    @Override
    public final void close() {
        this.shutdown();
    }

    public void shutdown() {
        this.backgroundResources.shutdown();
    }

    public boolean isShutdown() {
        return this.backgroundResources.isShutdown();
    }

    public boolean isTerminated() {
        return this.backgroundResources.isTerminated();
    }

    public void shutdownNow() {
        this.backgroundResources.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.backgroundResources.awaitTermination(duration, unit);
    }
}

