/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.video.transcoder.v1.stub;

import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.core.BackgroundResourceAggregation;
import com.google.api.gax.grpc.GrpcCallSettings;
import com.google.api.gax.grpc.GrpcStubCallableFactory;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.RequestParamsExtractor;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.video.transcoder.v1.CreateJobRequest;
import com.google.cloud.video.transcoder.v1.CreateJobTemplateRequest;
import com.google.cloud.video.transcoder.v1.DeleteJobRequest;
import com.google.cloud.video.transcoder.v1.DeleteJobTemplateRequest;
import com.google.cloud.video.transcoder.v1.GetJobRequest;
import com.google.cloud.video.transcoder.v1.GetJobTemplateRequest;
import com.google.cloud.video.transcoder.v1.Job;
import com.google.cloud.video.transcoder.v1.JobTemplate;
import com.google.cloud.video.transcoder.v1.ListJobTemplatesRequest;
import com.google.cloud.video.transcoder.v1.ListJobTemplatesResponse;
import com.google.cloud.video.transcoder.v1.ListJobsRequest;
import com.google.cloud.video.transcoder.v1.ListJobsResponse;
import com.google.cloud.video.transcoder.v1.TranscoderServiceClient;
import com.google.cloud.video.transcoder.v1.stub.GrpcTranscoderServiceCallableFactory;
import com.google.cloud.video.transcoder.v1.stub.TranscoderServiceStub;
import com.google.cloud.video.transcoder.v1.stub.TranscoderServiceStubSettings;
import com.google.common.collect.ImmutableMap;
import com.google.longrunning.stub.GrpcOperationsStub;
import com.google.protobuf.Empty;
import com.google.protobuf.Message;
import io.grpc.MethodDescriptor;
import io.grpc.protobuf.ProtoUtils;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.TimeUnit;

public class GrpcTranscoderServiceStub
extends TranscoderServiceStub {
    private static final MethodDescriptor<CreateJobRequest, Job> createJobMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.video.transcoder.v1.TranscoderService/CreateJob").setRequestMarshaller(ProtoUtils.marshaller((Message)CreateJobRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Job.getDefaultInstance())).build();
    private static final MethodDescriptor<ListJobsRequest, ListJobsResponse> listJobsMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.video.transcoder.v1.TranscoderService/ListJobs").setRequestMarshaller(ProtoUtils.marshaller((Message)ListJobsRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)ListJobsResponse.getDefaultInstance())).build();
    private static final MethodDescriptor<GetJobRequest, Job> getJobMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.video.transcoder.v1.TranscoderService/GetJob").setRequestMarshaller(ProtoUtils.marshaller((Message)GetJobRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Job.getDefaultInstance())).build();
    private static final MethodDescriptor<DeleteJobRequest, Empty> deleteJobMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.video.transcoder.v1.TranscoderService/DeleteJob").setRequestMarshaller(ProtoUtils.marshaller((Message)DeleteJobRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Empty.getDefaultInstance())).build();
    private static final MethodDescriptor<CreateJobTemplateRequest, JobTemplate> createJobTemplateMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.video.transcoder.v1.TranscoderService/CreateJobTemplate").setRequestMarshaller(ProtoUtils.marshaller((Message)CreateJobTemplateRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)JobTemplate.getDefaultInstance())).build();
    private static final MethodDescriptor<ListJobTemplatesRequest, ListJobTemplatesResponse> listJobTemplatesMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.video.transcoder.v1.TranscoderService/ListJobTemplates").setRequestMarshaller(ProtoUtils.marshaller((Message)ListJobTemplatesRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)ListJobTemplatesResponse.getDefaultInstance())).build();
    private static final MethodDescriptor<GetJobTemplateRequest, JobTemplate> getJobTemplateMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.video.transcoder.v1.TranscoderService/GetJobTemplate").setRequestMarshaller(ProtoUtils.marshaller((Message)GetJobTemplateRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)JobTemplate.getDefaultInstance())).build();
    private static final MethodDescriptor<DeleteJobTemplateRequest, Empty> deleteJobTemplateMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.video.transcoder.v1.TranscoderService/DeleteJobTemplate").setRequestMarshaller(ProtoUtils.marshaller((Message)DeleteJobTemplateRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Empty.getDefaultInstance())).build();
    private final UnaryCallable<CreateJobRequest, Job> createJobCallable;
    private final UnaryCallable<ListJobsRequest, ListJobsResponse> listJobsCallable;
    private final UnaryCallable<ListJobsRequest, TranscoderServiceClient.ListJobsPagedResponse> listJobsPagedCallable;
    private final UnaryCallable<GetJobRequest, Job> getJobCallable;
    private final UnaryCallable<DeleteJobRequest, Empty> deleteJobCallable;
    private final UnaryCallable<CreateJobTemplateRequest, JobTemplate> createJobTemplateCallable;
    private final UnaryCallable<ListJobTemplatesRequest, ListJobTemplatesResponse> listJobTemplatesCallable;
    private final UnaryCallable<ListJobTemplatesRequest, TranscoderServiceClient.ListJobTemplatesPagedResponse> listJobTemplatesPagedCallable;
    private final UnaryCallable<GetJobTemplateRequest, JobTemplate> getJobTemplateCallable;
    private final UnaryCallable<DeleteJobTemplateRequest, Empty> deleteJobTemplateCallable;
    private final BackgroundResource backgroundResources;
    private final GrpcOperationsStub operationsStub;
    private final GrpcStubCallableFactory callableFactory;

    public static final GrpcTranscoderServiceStub create(TranscoderServiceStubSettings settings) throws IOException {
        return new GrpcTranscoderServiceStub(settings, ClientContext.create((StubSettings)settings));
    }

    public static final GrpcTranscoderServiceStub create(ClientContext clientContext) throws IOException {
        return new GrpcTranscoderServiceStub(TranscoderServiceStubSettings.newBuilder().build(), clientContext);
    }

    public static final GrpcTranscoderServiceStub create(ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        return new GrpcTranscoderServiceStub(TranscoderServiceStubSettings.newBuilder().build(), clientContext, callableFactory);
    }

    protected GrpcTranscoderServiceStub(TranscoderServiceStubSettings settings, ClientContext clientContext) throws IOException {
        this(settings, clientContext, new GrpcTranscoderServiceCallableFactory());
    }

    protected GrpcTranscoderServiceStub(TranscoderServiceStubSettings settings, ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        this.callableFactory = callableFactory;
        this.operationsStub = GrpcOperationsStub.create((ClientContext)clientContext, (GrpcStubCallableFactory)callableFactory);
        GrpcCallSettings createJobTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(createJobMethodDescriptor).setParamsExtractor((RequestParamsExtractor)new RequestParamsExtractor<CreateJobRequest>(){

            public Map<String, String> extract(CreateJobRequest request) {
                ImmutableMap.Builder params = ImmutableMap.builder();
                params.put((Object)"parent", (Object)String.valueOf(request.getParent()));
                return params.build();
            }
        }).build();
        GrpcCallSettings listJobsTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(listJobsMethodDescriptor).setParamsExtractor((RequestParamsExtractor)new RequestParamsExtractor<ListJobsRequest>(){

            public Map<String, String> extract(ListJobsRequest request) {
                ImmutableMap.Builder params = ImmutableMap.builder();
                params.put((Object)"parent", (Object)String.valueOf(request.getParent()));
                return params.build();
            }
        }).build();
        GrpcCallSettings getJobTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(getJobMethodDescriptor).setParamsExtractor((RequestParamsExtractor)new RequestParamsExtractor<GetJobRequest>(){

            public Map<String, String> extract(GetJobRequest request) {
                ImmutableMap.Builder params = ImmutableMap.builder();
                params.put((Object)"name", (Object)String.valueOf(request.getName()));
                return params.build();
            }
        }).build();
        GrpcCallSettings deleteJobTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(deleteJobMethodDescriptor).setParamsExtractor((RequestParamsExtractor)new RequestParamsExtractor<DeleteJobRequest>(){

            public Map<String, String> extract(DeleteJobRequest request) {
                ImmutableMap.Builder params = ImmutableMap.builder();
                params.put((Object)"name", (Object)String.valueOf(request.getName()));
                return params.build();
            }
        }).build();
        GrpcCallSettings createJobTemplateTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(createJobTemplateMethodDescriptor).setParamsExtractor((RequestParamsExtractor)new RequestParamsExtractor<CreateJobTemplateRequest>(){

            public Map<String, String> extract(CreateJobTemplateRequest request) {
                ImmutableMap.Builder params = ImmutableMap.builder();
                params.put((Object)"parent", (Object)String.valueOf(request.getParent()));
                return params.build();
            }
        }).build();
        GrpcCallSettings listJobTemplatesTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(listJobTemplatesMethodDescriptor).setParamsExtractor((RequestParamsExtractor)new RequestParamsExtractor<ListJobTemplatesRequest>(){

            public Map<String, String> extract(ListJobTemplatesRequest request) {
                ImmutableMap.Builder params = ImmutableMap.builder();
                params.put((Object)"parent", (Object)String.valueOf(request.getParent()));
                return params.build();
            }
        }).build();
        GrpcCallSettings getJobTemplateTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(getJobTemplateMethodDescriptor).setParamsExtractor((RequestParamsExtractor)new RequestParamsExtractor<GetJobTemplateRequest>(){

            public Map<String, String> extract(GetJobTemplateRequest request) {
                ImmutableMap.Builder params = ImmutableMap.builder();
                params.put((Object)"name", (Object)String.valueOf(request.getName()));
                return params.build();
            }
        }).build();
        GrpcCallSettings deleteJobTemplateTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(deleteJobTemplateMethodDescriptor).setParamsExtractor((RequestParamsExtractor)new RequestParamsExtractor<DeleteJobTemplateRequest>(){

            public Map<String, String> extract(DeleteJobTemplateRequest request) {
                ImmutableMap.Builder params = ImmutableMap.builder();
                params.put((Object)"name", (Object)String.valueOf(request.getName()));
                return params.build();
            }
        }).build();
        this.createJobCallable = callableFactory.createUnaryCallable(createJobTransportSettings, settings.createJobSettings(), clientContext);
        this.listJobsCallable = callableFactory.createUnaryCallable(listJobsTransportSettings, settings.listJobsSettings(), clientContext);
        this.listJobsPagedCallable = callableFactory.createPagedCallable(listJobsTransportSettings, settings.listJobsSettings(), clientContext);
        this.getJobCallable = callableFactory.createUnaryCallable(getJobTransportSettings, settings.getJobSettings(), clientContext);
        this.deleteJobCallable = callableFactory.createUnaryCallable(deleteJobTransportSettings, settings.deleteJobSettings(), clientContext);
        this.createJobTemplateCallable = callableFactory.createUnaryCallable(createJobTemplateTransportSettings, settings.createJobTemplateSettings(), clientContext);
        this.listJobTemplatesCallable = callableFactory.createUnaryCallable(listJobTemplatesTransportSettings, settings.listJobTemplatesSettings(), clientContext);
        this.listJobTemplatesPagedCallable = callableFactory.createPagedCallable(listJobTemplatesTransportSettings, settings.listJobTemplatesSettings(), clientContext);
        this.getJobTemplateCallable = callableFactory.createUnaryCallable(getJobTemplateTransportSettings, settings.getJobTemplateSettings(), clientContext);
        this.deleteJobTemplateCallable = callableFactory.createUnaryCallable(deleteJobTemplateTransportSettings, settings.deleteJobTemplateSettings(), clientContext);
        this.backgroundResources = new BackgroundResourceAggregation(clientContext.getBackgroundResources());
    }

    public GrpcOperationsStub getOperationsStub() {
        return this.operationsStub;
    }

    @Override
    public UnaryCallable<CreateJobRequest, Job> createJobCallable() {
        return this.createJobCallable;
    }

    @Override
    public UnaryCallable<ListJobsRequest, ListJobsResponse> listJobsCallable() {
        return this.listJobsCallable;
    }

    @Override
    public UnaryCallable<ListJobsRequest, TranscoderServiceClient.ListJobsPagedResponse> listJobsPagedCallable() {
        return this.listJobsPagedCallable;
    }

    @Override
    public UnaryCallable<GetJobRequest, Job> getJobCallable() {
        return this.getJobCallable;
    }

    @Override
    public UnaryCallable<DeleteJobRequest, Empty> deleteJobCallable() {
        return this.deleteJobCallable;
    }

    @Override
    public UnaryCallable<CreateJobTemplateRequest, JobTemplate> createJobTemplateCallable() {
        return this.createJobTemplateCallable;
    }

    @Override
    public UnaryCallable<ListJobTemplatesRequest, ListJobTemplatesResponse> listJobTemplatesCallable() {
        return this.listJobTemplatesCallable;
    }

    @Override
    public UnaryCallable<ListJobTemplatesRequest, TranscoderServiceClient.ListJobTemplatesPagedResponse> listJobTemplatesPagedCallable() {
        return this.listJobTemplatesPagedCallable;
    }

    @Override
    public UnaryCallable<GetJobTemplateRequest, JobTemplate> getJobTemplateCallable() {
        return this.getJobTemplateCallable;
    }

    @Override
    public UnaryCallable<DeleteJobTemplateRequest, Empty> deleteJobTemplateCallable() {
        return this.deleteJobTemplateCallable;
    }

    @Override
    public final void close() {
        this.shutdown();
    }

    public void shutdown() {
        this.backgroundResources.shutdown();
    }

    public boolean isShutdown() {
        return this.backgroundResources.isShutdown();
    }

    public boolean isTerminated() {
        return this.backgroundResources.isTerminated();
    }

    public void shutdownNow() {
        this.backgroundResources.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.backgroundResources.awaitTermination(duration, unit);
    }
}

