/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.video.stitcher.v1.stub;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.GaxProperties;
import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.api.gax.grpc.GaxGrpcProperties;
import com.google.api.gax.grpc.GrpcTransportChannel;
import com.google.api.gax.grpc.InstantiatingGrpcChannelProvider;
import com.google.api.gax.grpc.ProtoOperationTransformers;
import com.google.api.gax.longrunning.OperationTimedPollAlgorithm;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.retrying.TimedRetryAlgorithm;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.OperationCallSettings;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.PagedCallSettings;
import com.google.api.gax.rpc.PagedListDescriptor;
import com.google.api.gax.rpc.PagedListResponseFactory;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.video.stitcher.v1.CdnKey;
import com.google.cloud.video.stitcher.v1.CreateCdnKeyRequest;
import com.google.cloud.video.stitcher.v1.CreateLiveConfigRequest;
import com.google.cloud.video.stitcher.v1.CreateLiveSessionRequest;
import com.google.cloud.video.stitcher.v1.CreateSlateRequest;
import com.google.cloud.video.stitcher.v1.CreateVodSessionRequest;
import com.google.cloud.video.stitcher.v1.DeleteCdnKeyRequest;
import com.google.cloud.video.stitcher.v1.DeleteLiveConfigRequest;
import com.google.cloud.video.stitcher.v1.DeleteSlateRequest;
import com.google.cloud.video.stitcher.v1.GetCdnKeyRequest;
import com.google.cloud.video.stitcher.v1.GetLiveAdTagDetailRequest;
import com.google.cloud.video.stitcher.v1.GetLiveConfigRequest;
import com.google.cloud.video.stitcher.v1.GetLiveSessionRequest;
import com.google.cloud.video.stitcher.v1.GetSlateRequest;
import com.google.cloud.video.stitcher.v1.GetVodAdTagDetailRequest;
import com.google.cloud.video.stitcher.v1.GetVodSessionRequest;
import com.google.cloud.video.stitcher.v1.GetVodStitchDetailRequest;
import com.google.cloud.video.stitcher.v1.ListCdnKeysRequest;
import com.google.cloud.video.stitcher.v1.ListCdnKeysResponse;
import com.google.cloud.video.stitcher.v1.ListLiveAdTagDetailsRequest;
import com.google.cloud.video.stitcher.v1.ListLiveAdTagDetailsResponse;
import com.google.cloud.video.stitcher.v1.ListLiveConfigsRequest;
import com.google.cloud.video.stitcher.v1.ListLiveConfigsResponse;
import com.google.cloud.video.stitcher.v1.ListSlatesRequest;
import com.google.cloud.video.stitcher.v1.ListSlatesResponse;
import com.google.cloud.video.stitcher.v1.ListVodAdTagDetailsRequest;
import com.google.cloud.video.stitcher.v1.ListVodAdTagDetailsResponse;
import com.google.cloud.video.stitcher.v1.ListVodStitchDetailsRequest;
import com.google.cloud.video.stitcher.v1.ListVodStitchDetailsResponse;
import com.google.cloud.video.stitcher.v1.LiveAdTagDetail;
import com.google.cloud.video.stitcher.v1.LiveConfig;
import com.google.cloud.video.stitcher.v1.LiveSession;
import com.google.cloud.video.stitcher.v1.OperationMetadata;
import com.google.cloud.video.stitcher.v1.Slate;
import com.google.cloud.video.stitcher.v1.UpdateCdnKeyRequest;
import com.google.cloud.video.stitcher.v1.UpdateSlateRequest;
import com.google.cloud.video.stitcher.v1.VideoStitcherServiceClient;
import com.google.cloud.video.stitcher.v1.VodAdTagDetail;
import com.google.cloud.video.stitcher.v1.VodSession;
import com.google.cloud.video.stitcher.v1.VodStitchDetail;
import com.google.cloud.video.stitcher.v1.stub.GrpcVideoStitcherServiceStub;
import com.google.cloud.video.stitcher.v1.stub.VideoStitcherServiceStub;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.longrunning.Operation;
import com.google.protobuf.Empty;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.threeten.bp.Duration;

public class VideoStitcherServiceStubSettings
extends StubSettings<VideoStitcherServiceStubSettings> {
    private static final ImmutableList<String> DEFAULT_SERVICE_SCOPES = ImmutableList.builder().add((Object)"https://www.googleapis.com/auth/cloud-platform").build();
    private final UnaryCallSettings<CreateCdnKeyRequest, Operation> createCdnKeySettings;
    private final OperationCallSettings<CreateCdnKeyRequest, CdnKey, OperationMetadata> createCdnKeyOperationSettings;
    private final PagedCallSettings<ListCdnKeysRequest, ListCdnKeysResponse, VideoStitcherServiceClient.ListCdnKeysPagedResponse> listCdnKeysSettings;
    private final UnaryCallSettings<GetCdnKeyRequest, CdnKey> getCdnKeySettings;
    private final UnaryCallSettings<DeleteCdnKeyRequest, Operation> deleteCdnKeySettings;
    private final OperationCallSettings<DeleteCdnKeyRequest, Empty, OperationMetadata> deleteCdnKeyOperationSettings;
    private final UnaryCallSettings<UpdateCdnKeyRequest, Operation> updateCdnKeySettings;
    private final OperationCallSettings<UpdateCdnKeyRequest, CdnKey, OperationMetadata> updateCdnKeyOperationSettings;
    private final UnaryCallSettings<CreateVodSessionRequest, VodSession> createVodSessionSettings;
    private final UnaryCallSettings<GetVodSessionRequest, VodSession> getVodSessionSettings;
    private final PagedCallSettings<ListVodStitchDetailsRequest, ListVodStitchDetailsResponse, VideoStitcherServiceClient.ListVodStitchDetailsPagedResponse> listVodStitchDetailsSettings;
    private final UnaryCallSettings<GetVodStitchDetailRequest, VodStitchDetail> getVodStitchDetailSettings;
    private final PagedCallSettings<ListVodAdTagDetailsRequest, ListVodAdTagDetailsResponse, VideoStitcherServiceClient.ListVodAdTagDetailsPagedResponse> listVodAdTagDetailsSettings;
    private final UnaryCallSettings<GetVodAdTagDetailRequest, VodAdTagDetail> getVodAdTagDetailSettings;
    private final PagedCallSettings<ListLiveAdTagDetailsRequest, ListLiveAdTagDetailsResponse, VideoStitcherServiceClient.ListLiveAdTagDetailsPagedResponse> listLiveAdTagDetailsSettings;
    private final UnaryCallSettings<GetLiveAdTagDetailRequest, LiveAdTagDetail> getLiveAdTagDetailSettings;
    private final UnaryCallSettings<CreateSlateRequest, Operation> createSlateSettings;
    private final OperationCallSettings<CreateSlateRequest, Slate, OperationMetadata> createSlateOperationSettings;
    private final PagedCallSettings<ListSlatesRequest, ListSlatesResponse, VideoStitcherServiceClient.ListSlatesPagedResponse> listSlatesSettings;
    private final UnaryCallSettings<GetSlateRequest, Slate> getSlateSettings;
    private final UnaryCallSettings<UpdateSlateRequest, Operation> updateSlateSettings;
    private final OperationCallSettings<UpdateSlateRequest, Slate, OperationMetadata> updateSlateOperationSettings;
    private final UnaryCallSettings<DeleteSlateRequest, Operation> deleteSlateSettings;
    private final OperationCallSettings<DeleteSlateRequest, Empty, OperationMetadata> deleteSlateOperationSettings;
    private final UnaryCallSettings<CreateLiveSessionRequest, LiveSession> createLiveSessionSettings;
    private final UnaryCallSettings<GetLiveSessionRequest, LiveSession> getLiveSessionSettings;
    private final UnaryCallSettings<CreateLiveConfigRequest, Operation> createLiveConfigSettings;
    private final OperationCallSettings<CreateLiveConfigRequest, LiveConfig, OperationMetadata> createLiveConfigOperationSettings;
    private final PagedCallSettings<ListLiveConfigsRequest, ListLiveConfigsResponse, VideoStitcherServiceClient.ListLiveConfigsPagedResponse> listLiveConfigsSettings;
    private final UnaryCallSettings<GetLiveConfigRequest, LiveConfig> getLiveConfigSettings;
    private final UnaryCallSettings<DeleteLiveConfigRequest, Operation> deleteLiveConfigSettings;
    private final OperationCallSettings<DeleteLiveConfigRequest, Empty, OperationMetadata> deleteLiveConfigOperationSettings;
    private static final PagedListDescriptor<ListCdnKeysRequest, ListCdnKeysResponse, CdnKey> LIST_CDN_KEYS_PAGE_STR_DESC = new PagedListDescriptor<ListCdnKeysRequest, ListCdnKeysResponse, CdnKey>(){

        public String emptyToken() {
            return "";
        }

        public ListCdnKeysRequest injectToken(ListCdnKeysRequest payload, String token) {
            return ListCdnKeysRequest.newBuilder((ListCdnKeysRequest)payload).setPageToken(token).build();
        }

        public ListCdnKeysRequest injectPageSize(ListCdnKeysRequest payload, int pageSize) {
            return ListCdnKeysRequest.newBuilder((ListCdnKeysRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListCdnKeysRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListCdnKeysResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<CdnKey> extractResources(ListCdnKeysResponse payload) {
            return payload.getCdnKeysList() == null ? ImmutableList.of() : payload.getCdnKeysList();
        }
    };
    private static final PagedListDescriptor<ListVodStitchDetailsRequest, ListVodStitchDetailsResponse, VodStitchDetail> LIST_VOD_STITCH_DETAILS_PAGE_STR_DESC = new PagedListDescriptor<ListVodStitchDetailsRequest, ListVodStitchDetailsResponse, VodStitchDetail>(){

        public String emptyToken() {
            return "";
        }

        public ListVodStitchDetailsRequest injectToken(ListVodStitchDetailsRequest payload, String token) {
            return ListVodStitchDetailsRequest.newBuilder((ListVodStitchDetailsRequest)payload).setPageToken(token).build();
        }

        public ListVodStitchDetailsRequest injectPageSize(ListVodStitchDetailsRequest payload, int pageSize) {
            return ListVodStitchDetailsRequest.newBuilder((ListVodStitchDetailsRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListVodStitchDetailsRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListVodStitchDetailsResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<VodStitchDetail> extractResources(ListVodStitchDetailsResponse payload) {
            return payload.getVodStitchDetailsList() == null ? ImmutableList.of() : payload.getVodStitchDetailsList();
        }
    };
    private static final PagedListDescriptor<ListVodAdTagDetailsRequest, ListVodAdTagDetailsResponse, VodAdTagDetail> LIST_VOD_AD_TAG_DETAILS_PAGE_STR_DESC = new PagedListDescriptor<ListVodAdTagDetailsRequest, ListVodAdTagDetailsResponse, VodAdTagDetail>(){

        public String emptyToken() {
            return "";
        }

        public ListVodAdTagDetailsRequest injectToken(ListVodAdTagDetailsRequest payload, String token) {
            return ListVodAdTagDetailsRequest.newBuilder((ListVodAdTagDetailsRequest)payload).setPageToken(token).build();
        }

        public ListVodAdTagDetailsRequest injectPageSize(ListVodAdTagDetailsRequest payload, int pageSize) {
            return ListVodAdTagDetailsRequest.newBuilder((ListVodAdTagDetailsRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListVodAdTagDetailsRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListVodAdTagDetailsResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<VodAdTagDetail> extractResources(ListVodAdTagDetailsResponse payload) {
            return payload.getVodAdTagDetailsList() == null ? ImmutableList.of() : payload.getVodAdTagDetailsList();
        }
    };
    private static final PagedListDescriptor<ListLiveAdTagDetailsRequest, ListLiveAdTagDetailsResponse, LiveAdTagDetail> LIST_LIVE_AD_TAG_DETAILS_PAGE_STR_DESC = new PagedListDescriptor<ListLiveAdTagDetailsRequest, ListLiveAdTagDetailsResponse, LiveAdTagDetail>(){

        public String emptyToken() {
            return "";
        }

        public ListLiveAdTagDetailsRequest injectToken(ListLiveAdTagDetailsRequest payload, String token) {
            return ListLiveAdTagDetailsRequest.newBuilder((ListLiveAdTagDetailsRequest)payload).setPageToken(token).build();
        }

        public ListLiveAdTagDetailsRequest injectPageSize(ListLiveAdTagDetailsRequest payload, int pageSize) {
            return ListLiveAdTagDetailsRequest.newBuilder((ListLiveAdTagDetailsRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListLiveAdTagDetailsRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListLiveAdTagDetailsResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<LiveAdTagDetail> extractResources(ListLiveAdTagDetailsResponse payload) {
            return payload.getLiveAdTagDetailsList() == null ? ImmutableList.of() : payload.getLiveAdTagDetailsList();
        }
    };
    private static final PagedListDescriptor<ListSlatesRequest, ListSlatesResponse, Slate> LIST_SLATES_PAGE_STR_DESC = new PagedListDescriptor<ListSlatesRequest, ListSlatesResponse, Slate>(){

        public String emptyToken() {
            return "";
        }

        public ListSlatesRequest injectToken(ListSlatesRequest payload, String token) {
            return ListSlatesRequest.newBuilder((ListSlatesRequest)payload).setPageToken(token).build();
        }

        public ListSlatesRequest injectPageSize(ListSlatesRequest payload, int pageSize) {
            return ListSlatesRequest.newBuilder((ListSlatesRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListSlatesRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListSlatesResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<Slate> extractResources(ListSlatesResponse payload) {
            return payload.getSlatesList() == null ? ImmutableList.of() : payload.getSlatesList();
        }
    };
    private static final PagedListDescriptor<ListLiveConfigsRequest, ListLiveConfigsResponse, LiveConfig> LIST_LIVE_CONFIGS_PAGE_STR_DESC = new PagedListDescriptor<ListLiveConfigsRequest, ListLiveConfigsResponse, LiveConfig>(){

        public String emptyToken() {
            return "";
        }

        public ListLiveConfigsRequest injectToken(ListLiveConfigsRequest payload, String token) {
            return ListLiveConfigsRequest.newBuilder((ListLiveConfigsRequest)payload).setPageToken(token).build();
        }

        public ListLiveConfigsRequest injectPageSize(ListLiveConfigsRequest payload, int pageSize) {
            return ListLiveConfigsRequest.newBuilder((ListLiveConfigsRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListLiveConfigsRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListLiveConfigsResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<LiveConfig> extractResources(ListLiveConfigsResponse payload) {
            return payload.getLiveConfigsList() == null ? ImmutableList.of() : payload.getLiveConfigsList();
        }
    };
    private static final PagedListResponseFactory<ListCdnKeysRequest, ListCdnKeysResponse, VideoStitcherServiceClient.ListCdnKeysPagedResponse> LIST_CDN_KEYS_PAGE_STR_FACT = new PagedListResponseFactory<ListCdnKeysRequest, ListCdnKeysResponse, VideoStitcherServiceClient.ListCdnKeysPagedResponse>(){

        public ApiFuture<VideoStitcherServiceClient.ListCdnKeysPagedResponse> getFuturePagedResponse(UnaryCallable<ListCdnKeysRequest, ListCdnKeysResponse> callable, ListCdnKeysRequest request, ApiCallContext context, ApiFuture<ListCdnKeysResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_CDN_KEYS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return VideoStitcherServiceClient.ListCdnKeysPagedResponse.createAsync((PageContext<ListCdnKeysRequest, ListCdnKeysResponse, CdnKey>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<ListVodStitchDetailsRequest, ListVodStitchDetailsResponse, VideoStitcherServiceClient.ListVodStitchDetailsPagedResponse> LIST_VOD_STITCH_DETAILS_PAGE_STR_FACT = new PagedListResponseFactory<ListVodStitchDetailsRequest, ListVodStitchDetailsResponse, VideoStitcherServiceClient.ListVodStitchDetailsPagedResponse>(){

        public ApiFuture<VideoStitcherServiceClient.ListVodStitchDetailsPagedResponse> getFuturePagedResponse(UnaryCallable<ListVodStitchDetailsRequest, ListVodStitchDetailsResponse> callable, ListVodStitchDetailsRequest request, ApiCallContext context, ApiFuture<ListVodStitchDetailsResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_VOD_STITCH_DETAILS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return VideoStitcherServiceClient.ListVodStitchDetailsPagedResponse.createAsync((PageContext<ListVodStitchDetailsRequest, ListVodStitchDetailsResponse, VodStitchDetail>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<ListVodAdTagDetailsRequest, ListVodAdTagDetailsResponse, VideoStitcherServiceClient.ListVodAdTagDetailsPagedResponse> LIST_VOD_AD_TAG_DETAILS_PAGE_STR_FACT = new PagedListResponseFactory<ListVodAdTagDetailsRequest, ListVodAdTagDetailsResponse, VideoStitcherServiceClient.ListVodAdTagDetailsPagedResponse>(){

        public ApiFuture<VideoStitcherServiceClient.ListVodAdTagDetailsPagedResponse> getFuturePagedResponse(UnaryCallable<ListVodAdTagDetailsRequest, ListVodAdTagDetailsResponse> callable, ListVodAdTagDetailsRequest request, ApiCallContext context, ApiFuture<ListVodAdTagDetailsResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_VOD_AD_TAG_DETAILS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return VideoStitcherServiceClient.ListVodAdTagDetailsPagedResponse.createAsync((PageContext<ListVodAdTagDetailsRequest, ListVodAdTagDetailsResponse, VodAdTagDetail>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<ListLiveAdTagDetailsRequest, ListLiveAdTagDetailsResponse, VideoStitcherServiceClient.ListLiveAdTagDetailsPagedResponse> LIST_LIVE_AD_TAG_DETAILS_PAGE_STR_FACT = new PagedListResponseFactory<ListLiveAdTagDetailsRequest, ListLiveAdTagDetailsResponse, VideoStitcherServiceClient.ListLiveAdTagDetailsPagedResponse>(){

        public ApiFuture<VideoStitcherServiceClient.ListLiveAdTagDetailsPagedResponse> getFuturePagedResponse(UnaryCallable<ListLiveAdTagDetailsRequest, ListLiveAdTagDetailsResponse> callable, ListLiveAdTagDetailsRequest request, ApiCallContext context, ApiFuture<ListLiveAdTagDetailsResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_LIVE_AD_TAG_DETAILS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return VideoStitcherServiceClient.ListLiveAdTagDetailsPagedResponse.createAsync((PageContext<ListLiveAdTagDetailsRequest, ListLiveAdTagDetailsResponse, LiveAdTagDetail>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<ListSlatesRequest, ListSlatesResponse, VideoStitcherServiceClient.ListSlatesPagedResponse> LIST_SLATES_PAGE_STR_FACT = new PagedListResponseFactory<ListSlatesRequest, ListSlatesResponse, VideoStitcherServiceClient.ListSlatesPagedResponse>(){

        public ApiFuture<VideoStitcherServiceClient.ListSlatesPagedResponse> getFuturePagedResponse(UnaryCallable<ListSlatesRequest, ListSlatesResponse> callable, ListSlatesRequest request, ApiCallContext context, ApiFuture<ListSlatesResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_SLATES_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return VideoStitcherServiceClient.ListSlatesPagedResponse.createAsync((PageContext<ListSlatesRequest, ListSlatesResponse, Slate>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<ListLiveConfigsRequest, ListLiveConfigsResponse, VideoStitcherServiceClient.ListLiveConfigsPagedResponse> LIST_LIVE_CONFIGS_PAGE_STR_FACT = new PagedListResponseFactory<ListLiveConfigsRequest, ListLiveConfigsResponse, VideoStitcherServiceClient.ListLiveConfigsPagedResponse>(){

        public ApiFuture<VideoStitcherServiceClient.ListLiveConfigsPagedResponse> getFuturePagedResponse(UnaryCallable<ListLiveConfigsRequest, ListLiveConfigsResponse> callable, ListLiveConfigsRequest request, ApiCallContext context, ApiFuture<ListLiveConfigsResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_LIVE_CONFIGS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return VideoStitcherServiceClient.ListLiveConfigsPagedResponse.createAsync((PageContext<ListLiveConfigsRequest, ListLiveConfigsResponse, LiveConfig>)pageContext, futureResponse);
        }
    };

    public UnaryCallSettings<CreateCdnKeyRequest, Operation> createCdnKeySettings() {
        return this.createCdnKeySettings;
    }

    public OperationCallSettings<CreateCdnKeyRequest, CdnKey, OperationMetadata> createCdnKeyOperationSettings() {
        return this.createCdnKeyOperationSettings;
    }

    public PagedCallSettings<ListCdnKeysRequest, ListCdnKeysResponse, VideoStitcherServiceClient.ListCdnKeysPagedResponse> listCdnKeysSettings() {
        return this.listCdnKeysSettings;
    }

    public UnaryCallSettings<GetCdnKeyRequest, CdnKey> getCdnKeySettings() {
        return this.getCdnKeySettings;
    }

    public UnaryCallSettings<DeleteCdnKeyRequest, Operation> deleteCdnKeySettings() {
        return this.deleteCdnKeySettings;
    }

    public OperationCallSettings<DeleteCdnKeyRequest, Empty, OperationMetadata> deleteCdnKeyOperationSettings() {
        return this.deleteCdnKeyOperationSettings;
    }

    public UnaryCallSettings<UpdateCdnKeyRequest, Operation> updateCdnKeySettings() {
        return this.updateCdnKeySettings;
    }

    public OperationCallSettings<UpdateCdnKeyRequest, CdnKey, OperationMetadata> updateCdnKeyOperationSettings() {
        return this.updateCdnKeyOperationSettings;
    }

    public UnaryCallSettings<CreateVodSessionRequest, VodSession> createVodSessionSettings() {
        return this.createVodSessionSettings;
    }

    public UnaryCallSettings<GetVodSessionRequest, VodSession> getVodSessionSettings() {
        return this.getVodSessionSettings;
    }

    public PagedCallSettings<ListVodStitchDetailsRequest, ListVodStitchDetailsResponse, VideoStitcherServiceClient.ListVodStitchDetailsPagedResponse> listVodStitchDetailsSettings() {
        return this.listVodStitchDetailsSettings;
    }

    public UnaryCallSettings<GetVodStitchDetailRequest, VodStitchDetail> getVodStitchDetailSettings() {
        return this.getVodStitchDetailSettings;
    }

    public PagedCallSettings<ListVodAdTagDetailsRequest, ListVodAdTagDetailsResponse, VideoStitcherServiceClient.ListVodAdTagDetailsPagedResponse> listVodAdTagDetailsSettings() {
        return this.listVodAdTagDetailsSettings;
    }

    public UnaryCallSettings<GetVodAdTagDetailRequest, VodAdTagDetail> getVodAdTagDetailSettings() {
        return this.getVodAdTagDetailSettings;
    }

    public PagedCallSettings<ListLiveAdTagDetailsRequest, ListLiveAdTagDetailsResponse, VideoStitcherServiceClient.ListLiveAdTagDetailsPagedResponse> listLiveAdTagDetailsSettings() {
        return this.listLiveAdTagDetailsSettings;
    }

    public UnaryCallSettings<GetLiveAdTagDetailRequest, LiveAdTagDetail> getLiveAdTagDetailSettings() {
        return this.getLiveAdTagDetailSettings;
    }

    public UnaryCallSettings<CreateSlateRequest, Operation> createSlateSettings() {
        return this.createSlateSettings;
    }

    public OperationCallSettings<CreateSlateRequest, Slate, OperationMetadata> createSlateOperationSettings() {
        return this.createSlateOperationSettings;
    }

    public PagedCallSettings<ListSlatesRequest, ListSlatesResponse, VideoStitcherServiceClient.ListSlatesPagedResponse> listSlatesSettings() {
        return this.listSlatesSettings;
    }

    public UnaryCallSettings<GetSlateRequest, Slate> getSlateSettings() {
        return this.getSlateSettings;
    }

    public UnaryCallSettings<UpdateSlateRequest, Operation> updateSlateSettings() {
        return this.updateSlateSettings;
    }

    public OperationCallSettings<UpdateSlateRequest, Slate, OperationMetadata> updateSlateOperationSettings() {
        return this.updateSlateOperationSettings;
    }

    public UnaryCallSettings<DeleteSlateRequest, Operation> deleteSlateSettings() {
        return this.deleteSlateSettings;
    }

    public OperationCallSettings<DeleteSlateRequest, Empty, OperationMetadata> deleteSlateOperationSettings() {
        return this.deleteSlateOperationSettings;
    }

    public UnaryCallSettings<CreateLiveSessionRequest, LiveSession> createLiveSessionSettings() {
        return this.createLiveSessionSettings;
    }

    public UnaryCallSettings<GetLiveSessionRequest, LiveSession> getLiveSessionSettings() {
        return this.getLiveSessionSettings;
    }

    public UnaryCallSettings<CreateLiveConfigRequest, Operation> createLiveConfigSettings() {
        return this.createLiveConfigSettings;
    }

    public OperationCallSettings<CreateLiveConfigRequest, LiveConfig, OperationMetadata> createLiveConfigOperationSettings() {
        return this.createLiveConfigOperationSettings;
    }

    public PagedCallSettings<ListLiveConfigsRequest, ListLiveConfigsResponse, VideoStitcherServiceClient.ListLiveConfigsPagedResponse> listLiveConfigsSettings() {
        return this.listLiveConfigsSettings;
    }

    public UnaryCallSettings<GetLiveConfigRequest, LiveConfig> getLiveConfigSettings() {
        return this.getLiveConfigSettings;
    }

    public UnaryCallSettings<DeleteLiveConfigRequest, Operation> deleteLiveConfigSettings() {
        return this.deleteLiveConfigSettings;
    }

    public OperationCallSettings<DeleteLiveConfigRequest, Empty, OperationMetadata> deleteLiveConfigOperationSettings() {
        return this.deleteLiveConfigOperationSettings;
    }

    public VideoStitcherServiceStub createStub() throws IOException {
        if (this.getTransportChannelProvider().getTransportName().equals(GrpcTransportChannel.getGrpcTransportName())) {
            return GrpcVideoStitcherServiceStub.create(this);
        }
        throw new UnsupportedOperationException(String.format("Transport not supported: %s", this.getTransportChannelProvider().getTransportName()));
    }

    public String getEndpoint() {
        if (super.getEndpoint() != null) {
            return super.getEndpoint();
        }
        return VideoStitcherServiceStubSettings.getDefaultEndpoint();
    }

    public String getServiceName() {
        return "videostitcher";
    }

    public static InstantiatingExecutorProvider.Builder defaultExecutorProviderBuilder() {
        return InstantiatingExecutorProvider.newBuilder();
    }

    public static String getDefaultEndpoint() {
        return "videostitcher.googleapis.com:443";
    }

    public static String getDefaultMtlsEndpoint() {
        return "videostitcher.mtls.googleapis.com:443";
    }

    public static List<String> getDefaultServiceScopes() {
        return DEFAULT_SERVICE_SCOPES;
    }

    public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
        return GoogleCredentialsProvider.newBuilder().setScopesToApply(DEFAULT_SERVICE_SCOPES).setUseJwtAccessWithScope(true);
    }

    public static InstantiatingGrpcChannelProvider.Builder defaultGrpcTransportProviderBuilder() {
        return InstantiatingGrpcChannelProvider.newBuilder().setMaxInboundMessageSize(Integer.valueOf(Integer.MAX_VALUE));
    }

    public static TransportChannelProvider defaultTransportChannelProvider() {
        return VideoStitcherServiceStubSettings.defaultGrpcTransportProviderBuilder().build();
    }

    public static ApiClientHeaderProvider.Builder defaultApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(VideoStitcherServiceStubSettings.class)).setTransportToken(GaxGrpcProperties.getGrpcTokenName(), GaxGrpcProperties.getGrpcVersion());
    }

    public static Builder newBuilder() {
        return Builder.createDefault();
    }

    public static Builder newBuilder(ClientContext clientContext) {
        return new Builder(clientContext);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    protected VideoStitcherServiceStubSettings(Builder settingsBuilder) throws IOException {
        super((StubSettings.Builder)settingsBuilder);
        this.createCdnKeySettings = settingsBuilder.createCdnKeySettings().build();
        this.createCdnKeyOperationSettings = settingsBuilder.createCdnKeyOperationSettings().build();
        this.listCdnKeysSettings = settingsBuilder.listCdnKeysSettings().build();
        this.getCdnKeySettings = settingsBuilder.getCdnKeySettings().build();
        this.deleteCdnKeySettings = settingsBuilder.deleteCdnKeySettings().build();
        this.deleteCdnKeyOperationSettings = settingsBuilder.deleteCdnKeyOperationSettings().build();
        this.updateCdnKeySettings = settingsBuilder.updateCdnKeySettings().build();
        this.updateCdnKeyOperationSettings = settingsBuilder.updateCdnKeyOperationSettings().build();
        this.createVodSessionSettings = settingsBuilder.createVodSessionSettings().build();
        this.getVodSessionSettings = settingsBuilder.getVodSessionSettings().build();
        this.listVodStitchDetailsSettings = settingsBuilder.listVodStitchDetailsSettings().build();
        this.getVodStitchDetailSettings = settingsBuilder.getVodStitchDetailSettings().build();
        this.listVodAdTagDetailsSettings = settingsBuilder.listVodAdTagDetailsSettings().build();
        this.getVodAdTagDetailSettings = settingsBuilder.getVodAdTagDetailSettings().build();
        this.listLiveAdTagDetailsSettings = settingsBuilder.listLiveAdTagDetailsSettings().build();
        this.getLiveAdTagDetailSettings = settingsBuilder.getLiveAdTagDetailSettings().build();
        this.createSlateSettings = settingsBuilder.createSlateSettings().build();
        this.createSlateOperationSettings = settingsBuilder.createSlateOperationSettings().build();
        this.listSlatesSettings = settingsBuilder.listSlatesSettings().build();
        this.getSlateSettings = settingsBuilder.getSlateSettings().build();
        this.updateSlateSettings = settingsBuilder.updateSlateSettings().build();
        this.updateSlateOperationSettings = settingsBuilder.updateSlateOperationSettings().build();
        this.deleteSlateSettings = settingsBuilder.deleteSlateSettings().build();
        this.deleteSlateOperationSettings = settingsBuilder.deleteSlateOperationSettings().build();
        this.createLiveSessionSettings = settingsBuilder.createLiveSessionSettings().build();
        this.getLiveSessionSettings = settingsBuilder.getLiveSessionSettings().build();
        this.createLiveConfigSettings = settingsBuilder.createLiveConfigSettings().build();
        this.createLiveConfigOperationSettings = settingsBuilder.createLiveConfigOperationSettings().build();
        this.listLiveConfigsSettings = settingsBuilder.listLiveConfigsSettings().build();
        this.getLiveConfigSettings = settingsBuilder.getLiveConfigSettings().build();
        this.deleteLiveConfigSettings = settingsBuilder.deleteLiveConfigSettings().build();
        this.deleteLiveConfigOperationSettings = settingsBuilder.deleteLiveConfigOperationSettings().build();
    }

    public static class Builder
    extends StubSettings.Builder<VideoStitcherServiceStubSettings, Builder> {
        private final ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders;
        private final UnaryCallSettings.Builder<CreateCdnKeyRequest, Operation> createCdnKeySettings;
        private final OperationCallSettings.Builder<CreateCdnKeyRequest, CdnKey, OperationMetadata> createCdnKeyOperationSettings;
        private final PagedCallSettings.Builder<ListCdnKeysRequest, ListCdnKeysResponse, VideoStitcherServiceClient.ListCdnKeysPagedResponse> listCdnKeysSettings;
        private final UnaryCallSettings.Builder<GetCdnKeyRequest, CdnKey> getCdnKeySettings;
        private final UnaryCallSettings.Builder<DeleteCdnKeyRequest, Operation> deleteCdnKeySettings;
        private final OperationCallSettings.Builder<DeleteCdnKeyRequest, Empty, OperationMetadata> deleteCdnKeyOperationSettings;
        private final UnaryCallSettings.Builder<UpdateCdnKeyRequest, Operation> updateCdnKeySettings;
        private final OperationCallSettings.Builder<UpdateCdnKeyRequest, CdnKey, OperationMetadata> updateCdnKeyOperationSettings;
        private final UnaryCallSettings.Builder<CreateVodSessionRequest, VodSession> createVodSessionSettings;
        private final UnaryCallSettings.Builder<GetVodSessionRequest, VodSession> getVodSessionSettings;
        private final PagedCallSettings.Builder<ListVodStitchDetailsRequest, ListVodStitchDetailsResponse, VideoStitcherServiceClient.ListVodStitchDetailsPagedResponse> listVodStitchDetailsSettings;
        private final UnaryCallSettings.Builder<GetVodStitchDetailRequest, VodStitchDetail> getVodStitchDetailSettings;
        private final PagedCallSettings.Builder<ListVodAdTagDetailsRequest, ListVodAdTagDetailsResponse, VideoStitcherServiceClient.ListVodAdTagDetailsPagedResponse> listVodAdTagDetailsSettings;
        private final UnaryCallSettings.Builder<GetVodAdTagDetailRequest, VodAdTagDetail> getVodAdTagDetailSettings;
        private final PagedCallSettings.Builder<ListLiveAdTagDetailsRequest, ListLiveAdTagDetailsResponse, VideoStitcherServiceClient.ListLiveAdTagDetailsPagedResponse> listLiveAdTagDetailsSettings;
        private final UnaryCallSettings.Builder<GetLiveAdTagDetailRequest, LiveAdTagDetail> getLiveAdTagDetailSettings;
        private final UnaryCallSettings.Builder<CreateSlateRequest, Operation> createSlateSettings;
        private final OperationCallSettings.Builder<CreateSlateRequest, Slate, OperationMetadata> createSlateOperationSettings;
        private final PagedCallSettings.Builder<ListSlatesRequest, ListSlatesResponse, VideoStitcherServiceClient.ListSlatesPagedResponse> listSlatesSettings;
        private final UnaryCallSettings.Builder<GetSlateRequest, Slate> getSlateSettings;
        private final UnaryCallSettings.Builder<UpdateSlateRequest, Operation> updateSlateSettings;
        private final OperationCallSettings.Builder<UpdateSlateRequest, Slate, OperationMetadata> updateSlateOperationSettings;
        private final UnaryCallSettings.Builder<DeleteSlateRequest, Operation> deleteSlateSettings;
        private final OperationCallSettings.Builder<DeleteSlateRequest, Empty, OperationMetadata> deleteSlateOperationSettings;
        private final UnaryCallSettings.Builder<CreateLiveSessionRequest, LiveSession> createLiveSessionSettings;
        private final UnaryCallSettings.Builder<GetLiveSessionRequest, LiveSession> getLiveSessionSettings;
        private final UnaryCallSettings.Builder<CreateLiveConfigRequest, Operation> createLiveConfigSettings;
        private final OperationCallSettings.Builder<CreateLiveConfigRequest, LiveConfig, OperationMetadata> createLiveConfigOperationSettings;
        private final PagedCallSettings.Builder<ListLiveConfigsRequest, ListLiveConfigsResponse, VideoStitcherServiceClient.ListLiveConfigsPagedResponse> listLiveConfigsSettings;
        private final UnaryCallSettings.Builder<GetLiveConfigRequest, LiveConfig> getLiveConfigSettings;
        private final UnaryCallSettings.Builder<DeleteLiveConfigRequest, Operation> deleteLiveConfigSettings;
        private final OperationCallSettings.Builder<DeleteLiveConfigRequest, Empty, OperationMetadata> deleteLiveConfigOperationSettings;
        private static final ImmutableMap<String, ImmutableSet<StatusCode.Code>> RETRYABLE_CODE_DEFINITIONS;
        private static final ImmutableMap<String, RetrySettings> RETRY_PARAM_DEFINITIONS;

        protected Builder() {
            this((ClientContext)null);
        }

        protected Builder(ClientContext clientContext) {
            super(clientContext);
            this.createCdnKeySettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.createCdnKeyOperationSettings = OperationCallSettings.newBuilder();
            this.listCdnKeysSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_CDN_KEYS_PAGE_STR_FACT);
            this.getCdnKeySettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.deleteCdnKeySettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.deleteCdnKeyOperationSettings = OperationCallSettings.newBuilder();
            this.updateCdnKeySettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.updateCdnKeyOperationSettings = OperationCallSettings.newBuilder();
            this.createVodSessionSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.getVodSessionSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.listVodStitchDetailsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_VOD_STITCH_DETAILS_PAGE_STR_FACT);
            this.getVodStitchDetailSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.listVodAdTagDetailsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_VOD_AD_TAG_DETAILS_PAGE_STR_FACT);
            this.getVodAdTagDetailSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.listLiveAdTagDetailsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_LIVE_AD_TAG_DETAILS_PAGE_STR_FACT);
            this.getLiveAdTagDetailSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.createSlateSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.createSlateOperationSettings = OperationCallSettings.newBuilder();
            this.listSlatesSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_SLATES_PAGE_STR_FACT);
            this.getSlateSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.updateSlateSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.updateSlateOperationSettings = OperationCallSettings.newBuilder();
            this.deleteSlateSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.deleteSlateOperationSettings = OperationCallSettings.newBuilder();
            this.createLiveSessionSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.getLiveSessionSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.createLiveConfigSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.createLiveConfigOperationSettings = OperationCallSettings.newBuilder();
            this.listLiveConfigsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_LIVE_CONFIGS_PAGE_STR_FACT);
            this.getLiveConfigSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.deleteLiveConfigSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.deleteLiveConfigOperationSettings = OperationCallSettings.newBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.createCdnKeySettings, this.listCdnKeysSettings, this.getCdnKeySettings, this.deleteCdnKeySettings, this.updateCdnKeySettings, this.createVodSessionSettings, this.getVodSessionSettings, this.listVodStitchDetailsSettings, this.getVodStitchDetailSettings, this.listVodAdTagDetailsSettings, this.getVodAdTagDetailSettings, this.listLiveAdTagDetailsSettings, (Object[])new UnaryCallSettings.Builder[]{this.getLiveAdTagDetailSettings, this.createSlateSettings, this.listSlatesSettings, this.getSlateSettings, this.updateSlateSettings, this.deleteSlateSettings, this.createLiveSessionSettings, this.getLiveSessionSettings, this.createLiveConfigSettings, this.listLiveConfigsSettings, this.getLiveConfigSettings, this.deleteLiveConfigSettings});
            Builder.initDefaults(this);
        }

        protected Builder(VideoStitcherServiceStubSettings settings) {
            super((StubSettings)settings);
            this.createCdnKeySettings = settings.createCdnKeySettings.toBuilder();
            this.createCdnKeyOperationSettings = settings.createCdnKeyOperationSettings.toBuilder();
            this.listCdnKeysSettings = settings.listCdnKeysSettings.toBuilder();
            this.getCdnKeySettings = settings.getCdnKeySettings.toBuilder();
            this.deleteCdnKeySettings = settings.deleteCdnKeySettings.toBuilder();
            this.deleteCdnKeyOperationSettings = settings.deleteCdnKeyOperationSettings.toBuilder();
            this.updateCdnKeySettings = settings.updateCdnKeySettings.toBuilder();
            this.updateCdnKeyOperationSettings = settings.updateCdnKeyOperationSettings.toBuilder();
            this.createVodSessionSettings = settings.createVodSessionSettings.toBuilder();
            this.getVodSessionSettings = settings.getVodSessionSettings.toBuilder();
            this.listVodStitchDetailsSettings = settings.listVodStitchDetailsSettings.toBuilder();
            this.getVodStitchDetailSettings = settings.getVodStitchDetailSettings.toBuilder();
            this.listVodAdTagDetailsSettings = settings.listVodAdTagDetailsSettings.toBuilder();
            this.getVodAdTagDetailSettings = settings.getVodAdTagDetailSettings.toBuilder();
            this.listLiveAdTagDetailsSettings = settings.listLiveAdTagDetailsSettings.toBuilder();
            this.getLiveAdTagDetailSettings = settings.getLiveAdTagDetailSettings.toBuilder();
            this.createSlateSettings = settings.createSlateSettings.toBuilder();
            this.createSlateOperationSettings = settings.createSlateOperationSettings.toBuilder();
            this.listSlatesSettings = settings.listSlatesSettings.toBuilder();
            this.getSlateSettings = settings.getSlateSettings.toBuilder();
            this.updateSlateSettings = settings.updateSlateSettings.toBuilder();
            this.updateSlateOperationSettings = settings.updateSlateOperationSettings.toBuilder();
            this.deleteSlateSettings = settings.deleteSlateSettings.toBuilder();
            this.deleteSlateOperationSettings = settings.deleteSlateOperationSettings.toBuilder();
            this.createLiveSessionSettings = settings.createLiveSessionSettings.toBuilder();
            this.getLiveSessionSettings = settings.getLiveSessionSettings.toBuilder();
            this.createLiveConfigSettings = settings.createLiveConfigSettings.toBuilder();
            this.createLiveConfigOperationSettings = settings.createLiveConfigOperationSettings.toBuilder();
            this.listLiveConfigsSettings = settings.listLiveConfigsSettings.toBuilder();
            this.getLiveConfigSettings = settings.getLiveConfigSettings.toBuilder();
            this.deleteLiveConfigSettings = settings.deleteLiveConfigSettings.toBuilder();
            this.deleteLiveConfigOperationSettings = settings.deleteLiveConfigOperationSettings.toBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.createCdnKeySettings, this.listCdnKeysSettings, this.getCdnKeySettings, this.deleteCdnKeySettings, this.updateCdnKeySettings, this.createVodSessionSettings, this.getVodSessionSettings, this.listVodStitchDetailsSettings, this.getVodStitchDetailSettings, this.listVodAdTagDetailsSettings, this.getVodAdTagDetailSettings, this.listLiveAdTagDetailsSettings, (Object[])new UnaryCallSettings.Builder[]{this.getLiveAdTagDetailSettings, this.createSlateSettings, this.listSlatesSettings, this.getSlateSettings, this.updateSlateSettings, this.deleteSlateSettings, this.createLiveSessionSettings, this.getLiveSessionSettings, this.createLiveConfigSettings, this.listLiveConfigsSettings, this.getLiveConfigSettings, this.deleteLiveConfigSettings});
        }

        private static Builder createDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider(VideoStitcherServiceStubSettings.defaultTransportChannelProvider());
            builder.setCredentialsProvider((CredentialsProvider)VideoStitcherServiceStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)VideoStitcherServiceStubSettings.defaultApiClientHeaderProviderBuilder().build());
            builder.setMtlsEndpoint(VideoStitcherServiceStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder initDefaults(Builder builder) {
            builder.createCdnKeySettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.listCdnKeysSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.getCdnKeySettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.deleteCdnKeySettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.updateCdnKeySettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.createVodSessionSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.getVodSessionSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.listVodStitchDetailsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.getVodStitchDetailSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.listVodAdTagDetailsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.getVodAdTagDetailSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.listLiveAdTagDetailsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.getLiveAdTagDetailSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.createSlateSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.listSlatesSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.getSlateSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.updateSlateSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.deleteSlateSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.createLiveSessionSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.getLiveSessionSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.createLiveConfigSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.listLiveConfigsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.getLiveConfigSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.deleteLiveConfigSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.createCdnKeyOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(CdnKey.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            builder.deleteCdnKeyOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Empty.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            builder.updateCdnKeyOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(CdnKey.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            builder.createSlateOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Slate.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            builder.updateSlateOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Slate.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            builder.deleteSlateOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Empty.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            builder.createLiveConfigOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(LiveConfig.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            builder.deleteLiveConfigOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Empty.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            return builder;
        }

        public Builder applyToAllUnaryMethods(ApiFunction<UnaryCallSettings.Builder<?, ?>, Void> settingsUpdater) {
            StubSettings.Builder.applyToAllUnaryMethods(this.unaryMethodSettingsBuilders, settingsUpdater);
            return this;
        }

        public ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders() {
            return this.unaryMethodSettingsBuilders;
        }

        public UnaryCallSettings.Builder<CreateCdnKeyRequest, Operation> createCdnKeySettings() {
            return this.createCdnKeySettings;
        }

        @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
        public OperationCallSettings.Builder<CreateCdnKeyRequest, CdnKey, OperationMetadata> createCdnKeyOperationSettings() {
            return this.createCdnKeyOperationSettings;
        }

        public PagedCallSettings.Builder<ListCdnKeysRequest, ListCdnKeysResponse, VideoStitcherServiceClient.ListCdnKeysPagedResponse> listCdnKeysSettings() {
            return this.listCdnKeysSettings;
        }

        public UnaryCallSettings.Builder<GetCdnKeyRequest, CdnKey> getCdnKeySettings() {
            return this.getCdnKeySettings;
        }

        public UnaryCallSettings.Builder<DeleteCdnKeyRequest, Operation> deleteCdnKeySettings() {
            return this.deleteCdnKeySettings;
        }

        @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
        public OperationCallSettings.Builder<DeleteCdnKeyRequest, Empty, OperationMetadata> deleteCdnKeyOperationSettings() {
            return this.deleteCdnKeyOperationSettings;
        }

        public UnaryCallSettings.Builder<UpdateCdnKeyRequest, Operation> updateCdnKeySettings() {
            return this.updateCdnKeySettings;
        }

        @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
        public OperationCallSettings.Builder<UpdateCdnKeyRequest, CdnKey, OperationMetadata> updateCdnKeyOperationSettings() {
            return this.updateCdnKeyOperationSettings;
        }

        public UnaryCallSettings.Builder<CreateVodSessionRequest, VodSession> createVodSessionSettings() {
            return this.createVodSessionSettings;
        }

        public UnaryCallSettings.Builder<GetVodSessionRequest, VodSession> getVodSessionSettings() {
            return this.getVodSessionSettings;
        }

        public PagedCallSettings.Builder<ListVodStitchDetailsRequest, ListVodStitchDetailsResponse, VideoStitcherServiceClient.ListVodStitchDetailsPagedResponse> listVodStitchDetailsSettings() {
            return this.listVodStitchDetailsSettings;
        }

        public UnaryCallSettings.Builder<GetVodStitchDetailRequest, VodStitchDetail> getVodStitchDetailSettings() {
            return this.getVodStitchDetailSettings;
        }

        public PagedCallSettings.Builder<ListVodAdTagDetailsRequest, ListVodAdTagDetailsResponse, VideoStitcherServiceClient.ListVodAdTagDetailsPagedResponse> listVodAdTagDetailsSettings() {
            return this.listVodAdTagDetailsSettings;
        }

        public UnaryCallSettings.Builder<GetVodAdTagDetailRequest, VodAdTagDetail> getVodAdTagDetailSettings() {
            return this.getVodAdTagDetailSettings;
        }

        public PagedCallSettings.Builder<ListLiveAdTagDetailsRequest, ListLiveAdTagDetailsResponse, VideoStitcherServiceClient.ListLiveAdTagDetailsPagedResponse> listLiveAdTagDetailsSettings() {
            return this.listLiveAdTagDetailsSettings;
        }

        public UnaryCallSettings.Builder<GetLiveAdTagDetailRequest, LiveAdTagDetail> getLiveAdTagDetailSettings() {
            return this.getLiveAdTagDetailSettings;
        }

        public UnaryCallSettings.Builder<CreateSlateRequest, Operation> createSlateSettings() {
            return this.createSlateSettings;
        }

        @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
        public OperationCallSettings.Builder<CreateSlateRequest, Slate, OperationMetadata> createSlateOperationSettings() {
            return this.createSlateOperationSettings;
        }

        public PagedCallSettings.Builder<ListSlatesRequest, ListSlatesResponse, VideoStitcherServiceClient.ListSlatesPagedResponse> listSlatesSettings() {
            return this.listSlatesSettings;
        }

        public UnaryCallSettings.Builder<GetSlateRequest, Slate> getSlateSettings() {
            return this.getSlateSettings;
        }

        public UnaryCallSettings.Builder<UpdateSlateRequest, Operation> updateSlateSettings() {
            return this.updateSlateSettings;
        }

        @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
        public OperationCallSettings.Builder<UpdateSlateRequest, Slate, OperationMetadata> updateSlateOperationSettings() {
            return this.updateSlateOperationSettings;
        }

        public UnaryCallSettings.Builder<DeleteSlateRequest, Operation> deleteSlateSettings() {
            return this.deleteSlateSettings;
        }

        @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
        public OperationCallSettings.Builder<DeleteSlateRequest, Empty, OperationMetadata> deleteSlateOperationSettings() {
            return this.deleteSlateOperationSettings;
        }

        public UnaryCallSettings.Builder<CreateLiveSessionRequest, LiveSession> createLiveSessionSettings() {
            return this.createLiveSessionSettings;
        }

        public UnaryCallSettings.Builder<GetLiveSessionRequest, LiveSession> getLiveSessionSettings() {
            return this.getLiveSessionSettings;
        }

        public UnaryCallSettings.Builder<CreateLiveConfigRequest, Operation> createLiveConfigSettings() {
            return this.createLiveConfigSettings;
        }

        @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
        public OperationCallSettings.Builder<CreateLiveConfigRequest, LiveConfig, OperationMetadata> createLiveConfigOperationSettings() {
            return this.createLiveConfigOperationSettings;
        }

        public PagedCallSettings.Builder<ListLiveConfigsRequest, ListLiveConfigsResponse, VideoStitcherServiceClient.ListLiveConfigsPagedResponse> listLiveConfigsSettings() {
            return this.listLiveConfigsSettings;
        }

        public UnaryCallSettings.Builder<GetLiveConfigRequest, LiveConfig> getLiveConfigSettings() {
            return this.getLiveConfigSettings;
        }

        public UnaryCallSettings.Builder<DeleteLiveConfigRequest, Operation> deleteLiveConfigSettings() {
            return this.deleteLiveConfigSettings;
        }

        @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
        public OperationCallSettings.Builder<DeleteLiveConfigRequest, Empty, OperationMetadata> deleteLiveConfigOperationSettings() {
            return this.deleteLiveConfigOperationSettings;
        }

        public String getEndpoint() {
            if (super.getEndpoint() != null) {
                return super.getEndpoint();
            }
            return VideoStitcherServiceStubSettings.getDefaultEndpoint();
        }

        public VideoStitcherServiceStubSettings build() throws IOException {
            return new VideoStitcherServiceStubSettings(this);
        }

        static {
            ImmutableMap.Builder definitions = ImmutableMap.builder();
            definitions.put((Object)"no_retry_1_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList()));
            RETRYABLE_CODE_DEFINITIONS = definitions.build();
            definitions = ImmutableMap.builder();
            RetrySettings settings = null;
            settings = RetrySettings.newBuilder().setInitialRpcTimeout(Duration.ofMillis((long)60000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ofMillis((long)60000L)).setTotalTimeout(Duration.ofMillis((long)60000L)).build();
            definitions.put((Object)"no_retry_1_params", (Object)settings);
            RETRY_PARAM_DEFINITIONS = definitions.build();
        }
    }
}

