/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.video.stitcher.v1;

import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.longrunning.OperationFuture;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.OperationCallable;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.video.stitcher.v1.CdnKey;
import com.google.cloud.video.stitcher.v1.CdnKeyName;
import com.google.cloud.video.stitcher.v1.CreateCdnKeyRequest;
import com.google.cloud.video.stitcher.v1.CreateLiveConfigRequest;
import com.google.cloud.video.stitcher.v1.CreateLiveSessionRequest;
import com.google.cloud.video.stitcher.v1.CreateSlateRequest;
import com.google.cloud.video.stitcher.v1.CreateVodSessionRequest;
import com.google.cloud.video.stitcher.v1.DeleteCdnKeyRequest;
import com.google.cloud.video.stitcher.v1.DeleteLiveConfigRequest;
import com.google.cloud.video.stitcher.v1.DeleteSlateRequest;
import com.google.cloud.video.stitcher.v1.GetCdnKeyRequest;
import com.google.cloud.video.stitcher.v1.GetLiveAdTagDetailRequest;
import com.google.cloud.video.stitcher.v1.GetLiveConfigRequest;
import com.google.cloud.video.stitcher.v1.GetLiveSessionRequest;
import com.google.cloud.video.stitcher.v1.GetSlateRequest;
import com.google.cloud.video.stitcher.v1.GetVodAdTagDetailRequest;
import com.google.cloud.video.stitcher.v1.GetVodSessionRequest;
import com.google.cloud.video.stitcher.v1.GetVodStitchDetailRequest;
import com.google.cloud.video.stitcher.v1.ListCdnKeysRequest;
import com.google.cloud.video.stitcher.v1.ListCdnKeysResponse;
import com.google.cloud.video.stitcher.v1.ListLiveAdTagDetailsRequest;
import com.google.cloud.video.stitcher.v1.ListLiveAdTagDetailsResponse;
import com.google.cloud.video.stitcher.v1.ListLiveConfigsRequest;
import com.google.cloud.video.stitcher.v1.ListLiveConfigsResponse;
import com.google.cloud.video.stitcher.v1.ListSlatesRequest;
import com.google.cloud.video.stitcher.v1.ListSlatesResponse;
import com.google.cloud.video.stitcher.v1.ListVodAdTagDetailsRequest;
import com.google.cloud.video.stitcher.v1.ListVodAdTagDetailsResponse;
import com.google.cloud.video.stitcher.v1.ListVodStitchDetailsRequest;
import com.google.cloud.video.stitcher.v1.ListVodStitchDetailsResponse;
import com.google.cloud.video.stitcher.v1.LiveAdTagDetail;
import com.google.cloud.video.stitcher.v1.LiveAdTagDetailName;
import com.google.cloud.video.stitcher.v1.LiveConfig;
import com.google.cloud.video.stitcher.v1.LiveConfigName;
import com.google.cloud.video.stitcher.v1.LiveSession;
import com.google.cloud.video.stitcher.v1.LiveSessionName;
import com.google.cloud.video.stitcher.v1.LocationName;
import com.google.cloud.video.stitcher.v1.OperationMetadata;
import com.google.cloud.video.stitcher.v1.Slate;
import com.google.cloud.video.stitcher.v1.SlateName;
import com.google.cloud.video.stitcher.v1.UpdateCdnKeyRequest;
import com.google.cloud.video.stitcher.v1.UpdateSlateRequest;
import com.google.cloud.video.stitcher.v1.VideoStitcherServiceSettings;
import com.google.cloud.video.stitcher.v1.VodAdTagDetail;
import com.google.cloud.video.stitcher.v1.VodAdTagDetailName;
import com.google.cloud.video.stitcher.v1.VodSession;
import com.google.cloud.video.stitcher.v1.VodSessionName;
import com.google.cloud.video.stitcher.v1.VodStitchDetail;
import com.google.cloud.video.stitcher.v1.VodStitchDetailName;
import com.google.cloud.video.stitcher.v1.stub.VideoStitcherServiceStub;
import com.google.cloud.video.stitcher.v1.stub.VideoStitcherServiceStubSettings;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.longrunning.Operation;
import com.google.longrunning.OperationsClient;
import com.google.longrunning.stub.OperationsStub;
import com.google.protobuf.Empty;
import com.google.protobuf.FieldMask;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

public class VideoStitcherServiceClient
implements BackgroundResource {
    private final VideoStitcherServiceSettings settings;
    private final VideoStitcherServiceStub stub;
    private final OperationsClient operationsClient;

    public static final VideoStitcherServiceClient create() throws IOException {
        return VideoStitcherServiceClient.create(VideoStitcherServiceSettings.newBuilder().build());
    }

    public static final VideoStitcherServiceClient create(VideoStitcherServiceSettings settings) throws IOException {
        return new VideoStitcherServiceClient(settings);
    }

    public static final VideoStitcherServiceClient create(VideoStitcherServiceStub stub) {
        return new VideoStitcherServiceClient(stub);
    }

    protected VideoStitcherServiceClient(VideoStitcherServiceSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((VideoStitcherServiceStubSettings)settings.getStubSettings()).createStub();
        this.operationsClient = OperationsClient.create((OperationsStub)this.stub.getOperationsStub());
    }

    protected VideoStitcherServiceClient(VideoStitcherServiceStub stub) {
        this.settings = null;
        this.stub = stub;
        this.operationsClient = OperationsClient.create((OperationsStub)this.stub.getOperationsStub());
    }

    public final VideoStitcherServiceSettings getSettings() {
        return this.settings;
    }

    public VideoStitcherServiceStub getStub() {
        return this.stub;
    }

    public final OperationsClient getOperationsClient() {
        return this.operationsClient;
    }

    public final OperationFuture<CdnKey, OperationMetadata> createCdnKeyAsync(LocationName parent, CdnKey cdnKey, String cdnKeyId) {
        CreateCdnKeyRequest request = CreateCdnKeyRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setCdnKey(cdnKey).setCdnKeyId(cdnKeyId).build();
        return this.createCdnKeyAsync(request);
    }

    public final OperationFuture<CdnKey, OperationMetadata> createCdnKeyAsync(String parent, CdnKey cdnKey, String cdnKeyId) {
        CreateCdnKeyRequest request = CreateCdnKeyRequest.newBuilder().setParent(parent).setCdnKey(cdnKey).setCdnKeyId(cdnKeyId).build();
        return this.createCdnKeyAsync(request);
    }

    public final OperationFuture<CdnKey, OperationMetadata> createCdnKeyAsync(CreateCdnKeyRequest request) {
        return this.createCdnKeyOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<CreateCdnKeyRequest, CdnKey, OperationMetadata> createCdnKeyOperationCallable() {
        return this.stub.createCdnKeyOperationCallable();
    }

    public final UnaryCallable<CreateCdnKeyRequest, Operation> createCdnKeyCallable() {
        return this.stub.createCdnKeyCallable();
    }

    public final ListCdnKeysPagedResponse listCdnKeys(LocationName parent) {
        ListCdnKeysRequest request = ListCdnKeysRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listCdnKeys(request);
    }

    public final ListCdnKeysPagedResponse listCdnKeys(String parent) {
        ListCdnKeysRequest request = ListCdnKeysRequest.newBuilder().setParent(parent).build();
        return this.listCdnKeys(request);
    }

    public final ListCdnKeysPagedResponse listCdnKeys(ListCdnKeysRequest request) {
        return (ListCdnKeysPagedResponse)((Object)this.listCdnKeysPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListCdnKeysRequest, ListCdnKeysPagedResponse> listCdnKeysPagedCallable() {
        return this.stub.listCdnKeysPagedCallable();
    }

    public final UnaryCallable<ListCdnKeysRequest, ListCdnKeysResponse> listCdnKeysCallable() {
        return this.stub.listCdnKeysCallable();
    }

    public final CdnKey getCdnKey(CdnKeyName name) {
        GetCdnKeyRequest request = GetCdnKeyRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getCdnKey(request);
    }

    public final CdnKey getCdnKey(String name) {
        GetCdnKeyRequest request = GetCdnKeyRequest.newBuilder().setName(name).build();
        return this.getCdnKey(request);
    }

    public final CdnKey getCdnKey(GetCdnKeyRequest request) {
        return (CdnKey)this.getCdnKeyCallable().call((Object)request);
    }

    public final UnaryCallable<GetCdnKeyRequest, CdnKey> getCdnKeyCallable() {
        return this.stub.getCdnKeyCallable();
    }

    public final OperationFuture<Empty, OperationMetadata> deleteCdnKeyAsync(CdnKeyName name) {
        DeleteCdnKeyRequest request = DeleteCdnKeyRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.deleteCdnKeyAsync(request);
    }

    public final OperationFuture<Empty, OperationMetadata> deleteCdnKeyAsync(String name) {
        DeleteCdnKeyRequest request = DeleteCdnKeyRequest.newBuilder().setName(name).build();
        return this.deleteCdnKeyAsync(request);
    }

    public final OperationFuture<Empty, OperationMetadata> deleteCdnKeyAsync(DeleteCdnKeyRequest request) {
        return this.deleteCdnKeyOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<DeleteCdnKeyRequest, Empty, OperationMetadata> deleteCdnKeyOperationCallable() {
        return this.stub.deleteCdnKeyOperationCallable();
    }

    public final UnaryCallable<DeleteCdnKeyRequest, Operation> deleteCdnKeyCallable() {
        return this.stub.deleteCdnKeyCallable();
    }

    public final OperationFuture<CdnKey, OperationMetadata> updateCdnKeyAsync(CdnKey cdnKey, FieldMask updateMask) {
        UpdateCdnKeyRequest request = UpdateCdnKeyRequest.newBuilder().setCdnKey(cdnKey).setUpdateMask(updateMask).build();
        return this.updateCdnKeyAsync(request);
    }

    public final OperationFuture<CdnKey, OperationMetadata> updateCdnKeyAsync(UpdateCdnKeyRequest request) {
        return this.updateCdnKeyOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<UpdateCdnKeyRequest, CdnKey, OperationMetadata> updateCdnKeyOperationCallable() {
        return this.stub.updateCdnKeyOperationCallable();
    }

    public final UnaryCallable<UpdateCdnKeyRequest, Operation> updateCdnKeyCallable() {
        return this.stub.updateCdnKeyCallable();
    }

    public final VodSession createVodSession(LocationName parent, VodSession vodSession) {
        CreateVodSessionRequest request = CreateVodSessionRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setVodSession(vodSession).build();
        return this.createVodSession(request);
    }

    public final VodSession createVodSession(String parent, VodSession vodSession) {
        CreateVodSessionRequest request = CreateVodSessionRequest.newBuilder().setParent(parent).setVodSession(vodSession).build();
        return this.createVodSession(request);
    }

    public final VodSession createVodSession(CreateVodSessionRequest request) {
        return (VodSession)this.createVodSessionCallable().call((Object)request);
    }

    public final UnaryCallable<CreateVodSessionRequest, VodSession> createVodSessionCallable() {
        return this.stub.createVodSessionCallable();
    }

    public final VodSession getVodSession(VodSessionName name) {
        GetVodSessionRequest request = GetVodSessionRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getVodSession(request);
    }

    public final VodSession getVodSession(String name) {
        GetVodSessionRequest request = GetVodSessionRequest.newBuilder().setName(name).build();
        return this.getVodSession(request);
    }

    public final VodSession getVodSession(GetVodSessionRequest request) {
        return (VodSession)this.getVodSessionCallable().call((Object)request);
    }

    public final UnaryCallable<GetVodSessionRequest, VodSession> getVodSessionCallable() {
        return this.stub.getVodSessionCallable();
    }

    public final ListVodStitchDetailsPagedResponse listVodStitchDetails(VodSessionName parent) {
        ListVodStitchDetailsRequest request = ListVodStitchDetailsRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listVodStitchDetails(request);
    }

    public final ListVodStitchDetailsPagedResponse listVodStitchDetails(String parent) {
        ListVodStitchDetailsRequest request = ListVodStitchDetailsRequest.newBuilder().setParent(parent).build();
        return this.listVodStitchDetails(request);
    }

    public final ListVodStitchDetailsPagedResponse listVodStitchDetails(ListVodStitchDetailsRequest request) {
        return (ListVodStitchDetailsPagedResponse)((Object)this.listVodStitchDetailsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListVodStitchDetailsRequest, ListVodStitchDetailsPagedResponse> listVodStitchDetailsPagedCallable() {
        return this.stub.listVodStitchDetailsPagedCallable();
    }

    public final UnaryCallable<ListVodStitchDetailsRequest, ListVodStitchDetailsResponse> listVodStitchDetailsCallable() {
        return this.stub.listVodStitchDetailsCallable();
    }

    public final VodStitchDetail getVodStitchDetail(VodStitchDetailName name) {
        GetVodStitchDetailRequest request = GetVodStitchDetailRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getVodStitchDetail(request);
    }

    public final VodStitchDetail getVodStitchDetail(String name) {
        GetVodStitchDetailRequest request = GetVodStitchDetailRequest.newBuilder().setName(name).build();
        return this.getVodStitchDetail(request);
    }

    public final VodStitchDetail getVodStitchDetail(GetVodStitchDetailRequest request) {
        return (VodStitchDetail)this.getVodStitchDetailCallable().call((Object)request);
    }

    public final UnaryCallable<GetVodStitchDetailRequest, VodStitchDetail> getVodStitchDetailCallable() {
        return this.stub.getVodStitchDetailCallable();
    }

    public final ListVodAdTagDetailsPagedResponse listVodAdTagDetails(VodSessionName parent) {
        ListVodAdTagDetailsRequest request = ListVodAdTagDetailsRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listVodAdTagDetails(request);
    }

    public final ListVodAdTagDetailsPagedResponse listVodAdTagDetails(String parent) {
        ListVodAdTagDetailsRequest request = ListVodAdTagDetailsRequest.newBuilder().setParent(parent).build();
        return this.listVodAdTagDetails(request);
    }

    public final ListVodAdTagDetailsPagedResponse listVodAdTagDetails(ListVodAdTagDetailsRequest request) {
        return (ListVodAdTagDetailsPagedResponse)((Object)this.listVodAdTagDetailsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListVodAdTagDetailsRequest, ListVodAdTagDetailsPagedResponse> listVodAdTagDetailsPagedCallable() {
        return this.stub.listVodAdTagDetailsPagedCallable();
    }

    public final UnaryCallable<ListVodAdTagDetailsRequest, ListVodAdTagDetailsResponse> listVodAdTagDetailsCallable() {
        return this.stub.listVodAdTagDetailsCallable();
    }

    public final VodAdTagDetail getVodAdTagDetail(VodAdTagDetailName name) {
        GetVodAdTagDetailRequest request = GetVodAdTagDetailRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getVodAdTagDetail(request);
    }

    public final VodAdTagDetail getVodAdTagDetail(String name) {
        GetVodAdTagDetailRequest request = GetVodAdTagDetailRequest.newBuilder().setName(name).build();
        return this.getVodAdTagDetail(request);
    }

    public final VodAdTagDetail getVodAdTagDetail(GetVodAdTagDetailRequest request) {
        return (VodAdTagDetail)this.getVodAdTagDetailCallable().call((Object)request);
    }

    public final UnaryCallable<GetVodAdTagDetailRequest, VodAdTagDetail> getVodAdTagDetailCallable() {
        return this.stub.getVodAdTagDetailCallable();
    }

    public final ListLiveAdTagDetailsPagedResponse listLiveAdTagDetails(LiveSessionName parent) {
        ListLiveAdTagDetailsRequest request = ListLiveAdTagDetailsRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listLiveAdTagDetails(request);
    }

    public final ListLiveAdTagDetailsPagedResponse listLiveAdTagDetails(String parent) {
        ListLiveAdTagDetailsRequest request = ListLiveAdTagDetailsRequest.newBuilder().setParent(parent).build();
        return this.listLiveAdTagDetails(request);
    }

    public final ListLiveAdTagDetailsPagedResponse listLiveAdTagDetails(ListLiveAdTagDetailsRequest request) {
        return (ListLiveAdTagDetailsPagedResponse)((Object)this.listLiveAdTagDetailsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListLiveAdTagDetailsRequest, ListLiveAdTagDetailsPagedResponse> listLiveAdTagDetailsPagedCallable() {
        return this.stub.listLiveAdTagDetailsPagedCallable();
    }

    public final UnaryCallable<ListLiveAdTagDetailsRequest, ListLiveAdTagDetailsResponse> listLiveAdTagDetailsCallable() {
        return this.stub.listLiveAdTagDetailsCallable();
    }

    public final LiveAdTagDetail getLiveAdTagDetail(LiveAdTagDetailName name) {
        GetLiveAdTagDetailRequest request = GetLiveAdTagDetailRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getLiveAdTagDetail(request);
    }

    public final LiveAdTagDetail getLiveAdTagDetail(String name) {
        GetLiveAdTagDetailRequest request = GetLiveAdTagDetailRequest.newBuilder().setName(name).build();
        return this.getLiveAdTagDetail(request);
    }

    public final LiveAdTagDetail getLiveAdTagDetail(GetLiveAdTagDetailRequest request) {
        return (LiveAdTagDetail)this.getLiveAdTagDetailCallable().call((Object)request);
    }

    public final UnaryCallable<GetLiveAdTagDetailRequest, LiveAdTagDetail> getLiveAdTagDetailCallable() {
        return this.stub.getLiveAdTagDetailCallable();
    }

    public final OperationFuture<Slate, OperationMetadata> createSlateAsync(LocationName parent, Slate slate, String slateId) {
        CreateSlateRequest request = CreateSlateRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setSlate(slate).setSlateId(slateId).build();
        return this.createSlateAsync(request);
    }

    public final OperationFuture<Slate, OperationMetadata> createSlateAsync(String parent, Slate slate, String slateId) {
        CreateSlateRequest request = CreateSlateRequest.newBuilder().setParent(parent).setSlate(slate).setSlateId(slateId).build();
        return this.createSlateAsync(request);
    }

    public final OperationFuture<Slate, OperationMetadata> createSlateAsync(CreateSlateRequest request) {
        return this.createSlateOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<CreateSlateRequest, Slate, OperationMetadata> createSlateOperationCallable() {
        return this.stub.createSlateOperationCallable();
    }

    public final UnaryCallable<CreateSlateRequest, Operation> createSlateCallable() {
        return this.stub.createSlateCallable();
    }

    public final ListSlatesPagedResponse listSlates(LocationName parent) {
        ListSlatesRequest request = ListSlatesRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listSlates(request);
    }

    public final ListSlatesPagedResponse listSlates(String parent) {
        ListSlatesRequest request = ListSlatesRequest.newBuilder().setParent(parent).build();
        return this.listSlates(request);
    }

    public final ListSlatesPagedResponse listSlates(ListSlatesRequest request) {
        return (ListSlatesPagedResponse)((Object)this.listSlatesPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListSlatesRequest, ListSlatesPagedResponse> listSlatesPagedCallable() {
        return this.stub.listSlatesPagedCallable();
    }

    public final UnaryCallable<ListSlatesRequest, ListSlatesResponse> listSlatesCallable() {
        return this.stub.listSlatesCallable();
    }

    public final Slate getSlate(SlateName name) {
        GetSlateRequest request = GetSlateRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getSlate(request);
    }

    public final Slate getSlate(String name) {
        GetSlateRequest request = GetSlateRequest.newBuilder().setName(name).build();
        return this.getSlate(request);
    }

    public final Slate getSlate(GetSlateRequest request) {
        return (Slate)this.getSlateCallable().call((Object)request);
    }

    public final UnaryCallable<GetSlateRequest, Slate> getSlateCallable() {
        return this.stub.getSlateCallable();
    }

    public final OperationFuture<Slate, OperationMetadata> updateSlateAsync(Slate slate, FieldMask updateMask) {
        UpdateSlateRequest request = UpdateSlateRequest.newBuilder().setSlate(slate).setUpdateMask(updateMask).build();
        return this.updateSlateAsync(request);
    }

    public final OperationFuture<Slate, OperationMetadata> updateSlateAsync(UpdateSlateRequest request) {
        return this.updateSlateOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<UpdateSlateRequest, Slate, OperationMetadata> updateSlateOperationCallable() {
        return this.stub.updateSlateOperationCallable();
    }

    public final UnaryCallable<UpdateSlateRequest, Operation> updateSlateCallable() {
        return this.stub.updateSlateCallable();
    }

    public final OperationFuture<Empty, OperationMetadata> deleteSlateAsync(SlateName name) {
        DeleteSlateRequest request = DeleteSlateRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.deleteSlateAsync(request);
    }

    public final OperationFuture<Empty, OperationMetadata> deleteSlateAsync(String name) {
        DeleteSlateRequest request = DeleteSlateRequest.newBuilder().setName(name).build();
        return this.deleteSlateAsync(request);
    }

    public final OperationFuture<Empty, OperationMetadata> deleteSlateAsync(DeleteSlateRequest request) {
        return this.deleteSlateOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<DeleteSlateRequest, Empty, OperationMetadata> deleteSlateOperationCallable() {
        return this.stub.deleteSlateOperationCallable();
    }

    public final UnaryCallable<DeleteSlateRequest, Operation> deleteSlateCallable() {
        return this.stub.deleteSlateCallable();
    }

    public final LiveSession createLiveSession(LiveSessionName parent, LiveSession liveSession) {
        CreateLiveSessionRequest request = CreateLiveSessionRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setLiveSession(liveSession).build();
        return this.createLiveSession(request);
    }

    public final LiveSession createLiveSession(String parent, LiveSession liveSession) {
        CreateLiveSessionRequest request = CreateLiveSessionRequest.newBuilder().setParent(parent).setLiveSession(liveSession).build();
        return this.createLiveSession(request);
    }

    public final LiveSession createLiveSession(CreateLiveSessionRequest request) {
        return (LiveSession)this.createLiveSessionCallable().call((Object)request);
    }

    public final UnaryCallable<CreateLiveSessionRequest, LiveSession> createLiveSessionCallable() {
        return this.stub.createLiveSessionCallable();
    }

    public final LiveSession getLiveSession(LiveSessionName name) {
        GetLiveSessionRequest request = GetLiveSessionRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getLiveSession(request);
    }

    public final LiveSession getLiveSession(String name) {
        GetLiveSessionRequest request = GetLiveSessionRequest.newBuilder().setName(name).build();
        return this.getLiveSession(request);
    }

    public final LiveSession getLiveSession(GetLiveSessionRequest request) {
        return (LiveSession)this.getLiveSessionCallable().call((Object)request);
    }

    public final UnaryCallable<GetLiveSessionRequest, LiveSession> getLiveSessionCallable() {
        return this.stub.getLiveSessionCallable();
    }

    public final OperationFuture<LiveConfig, OperationMetadata> createLiveConfigAsync(LocationName parent, LiveConfig liveConfig, String liveConfigId) {
        CreateLiveConfigRequest request = CreateLiveConfigRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setLiveConfig(liveConfig).setLiveConfigId(liveConfigId).build();
        return this.createLiveConfigAsync(request);
    }

    public final OperationFuture<LiveConfig, OperationMetadata> createLiveConfigAsync(String parent, LiveConfig liveConfig, String liveConfigId) {
        CreateLiveConfigRequest request = CreateLiveConfigRequest.newBuilder().setParent(parent).setLiveConfig(liveConfig).setLiveConfigId(liveConfigId).build();
        return this.createLiveConfigAsync(request);
    }

    public final OperationFuture<LiveConfig, OperationMetadata> createLiveConfigAsync(CreateLiveConfigRequest request) {
        return this.createLiveConfigOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<CreateLiveConfigRequest, LiveConfig, OperationMetadata> createLiveConfigOperationCallable() {
        return this.stub.createLiveConfigOperationCallable();
    }

    public final UnaryCallable<CreateLiveConfigRequest, Operation> createLiveConfigCallable() {
        return this.stub.createLiveConfigCallable();
    }

    public final ListLiveConfigsPagedResponse listLiveConfigs(LocationName parent) {
        ListLiveConfigsRequest request = ListLiveConfigsRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listLiveConfigs(request);
    }

    public final ListLiveConfigsPagedResponse listLiveConfigs(String parent) {
        ListLiveConfigsRequest request = ListLiveConfigsRequest.newBuilder().setParent(parent).build();
        return this.listLiveConfigs(request);
    }

    public final ListLiveConfigsPagedResponse listLiveConfigs(ListLiveConfigsRequest request) {
        return (ListLiveConfigsPagedResponse)((Object)this.listLiveConfigsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListLiveConfigsRequest, ListLiveConfigsPagedResponse> listLiveConfigsPagedCallable() {
        return this.stub.listLiveConfigsPagedCallable();
    }

    public final UnaryCallable<ListLiveConfigsRequest, ListLiveConfigsResponse> listLiveConfigsCallable() {
        return this.stub.listLiveConfigsCallable();
    }

    public final LiveConfig getLiveConfig(LiveConfigName name) {
        GetLiveConfigRequest request = GetLiveConfigRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getLiveConfig(request);
    }

    public final LiveConfig getLiveConfig(String name) {
        GetLiveConfigRequest request = GetLiveConfigRequest.newBuilder().setName(name).build();
        return this.getLiveConfig(request);
    }

    public final LiveConfig getLiveConfig(GetLiveConfigRequest request) {
        return (LiveConfig)this.getLiveConfigCallable().call((Object)request);
    }

    public final UnaryCallable<GetLiveConfigRequest, LiveConfig> getLiveConfigCallable() {
        return this.stub.getLiveConfigCallable();
    }

    public final OperationFuture<Empty, OperationMetadata> deleteLiveConfigAsync(LiveConfigName name) {
        DeleteLiveConfigRequest request = DeleteLiveConfigRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.deleteLiveConfigAsync(request);
    }

    public final OperationFuture<Empty, OperationMetadata> deleteLiveConfigAsync(String name) {
        DeleteLiveConfigRequest request = DeleteLiveConfigRequest.newBuilder().setName(name).build();
        return this.deleteLiveConfigAsync(request);
    }

    public final OperationFuture<Empty, OperationMetadata> deleteLiveConfigAsync(DeleteLiveConfigRequest request) {
        return this.deleteLiveConfigOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<DeleteLiveConfigRequest, Empty, OperationMetadata> deleteLiveConfigOperationCallable() {
        return this.stub.deleteLiveConfigOperationCallable();
    }

    public final UnaryCallable<DeleteLiveConfigRequest, Operation> deleteLiveConfigCallable() {
        return this.stub.deleteLiveConfigCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class ListLiveConfigsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListLiveConfigsRequest, ListLiveConfigsResponse, LiveConfig, ListLiveConfigsPage, ListLiveConfigsFixedSizeCollection> {
        private ListLiveConfigsFixedSizeCollection(List<ListLiveConfigsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListLiveConfigsFixedSizeCollection createEmptyCollection() {
            return new ListLiveConfigsFixedSizeCollection(null, 0);
        }

        protected ListLiveConfigsFixedSizeCollection createCollection(List<ListLiveConfigsPage> pages, int collectionSize) {
            return new ListLiveConfigsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListLiveConfigsPage
    extends AbstractPage<ListLiveConfigsRequest, ListLiveConfigsResponse, LiveConfig, ListLiveConfigsPage> {
        private ListLiveConfigsPage(PageContext<ListLiveConfigsRequest, ListLiveConfigsResponse, LiveConfig> context, ListLiveConfigsResponse response) {
            super(context, (Object)response);
        }

        private static ListLiveConfigsPage createEmptyPage() {
            return new ListLiveConfigsPage(null, null);
        }

        protected ListLiveConfigsPage createPage(PageContext<ListLiveConfigsRequest, ListLiveConfigsResponse, LiveConfig> context, ListLiveConfigsResponse response) {
            return new ListLiveConfigsPage(context, response);
        }

        public ApiFuture<ListLiveConfigsPage> createPageAsync(PageContext<ListLiveConfigsRequest, ListLiveConfigsResponse, LiveConfig> context, ApiFuture<ListLiveConfigsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListLiveConfigsPagedResponse
    extends AbstractPagedListResponse<ListLiveConfigsRequest, ListLiveConfigsResponse, LiveConfig, ListLiveConfigsPage, ListLiveConfigsFixedSizeCollection> {
        public static ApiFuture<ListLiveConfigsPagedResponse> createAsync(PageContext<ListLiveConfigsRequest, ListLiveConfigsResponse, LiveConfig> context, ApiFuture<ListLiveConfigsResponse> futureResponse) {
            ApiFuture<ListLiveConfigsPage> futurePage = ListLiveConfigsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListLiveConfigsPagedResponse((ListLiveConfigsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListLiveConfigsPagedResponse(ListLiveConfigsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListLiveConfigsFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListSlatesFixedSizeCollection
    extends AbstractFixedSizeCollection<ListSlatesRequest, ListSlatesResponse, Slate, ListSlatesPage, ListSlatesFixedSizeCollection> {
        private ListSlatesFixedSizeCollection(List<ListSlatesPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListSlatesFixedSizeCollection createEmptyCollection() {
            return new ListSlatesFixedSizeCollection(null, 0);
        }

        protected ListSlatesFixedSizeCollection createCollection(List<ListSlatesPage> pages, int collectionSize) {
            return new ListSlatesFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListSlatesPage
    extends AbstractPage<ListSlatesRequest, ListSlatesResponse, Slate, ListSlatesPage> {
        private ListSlatesPage(PageContext<ListSlatesRequest, ListSlatesResponse, Slate> context, ListSlatesResponse response) {
            super(context, (Object)response);
        }

        private static ListSlatesPage createEmptyPage() {
            return new ListSlatesPage(null, null);
        }

        protected ListSlatesPage createPage(PageContext<ListSlatesRequest, ListSlatesResponse, Slate> context, ListSlatesResponse response) {
            return new ListSlatesPage(context, response);
        }

        public ApiFuture<ListSlatesPage> createPageAsync(PageContext<ListSlatesRequest, ListSlatesResponse, Slate> context, ApiFuture<ListSlatesResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListSlatesPagedResponse
    extends AbstractPagedListResponse<ListSlatesRequest, ListSlatesResponse, Slate, ListSlatesPage, ListSlatesFixedSizeCollection> {
        public static ApiFuture<ListSlatesPagedResponse> createAsync(PageContext<ListSlatesRequest, ListSlatesResponse, Slate> context, ApiFuture<ListSlatesResponse> futureResponse) {
            ApiFuture<ListSlatesPage> futurePage = ListSlatesPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListSlatesPagedResponse((ListSlatesPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListSlatesPagedResponse(ListSlatesPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListSlatesFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListLiveAdTagDetailsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListLiveAdTagDetailsRequest, ListLiveAdTagDetailsResponse, LiveAdTagDetail, ListLiveAdTagDetailsPage, ListLiveAdTagDetailsFixedSizeCollection> {
        private ListLiveAdTagDetailsFixedSizeCollection(List<ListLiveAdTagDetailsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListLiveAdTagDetailsFixedSizeCollection createEmptyCollection() {
            return new ListLiveAdTagDetailsFixedSizeCollection(null, 0);
        }

        protected ListLiveAdTagDetailsFixedSizeCollection createCollection(List<ListLiveAdTagDetailsPage> pages, int collectionSize) {
            return new ListLiveAdTagDetailsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListLiveAdTagDetailsPage
    extends AbstractPage<ListLiveAdTagDetailsRequest, ListLiveAdTagDetailsResponse, LiveAdTagDetail, ListLiveAdTagDetailsPage> {
        private ListLiveAdTagDetailsPage(PageContext<ListLiveAdTagDetailsRequest, ListLiveAdTagDetailsResponse, LiveAdTagDetail> context, ListLiveAdTagDetailsResponse response) {
            super(context, (Object)response);
        }

        private static ListLiveAdTagDetailsPage createEmptyPage() {
            return new ListLiveAdTagDetailsPage(null, null);
        }

        protected ListLiveAdTagDetailsPage createPage(PageContext<ListLiveAdTagDetailsRequest, ListLiveAdTagDetailsResponse, LiveAdTagDetail> context, ListLiveAdTagDetailsResponse response) {
            return new ListLiveAdTagDetailsPage(context, response);
        }

        public ApiFuture<ListLiveAdTagDetailsPage> createPageAsync(PageContext<ListLiveAdTagDetailsRequest, ListLiveAdTagDetailsResponse, LiveAdTagDetail> context, ApiFuture<ListLiveAdTagDetailsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListLiveAdTagDetailsPagedResponse
    extends AbstractPagedListResponse<ListLiveAdTagDetailsRequest, ListLiveAdTagDetailsResponse, LiveAdTagDetail, ListLiveAdTagDetailsPage, ListLiveAdTagDetailsFixedSizeCollection> {
        public static ApiFuture<ListLiveAdTagDetailsPagedResponse> createAsync(PageContext<ListLiveAdTagDetailsRequest, ListLiveAdTagDetailsResponse, LiveAdTagDetail> context, ApiFuture<ListLiveAdTagDetailsResponse> futureResponse) {
            ApiFuture<ListLiveAdTagDetailsPage> futurePage = ListLiveAdTagDetailsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListLiveAdTagDetailsPagedResponse((ListLiveAdTagDetailsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListLiveAdTagDetailsPagedResponse(ListLiveAdTagDetailsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListLiveAdTagDetailsFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListVodAdTagDetailsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListVodAdTagDetailsRequest, ListVodAdTagDetailsResponse, VodAdTagDetail, ListVodAdTagDetailsPage, ListVodAdTagDetailsFixedSizeCollection> {
        private ListVodAdTagDetailsFixedSizeCollection(List<ListVodAdTagDetailsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListVodAdTagDetailsFixedSizeCollection createEmptyCollection() {
            return new ListVodAdTagDetailsFixedSizeCollection(null, 0);
        }

        protected ListVodAdTagDetailsFixedSizeCollection createCollection(List<ListVodAdTagDetailsPage> pages, int collectionSize) {
            return new ListVodAdTagDetailsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListVodAdTagDetailsPage
    extends AbstractPage<ListVodAdTagDetailsRequest, ListVodAdTagDetailsResponse, VodAdTagDetail, ListVodAdTagDetailsPage> {
        private ListVodAdTagDetailsPage(PageContext<ListVodAdTagDetailsRequest, ListVodAdTagDetailsResponse, VodAdTagDetail> context, ListVodAdTagDetailsResponse response) {
            super(context, (Object)response);
        }

        private static ListVodAdTagDetailsPage createEmptyPage() {
            return new ListVodAdTagDetailsPage(null, null);
        }

        protected ListVodAdTagDetailsPage createPage(PageContext<ListVodAdTagDetailsRequest, ListVodAdTagDetailsResponse, VodAdTagDetail> context, ListVodAdTagDetailsResponse response) {
            return new ListVodAdTagDetailsPage(context, response);
        }

        public ApiFuture<ListVodAdTagDetailsPage> createPageAsync(PageContext<ListVodAdTagDetailsRequest, ListVodAdTagDetailsResponse, VodAdTagDetail> context, ApiFuture<ListVodAdTagDetailsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListVodAdTagDetailsPagedResponse
    extends AbstractPagedListResponse<ListVodAdTagDetailsRequest, ListVodAdTagDetailsResponse, VodAdTagDetail, ListVodAdTagDetailsPage, ListVodAdTagDetailsFixedSizeCollection> {
        public static ApiFuture<ListVodAdTagDetailsPagedResponse> createAsync(PageContext<ListVodAdTagDetailsRequest, ListVodAdTagDetailsResponse, VodAdTagDetail> context, ApiFuture<ListVodAdTagDetailsResponse> futureResponse) {
            ApiFuture<ListVodAdTagDetailsPage> futurePage = ListVodAdTagDetailsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListVodAdTagDetailsPagedResponse((ListVodAdTagDetailsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListVodAdTagDetailsPagedResponse(ListVodAdTagDetailsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListVodAdTagDetailsFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListVodStitchDetailsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListVodStitchDetailsRequest, ListVodStitchDetailsResponse, VodStitchDetail, ListVodStitchDetailsPage, ListVodStitchDetailsFixedSizeCollection> {
        private ListVodStitchDetailsFixedSizeCollection(List<ListVodStitchDetailsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListVodStitchDetailsFixedSizeCollection createEmptyCollection() {
            return new ListVodStitchDetailsFixedSizeCollection(null, 0);
        }

        protected ListVodStitchDetailsFixedSizeCollection createCollection(List<ListVodStitchDetailsPage> pages, int collectionSize) {
            return new ListVodStitchDetailsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListVodStitchDetailsPage
    extends AbstractPage<ListVodStitchDetailsRequest, ListVodStitchDetailsResponse, VodStitchDetail, ListVodStitchDetailsPage> {
        private ListVodStitchDetailsPage(PageContext<ListVodStitchDetailsRequest, ListVodStitchDetailsResponse, VodStitchDetail> context, ListVodStitchDetailsResponse response) {
            super(context, (Object)response);
        }

        private static ListVodStitchDetailsPage createEmptyPage() {
            return new ListVodStitchDetailsPage(null, null);
        }

        protected ListVodStitchDetailsPage createPage(PageContext<ListVodStitchDetailsRequest, ListVodStitchDetailsResponse, VodStitchDetail> context, ListVodStitchDetailsResponse response) {
            return new ListVodStitchDetailsPage(context, response);
        }

        public ApiFuture<ListVodStitchDetailsPage> createPageAsync(PageContext<ListVodStitchDetailsRequest, ListVodStitchDetailsResponse, VodStitchDetail> context, ApiFuture<ListVodStitchDetailsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListVodStitchDetailsPagedResponse
    extends AbstractPagedListResponse<ListVodStitchDetailsRequest, ListVodStitchDetailsResponse, VodStitchDetail, ListVodStitchDetailsPage, ListVodStitchDetailsFixedSizeCollection> {
        public static ApiFuture<ListVodStitchDetailsPagedResponse> createAsync(PageContext<ListVodStitchDetailsRequest, ListVodStitchDetailsResponse, VodStitchDetail> context, ApiFuture<ListVodStitchDetailsResponse> futureResponse) {
            ApiFuture<ListVodStitchDetailsPage> futurePage = ListVodStitchDetailsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListVodStitchDetailsPagedResponse((ListVodStitchDetailsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListVodStitchDetailsPagedResponse(ListVodStitchDetailsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListVodStitchDetailsFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListCdnKeysFixedSizeCollection
    extends AbstractFixedSizeCollection<ListCdnKeysRequest, ListCdnKeysResponse, CdnKey, ListCdnKeysPage, ListCdnKeysFixedSizeCollection> {
        private ListCdnKeysFixedSizeCollection(List<ListCdnKeysPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListCdnKeysFixedSizeCollection createEmptyCollection() {
            return new ListCdnKeysFixedSizeCollection(null, 0);
        }

        protected ListCdnKeysFixedSizeCollection createCollection(List<ListCdnKeysPage> pages, int collectionSize) {
            return new ListCdnKeysFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListCdnKeysPage
    extends AbstractPage<ListCdnKeysRequest, ListCdnKeysResponse, CdnKey, ListCdnKeysPage> {
        private ListCdnKeysPage(PageContext<ListCdnKeysRequest, ListCdnKeysResponse, CdnKey> context, ListCdnKeysResponse response) {
            super(context, (Object)response);
        }

        private static ListCdnKeysPage createEmptyPage() {
            return new ListCdnKeysPage(null, null);
        }

        protected ListCdnKeysPage createPage(PageContext<ListCdnKeysRequest, ListCdnKeysResponse, CdnKey> context, ListCdnKeysResponse response) {
            return new ListCdnKeysPage(context, response);
        }

        public ApiFuture<ListCdnKeysPage> createPageAsync(PageContext<ListCdnKeysRequest, ListCdnKeysResponse, CdnKey> context, ApiFuture<ListCdnKeysResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListCdnKeysPagedResponse
    extends AbstractPagedListResponse<ListCdnKeysRequest, ListCdnKeysResponse, CdnKey, ListCdnKeysPage, ListCdnKeysFixedSizeCollection> {
        public static ApiFuture<ListCdnKeysPagedResponse> createAsync(PageContext<ListCdnKeysRequest, ListCdnKeysResponse, CdnKey> context, ApiFuture<ListCdnKeysResponse> futureResponse) {
            ApiFuture<ListCdnKeysPage> futurePage = ListCdnKeysPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListCdnKeysPagedResponse((ListCdnKeysPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListCdnKeysPagedResponse(ListCdnKeysPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListCdnKeysFixedSizeCollection.createEmptyCollection());
        }
    }
}

