/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.vertexai.api.stub;

import com.google.api.HttpBody;
import com.google.api.core.InternalApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.core.BackgroundResourceAggregation;
import com.google.api.gax.httpjson.ApiMethodDescriptor;
import com.google.api.gax.httpjson.HttpJsonCallSettings;
import com.google.api.gax.httpjson.HttpJsonStubCallableFactory;
import com.google.api.gax.httpjson.HttpRequestFormatter;
import com.google.api.gax.httpjson.HttpResponseParser;
import com.google.api.gax.httpjson.ProtoMessageRequestFormatter;
import com.google.api.gax.httpjson.ProtoMessageResponseParser;
import com.google.api.gax.httpjson.ProtoRestSerializer;
import com.google.api.gax.rpc.BidiStreamingCallable;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.RequestParamsBuilder;
import com.google.api.gax.rpc.ServerStreamingCallable;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.location.GetLocationRequest;
import com.google.cloud.location.ListLocationsRequest;
import com.google.cloud.location.ListLocationsResponse;
import com.google.cloud.location.Location;
import com.google.cloud.vertexai.api.DirectPredictRequest;
import com.google.cloud.vertexai.api.DirectPredictResponse;
import com.google.cloud.vertexai.api.DirectRawPredictRequest;
import com.google.cloud.vertexai.api.DirectRawPredictResponse;
import com.google.cloud.vertexai.api.EmbedContentRequest;
import com.google.cloud.vertexai.api.EmbedContentResponse;
import com.google.cloud.vertexai.api.ExplainRequest;
import com.google.cloud.vertexai.api.ExplainResponse;
import com.google.cloud.vertexai.api.GenerateContentRequest;
import com.google.cloud.vertexai.api.GenerateContentResponse;
import com.google.cloud.vertexai.api.PredictRequest;
import com.google.cloud.vertexai.api.PredictResponse;
import com.google.cloud.vertexai.api.PredictionServiceClient;
import com.google.cloud.vertexai.api.RawPredictRequest;
import com.google.cloud.vertexai.api.StreamDirectPredictRequest;
import com.google.cloud.vertexai.api.StreamDirectPredictResponse;
import com.google.cloud.vertexai.api.StreamDirectRawPredictRequest;
import com.google.cloud.vertexai.api.StreamDirectRawPredictResponse;
import com.google.cloud.vertexai.api.StreamRawPredictRequest;
import com.google.cloud.vertexai.api.StreamingPredictRequest;
import com.google.cloud.vertexai.api.StreamingPredictResponse;
import com.google.cloud.vertexai.api.StreamingRawPredictRequest;
import com.google.cloud.vertexai.api.StreamingRawPredictResponse;
import com.google.cloud.vertexai.api.stub.HttpJsonPredictionServiceCallableFactory;
import com.google.cloud.vertexai.api.stub.PredictionServiceStub;
import com.google.cloud.vertexai.api.stub.PredictionServiceStubSettings;
import com.google.iam.v1.GetIamPolicyRequest;
import com.google.iam.v1.Policy;
import com.google.iam.v1.SetIamPolicyRequest;
import com.google.iam.v1.TestIamPermissionsRequest;
import com.google.iam.v1.TestIamPermissionsResponse;
import com.google.protobuf.Message;
import com.google.protobuf.TypeRegistry;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.TimeUnit;

public class HttpJsonPredictionServiceStub
extends PredictionServiceStub {
    private static final TypeRegistry typeRegistry = TypeRegistry.newBuilder().build();
    private static final ApiMethodDescriptor<PredictRequest, PredictResponse> predictMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.aiplatform.v1.PredictionService/Predict").setHttpMethod("POST").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{endpoint=projects/*/locations/*/endpoints/*}:predict", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "endpoint", (Object)request.getEndpoint());
        return fields;
    }).setAdditionalPaths(new String[]{"/v1/{endpoint=projects/*/locations/*/publishers/*/models/*}:predict"}).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("*", (Message)request.toBuilder().clearEndpoint().build(), true)).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)PredictResponse.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<RawPredictRequest, HttpBody> rawPredictMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.aiplatform.v1.PredictionService/RawPredict").setHttpMethod("POST").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{endpoint=projects/*/locations/*/endpoints/*}:rawPredict", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "endpoint", (Object)request.getEndpoint());
        return fields;
    }).setAdditionalPaths(new String[]{"/v1/{endpoint=projects/*/locations/*/publishers/*/models/*}:rawPredict"}).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("*", (Message)request.toBuilder().clearEndpoint().build(), true)).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)HttpBody.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<StreamRawPredictRequest, HttpBody> streamRawPredictMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.aiplatform.v1.PredictionService/StreamRawPredict").setHttpMethod("POST").setType(ApiMethodDescriptor.MethodType.SERVER_STREAMING).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{endpoint=projects/*/locations/*/endpoints/*}:streamRawPredict", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "endpoint", (Object)request.getEndpoint());
        return fields;
    }).setAdditionalPaths(new String[]{"/v1/{endpoint=projects/*/locations/*/publishers/*/models/*}:streamRawPredict"}).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("*", (Message)request.toBuilder().clearEndpoint().build(), true)).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)HttpBody.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<DirectPredictRequest, DirectPredictResponse> directPredictMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.aiplatform.v1.PredictionService/DirectPredict").setHttpMethod("POST").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{endpoint=projects/*/locations/*/endpoints/*}:directPredict", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "endpoint", (Object)request.getEndpoint());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("*", (Message)request.toBuilder().clearEndpoint().build(), true)).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)DirectPredictResponse.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<DirectRawPredictRequest, DirectRawPredictResponse> directRawPredictMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.aiplatform.v1.PredictionService/DirectRawPredict").setHttpMethod("POST").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{endpoint=projects/*/locations/*/endpoints/*}:directRawPredict", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "endpoint", (Object)request.getEndpoint());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("*", (Message)request.toBuilder().clearEndpoint().build(), true)).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)DirectRawPredictResponse.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<StreamingPredictRequest, StreamingPredictResponse> serverStreamingPredictMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.aiplatform.v1.PredictionService/ServerStreamingPredict").setHttpMethod("POST").setType(ApiMethodDescriptor.MethodType.SERVER_STREAMING).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{endpoint=projects/*/locations/*/endpoints/*}:serverStreamingPredict", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "endpoint", (Object)request.getEndpoint());
        return fields;
    }).setAdditionalPaths(new String[]{"/v1/{endpoint=projects/*/locations/*/publishers/*/models/*}:serverStreamingPredict"}).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("*", (Message)request.toBuilder().clearEndpoint().build(), true)).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)StreamingPredictResponse.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<ExplainRequest, ExplainResponse> explainMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.aiplatform.v1.PredictionService/Explain").setHttpMethod("POST").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{endpoint=projects/*/locations/*/endpoints/*}:explain", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "endpoint", (Object)request.getEndpoint());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("*", (Message)request.toBuilder().clearEndpoint().build(), true)).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)ExplainResponse.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<GenerateContentRequest, GenerateContentResponse> generateContentMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.aiplatform.v1.PredictionService/GenerateContent").setHttpMethod("POST").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{model=projects/*/locations/*/endpoints/*}:generateContent", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "model", (Object)request.getModel());
        return fields;
    }).setAdditionalPaths(new String[]{"/v1/{model=projects/*/locations/*/publishers/*/models/*}:generateContent", "/v1/{model=endpoints/*}:generateContent", "/v1/{model=publishers/*/models/*}:generateContent"}).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("*", (Message)request.toBuilder().clearModel().build(), true)).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)GenerateContentResponse.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<GenerateContentRequest, GenerateContentResponse> streamGenerateContentMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.aiplatform.v1.PredictionService/StreamGenerateContent").setHttpMethod("POST").setType(ApiMethodDescriptor.MethodType.SERVER_STREAMING).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{model=projects/*/locations/*/endpoints/*}:streamGenerateContent", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "model", (Object)request.getModel());
        return fields;
    }).setAdditionalPaths(new String[]{"/v1/{model=projects/*/locations/*/publishers/*/models/*}:streamGenerateContent", "/v1/{model=endpoints/*}:streamGenerateContent", "/v1/{model=publishers/*/models/*}:streamGenerateContent"}).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("*", (Message)request.toBuilder().clearModel().build(), true)).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)GenerateContentResponse.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<EmbedContentRequest, EmbedContentResponse> embedContentMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.aiplatform.v1.PredictionService/EmbedContent").setHttpMethod("POST").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{model=projects/*/locations/*/publishers/*/models/*}:embedContent", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        if (request.hasModel()) {
            serializer.putPathParam(fields, "model", (Object)request.getModel());
        }
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("*", (Message)request.toBuilder().clearModel().build(), true)).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)EmbedContentResponse.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<ListLocationsRequest, ListLocationsResponse> listLocationsMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.location.Locations/ListLocations").setHttpMethod("GET").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/ui/{name=projects/*}/locations", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "name", (Object)request.getName());
        return fields;
    }).setAdditionalPaths(new String[]{"/v1/{name=projects/*}/locations"}).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)ListLocationsResponse.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<GetLocationRequest, Location> getLocationMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.location.Locations/GetLocation").setHttpMethod("GET").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/ui/{name=projects/*/locations/*}", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "name", (Object)request.getName());
        return fields;
    }).setAdditionalPaths(new String[]{"/v1/{name=projects/*/locations/*}"}).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Location.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<SetIamPolicyRequest, Policy> setIamPolicyMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.iam.v1.IAMPolicy/SetIamPolicy").setHttpMethod("POST").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{resource=projects/*/locations/*/featurestores/*}:setIamPolicy", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "resource", (Object)request.getResource());
        return fields;
    }).setAdditionalPaths(new String[]{"/v1/{resource=projects/*/locations/*/featurestores/*/entityTypes/*}:setIamPolicy", "/v1/{resource=projects/*/locations/*/models/*}:setIamPolicy", "/v1/{resource=projects/*/locations/*/notebookRuntimeTemplates/*}:setIamPolicy", "/v1/{resource=projects/*/locations/*/featureOnlineStores/*}:setIamPolicy", "/v1/{resource=projects/*/locations/*/featureOnlineStores/*/featureViews/*}:setIamPolicy", "/ui/{resource=projects/*/locations/*/featurestores/*}:setIamPolicy", "/ui/{resource=projects/*/locations/*/featurestores/*/entityTypes/*}:setIamPolicy", "/ui/{resource=projects/*/locations/*/models/*}:setIamPolicy", "/ui/{resource=projects/*/locations/*/endpoints/*}:setIamPolicy", "/ui/{resource=projects/*/locations/*/notebookRuntimeTemplates/*}:setIamPolicy", "/ui/{resource=projects/*/locations/*/featureOnlineStores/*}:setIamPolicy", "/ui/{resource=projects/*/locations/*/featureOnlineStores/*/featureViews/*}:setIamPolicy", "/ui/{resource=projects/*/locations/*/featureGroups/*}:setIamPolicy"}).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("*", (Message)request.toBuilder().clearResource().build(), true)).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Policy.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<GetIamPolicyRequest, Policy> getIamPolicyMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.iam.v1.IAMPolicy/GetIamPolicy").setHttpMethod("POST").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{resource=projects/*/locations/*/featurestores/*}:getIamPolicy", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "resource", (Object)request.getResource());
        return fields;
    }).setAdditionalPaths(new String[]{"/v1/{resource=projects/*/locations/*/featurestores/*/entityTypes/*}:getIamPolicy", "/v1/{resource=projects/*/locations/*/models/*}:getIamPolicy", "/v1/{resource=projects/*/locations/*/notebookRuntimeTemplates/*}:getIamPolicy", "/v1/{resource=projects/*/locations/*/featureOnlineStores/*}:getIamPolicy", "/v1/{resource=projects/*/locations/*/featureOnlineStores/*/featureViews/*}:getIamPolicy", "/ui/{resource=projects/*/locations/*/featurestores/*}:getIamPolicy", "/ui/{resource=projects/*/locations/*/featurestores/*/entityTypes/*}:getIamPolicy", "/ui/{resource=projects/*/locations/*/models/*}:getIamPolicy", "/ui/{resource=projects/*/locations/*/endpoints/*}:getIamPolicy", "/ui/{resource=projects/*/locations/*/notebookRuntimeTemplates/*}:getIamPolicy", "/ui/{resource=projects/*/locations/*/publishers/*/models/*}:getIamPolicy", "/ui/{resource=projects/*/locations/*/featureOnlineStores/*}:getIamPolicy", "/ui/{resource=projects/*/locations/*/featureOnlineStores/*/featureViews/*}:getIamPolicy", "/ui/{resource=projects/*/locations/*/featureGroups/*}:getIamPolicy"}).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Policy.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.iam.v1.IAMPolicy/TestIamPermissions").setHttpMethod("POST").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{resource=projects/*/locations/*/featurestores/*}:testIamPermissions", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "resource", (Object)request.getResource());
        return fields;
    }).setAdditionalPaths(new String[]{"/v1/{resource=projects/*/locations/*/featurestores/*/entityTypes/*}:testIamPermissions", "/v1/{resource=projects/*/locations/*/models/*}:testIamPermissions", "/v1/{resource=projects/*/locations/*/notebookRuntimeTemplates/*}:testIamPermissions", "/v1/{resource=projects/*/locations/*/featureOnlineStores/*}:testIamPermissions", "/v1/{resource=projects/*/locations/*/featureOnlineStores/*/featureViews/*}:testIamPermissions", "/ui/{resource=projects/*/locations/*/featurestores/*}:testIamPermissions", "/ui/{resource=projects/*/locations/*/featurestores/*/entityTypes/*}:testIamPermissions", "/ui/{resource=projects/*/locations/*/models/*}:testIamPermissions", "/ui/{resource=projects/*/locations/*/endpoints/*}:testIamPermissions", "/ui/{resource=projects/*/locations/*/notebookRuntimeTemplates/*}:testIamPermissions", "/ui/{resource=projects/*/locations/*/featureOnlineStores/*}:testIamPermissions", "/ui/{resource=projects/*/locations/*/featureOnlineStores/*/featureViews/*}:testIamPermissions", "/ui/{resource=projects/*/locations/*/featureGroups/*}:testIamPermissions"}).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)TestIamPermissionsResponse.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private final UnaryCallable<PredictRequest, PredictResponse> predictCallable;
    private final UnaryCallable<RawPredictRequest, HttpBody> rawPredictCallable;
    private final ServerStreamingCallable<StreamRawPredictRequest, HttpBody> streamRawPredictCallable;
    private final UnaryCallable<DirectPredictRequest, DirectPredictResponse> directPredictCallable;
    private final UnaryCallable<DirectRawPredictRequest, DirectRawPredictResponse> directRawPredictCallable;
    private final ServerStreamingCallable<StreamingPredictRequest, StreamingPredictResponse> serverStreamingPredictCallable;
    private final UnaryCallable<ExplainRequest, ExplainResponse> explainCallable;
    private final UnaryCallable<GenerateContentRequest, GenerateContentResponse> generateContentCallable;
    private final ServerStreamingCallable<GenerateContentRequest, GenerateContentResponse> streamGenerateContentCallable;
    private final UnaryCallable<EmbedContentRequest, EmbedContentResponse> embedContentCallable;
    private final UnaryCallable<ListLocationsRequest, ListLocationsResponse> listLocationsCallable;
    private final UnaryCallable<ListLocationsRequest, PredictionServiceClient.ListLocationsPagedResponse> listLocationsPagedCallable;
    private final UnaryCallable<GetLocationRequest, Location> getLocationCallable;
    private final UnaryCallable<SetIamPolicyRequest, Policy> setIamPolicyCallable;
    private final UnaryCallable<GetIamPolicyRequest, Policy> getIamPolicyCallable;
    private final UnaryCallable<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsCallable;
    private final BackgroundResource backgroundResources;
    private final HttpJsonStubCallableFactory callableFactory;

    public static final HttpJsonPredictionServiceStub create(PredictionServiceStubSettings settings) throws IOException {
        return new HttpJsonPredictionServiceStub(settings, ClientContext.create((StubSettings)settings));
    }

    public static final HttpJsonPredictionServiceStub create(ClientContext clientContext) throws IOException {
        return new HttpJsonPredictionServiceStub(PredictionServiceStubSettings.newHttpJsonBuilder().build(), clientContext);
    }

    public static final HttpJsonPredictionServiceStub create(ClientContext clientContext, HttpJsonStubCallableFactory callableFactory) throws IOException {
        return new HttpJsonPredictionServiceStub(PredictionServiceStubSettings.newHttpJsonBuilder().build(), clientContext, callableFactory);
    }

    protected HttpJsonPredictionServiceStub(PredictionServiceStubSettings settings, ClientContext clientContext) throws IOException {
        this(settings, clientContext, new HttpJsonPredictionServiceCallableFactory());
    }

    protected HttpJsonPredictionServiceStub(PredictionServiceStubSettings settings, ClientContext clientContext, HttpJsonStubCallableFactory callableFactory) throws IOException {
        this.callableFactory = callableFactory;
        HttpJsonCallSettings predictTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(predictMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("endpoint", String.valueOf(request.getEndpoint()));
            return builder.build();
        }).build();
        HttpJsonCallSettings rawPredictTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(rawPredictMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("endpoint", String.valueOf(request.getEndpoint()));
            return builder.build();
        }).build();
        HttpJsonCallSettings streamRawPredictTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(streamRawPredictMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("endpoint", String.valueOf(request.getEndpoint()));
            return builder.build();
        }).build();
        HttpJsonCallSettings directPredictTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(directPredictMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("endpoint", String.valueOf(request.getEndpoint()));
            return builder.build();
        }).build();
        HttpJsonCallSettings directRawPredictTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(directRawPredictMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("endpoint", String.valueOf(request.getEndpoint()));
            return builder.build();
        }).build();
        HttpJsonCallSettings serverStreamingPredictTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(serverStreamingPredictMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("endpoint", String.valueOf(request.getEndpoint()));
            return builder.build();
        }).build();
        HttpJsonCallSettings explainTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(explainMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("endpoint", String.valueOf(request.getEndpoint()));
            return builder.build();
        }).build();
        HttpJsonCallSettings generateContentTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(generateContentMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("model", String.valueOf(request.getModel()));
            return builder.build();
        }).build();
        HttpJsonCallSettings streamGenerateContentTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(streamGenerateContentMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("model", String.valueOf(request.getModel()));
            return builder.build();
        }).build();
        HttpJsonCallSettings embedContentTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(embedContentMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("model", String.valueOf(request.getModel()));
            return builder.build();
        }).build();
        HttpJsonCallSettings listLocationsTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(listLocationsMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        HttpJsonCallSettings getLocationTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(getLocationMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        HttpJsonCallSettings setIamPolicyTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(setIamPolicyMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("resource", String.valueOf(request.getResource()));
            return builder.build();
        }).build();
        HttpJsonCallSettings getIamPolicyTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(getIamPolicyMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("resource", String.valueOf(request.getResource()));
            return builder.build();
        }).build();
        HttpJsonCallSettings testIamPermissionsTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(testIamPermissionsMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("resource", String.valueOf(request.getResource()));
            return builder.build();
        }).build();
        this.predictCallable = callableFactory.createUnaryCallable(predictTransportSettings, settings.predictSettings(), clientContext);
        this.rawPredictCallable = callableFactory.createUnaryCallable(rawPredictTransportSettings, settings.rawPredictSettings(), clientContext);
        this.streamRawPredictCallable = callableFactory.createServerStreamingCallable(streamRawPredictTransportSettings, settings.streamRawPredictSettings(), clientContext);
        this.directPredictCallable = callableFactory.createUnaryCallable(directPredictTransportSettings, settings.directPredictSettings(), clientContext);
        this.directRawPredictCallable = callableFactory.createUnaryCallable(directRawPredictTransportSettings, settings.directRawPredictSettings(), clientContext);
        this.serverStreamingPredictCallable = callableFactory.createServerStreamingCallable(serverStreamingPredictTransportSettings, settings.serverStreamingPredictSettings(), clientContext);
        this.explainCallable = callableFactory.createUnaryCallable(explainTransportSettings, settings.explainSettings(), clientContext);
        this.generateContentCallable = callableFactory.createUnaryCallable(generateContentTransportSettings, settings.generateContentSettings(), clientContext);
        this.streamGenerateContentCallable = callableFactory.createServerStreamingCallable(streamGenerateContentTransportSettings, settings.streamGenerateContentSettings(), clientContext);
        this.embedContentCallable = callableFactory.createUnaryCallable(embedContentTransportSettings, settings.embedContentSettings(), clientContext);
        this.listLocationsCallable = callableFactory.createUnaryCallable(listLocationsTransportSettings, settings.listLocationsSettings(), clientContext);
        this.listLocationsPagedCallable = callableFactory.createPagedCallable(listLocationsTransportSettings, settings.listLocationsSettings(), clientContext);
        this.getLocationCallable = callableFactory.createUnaryCallable(getLocationTransportSettings, settings.getLocationSettings(), clientContext);
        this.setIamPolicyCallable = callableFactory.createUnaryCallable(setIamPolicyTransportSettings, settings.setIamPolicySettings(), clientContext);
        this.getIamPolicyCallable = callableFactory.createUnaryCallable(getIamPolicyTransportSettings, settings.getIamPolicySettings(), clientContext);
        this.testIamPermissionsCallable = callableFactory.createUnaryCallable(testIamPermissionsTransportSettings, settings.testIamPermissionsSettings(), clientContext);
        this.backgroundResources = new BackgroundResourceAggregation(clientContext.getBackgroundResources());
    }

    @InternalApi
    public static List<ApiMethodDescriptor> getMethodDescriptors() {
        ArrayList<ApiMethodDescriptor> methodDescriptors = new ArrayList<ApiMethodDescriptor>();
        methodDescriptors.add(predictMethodDescriptor);
        methodDescriptors.add(rawPredictMethodDescriptor);
        methodDescriptors.add(streamRawPredictMethodDescriptor);
        methodDescriptors.add(directPredictMethodDescriptor);
        methodDescriptors.add(directRawPredictMethodDescriptor);
        methodDescriptors.add(serverStreamingPredictMethodDescriptor);
        methodDescriptors.add(explainMethodDescriptor);
        methodDescriptors.add(generateContentMethodDescriptor);
        methodDescriptors.add(streamGenerateContentMethodDescriptor);
        methodDescriptors.add(embedContentMethodDescriptor);
        methodDescriptors.add(listLocationsMethodDescriptor);
        methodDescriptors.add(getLocationMethodDescriptor);
        methodDescriptors.add(setIamPolicyMethodDescriptor);
        methodDescriptors.add(getIamPolicyMethodDescriptor);
        methodDescriptors.add(testIamPermissionsMethodDescriptor);
        return methodDescriptors;
    }

    @Override
    public UnaryCallable<PredictRequest, PredictResponse> predictCallable() {
        return this.predictCallable;
    }

    @Override
    public UnaryCallable<RawPredictRequest, HttpBody> rawPredictCallable() {
        return this.rawPredictCallable;
    }

    @Override
    public ServerStreamingCallable<StreamRawPredictRequest, HttpBody> streamRawPredictCallable() {
        return this.streamRawPredictCallable;
    }

    @Override
    public UnaryCallable<DirectPredictRequest, DirectPredictResponse> directPredictCallable() {
        return this.directPredictCallable;
    }

    @Override
    public UnaryCallable<DirectRawPredictRequest, DirectRawPredictResponse> directRawPredictCallable() {
        return this.directRawPredictCallable;
    }

    @Override
    public ServerStreamingCallable<StreamingPredictRequest, StreamingPredictResponse> serverStreamingPredictCallable() {
        return this.serverStreamingPredictCallable;
    }

    @Override
    public UnaryCallable<ExplainRequest, ExplainResponse> explainCallable() {
        return this.explainCallable;
    }

    @Override
    public UnaryCallable<GenerateContentRequest, GenerateContentResponse> generateContentCallable() {
        return this.generateContentCallable;
    }

    @Override
    public ServerStreamingCallable<GenerateContentRequest, GenerateContentResponse> streamGenerateContentCallable() {
        return this.streamGenerateContentCallable;
    }

    @Override
    public UnaryCallable<EmbedContentRequest, EmbedContentResponse> embedContentCallable() {
        return this.embedContentCallable;
    }

    @Override
    public UnaryCallable<ListLocationsRequest, ListLocationsResponse> listLocationsCallable() {
        return this.listLocationsCallable;
    }

    @Override
    public UnaryCallable<ListLocationsRequest, PredictionServiceClient.ListLocationsPagedResponse> listLocationsPagedCallable() {
        return this.listLocationsPagedCallable;
    }

    @Override
    public UnaryCallable<GetLocationRequest, Location> getLocationCallable() {
        return this.getLocationCallable;
    }

    @Override
    public UnaryCallable<SetIamPolicyRequest, Policy> setIamPolicyCallable() {
        return this.setIamPolicyCallable;
    }

    @Override
    public UnaryCallable<GetIamPolicyRequest, Policy> getIamPolicyCallable() {
        return this.getIamPolicyCallable;
    }

    @Override
    public UnaryCallable<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsCallable() {
        return this.testIamPermissionsCallable;
    }

    @Override
    public BidiStreamingCallable<StreamDirectPredictRequest, StreamDirectPredictResponse> streamDirectPredictCallable() {
        throw new UnsupportedOperationException("Not implemented: streamDirectPredictCallable(). REST transport is not implemented for this method yet.");
    }

    @Override
    public BidiStreamingCallable<StreamDirectRawPredictRequest, StreamDirectRawPredictResponse> streamDirectRawPredictCallable() {
        throw new UnsupportedOperationException("Not implemented: streamDirectRawPredictCallable(). REST transport is not implemented for this method yet.");
    }

    @Override
    public BidiStreamingCallable<StreamingPredictRequest, StreamingPredictResponse> streamingPredictCallable() {
        throw new UnsupportedOperationException("Not implemented: streamingPredictCallable(). REST transport is not implemented for this method yet.");
    }

    @Override
    public BidiStreamingCallable<StreamingRawPredictRequest, StreamingRawPredictResponse> streamingRawPredictCallable() {
        throw new UnsupportedOperationException("Not implemented: streamingRawPredictCallable(). REST transport is not implemented for this method yet.");
    }

    @Override
    public final void close() {
        try {
            this.backgroundResources.close();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to close resource", e);
        }
    }

    public void shutdown() {
        this.backgroundResources.shutdown();
    }

    public boolean isShutdown() {
        return this.backgroundResources.isShutdown();
    }

    public boolean isTerminated() {
        return this.backgroundResources.isTerminated();
    }

    public void shutdownNow() {
        this.backgroundResources.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.backgroundResources.awaitTermination(duration, unit);
    }
}

