/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.vertexai;

import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.FixedCredentialsProvider;
import com.google.api.gax.core.GaxProperties;
import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.api.gax.rpc.FixedHeaderProvider;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.auth.Credentials;
import com.google.cloud.vertexai.Transport;
import com.google.cloud.vertexai.api.LlmUtilityServiceClient;
import com.google.cloud.vertexai.api.LlmUtilityServiceSettings;
import com.google.cloud.vertexai.api.PredictionServiceClient;
import com.google.cloud.vertexai.api.PredictionServiceSettings;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class VertexAI
implements AutoCloseable {
    private final String projectId;
    private final String location;
    private String apiEndpoint;
    private CredentialsProvider credentialsProvider = null;
    private Transport transport = Transport.GRPC;
    private PredictionServiceClient predictionServiceClient = null;
    private PredictionServiceClient predictionServiceRestClient = null;
    private LlmUtilityServiceClient llmUtilityClient = null;
    private LlmUtilityServiceClient llmUtilityRestClient = null;

    public VertexAI(String projectId, String location) {
        this.projectId = projectId;
        this.location = location;
        this.apiEndpoint = String.format("%s-aiplatform.googleapis.com", this.location);
    }

    public VertexAI(String projectId, String location, Transport transport) {
        this(projectId, location);
        this.transport = transport;
    }

    public VertexAI(String projectId, String location, Credentials credentials) {
        this(projectId, location);
        this.credentialsProvider = FixedCredentialsProvider.create((Credentials)credentials);
    }

    public VertexAI(String projectId, String location, Transport transport, Credentials credentials) {
        this(projectId, location, credentials);
        this.transport = transport;
    }

    public VertexAI(String projectId, String location, List<String> scopes) throws IOException {
        this(projectId, location);
        GoogleCredentialsProvider credentialsProvider = scopes.size() == 0 ? null : GoogleCredentialsProvider.newBuilder().setScopesToApply(scopes).setUseJwtAccessWithScope(true).build();
        this.credentialsProvider = credentialsProvider;
    }

    public VertexAI(String projectId, String location, Transport transport, List<String> scopes) throws IOException {
        this(projectId, location, scopes);
        this.transport = transport;
    }

    @Deprecated
    public VertexAI(String projectId, String location, String ... scopes) throws IOException {
        GoogleCredentialsProvider credentialsProvider = scopes.length == 0 ? null : GoogleCredentialsProvider.newBuilder().setScopesToApply(Arrays.asList(scopes)).setUseJwtAccessWithScope(true).build();
        this.projectId = projectId;
        this.location = location;
        this.apiEndpoint = String.format("%s-aiplatform.googleapis.com", this.location);
        this.credentialsProvider = credentialsProvider;
    }

    @Deprecated
    public VertexAI(String projectId, String location, Transport transport, String ... scopes) throws IOException {
        this(projectId, location, scopes);
        this.transport = transport;
    }

    public Transport getTransport() {
        return this.transport;
    }

    public String getProjectId() {
        return this.projectId;
    }

    public String getLocation() {
        return this.location;
    }

    public String getApiEndpoint() {
        return this.apiEndpoint;
    }

    public Credentials getCredentials() throws IOException {
        return this.credentialsProvider.getCredentials();
    }

    public void setTransport(Transport transport) {
        this.transport = transport;
    }

    public void setApiEndpoint(String apiEndpoint) {
        this.apiEndpoint = apiEndpoint;
        if (this.predictionServiceClient != null) {
            this.predictionServiceClient.close();
            this.predictionServiceClient = null;
        }
        if (this.predictionServiceRestClient != null) {
            this.predictionServiceRestClient.close();
            this.predictionServiceRestClient = null;
        }
        if (this.llmUtilityClient != null) {
            this.llmUtilityClient.close();
            this.llmUtilityClient = null;
        }
        if (this.llmUtilityRestClient != null) {
            this.llmUtilityRestClient.close();
            this.llmUtilityRestClient = null;
        }
    }

    public PredictionServiceClient getPredictionServiceClient() throws IOException {
        if (this.predictionServiceClient == null) {
            PredictionServiceSettings.Builder settingsBuilder = PredictionServiceSettings.newBuilder();
            settingsBuilder.setEndpoint(String.format("%s:443", this.apiEndpoint));
            if (this.credentialsProvider != null) {
                settingsBuilder.setCredentialsProvider(this.credentialsProvider);
            }
            FixedHeaderProvider headerProvider = FixedHeaderProvider.create((String[])new String[]{"user-agent", String.format("%s/%s", "model-builder", GaxProperties.getLibraryVersion(PredictionServiceSettings.class))});
            settingsBuilder.setHeaderProvider((HeaderProvider)headerProvider);
            Logger defaultCredentialsProviderLogger = Logger.getLogger("com.google.auth.oauth2.DefaultCredentialsProvider");
            Level previousLevel = defaultCredentialsProviderLogger.getLevel();
            defaultCredentialsProviderLogger.setLevel(Level.SEVERE);
            this.predictionServiceClient = PredictionServiceClient.create(settingsBuilder.build());
            defaultCredentialsProviderLogger.setLevel(previousLevel);
        }
        return this.predictionServiceClient;
    }

    public PredictionServiceClient getPredictionServiceRestClient() throws IOException {
        if (this.predictionServiceRestClient == null) {
            PredictionServiceSettings.Builder settingsBuilder = PredictionServiceSettings.newHttpJsonBuilder();
            settingsBuilder.setEndpoint(String.format("%s:443", this.apiEndpoint));
            if (this.credentialsProvider != null) {
                settingsBuilder.setCredentialsProvider(this.credentialsProvider);
            }
            FixedHeaderProvider headerProvider = FixedHeaderProvider.create((String[])new String[]{"user-agent", String.format("%s/%s", "model-builder", GaxProperties.getLibraryVersion(PredictionServiceSettings.class))});
            settingsBuilder.setHeaderProvider((HeaderProvider)headerProvider);
            Logger defaultCredentialsProviderLogger = Logger.getLogger("com.google.auth.oauth2.DefaultCredentialsProvider");
            Level previousLevel = defaultCredentialsProviderLogger.getLevel();
            defaultCredentialsProviderLogger.setLevel(Level.SEVERE);
            this.predictionServiceRestClient = PredictionServiceClient.create(settingsBuilder.build());
            defaultCredentialsProviderLogger.setLevel(previousLevel);
        }
        return this.predictionServiceRestClient;
    }

    public LlmUtilityServiceClient getLlmUtilityClient() throws IOException {
        if (this.llmUtilityClient == null) {
            LlmUtilityServiceSettings.Builder settingsBuilder = LlmUtilityServiceSettings.newBuilder();
            settingsBuilder.setEndpoint(String.format("%s:443", this.apiEndpoint));
            if (this.credentialsProvider != null) {
                settingsBuilder.setCredentialsProvider(this.credentialsProvider);
            }
            FixedHeaderProvider headerProvider = FixedHeaderProvider.create((String[])new String[]{"user-agent", String.format("%s/%s", "model-builder", GaxProperties.getLibraryVersion(LlmUtilityServiceSettings.class))});
            settingsBuilder.setHeaderProvider((HeaderProvider)headerProvider);
            Logger defaultCredentialsProviderLogger = Logger.getLogger("com.google.auth.oauth2.DefaultCredentialsProvider");
            Level previousLevel = defaultCredentialsProviderLogger.getLevel();
            defaultCredentialsProviderLogger.setLevel(Level.SEVERE);
            this.llmUtilityClient = LlmUtilityServiceClient.create(settingsBuilder.build());
            defaultCredentialsProviderLogger.setLevel(previousLevel);
        }
        return this.llmUtilityClient;
    }

    public LlmUtilityServiceClient getLlmUtilityRestClient() throws IOException {
        if (this.llmUtilityRestClient == null) {
            LlmUtilityServiceSettings.Builder settingsBuilder = LlmUtilityServiceSettings.newHttpJsonBuilder();
            settingsBuilder.setEndpoint(String.format("%s:443", this.apiEndpoint));
            if (this.credentialsProvider != null) {
                settingsBuilder.setCredentialsProvider(this.credentialsProvider);
            }
            FixedHeaderProvider headerProvider = FixedHeaderProvider.create((String[])new String[]{"user-agent", String.format("%s/%s", "model-builder", GaxProperties.getLibraryVersion(LlmUtilityServiceSettings.class))});
            settingsBuilder.setHeaderProvider((HeaderProvider)headerProvider);
            Logger defaultCredentialsProviderLogger = Logger.getLogger("com.google.auth.oauth2.DefaultCredentialsProvider");
            Level previousLevel = defaultCredentialsProviderLogger.getLevel();
            defaultCredentialsProviderLogger.setLevel(Level.SEVERE);
            this.llmUtilityRestClient = LlmUtilityServiceClient.create(settingsBuilder.build());
            defaultCredentialsProviderLogger.setLevel(previousLevel);
        }
        return this.llmUtilityRestClient;
    }

    @Override
    public void close() {
        if (this.predictionServiceClient != null) {
            this.predictionServiceClient.close();
        }
        if (this.predictionServiceRestClient != null) {
            this.predictionServiceRestClient.close();
        }
        if (this.llmUtilityClient != null) {
            this.llmUtilityClient.close();
        }
        if (this.llmUtilityRestClient != null) {
            this.llmUtilityRestClient.close();
        }
    }
}

