/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.vertexai.generativeai.preview;

import com.google.cloud.vertexai.Transport;
import com.google.cloud.vertexai.VertexAI;
import com.google.cloud.vertexai.api.Content;
import com.google.cloud.vertexai.api.CountTokensRequest;
import com.google.cloud.vertexai.api.CountTokensResponse;
import com.google.cloud.vertexai.api.GenerateContentRequest;
import com.google.cloud.vertexai.api.GenerateContentResponse;
import com.google.cloud.vertexai.api.GenerationConfig;
import com.google.cloud.vertexai.api.Part;
import com.google.cloud.vertexai.api.SafetySetting;
import com.google.cloud.vertexai.api.Tool;
import com.google.cloud.vertexai.generativeai.preview.ChatSession;
import com.google.cloud.vertexai.generativeai.preview.Constants;
import com.google.cloud.vertexai.generativeai.preview.ContentMaker;
import com.google.cloud.vertexai.generativeai.preview.ResponseHandler;
import com.google.cloud.vertexai.generativeai.preview.ResponseStream;
import com.google.cloud.vertexai.generativeai.preview.ResponseStreamIteratorWithHistory;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class GenerativeModel {
    private final String modelName;
    private final String resourceName;
    private final VertexAI vertexAi;
    private GenerationConfig generationConfig = null;
    private List<SafetySetting> safetySettings = null;
    private List<Tool> tools = null;
    private Transport transport;

    public static Builder newBuilder() {
        return new Builder();
    }

    private GenerativeModel(Builder builder) {
        this.modelName = builder.modelName;
        this.vertexAi = builder.vertexAi;
        this.resourceName = String.format("projects/%s/locations/%s/publishers/google/models/%s", this.vertexAi.getProjectId(), this.vertexAi.getLocation(), this.modelName);
        if (builder.generationConfig != null) {
            this.generationConfig = builder.generationConfig;
        }
        if (builder.safetySettings != null) {
            this.safetySettings = builder.safetySettings;
        }
        if (builder.tools != null) {
            this.tools = builder.tools;
        }
        this.transport = builder.transport != null ? builder.transport : this.vertexAi.getTransport();
    }

    public GenerativeModel(String modelName, VertexAI vertexAi) {
        this(modelName, null, null, vertexAi, null);
    }

    public GenerativeModel(String modelName, VertexAI vertexAi, Transport transport) {
        this(modelName, null, null, vertexAi, transport);
    }

    public GenerativeModel(String modelName, GenerationConfig generationConfig, VertexAI vertexAi) {
        this(modelName, generationConfig, null, vertexAi, null);
    }

    public GenerativeModel(String modelName, GenerationConfig generationConfig, VertexAI vertexAi, Transport transport) {
        this(modelName, generationConfig, null, vertexAi, transport);
    }

    public GenerativeModel(String modelName, List<SafetySetting> safetySettings, VertexAI vertexAi) {
        this(modelName, null, safetySettings, vertexAi, null);
    }

    public GenerativeModel(String modelName, List<SafetySetting> safetySettings, VertexAI vertexAi, Transport transport) {
        this(modelName, null, safetySettings, vertexAi, transport);
    }

    public GenerativeModel(String modelName, GenerationConfig generationConfig, List<SafetySetting> safetySettings, VertexAI vertexAi) {
        this(modelName, generationConfig, safetySettings, vertexAi, null);
    }

    public GenerativeModel(String modelName, GenerationConfig generationConfig, List<SafetySetting> safetySettings, VertexAI vertexAi, Transport transport) {
        this.modelName = modelName = GenerativeModel.validateModelName(modelName);
        this.resourceName = String.format("projects/%s/locations/%s/publishers/google/models/%s", vertexAi.getProjectId(), vertexAi.getLocation(), modelName);
        if (generationConfig != null) {
            this.generationConfig = generationConfig;
        }
        if (safetySettings != null) {
            this.safetySettings = new ArrayList<SafetySetting>();
            for (SafetySetting safetySetting : safetySettings) {
                this.safetySettings.add(safetySetting);
            }
        }
        this.vertexAi = vertexAi;
        this.transport = transport != null ? transport : vertexAi.getTransport();
    }

    public CountTokensResponse countTokens(String text) throws IOException {
        Content content = ContentMaker.fromString(text);
        CountTokensRequest.Builder requestBuilder = CountTokensRequest.newBuilder().addAllContents(Arrays.asList(content));
        return this.countTokensFromBuilder(requestBuilder);
    }

    public CountTokensResponse countTokens(Content content) throws IOException {
        return this.countTokens(Arrays.asList(content));
    }

    public CountTokensResponse countTokens(List<Content> contents) throws IOException {
        CountTokensRequest.Builder requestBuilder = CountTokensRequest.newBuilder().addAllContents(contents);
        return this.countTokensFromBuilder(requestBuilder);
    }

    private CountTokensResponse countTokensFromBuilder(CountTokensRequest.Builder requestBuilder) throws IOException {
        CountTokensRequest request = requestBuilder.setEndpoint(this.resourceName).setModel(this.resourceName).build();
        if (this.transport == Transport.REST) {
            return this.vertexAi.getLlmUtilityRestClient().countTokens(request);
        }
        return this.vertexAi.getLlmUtilityClient().countTokens(request);
    }

    public GenerateContentResponse generateContent(String text) throws IOException {
        return this.generateContent(text, null, null);
    }

    public GenerateContentResponse generateContent(String text, GenerationConfig generationConfig) throws IOException {
        return this.generateContent(text, generationConfig, null);
    }

    public GenerateContentResponse generateContent(String text, List<SafetySetting> safetySettings) throws IOException {
        return this.generateContent(text, null, safetySettings);
    }

    public GenerateContentResponse generateContent(String text, GenerationConfig generationConfig, List<SafetySetting> safetySettings) throws IOException {
        Part part = Part.newBuilder().setText(text).build();
        Content content = Content.newBuilder().addParts(part).setRole("user").build();
        List<Content> contents = Arrays.asList(content);
        return this.generateContent(contents, generationConfig, safetySettings);
    }

    public GenerateContentResponse generateContent(List<Content> contents) throws IOException {
        return this.generateContent(contents, null, null);
    }

    public GenerateContentResponse generateContent(List<Content> contents, GenerationConfig generationConfig) throws IOException {
        return this.generateContent(contents, generationConfig, null);
    }

    public GenerateContentResponse generateContent(List<Content> contents, List<SafetySetting> safetySettings) throws IOException {
        return this.generateContent(contents, null, safetySettings);
    }

    public GenerateContentResponse generateContent(List<Content> contents, GenerationConfig generationConfig, List<SafetySetting> safetySettings) throws IOException {
        GenerateContentRequest.Builder requestBuilder = GenerateContentRequest.newBuilder().addAllContents(contents);
        if (generationConfig != null) {
            requestBuilder.setGenerationConfig(generationConfig);
        } else if (this.generationConfig != null) {
            requestBuilder.setGenerationConfig(this.generationConfig);
        }
        if (safetySettings != null) {
            requestBuilder.addAllSafetySettings(safetySettings);
        } else if (this.safetySettings != null) {
            requestBuilder.addAllSafetySettings(this.safetySettings);
        }
        if (this.tools != null) {
            requestBuilder.addAllTools(this.tools);
        }
        return ResponseHandler.aggregateStreamIntoResponse(this.generateContentStream(requestBuilder));
    }

    public GenerateContentResponse generateContent(Content content) throws IOException {
        return this.generateContent(content, null, null);
    }

    public GenerateContentResponse generateContent(Content content, GenerationConfig generationConfig) throws IOException {
        return this.generateContent(content, generationConfig, null);
    }

    public GenerateContentResponse generateContent(Content content, List<SafetySetting> safetySettings) throws IOException {
        return this.generateContent(content, null, safetySettings);
    }

    public GenerateContentResponse generateContent(Content content, GenerationConfig generationConfig, List<SafetySetting> safetySettings) throws IOException {
        return this.generateContent(Arrays.asList(content), generationConfig, safetySettings);
    }

    public ResponseStream<GenerateContentResponse> generateContentStream(String text) throws IOException {
        return this.generateContentStream(text, null, null);
    }

    public ResponseStream<GenerateContentResponse> generateContentStream(String text, GenerationConfig generationConfig) throws IOException {
        return this.generateContentStream(text, generationConfig, null);
    }

    public ResponseStream<GenerateContentResponse> generateContentStream(String text, List<SafetySetting> safetySettings) throws IOException {
        return this.generateContentStream(text, null, safetySettings);
    }

    public ResponseStream<GenerateContentResponse> generateContentStream(String text, GenerationConfig generationConfig, List<SafetySetting> safetySettings) throws IOException {
        Part part = Part.newBuilder().setText(text).build();
        Content content = Content.newBuilder().addParts(part).setRole("user").build();
        List<Content> contents = Arrays.asList(content);
        return this.generateContentStream(contents, generationConfig, safetySettings);
    }

    public ResponseStream<GenerateContentResponse> generateContentStream(Content content) throws IOException {
        return this.generateContentStream(content, null, null);
    }

    public ResponseStream<GenerateContentResponse> generateContentStream(Content content, GenerationConfig generationConfig) throws IOException {
        return this.generateContentStream(content, generationConfig, null);
    }

    public ResponseStream<GenerateContentResponse> generateContentStream(Content content, List<SafetySetting> safetySettings) throws IOException {
        return this.generateContentStream(content, null, safetySettings);
    }

    public ResponseStream<GenerateContentResponse> generateContentStream(Content content, GenerationConfig generationConfig, List<SafetySetting> safetySettings) throws IOException {
        return this.generateContentStream(Arrays.asList(content), generationConfig, safetySettings);
    }

    public ResponseStream<GenerateContentResponse> generateContentStream(List<Content> contents) throws IOException {
        return this.generateContentStream(contents, null, null);
    }

    public ResponseStream<GenerateContentResponse> generateContentStream(List<Content> contents, GenerationConfig generationConfig) throws IOException {
        return this.generateContentStream(contents, generationConfig, null);
    }

    public ResponseStream<GenerateContentResponse> generateContentStream(List<Content> contents, List<SafetySetting> safetySettings) throws IOException {
        return this.generateContentStream(contents, null, safetySettings);
    }

    public ResponseStream<GenerateContentResponse> generateContentStream(List<Content> contents, GenerationConfig generationConfig, List<SafetySetting> safetySettings) throws IOException {
        GenerateContentRequest.Builder requestBuilder = GenerateContentRequest.newBuilder().addAllContents(contents);
        if (generationConfig != null) {
            requestBuilder.setGenerationConfig(generationConfig);
        } else if (this.generationConfig != null) {
            requestBuilder.setGenerationConfig(this.generationConfig);
        }
        if (safetySettings != null) {
            requestBuilder.addAllSafetySettings(safetySettings);
        } else if (this.safetySettings != null) {
            requestBuilder.addAllSafetySettings(this.safetySettings);
        }
        if (this.tools != null) {
            requestBuilder.addAllTools(this.tools);
        }
        return this.generateContentStream(requestBuilder);
    }

    private ResponseStream<GenerateContentResponse> generateContentStream(GenerateContentRequest.Builder requestBuilder) throws IOException {
        GenerateContentRequest request = requestBuilder.setModel(this.resourceName).build();
        ResponseStream<Object> responseStream = null;
        responseStream = this.transport == Transport.REST ? new ResponseStream<GenerateContentResponse>(new ResponseStreamIteratorWithHistory(this.vertexAi.getPredictionServiceRestClient().streamGenerateContentCallable().call((Object)request).iterator())) : new ResponseStream(new ResponseStreamIteratorWithHistory(this.vertexAi.getPredictionServiceClient().streamGenerateContentCallable().call((Object)request).iterator()));
        return responseStream;
    }

    public void setGenerationConfig(GenerationConfig generationConfig) {
        this.generationConfig = generationConfig;
    }

    public void setSafetySettings(List<SafetySetting> safetySettings) {
        this.safetySettings = new ArrayList<SafetySetting>();
        for (SafetySetting safetySetting : safetySettings) {
            this.safetySettings.add(safetySetting);
        }
    }

    public void setTools(List<Tool> tools) {
        this.tools = new ArrayList<Tool>();
        for (Tool tool : tools) {
            this.tools.add(tool);
        }
    }

    public void setTransport(Transport transport) {
        this.transport = transport;
    }

    public String getModelName() {
        return this.modelName;
    }

    public Transport getTransport() {
        return this.transport;
    }

    public GenerationConfig getGenerationConfig() {
        return this.generationConfig;
    }

    public List<SafetySetting> getSafetySettings() {
        if (this.safetySettings != null) {
            return Collections.unmodifiableList(this.safetySettings);
        }
        return null;
    }

    public List<Tool> getTools() {
        if (this.tools != null) {
            return Collections.unmodifiableList(this.tools);
        }
        return null;
    }

    public ChatSession startChat() {
        return new ChatSession(this);
    }

    private static String validateModelName(String modelName) {
        for (String prefix : Constants.MODEL_NAME_PREFIXES) {
            if (!modelName.startsWith(prefix)) continue;
            modelName = modelName.substring(prefix.length());
            break;
        }
        if (!Constants.GENERATIVE_MODEL_NAMES.contains((Object)modelName)) {
            throw new IllegalArgumentException(String.format("Invalid model name: %s. Please choose from: %s", modelName, Constants.GENERATIVE_MODEL_NAMES));
        }
        return modelName;
    }

    public static class Builder {
        private String modelName;
        private VertexAI vertexAi;
        private GenerationConfig generationConfig;
        private List<SafetySetting> safetySettings;
        private List<Tool> tools;
        private Transport transport;

        private Builder() {
        }

        public GenerativeModel build() {
            if (this.modelName == null) {
                throw new IllegalArgumentException("modelName is required. Please call setModelName() before building.");
            }
            if (this.vertexAi == null) {
                throw new IllegalArgumentException("vertexAi is required. Please call setVertexAi() before building.");
            }
            return new GenerativeModel(this);
        }

        public Builder setModelName(String modelName) {
            this.modelName = GenerativeModel.validateModelName(modelName);
            return this;
        }

        public Builder setVertexAi(VertexAI vertexAi) {
            this.vertexAi = vertexAi;
            return this;
        }

        public Builder setGenerationConfig(GenerationConfig generationConfig) {
            this.generationConfig = generationConfig;
            return this;
        }

        public Builder setSafetySettings(List<SafetySetting> safetySettings) {
            this.safetySettings = new ArrayList<SafetySetting>();
            for (SafetySetting safetySetting : safetySettings) {
                if (safetySetting == null) continue;
                this.safetySettings.add(safetySetting);
            }
            return this;
        }

        public Builder setTools(List<Tool> tools) {
            this.tools = new ArrayList<Tool>();
            for (Tool tool : tools) {
                if (tool == null) continue;
                this.tools.add(tool);
            }
            return this;
        }

        public Builder setTransport(Transport transport) {
            this.transport = transport;
            return this;
        }
    }
}

