/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.vertexai.generativeai.preview;

import com.google.cloud.vertexai.api.Candidate;
import com.google.cloud.vertexai.api.Content;
import com.google.cloud.vertexai.api.GenerateContentResponse;
import com.google.cloud.vertexai.api.GenerationConfig;
import com.google.cloud.vertexai.api.SafetySetting;
import com.google.cloud.vertexai.generativeai.preview.ContentMaker;
import com.google.cloud.vertexai.generativeai.preview.GenerativeModel;
import com.google.cloud.vertexai.generativeai.preview.ResponseHandler;
import com.google.cloud.vertexai.generativeai.preview.ResponseStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class ChatSession {
    private final GenerativeModel model;
    private List<Content> history = new ArrayList<Content>();
    private ResponseStream<GenerateContentResponse> currentResponseStream = null;
    private GenerateContentResponse currentResponse = null;

    public ChatSession(GenerativeModel model) {
        if (model == null) {
            throw new IllegalArgumentException("model should not be null");
        }
        this.model = model;
    }

    public ResponseStream<GenerateContentResponse> sendMessageStream(String text) throws IOException {
        return this.sendMessageStream(text, null, null);
    }

    public ResponseStream<GenerateContentResponse> sendMessageStream(String text, GenerationConfig generationConfig) throws IOException {
        return this.sendMessageStream(text, generationConfig, null);
    }

    public ResponseStream<GenerateContentResponse> sendMessageStream(String text, List<SafetySetting> safetySettings) throws IOException {
        return this.sendMessageStream(text, null, safetySettings);
    }

    public ResponseStream<GenerateContentResponse> sendMessageStream(String text, GenerationConfig generationConfig, List<SafetySetting> safetySettings) throws IOException {
        this.checkLastResponseAndEditHistory();
        this.history.add(ContentMaker.fromString(text));
        ResponseStream<GenerateContentResponse> respStream = this.model.generateContentStream(this.history, generationConfig, safetySettings);
        this.currentResponseStream = respStream;
        this.currentResponse = null;
        return respStream;
    }

    public ResponseStream<GenerateContentResponse> sendMessageStream(Content content) throws IOException, IllegalArgumentException {
        return this.sendMessageStream(content, null, null);
    }

    public ResponseStream<GenerateContentResponse> sendMessageStream(Content content, GenerationConfig generationConfig) throws IOException, IllegalArgumentException {
        return this.sendMessageStream(content, generationConfig, null);
    }

    public ResponseStream<GenerateContentResponse> sendMessageStream(Content content, List<SafetySetting> safetySettings) throws IOException, IllegalArgumentException {
        return this.sendMessageStream(content, null, safetySettings);
    }

    public ResponseStream<GenerateContentResponse> sendMessageStream(Content content, GenerationConfig generationConfig, List<SafetySetting> safetySettings) throws IOException {
        this.checkLastResponseAndEditHistory();
        this.history.add(content);
        ResponseStream<GenerateContentResponse> respStream = this.model.generateContentStream(this.history, generationConfig, safetySettings);
        this.currentResponseStream = respStream;
        this.currentResponse = null;
        return respStream;
    }

    public GenerateContentResponse sendMessage(String text) throws IOException {
        return this.sendMessage(text, null, null);
    }

    public GenerateContentResponse sendMessage(String text, GenerationConfig generationConfig) throws IOException {
        return this.sendMessage(text, generationConfig, null);
    }

    public GenerateContentResponse sendMessage(String text, List<SafetySetting> safetySettings) throws IOException {
        return this.sendMessage(text, null, safetySettings);
    }

    public GenerateContentResponse sendMessage(String text, GenerationConfig generationConfig, List<SafetySetting> safetySettings) throws IOException {
        GenerateContentResponse response;
        this.checkLastResponseAndEditHistory();
        this.history.add(ContentMaker.fromString(text));
        this.currentResponse = response = this.model.generateContent(this.history, generationConfig, safetySettings);
        this.currentResponseStream = null;
        return response;
    }

    public GenerateContentResponse sendMessage(Content content) throws IOException {
        return this.sendMessage(content, null, null);
    }

    public GenerateContentResponse sendMessage(Content content, GenerationConfig generationConfig) throws IOException {
        return this.sendMessage(content, generationConfig, null);
    }

    public GenerateContentResponse sendMessage(Content content, List<SafetySetting> safetySettings) throws IOException {
        return this.sendMessage(content, null, safetySettings);
    }

    public GenerateContentResponse sendMessage(Content content, GenerationConfig generationConfig, List<SafetySetting> safetySettings) throws IOException {
        GenerateContentResponse response;
        this.checkLastResponseAndEditHistory();
        this.history.add(content);
        this.currentResponse = response = this.model.generateContent(this.history, generationConfig, safetySettings);
        this.currentResponseStream = null;
        return response;
    }

    private void removeLastContent() {
        int lastIndex = this.history.size() - 1;
        this.history.remove(lastIndex);
    }

    private void checkLastResponseAndEditHistory() throws IllegalStateException {
        if (this.currentResponseStream == null && this.currentResponse == null) {
            return;
        }
        if (this.currentResponseStream != null && !this.currentResponseStream.isConsumed()) {
            throw new IllegalStateException("Response stream is not consumed");
        }
        if (this.currentResponseStream != null && this.currentResponseStream.isConsumed()) {
            GenerateContentResponse response = ResponseHandler.aggregateStreamIntoResponse(this.currentResponseStream);
            Candidate.FinishReason finishReason = ResponseHandler.getFinishReason(response);
            if (finishReason != Candidate.FinishReason.STOP && finishReason != Candidate.FinishReason.MAX_TOKENS) {
                this.removeLastContent();
                this.currentResponseStream = null;
                throw new IllegalStateException(String.format("The last round of conversation will not be added to history because response stream did not finish normally. Finish reason is %s.", finishReason));
            }
            this.history.add(ResponseHandler.getContent(response));
        } else if (this.currentResponseStream == null && this.currentResponse != null) {
            Candidate.FinishReason finishReason = ResponseHandler.getFinishReason(this.currentResponse);
            if (finishReason != Candidate.FinishReason.STOP && finishReason != Candidate.FinishReason.MAX_TOKENS) {
                this.removeLastContent();
                this.currentResponse = null;
                throw new IllegalStateException(String.format("The last round of conversation will not be added to history because response did not finish normally. Finish reason is %s.", finishReason));
            }
            this.history.add(ResponseHandler.getContent(this.currentResponse));
            this.currentResponse = null;
        }
    }

    public List<Content> getHistory() {
        try {
            this.checkLastResponseAndEditHistory();
        }
        catch (IllegalStateException e) {
            if (e.getMessage().contains("The last round of conversation will not be added to history because")) {
                IllegalStateException modifiedExecption = new IllegalStateException("Rerun getHistory() to get cleaned history.");
                modifiedExecption.initCause(e);
                throw modifiedExecption;
            }
            throw e;
        }
        return Collections.unmodifiableList(this.history);
    }

    public void setHistory(List<Content> history) {
        this.history = history;
    }
}

