/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.vectorsearch.v1beta.stub;

import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.core.BackgroundResourceAggregation;
import com.google.api.gax.grpc.GrpcCallSettings;
import com.google.api.gax.grpc.GrpcStubCallableFactory;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.RequestParamsBuilder;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.location.GetLocationRequest;
import com.google.cloud.location.ListLocationsRequest;
import com.google.cloud.location.ListLocationsResponse;
import com.google.cloud.location.Location;
import com.google.cloud.vectorsearch.v1beta.BatchCreateDataObjectsRequest;
import com.google.cloud.vectorsearch.v1beta.BatchCreateDataObjectsResponse;
import com.google.cloud.vectorsearch.v1beta.BatchDeleteDataObjectsRequest;
import com.google.cloud.vectorsearch.v1beta.BatchUpdateDataObjectsRequest;
import com.google.cloud.vectorsearch.v1beta.BatchUpdateDataObjectsResponse;
import com.google.cloud.vectorsearch.v1beta.CreateDataObjectRequest;
import com.google.cloud.vectorsearch.v1beta.DataObject;
import com.google.cloud.vectorsearch.v1beta.DataObjectServiceClient;
import com.google.cloud.vectorsearch.v1beta.DeleteDataObjectRequest;
import com.google.cloud.vectorsearch.v1beta.GetDataObjectRequest;
import com.google.cloud.vectorsearch.v1beta.UpdateDataObjectRequest;
import com.google.cloud.vectorsearch.v1beta.stub.DataObjectServiceStub;
import com.google.cloud.vectorsearch.v1beta.stub.DataObjectServiceStubSettings;
import com.google.cloud.vectorsearch.v1beta.stub.GrpcDataObjectServiceCallableFactory;
import com.google.longrunning.stub.GrpcOperationsStub;
import com.google.protobuf.Empty;
import com.google.protobuf.Message;
import io.grpc.MethodDescriptor;
import io.grpc.protobuf.ProtoUtils;
import java.io.IOException;
import java.util.concurrent.TimeUnit;

@BetaApi
public class GrpcDataObjectServiceStub
extends DataObjectServiceStub {
    private static final MethodDescriptor<CreateDataObjectRequest, DataObject> createDataObjectMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.vectorsearch.v1beta.DataObjectService/CreateDataObject").setRequestMarshaller(ProtoUtils.marshaller((Message)CreateDataObjectRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)DataObject.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private static final MethodDescriptor<BatchCreateDataObjectsRequest, BatchCreateDataObjectsResponse> batchCreateDataObjectsMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.vectorsearch.v1beta.DataObjectService/BatchCreateDataObjects").setRequestMarshaller(ProtoUtils.marshaller((Message)BatchCreateDataObjectsRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)BatchCreateDataObjectsResponse.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private static final MethodDescriptor<GetDataObjectRequest, DataObject> getDataObjectMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.vectorsearch.v1beta.DataObjectService/GetDataObject").setRequestMarshaller(ProtoUtils.marshaller((Message)GetDataObjectRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)DataObject.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private static final MethodDescriptor<UpdateDataObjectRequest, DataObject> updateDataObjectMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.vectorsearch.v1beta.DataObjectService/UpdateDataObject").setRequestMarshaller(ProtoUtils.marshaller((Message)UpdateDataObjectRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)DataObject.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private static final MethodDescriptor<BatchUpdateDataObjectsRequest, BatchUpdateDataObjectsResponse> batchUpdateDataObjectsMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.vectorsearch.v1beta.DataObjectService/BatchUpdateDataObjects").setRequestMarshaller(ProtoUtils.marshaller((Message)BatchUpdateDataObjectsRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)BatchUpdateDataObjectsResponse.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private static final MethodDescriptor<DeleteDataObjectRequest, Empty> deleteDataObjectMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.vectorsearch.v1beta.DataObjectService/DeleteDataObject").setRequestMarshaller(ProtoUtils.marshaller((Message)DeleteDataObjectRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Empty.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private static final MethodDescriptor<BatchDeleteDataObjectsRequest, Empty> batchDeleteDataObjectsMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.vectorsearch.v1beta.DataObjectService/BatchDeleteDataObjects").setRequestMarshaller(ProtoUtils.marshaller((Message)BatchDeleteDataObjectsRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Empty.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private static final MethodDescriptor<ListLocationsRequest, ListLocationsResponse> listLocationsMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.location.Locations/ListLocations").setRequestMarshaller(ProtoUtils.marshaller((Message)ListLocationsRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)ListLocationsResponse.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private static final MethodDescriptor<GetLocationRequest, Location> getLocationMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.location.Locations/GetLocation").setRequestMarshaller(ProtoUtils.marshaller((Message)GetLocationRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Location.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private final UnaryCallable<CreateDataObjectRequest, DataObject> createDataObjectCallable;
    private final UnaryCallable<BatchCreateDataObjectsRequest, BatchCreateDataObjectsResponse> batchCreateDataObjectsCallable;
    private final UnaryCallable<GetDataObjectRequest, DataObject> getDataObjectCallable;
    private final UnaryCallable<UpdateDataObjectRequest, DataObject> updateDataObjectCallable;
    private final UnaryCallable<BatchUpdateDataObjectsRequest, BatchUpdateDataObjectsResponse> batchUpdateDataObjectsCallable;
    private final UnaryCallable<DeleteDataObjectRequest, Empty> deleteDataObjectCallable;
    private final UnaryCallable<BatchDeleteDataObjectsRequest, Empty> batchDeleteDataObjectsCallable;
    private final UnaryCallable<ListLocationsRequest, ListLocationsResponse> listLocationsCallable;
    private final UnaryCallable<ListLocationsRequest, DataObjectServiceClient.ListLocationsPagedResponse> listLocationsPagedCallable;
    private final UnaryCallable<GetLocationRequest, Location> getLocationCallable;
    private final BackgroundResource backgroundResources;
    private final GrpcOperationsStub operationsStub;
    private final GrpcStubCallableFactory callableFactory;

    public static final GrpcDataObjectServiceStub create(DataObjectServiceStubSettings settings) throws IOException {
        return new GrpcDataObjectServiceStub(settings, ClientContext.create((StubSettings)settings));
    }

    public static final GrpcDataObjectServiceStub create(ClientContext clientContext) throws IOException {
        return new GrpcDataObjectServiceStub(DataObjectServiceStubSettings.newBuilder().build(), clientContext);
    }

    public static final GrpcDataObjectServiceStub create(ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        return new GrpcDataObjectServiceStub(DataObjectServiceStubSettings.newBuilder().build(), clientContext, callableFactory);
    }

    protected GrpcDataObjectServiceStub(DataObjectServiceStubSettings settings, ClientContext clientContext) throws IOException {
        this(settings, clientContext, new GrpcDataObjectServiceCallableFactory());
    }

    protected GrpcDataObjectServiceStub(DataObjectServiceStubSettings settings, ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        this.callableFactory = callableFactory;
        this.operationsStub = GrpcOperationsStub.create((ClientContext)clientContext, (GrpcStubCallableFactory)callableFactory);
        GrpcCallSettings createDataObjectTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(createDataObjectMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parent", String.valueOf(request.getParent()));
            return builder.build();
        }).build();
        GrpcCallSettings batchCreateDataObjectsTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(batchCreateDataObjectsMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parent", String.valueOf(request.getParent()));
            return builder.build();
        }).build();
        GrpcCallSettings getDataObjectTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(getDataObjectMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        GrpcCallSettings updateDataObjectTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(updateDataObjectMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("data_object.name", String.valueOf(request.getDataObject().getName()));
            return builder.build();
        }).build();
        GrpcCallSettings batchUpdateDataObjectsTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(batchUpdateDataObjectsMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parent", String.valueOf(request.getParent()));
            return builder.build();
        }).build();
        GrpcCallSettings deleteDataObjectTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(deleteDataObjectMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        GrpcCallSettings batchDeleteDataObjectsTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(batchDeleteDataObjectsMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parent", String.valueOf(request.getParent()));
            return builder.build();
        }).build();
        GrpcCallSettings listLocationsTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(listLocationsMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        GrpcCallSettings getLocationTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(getLocationMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        this.createDataObjectCallable = callableFactory.createUnaryCallable(createDataObjectTransportSettings, settings.createDataObjectSettings(), clientContext);
        this.batchCreateDataObjectsCallable = callableFactory.createUnaryCallable(batchCreateDataObjectsTransportSettings, settings.batchCreateDataObjectsSettings(), clientContext);
        this.getDataObjectCallable = callableFactory.createUnaryCallable(getDataObjectTransportSettings, settings.getDataObjectSettings(), clientContext);
        this.updateDataObjectCallable = callableFactory.createUnaryCallable(updateDataObjectTransportSettings, settings.updateDataObjectSettings(), clientContext);
        this.batchUpdateDataObjectsCallable = callableFactory.createUnaryCallable(batchUpdateDataObjectsTransportSettings, settings.batchUpdateDataObjectsSettings(), clientContext);
        this.deleteDataObjectCallable = callableFactory.createUnaryCallable(deleteDataObjectTransportSettings, settings.deleteDataObjectSettings(), clientContext);
        this.batchDeleteDataObjectsCallable = callableFactory.createUnaryCallable(batchDeleteDataObjectsTransportSettings, settings.batchDeleteDataObjectsSettings(), clientContext);
        this.listLocationsCallable = callableFactory.createUnaryCallable(listLocationsTransportSettings, settings.listLocationsSettings(), clientContext);
        this.listLocationsPagedCallable = callableFactory.createPagedCallable(listLocationsTransportSettings, settings.listLocationsSettings(), clientContext);
        this.getLocationCallable = callableFactory.createUnaryCallable(getLocationTransportSettings, settings.getLocationSettings(), clientContext);
        this.backgroundResources = new BackgroundResourceAggregation(clientContext.getBackgroundResources());
    }

    public GrpcOperationsStub getOperationsStub() {
        return this.operationsStub;
    }

    @Override
    public UnaryCallable<CreateDataObjectRequest, DataObject> createDataObjectCallable() {
        return this.createDataObjectCallable;
    }

    @Override
    public UnaryCallable<BatchCreateDataObjectsRequest, BatchCreateDataObjectsResponse> batchCreateDataObjectsCallable() {
        return this.batchCreateDataObjectsCallable;
    }

    @Override
    public UnaryCallable<GetDataObjectRequest, DataObject> getDataObjectCallable() {
        return this.getDataObjectCallable;
    }

    @Override
    public UnaryCallable<UpdateDataObjectRequest, DataObject> updateDataObjectCallable() {
        return this.updateDataObjectCallable;
    }

    @Override
    public UnaryCallable<BatchUpdateDataObjectsRequest, BatchUpdateDataObjectsResponse> batchUpdateDataObjectsCallable() {
        return this.batchUpdateDataObjectsCallable;
    }

    @Override
    public UnaryCallable<DeleteDataObjectRequest, Empty> deleteDataObjectCallable() {
        return this.deleteDataObjectCallable;
    }

    @Override
    public UnaryCallable<BatchDeleteDataObjectsRequest, Empty> batchDeleteDataObjectsCallable() {
        return this.batchDeleteDataObjectsCallable;
    }

    @Override
    public UnaryCallable<ListLocationsRequest, ListLocationsResponse> listLocationsCallable() {
        return this.listLocationsCallable;
    }

    @Override
    public UnaryCallable<ListLocationsRequest, DataObjectServiceClient.ListLocationsPagedResponse> listLocationsPagedCallable() {
        return this.listLocationsPagedCallable;
    }

    @Override
    public UnaryCallable<GetLocationRequest, Location> getLocationCallable() {
        return this.getLocationCallable;
    }

    @Override
    public final void close() {
        try {
            this.backgroundResources.close();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to close resource", e);
        }
    }

    public void shutdown() {
        this.backgroundResources.shutdown();
    }

    public boolean isShutdown() {
        return this.backgroundResources.isShutdown();
    }

    public boolean isTerminated() {
        return this.backgroundResources.isTerminated();
    }

    public void shutdownNow() {
        this.backgroundResources.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.backgroundResources.awaitTermination(duration, unit);
    }
}

