/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.translate.v3beta1.stub;

import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.core.BackgroundResourceAggregation;
import com.google.api.gax.grpc.GrpcCallSettings;
import com.google.api.gax.grpc.GrpcStubCallableFactory;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.OperationCallable;
import com.google.api.gax.rpc.RequestParamsExtractor;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.translate.v3beta1.BatchTranslateMetadata;
import com.google.cloud.translate.v3beta1.BatchTranslateResponse;
import com.google.cloud.translate.v3beta1.BatchTranslateTextRequest;
import com.google.cloud.translate.v3beta1.CreateGlossaryMetadata;
import com.google.cloud.translate.v3beta1.CreateGlossaryRequest;
import com.google.cloud.translate.v3beta1.DeleteGlossaryMetadata;
import com.google.cloud.translate.v3beta1.DeleteGlossaryRequest;
import com.google.cloud.translate.v3beta1.DeleteGlossaryResponse;
import com.google.cloud.translate.v3beta1.DetectLanguageRequest;
import com.google.cloud.translate.v3beta1.DetectLanguageResponse;
import com.google.cloud.translate.v3beta1.GetGlossaryRequest;
import com.google.cloud.translate.v3beta1.GetSupportedLanguagesRequest;
import com.google.cloud.translate.v3beta1.Glossary;
import com.google.cloud.translate.v3beta1.ListGlossariesRequest;
import com.google.cloud.translate.v3beta1.ListGlossariesResponse;
import com.google.cloud.translate.v3beta1.SupportedLanguages;
import com.google.cloud.translate.v3beta1.TranslateTextRequest;
import com.google.cloud.translate.v3beta1.TranslateTextResponse;
import com.google.cloud.translate.v3beta1.TranslationServiceClient;
import com.google.cloud.translate.v3beta1.stub.GrpcTranslationServiceCallableFactory;
import com.google.cloud.translate.v3beta1.stub.TranslationServiceStub;
import com.google.cloud.translate.v3beta1.stub.TranslationServiceStubSettings;
import com.google.common.collect.ImmutableMap;
import com.google.longrunning.Operation;
import com.google.longrunning.stub.GrpcOperationsStub;
import com.google.longrunning.stub.OperationsStub;
import com.google.protobuf.Message;
import io.grpc.MethodDescriptor;
import io.grpc.protobuf.ProtoUtils;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.TimeUnit;

public class GrpcTranslationServiceStub
extends TranslationServiceStub {
    private static final MethodDescriptor<TranslateTextRequest, TranslateTextResponse> translateTextMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.translation.v3beta1.TranslationService/TranslateText").setRequestMarshaller(ProtoUtils.marshaller((Message)TranslateTextRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)TranslateTextResponse.getDefaultInstance())).build();
    private static final MethodDescriptor<DetectLanguageRequest, DetectLanguageResponse> detectLanguageMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.translation.v3beta1.TranslationService/DetectLanguage").setRequestMarshaller(ProtoUtils.marshaller((Message)DetectLanguageRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)DetectLanguageResponse.getDefaultInstance())).build();
    private static final MethodDescriptor<GetSupportedLanguagesRequest, SupportedLanguages> getSupportedLanguagesMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.translation.v3beta1.TranslationService/GetSupportedLanguages").setRequestMarshaller(ProtoUtils.marshaller((Message)GetSupportedLanguagesRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)SupportedLanguages.getDefaultInstance())).build();
    private static final MethodDescriptor<BatchTranslateTextRequest, Operation> batchTranslateTextMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.translation.v3beta1.TranslationService/BatchTranslateText").setRequestMarshaller(ProtoUtils.marshaller((Message)BatchTranslateTextRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Operation.getDefaultInstance())).build();
    private static final MethodDescriptor<CreateGlossaryRequest, Operation> createGlossaryMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.translation.v3beta1.TranslationService/CreateGlossary").setRequestMarshaller(ProtoUtils.marshaller((Message)CreateGlossaryRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Operation.getDefaultInstance())).build();
    private static final MethodDescriptor<ListGlossariesRequest, ListGlossariesResponse> listGlossariesMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.translation.v3beta1.TranslationService/ListGlossaries").setRequestMarshaller(ProtoUtils.marshaller((Message)ListGlossariesRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)ListGlossariesResponse.getDefaultInstance())).build();
    private static final MethodDescriptor<GetGlossaryRequest, Glossary> getGlossaryMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.translation.v3beta1.TranslationService/GetGlossary").setRequestMarshaller(ProtoUtils.marshaller((Message)GetGlossaryRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Glossary.getDefaultInstance())).build();
    private static final MethodDescriptor<DeleteGlossaryRequest, Operation> deleteGlossaryMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.translation.v3beta1.TranslationService/DeleteGlossary").setRequestMarshaller(ProtoUtils.marshaller((Message)DeleteGlossaryRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Operation.getDefaultInstance())).build();
    private final UnaryCallable<TranslateTextRequest, TranslateTextResponse> translateTextCallable;
    private final UnaryCallable<DetectLanguageRequest, DetectLanguageResponse> detectLanguageCallable;
    private final UnaryCallable<GetSupportedLanguagesRequest, SupportedLanguages> getSupportedLanguagesCallable;
    private final UnaryCallable<BatchTranslateTextRequest, Operation> batchTranslateTextCallable;
    private final OperationCallable<BatchTranslateTextRequest, BatchTranslateResponse, BatchTranslateMetadata> batchTranslateTextOperationCallable;
    private final UnaryCallable<CreateGlossaryRequest, Operation> createGlossaryCallable;
    private final OperationCallable<CreateGlossaryRequest, Glossary, CreateGlossaryMetadata> createGlossaryOperationCallable;
    private final UnaryCallable<ListGlossariesRequest, ListGlossariesResponse> listGlossariesCallable;
    private final UnaryCallable<ListGlossariesRequest, TranslationServiceClient.ListGlossariesPagedResponse> listGlossariesPagedCallable;
    private final UnaryCallable<GetGlossaryRequest, Glossary> getGlossaryCallable;
    private final UnaryCallable<DeleteGlossaryRequest, Operation> deleteGlossaryCallable;
    private final OperationCallable<DeleteGlossaryRequest, DeleteGlossaryResponse, DeleteGlossaryMetadata> deleteGlossaryOperationCallable;
    private final BackgroundResource backgroundResources;
    private final GrpcOperationsStub operationsStub;
    private final GrpcStubCallableFactory callableFactory;

    public static final GrpcTranslationServiceStub create(TranslationServiceStubSettings settings) throws IOException {
        return new GrpcTranslationServiceStub(settings, ClientContext.create((StubSettings)settings));
    }

    public static final GrpcTranslationServiceStub create(ClientContext clientContext) throws IOException {
        return new GrpcTranslationServiceStub(TranslationServiceStubSettings.newBuilder().build(), clientContext);
    }

    public static final GrpcTranslationServiceStub create(ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        return new GrpcTranslationServiceStub(TranslationServiceStubSettings.newBuilder().build(), clientContext, callableFactory);
    }

    protected GrpcTranslationServiceStub(TranslationServiceStubSettings settings, ClientContext clientContext) throws IOException {
        this(settings, clientContext, new GrpcTranslationServiceCallableFactory());
    }

    protected GrpcTranslationServiceStub(TranslationServiceStubSettings settings, ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        this.callableFactory = callableFactory;
        this.operationsStub = GrpcOperationsStub.create((ClientContext)clientContext, (GrpcStubCallableFactory)callableFactory);
        GrpcCallSettings translateTextTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(translateTextMethodDescriptor).setParamsExtractor((RequestParamsExtractor)new RequestParamsExtractor<TranslateTextRequest>(){

            public Map<String, String> extract(TranslateTextRequest request) {
                ImmutableMap.Builder params = ImmutableMap.builder();
                params.put((Object)"parent", (Object)String.valueOf(request.getParent()));
                return params.build();
            }
        }).build();
        GrpcCallSettings detectLanguageTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(detectLanguageMethodDescriptor).setParamsExtractor((RequestParamsExtractor)new RequestParamsExtractor<DetectLanguageRequest>(){

            public Map<String, String> extract(DetectLanguageRequest request) {
                ImmutableMap.Builder params = ImmutableMap.builder();
                params.put((Object)"parent", (Object)String.valueOf(request.getParent()));
                return params.build();
            }
        }).build();
        GrpcCallSettings getSupportedLanguagesTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(getSupportedLanguagesMethodDescriptor).setParamsExtractor((RequestParamsExtractor)new RequestParamsExtractor<GetSupportedLanguagesRequest>(){

            public Map<String, String> extract(GetSupportedLanguagesRequest request) {
                ImmutableMap.Builder params = ImmutableMap.builder();
                params.put((Object)"parent", (Object)String.valueOf(request.getParent()));
                return params.build();
            }
        }).build();
        GrpcCallSettings batchTranslateTextTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(batchTranslateTextMethodDescriptor).setParamsExtractor((RequestParamsExtractor)new RequestParamsExtractor<BatchTranslateTextRequest>(){

            public Map<String, String> extract(BatchTranslateTextRequest request) {
                ImmutableMap.Builder params = ImmutableMap.builder();
                params.put((Object)"parent", (Object)String.valueOf(request.getParent()));
                return params.build();
            }
        }).build();
        GrpcCallSettings createGlossaryTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(createGlossaryMethodDescriptor).setParamsExtractor((RequestParamsExtractor)new RequestParamsExtractor<CreateGlossaryRequest>(){

            public Map<String, String> extract(CreateGlossaryRequest request) {
                ImmutableMap.Builder params = ImmutableMap.builder();
                params.put((Object)"parent", (Object)String.valueOf(request.getParent()));
                return params.build();
            }
        }).build();
        GrpcCallSettings listGlossariesTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(listGlossariesMethodDescriptor).setParamsExtractor((RequestParamsExtractor)new RequestParamsExtractor<ListGlossariesRequest>(){

            public Map<String, String> extract(ListGlossariesRequest request) {
                ImmutableMap.Builder params = ImmutableMap.builder();
                params.put((Object)"parent", (Object)String.valueOf(request.getParent()));
                return params.build();
            }
        }).build();
        GrpcCallSettings getGlossaryTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(getGlossaryMethodDescriptor).setParamsExtractor((RequestParamsExtractor)new RequestParamsExtractor<GetGlossaryRequest>(){

            public Map<String, String> extract(GetGlossaryRequest request) {
                ImmutableMap.Builder params = ImmutableMap.builder();
                params.put((Object)"name", (Object)String.valueOf(request.getName()));
                return params.build();
            }
        }).build();
        GrpcCallSettings deleteGlossaryTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(deleteGlossaryMethodDescriptor).setParamsExtractor((RequestParamsExtractor)new RequestParamsExtractor<DeleteGlossaryRequest>(){

            public Map<String, String> extract(DeleteGlossaryRequest request) {
                ImmutableMap.Builder params = ImmutableMap.builder();
                params.put((Object)"name", (Object)String.valueOf(request.getName()));
                return params.build();
            }
        }).build();
        this.translateTextCallable = callableFactory.createUnaryCallable(translateTextTransportSettings, settings.translateTextSettings(), clientContext);
        this.detectLanguageCallable = callableFactory.createUnaryCallable(detectLanguageTransportSettings, settings.detectLanguageSettings(), clientContext);
        this.getSupportedLanguagesCallable = callableFactory.createUnaryCallable(getSupportedLanguagesTransportSettings, settings.getSupportedLanguagesSettings(), clientContext);
        this.batchTranslateTextCallable = callableFactory.createUnaryCallable(batchTranslateTextTransportSettings, settings.batchTranslateTextSettings(), clientContext);
        this.batchTranslateTextOperationCallable = callableFactory.createOperationCallable(batchTranslateTextTransportSettings, settings.batchTranslateTextOperationSettings(), clientContext, (OperationsStub)this.operationsStub);
        this.createGlossaryCallable = callableFactory.createUnaryCallable(createGlossaryTransportSettings, settings.createGlossarySettings(), clientContext);
        this.createGlossaryOperationCallable = callableFactory.createOperationCallable(createGlossaryTransportSettings, settings.createGlossaryOperationSettings(), clientContext, (OperationsStub)this.operationsStub);
        this.listGlossariesCallable = callableFactory.createUnaryCallable(listGlossariesTransportSettings, settings.listGlossariesSettings(), clientContext);
        this.listGlossariesPagedCallable = callableFactory.createPagedCallable(listGlossariesTransportSettings, settings.listGlossariesSettings(), clientContext);
        this.getGlossaryCallable = callableFactory.createUnaryCallable(getGlossaryTransportSettings, settings.getGlossarySettings(), clientContext);
        this.deleteGlossaryCallable = callableFactory.createUnaryCallable(deleteGlossaryTransportSettings, settings.deleteGlossarySettings(), clientContext);
        this.deleteGlossaryOperationCallable = callableFactory.createOperationCallable(deleteGlossaryTransportSettings, settings.deleteGlossaryOperationSettings(), clientContext, (OperationsStub)this.operationsStub);
        this.backgroundResources = new BackgroundResourceAggregation(clientContext.getBackgroundResources());
    }

    public GrpcOperationsStub getOperationsStub() {
        return this.operationsStub;
    }

    @Override
    public UnaryCallable<TranslateTextRequest, TranslateTextResponse> translateTextCallable() {
        return this.translateTextCallable;
    }

    @Override
    public UnaryCallable<DetectLanguageRequest, DetectLanguageResponse> detectLanguageCallable() {
        return this.detectLanguageCallable;
    }

    @Override
    public UnaryCallable<GetSupportedLanguagesRequest, SupportedLanguages> getSupportedLanguagesCallable() {
        return this.getSupportedLanguagesCallable;
    }

    @Override
    public UnaryCallable<BatchTranslateTextRequest, Operation> batchTranslateTextCallable() {
        return this.batchTranslateTextCallable;
    }

    @Override
    public OperationCallable<BatchTranslateTextRequest, BatchTranslateResponse, BatchTranslateMetadata> batchTranslateTextOperationCallable() {
        return this.batchTranslateTextOperationCallable;
    }

    @Override
    public UnaryCallable<CreateGlossaryRequest, Operation> createGlossaryCallable() {
        return this.createGlossaryCallable;
    }

    @Override
    public OperationCallable<CreateGlossaryRequest, Glossary, CreateGlossaryMetadata> createGlossaryOperationCallable() {
        return this.createGlossaryOperationCallable;
    }

    @Override
    public UnaryCallable<ListGlossariesRequest, ListGlossariesResponse> listGlossariesCallable() {
        return this.listGlossariesCallable;
    }

    @Override
    public UnaryCallable<ListGlossariesRequest, TranslationServiceClient.ListGlossariesPagedResponse> listGlossariesPagedCallable() {
        return this.listGlossariesPagedCallable;
    }

    @Override
    public UnaryCallable<GetGlossaryRequest, Glossary> getGlossaryCallable() {
        return this.getGlossaryCallable;
    }

    @Override
    public UnaryCallable<DeleteGlossaryRequest, Operation> deleteGlossaryCallable() {
        return this.deleteGlossaryCallable;
    }

    @Override
    public OperationCallable<DeleteGlossaryRequest, DeleteGlossaryResponse, DeleteGlossaryMetadata> deleteGlossaryOperationCallable() {
        return this.deleteGlossaryOperationCallable;
    }

    @Override
    public final void close() {
        this.shutdown();
    }

    public void shutdown() {
        this.backgroundResources.shutdown();
    }

    public boolean isShutdown() {
        return this.backgroundResources.isShutdown();
    }

    public boolean isTerminated() {
        return this.backgroundResources.isTerminated();
    }

    public void shutdownNow() {
        this.backgroundResources.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.backgroundResources.awaitTermination(duration, unit);
    }
}

