/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.translate;

import com.google.api.services.translate.model.TranslationsResource;
import com.google.common.base.Function;
import com.google.common.base.MoreObjects;
import java.io.Serializable;
import java.util.Objects;

public class Translation
implements Serializable {
    private static final long serialVersionUID = 2556017420486245581L;
    static final Function<TranslationsResource, Translation> FROM_PB_FUNCTION = new Function<TranslationsResource, Translation>(){

        public Translation apply(TranslationsResource translationPb) {
            return Translation.fromPb(translationPb);
        }
    };
    private final String translatedText;
    private final String sourceLanguage;

    private Translation(String translatedText, String sourceLanguage) {
        this.translatedText = translatedText;
        this.sourceLanguage = sourceLanguage;
    }

    @Deprecated
    public String translatedText() {
        return this.translatedText;
    }

    public String getTranslatedText() {
        return this.translatedText;
    }

    @Deprecated
    public String sourceLanguage() {
        return this.getSourceLanguage();
    }

    public String getSourceLanguage() {
        return this.sourceLanguage;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("translatedText", (Object)this.translatedText).add("sourceLanguage", (Object)this.sourceLanguage).toString();
    }

    public final int hashCode() {
        return Objects.hash(this.translatedText, this.sourceLanguage);
    }

    public final boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || !obj.getClass().equals(Translation.class)) {
            return false;
        }
        Translation other = (Translation)obj;
        return Objects.equals(this.translatedText, other.translatedText) && Objects.equals(this.sourceLanguage, other.sourceLanguage);
    }

    static Translation fromPb(TranslationsResource translationPb) {
        return new Translation(translationPb.getTranslatedText(), translationPb.getDetectedSourceLanguage());
    }
}

