/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.translate;

import com.google.cloud.Service;
import com.google.cloud.translate.Detection;
import com.google.cloud.translate.Language;
import com.google.cloud.translate.Option;
import com.google.cloud.translate.TranslateOptions;
import com.google.cloud.translate.Translation;
import com.google.cloud.translate.spi.v2.TranslateRpc;
import java.util.List;

public interface Translate
extends Service<TranslateOptions> {
    public List<Language> listSupportedLanguages(LanguageListOption ... var1);

    public List<Detection> detect(List<String> var1);

    public List<Detection> detect(String ... var1);

    public Detection detect(String var1);

    public List<Translation> translate(List<String> var1, TranslateOption ... var2);

    public Translation translate(String var1, TranslateOption ... var2);

    public static class TranslateOption
    extends Option {
        private static final long serialVersionUID = 1347871763933507106L;

        private TranslateOption(TranslateRpc.Option rpcOption, String value) {
            super(rpcOption, value);
        }

        public static TranslateOption sourceLanguage(String sourceLanguage) {
            return new TranslateOption(TranslateRpc.Option.SOURCE_LANGUAGE, sourceLanguage);
        }

        public static TranslateOption targetLanguage(String targetLanguage) {
            return new TranslateOption(TranslateRpc.Option.TARGET_LANGUAGE, targetLanguage);
        }

        public static TranslateOption model(String model) {
            return new TranslateOption(TranslateRpc.Option.MODEL, model);
        }
    }

    public static class LanguageListOption
    extends Option {
        private static final long serialVersionUID = 1982978040516658597L;

        private LanguageListOption(TranslateRpc.Option rpcOption, String value) {
            super(rpcOption, value);
        }

        public static LanguageListOption targetLanguage(String targetLanguage) {
            return new LanguageListOption(TranslateRpc.Option.TARGET_LANGUAGE, targetLanguage);
        }
    }
}

