/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.translate.testing;

import com.google.cloud.HttpTransportOptions;
import com.google.cloud.RetryParams;
import com.google.cloud.TransportOptions;
import com.google.cloud.translate.TranslateOptions;

public class RemoteTranslateHelper {
    private final TranslateOptions options;

    private RemoteTranslateHelper(TranslateOptions options) {
        this.options = options;
    }

    public TranslateOptions getOptions() {
        return this.options;
    }

    public static RemoteTranslateHelper create(String apiKey) {
        HttpTransportOptions transportOptions = TranslateOptions.getDefaultHttpTransportOptions();
        transportOptions = transportOptions.toBuilder().setConnectTimeout(60000).setReadTimeout(60000).build();
        TranslateOptions translateOptions = ((TranslateOptions.Builder)TranslateOptions.newBuilder().setApiKey(apiKey).setRetryParams(RemoteTranslateHelper.retryParams())).setTransportOptions((TransportOptions)transportOptions).build();
        return new RemoteTranslateHelper(translateOptions);
    }

    public static RemoteTranslateHelper create() {
        HttpTransportOptions transportOptions = TranslateOptions.getDefaultHttpTransportOptions();
        transportOptions = transportOptions.toBuilder().setConnectTimeout(60000).setReadTimeout(60000).build();
        TranslateOptions translateOption = ((TranslateOptions.Builder)TranslateOptions.newBuilder().setRetryParams(RemoteTranslateHelper.retryParams())).setTransportOptions((TransportOptions)transportOptions).build();
        return new RemoteTranslateHelper(translateOption);
    }

    private static RetryParams retryParams() {
        return RetryParams.newBuilder().setRetryMaxAttempts(10).setRetryMinAttempts(6).setMaxRetryDelayMillis(30000L).setTotalRetryPeriodMillis(120000L).setInitialRetryDelayMillis(250L).build();
    }
}

