/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.talent.v4beta1.stub;

import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.core.BackgroundResourceAggregation;
import com.google.api.gax.grpc.GrpcCallSettings;
import com.google.api.gax.grpc.GrpcStubCallableFactory;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.RequestParamsBuilder;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.talent.v4beta1.CreateTenantRequest;
import com.google.cloud.talent.v4beta1.DeleteTenantRequest;
import com.google.cloud.talent.v4beta1.GetTenantRequest;
import com.google.cloud.talent.v4beta1.ListTenantsRequest;
import com.google.cloud.talent.v4beta1.ListTenantsResponse;
import com.google.cloud.talent.v4beta1.Tenant;
import com.google.cloud.talent.v4beta1.TenantServiceClient;
import com.google.cloud.talent.v4beta1.UpdateTenantRequest;
import com.google.cloud.talent.v4beta1.stub.GrpcTenantServiceCallableFactory;
import com.google.cloud.talent.v4beta1.stub.TenantServiceStub;
import com.google.cloud.talent.v4beta1.stub.TenantServiceStubSettings;
import com.google.longrunning.stub.GrpcOperationsStub;
import com.google.protobuf.Empty;
import com.google.protobuf.Message;
import io.grpc.MethodDescriptor;
import io.grpc.protobuf.ProtoUtils;
import java.io.IOException;
import java.util.concurrent.TimeUnit;

@BetaApi
public class GrpcTenantServiceStub
extends TenantServiceStub {
    private static final MethodDescriptor<CreateTenantRequest, Tenant> createTenantMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.talent.v4beta1.TenantService/CreateTenant").setRequestMarshaller(ProtoUtils.marshaller((Message)CreateTenantRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Tenant.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private static final MethodDescriptor<GetTenantRequest, Tenant> getTenantMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.talent.v4beta1.TenantService/GetTenant").setRequestMarshaller(ProtoUtils.marshaller((Message)GetTenantRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Tenant.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private static final MethodDescriptor<UpdateTenantRequest, Tenant> updateTenantMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.talent.v4beta1.TenantService/UpdateTenant").setRequestMarshaller(ProtoUtils.marshaller((Message)UpdateTenantRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Tenant.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private static final MethodDescriptor<DeleteTenantRequest, Empty> deleteTenantMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.talent.v4beta1.TenantService/DeleteTenant").setRequestMarshaller(ProtoUtils.marshaller((Message)DeleteTenantRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Empty.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private static final MethodDescriptor<ListTenantsRequest, ListTenantsResponse> listTenantsMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.talent.v4beta1.TenantService/ListTenants").setRequestMarshaller(ProtoUtils.marshaller((Message)ListTenantsRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)ListTenantsResponse.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private final UnaryCallable<CreateTenantRequest, Tenant> createTenantCallable;
    private final UnaryCallable<GetTenantRequest, Tenant> getTenantCallable;
    private final UnaryCallable<UpdateTenantRequest, Tenant> updateTenantCallable;
    private final UnaryCallable<DeleteTenantRequest, Empty> deleteTenantCallable;
    private final UnaryCallable<ListTenantsRequest, ListTenantsResponse> listTenantsCallable;
    private final UnaryCallable<ListTenantsRequest, TenantServiceClient.ListTenantsPagedResponse> listTenantsPagedCallable;
    private final BackgroundResource backgroundResources;
    private final GrpcOperationsStub operationsStub;
    private final GrpcStubCallableFactory callableFactory;

    public static final GrpcTenantServiceStub create(TenantServiceStubSettings settings) throws IOException {
        return new GrpcTenantServiceStub(settings, ClientContext.create((StubSettings)settings));
    }

    public static final GrpcTenantServiceStub create(ClientContext clientContext) throws IOException {
        return new GrpcTenantServiceStub(TenantServiceStubSettings.newBuilder().build(), clientContext);
    }

    public static final GrpcTenantServiceStub create(ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        return new GrpcTenantServiceStub(TenantServiceStubSettings.newBuilder().build(), clientContext, callableFactory);
    }

    protected GrpcTenantServiceStub(TenantServiceStubSettings settings, ClientContext clientContext) throws IOException {
        this(settings, clientContext, new GrpcTenantServiceCallableFactory());
    }

    protected GrpcTenantServiceStub(TenantServiceStubSettings settings, ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        this.callableFactory = callableFactory;
        this.operationsStub = GrpcOperationsStub.create((ClientContext)clientContext, (GrpcStubCallableFactory)callableFactory);
        GrpcCallSettings createTenantTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(createTenantMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parent", String.valueOf(request.getParent()));
            return builder.build();
        }).build();
        GrpcCallSettings getTenantTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(getTenantMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        GrpcCallSettings updateTenantTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(updateTenantMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("tenant.name", String.valueOf(request.getTenant().getName()));
            return builder.build();
        }).build();
        GrpcCallSettings deleteTenantTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(deleteTenantMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        GrpcCallSettings listTenantsTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(listTenantsMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parent", String.valueOf(request.getParent()));
            return builder.build();
        }).build();
        this.createTenantCallable = callableFactory.createUnaryCallable(createTenantTransportSettings, settings.createTenantSettings(), clientContext);
        this.getTenantCallable = callableFactory.createUnaryCallable(getTenantTransportSettings, settings.getTenantSettings(), clientContext);
        this.updateTenantCallable = callableFactory.createUnaryCallable(updateTenantTransportSettings, settings.updateTenantSettings(), clientContext);
        this.deleteTenantCallable = callableFactory.createUnaryCallable(deleteTenantTransportSettings, settings.deleteTenantSettings(), clientContext);
        this.listTenantsCallable = callableFactory.createUnaryCallable(listTenantsTransportSettings, settings.listTenantsSettings(), clientContext);
        this.listTenantsPagedCallable = callableFactory.createPagedCallable(listTenantsTransportSettings, settings.listTenantsSettings(), clientContext);
        this.backgroundResources = new BackgroundResourceAggregation(clientContext.getBackgroundResources());
    }

    public GrpcOperationsStub getOperationsStub() {
        return this.operationsStub;
    }

    @Override
    public UnaryCallable<CreateTenantRequest, Tenant> createTenantCallable() {
        return this.createTenantCallable;
    }

    @Override
    public UnaryCallable<GetTenantRequest, Tenant> getTenantCallable() {
        return this.getTenantCallable;
    }

    @Override
    public UnaryCallable<UpdateTenantRequest, Tenant> updateTenantCallable() {
        return this.updateTenantCallable;
    }

    @Override
    public UnaryCallable<DeleteTenantRequest, Empty> deleteTenantCallable() {
        return this.deleteTenantCallable;
    }

    @Override
    public UnaryCallable<ListTenantsRequest, ListTenantsResponse> listTenantsCallable() {
        return this.listTenantsCallable;
    }

    @Override
    public UnaryCallable<ListTenantsRequest, TenantServiceClient.ListTenantsPagedResponse> listTenantsPagedCallable() {
        return this.listTenantsPagedCallable;
    }

    @Override
    public final void close() {
        try {
            this.backgroundResources.close();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to close resource", e);
        }
    }

    public void shutdown() {
        this.backgroundResources.shutdown();
    }

    public boolean isShutdown() {
        return this.backgroundResources.isShutdown();
    }

    public boolean isTerminated() {
        return this.backgroundResources.isTerminated();
    }

    public void shutdownNow() {
        this.backgroundResources.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.backgroundResources.awaitTermination(duration, unit);
    }
}

