/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.talent.v4.stub;

import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.core.BackgroundResourceAggregation;
import com.google.api.gax.grpc.GrpcCallSettings;
import com.google.api.gax.grpc.GrpcStubCallableFactory;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.RequestParamsBuilder;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.talent.v4.Company;
import com.google.cloud.talent.v4.CompanyServiceClient;
import com.google.cloud.talent.v4.CreateCompanyRequest;
import com.google.cloud.talent.v4.DeleteCompanyRequest;
import com.google.cloud.talent.v4.GetCompanyRequest;
import com.google.cloud.talent.v4.ListCompaniesRequest;
import com.google.cloud.talent.v4.ListCompaniesResponse;
import com.google.cloud.talent.v4.UpdateCompanyRequest;
import com.google.cloud.talent.v4.stub.CompanyServiceStub;
import com.google.cloud.talent.v4.stub.CompanyServiceStubSettings;
import com.google.cloud.talent.v4.stub.GrpcCompanyServiceCallableFactory;
import com.google.longrunning.stub.GrpcOperationsStub;
import com.google.protobuf.Empty;
import com.google.protobuf.Message;
import io.grpc.MethodDescriptor;
import io.grpc.protobuf.ProtoUtils;
import java.io.IOException;
import java.util.concurrent.TimeUnit;

public class GrpcCompanyServiceStub
extends CompanyServiceStub {
    private static final MethodDescriptor<CreateCompanyRequest, Company> createCompanyMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.talent.v4.CompanyService/CreateCompany").setRequestMarshaller(ProtoUtils.marshaller((Message)CreateCompanyRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Company.getDefaultInstance())).build();
    private static final MethodDescriptor<GetCompanyRequest, Company> getCompanyMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.talent.v4.CompanyService/GetCompany").setRequestMarshaller(ProtoUtils.marshaller((Message)GetCompanyRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Company.getDefaultInstance())).build();
    private static final MethodDescriptor<UpdateCompanyRequest, Company> updateCompanyMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.talent.v4.CompanyService/UpdateCompany").setRequestMarshaller(ProtoUtils.marshaller((Message)UpdateCompanyRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Company.getDefaultInstance())).build();
    private static final MethodDescriptor<DeleteCompanyRequest, Empty> deleteCompanyMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.talent.v4.CompanyService/DeleteCompany").setRequestMarshaller(ProtoUtils.marshaller((Message)DeleteCompanyRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Empty.getDefaultInstance())).build();
    private static final MethodDescriptor<ListCompaniesRequest, ListCompaniesResponse> listCompaniesMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.talent.v4.CompanyService/ListCompanies").setRequestMarshaller(ProtoUtils.marshaller((Message)ListCompaniesRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)ListCompaniesResponse.getDefaultInstance())).build();
    private final UnaryCallable<CreateCompanyRequest, Company> createCompanyCallable;
    private final UnaryCallable<GetCompanyRequest, Company> getCompanyCallable;
    private final UnaryCallable<UpdateCompanyRequest, Company> updateCompanyCallable;
    private final UnaryCallable<DeleteCompanyRequest, Empty> deleteCompanyCallable;
    private final UnaryCallable<ListCompaniesRequest, ListCompaniesResponse> listCompaniesCallable;
    private final UnaryCallable<ListCompaniesRequest, CompanyServiceClient.ListCompaniesPagedResponse> listCompaniesPagedCallable;
    private final BackgroundResource backgroundResources;
    private final GrpcOperationsStub operationsStub;
    private final GrpcStubCallableFactory callableFactory;

    public static final GrpcCompanyServiceStub create(CompanyServiceStubSettings settings) throws IOException {
        return new GrpcCompanyServiceStub(settings, ClientContext.create((StubSettings)settings));
    }

    public static final GrpcCompanyServiceStub create(ClientContext clientContext) throws IOException {
        return new GrpcCompanyServiceStub(CompanyServiceStubSettings.newBuilder().build(), clientContext);
    }

    public static final GrpcCompanyServiceStub create(ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        return new GrpcCompanyServiceStub(CompanyServiceStubSettings.newBuilder().build(), clientContext, callableFactory);
    }

    protected GrpcCompanyServiceStub(CompanyServiceStubSettings settings, ClientContext clientContext) throws IOException {
        this(settings, clientContext, new GrpcCompanyServiceCallableFactory());
    }

    protected GrpcCompanyServiceStub(CompanyServiceStubSettings settings, ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        this.callableFactory = callableFactory;
        this.operationsStub = GrpcOperationsStub.create((ClientContext)clientContext, (GrpcStubCallableFactory)callableFactory);
        GrpcCallSettings createCompanyTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(createCompanyMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parent", String.valueOf(request.getParent()));
            return builder.build();
        }).build();
        GrpcCallSettings getCompanyTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(getCompanyMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        GrpcCallSettings updateCompanyTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(updateCompanyMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("company.name", String.valueOf(request.getCompany().getName()));
            return builder.build();
        }).build();
        GrpcCallSettings deleteCompanyTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(deleteCompanyMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        GrpcCallSettings listCompaniesTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(listCompaniesMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parent", String.valueOf(request.getParent()));
            return builder.build();
        }).build();
        this.createCompanyCallable = callableFactory.createUnaryCallable(createCompanyTransportSettings, settings.createCompanySettings(), clientContext);
        this.getCompanyCallable = callableFactory.createUnaryCallable(getCompanyTransportSettings, settings.getCompanySettings(), clientContext);
        this.updateCompanyCallable = callableFactory.createUnaryCallable(updateCompanyTransportSettings, settings.updateCompanySettings(), clientContext);
        this.deleteCompanyCallable = callableFactory.createUnaryCallable(deleteCompanyTransportSettings, settings.deleteCompanySettings(), clientContext);
        this.listCompaniesCallable = callableFactory.createUnaryCallable(listCompaniesTransportSettings, settings.listCompaniesSettings(), clientContext);
        this.listCompaniesPagedCallable = callableFactory.createPagedCallable(listCompaniesTransportSettings, settings.listCompaniesSettings(), clientContext);
        this.backgroundResources = new BackgroundResourceAggregation(clientContext.getBackgroundResources());
    }

    public GrpcOperationsStub getOperationsStub() {
        return this.operationsStub;
    }

    @Override
    public UnaryCallable<CreateCompanyRequest, Company> createCompanyCallable() {
        return this.createCompanyCallable;
    }

    @Override
    public UnaryCallable<GetCompanyRequest, Company> getCompanyCallable() {
        return this.getCompanyCallable;
    }

    @Override
    public UnaryCallable<UpdateCompanyRequest, Company> updateCompanyCallable() {
        return this.updateCompanyCallable;
    }

    @Override
    public UnaryCallable<DeleteCompanyRequest, Empty> deleteCompanyCallable() {
        return this.deleteCompanyCallable;
    }

    @Override
    public UnaryCallable<ListCompaniesRequest, ListCompaniesResponse> listCompaniesCallable() {
        return this.listCompaniesCallable;
    }

    @Override
    public UnaryCallable<ListCompaniesRequest, CompanyServiceClient.ListCompaniesPagedResponse> listCompaniesPagedCallable() {
        return this.listCompaniesPagedCallable;
    }

    @Override
    public final void close() {
        try {
            this.backgroundResources.close();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to close resource", e);
        }
    }

    public void shutdown() {
        this.backgroundResources.shutdown();
    }

    public boolean isShutdown() {
        return this.backgroundResources.isShutdown();
    }

    public boolean isTerminated() {
        return this.backgroundResources.isTerminated();
    }

    public void shutdownNow() {
        this.backgroundResources.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.backgroundResources.awaitTermination(duration, unit);
    }
}

