/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.talent.v4.stub;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.GaxProperties;
import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.api.gax.grpc.GaxGrpcProperties;
import com.google.api.gax.grpc.GrpcTransportChannel;
import com.google.api.gax.grpc.InstantiatingGrpcChannelProvider;
import com.google.api.gax.grpc.ProtoOperationTransformers;
import com.google.api.gax.longrunning.OperationTimedPollAlgorithm;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.retrying.TimedRetryAlgorithm;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.OperationCallSettings;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.PagedCallSettings;
import com.google.api.gax.rpc.PagedListDescriptor;
import com.google.api.gax.rpc.PagedListResponseFactory;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.talent.v4.BatchCreateJobsRequest;
import com.google.cloud.talent.v4.BatchCreateJobsResponse;
import com.google.cloud.talent.v4.BatchDeleteJobsRequest;
import com.google.cloud.talent.v4.BatchDeleteJobsResponse;
import com.google.cloud.talent.v4.BatchOperationMetadata;
import com.google.cloud.talent.v4.BatchUpdateJobsRequest;
import com.google.cloud.talent.v4.BatchUpdateJobsResponse;
import com.google.cloud.talent.v4.CreateJobRequest;
import com.google.cloud.talent.v4.DeleteJobRequest;
import com.google.cloud.talent.v4.GetJobRequest;
import com.google.cloud.talent.v4.Job;
import com.google.cloud.talent.v4.JobServiceClient;
import com.google.cloud.talent.v4.ListJobsRequest;
import com.google.cloud.talent.v4.ListJobsResponse;
import com.google.cloud.talent.v4.SearchJobsRequest;
import com.google.cloud.talent.v4.SearchJobsResponse;
import com.google.cloud.talent.v4.UpdateJobRequest;
import com.google.cloud.talent.v4.stub.GrpcJobServiceStub;
import com.google.cloud.talent.v4.stub.JobServiceStub;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.longrunning.Operation;
import com.google.protobuf.Empty;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.threeten.bp.Duration;

@BetaApi
public class JobServiceStubSettings
extends StubSettings<JobServiceStubSettings> {
    private static final ImmutableList<String> DEFAULT_SERVICE_SCOPES = ImmutableList.builder().add((Object)"https://www.googleapis.com/auth/cloud-platform").add((Object)"https://www.googleapis.com/auth/jobs").build();
    private final UnaryCallSettings<CreateJobRequest, Job> createJobSettings;
    private final UnaryCallSettings<BatchCreateJobsRequest, Operation> batchCreateJobsSettings;
    private final OperationCallSettings<BatchCreateJobsRequest, BatchCreateJobsResponse, BatchOperationMetadata> batchCreateJobsOperationSettings;
    private final UnaryCallSettings<GetJobRequest, Job> getJobSettings;
    private final UnaryCallSettings<UpdateJobRequest, Job> updateJobSettings;
    private final UnaryCallSettings<BatchUpdateJobsRequest, Operation> batchUpdateJobsSettings;
    private final OperationCallSettings<BatchUpdateJobsRequest, BatchUpdateJobsResponse, BatchOperationMetadata> batchUpdateJobsOperationSettings;
    private final UnaryCallSettings<DeleteJobRequest, Empty> deleteJobSettings;
    private final UnaryCallSettings<BatchDeleteJobsRequest, Operation> batchDeleteJobsSettings;
    private final OperationCallSettings<BatchDeleteJobsRequest, BatchDeleteJobsResponse, BatchOperationMetadata> batchDeleteJobsOperationSettings;
    private final PagedCallSettings<ListJobsRequest, ListJobsResponse, JobServiceClient.ListJobsPagedResponse> listJobsSettings;
    private final UnaryCallSettings<SearchJobsRequest, SearchJobsResponse> searchJobsSettings;
    private final UnaryCallSettings<SearchJobsRequest, SearchJobsResponse> searchJobsForAlertSettings;
    private static final PagedListDescriptor<ListJobsRequest, ListJobsResponse, Job> LIST_JOBS_PAGE_STR_DESC = new PagedListDescriptor<ListJobsRequest, ListJobsResponse, Job>(){

        public String emptyToken() {
            return "";
        }

        public ListJobsRequest injectToken(ListJobsRequest payload, String token) {
            return ListJobsRequest.newBuilder((ListJobsRequest)payload).setPageToken(token).build();
        }

        public ListJobsRequest injectPageSize(ListJobsRequest payload, int pageSize) {
            return ListJobsRequest.newBuilder((ListJobsRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListJobsRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListJobsResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<Job> extractResources(ListJobsResponse payload) {
            return payload.getJobsList() == null ? ImmutableList.of() : payload.getJobsList();
        }
    };
    private static final PagedListResponseFactory<ListJobsRequest, ListJobsResponse, JobServiceClient.ListJobsPagedResponse> LIST_JOBS_PAGE_STR_FACT = new PagedListResponseFactory<ListJobsRequest, ListJobsResponse, JobServiceClient.ListJobsPagedResponse>(){

        public ApiFuture<JobServiceClient.ListJobsPagedResponse> getFuturePagedResponse(UnaryCallable<ListJobsRequest, ListJobsResponse> callable, ListJobsRequest request, ApiCallContext context, ApiFuture<ListJobsResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_JOBS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return JobServiceClient.ListJobsPagedResponse.createAsync((PageContext<ListJobsRequest, ListJobsResponse, Job>)pageContext, futureResponse);
        }
    };

    public UnaryCallSettings<CreateJobRequest, Job> createJobSettings() {
        return this.createJobSettings;
    }

    public UnaryCallSettings<BatchCreateJobsRequest, Operation> batchCreateJobsSettings() {
        return this.batchCreateJobsSettings;
    }

    public OperationCallSettings<BatchCreateJobsRequest, BatchCreateJobsResponse, BatchOperationMetadata> batchCreateJobsOperationSettings() {
        return this.batchCreateJobsOperationSettings;
    }

    public UnaryCallSettings<GetJobRequest, Job> getJobSettings() {
        return this.getJobSettings;
    }

    public UnaryCallSettings<UpdateJobRequest, Job> updateJobSettings() {
        return this.updateJobSettings;
    }

    public UnaryCallSettings<BatchUpdateJobsRequest, Operation> batchUpdateJobsSettings() {
        return this.batchUpdateJobsSettings;
    }

    public OperationCallSettings<BatchUpdateJobsRequest, BatchUpdateJobsResponse, BatchOperationMetadata> batchUpdateJobsOperationSettings() {
        return this.batchUpdateJobsOperationSettings;
    }

    public UnaryCallSettings<DeleteJobRequest, Empty> deleteJobSettings() {
        return this.deleteJobSettings;
    }

    public UnaryCallSettings<BatchDeleteJobsRequest, Operation> batchDeleteJobsSettings() {
        return this.batchDeleteJobsSettings;
    }

    public OperationCallSettings<BatchDeleteJobsRequest, BatchDeleteJobsResponse, BatchOperationMetadata> batchDeleteJobsOperationSettings() {
        return this.batchDeleteJobsOperationSettings;
    }

    public PagedCallSettings<ListJobsRequest, ListJobsResponse, JobServiceClient.ListJobsPagedResponse> listJobsSettings() {
        return this.listJobsSettings;
    }

    public UnaryCallSettings<SearchJobsRequest, SearchJobsResponse> searchJobsSettings() {
        return this.searchJobsSettings;
    }

    public UnaryCallSettings<SearchJobsRequest, SearchJobsResponse> searchJobsForAlertSettings() {
        return this.searchJobsForAlertSettings;
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public JobServiceStub createStub() throws IOException {
        if (this.getTransportChannelProvider().getTransportName().equals(GrpcTransportChannel.getGrpcTransportName())) {
            return GrpcJobServiceStub.create(this);
        }
        throw new UnsupportedOperationException(String.format("Transport not supported: %s", this.getTransportChannelProvider().getTransportName()));
    }

    public static InstantiatingExecutorProvider.Builder defaultExecutorProviderBuilder() {
        return InstantiatingExecutorProvider.newBuilder();
    }

    public static String getDefaultEndpoint() {
        return "jobs.googleapis.com:443";
    }

    public static List<String> getDefaultServiceScopes() {
        return DEFAULT_SERVICE_SCOPES;
    }

    public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
        return GoogleCredentialsProvider.newBuilder().setScopesToApply(DEFAULT_SERVICE_SCOPES);
    }

    public static InstantiatingGrpcChannelProvider.Builder defaultGrpcTransportProviderBuilder() {
        return InstantiatingGrpcChannelProvider.newBuilder().setMaxInboundMessageSize(Integer.valueOf(Integer.MAX_VALUE));
    }

    public static TransportChannelProvider defaultTransportChannelProvider() {
        return JobServiceStubSettings.defaultGrpcTransportProviderBuilder().build();
    }

    @BetaApi(value="The surface for customizing headers is not stable yet and may change in the future.")
    public static ApiClientHeaderProvider.Builder defaultApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(JobServiceStubSettings.class)).setTransportToken(GaxGrpcProperties.getGrpcTokenName(), GaxGrpcProperties.getGrpcVersion());
    }

    public static Builder newBuilder() {
        return Builder.createDefault();
    }

    public static Builder newBuilder(ClientContext clientContext) {
        return new Builder(clientContext);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    protected JobServiceStubSettings(Builder settingsBuilder) throws IOException {
        super((StubSettings.Builder)settingsBuilder);
        this.createJobSettings = settingsBuilder.createJobSettings().build();
        this.batchCreateJobsSettings = settingsBuilder.batchCreateJobsSettings().build();
        this.batchCreateJobsOperationSettings = settingsBuilder.batchCreateJobsOperationSettings().build();
        this.getJobSettings = settingsBuilder.getJobSettings().build();
        this.updateJobSettings = settingsBuilder.updateJobSettings().build();
        this.batchUpdateJobsSettings = settingsBuilder.batchUpdateJobsSettings().build();
        this.batchUpdateJobsOperationSettings = settingsBuilder.batchUpdateJobsOperationSettings().build();
        this.deleteJobSettings = settingsBuilder.deleteJobSettings().build();
        this.batchDeleteJobsSettings = settingsBuilder.batchDeleteJobsSettings().build();
        this.batchDeleteJobsOperationSettings = settingsBuilder.batchDeleteJobsOperationSettings().build();
        this.listJobsSettings = settingsBuilder.listJobsSettings().build();
        this.searchJobsSettings = settingsBuilder.searchJobsSettings().build();
        this.searchJobsForAlertSettings = settingsBuilder.searchJobsForAlertSettings().build();
    }

    public static class Builder
    extends StubSettings.Builder<JobServiceStubSettings, Builder> {
        private final ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders;
        private final UnaryCallSettings.Builder<CreateJobRequest, Job> createJobSettings;
        private final UnaryCallSettings.Builder<BatchCreateJobsRequest, Operation> batchCreateJobsSettings;
        private final OperationCallSettings.Builder<BatchCreateJobsRequest, BatchCreateJobsResponse, BatchOperationMetadata> batchCreateJobsOperationSettings;
        private final UnaryCallSettings.Builder<GetJobRequest, Job> getJobSettings;
        private final UnaryCallSettings.Builder<UpdateJobRequest, Job> updateJobSettings;
        private final UnaryCallSettings.Builder<BatchUpdateJobsRequest, Operation> batchUpdateJobsSettings;
        private final OperationCallSettings.Builder<BatchUpdateJobsRequest, BatchUpdateJobsResponse, BatchOperationMetadata> batchUpdateJobsOperationSettings;
        private final UnaryCallSettings.Builder<DeleteJobRequest, Empty> deleteJobSettings;
        private final UnaryCallSettings.Builder<BatchDeleteJobsRequest, Operation> batchDeleteJobsSettings;
        private final OperationCallSettings.Builder<BatchDeleteJobsRequest, BatchDeleteJobsResponse, BatchOperationMetadata> batchDeleteJobsOperationSettings;
        private final PagedCallSettings.Builder<ListJobsRequest, ListJobsResponse, JobServiceClient.ListJobsPagedResponse> listJobsSettings;
        private final UnaryCallSettings.Builder<SearchJobsRequest, SearchJobsResponse> searchJobsSettings;
        private final UnaryCallSettings.Builder<SearchJobsRequest, SearchJobsResponse> searchJobsForAlertSettings;
        private static final ImmutableMap<String, ImmutableSet<StatusCode.Code>> RETRYABLE_CODE_DEFINITIONS;
        private static final ImmutableMap<String, RetrySettings> RETRY_PARAM_DEFINITIONS;

        protected Builder() {
            this((ClientContext)null);
        }

        protected Builder(ClientContext clientContext) {
            super(clientContext);
            this.createJobSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.batchCreateJobsSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.batchCreateJobsOperationSettings = OperationCallSettings.newBuilder();
            this.getJobSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.updateJobSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.batchUpdateJobsSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.batchUpdateJobsOperationSettings = OperationCallSettings.newBuilder();
            this.deleteJobSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.batchDeleteJobsSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.batchDeleteJobsOperationSettings = OperationCallSettings.newBuilder();
            this.listJobsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_JOBS_PAGE_STR_FACT);
            this.searchJobsSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.searchJobsForAlertSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.createJobSettings, this.batchCreateJobsSettings, this.getJobSettings, this.updateJobSettings, this.batchUpdateJobsSettings, this.deleteJobSettings, this.batchDeleteJobsSettings, this.listJobsSettings, this.searchJobsSettings, this.searchJobsForAlertSettings);
            Builder.initDefaults(this);
        }

        protected Builder(JobServiceStubSettings settings) {
            super((StubSettings)settings);
            this.createJobSettings = settings.createJobSettings.toBuilder();
            this.batchCreateJobsSettings = settings.batchCreateJobsSettings.toBuilder();
            this.batchCreateJobsOperationSettings = settings.batchCreateJobsOperationSettings.toBuilder();
            this.getJobSettings = settings.getJobSettings.toBuilder();
            this.updateJobSettings = settings.updateJobSettings.toBuilder();
            this.batchUpdateJobsSettings = settings.batchUpdateJobsSettings.toBuilder();
            this.batchUpdateJobsOperationSettings = settings.batchUpdateJobsOperationSettings.toBuilder();
            this.deleteJobSettings = settings.deleteJobSettings.toBuilder();
            this.batchDeleteJobsSettings = settings.batchDeleteJobsSettings.toBuilder();
            this.batchDeleteJobsOperationSettings = settings.batchDeleteJobsOperationSettings.toBuilder();
            this.listJobsSettings = settings.listJobsSettings.toBuilder();
            this.searchJobsSettings = settings.searchJobsSettings.toBuilder();
            this.searchJobsForAlertSettings = settings.searchJobsForAlertSettings.toBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.createJobSettings, this.batchCreateJobsSettings, this.getJobSettings, this.updateJobSettings, this.batchUpdateJobsSettings, this.deleteJobSettings, this.batchDeleteJobsSettings, this.listJobsSettings, this.searchJobsSettings, this.searchJobsForAlertSettings);
        }

        private static Builder createDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider(JobServiceStubSettings.defaultTransportChannelProvider());
            builder.setCredentialsProvider((CredentialsProvider)JobServiceStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)JobServiceStubSettings.defaultApiClientHeaderProviderBuilder().build());
            builder.setEndpoint(JobServiceStubSettings.getDefaultEndpoint());
            return Builder.initDefaults(builder);
        }

        private static Builder initDefaults(Builder builder) {
            builder.createJobSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_3_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_3_params"));
            builder.batchCreateJobsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_3_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_3_params"));
            builder.getJobSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_2_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_2_params"));
            builder.updateJobSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_3_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_3_params"));
            builder.batchUpdateJobsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_3_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_3_params"));
            builder.deleteJobSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_2_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_2_params"));
            builder.batchDeleteJobsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_3_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_3_params"));
            builder.listJobsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_2_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_2_params"));
            builder.searchJobsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_3_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_3_params"));
            builder.searchJobsForAlertSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_3_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_3_params"));
            builder.batchCreateJobsOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_3_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_3_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(BatchCreateJobsResponse.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(BatchOperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            builder.batchUpdateJobsOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_3_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_3_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(BatchUpdateJobsResponse.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(BatchOperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            builder.batchDeleteJobsOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_3_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_3_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(BatchDeleteJobsResponse.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(BatchOperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            return builder;
        }

        public Builder applyToAllUnaryMethods(ApiFunction<UnaryCallSettings.Builder<?, ?>, Void> settingsUpdater) throws Exception {
            StubSettings.Builder.applyToAllUnaryMethods(this.unaryMethodSettingsBuilders, settingsUpdater);
            return this;
        }

        public ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders() {
            return this.unaryMethodSettingsBuilders;
        }

        public UnaryCallSettings.Builder<CreateJobRequest, Job> createJobSettings() {
            return this.createJobSettings;
        }

        public UnaryCallSettings.Builder<BatchCreateJobsRequest, Operation> batchCreateJobsSettings() {
            return this.batchCreateJobsSettings;
        }

        @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
        public OperationCallSettings.Builder<BatchCreateJobsRequest, BatchCreateJobsResponse, BatchOperationMetadata> batchCreateJobsOperationSettings() {
            return this.batchCreateJobsOperationSettings;
        }

        public UnaryCallSettings.Builder<GetJobRequest, Job> getJobSettings() {
            return this.getJobSettings;
        }

        public UnaryCallSettings.Builder<UpdateJobRequest, Job> updateJobSettings() {
            return this.updateJobSettings;
        }

        public UnaryCallSettings.Builder<BatchUpdateJobsRequest, Operation> batchUpdateJobsSettings() {
            return this.batchUpdateJobsSettings;
        }

        @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
        public OperationCallSettings.Builder<BatchUpdateJobsRequest, BatchUpdateJobsResponse, BatchOperationMetadata> batchUpdateJobsOperationSettings() {
            return this.batchUpdateJobsOperationSettings;
        }

        public UnaryCallSettings.Builder<DeleteJobRequest, Empty> deleteJobSettings() {
            return this.deleteJobSettings;
        }

        public UnaryCallSettings.Builder<BatchDeleteJobsRequest, Operation> batchDeleteJobsSettings() {
            return this.batchDeleteJobsSettings;
        }

        @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
        public OperationCallSettings.Builder<BatchDeleteJobsRequest, BatchDeleteJobsResponse, BatchOperationMetadata> batchDeleteJobsOperationSettings() {
            return this.batchDeleteJobsOperationSettings;
        }

        public PagedCallSettings.Builder<ListJobsRequest, ListJobsResponse, JobServiceClient.ListJobsPagedResponse> listJobsSettings() {
            return this.listJobsSettings;
        }

        public UnaryCallSettings.Builder<SearchJobsRequest, SearchJobsResponse> searchJobsSettings() {
            return this.searchJobsSettings;
        }

        public UnaryCallSettings.Builder<SearchJobsRequest, SearchJobsResponse> searchJobsForAlertSettings() {
            return this.searchJobsForAlertSettings;
        }

        public JobServiceStubSettings build() throws IOException {
            return new JobServiceStubSettings(this);
        }

        static {
            ImmutableMap.Builder definitions = ImmutableMap.builder();
            definitions.put((Object)"no_retry_3_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList()));
            definitions.put((Object)"retry_policy_2_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList((Object[])new StatusCode.Code[]{StatusCode.Code.DEADLINE_EXCEEDED, StatusCode.Code.UNAVAILABLE})));
            RETRYABLE_CODE_DEFINITIONS = definitions.build();
            definitions = ImmutableMap.builder();
            RetrySettings settings = null;
            settings = RetrySettings.newBuilder().setInitialRpcTimeout(Duration.ofMillis((long)30000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ofMillis((long)30000L)).setTotalTimeout(Duration.ofMillis((long)30000L)).build();
            definitions.put((Object)"no_retry_3_params", (Object)settings);
            settings = RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)100L)).setRetryDelayMultiplier(1.3).setMaxRetryDelay(Duration.ofMillis((long)60000L)).setInitialRpcTimeout(Duration.ofMillis((long)30000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ofMillis((long)30000L)).setTotalTimeout(Duration.ofMillis((long)30000L)).build();
            definitions.put((Object)"retry_policy_2_params", (Object)settings);
            RETRY_PARAM_DEFINITIONS = definitions.build();
        }
    }
}

