/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.talent.v4beta1;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.talent.v4beta1.CreateProfileRequest;
import com.google.cloud.talent.v4beta1.DeleteProfileRequest;
import com.google.cloud.talent.v4beta1.GetProfileRequest;
import com.google.cloud.talent.v4beta1.ListProfilesRequest;
import com.google.cloud.talent.v4beta1.ListProfilesResponse;
import com.google.cloud.talent.v4beta1.Profile;
import com.google.cloud.talent.v4beta1.ProfileName;
import com.google.cloud.talent.v4beta1.ProfileServiceSettings;
import com.google.cloud.talent.v4beta1.SearchProfilesRequest;
import com.google.cloud.talent.v4beta1.SearchProfilesResponse;
import com.google.cloud.talent.v4beta1.SummarizedProfile;
import com.google.cloud.talent.v4beta1.TenantName;
import com.google.cloud.talent.v4beta1.UpdateProfileRequest;
import com.google.cloud.talent.v4beta1.stub.ProfileServiceStub;
import com.google.cloud.talent.v4beta1.stub.ProfileServiceStubSettings;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.protobuf.Empty;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

@BetaApi
public class ProfileServiceClient
implements BackgroundResource {
    private final ProfileServiceSettings settings;
    private final ProfileServiceStub stub;

    public static final ProfileServiceClient create() throws IOException {
        return ProfileServiceClient.create(ProfileServiceSettings.newBuilder().build());
    }

    public static final ProfileServiceClient create(ProfileServiceSettings settings) throws IOException {
        return new ProfileServiceClient(settings);
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public static final ProfileServiceClient create(ProfileServiceStub stub) {
        return new ProfileServiceClient(stub);
    }

    protected ProfileServiceClient(ProfileServiceSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((ProfileServiceStubSettings)settings.getStubSettings()).createStub();
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    protected ProfileServiceClient(ProfileServiceStub stub) {
        this.settings = null;
        this.stub = stub;
    }

    public final ProfileServiceSettings getSettings() {
        return this.settings;
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public ProfileServiceStub getStub() {
        return this.stub;
    }

    public final SearchProfilesPagedResponse searchProfiles(SearchProfilesRequest request) {
        return (SearchProfilesPagedResponse)((Object)this.searchProfilesPagedCallable().call((Object)request));
    }

    public final UnaryCallable<SearchProfilesRequest, SearchProfilesPagedResponse> searchProfilesPagedCallable() {
        return this.stub.searchProfilesPagedCallable();
    }

    public final UnaryCallable<SearchProfilesRequest, SearchProfilesResponse> searchProfilesCallable() {
        return this.stub.searchProfilesCallable();
    }

    public final ListProfilesPagedResponse listProfiles(TenantName parent) {
        ListProfilesRequest request = ListProfilesRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listProfiles(request);
    }

    public final ListProfilesPagedResponse listProfiles(String parent) {
        ListProfilesRequest request = ListProfilesRequest.newBuilder().setParent(parent).build();
        return this.listProfiles(request);
    }

    public final ListProfilesPagedResponse listProfiles(ListProfilesRequest request) {
        return (ListProfilesPagedResponse)((Object)this.listProfilesPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListProfilesRequest, ListProfilesPagedResponse> listProfilesPagedCallable() {
        return this.stub.listProfilesPagedCallable();
    }

    public final UnaryCallable<ListProfilesRequest, ListProfilesResponse> listProfilesCallable() {
        return this.stub.listProfilesCallable();
    }

    public final Profile createProfile(TenantName parent, Profile profile) {
        CreateProfileRequest request = CreateProfileRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setProfile(profile).build();
        return this.createProfile(request);
    }

    public final Profile createProfile(String parent, Profile profile) {
        CreateProfileRequest request = CreateProfileRequest.newBuilder().setParent(parent).setProfile(profile).build();
        return this.createProfile(request);
    }

    public final Profile createProfile(CreateProfileRequest request) {
        return (Profile)this.createProfileCallable().call((Object)request);
    }

    public final UnaryCallable<CreateProfileRequest, Profile> createProfileCallable() {
        return this.stub.createProfileCallable();
    }

    public final Profile getProfile(ProfileName name) {
        GetProfileRequest request = GetProfileRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getProfile(request);
    }

    public final Profile getProfile(String name) {
        GetProfileRequest request = GetProfileRequest.newBuilder().setName(name).build();
        return this.getProfile(request);
    }

    public final Profile getProfile(GetProfileRequest request) {
        return (Profile)this.getProfileCallable().call((Object)request);
    }

    public final UnaryCallable<GetProfileRequest, Profile> getProfileCallable() {
        return this.stub.getProfileCallable();
    }

    public final Profile updateProfile(Profile profile) {
        UpdateProfileRequest request = UpdateProfileRequest.newBuilder().setProfile(profile).build();
        return this.updateProfile(request);
    }

    public final Profile updateProfile(UpdateProfileRequest request) {
        return (Profile)this.updateProfileCallable().call((Object)request);
    }

    public final UnaryCallable<UpdateProfileRequest, Profile> updateProfileCallable() {
        return this.stub.updateProfileCallable();
    }

    public final void deleteProfile(ProfileName name) {
        DeleteProfileRequest request = DeleteProfileRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        this.deleteProfile(request);
    }

    public final void deleteProfile(String name) {
        DeleteProfileRequest request = DeleteProfileRequest.newBuilder().setName(name).build();
        this.deleteProfile(request);
    }

    public final void deleteProfile(DeleteProfileRequest request) {
        this.deleteProfileCallable().call((Object)request);
    }

    public final UnaryCallable<DeleteProfileRequest, Empty> deleteProfileCallable() {
        return this.stub.deleteProfileCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class ListProfilesFixedSizeCollection
    extends AbstractFixedSizeCollection<ListProfilesRequest, ListProfilesResponse, Profile, ListProfilesPage, ListProfilesFixedSizeCollection> {
        private ListProfilesFixedSizeCollection(List<ListProfilesPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListProfilesFixedSizeCollection createEmptyCollection() {
            return new ListProfilesFixedSizeCollection(null, 0);
        }

        protected ListProfilesFixedSizeCollection createCollection(List<ListProfilesPage> pages, int collectionSize) {
            return new ListProfilesFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListProfilesPage
    extends AbstractPage<ListProfilesRequest, ListProfilesResponse, Profile, ListProfilesPage> {
        private ListProfilesPage(PageContext<ListProfilesRequest, ListProfilesResponse, Profile> context, ListProfilesResponse response) {
            super(context, (Object)response);
        }

        private static ListProfilesPage createEmptyPage() {
            return new ListProfilesPage(null, null);
        }

        protected ListProfilesPage createPage(PageContext<ListProfilesRequest, ListProfilesResponse, Profile> context, ListProfilesResponse response) {
            return new ListProfilesPage(context, response);
        }

        public ApiFuture<ListProfilesPage> createPageAsync(PageContext<ListProfilesRequest, ListProfilesResponse, Profile> context, ApiFuture<ListProfilesResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListProfilesPagedResponse
    extends AbstractPagedListResponse<ListProfilesRequest, ListProfilesResponse, Profile, ListProfilesPage, ListProfilesFixedSizeCollection> {
        public static ApiFuture<ListProfilesPagedResponse> createAsync(PageContext<ListProfilesRequest, ListProfilesResponse, Profile> context, ApiFuture<ListProfilesResponse> futureResponse) {
            ApiFuture<ListProfilesPage> futurePage = ListProfilesPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, (ApiFunction)new ApiFunction<ListProfilesPage, ListProfilesPagedResponse>(){

                public ListProfilesPagedResponse apply(ListProfilesPage input) {
                    return new ListProfilesPagedResponse(input);
                }
            }, (Executor)MoreExecutors.directExecutor());
        }

        private ListProfilesPagedResponse(ListProfilesPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListProfilesFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class SearchProfilesFixedSizeCollection
    extends AbstractFixedSizeCollection<SearchProfilesRequest, SearchProfilesResponse, SummarizedProfile, SearchProfilesPage, SearchProfilesFixedSizeCollection> {
        private SearchProfilesFixedSizeCollection(List<SearchProfilesPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static SearchProfilesFixedSizeCollection createEmptyCollection() {
            return new SearchProfilesFixedSizeCollection(null, 0);
        }

        protected SearchProfilesFixedSizeCollection createCollection(List<SearchProfilesPage> pages, int collectionSize) {
            return new SearchProfilesFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class SearchProfilesPage
    extends AbstractPage<SearchProfilesRequest, SearchProfilesResponse, SummarizedProfile, SearchProfilesPage> {
        private SearchProfilesPage(PageContext<SearchProfilesRequest, SearchProfilesResponse, SummarizedProfile> context, SearchProfilesResponse response) {
            super(context, (Object)response);
        }

        private static SearchProfilesPage createEmptyPage() {
            return new SearchProfilesPage(null, null);
        }

        protected SearchProfilesPage createPage(PageContext<SearchProfilesRequest, SearchProfilesResponse, SummarizedProfile> context, SearchProfilesResponse response) {
            return new SearchProfilesPage(context, response);
        }

        public ApiFuture<SearchProfilesPage> createPageAsync(PageContext<SearchProfilesRequest, SearchProfilesResponse, SummarizedProfile> context, ApiFuture<SearchProfilesResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class SearchProfilesPagedResponse
    extends AbstractPagedListResponse<SearchProfilesRequest, SearchProfilesResponse, SummarizedProfile, SearchProfilesPage, SearchProfilesFixedSizeCollection> {
        public static ApiFuture<SearchProfilesPagedResponse> createAsync(PageContext<SearchProfilesRequest, SearchProfilesResponse, SummarizedProfile> context, ApiFuture<SearchProfilesResponse> futureResponse) {
            ApiFuture<SearchProfilesPage> futurePage = SearchProfilesPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, (ApiFunction)new ApiFunction<SearchProfilesPage, SearchProfilesPagedResponse>(){

                public SearchProfilesPagedResponse apply(SearchProfilesPage input) {
                    return new SearchProfilesPagedResponse(input);
                }
            }, (Executor)MoreExecutors.directExecutor());
        }

        private SearchProfilesPagedResponse(SearchProfilesPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)SearchProfilesFixedSizeCollection.createEmptyCollection());
        }
    }
}

