/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.storage;

import com.google.api.core.ApiFuture;
import com.google.api.gax.paging.Page;
import com.google.api.gax.retrying.ResultRetryAlgorithm;
import com.google.api.services.storage.model.BucketAccessControl;
import com.google.api.services.storage.model.HmacKeyMetadata;
import com.google.api.services.storage.model.ObjectAccessControl;
import com.google.api.services.storage.model.StorageObject;
import com.google.auth.ServiceAccountSigner;
import com.google.cloud.BaseService;
import com.google.cloud.BatchResult;
import com.google.cloud.PageImpl;
import com.google.cloud.Policy;
import com.google.cloud.ServiceOptions;
import com.google.cloud.WriteChannel;
import com.google.cloud.storage.Acl;
import com.google.cloud.storage.Blob;
import com.google.cloud.storage.BlobId;
import com.google.cloud.storage.BlobInfo;
import com.google.cloud.storage.BlobReadChannelV2;
import com.google.cloud.storage.BlobWriteChannelV2;
import com.google.cloud.storage.Bucket;
import com.google.cloud.storage.BucketInfo;
import com.google.cloud.storage.ByteRangeSpec;
import com.google.cloud.storage.Conversions;
import com.google.cloud.storage.CopyWriter;
import com.google.cloud.storage.HmacKey;
import com.google.cloud.storage.HttpClientContext;
import com.google.cloud.storage.HttpContentRange;
import com.google.cloud.storage.HttpCopyWriter;
import com.google.cloud.storage.HttpMethod;
import com.google.cloud.storage.HttpRetryAlgorithmManager;
import com.google.cloud.storage.HttpStorageOptions;
import com.google.cloud.storage.JsonConversions;
import com.google.cloud.storage.JsonResumableSession;
import com.google.cloud.storage.JsonResumableWrite;
import com.google.cloud.storage.Notification;
import com.google.cloud.storage.NotificationInfo;
import com.google.cloud.storage.PostPolicyV4;
import com.google.cloud.storage.ResumableMedia;
import com.google.cloud.storage.ResumableOperationResult;
import com.google.cloud.storage.ResumableSession;
import com.google.cloud.storage.Retrying;
import com.google.cloud.storage.RewindableContent;
import com.google.cloud.storage.ServiceAccount;
import com.google.cloud.storage.SignatureInfo;
import com.google.cloud.storage.SignedUrlEncodingHelper;
import com.google.cloud.storage.Storage;
import com.google.cloud.storage.StorageBatch;
import com.google.cloud.storage.StorageException;
import com.google.cloud.storage.StorageOptions;
import com.google.cloud.storage.StorageReadChannel;
import com.google.cloud.storage.StorageWriteChannel;
import com.google.cloud.storage.UnifiedOpts;
import com.google.cloud.storage.spi.v1.StorageRpc;
import com.google.common.base.CharMatcher;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.hash.Hashing;
import com.google.common.io.BaseEncoding;
import com.google.common.io.CountingOutputStream;
import com.google.common.primitives.Ints;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Function;
import java.util.function.Supplier;
import org.checkerframework.checker.nullness.qual.Nullable;

final class StorageImpl
extends BaseService<StorageOptions>
implements Storage {
    private static final byte[] EMPTY_BYTE_ARRAY = new byte[0];
    private static final String EMPTY_BYTE_ARRAY_MD5 = "1B2M2Y8AsgTpgAmY7PhCfg==";
    private static final String EMPTY_BYTE_ARRAY_CRC32C = "AAAAAA==";
    private static final String PATH_DELIMITER = "/";
    private static final String STORAGE_XML_URI_SCHEME = "https";
    private static final String STORAGE_XML_URI_HOST_NAME = "storage.googleapis.com";
    private static final int DEFAULT_BUFFER_SIZE = 0xF00000;
    private static final int MIN_BUFFER_SIZE = 262144;
    private static final JsonConversions codecs = Conversions.json();
    final HttpRetryAlgorithmManager retryAlgorithmManager;
    final StorageRpc storageRpc;

    StorageImpl(HttpStorageOptions options) {
        super((ServiceOptions)options);
        this.retryAlgorithmManager = options.getRetryAlgorithmManager();
        this.storageRpc = options.getStorageRpcV1();
    }

    @Override
    public Bucket create(BucketInfo bucketInfo, Storage.BucketTargetOption ... options) {
        com.google.api.services.storage.model.Bucket bucketPb = (com.google.api.services.storage.model.Bucket)codecs.bucketInfo().encode(bucketInfo);
        ImmutableMap<StorageRpc.Option, ?> optionsMap = UnifiedOpts.Opts.unwrap((UnifiedOpts.OptionShim[])options).resolveFrom(bucketInfo).getRpcOptions();
        ResultRetryAlgorithm<?> algorithm = this.retryAlgorithmManager.getForBucketsCreate(bucketPb, (Map<StorageRpc.Option, ?>)optionsMap);
        return this.run(algorithm, () -> this.storageRpc.create(bucketPb, (Map<StorageRpc.Option, ?>)optionsMap), b -> ((BucketInfo)Conversions.json().bucketInfo().decode(b)).asBucket(this));
    }

    @Override
    public Blob create(BlobInfo blobInfo, Storage.BlobTargetOption ... options) {
        BlobInfo updatedInfo = blobInfo.toBuilder().setMd5(EMPTY_BYTE_ARRAY_MD5).setCrc32c(EMPTY_BYTE_ARRAY_CRC32C).build();
        return this.internalCreate(updatedInfo, EMPTY_BYTE_ARRAY, 0, 0, options);
    }

    @Override
    public Blob create(BlobInfo blobInfo, byte[] content, Storage.BlobTargetOption ... options) {
        content = (byte[])MoreObjects.firstNonNull((Object)content, (Object)EMPTY_BYTE_ARRAY);
        BlobInfo updatedInfo = blobInfo.toBuilder().setMd5(BaseEncoding.base64().encode(Hashing.md5().hashBytes(content).asBytes())).setCrc32c(BaseEncoding.base64().encode(Ints.toByteArray((int)Hashing.crc32c().hashBytes(content).asInt()))).build();
        return this.internalCreate(updatedInfo, content, 0, content.length, options);
    }

    @Override
    public Blob create(BlobInfo blobInfo, byte[] content, int offset, int length, Storage.BlobTargetOption ... options) {
        content = (byte[])MoreObjects.firstNonNull((Object)content, (Object)EMPTY_BYTE_ARRAY);
        BlobInfo updatedInfo = blobInfo.toBuilder().setMd5(BaseEncoding.base64().encode(Hashing.md5().hashBytes(content, offset, length).asBytes())).setCrc32c(BaseEncoding.base64().encode(Ints.toByteArray((int)Hashing.crc32c().hashBytes(content, offset, length).asInt()))).build();
        return this.internalCreate(updatedInfo, content, offset, length, options);
    }

    @Override
    @Deprecated
    public Blob create(BlobInfo blobInfo, InputStream content, Storage.BlobWriteOption ... options) {
        UnifiedOpts.Opts opts = UnifiedOpts.Opts.unwrap((UnifiedOpts.OptionShim[])options).resolveFrom(blobInfo);
        ImmutableMap<StorageRpc.Option, ?> optionsMap = opts.getRpcOptions();
        BlobInfo.Builder builder = blobInfo.toBuilder().setMd5(null).setCrc32c(null);
        BlobInfo updated = opts.blobInfoMapper().apply(builder).build();
        StorageObject blobPb = (StorageObject)codecs.blobInfo().encode(updated);
        InputStream inputStreamParam = (InputStream)MoreObjects.firstNonNull((Object)content, (Object)new ByteArrayInputStream(EMPTY_BYTE_ARRAY));
        BlobInfo info = (BlobInfo)Conversions.json().blobInfo().decode(this.storageRpc.create(blobPb, inputStreamParam, (Map<StorageRpc.Option, ?>)optionsMap));
        return info.asBlob(this);
    }

    private Blob internalCreate(BlobInfo info, byte[] content, int offset, int length, Storage.BlobTargetOption ... options) {
        Preconditions.checkNotNull((Object)content);
        UnifiedOpts.Opts opts = UnifiedOpts.Opts.unwrap((UnifiedOpts.OptionShim[])options).resolveFrom(info);
        ImmutableMap<StorageRpc.Option, ?> optionsMap = opts.getRpcOptions();
        BlobInfo updated = opts.blobInfoMapper().apply(info.toBuilder()).build();
        StorageObject blobPb = (StorageObject)codecs.blobInfo().encode(updated);
        ResultRetryAlgorithm<?> algorithm = this.retryAlgorithmManager.getForObjectsCreate(blobPb, (Map<StorageRpc.Option, ?>)optionsMap);
        return this.run(algorithm, () -> this.storageRpc.create(blobPb, new ByteArrayInputStream(content, offset, length), (Map<StorageRpc.Option, ?>)optionsMap), x -> {
            BlobInfo info1 = (BlobInfo)Conversions.json().blobInfo().decode(x);
            return info1.asBlob(this);
        });
    }

    @Override
    public Blob createFrom(BlobInfo blobInfo, Path path, Storage.BlobWriteOption ... options) throws IOException {
        return this.createFrom(blobInfo, path, 0xF00000, options);
    }

    @Override
    public Blob createFrom(BlobInfo blobInfo, Path path, int bufferSize, Storage.BlobWriteOption ... options) throws IOException {
        if (Files.isDirectory(path, new LinkOption[0])) {
            throw new StorageException(0, path + " is a directory");
        }
        long size = Files.size(path);
        if (size == 0L) {
            return this.create(blobInfo, null, options);
        }
        UnifiedOpts.Opts opts = UnifiedOpts.Opts.unwrap((UnifiedOpts.OptionShim[])options).resolveFrom(blobInfo);
        ImmutableMap<StorageRpc.Option, ?> optionsMap = opts.getRpcOptions();
        BlobInfo.Builder builder = blobInfo.toBuilder().setMd5(null).setCrc32c(null);
        BlobInfo updated = opts.blobInfoMapper().apply(builder).build();
        StorageObject encode = (StorageObject)codecs.blobInfo().encode(updated);
        Supplier<String> uploadIdSupplier = ResumableMedia.startUploadForBlobInfo(this.getOptions(), updated, optionsMap, this.retryAlgorithmManager.getForResumableUploadSessionCreate((Map<StorageRpc.Option, ?>)optionsMap));
        JsonResumableWrite jsonResumableWrite = JsonResumableWrite.of(encode, optionsMap, uploadIdSupplier.get(), 0L);
        JsonResumableSession session = ResumableSession.json(HttpClientContext.from(this.storageRpc), this.getOptions().asRetryDependencies(), this.retryAlgorithmManager.idempotent(), jsonResumableWrite);
        HttpContentRange.Total contentRange = HttpContentRange.of(ByteRangeSpec.relativeLength(0L, size), size);
        ResumableOperationResult<StorageObject> put = session.put(RewindableContent.of(path), contentRange);
        StorageObject object = put.getObject();
        if (object == null) {
            ResumableOperationResult<@Nullable StorageObject> query = session.query();
            object = query.getObject();
        }
        return ((BlobInfo)codecs.blobInfo().decode(object)).asBlob(this);
    }

    @Override
    public Blob createFrom(BlobInfo blobInfo, InputStream content, Storage.BlobWriteOption ... options) throws IOException {
        return this.createFrom(blobInfo, content, 0xF00000, options);
    }

    @Override
    public Blob createFrom(BlobInfo blobInfo, InputStream content, int bufferSize, Storage.BlobWriteOption ... options) throws IOException {
        ApiFuture<BlobInfo> objectFuture;
        try (StorageWriteChannel writer = this.writer(blobInfo, options);){
            objectFuture = writer.getObject();
            StorageImpl.uploadHelper(Channels.newChannel(content), writer, bufferSize);
        }
        try {
            BlobInfo info = (BlobInfo)objectFuture.get(10L, TimeUnit.SECONDS);
            return info.asBlob(this);
        }
        catch (InterruptedException | ExecutionException | TimeoutException e) {
            throw StorageException.coalesce(e);
        }
    }

    private static void uploadHelper(ReadableByteChannel reader, WriteChannel writer, int bufferSize) throws IOException {
        bufferSize = Math.max(bufferSize, 262144);
        ByteBuffer buffer = ByteBuffer.allocate(bufferSize);
        writer.setChunkSize(bufferSize);
        while (reader.read(buffer) >= 0) {
            buffer.flip();
            writer.write(buffer);
            buffer.clear();
        }
    }

    @Override
    public Bucket get(String bucket, Storage.BucketGetOption ... options) {
        ImmutableMap<StorageRpc.Option, ?> optionsMap = UnifiedOpts.Opts.unwrap((UnifiedOpts.OptionShim[])options).getRpcOptions();
        return this.internalBucketGet(bucket, (Map<StorageRpc.Option, ?>)optionsMap);
    }

    @Override
    public Blob get(String bucket, String blob, Storage.BlobGetOption ... options) {
        return this.get(BlobId.of(bucket, blob), options);
    }

    @Override
    public Blob get(BlobId blob, Storage.BlobGetOption ... options) {
        ImmutableMap<StorageRpc.Option, ?> optionsMap = UnifiedOpts.Opts.unwrap((UnifiedOpts.OptionShim[])options).resolveFrom(blob).getRpcOptions();
        return this.internalGetBlob(blob, (Map<StorageRpc.Option, ?>)optionsMap);
    }

    @Override
    public Blob get(BlobId blob) {
        return this.get(blob, new Storage.BlobGetOption[0]);
    }

    @Override
    public Page<Bucket> list(Storage.BucketListOption ... options) {
        ImmutableMap<StorageRpc.Option, ?> optionsMap = UnifiedOpts.Opts.unwrap((UnifiedOpts.OptionShim[])options).getRpcOptions();
        return StorageImpl.listBuckets(this.getOptions(), optionsMap);
    }

    @Override
    public Page<Blob> list(String bucket, Storage.BlobListOption ... options) {
        ImmutableMap<StorageRpc.Option, ?> optionsMap = UnifiedOpts.Opts.unwrap((UnifiedOpts.OptionShim[])options).getRpcOptions();
        return StorageImpl.listBlobs(bucket, this.getOptions(), optionsMap);
    }

    private static Page<Bucket> listBuckets(HttpStorageOptions serviceOptions, Map<StorageRpc.Option, ?> optionsMap) {
        ResultRetryAlgorithm<?> algorithm = serviceOptions.getRetryAlgorithmManager().getForBucketsList(optionsMap);
        return (Page)Retrying.run(serviceOptions, algorithm, () -> serviceOptions.getStorageRpcV1().list(optionsMap), result -> {
            String cursor = (String)result.x();
            ImmutableList buckets = result.y() == null ? ImmutableList.of() : Iterables.transform((Iterable)((Iterable)result.y()), bucketPb -> ((BucketInfo)Conversions.json().bucketInfo().decode(bucketPb)).asBucket((Storage)serviceOptions.getService()));
            return new PageImpl((PageImpl.NextPageFetcher)new BucketPageFetcher(serviceOptions, cursor, optionsMap), cursor, (Iterable)buckets);
        });
    }

    private static Page<Blob> listBlobs(String bucket, HttpStorageOptions serviceOptions, Map<StorageRpc.Option, ?> optionsMap) {
        ResultRetryAlgorithm<?> algorithm = serviceOptions.getRetryAlgorithmManager().getForObjectsList(bucket, optionsMap);
        return (Page)Retrying.run(serviceOptions, algorithm, () -> serviceOptions.getStorageRpcV1().list(bucket, optionsMap), result -> {
            String cursor = (String)result.x();
            ImmutableList blobs = result.y() == null ? ImmutableList.of() : Iterables.transform((Iterable)((Iterable)result.y()), storageObject -> {
                BlobInfo info = (BlobInfo)Conversions.json().blobInfo().decode(storageObject);
                return info.asBlob((Storage)serviceOptions.getService());
            });
            return new PageImpl((PageImpl.NextPageFetcher)new BlobPageFetcher(bucket, serviceOptions, cursor, optionsMap), cursor, (Iterable)blobs);
        });
    }

    @Override
    public Bucket update(BucketInfo bucketInfo, Storage.BucketTargetOption ... options) {
        ImmutableMap<StorageRpc.Option, ?> optionsMap = UnifiedOpts.Opts.unwrap((UnifiedOpts.OptionShim[])options).resolveFrom(bucketInfo).getRpcOptions();
        if (bucketInfo.getModifiedFields().isEmpty()) {
            return this.internalBucketGet(bucketInfo.getName(), (Map<StorageRpc.Option, ?>)optionsMap);
        }
        com.google.api.services.storage.model.Bucket bucketPb = (com.google.api.services.storage.model.Bucket)codecs.bucketInfo().encode(bucketInfo);
        ResultRetryAlgorithm<?> algorithm = this.retryAlgorithmManager.getForBucketsUpdate(bucketPb, (Map<StorageRpc.Option, ?>)optionsMap);
        return this.run(algorithm, () -> this.storageRpc.patch(bucketPb, (Map<StorageRpc.Option, ?>)optionsMap), x -> ((BucketInfo)Conversions.json().bucketInfo().decode(x)).asBucket(this));
    }

    @Override
    public Blob update(BlobInfo blobInfo, Storage.BlobTargetOption ... options) {
        UnifiedOpts.Opts opts = UnifiedOpts.Opts.unwrap((UnifiedOpts.OptionShim[])options).resolveFrom(blobInfo);
        ImmutableMap<StorageRpc.Option, ?> optionsMap = opts.getRpcOptions();
        boolean unmodifiedBeforeOpts = blobInfo.getModifiedFields().isEmpty();
        BlobInfo.Builder builder = blobInfo.toBuilder();
        if (blobInfo.getModifiedFields().contains((Object)Storage.BlobField.RETENTION)) {
            builder.setRetention(blobInfo.getRetention());
        }
        BlobInfo updated = opts.blobInfoMapper().apply(builder).build();
        boolean unmodifiedAfterOpts = updated.getModifiedFields().isEmpty();
        if (unmodifiedBeforeOpts && unmodifiedAfterOpts) {
            return this.internalGetBlob(blobInfo.getBlobId(), (Map<StorageRpc.Option, ?>)optionsMap);
        }
        StorageObject pb = (StorageObject)codecs.blobInfo().encode(updated);
        ResultRetryAlgorithm<?> algorithm = this.retryAlgorithmManager.getForObjectsUpdate(pb, (Map<StorageRpc.Option, ?>)optionsMap);
        return this.run(algorithm, () -> this.storageRpc.patch(pb, (Map<StorageRpc.Option, ?>)optionsMap), x -> {
            BlobInfo info = (BlobInfo)Conversions.json().blobInfo().decode(x);
            return info.asBlob(this);
        });
    }

    @Override
    public Blob update(BlobInfo blobInfo) {
        return this.update(blobInfo, new Storage.BlobTargetOption[0]);
    }

    @Override
    public boolean delete(String bucket, Storage.BucketSourceOption ... options) {
        com.google.api.services.storage.model.Bucket bucketPb = (com.google.api.services.storage.model.Bucket)codecs.bucketInfo().encode(BucketInfo.of(bucket));
        ImmutableMap<StorageRpc.Option, ?> optionsMap = UnifiedOpts.Opts.unwrap((UnifiedOpts.OptionShim[])options).getRpcOptions();
        ResultRetryAlgorithm<?> algorithm = this.retryAlgorithmManager.getForBucketsDelete(bucketPb, (Map<StorageRpc.Option, ?>)optionsMap);
        return (Boolean)this.run(algorithm, () -> this.storageRpc.delete(bucketPb, (Map<StorageRpc.Option, ?>)optionsMap), Function.identity());
    }

    @Override
    public boolean delete(String bucket, String blob, Storage.BlobSourceOption ... options) {
        return this.delete(BlobId.of(bucket, blob), options);
    }

    @Override
    public boolean delete(BlobId blob, Storage.BlobSourceOption ... options) {
        StorageObject storageObject = (StorageObject)codecs.blobId().encode(blob);
        ImmutableMap<StorageRpc.Option, ?> optionsMap = UnifiedOpts.Opts.unwrap((UnifiedOpts.OptionShim[])options).resolveFrom(blob).getRpcOptions();
        ResultRetryAlgorithm<?> algorithm = this.retryAlgorithmManager.getForObjectsDelete(storageObject, (Map<StorageRpc.Option, ?>)optionsMap);
        return (Boolean)this.run(algorithm, () -> this.storageRpc.delete(storageObject, (Map<StorageRpc.Option, ?>)optionsMap), Function.identity());
    }

    @Override
    public boolean delete(BlobId blob) {
        return this.delete(blob, new Storage.BlobSourceOption[0]);
    }

    @Override
    public Blob compose(Storage.ComposeRequest composeRequest) {
        ArrayList sources = Lists.newArrayListWithCapacity((int)composeRequest.getSourceBlobs().size());
        BlobInfo target = composeRequest.getTarget();
        for (Storage.ComposeRequest.SourceBlob sourceBlob : composeRequest.getSourceBlobs()) {
            sources.add((StorageObject)codecs.blobInfo().encode(BlobInfo.newBuilder(BlobId.of(target.getBucket(), sourceBlob.getName(), sourceBlob.getGeneration())).build()));
        }
        UnifiedOpts.Opts<UnifiedOpts.ObjectTargetOpt> targetOpts = composeRequest.getTargetOpts();
        StorageObject targetPb = (StorageObject)codecs.blobInfo().encode(composeRequest.getTarget());
        ImmutableMap<StorageRpc.Option, ?> targetOptions = targetOpts.getRpcOptions();
        ResultRetryAlgorithm<?> algorithm = this.retryAlgorithmManager.getForObjectsCompose(sources, targetPb, (Map<StorageRpc.Option, ?>)targetOptions);
        return this.run(algorithm, () -> this.storageRpc.compose(sources, targetPb, (Map<StorageRpc.Option, ?>)targetOptions), x -> {
            BlobInfo info = (BlobInfo)Conversions.json().blobInfo().decode(x);
            return info.asBlob(this);
        });
    }

    @Override
    public CopyWriter copy(Storage.CopyRequest copyRequest) {
        BlobId source = copyRequest.getSource();
        BlobInfo target = copyRequest.getTarget();
        UnifiedOpts.Opts sourceOpts = UnifiedOpts.Opts.unwrap(copyRequest.getSourceOptions()).resolveFrom(source).projectAsSource();
        UnifiedOpts.Opts targetOpts = UnifiedOpts.Opts.unwrap(copyRequest.getTargetOptions()).resolveFrom(target);
        StorageObject sourcePb = (StorageObject)codecs.blobId().encode(source);
        StorageObject targetPb = (StorageObject)codecs.blobInfo().encode(target);
        ImmutableMap<StorageRpc.Option, ?> sourceOptions = sourceOpts.getRpcOptions();
        ImmutableMap<StorageRpc.Option, ?> targetOptions = targetOpts.getRpcOptions();
        StorageRpc.RewriteRequest rewriteRequest = new StorageRpc.RewriteRequest(sourcePb, (Map<StorageRpc.Option, ?>)sourceOptions, copyRequest.overrideInfo(), targetPb, (Map<StorageRpc.Option, ?>)targetOptions, copyRequest.getMegabytesCopiedPerChunk());
        ResultRetryAlgorithm<?> algorithm = this.retryAlgorithmManager.getForObjectsRewrite(rewriteRequest);
        return this.run(algorithm, () -> this.storageRpc.openRewrite(rewriteRequest), r -> new HttpCopyWriter(this.getOptions(), (StorageRpc.RewriteResponse)r));
    }

    @Override
    public byte[] readAllBytes(String bucket, String blob, Storage.BlobSourceOption ... options) {
        return this.readAllBytes(BlobId.of(bucket, blob), options);
    }

    @Override
    public byte[] readAllBytes(BlobId blob, Storage.BlobSourceOption ... options) {
        StorageObject storageObject = (StorageObject)codecs.blobId().encode(blob);
        UnifiedOpts.Opts unwrap = UnifiedOpts.Opts.unwrap((UnifiedOpts.OptionShim[])options);
        UnifiedOpts.Opts resolve = unwrap.resolveFrom(blob);
        ImmutableMap<StorageRpc.Option, ?> optionsMap = resolve.getRpcOptions();
        ResultRetryAlgorithm<?> algorithm = this.retryAlgorithmManager.getForObjectsGet(storageObject, (Map<StorageRpc.Option, ?>)optionsMap);
        return (byte[])this.run(algorithm, () -> this.storageRpc.load(storageObject, (Map<StorageRpc.Option, ?>)optionsMap), Function.identity());
    }

    @Override
    public StorageBatch batch() {
        return new StorageBatch(this.getOptions());
    }

    @Override
    public StorageReadChannel reader(String bucket, String blob, Storage.BlobSourceOption ... options) {
        return this.reader(BlobId.of(bucket, blob), options);
    }

    @Override
    public StorageReadChannel reader(BlobId blob, Storage.BlobSourceOption ... options) {
        UnifiedOpts.Opts opts = UnifiedOpts.Opts.unwrap((UnifiedOpts.OptionShim[])options).resolveFrom(blob);
        StorageObject storageObject = (StorageObject)Conversions.json().blobId().encode(blob);
        ImmutableMap<StorageRpc.Option, ?> optionsMap = opts.getRpcOptions();
        return new BlobReadChannelV2(storageObject, (Map<StorageRpc.Option, ?>)optionsMap, BlobReadChannelV2.BlobReadChannelContext.from(this));
    }

    @Override
    public void downloadTo(BlobId blob, Path path, Storage.BlobSourceOption ... options) {
        try (OutputStream outputStream = Files.newOutputStream(path, new OpenOption[0]);){
            this.downloadTo(blob, outputStream, options);
        }
        catch (IOException e) {
            throw new StorageException(e);
        }
    }

    @Override
    public void downloadTo(BlobId blob, OutputStream outputStream, Storage.BlobSourceOption ... options) {
        CountingOutputStream countingOutputStream = new CountingOutputStream(outputStream);
        StorageObject pb = (StorageObject)codecs.blobId().encode(blob);
        ImmutableMap<StorageRpc.Option, ?> optionsMap = UnifiedOpts.Opts.unwrap((UnifiedOpts.OptionShim[])options).resolveFrom(blob).getRpcOptions();
        ResultRetryAlgorithm<?> algorithm = this.retryAlgorithmManager.getForObjectsGet(pb, (Map<StorageRpc.Option, ?>)optionsMap);
        this.run(algorithm, Executors.callable(() -> this.storageRpc.read(pb, (Map<StorageRpc.Option, ?>)optionsMap, countingOutputStream.getCount(), (OutputStream)countingOutputStream)), Function.identity());
    }

    @Override
    public StorageWriteChannel writer(BlobInfo blobInfo, Storage.BlobWriteOption ... options) {
        UnifiedOpts.Opts opts = UnifiedOpts.Opts.unwrap((UnifiedOpts.OptionShim[])options).resolveFrom(blobInfo);
        ImmutableMap<StorageRpc.Option, ?> optionsMap = opts.getRpcOptions();
        BlobInfo.Builder builder = blobInfo.toBuilder().setMd5(null).setCrc32c(null);
        BlobInfo updated = opts.blobInfoMapper().apply(builder).build();
        StorageObject encode = (StorageObject)codecs.blobInfo().encode(updated);
        Supplier<String> uploadIdSupplier = ResumableMedia.startUploadForBlobInfo(this.getOptions(), updated, optionsMap, this.retryAlgorithmManager.getForResumableUploadSessionCreate((Map<StorageRpc.Option, ?>)optionsMap));
        JsonResumableWrite jsonResumableWrite = JsonResumableWrite.of(encode, optionsMap, uploadIdSupplier.get(), 0L);
        return new BlobWriteChannelV2(BlobReadChannelV2.BlobReadChannelContext.from(this.getOptions()), jsonResumableWrite);
    }

    @Override
    public StorageWriteChannel writer(URL signedURL) {
        ResultRetryAlgorithm<?> forResumableUploadSessionCreate = this.retryAlgorithmManager.getForResumableUploadSessionCreate(Collections.emptyMap());
        String signedUrlString = signedURL.toString();
        Supplier<String> uploadIdSupplier = ResumableMedia.startUploadForSignedUrl(this.getOptions(), signedURL, forResumableUploadSessionCreate);
        JsonResumableWrite jsonResumableWrite = JsonResumableWrite.of(signedUrlString, uploadIdSupplier.get(), 0L);
        return new BlobWriteChannelV2(BlobReadChannelV2.BlobReadChannelContext.from(this.getOptions()), jsonResumableWrite);
    }

    @Override
    public URL signUrl(BlobInfo blobInfo, long duration, TimeUnit unit, Storage.SignUrlOption ... options) {
        boolean usePathStyle;
        String storageXmlHostName;
        EnumMap optionMap = Maps.newEnumMap(Storage.SignUrlOption.Option.class);
        for (Storage.SignUrlOption option : options) {
            optionMap.put(option.getOption(), option.getValue());
        }
        boolean isV2 = this.getPreferredSignatureVersion(optionMap).equals((Object)Storage.SignUrlOption.SignatureVersion.V2);
        boolean isV4 = this.getPreferredSignatureVersion(optionMap).equals((Object)Storage.SignUrlOption.SignatureVersion.V4);
        ServiceAccountSigner credentials = (ServiceAccountSigner)optionMap.get((Object)Storage.SignUrlOption.Option.SERVICE_ACCOUNT_CRED);
        if (credentials == null) {
            Preconditions.checkState((boolean)(this.getOptions().getCredentials() instanceof ServiceAccountSigner), (Object)"Signing key was not provided and could not be derived");
            credentials = (ServiceAccountSigner)this.getOptions().getCredentials();
        }
        long expiration = isV4 ? TimeUnit.SECONDS.convert(unit.toMillis(duration), TimeUnit.MILLISECONDS) : TimeUnit.SECONDS.convert(this.getOptions().getClock().millisTime() + unit.toMillis(duration), TimeUnit.MILLISECONDS);
        Preconditions.checkArgument((!optionMap.containsKey((Object)Storage.SignUrlOption.Option.VIRTUAL_HOSTED_STYLE) || !optionMap.containsKey((Object)Storage.SignUrlOption.Option.PATH_STYLE) || !optionMap.containsKey((Object)Storage.SignUrlOption.Option.BUCKET_BOUND_HOST_NAME) ? 1 : 0) != 0, (Object)"Only one of VIRTUAL_HOSTED_STYLE, PATH_STYLE, or BUCKET_BOUND_HOST_NAME SignUrlOptions can be specified.");
        String bucketName = this.slashlessBucketNameFromBlobInfo(blobInfo);
        String escapedBlobName = "";
        if (!Strings.isNullOrEmpty((String)blobInfo.getName())) {
            escapedBlobName = SignedUrlEncodingHelper.Rfc3986UriEncode(blobInfo.getName(), false);
        }
        String string = storageXmlHostName = (usePathStyle = this.shouldUsePathStyleForSignedUrl(optionMap)) ? "https://" + this.getBaseStorageHostName(optionMap) : "https://" + bucketName + "." + this.getBaseStorageHostName(optionMap);
        if (optionMap.containsKey((Object)Storage.SignUrlOption.Option.BUCKET_BOUND_HOST_NAME)) {
            storageXmlHostName = (String)optionMap.get((Object)Storage.SignUrlOption.Option.BUCKET_BOUND_HOST_NAME);
        }
        String stPath = usePathStyle ? this.constructResourceUriPath(bucketName, escapedBlobName, optionMap) : this.constructResourceUriPath("", escapedBlobName, optionMap);
        URI path = URI.create(stPath);
        URI pathForSigning = isV2 ? URI.create(this.constructResourceUriPath(bucketName, escapedBlobName, optionMap)) : path;
        try {
            SignatureInfo signatureInfo = this.buildSignatureInfo(optionMap, blobInfo, expiration, pathForSigning, credentials.getAccount());
            String unsignedPayload = signatureInfo.constructUnsignedPayload();
            byte[] signatureBytes = credentials.sign(unsignedPayload.getBytes(StandardCharsets.UTF_8));
            StringBuilder stBuilder = new StringBuilder();
            stBuilder.append(storageXmlHostName).append(path);
            if (isV4) {
                BaseEncoding encoding = BaseEncoding.base16().lowerCase();
                String signature = URLEncoder.encode(encoding.encode(signatureBytes), StandardCharsets.UTF_8.name());
                String v4QueryString = signatureInfo.constructV4QueryString();
                stBuilder.append('?');
                if (!Strings.isNullOrEmpty((String)v4QueryString)) {
                    stBuilder.append(v4QueryString).append('&');
                }
                stBuilder.append("X-Goog-Signature=").append(signature);
            } else {
                BaseEncoding encoding = BaseEncoding.base64();
                String signature = URLEncoder.encode(encoding.encode(signatureBytes), StandardCharsets.UTF_8.name());
                String v2QueryString = signatureInfo.constructV2QueryString();
                stBuilder.append('?');
                if (!Strings.isNullOrEmpty((String)v2QueryString)) {
                    stBuilder.append(v2QueryString).append('&');
                }
                stBuilder.append("GoogleAccessId=").append(credentials.getAccount());
                stBuilder.append("&Expires=").append(expiration);
                stBuilder.append("&Signature=").append(signature);
            }
            return new URL(stBuilder.toString());
        }
        catch (UnsupportedEncodingException | MalformedURLException ex) {
            throw new IllegalStateException(ex);
        }
    }

    @Override
    public PostPolicyV4 generateSignedPostPolicyV4(BlobInfo blobInfo, long duration, TimeUnit unit, PostPolicyV4.PostFieldsV4 fields, PostPolicyV4.PostConditionsV4 conditions, Storage.PostPolicyV4Option ... options) {
        EnumMap optionMap = Maps.newEnumMap(Storage.SignUrlOption.Option.class);
        for (Storage.PostPolicyV4Option option : options) {
            optionMap.put(Storage.SignUrlOption.Option.valueOf(option.getOption().name()), option.getValue());
        }
        optionMap.put(Storage.SignUrlOption.Option.SIGNATURE_VERSION, Storage.SignUrlOption.SignatureVersion.V4);
        ServiceAccountSigner credentials = (ServiceAccountSigner)optionMap.get((Object)Storage.SignUrlOption.Option.SERVICE_ACCOUNT_CRED);
        if (credentials == null) {
            Preconditions.checkState((boolean)(this.getOptions().getCredentials() instanceof ServiceAccountSigner), (Object)"Signing key was not provided and could not be derived");
            credentials = (ServiceAccountSigner)this.getOptions().getCredentials();
        }
        Preconditions.checkArgument((!optionMap.containsKey((Object)Storage.SignUrlOption.Option.VIRTUAL_HOSTED_STYLE) || !optionMap.containsKey((Object)Storage.SignUrlOption.Option.PATH_STYLE) || !optionMap.containsKey((Object)Storage.SignUrlOption.Option.BUCKET_BOUND_HOST_NAME) ? 1 : 0) != 0, (Object)"Only one of VIRTUAL_HOSTED_STYLE, PATH_STYLE, or BUCKET_BOUND_HOST_NAME SignUrlOptions can be specified.");
        String bucketName = this.slashlessBucketNameFromBlobInfo(blobInfo);
        boolean usePathStyle = this.shouldUsePathStyleForSignedUrl(optionMap);
        String url = usePathStyle ? "https://storage.googleapis.com/" + bucketName + PATH_DELIMITER : "https://" + bucketName + "." + STORAGE_XML_URI_HOST_NAME + PATH_DELIMITER;
        if (optionMap.containsKey((Object)Storage.SignUrlOption.Option.BUCKET_BOUND_HOST_NAME)) {
            url = optionMap.get((Object)Storage.SignUrlOption.Option.BUCKET_BOUND_HOST_NAME) + PATH_DELIMITER;
        }
        SimpleDateFormat googDateFormat = new SimpleDateFormat("yyyyMMdd'T'HHmmss'Z'");
        SimpleDateFormat yearMonthDayFormat = new SimpleDateFormat("yyyyMMdd");
        SimpleDateFormat expirationFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
        googDateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
        yearMonthDayFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
        expirationFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
        long timestamp = this.getOptions().getClock().millisTime();
        String date = googDateFormat.format(timestamp);
        String signingCredential = credentials.getAccount() + PATH_DELIMITER + yearMonthDayFormat.format(timestamp) + "/auto/storage/goog4_request";
        HashMap<String, String> policyFields = new HashMap<String, String>();
        PostPolicyV4.PostConditionsV4.Builder conditionsBuilder = conditions.toBuilder();
        for (Map.Entry<String, String> entry : fields.getFieldsMap().entrySet()) {
            conditionsBuilder.addCustomCondition(PostPolicyV4.ConditionV4Type.MATCHES, entry.getKey(), entry.getValue());
            policyFields.put(entry.getKey(), entry.getValue());
        }
        PostPolicyV4.PostConditionsV4 v4Conditions = conditionsBuilder.addBucketCondition(PostPolicyV4.ConditionV4Type.MATCHES, blobInfo.getBucket()).addKeyCondition(PostPolicyV4.ConditionV4Type.MATCHES, blobInfo.getName()).addCustomCondition(PostPolicyV4.ConditionV4Type.MATCHES, "x-goog-date", date).addCustomCondition(PostPolicyV4.ConditionV4Type.MATCHES, "x-goog-credential", signingCredential).addCustomCondition(PostPolicyV4.ConditionV4Type.MATCHES, "x-goog-algorithm", "GOOG4-RSA-SHA256").build();
        PostPolicyV4.PostPolicyV4Document document = PostPolicyV4.PostPolicyV4Document.of(expirationFormat.format(timestamp + unit.toMillis(duration)), v4Conditions);
        String policy = BaseEncoding.base64().encode(document.toJson().getBytes());
        String signature = BaseEncoding.base16().encode(credentials.sign(policy.getBytes())).toLowerCase();
        for (PostPolicyV4.ConditionV4 condition : v4Conditions.getConditions()) {
            if (condition.type != PostPolicyV4.ConditionV4Type.MATCHES) continue;
            policyFields.put(condition.operand1, condition.operand2);
        }
        policyFields.put("key", blobInfo.getName());
        policyFields.put("x-goog-credential", signingCredential);
        policyFields.put("x-goog-algorithm", "GOOG4-RSA-SHA256");
        policyFields.put("x-goog-date", date);
        policyFields.put("x-goog-signature", signature);
        policyFields.put("policy", policy);
        policyFields.remove("bucket");
        return PostPolicyV4.of(url, policyFields);
    }

    @Override
    public PostPolicyV4 generateSignedPostPolicyV4(BlobInfo blobInfo, long duration, TimeUnit unit, PostPolicyV4.PostFieldsV4 fields, Storage.PostPolicyV4Option ... options) {
        return this.generateSignedPostPolicyV4(blobInfo, duration, unit, fields, PostPolicyV4.PostConditionsV4.newBuilder().build(), options);
    }

    @Override
    public PostPolicyV4 generateSignedPostPolicyV4(BlobInfo blobInfo, long duration, TimeUnit unit, PostPolicyV4.PostConditionsV4 conditions, Storage.PostPolicyV4Option ... options) {
        return this.generateSignedPostPolicyV4(blobInfo, duration, unit, PostPolicyV4.PostFieldsV4.newBuilder().build(), conditions, options);
    }

    @Override
    public PostPolicyV4 generateSignedPostPolicyV4(BlobInfo blobInfo, long duration, TimeUnit unit, Storage.PostPolicyV4Option ... options) {
        return this.generateSignedPostPolicyV4(blobInfo, duration, unit, PostPolicyV4.PostFieldsV4.newBuilder().build(), options);
    }

    private String constructResourceUriPath(String slashlessBucketName, String escapedBlobName, EnumMap<Storage.SignUrlOption.Option, Object> optionMap) {
        if (Strings.isNullOrEmpty((String)slashlessBucketName)) {
            if (Strings.isNullOrEmpty((String)escapedBlobName)) {
                return PATH_DELIMITER;
            }
            if (escapedBlobName.startsWith(PATH_DELIMITER)) {
                return escapedBlobName;
            }
            return PATH_DELIMITER + escapedBlobName;
        }
        StringBuilder pathBuilder = new StringBuilder();
        pathBuilder.append(PATH_DELIMITER).append(slashlessBucketName);
        if (Strings.isNullOrEmpty((String)escapedBlobName)) {
            boolean isV2 = this.getPreferredSignatureVersion(optionMap).equals((Object)Storage.SignUrlOption.SignatureVersion.V2);
            if (optionMap.containsKey((Object)Storage.SignUrlOption.Option.VIRTUAL_HOSTED_STYLE) && isV2) {
                pathBuilder.append(PATH_DELIMITER);
            }
            return pathBuilder.toString();
        }
        pathBuilder.append(PATH_DELIMITER);
        pathBuilder.append(escapedBlobName);
        return pathBuilder.toString();
    }

    private Storage.SignUrlOption.SignatureVersion getPreferredSignatureVersion(EnumMap<Storage.SignUrlOption.Option, Object> optionMap) {
        for (Storage.SignUrlOption.SignatureVersion version : Storage.SignUrlOption.SignatureVersion.values()) {
            if (!version.equals(optionMap.get((Object)Storage.SignUrlOption.Option.SIGNATURE_VERSION))) continue;
            return version;
        }
        return Storage.SignUrlOption.SignatureVersion.V2;
    }

    private boolean shouldUsePathStyleForSignedUrl(EnumMap<Storage.SignUrlOption.Option, Object> optionMap) {
        return !optionMap.containsKey((Object)Storage.SignUrlOption.Option.VIRTUAL_HOSTED_STYLE) && !optionMap.containsKey((Object)Storage.SignUrlOption.Option.BUCKET_BOUND_HOST_NAME);
    }

    private SignatureInfo buildSignatureInfo(Map<Storage.SignUrlOption.Option, Object> optionMap, BlobInfo blobInfo, long expiration, URI path, String accountEmail) {
        HttpMethod httpVerb = optionMap.containsKey((Object)Storage.SignUrlOption.Option.HTTP_METHOD) ? (HttpMethod)((Object)optionMap.get((Object)Storage.SignUrlOption.Option.HTTP_METHOD)) : HttpMethod.GET;
        SignatureInfo.Builder signatureInfoBuilder = new SignatureInfo.Builder(httpVerb, expiration, path);
        if (((Boolean)MoreObjects.firstNonNull((Object)((Boolean)optionMap.get((Object)Storage.SignUrlOption.Option.MD5)), (Object)false)).booleanValue()) {
            Preconditions.checkArgument((blobInfo.getMd5() != null ? 1 : 0) != 0, (Object)"Blob is missing a value for md5");
            signatureInfoBuilder.setContentMd5(blobInfo.getMd5());
        }
        if (((Boolean)MoreObjects.firstNonNull((Object)((Boolean)optionMap.get((Object)Storage.SignUrlOption.Option.CONTENT_TYPE)), (Object)false)).booleanValue()) {
            Preconditions.checkArgument((blobInfo.getContentType() != null ? 1 : 0) != 0, (Object)"Blob is missing a value for content-type");
            signatureInfoBuilder.setContentType(blobInfo.getContentType());
        }
        signatureInfoBuilder.setSignatureVersion((Storage.SignUrlOption.SignatureVersion)((Object)optionMap.get((Object)Storage.SignUrlOption.Option.SIGNATURE_VERSION)));
        signatureInfoBuilder.setAccountEmail(accountEmail);
        signatureInfoBuilder.setTimestamp(this.getOptions().getClock().millisTime());
        ImmutableMap.Builder extHeadersBuilder = new ImmutableMap.Builder();
        boolean isV4 = Storage.SignUrlOption.SignatureVersion.V4.equals(optionMap.get((Object)Storage.SignUrlOption.Option.SIGNATURE_VERSION));
        if (isV4) {
            if (optionMap.containsKey((Object)Storage.SignUrlOption.Option.VIRTUAL_HOSTED_STYLE)) {
                extHeadersBuilder.put((Object)"host", (Object)(this.slashlessBucketNameFromBlobInfo(blobInfo) + "." + this.getBaseStorageHostName(optionMap)));
            } else if (optionMap.containsKey((Object)Storage.SignUrlOption.Option.HOST_NAME) || optionMap.containsKey((Object)Storage.SignUrlOption.Option.BUCKET_BOUND_HOST_NAME)) {
                extHeadersBuilder.put((Object)"host", (Object)this.getBaseStorageHostName(optionMap));
            }
        }
        if (optionMap.containsKey((Object)Storage.SignUrlOption.Option.EXT_HEADERS)) {
            extHeadersBuilder.putAll((Map)optionMap.get((Object)Storage.SignUrlOption.Option.EXT_HEADERS));
        }
        ImmutableMap.Builder queryParamsBuilder = new ImmutableMap.Builder();
        if (optionMap.containsKey((Object)Storage.SignUrlOption.Option.QUERY_PARAMS)) {
            queryParamsBuilder.putAll((Map)optionMap.get((Object)Storage.SignUrlOption.Option.QUERY_PARAMS));
        }
        return signatureInfoBuilder.setCanonicalizedExtensionHeaders((Map<String, String>)extHeadersBuilder.build()).setCanonicalizedQueryParams((Map<String, String>)queryParamsBuilder.build()).build();
    }

    private String slashlessBucketNameFromBlobInfo(BlobInfo blobInfo) {
        return CharMatcher.anyOf((CharSequence)PATH_DELIMITER).trimFrom((CharSequence)blobInfo.getBucket());
    }

    private String getBaseStorageHostName(Map<Storage.SignUrlOption.Option, Object> optionMap) {
        String specifiedBaseHostName = (String)optionMap.get((Object)Storage.SignUrlOption.Option.HOST_NAME);
        String bucketBoundHostName = (String)optionMap.get((Object)Storage.SignUrlOption.Option.BUCKET_BOUND_HOST_NAME);
        if (!Strings.isNullOrEmpty((String)specifiedBaseHostName)) {
            return specifiedBaseHostName.replaceFirst("http(s)?://", "");
        }
        if (!Strings.isNullOrEmpty((String)bucketBoundHostName)) {
            return bucketBoundHostName.replaceFirst("http(s)?://", "");
        }
        return STORAGE_XML_URI_HOST_NAME;
    }

    @Override
    public List<Blob> get(BlobId ... blobIds) {
        return this.get(Arrays.asList(blobIds));
    }

    @Override
    public List<Blob> get(Iterable<BlobId> blobIds) {
        StorageBatch batch = this.batch();
        final ArrayList results = Lists.newArrayList();
        for (BlobId blob : blobIds) {
            batch.get(blob, new Storage.BlobGetOption[0]).notify((BatchResult.Callback)new BatchResult.Callback<Blob, StorageException>(){

                public void success(Blob result) {
                    results.add(result);
                }

                public void error(StorageException exception) {
                    results.add(null);
                }
            });
        }
        batch.submit();
        return Collections.unmodifiableList(results);
    }

    @Override
    public List<Blob> update(BlobInfo ... blobInfos) {
        return this.update(Arrays.asList(blobInfos));
    }

    @Override
    public List<Blob> update(Iterable<BlobInfo> blobInfos) {
        StorageBatch batch = this.batch();
        final ArrayList results = Lists.newArrayList();
        for (BlobInfo blobInfo : blobInfos) {
            batch.update(blobInfo, new Storage.BlobTargetOption[0]).notify((BatchResult.Callback)new BatchResult.Callback<Blob, StorageException>(){

                public void success(Blob result) {
                    results.add(result);
                }

                public void error(StorageException exception) {
                    results.add(null);
                }
            });
        }
        batch.submit();
        return Collections.unmodifiableList(results);
    }

    @Override
    public List<Boolean> delete(BlobId ... blobIds) {
        return this.delete(Arrays.asList(blobIds));
    }

    @Override
    public List<Boolean> delete(Iterable<BlobId> blobIds) {
        StorageBatch batch = this.batch();
        final ArrayList results = Lists.newArrayList();
        for (BlobId blob : blobIds) {
            batch.delete(blob, new Storage.BlobSourceOption[0]).notify((BatchResult.Callback)new BatchResult.Callback<Boolean, StorageException>(){

                public void success(Boolean result) {
                    results.add(result);
                }

                public void error(StorageException exception) {
                    results.add(Boolean.FALSE);
                }
            });
        }
        batch.submit();
        return Collections.unmodifiableList(results);
    }

    @Override
    public Acl getAcl(String bucket, Acl.Entity entity, Storage.BucketSourceOption ... options) {
        String pb = (String)codecs.entity().encode(entity);
        ImmutableMap<StorageRpc.Option, ?> optionsMap = UnifiedOpts.Opts.unwrap((UnifiedOpts.OptionShim[])options).getRpcOptions();
        ResultRetryAlgorithm<?> algorithm = this.retryAlgorithmManager.getForBucketAclGet(pb, (Map<StorageRpc.Option, ?>)optionsMap);
        return this.run(algorithm, () -> this.storageRpc.getAcl(bucket, pb, (Map<StorageRpc.Option, ?>)optionsMap), codecs.bucketAcl()::decode);
    }

    @Override
    public Acl getAcl(String bucket, Acl.Entity entity) {
        return this.getAcl(bucket, entity, new Storage.BucketSourceOption[0]);
    }

    @Override
    public boolean deleteAcl(String bucket, Acl.Entity entity, Storage.BucketSourceOption ... options) {
        String pb = (String)codecs.entity().encode(entity);
        ImmutableMap<StorageRpc.Option, ?> optionsMap = UnifiedOpts.Opts.unwrap((UnifiedOpts.OptionShim[])options).getRpcOptions();
        ResultRetryAlgorithm<?> algorithm = this.retryAlgorithmManager.getForBucketAclDelete(pb, (Map<StorageRpc.Option, ?>)optionsMap);
        return (Boolean)this.run(algorithm, () -> this.storageRpc.deleteAcl(bucket, pb, (Map<StorageRpc.Option, ?>)optionsMap), Function.identity());
    }

    @Override
    public boolean deleteAcl(String bucket, Acl.Entity entity) {
        return this.deleteAcl(bucket, entity, new Storage.BucketSourceOption[0]);
    }

    @Override
    public Acl createAcl(String bucket, Acl acl, Storage.BucketSourceOption ... options) {
        BucketAccessControl aclPb = ((BucketAccessControl)codecs.bucketAcl().encode(acl)).setBucket(bucket);
        ImmutableMap<StorageRpc.Option, ?> optionsMap = UnifiedOpts.Opts.unwrap((UnifiedOpts.OptionShim[])options).getRpcOptions();
        ResultRetryAlgorithm<?> algorithm = this.retryAlgorithmManager.getForBucketAclCreate(aclPb, (Map<StorageRpc.Option, ?>)optionsMap);
        return this.run(algorithm, () -> this.storageRpc.createAcl(aclPb, (Map<StorageRpc.Option, ?>)optionsMap), codecs.bucketAcl()::decode);
    }

    @Override
    public Acl createAcl(String bucket, Acl acl) {
        return this.createAcl(bucket, acl, new Storage.BucketSourceOption[0]);
    }

    @Override
    public Acl updateAcl(String bucket, Acl acl, Storage.BucketSourceOption ... options) {
        BucketAccessControl aclPb = ((BucketAccessControl)codecs.bucketAcl().encode(acl)).setBucket(bucket);
        ImmutableMap<StorageRpc.Option, ?> optionsMap = UnifiedOpts.Opts.unwrap((UnifiedOpts.OptionShim[])options).getRpcOptions();
        ResultRetryAlgorithm<?> algorithm = this.retryAlgorithmManager.getForBucketAclUpdate(aclPb, (Map<StorageRpc.Option, ?>)optionsMap);
        return this.run(algorithm, () -> this.storageRpc.patchAcl(aclPb, (Map<StorageRpc.Option, ?>)optionsMap), codecs.bucketAcl()::decode);
    }

    @Override
    public Acl updateAcl(String bucket, Acl acl) {
        return this.updateAcl(bucket, acl, new Storage.BucketSourceOption[0]);
    }

    @Override
    public List<Acl> listAcls(String bucket, Storage.BucketSourceOption ... options) {
        ImmutableMap<StorageRpc.Option, ?> optionsMap = UnifiedOpts.Opts.unwrap((UnifiedOpts.OptionShim[])options).getRpcOptions();
        ResultRetryAlgorithm<?> algorithm = this.retryAlgorithmManager.getForBucketAclList(bucket, (Map<StorageRpc.Option, ?>)optionsMap);
        return (List)this.run(algorithm, () -> this.storageRpc.listAcls(bucket, (Map<StorageRpc.Option, ?>)optionsMap), answer -> (ImmutableList)answer.stream().map(codecs.bucketAcl()::decode).collect(ImmutableList.toImmutableList()));
    }

    @Override
    public List<Acl> listAcls(String bucket) {
        return this.listAcls(bucket, new Storage.BucketSourceOption[0]);
    }

    @Override
    public Acl getDefaultAcl(String bucket, Acl.Entity entity) {
        String pb = (String)codecs.entity().encode(entity);
        ResultRetryAlgorithm<?> algorithm = this.retryAlgorithmManager.getForDefaultObjectAclGet(pb);
        return this.run(algorithm, () -> this.storageRpc.getDefaultAcl(bucket, pb), codecs.objectAcl()::decode);
    }

    @Override
    public boolean deleteDefaultAcl(String bucket, Acl.Entity entity) {
        String pb = (String)codecs.entity().encode(entity);
        ResultRetryAlgorithm<?> algorithm = this.retryAlgorithmManager.getForDefaultObjectAclDelete(pb);
        return (Boolean)this.run(algorithm, () -> this.storageRpc.deleteDefaultAcl(bucket, pb), Function.identity());
    }

    @Override
    public Acl createDefaultAcl(String bucket, Acl acl) {
        ObjectAccessControl aclPb = ((ObjectAccessControl)codecs.objectAcl().encode(acl)).setBucket(bucket);
        ResultRetryAlgorithm<?> algorithm = this.retryAlgorithmManager.getForDefaultObjectAclCreate(aclPb);
        return this.run(algorithm, () -> this.storageRpc.createDefaultAcl(aclPb), codecs.objectAcl()::decode);
    }

    @Override
    public Acl updateDefaultAcl(String bucket, Acl acl) {
        ObjectAccessControl aclPb = ((ObjectAccessControl)codecs.objectAcl().encode(acl)).setBucket(bucket);
        ResultRetryAlgorithm<?> algorithm = this.retryAlgorithmManager.getForDefaultObjectAclUpdate(aclPb);
        return this.run(algorithm, () -> this.storageRpc.patchDefaultAcl(aclPb), codecs.objectAcl()::decode);
    }

    @Override
    public List<Acl> listDefaultAcls(String bucket) {
        ResultRetryAlgorithm<?> algorithm = this.retryAlgorithmManager.getForDefaultObjectAclList(bucket);
        return (List)this.run(algorithm, () -> this.storageRpc.listDefaultAcls(bucket), answer -> (ImmutableList)answer.stream().map(codecs.objectAcl()::decode).collect(ImmutableList.toImmutableList()));
    }

    @Override
    public Acl getAcl(BlobId blob, Acl.Entity entity) {
        String bucket = blob.getBucket();
        String name = blob.getName();
        Long generation = blob.getGeneration();
        String pb = (String)codecs.entity().encode(entity);
        ResultRetryAlgorithm<?> algorithm = this.retryAlgorithmManager.getForObjectAclGet(bucket, name, generation, pb);
        return this.run(algorithm, () -> this.storageRpc.getAcl(bucket, name, generation, pb), codecs.objectAcl()::decode);
    }

    @Override
    public boolean deleteAcl(BlobId blob, Acl.Entity entity) {
        String bucket = blob.getBucket();
        String name = blob.getName();
        Long generation = blob.getGeneration();
        String pb = (String)codecs.entity().encode(entity);
        ResultRetryAlgorithm<?> algorithm = this.retryAlgorithmManager.getForObjectAclDelete(bucket, name, generation, pb);
        return (Boolean)this.run(algorithm, () -> this.storageRpc.deleteAcl(bucket, name, generation, pb), Function.identity());
    }

    @Override
    public Acl createAcl(BlobId blob, Acl acl) {
        ObjectAccessControl aclPb = ((ObjectAccessControl)codecs.objectAcl().encode(acl)).setBucket(blob.getBucket()).setObject(blob.getName()).setGeneration(blob.getGeneration());
        ResultRetryAlgorithm<?> algorithm = this.retryAlgorithmManager.getForObjectAclCreate(aclPb);
        return this.run(algorithm, () -> this.storageRpc.createAcl(aclPb), codecs.objectAcl()::decode);
    }

    @Override
    public Acl updateAcl(BlobId blob, Acl acl) {
        ObjectAccessControl aclPb = ((ObjectAccessControl)codecs.objectAcl().encode(acl)).setBucket(blob.getBucket()).setObject(blob.getName()).setGeneration(blob.getGeneration());
        ResultRetryAlgorithm<?> algorithm = this.retryAlgorithmManager.getForObjectAclUpdate(aclPb);
        return this.run(algorithm, () -> this.storageRpc.patchAcl(aclPb), codecs.objectAcl()::decode);
    }

    @Override
    public List<Acl> listAcls(BlobId blob) {
        String bucket = blob.getBucket();
        String name = blob.getName();
        Long generation = blob.getGeneration();
        ResultRetryAlgorithm<?> algorithm = this.retryAlgorithmManager.getForObjectAclList(bucket, name, generation);
        return (List)this.run(algorithm, () -> this.storageRpc.listAcls(bucket, name, generation), answer -> (ImmutableList)answer.stream().map(codecs.objectAcl()::decode).collect(ImmutableList.toImmutableList()));
    }

    @Override
    public HmacKey createHmacKey(ServiceAccount serviceAccount, Storage.CreateHmacKeyOption ... options) {
        String pb = serviceAccount.getEmail();
        ImmutableMap<StorageRpc.Option, ?> optionsMap = UnifiedOpts.Opts.unwrap((UnifiedOpts.OptionShim[])options).getRpcOptions();
        ResultRetryAlgorithm<?> algorithm = this.retryAlgorithmManager.getForHmacKeyCreate(pb, (Map<StorageRpc.Option, ?>)optionsMap);
        return this.run(algorithm, () -> this.storageRpc.createHmacKey(pb, (Map<StorageRpc.Option, ?>)optionsMap), codecs.hmacKey()::decode);
    }

    @Override
    public Page<HmacKey.HmacKeyMetadata> listHmacKeys(Storage.ListHmacKeysOption ... options) {
        ImmutableMap<StorageRpc.Option, ?> optionsMap = UnifiedOpts.Opts.unwrap((UnifiedOpts.OptionShim[])options).getRpcOptions();
        return StorageImpl.listHmacKeys(this.getOptions(), this.retryAlgorithmManager, optionsMap);
    }

    @Override
    public HmacKey.HmacKeyMetadata getHmacKey(String accessId, Storage.GetHmacKeyOption ... options) {
        ImmutableMap<StorageRpc.Option, ?> optionsMap = UnifiedOpts.Opts.unwrap((UnifiedOpts.OptionShim[])options).getRpcOptions();
        ResultRetryAlgorithm<?> algorithm = this.retryAlgorithmManager.getForHmacKeyGet(accessId, (Map<StorageRpc.Option, ?>)optionsMap);
        return this.run(algorithm, () -> this.storageRpc.getHmacKey(accessId, (Map<StorageRpc.Option, ?>)optionsMap), codecs.hmacKeyMetadata()::decode);
    }

    private HmacKey.HmacKeyMetadata updateHmacKey(HmacKey.HmacKeyMetadata hmacKeyMetadata, Storage.UpdateHmacKeyOption ... options) {
        HmacKeyMetadata pb = (HmacKeyMetadata)codecs.hmacKeyMetadata().encode(hmacKeyMetadata);
        ImmutableMap<StorageRpc.Option, ?> optionsMap = UnifiedOpts.Opts.unwrap((UnifiedOpts.OptionShim[])options).getRpcOptions();
        ResultRetryAlgorithm<?> algorithm = this.retryAlgorithmManager.getForHmacKeyUpdate(pb, (Map<StorageRpc.Option, ?>)optionsMap);
        return this.run(algorithm, () -> this.storageRpc.updateHmacKey(pb, (Map<StorageRpc.Option, ?>)optionsMap), codecs.hmacKeyMetadata()::decode);
    }

    @Override
    public HmacKey.HmacKeyMetadata updateHmacKeyState(HmacKey.HmacKeyMetadata hmacKeyMetadata, HmacKey.HmacKeyState state, Storage.UpdateHmacKeyOption ... options) {
        HmacKey.HmacKeyMetadata updatedMetadata = HmacKey.HmacKeyMetadata.newBuilder(hmacKeyMetadata.getServiceAccount()).setProjectId(hmacKeyMetadata.getProjectId()).setAccessId(hmacKeyMetadata.getAccessId()).setState(state).build();
        return this.updateHmacKey(updatedMetadata, options);
    }

    @Override
    public void deleteHmacKey(HmacKey.HmacKeyMetadata metadata, Storage.DeleteHmacKeyOption ... options) {
        HmacKeyMetadata pb = (HmacKeyMetadata)codecs.hmacKeyMetadata().encode(metadata);
        ImmutableMap<StorageRpc.Option, ?> optionsMap = UnifiedOpts.Opts.unwrap((UnifiedOpts.OptionShim[])options).getRpcOptions();
        ResultRetryAlgorithm<?> algorithm = this.retryAlgorithmManager.getForHmacKeyDelete(pb, (Map<StorageRpc.Option, ?>)optionsMap);
        this.run(algorithm, () -> {
            this.storageRpc.deleteHmacKey(pb, (Map<StorageRpc.Option, ?>)optionsMap);
            return null;
        }, Function.identity());
    }

    private static Page<HmacKey.HmacKeyMetadata> listHmacKeys(HttpStorageOptions serviceOptions, HttpRetryAlgorithmManager retryAlgorithmManager, Map<StorageRpc.Option, ?> options) {
        ResultRetryAlgorithm<?> algorithm = retryAlgorithmManager.getForHmacKeyList(options);
        return (Page)Retrying.run(serviceOptions, algorithm, () -> serviceOptions.getStorageRpcV1().listHmacKeys(options), result -> {
            String cursor = (String)result.x();
            ImmutableList metadata = result.y() == null ? ImmutableList.of() : Iterables.transform((Iterable)((Iterable)result.y()), codecs.hmacKeyMetadata()::decode);
            return new PageImpl((PageImpl.NextPageFetcher)new HmacKeyMetadataPageFetcher(serviceOptions, retryAlgorithmManager, options), cursor, (Iterable)metadata);
        });
    }

    @Override
    public Policy getIamPolicy(String bucket, Storage.BucketSourceOption ... options) {
        ImmutableMap<StorageRpc.Option, ?> optionsMap = UnifiedOpts.Opts.unwrap((UnifiedOpts.OptionShim[])options).getRpcOptions();
        ResultRetryAlgorithm<?> algorithm = this.retryAlgorithmManager.getForBucketsGetIamPolicy(bucket, (Map<StorageRpc.Option, ?>)optionsMap);
        return this.run(algorithm, () -> this.storageRpc.getIamPolicy(bucket, (Map<StorageRpc.Option, ?>)optionsMap), apiPolicy -> (Policy)Conversions.json().policyCodec().decode(apiPolicy));
    }

    @Override
    public Policy setIamPolicy(String bucket, Policy policy, Storage.BucketSourceOption ... options) {
        com.google.api.services.storage.model.Policy pb = (com.google.api.services.storage.model.Policy)Conversions.json().policyCodec().encode(policy);
        ImmutableMap<StorageRpc.Option, ?> optionsMap = UnifiedOpts.Opts.unwrap((UnifiedOpts.OptionShim[])options).getRpcOptions();
        ResultRetryAlgorithm<?> algorithm = this.retryAlgorithmManager.getForBucketsSetIamPolicy(bucket, pb, (Map<StorageRpc.Option, ?>)optionsMap);
        return this.run(algorithm, () -> this.storageRpc.setIamPolicy(bucket, pb, (Map<StorageRpc.Option, ?>)optionsMap), apiPolicy -> (Policy)Conversions.json().policyCodec().decode(apiPolicy));
    }

    @Override
    public List<Boolean> testIamPermissions(String bucket, List<String> permissions, Storage.BucketSourceOption ... options) {
        ImmutableMap<StorageRpc.Option, ?> optionsMap = UnifiedOpts.Opts.unwrap((UnifiedOpts.OptionShim[])options).getRpcOptions();
        ResultRetryAlgorithm<?> algorithm = this.retryAlgorithmManager.getForBucketsTestIamPermissions(bucket, permissions, (Map<StorageRpc.Option, ?>)optionsMap);
        return (List)this.run(algorithm, () -> this.storageRpc.testIamPermissions(bucket, permissions, (Map<StorageRpc.Option, ?>)optionsMap), response -> {
            ImmutableSet heldPermissions = response.getPermissions() != null ? ImmutableSet.copyOf((Collection)response.getPermissions()) : ImmutableSet.of();
            return (ImmutableList)permissions.stream().map(((Set)heldPermissions)::contains).collect(ImmutableList.toImmutableList());
        });
    }

    @Override
    public Bucket lockRetentionPolicy(BucketInfo bucketInfo, Storage.BucketTargetOption ... options) {
        com.google.api.services.storage.model.Bucket bucketPb = (com.google.api.services.storage.model.Bucket)codecs.bucketInfo().encode(bucketInfo);
        ImmutableMap<StorageRpc.Option, ?> optionsMap = UnifiedOpts.Opts.unwrap((UnifiedOpts.OptionShim[])options).resolveFrom(bucketInfo).getRpcOptions();
        ResultRetryAlgorithm<?> algorithm = this.retryAlgorithmManager.getForBucketsLockRetentionPolicy(bucketPb, (Map<StorageRpc.Option, ?>)optionsMap);
        return this.run(algorithm, () -> this.storageRpc.lockRetentionPolicy(bucketPb, (Map<StorageRpc.Option, ?>)optionsMap), x -> ((BucketInfo)Conversions.json().bucketInfo().decode(x)).asBucket(this));
    }

    @Override
    public ServiceAccount getServiceAccount(String projectId) {
        ResultRetryAlgorithm<?> algorithm = this.retryAlgorithmManager.getForServiceAccountGet(projectId);
        return this.run(algorithm, () -> this.storageRpc.getServiceAccount(projectId), codecs.serviceAccount()::decode);
    }

    private <T, U> U run(ResultRetryAlgorithm<?> algorithm, Callable<T> c, Function<T, U> f) {
        return Retrying.run(this.getOptions(), algorithm, c, f);
    }

    @Override
    public Notification createNotification(String bucket, NotificationInfo notificationInfo) {
        com.google.api.services.storage.model.Notification notificationPb = (com.google.api.services.storage.model.Notification)codecs.notificationInfo().encode(notificationInfo);
        ResultRetryAlgorithm<?> algorithm = this.retryAlgorithmManager.getForNotificationCreate(bucket, notificationPb);
        return this.run(algorithm, () -> this.storageRpc.createNotification(bucket, notificationPb), n -> ((NotificationInfo)codecs.notificationInfo().decode(n)).asNotification(this));
    }

    @Override
    public Notification getNotification(String bucket, String notificationId) {
        ResultRetryAlgorithm<?> algorithm = this.retryAlgorithmManager.getForNotificationGet(bucket, notificationId);
        return this.run(algorithm, () -> this.storageRpc.getNotification(bucket, notificationId), n -> ((NotificationInfo)codecs.notificationInfo().decode(n)).asNotification(this));
    }

    @Override
    public List<Notification> listNotifications(String bucket) {
        ResultRetryAlgorithm<?> algorithm = this.retryAlgorithmManager.getForNotificationList(bucket);
        List result = (List)this.run(algorithm, () -> this.storageRpc.listNotifications(bucket), answer -> (ImmutableList)answer.stream().map(n -> ((NotificationInfo)codecs.notificationInfo().decode(n)).asNotification(this)).collect(ImmutableList.toImmutableList()));
        return result == null ? ImmutableList.of() : result;
    }

    @Override
    public boolean deleteNotification(String bucket, String notificationId) {
        ResultRetryAlgorithm<?> algorithm = this.retryAlgorithmManager.getForNotificationDelete(bucket, notificationId);
        return (Boolean)this.run(algorithm, () -> this.storageRpc.deleteNotification(bucket, notificationId), Function.identity());
    }

    public HttpStorageOptions getOptions() {
        return (HttpStorageOptions)super.getOptions();
    }

    private Blob internalGetBlob(BlobId blob, Map<StorageRpc.Option, ?> optionsMap) {
        StorageObject storedObject = (StorageObject)codecs.blobId().encode(blob);
        ResultRetryAlgorithm<?> algorithm = this.retryAlgorithmManager.getForObjectsGet(storedObject, optionsMap);
        return this.run(algorithm, () -> this.storageRpc.get(storedObject, optionsMap), x -> {
            BlobInfo info = (BlobInfo)Conversions.json().blobInfo().decode(x);
            return info.asBlob(this);
        });
    }

    private Bucket internalBucketGet(String bucket, Map<StorageRpc.Option, ?> optionsMap) {
        com.google.api.services.storage.model.Bucket bucketPb = (com.google.api.services.storage.model.Bucket)codecs.bucketInfo().encode(BucketInfo.of(bucket));
        ResultRetryAlgorithm<?> algorithm = this.retryAlgorithmManager.getForBucketsGet(bucketPb, optionsMap);
        return this.run(algorithm, () -> this.storageRpc.get(bucketPb, optionsMap), b -> ((BucketInfo)Conversions.json().bucketInfo().decode(b)).asBucket(this));
    }

    private static class HmacKeyMetadataPageFetcher
    implements PageImpl.NextPageFetcher<HmacKey.HmacKeyMetadata> {
        private static final long serialVersionUID = -8637392485924772927L;
        private final HttpStorageOptions serviceOptions;
        private final HttpRetryAlgorithmManager retryAlgorithmManager;
        private final Map<StorageRpc.Option, ?> options;

        HmacKeyMetadataPageFetcher(HttpStorageOptions serviceOptions, HttpRetryAlgorithmManager retryAlgorithmManager, Map<StorageRpc.Option, ?> options) {
            this.serviceOptions = serviceOptions;
            this.retryAlgorithmManager = retryAlgorithmManager;
            this.options = options;
        }

        public Page<HmacKey.HmacKeyMetadata> getNextPage() {
            return StorageImpl.listHmacKeys(this.serviceOptions, this.retryAlgorithmManager, this.options);
        }
    }

    private static class BlobPageFetcher
    implements PageImpl.NextPageFetcher<Blob> {
        private static final long serialVersionUID = -4308415167471093443L;
        private final Map<StorageRpc.Option, ?> requestOptions;
        private final HttpStorageOptions serviceOptions;
        private final String bucket;

        BlobPageFetcher(String bucket, HttpStorageOptions serviceOptions, String cursor, Map<StorageRpc.Option, ?> optionMap) {
            this.requestOptions = PageImpl.nextRequestOptions((Object)((Object)StorageRpc.Option.PAGE_TOKEN), (String)cursor, optionMap);
            this.serviceOptions = serviceOptions;
            this.bucket = bucket;
        }

        public Page<Blob> getNextPage() {
            return StorageImpl.listBlobs(this.bucket, this.serviceOptions, this.requestOptions);
        }
    }

    private static class BucketPageFetcher
    implements PageImpl.NextPageFetcher<Bucket> {
        private static final long serialVersionUID = 8534413447247364038L;
        private final Map<StorageRpc.Option, ?> requestOptions;
        private final HttpStorageOptions serviceOptions;

        BucketPageFetcher(HttpStorageOptions serviceOptions, String cursor, Map<StorageRpc.Option, ?> optionMap) {
            this.requestOptions = PageImpl.nextRequestOptions((Object)((Object)StorageRpc.Option.PAGE_TOKEN), (String)cursor, optionMap);
            this.serviceOptions = serviceOptions;
        }

        public Page<Bucket> getNextPage() {
            return StorageImpl.listBuckets(this.serviceOptions, this.requestOptions);
        }
    }
}

