/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.storage;

import com.google.api.gax.paging.Page;
import com.google.cloud.Tuple;
import com.google.cloud.storage.Acl;
import com.google.cloud.storage.Blob;
import com.google.cloud.storage.BlobId;
import com.google.cloud.storage.BlobInfo;
import com.google.cloud.storage.BucketInfo;
import com.google.cloud.storage.Cors;
import com.google.cloud.storage.Option;
import com.google.cloud.storage.Storage;
import com.google.cloud.storage.StorageClass;
import com.google.cloud.storage.StorageOptions;
import com.google.cloud.storage.spi.v1.StorageRpc;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.common.io.BaseEncoding;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.security.Key;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class Bucket
extends BucketInfo {
    private static final long serialVersionUID = 8574601739542252586L;
    private final StorageOptions options;
    private transient Storage storage;

    Bucket(Storage storage, BucketInfo.BuilderImpl infoBuilder) {
        super(infoBuilder);
        this.storage = (Storage)Preconditions.checkNotNull((Object)storage);
        this.options = (StorageOptions)storage.getOptions();
    }

    public boolean exists(BucketSourceOption ... options) {
        int length = options.length;
        Storage.BucketGetOption[] getOptions = Arrays.copyOf(BucketSourceOption.toGetOptions(this, options), length + 1);
        getOptions[length] = Storage.BucketGetOption.fields(new Storage.BucketField[0]);
        return this.storage.get(this.getName(), getOptions) != null;
    }

    public Bucket reload(BucketSourceOption ... options) {
        return this.storage.get(this.getName(), BucketSourceOption.toGetOptions(this, options));
    }

    public Bucket update(Storage.BucketTargetOption ... options) {
        return this.storage.update(this, options);
    }

    public boolean delete(BucketSourceOption ... options) {
        return this.storage.delete(this.getName(), BucketSourceOption.toSourceOptions(this, options));
    }

    public Page<Blob> list(Storage.BlobListOption ... options) {
        return this.storage.list(this.getName(), options);
    }

    public Blob get(String blob, Storage.BlobGetOption ... options) {
        return this.storage.get(BlobId.of(this.getName(), blob), options);
    }

    public List<Blob> get(String blobName1, String blobName2, String ... blobNames) {
        ArrayList blobIds = Lists.newArrayListWithCapacity((int)(blobNames.length + 2));
        blobIds.add(BlobId.of(this.getName(), blobName1));
        blobIds.add(BlobId.of(this.getName(), blobName2));
        for (String blobName : blobNames) {
            blobIds.add(BlobId.of(this.getName(), blobName));
        }
        return this.storage.get(blobIds);
    }

    public List<Blob> get(Iterable<String> blobNames) {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (String blobName : blobNames) {
            builder.add((Object)BlobId.of(this.getName(), blobName));
        }
        return this.storage.get((Iterable<BlobId>)builder.build());
    }

    public Blob create(String blob, byte[] content, String contentType, BlobTargetOption ... options) {
        BlobInfo blobInfo = BlobInfo.newBuilder(BlobId.of(this.getName(), blob)).setContentType(contentType).build();
        Tuple<BlobInfo, Storage.BlobTargetOption[]> target = BlobTargetOption.toTargetOptions(blobInfo, options);
        return this.storage.create((BlobInfo)target.x(), content, (Storage.BlobTargetOption[])target.y());
    }

    public Blob create(String blob, InputStream content, String contentType, BlobWriteOption ... options) {
        BlobInfo blobInfo = BlobInfo.newBuilder(BlobId.of(this.getName(), blob)).setContentType(contentType).build();
        Tuple<BlobInfo, Storage.BlobWriteOption[]> write = BlobWriteOption.toWriteOptions(blobInfo, options);
        return this.storage.create((BlobInfo)write.x(), content, (Storage.BlobWriteOption[])write.y());
    }

    public Blob create(String blob, byte[] content, BlobTargetOption ... options) {
        BlobInfo blobInfo = BlobInfo.newBuilder(BlobId.of(this.getName(), blob)).build();
        Tuple<BlobInfo, Storage.BlobTargetOption[]> target = BlobTargetOption.toTargetOptions(blobInfo, options);
        return this.storage.create((BlobInfo)target.x(), content, (Storage.BlobTargetOption[])target.y());
    }

    public Blob create(String blob, InputStream content, BlobWriteOption ... options) {
        BlobInfo blobInfo = BlobInfo.newBuilder(BlobId.of(this.getName(), blob)).build();
        Tuple<BlobInfo, Storage.BlobWriteOption[]> write = BlobWriteOption.toWriteOptions(blobInfo, options);
        return this.storage.create((BlobInfo)write.x(), content, (Storage.BlobWriteOption[])write.y());
    }

    public Acl getAcl(Acl.Entity entity) {
        return this.storage.getAcl(this.getName(), entity);
    }

    public boolean deleteAcl(Acl.Entity entity) {
        return this.storage.deleteAcl(this.getName(), entity);
    }

    public Acl createAcl(Acl acl) {
        return this.storage.createAcl(this.getName(), acl);
    }

    public Acl updateAcl(Acl acl) {
        return this.storage.updateAcl(this.getName(), acl);
    }

    public List<Acl> listAcls() {
        return this.storage.listAcls(this.getName());
    }

    public Acl getDefaultAcl(Acl.Entity entity) {
        return this.storage.getDefaultAcl(this.getName(), entity);
    }

    public boolean deleteDefaultAcl(Acl.Entity entity) {
        return this.storage.deleteDefaultAcl(this.getName(), entity);
    }

    public Acl createDefaultAcl(Acl acl) {
        return this.storage.createDefaultAcl(this.getName(), acl);
    }

    public Acl updateDefaultAcl(Acl acl) {
        return this.storage.updateDefaultAcl(this.getName(), acl);
    }

    public List<Acl> listDefaultAcls() {
        return this.storage.listDefaultAcls(this.getName());
    }

    public Bucket lockRetentionPolicy(Storage.BucketTargetOption ... options) {
        return this.storage.lockRetentionPolicy(this, options);
    }

    public Storage getStorage() {
        return this.storage;
    }

    @Override
    public Builder toBuilder() {
        return new Builder(this);
    }

    @Override
    public final boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || !obj.getClass().equals(Bucket.class)) {
            return false;
        }
        Bucket other = (Bucket)obj;
        return Objects.equals(this.toPb(), other.toPb()) && Objects.equals((Object)this.options, (Object)other.options);
    }

    @Override
    public final int hashCode() {
        return Objects.hash(new Object[]{super.hashCode(), this.options});
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.storage = (Storage)this.options.getService();
    }

    static Bucket fromPb(Storage storage, com.google.api.services.storage.model.Bucket bucketPb) {
        return new Bucket(storage, new BucketInfo.BuilderImpl(BucketInfo.fromPb(bucketPb)));
    }

    public static class Builder
    extends BucketInfo.Builder {
        private final Storage storage;
        private final BucketInfo.BuilderImpl infoBuilder;

        Builder(Bucket bucket) {
            this.storage = bucket.storage;
            this.infoBuilder = new BucketInfo.BuilderImpl(bucket);
        }

        @Override
        public Builder setName(String name) {
            this.infoBuilder.setName(name);
            return this;
        }

        @Override
        Builder setGeneratedId(String generatedId) {
            this.infoBuilder.setGeneratedId(generatedId);
            return this;
        }

        @Override
        Builder setOwner(Acl.Entity owner) {
            this.infoBuilder.setOwner(owner);
            return this;
        }

        @Override
        Builder setSelfLink(String selfLink) {
            this.infoBuilder.setSelfLink(selfLink);
            return this;
        }

        @Override
        public Builder setVersioningEnabled(Boolean enable) {
            this.infoBuilder.setVersioningEnabled(enable);
            return this;
        }

        @Override
        public Builder setRequesterPays(Boolean requesterPays) {
            this.infoBuilder.setRequesterPays(requesterPays);
            return this;
        }

        @Override
        public Builder setIndexPage(String indexPage) {
            this.infoBuilder.setIndexPage(indexPage);
            return this;
        }

        @Override
        public Builder setNotFoundPage(String notFoundPage) {
            this.infoBuilder.setNotFoundPage(notFoundPage);
            return this;
        }

        @Override
        public Builder setDeleteRules(Iterable<? extends BucketInfo.DeleteRule> rules) {
            this.infoBuilder.setDeleteRules(rules);
            return this;
        }

        @Override
        public Builder setStorageClass(StorageClass storageClass) {
            this.infoBuilder.setStorageClass(storageClass);
            return this;
        }

        @Override
        public Builder setLocation(String location) {
            this.infoBuilder.setLocation(location);
            return this;
        }

        @Override
        Builder setEtag(String etag) {
            this.infoBuilder.setEtag(etag);
            return this;
        }

        @Override
        Builder setCreateTime(Long createTime) {
            this.infoBuilder.setCreateTime(createTime);
            return this;
        }

        @Override
        Builder setMetageneration(Long metageneration) {
            this.infoBuilder.setMetageneration(metageneration);
            return this;
        }

        @Override
        public Builder setCors(Iterable<Cors> cors) {
            this.infoBuilder.setCors(cors);
            return this;
        }

        @Override
        public Builder setAcl(Iterable<Acl> acl) {
            this.infoBuilder.setAcl(acl);
            return this;
        }

        @Override
        public Builder setDefaultAcl(Iterable<Acl> acl) {
            this.infoBuilder.setDefaultAcl(acl);
            return this;
        }

        @Override
        public Builder setLabels(Map<String, String> labels) {
            this.infoBuilder.setLabels(labels);
            return this;
        }

        @Override
        public Builder setDefaultKmsKeyName(String defaultKmsKeyName) {
            this.infoBuilder.setDefaultKmsKeyName(defaultKmsKeyName);
            return this;
        }

        @Override
        public Builder setDefaultEventBasedHold(Boolean defaultEventBasedHold) {
            this.infoBuilder.setDefaultEventBasedHold(defaultEventBasedHold);
            return this;
        }

        @Override
        Builder setRetentionEffectiveTime(Long retentionEffectiveTime) {
            this.infoBuilder.setRetentionEffectiveTime(retentionEffectiveTime);
            return this;
        }

        @Override
        Builder setRetentionPolicyIsLocked(Boolean retentionIsLocked) {
            this.infoBuilder.setRetentionPolicyIsLocked(retentionIsLocked);
            return this;
        }

        @Override
        public Builder setRetentionPeriod(Long retentionPeriod) {
            this.infoBuilder.setRetentionPeriod(retentionPeriod);
            return this;
        }

        @Override
        public Bucket build() {
            return new Bucket(this.storage, this.infoBuilder);
        }
    }

    public static class BlobWriteOption
    implements Serializable {
        private static final Function<BlobWriteOption, Storage.BlobWriteOption.Option> TO_ENUM = new Function<BlobWriteOption, Storage.BlobWriteOption.Option>(){

            public Storage.BlobWriteOption.Option apply(BlobWriteOption blobWriteOption) {
                return blobWriteOption.option;
            }
        };
        private static final long serialVersionUID = 4722190734541993114L;
        private final Storage.BlobWriteOption.Option option;
        private final Object value;

        private Tuple<BlobInfo, Storage.BlobWriteOption> toWriteOption(BlobInfo blobInfo) {
            BlobId blobId = blobInfo.getBlobId();
            switch (this.option) {
                case PREDEFINED_ACL: {
                    return Tuple.of((Object)blobInfo, (Object)Storage.BlobWriteOption.predefinedAcl((Storage.PredefinedAcl)((Object)this.value)));
                }
                case IF_GENERATION_MATCH: {
                    blobId = BlobId.of(blobId.getBucket(), blobId.getName(), (Long)this.value);
                    return Tuple.of((Object)blobInfo.toBuilder().setBlobId(blobId).build(), (Object)Storage.BlobWriteOption.generationMatch());
                }
                case IF_GENERATION_NOT_MATCH: {
                    blobId = BlobId.of(blobId.getBucket(), blobId.getName(), (Long)this.value);
                    return Tuple.of((Object)blobInfo.toBuilder().setBlobId(blobId).build(), (Object)Storage.BlobWriteOption.generationNotMatch());
                }
                case IF_METAGENERATION_MATCH: {
                    return Tuple.of((Object)blobInfo.toBuilder().setMetageneration((Long)this.value).build(), (Object)Storage.BlobWriteOption.metagenerationMatch());
                }
                case IF_METAGENERATION_NOT_MATCH: {
                    return Tuple.of((Object)blobInfo.toBuilder().setMetageneration((Long)this.value).build(), (Object)Storage.BlobWriteOption.metagenerationNotMatch());
                }
                case IF_MD5_MATCH: {
                    return Tuple.of((Object)blobInfo.toBuilder().setMd5((String)this.value).build(), (Object)Storage.BlobWriteOption.md5Match());
                }
                case IF_CRC32C_MATCH: {
                    return Tuple.of((Object)blobInfo.toBuilder().setCrc32c((String)this.value).build(), (Object)Storage.BlobWriteOption.crc32cMatch());
                }
                case CUSTOMER_SUPPLIED_KEY: {
                    return Tuple.of((Object)blobInfo, (Object)Storage.BlobWriteOption.encryptionKey((String)this.value));
                }
                case KMS_KEY_NAME: {
                    return Tuple.of((Object)blobInfo, (Object)Storage.BlobWriteOption.kmsKeyName((String)this.value));
                }
                case USER_PROJECT: {
                    return Tuple.of((Object)blobInfo, (Object)Storage.BlobWriteOption.userProject((String)this.value));
                }
            }
            throw new AssertionError((Object)"Unexpected enum value");
        }

        private BlobWriteOption(Storage.BlobWriteOption.Option option, Object value) {
            this.option = option;
            this.value = value;
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.option, this.value});
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof BlobWriteOption)) {
                return false;
            }
            BlobWriteOption other = (BlobWriteOption)obj;
            return this.option == other.option && Objects.equals(this.value, other.value);
        }

        public static BlobWriteOption predefinedAcl(Storage.PredefinedAcl acl) {
            return new BlobWriteOption(Storage.BlobWriteOption.Option.PREDEFINED_ACL, (Object)acl);
        }

        public static BlobWriteOption doesNotExist() {
            return new BlobWriteOption(Storage.BlobWriteOption.Option.IF_GENERATION_MATCH, 0L);
        }

        public static BlobWriteOption generationMatch(long generation) {
            return new BlobWriteOption(Storage.BlobWriteOption.Option.IF_GENERATION_MATCH, generation);
        }

        public static BlobWriteOption generationNotMatch(long generation) {
            return new BlobWriteOption(Storage.BlobWriteOption.Option.IF_GENERATION_NOT_MATCH, generation);
        }

        public static BlobWriteOption metagenerationMatch(long metageneration) {
            return new BlobWriteOption(Storage.BlobWriteOption.Option.IF_METAGENERATION_MATCH, metageneration);
        }

        public static BlobWriteOption metagenerationNotMatch(long metageneration) {
            return new BlobWriteOption(Storage.BlobWriteOption.Option.IF_METAGENERATION_NOT_MATCH, metageneration);
        }

        public static BlobWriteOption md5Match(String md5) {
            return new BlobWriteOption(Storage.BlobWriteOption.Option.IF_MD5_MATCH, md5);
        }

        public static BlobWriteOption crc32cMatch(String crc32c) {
            return new BlobWriteOption(Storage.BlobWriteOption.Option.IF_CRC32C_MATCH, crc32c);
        }

        public static BlobWriteOption encryptionKey(Key key) {
            String base64Key = BaseEncoding.base64().encode(key.getEncoded());
            return new BlobWriteOption(Storage.BlobWriteOption.Option.CUSTOMER_SUPPLIED_KEY, base64Key);
        }

        public static BlobWriteOption encryptionKey(String key) {
            return new BlobWriteOption(Storage.BlobWriteOption.Option.CUSTOMER_SUPPLIED_KEY, key);
        }

        public static BlobWriteOption userProject(String userProject) {
            return new BlobWriteOption(Storage.BlobWriteOption.Option.USER_PROJECT, userProject);
        }

        static Tuple<BlobInfo, Storage.BlobWriteOption[]> toWriteOptions(BlobInfo info, BlobWriteOption ... options) {
            ImmutableSet optionSet = Sets.immutableEnumSet((Iterable)Lists.transform(Arrays.asList(options), TO_ENUM));
            Preconditions.checkArgument((!optionSet.contains((Object)Storage.BlobWriteOption.Option.IF_METAGENERATION_NOT_MATCH) || !optionSet.contains((Object)Storage.BlobWriteOption.Option.IF_METAGENERATION_MATCH) ? 1 : 0) != 0, (Object)"metagenerationMatch and metagenerationNotMatch options can not be both provided");
            Preconditions.checkArgument((!optionSet.contains((Object)Storage.BlobWriteOption.Option.IF_GENERATION_NOT_MATCH) || !optionSet.contains((Object)Storage.BlobWriteOption.Option.IF_GENERATION_MATCH) ? 1 : 0) != 0, (Object)"Only one option of generationMatch, doesNotExist or generationNotMatch can be provided");
            Storage.BlobWriteOption[] convertedOptions = new Storage.BlobWriteOption[options.length];
            BlobInfo writeInfo = info;
            int index = 0;
            for (BlobWriteOption option : options) {
                Tuple<BlobInfo, Storage.BlobWriteOption> write = option.toWriteOption(writeInfo);
                writeInfo = (BlobInfo)write.x();
                convertedOptions[index++] = (Storage.BlobWriteOption)write.y();
            }
            return Tuple.of((Object)writeInfo, (Object)convertedOptions);
        }
    }

    public static class BlobTargetOption
    extends Option {
        private static final Function<BlobTargetOption, StorageRpc.Option> TO_ENUM = new Function<BlobTargetOption, StorageRpc.Option>(){

            public StorageRpc.Option apply(BlobTargetOption blobTargetOption) {
                return blobTargetOption.getRpcOption();
            }
        };
        private static final long serialVersionUID = 8345296337342509425L;

        private BlobTargetOption(StorageRpc.Option rpcOption, Object value) {
            super(rpcOption, value);
        }

        private Tuple<BlobInfo, Storage.BlobTargetOption> toTargetOption(BlobInfo blobInfo) {
            BlobId blobId = blobInfo.getBlobId();
            switch (this.getRpcOption()) {
                case PREDEFINED_ACL: {
                    return Tuple.of((Object)blobInfo, (Object)Storage.BlobTargetOption.predefinedAcl((Storage.PredefinedAcl)((Object)this.getValue())));
                }
                case IF_GENERATION_MATCH: {
                    blobId = BlobId.of(blobId.getBucket(), blobId.getName(), (Long)this.getValue());
                    return Tuple.of((Object)blobInfo.toBuilder().setBlobId(blobId).build(), (Object)Storage.BlobTargetOption.generationMatch());
                }
                case IF_GENERATION_NOT_MATCH: {
                    blobId = BlobId.of(blobId.getBucket(), blobId.getName(), (Long)this.getValue());
                    return Tuple.of((Object)blobInfo.toBuilder().setBlobId(blobId).build(), (Object)Storage.BlobTargetOption.generationNotMatch());
                }
                case IF_METAGENERATION_MATCH: {
                    return Tuple.of((Object)blobInfo.toBuilder().setMetageneration((Long)this.getValue()).build(), (Object)Storage.BlobTargetOption.metagenerationMatch());
                }
                case IF_METAGENERATION_NOT_MATCH: {
                    return Tuple.of((Object)blobInfo.toBuilder().setMetageneration((Long)this.getValue()).build(), (Object)Storage.BlobTargetOption.metagenerationNotMatch());
                }
                case CUSTOMER_SUPPLIED_KEY: {
                    return Tuple.of((Object)blobInfo, (Object)Storage.BlobTargetOption.encryptionKey((String)this.getValue()));
                }
                case KMS_KEY_NAME: {
                    return Tuple.of((Object)blobInfo, (Object)Storage.BlobTargetOption.kmsKeyName((String)this.getValue()));
                }
                case USER_PROJECT: {
                    return Tuple.of((Object)blobInfo, (Object)Storage.BlobTargetOption.userProject((String)this.getValue()));
                }
            }
            throw new AssertionError((Object)"Unexpected enum value");
        }

        public static BlobTargetOption predefinedAcl(Storage.PredefinedAcl acl) {
            return new BlobTargetOption(StorageRpc.Option.PREDEFINED_ACL, (Object)acl);
        }

        public static BlobTargetOption doesNotExist() {
            return new BlobTargetOption(StorageRpc.Option.IF_GENERATION_MATCH, 0L);
        }

        public static BlobTargetOption generationMatch(long generation) {
            return new BlobTargetOption(StorageRpc.Option.IF_GENERATION_MATCH, generation);
        }

        public static BlobTargetOption generationNotMatch(long generation) {
            return new BlobTargetOption(StorageRpc.Option.IF_GENERATION_NOT_MATCH, generation);
        }

        public static BlobTargetOption metagenerationMatch(long metageneration) {
            return new BlobTargetOption(StorageRpc.Option.IF_METAGENERATION_MATCH, metageneration);
        }

        public static BlobTargetOption metagenerationNotMatch(long metageneration) {
            return new BlobTargetOption(StorageRpc.Option.IF_METAGENERATION_NOT_MATCH, metageneration);
        }

        public static BlobTargetOption encryptionKey(Key key) {
            String base64Key = BaseEncoding.base64().encode(key.getEncoded());
            return new BlobTargetOption(StorageRpc.Option.CUSTOMER_SUPPLIED_KEY, base64Key);
        }

        public static BlobTargetOption encryptionKey(String key) {
            return new BlobTargetOption(StorageRpc.Option.CUSTOMER_SUPPLIED_KEY, key);
        }

        public static BlobTargetOption kmsKeyName(String kmsKeyName) {
            return new BlobTargetOption(StorageRpc.Option.KMS_KEY_NAME, kmsKeyName);
        }

        public static BlobTargetOption userProject(String userProject) {
            return new BlobTargetOption(StorageRpc.Option.USER_PROJECT, userProject);
        }

        static Tuple<BlobInfo, Storage.BlobTargetOption[]> toTargetOptions(BlobInfo info, BlobTargetOption ... options) {
            ImmutableSet optionSet = Sets.immutableEnumSet((Iterable)Lists.transform(Arrays.asList(options), TO_ENUM));
            Preconditions.checkArgument((!optionSet.contains((Object)StorageRpc.Option.IF_METAGENERATION_NOT_MATCH) || !optionSet.contains((Object)StorageRpc.Option.IF_METAGENERATION_MATCH) ? 1 : 0) != 0, (Object)"metagenerationMatch and metagenerationNotMatch options can not be both provided");
            Preconditions.checkArgument((!optionSet.contains((Object)StorageRpc.Option.IF_GENERATION_NOT_MATCH) || !optionSet.contains((Object)StorageRpc.Option.IF_GENERATION_MATCH) ? 1 : 0) != 0, (Object)"Only one option of generationMatch, doesNotExist or generationNotMatch can be provided");
            Storage.BlobTargetOption[] convertedOptions = new Storage.BlobTargetOption[options.length];
            BlobInfo targetInfo = info;
            int index = 0;
            for (BlobTargetOption option : options) {
                Tuple<BlobInfo, Storage.BlobTargetOption> target = option.toTargetOption(targetInfo);
                targetInfo = (BlobInfo)target.x();
                convertedOptions[index++] = (Storage.BlobTargetOption)target.y();
            }
            return Tuple.of((Object)targetInfo, (Object)convertedOptions);
        }
    }

    public static class BucketSourceOption
    extends Option {
        private static final long serialVersionUID = 6928872234155522371L;

        private BucketSourceOption(StorageRpc.Option rpcOption) {
            super(rpcOption, null);
        }

        private BucketSourceOption(StorageRpc.Option rpcOption, Object value) {
            super(rpcOption, value);
        }

        private Storage.BucketSourceOption toSourceOption(BucketInfo bucketInfo) {
            switch (this.getRpcOption()) {
                case IF_METAGENERATION_MATCH: {
                    return Storage.BucketSourceOption.metagenerationMatch(bucketInfo.getMetageneration());
                }
                case IF_METAGENERATION_NOT_MATCH: {
                    return Storage.BucketSourceOption.metagenerationNotMatch(bucketInfo.getMetageneration());
                }
            }
            throw new AssertionError((Object)"Unexpected enum value");
        }

        private Storage.BucketGetOption toGetOption(BucketInfo bucketInfo) {
            switch (this.getRpcOption()) {
                case IF_METAGENERATION_MATCH: {
                    return Storage.BucketGetOption.metagenerationMatch(bucketInfo.getMetageneration());
                }
                case IF_METAGENERATION_NOT_MATCH: {
                    return Storage.BucketGetOption.metagenerationNotMatch(bucketInfo.getMetageneration());
                }
            }
            throw new AssertionError((Object)"Unexpected enum value");
        }

        public static BucketSourceOption metagenerationMatch() {
            return new BucketSourceOption(StorageRpc.Option.IF_METAGENERATION_MATCH);
        }

        public static BucketSourceOption metagenerationNotMatch() {
            return new BucketSourceOption(StorageRpc.Option.IF_METAGENERATION_NOT_MATCH);
        }

        public static BucketSourceOption userProject(String userProject) {
            return new BucketSourceOption(StorageRpc.Option.USER_PROJECT, userProject);
        }

        static Storage.BucketSourceOption[] toSourceOptions(BucketInfo bucketInfo, BucketSourceOption ... options) {
            Storage.BucketSourceOption[] convertedOptions = new Storage.BucketSourceOption[options.length];
            int index = 0;
            for (BucketSourceOption option : options) {
                convertedOptions[index++] = option.toSourceOption(bucketInfo);
            }
            return convertedOptions;
        }

        static Storage.BucketGetOption[] toGetOptions(BucketInfo bucketInfo, BucketSourceOption ... options) {
            Storage.BucketGetOption[] convertedOptions = new Storage.BucketGetOption[options.length];
            int index = 0;
            for (BucketSourceOption option : options) {
                convertedOptions[index++] = option.toGetOption(bucketInfo);
            }
            return convertedOptions;
        }
    }
}

