/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.storage;

import com.google.cloud.Clock;
import com.google.cloud.ExceptionHandler;
import com.google.cloud.Restorable;
import com.google.cloud.RestorableState;
import com.google.cloud.RetryHelper;
import com.google.cloud.RetryParams;
import com.google.cloud.storage.Blob;
import com.google.cloud.storage.BlobId;
import com.google.cloud.storage.BlobInfo;
import com.google.cloud.storage.Storage;
import com.google.cloud.storage.StorageException;
import com.google.cloud.storage.StorageImpl;
import com.google.cloud.storage.StorageOptions;
import com.google.cloud.storage.spi.StorageRpc;
import com.google.common.base.MoreObjects;
import java.io.Serializable;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Callable;

public class CopyWriter
implements Restorable<CopyWriter> {
    private final StorageOptions serviceOptions;
    private final StorageRpc storageRpc;
    private StorageRpc.RewriteResponse rewriteResponse;

    CopyWriter(StorageOptions serviceOptions, StorageRpc.RewriteResponse rewriteResponse) {
        this.serviceOptions = serviceOptions;
        this.rewriteResponse = rewriteResponse;
        this.storageRpc = (StorageRpc)serviceOptions.getRpc();
    }

    @Deprecated
    public Blob result() {
        return this.getResult();
    }

    public Blob getResult() {
        while (!this.isDone()) {
            this.copyChunk();
        }
        return Blob.fromPb((Storage)this.serviceOptions.getService(), this.rewriteResponse.result);
    }

    @Deprecated
    public long blobSize() {
        return this.getBlobSize();
    }

    public long getBlobSize() {
        return this.rewriteResponse.blobSize;
    }

    public boolean isDone() {
        return this.rewriteResponse.isDone;
    }

    @Deprecated
    public long totalBytesCopied() {
        return this.getTotalBytesCopied();
    }

    public long getTotalBytesCopied() {
        return this.rewriteResponse.totalBytesRewritten;
    }

    public void copyChunk() {
        if (!this.isDone()) {
            try {
                this.rewriteResponse = (StorageRpc.RewriteResponse)RetryHelper.runWithRetries((Callable)new Callable<StorageRpc.RewriteResponse>(){

                    @Override
                    public StorageRpc.RewriteResponse call() {
                        return CopyWriter.this.storageRpc.continueRewrite(CopyWriter.this.rewriteResponse);
                    }
                }, (RetryParams)this.serviceOptions.getRetryParams(), (ExceptionHandler)StorageImpl.EXCEPTION_HANDLER, (Clock)this.serviceOptions.getClock());
            }
            catch (RetryHelper.RetryHelperException e) {
                throw StorageException.translateAndThrow(e);
            }
        }
    }

    public RestorableState<CopyWriter> capture() {
        return StateImpl.newBuilder(this.serviceOptions, BlobId.fromPb(this.rewriteResponse.rewriteRequest.source), this.rewriteResponse.rewriteRequest.sourceOptions, this.rewriteResponse.rewriteRequest.overrideInfo, BlobInfo.fromPb(this.rewriteResponse.rewriteRequest.target), this.rewriteResponse.rewriteRequest.targetOptions).setResult(this.rewriteResponse.result != null ? BlobInfo.fromPb(this.rewriteResponse.result) : null).setBlobSize(this.getBlobSize()).setIsDone(this.isDone()).setMegabytesCopiedPerChunk(this.rewriteResponse.rewriteRequest.megabytesRewrittenPerCall).setRewriteToken(this.rewriteResponse.rewriteToken).setTotalBytesRewritten(this.getTotalBytesCopied()).build();
    }

    static class StateImpl
    implements RestorableState<CopyWriter>,
    Serializable {
        private static final long serialVersionUID = 1693964441435822700L;
        private final StorageOptions serviceOptions;
        private final BlobId source;
        private final Map<StorageRpc.Option, ?> sourceOptions;
        private final boolean overrideInfo;
        private final BlobInfo target;
        private final Map<StorageRpc.Option, ?> targetOptions;
        private final BlobInfo result;
        private final long blobSize;
        private final boolean isDone;
        private final String rewriteToken;
        private final long totalBytesCopied;
        private final Long megabytesCopiedPerChunk;

        StateImpl(Builder builder) {
            this.serviceOptions = builder.serviceOptions;
            this.source = builder.source;
            this.sourceOptions = builder.sourceOptions;
            this.overrideInfo = builder.overrideInfo;
            this.target = builder.target;
            this.targetOptions = builder.targetOptions;
            this.result = builder.result;
            this.blobSize = builder.blobSize;
            this.isDone = builder.isDone;
            this.rewriteToken = builder.rewriteToken;
            this.totalBytesCopied = builder.totalBytesCopied;
            this.megabytesCopiedPerChunk = builder.megabytesCopiedPerChunk;
        }

        static Builder newBuilder(StorageOptions options, BlobId source, Map<StorageRpc.Option, ?> sourceOptions, boolean overrideInfo, BlobInfo target, Map<StorageRpc.Option, ?> targetOptions) {
            return new Builder(options, source, sourceOptions, overrideInfo, target, targetOptions);
        }

        public CopyWriter restore() {
            StorageRpc.RewriteRequest rewriteRequest = new StorageRpc.RewriteRequest(this.source.toPb(), this.sourceOptions, this.overrideInfo, this.target.toPb(), this.targetOptions, this.megabytesCopiedPerChunk);
            StorageRpc.RewriteResponse rewriteResponse = new StorageRpc.RewriteResponse(rewriteRequest, this.result != null ? this.result.toPb() : null, this.blobSize, this.isDone, this.rewriteToken, this.totalBytesCopied);
            return new CopyWriter(this.serviceOptions, rewriteResponse);
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.serviceOptions, this.source, this.sourceOptions, this.overrideInfo, this.target, this.targetOptions, this.result, this.blobSize, this.isDone, this.megabytesCopiedPerChunk, this.rewriteToken, this.totalBytesCopied});
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof StateImpl)) {
                return false;
            }
            StateImpl other = (StateImpl)obj;
            return Objects.equals((Object)this.serviceOptions, (Object)other.serviceOptions) && Objects.equals(this.source, other.source) && Objects.equals(this.sourceOptions, other.sourceOptions) && Objects.equals(this.overrideInfo, other.overrideInfo) && Objects.equals(this.target, other.target) && Objects.equals(this.targetOptions, other.targetOptions) && Objects.equals(this.result, other.result) && Objects.equals(this.rewriteToken, other.rewriteToken) && Objects.equals(this.megabytesCopiedPerChunk, other.megabytesCopiedPerChunk) && this.blobSize == other.blobSize && this.isDone == other.isDone && this.totalBytesCopied == other.totalBytesCopied;
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("source", (Object)this.source).add("overrideInfo", this.overrideInfo).add("target", (Object)this.target).add("result", (Object)this.result).add("blobSize", this.blobSize).add("isDone", this.isDone).add("rewriteToken", (Object)this.rewriteToken).add("totalBytesCopied", this.totalBytesCopied).add("megabytesCopiedPerChunk", (Object)this.megabytesCopiedPerChunk).toString();
        }

        static class Builder {
            private final StorageOptions serviceOptions;
            private final BlobId source;
            private final Map<StorageRpc.Option, ?> sourceOptions;
            private final boolean overrideInfo;
            private final BlobInfo target;
            private final Map<StorageRpc.Option, ?> targetOptions;
            private BlobInfo result;
            private long blobSize;
            private boolean isDone;
            private String rewriteToken;
            private long totalBytesCopied;
            private Long megabytesCopiedPerChunk;

            private Builder(StorageOptions options, BlobId source, Map<StorageRpc.Option, ?> sourceOptions, boolean overrideInfo, BlobInfo target, Map<StorageRpc.Option, ?> targetOptions) {
                this.serviceOptions = options;
                this.source = source;
                this.sourceOptions = sourceOptions;
                this.overrideInfo = overrideInfo;
                this.target = target;
                this.targetOptions = targetOptions;
            }

            Builder setResult(BlobInfo result) {
                this.result = result;
                return this;
            }

            Builder setBlobSize(long blobSize) {
                this.blobSize = blobSize;
                return this;
            }

            Builder setIsDone(boolean isDone) {
                this.isDone = isDone;
                return this;
            }

            Builder setRewriteToken(String rewriteToken) {
                this.rewriteToken = rewriteToken;
                return this;
            }

            Builder setTotalBytesRewritten(long totalBytesRewritten) {
                this.totalBytesCopied = totalBytesRewritten;
                return this;
            }

            Builder setMegabytesCopiedPerChunk(Long megabytesCopiedPerChunk) {
                this.megabytesCopiedPerChunk = megabytesCopiedPerChunk;
                return this;
            }

            RestorableState<CopyWriter> build() {
                return new StateImpl(this);
            }
        }
    }
}

