/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.storage;

import com.google.cloud.BaseWriteChannel;
import com.google.cloud.Clock;
import com.google.cloud.ExceptionHandler;
import com.google.cloud.RestorableState;
import com.google.cloud.RetryHelper;
import com.google.cloud.RetryParams;
import com.google.cloud.ServiceOptions;
import com.google.cloud.WriteChannel;
import com.google.cloud.storage.BlobInfo;
import com.google.cloud.storage.StorageException;
import com.google.cloud.storage.StorageImpl;
import com.google.cloud.storage.StorageOptions;
import com.google.cloud.storage.spi.StorageRpc;
import java.io.Serializable;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.Executors;

class BlobWriteChannel
extends BaseWriteChannel<StorageOptions, BlobInfo> {
    BlobWriteChannel(StorageOptions options, BlobInfo blob, Map<StorageRpc.Option, ?> optionsMap) {
        this(options, blob, BlobWriteChannel.open(options, blob, optionsMap));
    }

    BlobWriteChannel(StorageOptions options, BlobInfo blobInfo, String uploadId) {
        super((ServiceOptions)options, (Serializable)blobInfo, uploadId);
    }

    protected void flushBuffer(final int length, final boolean last) {
        try {
            RetryHelper.runWithRetries(Executors.callable(new Runnable(){

                @Override
                public void run() {
                    ((StorageRpc)((StorageOptions)BlobWriteChannel.this.options()).rpc()).write(BlobWriteChannel.this.uploadId(), BlobWriteChannel.this.buffer(), 0, BlobWriteChannel.this.position(), length, last);
                }
            }), (RetryParams)((StorageOptions)this.options()).retryParams(), (ExceptionHandler)StorageImpl.EXCEPTION_HANDLER, (Clock)((StorageOptions)this.options()).clock());
        }
        catch (RetryHelper.RetryHelperException e) {
            throw StorageException.translateAndThrow(e);
        }
    }

    protected StateImpl.Builder stateBuilder() {
        return StateImpl.builder((StorageOptions)this.options(), (BlobInfo)this.entity(), this.uploadId());
    }

    private static String open(final StorageOptions options, final BlobInfo blob, final Map<StorageRpc.Option, ?> optionsMap) {
        try {
            return (String)RetryHelper.runWithRetries((Callable)new Callable<String>(){

                @Override
                public String call() {
                    return ((StorageRpc)options.rpc()).open(blob.toPb(), optionsMap);
                }
            }, (RetryParams)options.retryParams(), (ExceptionHandler)StorageImpl.EXCEPTION_HANDLER, (Clock)options.clock());
        }
        catch (RetryHelper.RetryHelperException e) {
            throw StorageException.translateAndThrow(e);
        }
    }

    static class StateImpl
    extends BaseWriteChannel.BaseState<StorageOptions, BlobInfo> {
        private static final long serialVersionUID = -9028324143780151286L;

        StateImpl(Builder builder) {
            super((BaseWriteChannel.BaseState.Builder)builder);
        }

        static Builder builder(StorageOptions options, BlobInfo blobInfo, String uploadId) {
            return new Builder(options, blobInfo, uploadId);
        }

        public WriteChannel restore() {
            BlobWriteChannel channel = new BlobWriteChannel((StorageOptions)this.serviceOptions, (BlobInfo)this.entity, this.uploadId);
            channel.restore(this);
            return channel;
        }

        static class Builder
        extends BaseWriteChannel.BaseState.Builder<StorageOptions, BlobInfo> {
            private Builder(StorageOptions options, BlobInfo blobInfo, String uploadId) {
                super((ServiceOptions)options, (Serializable)blobInfo, uploadId);
            }

            public RestorableState<WriteChannel> build() {
                return new StateImpl(this);
            }
        }
    }
}

