/*
 * Decompiled with CFR 0.152.
 */
package com.google.storage.control.v2.stub;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.GaxProperties;
import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.api.gax.grpc.GaxGrpcProperties;
import com.google.api.gax.grpc.GrpcTransportChannel;
import com.google.api.gax.grpc.InstantiatingGrpcChannelProvider;
import com.google.api.gax.grpc.ProtoOperationTransformers;
import com.google.api.gax.longrunning.OperationTimedPollAlgorithm;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.retrying.TimedRetryAlgorithm;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.OperationCallSettings;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.PagedCallSettings;
import com.google.api.gax.rpc.PagedListDescriptor;
import com.google.api.gax.rpc.PagedListResponseFactory;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.longrunning.Operation;
import com.google.protobuf.Empty;
import com.google.storage.control.v2.CreateFolderRequest;
import com.google.storage.control.v2.DeleteFolderRequest;
import com.google.storage.control.v2.Folder;
import com.google.storage.control.v2.GetFolderRequest;
import com.google.storage.control.v2.GetStorageLayoutRequest;
import com.google.storage.control.v2.ListFoldersRequest;
import com.google.storage.control.v2.ListFoldersResponse;
import com.google.storage.control.v2.RenameFolderMetadata;
import com.google.storage.control.v2.RenameFolderRequest;
import com.google.storage.control.v2.StorageControlClient;
import com.google.storage.control.v2.StorageLayout;
import com.google.storage.control.v2.stub.GrpcStorageControlStub;
import com.google.storage.control.v2.stub.StorageControlStub;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.threeten.bp.Duration;

public class StorageControlStubSettings
extends StubSettings<StorageControlStubSettings> {
    private static final ImmutableList<String> DEFAULT_SERVICE_SCOPES = ImmutableList.builder().add((Object)"https://www.googleapis.com/auth/cloud-platform").add((Object)"https://www.googleapis.com/auth/cloud-platform.read-only").add((Object)"https://www.googleapis.com/auth/devstorage.full_control").add((Object)"https://www.googleapis.com/auth/devstorage.read_only").add((Object)"https://www.googleapis.com/auth/devstorage.read_write").build();
    private final UnaryCallSettings<CreateFolderRequest, Folder> createFolderSettings;
    private final UnaryCallSettings<DeleteFolderRequest, Empty> deleteFolderSettings;
    private final UnaryCallSettings<GetFolderRequest, Folder> getFolderSettings;
    private final PagedCallSettings<ListFoldersRequest, ListFoldersResponse, StorageControlClient.ListFoldersPagedResponse> listFoldersSettings;
    private final UnaryCallSettings<RenameFolderRequest, Operation> renameFolderSettings;
    private final OperationCallSettings<RenameFolderRequest, Folder, RenameFolderMetadata> renameFolderOperationSettings;
    private final UnaryCallSettings<GetStorageLayoutRequest, StorageLayout> getStorageLayoutSettings;
    private static final PagedListDescriptor<ListFoldersRequest, ListFoldersResponse, Folder> LIST_FOLDERS_PAGE_STR_DESC = new PagedListDescriptor<ListFoldersRequest, ListFoldersResponse, Folder>(){

        public String emptyToken() {
            return "";
        }

        public ListFoldersRequest injectToken(ListFoldersRequest payload, String token) {
            return ListFoldersRequest.newBuilder((ListFoldersRequest)payload).setPageToken(token).build();
        }

        public ListFoldersRequest injectPageSize(ListFoldersRequest payload, int pageSize) {
            return ListFoldersRequest.newBuilder((ListFoldersRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListFoldersRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListFoldersResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<Folder> extractResources(ListFoldersResponse payload) {
            return payload.getFoldersList() == null ? ImmutableList.of() : payload.getFoldersList();
        }
    };
    private static final PagedListResponseFactory<ListFoldersRequest, ListFoldersResponse, StorageControlClient.ListFoldersPagedResponse> LIST_FOLDERS_PAGE_STR_FACT = new PagedListResponseFactory<ListFoldersRequest, ListFoldersResponse, StorageControlClient.ListFoldersPagedResponse>(){

        public ApiFuture<StorageControlClient.ListFoldersPagedResponse> getFuturePagedResponse(UnaryCallable<ListFoldersRequest, ListFoldersResponse> callable, ListFoldersRequest request, ApiCallContext context, ApiFuture<ListFoldersResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_FOLDERS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return StorageControlClient.ListFoldersPagedResponse.createAsync((PageContext<ListFoldersRequest, ListFoldersResponse, Folder>)pageContext, futureResponse);
        }
    };

    public UnaryCallSettings<CreateFolderRequest, Folder> createFolderSettings() {
        return this.createFolderSettings;
    }

    public UnaryCallSettings<DeleteFolderRequest, Empty> deleteFolderSettings() {
        return this.deleteFolderSettings;
    }

    public UnaryCallSettings<GetFolderRequest, Folder> getFolderSettings() {
        return this.getFolderSettings;
    }

    public PagedCallSettings<ListFoldersRequest, ListFoldersResponse, StorageControlClient.ListFoldersPagedResponse> listFoldersSettings() {
        return this.listFoldersSettings;
    }

    public UnaryCallSettings<RenameFolderRequest, Operation> renameFolderSettings() {
        return this.renameFolderSettings;
    }

    public OperationCallSettings<RenameFolderRequest, Folder, RenameFolderMetadata> renameFolderOperationSettings() {
        return this.renameFolderOperationSettings;
    }

    public UnaryCallSettings<GetStorageLayoutRequest, StorageLayout> getStorageLayoutSettings() {
        return this.getStorageLayoutSettings;
    }

    public StorageControlStub createStub() throws IOException {
        if (this.getTransportChannelProvider().getTransportName().equals(GrpcTransportChannel.getGrpcTransportName())) {
            return GrpcStorageControlStub.create(this);
        }
        throw new UnsupportedOperationException(String.format("Transport not supported: %s", this.getTransportChannelProvider().getTransportName()));
    }

    public String getEndpoint() {
        if (super.getEndpoint() != null) {
            return super.getEndpoint();
        }
        return StorageControlStubSettings.getDefaultEndpoint();
    }

    public String getServiceName() {
        return "storage";
    }

    public static InstantiatingExecutorProvider.Builder defaultExecutorProviderBuilder() {
        return InstantiatingExecutorProvider.newBuilder();
    }

    public static String getDefaultEndpoint() {
        return "storage.googleapis.com:443";
    }

    public static String getDefaultMtlsEndpoint() {
        return "storage.mtls.googleapis.com:443";
    }

    public static List<String> getDefaultServiceScopes() {
        return DEFAULT_SERVICE_SCOPES;
    }

    public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
        return GoogleCredentialsProvider.newBuilder().setScopesToApply(DEFAULT_SERVICE_SCOPES).setUseJwtAccessWithScope(true);
    }

    public static InstantiatingGrpcChannelProvider.Builder defaultGrpcTransportProviderBuilder() {
        return InstantiatingGrpcChannelProvider.newBuilder().setMaxInboundMessageSize(Integer.valueOf(Integer.MAX_VALUE));
    }

    public static TransportChannelProvider defaultTransportChannelProvider() {
        return StorageControlStubSettings.defaultGrpcTransportProviderBuilder().build();
    }

    public static ApiClientHeaderProvider.Builder defaultApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(StorageControlStubSettings.class)).setTransportToken(GaxGrpcProperties.getGrpcTokenName(), GaxGrpcProperties.getGrpcVersion());
    }

    public static Builder newBuilder() {
        return Builder.createDefault();
    }

    public static Builder newBuilder(ClientContext clientContext) {
        return new Builder(clientContext);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    protected StorageControlStubSettings(Builder settingsBuilder) throws IOException {
        super((StubSettings.Builder)settingsBuilder);
        this.createFolderSettings = settingsBuilder.createFolderSettings().build();
        this.deleteFolderSettings = settingsBuilder.deleteFolderSettings().build();
        this.getFolderSettings = settingsBuilder.getFolderSettings().build();
        this.listFoldersSettings = settingsBuilder.listFoldersSettings().build();
        this.renameFolderSettings = settingsBuilder.renameFolderSettings().build();
        this.renameFolderOperationSettings = settingsBuilder.renameFolderOperationSettings().build();
        this.getStorageLayoutSettings = settingsBuilder.getStorageLayoutSettings().build();
    }

    public static class Builder
    extends StubSettings.Builder<StorageControlStubSettings, Builder> {
        private final ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders;
        private final UnaryCallSettings.Builder<CreateFolderRequest, Folder> createFolderSettings;
        private final UnaryCallSettings.Builder<DeleteFolderRequest, Empty> deleteFolderSettings;
        private final UnaryCallSettings.Builder<GetFolderRequest, Folder> getFolderSettings;
        private final PagedCallSettings.Builder<ListFoldersRequest, ListFoldersResponse, StorageControlClient.ListFoldersPagedResponse> listFoldersSettings;
        private final UnaryCallSettings.Builder<RenameFolderRequest, Operation> renameFolderSettings;
        private final OperationCallSettings.Builder<RenameFolderRequest, Folder, RenameFolderMetadata> renameFolderOperationSettings;
        private final UnaryCallSettings.Builder<GetStorageLayoutRequest, StorageLayout> getStorageLayoutSettings;
        private static final ImmutableMap<String, ImmutableSet<StatusCode.Code>> RETRYABLE_CODE_DEFINITIONS;
        private static final ImmutableMap<String, RetrySettings> RETRY_PARAM_DEFINITIONS;

        protected Builder() {
            this((ClientContext)null);
        }

        protected Builder(ClientContext clientContext) {
            super(clientContext);
            this.createFolderSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.deleteFolderSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.getFolderSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.listFoldersSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_FOLDERS_PAGE_STR_FACT);
            this.renameFolderSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.renameFolderOperationSettings = OperationCallSettings.newBuilder();
            this.getStorageLayoutSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.createFolderSettings, this.deleteFolderSettings, this.getFolderSettings, this.listFoldersSettings, this.renameFolderSettings, this.getStorageLayoutSettings);
            Builder.initDefaults(this);
        }

        protected Builder(StorageControlStubSettings settings) {
            super((StubSettings)settings);
            this.createFolderSettings = settings.createFolderSettings.toBuilder();
            this.deleteFolderSettings = settings.deleteFolderSettings.toBuilder();
            this.getFolderSettings = settings.getFolderSettings.toBuilder();
            this.listFoldersSettings = settings.listFoldersSettings.toBuilder();
            this.renameFolderSettings = settings.renameFolderSettings.toBuilder();
            this.renameFolderOperationSettings = settings.renameFolderOperationSettings.toBuilder();
            this.getStorageLayoutSettings = settings.getStorageLayoutSettings.toBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.createFolderSettings, this.deleteFolderSettings, this.getFolderSettings, this.listFoldersSettings, this.renameFolderSettings, this.getStorageLayoutSettings);
        }

        private static Builder createDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider(StorageControlStubSettings.defaultTransportChannelProvider());
            builder.setCredentialsProvider((CredentialsProvider)StorageControlStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)StorageControlStubSettings.defaultApiClientHeaderProviderBuilder().build());
            builder.setMtlsEndpoint(StorageControlStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder initDefaults(Builder builder) {
            builder.createFolderSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.deleteFolderSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.getFolderSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.listFoldersSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.renameFolderSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.getStorageLayoutSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.renameFolderOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Folder.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(RenameFolderMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            return builder;
        }

        public Builder applyToAllUnaryMethods(ApiFunction<UnaryCallSettings.Builder<?, ?>, Void> settingsUpdater) {
            StubSettings.Builder.applyToAllUnaryMethods(this.unaryMethodSettingsBuilders, settingsUpdater);
            return this;
        }

        public ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders() {
            return this.unaryMethodSettingsBuilders;
        }

        public UnaryCallSettings.Builder<CreateFolderRequest, Folder> createFolderSettings() {
            return this.createFolderSettings;
        }

        public UnaryCallSettings.Builder<DeleteFolderRequest, Empty> deleteFolderSettings() {
            return this.deleteFolderSettings;
        }

        public UnaryCallSettings.Builder<GetFolderRequest, Folder> getFolderSettings() {
            return this.getFolderSettings;
        }

        public PagedCallSettings.Builder<ListFoldersRequest, ListFoldersResponse, StorageControlClient.ListFoldersPagedResponse> listFoldersSettings() {
            return this.listFoldersSettings;
        }

        public UnaryCallSettings.Builder<RenameFolderRequest, Operation> renameFolderSettings() {
            return this.renameFolderSettings;
        }

        @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
        public OperationCallSettings.Builder<RenameFolderRequest, Folder, RenameFolderMetadata> renameFolderOperationSettings() {
            return this.renameFolderOperationSettings;
        }

        public UnaryCallSettings.Builder<GetStorageLayoutRequest, StorageLayout> getStorageLayoutSettings() {
            return this.getStorageLayoutSettings;
        }

        public String getEndpoint() {
            if (super.getEndpoint() != null) {
                return super.getEndpoint();
            }
            return StorageControlStubSettings.getDefaultEndpoint();
        }

        public StorageControlStubSettings build() throws IOException {
            return new StorageControlStubSettings(this);
        }

        static {
            ImmutableMap.Builder definitions = ImmutableMap.builder();
            definitions.put((Object)"no_retry_1_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList()));
            definitions.put((Object)"retry_policy_0_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList((Object[])new StatusCode.Code[]{StatusCode.Code.RESOURCE_EXHAUSTED, StatusCode.Code.UNAVAILABLE, StatusCode.Code.DEADLINE_EXCEEDED, StatusCode.Code.INTERNAL, StatusCode.Code.UNKNOWN})));
            RETRYABLE_CODE_DEFINITIONS = definitions.build();
            definitions = ImmutableMap.builder();
            RetrySettings settings = null;
            settings = RetrySettings.newBuilder().setInitialRpcTimeout(Duration.ofMillis((long)60000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ofMillis((long)60000L)).setTotalTimeout(Duration.ofMillis((long)60000L)).build();
            definitions.put((Object)"no_retry_1_params", (Object)settings);
            settings = RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)1000L)).setRetryDelayMultiplier(2.0).setMaxRetryDelay(Duration.ofMillis((long)60000L)).setInitialRpcTimeout(Duration.ofMillis((long)60000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ofMillis((long)60000L)).setTotalTimeout(Duration.ofMillis((long)60000L)).build();
            definitions.put((Object)"retry_policy_0_params", (Object)settings);
            RETRY_PARAM_DEFINITIONS = definitions.build();
        }
    }
}

