/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.speech.v1beta1;

import com.google.api.core.BetaApi;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.api.gax.core.PropertiesProvider;
import com.google.api.gax.grpc.ChannelProvider;
import com.google.api.gax.grpc.ClientSettings;
import com.google.api.gax.grpc.ExecutorProvider;
import com.google.api.gax.grpc.InstantiatingChannelProvider;
import com.google.api.gax.grpc.InstantiatingExecutorProvider;
import com.google.api.gax.grpc.OperationCallSettings;
import com.google.api.gax.grpc.OperationTimedPollAlgorithm;
import com.google.api.gax.grpc.SimpleCallSettings;
import com.google.api.gax.grpc.StreamingCallSettings;
import com.google.api.gax.grpc.UnaryCallSettings;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.retrying.TimedRetryAlgorithm;
import com.google.cloud.speech.v1beta1.AsyncRecognizeMetadata;
import com.google.cloud.speech.v1beta1.AsyncRecognizeRequest;
import com.google.cloud.speech.v1beta1.AsyncRecognizeResponse;
import com.google.cloud.speech.v1beta1.StreamingRecognizeRequest;
import com.google.cloud.speech.v1beta1.StreamingRecognizeResponse;
import com.google.cloud.speech.v1beta1.SyncRecognizeRequest;
import com.google.cloud.speech.v1beta1.SyncRecognizeResponse;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.longrunning.Operation;
import com.google.protobuf.Message;
import io.grpc.MethodDescriptor;
import io.grpc.Status;
import io.grpc.protobuf.ProtoUtils;
import java.io.IOException;
import java.util.List;
import java.util.Set;
import org.threeten.bp.Duration;

@BetaApi
public class SpeechSettings
extends ClientSettings {
    private static final ImmutableList<String> DEFAULT_SERVICE_SCOPES = ImmutableList.builder().add((Object)"https://www.googleapis.com/auth/cloud-platform").build();
    private static final String DEFAULT_GAPIC_NAME = "gapic";
    private static final String DEFAULT_GAPIC_VERSION = "";
    private static final String PROPERTIES_FILE = "/com/google/cloud/speech/project.properties";
    private static final String META_VERSION_KEY = "artifact.version";
    private static String gapicVersion;
    private static final MethodDescriptor<SyncRecognizeRequest, SyncRecognizeResponse> METHOD_SYNC_RECOGNIZE;
    private static final MethodDescriptor<AsyncRecognizeRequest, Operation> METHOD_ASYNC_RECOGNIZE;
    private static final MethodDescriptor<StreamingRecognizeRequest, StreamingRecognizeResponse> METHOD_STREAMING_RECOGNIZE;
    private final SimpleCallSettings<SyncRecognizeRequest, SyncRecognizeResponse> syncRecognizeSettings;
    private final OperationCallSettings<AsyncRecognizeRequest, AsyncRecognizeResponse, AsyncRecognizeMetadata> asyncRecognizeSettings;
    private final StreamingCallSettings<StreamingRecognizeRequest, StreamingRecognizeResponse> streamingRecognizeSettings;

    public SimpleCallSettings<SyncRecognizeRequest, SyncRecognizeResponse> syncRecognizeSettings() {
        return this.syncRecognizeSettings;
    }

    public OperationCallSettings<AsyncRecognizeRequest, AsyncRecognizeResponse, AsyncRecognizeMetadata> asyncRecognizeSettings() {
        return this.asyncRecognizeSettings;
    }

    public StreamingCallSettings<StreamingRecognizeRequest, StreamingRecognizeResponse> streamingRecognizeSettings() {
        return this.streamingRecognizeSettings;
    }

    public static InstantiatingExecutorProvider.Builder defaultExecutorProviderBuilder() {
        return InstantiatingExecutorProvider.newBuilder();
    }

    public static String getDefaultEndpoint() {
        return "speech.googleapis.com:443";
    }

    public static List<String> getDefaultServiceScopes() {
        return DEFAULT_SERVICE_SCOPES;
    }

    public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
        return GoogleCredentialsProvider.newBuilder().setScopesToApply(DEFAULT_SERVICE_SCOPES);
    }

    public static InstantiatingChannelProvider.Builder defaultChannelProviderBuilder() {
        return InstantiatingChannelProvider.newBuilder().setEndpoint(SpeechSettings.getDefaultEndpoint()).setGeneratorHeader(DEFAULT_GAPIC_NAME, SpeechSettings.getGapicVersion());
    }

    private static String getGapicVersion() {
        if (gapicVersion == null) {
            gapicVersion = PropertiesProvider.loadProperty(SpeechSettings.class, (String)PROPERTIES_FILE, (String)META_VERSION_KEY);
            gapicVersion = gapicVersion == null ? DEFAULT_GAPIC_VERSION : gapicVersion;
        }
        return gapicVersion;
    }

    public static Builder defaultBuilder() {
        return Builder.createDefault();
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    private SpeechSettings(Builder settingsBuilder) throws IOException {
        super(settingsBuilder.getExecutorProvider(), settingsBuilder.getChannelProvider(), settingsBuilder.getCredentialsProvider());
        this.syncRecognizeSettings = settingsBuilder.syncRecognizeSettings().build();
        this.asyncRecognizeSettings = settingsBuilder.asyncRecognizeSettings().build();
        this.streamingRecognizeSettings = settingsBuilder.streamingRecognizeSettings().build();
    }

    static {
        METHOD_SYNC_RECOGNIZE = MethodDescriptor.create((MethodDescriptor.MethodType)MethodDescriptor.MethodType.UNARY, (String)"google.cloud.speech.v1beta1.Speech/SyncRecognize", (MethodDescriptor.Marshaller)ProtoUtils.marshaller((Message)SyncRecognizeRequest.getDefaultInstance()), (MethodDescriptor.Marshaller)ProtoUtils.marshaller((Message)SyncRecognizeResponse.getDefaultInstance()));
        METHOD_ASYNC_RECOGNIZE = MethodDescriptor.create((MethodDescriptor.MethodType)MethodDescriptor.MethodType.UNARY, (String)"google.cloud.speech.v1beta1.Speech/AsyncRecognize", (MethodDescriptor.Marshaller)ProtoUtils.marshaller((Message)AsyncRecognizeRequest.getDefaultInstance()), (MethodDescriptor.Marshaller)ProtoUtils.marshaller((Message)Operation.getDefaultInstance()));
        METHOD_STREAMING_RECOGNIZE = MethodDescriptor.create((MethodDescriptor.MethodType)MethodDescriptor.MethodType.BIDI_STREAMING, (String)"google.cloud.speech.v1beta1.Speech/StreamingRecognize", (MethodDescriptor.Marshaller)ProtoUtils.marshaller((Message)StreamingRecognizeRequest.getDefaultInstance()), (MethodDescriptor.Marshaller)ProtoUtils.marshaller((Message)StreamingRecognizeResponse.getDefaultInstance()));
    }

    public static class Builder
    extends ClientSettings.Builder {
        private final ImmutableList<UnaryCallSettings.Builder> unaryMethodSettingsBuilders;
        private final SimpleCallSettings.Builder<SyncRecognizeRequest, SyncRecognizeResponse> syncRecognizeSettings;
        private final OperationCallSettings.Builder<AsyncRecognizeRequest, AsyncRecognizeResponse, AsyncRecognizeMetadata> asyncRecognizeSettings;
        private final StreamingCallSettings.Builder<StreamingRecognizeRequest, StreamingRecognizeResponse> streamingRecognizeSettings;
        private static final ImmutableMap<String, ImmutableSet<Status.Code>> RETRYABLE_CODE_DEFINITIONS;
        private static final ImmutableMap<String, RetrySettings.Builder> RETRY_PARAM_DEFINITIONS;

        private Builder() {
            super(SpeechSettings.defaultChannelProviderBuilder().build());
            this.setCredentialsProvider((CredentialsProvider)SpeechSettings.defaultCredentialsProviderBuilder().build());
            this.syncRecognizeSettings = SimpleCallSettings.newBuilder((MethodDescriptor)METHOD_SYNC_RECOGNIZE);
            this.asyncRecognizeSettings = OperationCallSettings.newBuilder();
            this.streamingRecognizeSettings = StreamingCallSettings.newBuilder((MethodDescriptor)METHOD_STREAMING_RECOGNIZE);
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.syncRecognizeSettings);
        }

        private static Builder createDefault() {
            Builder builder = new Builder();
            builder.syncRecognizeSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"idempotent")).setRetrySettingsBuilder((RetrySettings.Builder)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.asyncRecognizeSettings().setInitialCallSettings(SimpleCallSettings.newBuilder((MethodDescriptor)METHOD_ASYNC_RECOGNIZE).setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"idempotent")).setRetrySettingsBuilder((RetrySettings.Builder)RETRY_PARAM_DEFINITIONS.get((Object)"default")).build()).setResponseClass(AsyncRecognizeResponse.class).setMetadataClass(AsyncRecognizeMetadata.class).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)20000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)86400000L)).build()));
            return builder;
        }

        private Builder(SpeechSettings settings) {
            super((ClientSettings)settings);
            this.syncRecognizeSettings = settings.syncRecognizeSettings.toBuilder();
            this.asyncRecognizeSettings = settings.asyncRecognizeSettings.toBuilder();
            this.streamingRecognizeSettings = settings.streamingRecognizeSettings.toBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.syncRecognizeSettings);
        }

        public Builder setExecutorProvider(ExecutorProvider executorProvider) {
            super.setExecutorProvider(executorProvider);
            return this;
        }

        public Builder setChannelProvider(ChannelProvider channelProvider) {
            super.setChannelProvider(channelProvider);
            return this;
        }

        public Builder setCredentialsProvider(CredentialsProvider credentialsProvider) {
            super.setCredentialsProvider(credentialsProvider);
            return this;
        }

        public Builder applyToAllUnaryMethods(UnaryCallSettings.Builder unaryCallSettings) throws Exception {
            super.applyToAllUnaryMethods(this.unaryMethodSettingsBuilders, unaryCallSettings);
            return this;
        }

        public SimpleCallSettings.Builder<SyncRecognizeRequest, SyncRecognizeResponse> syncRecognizeSettings() {
            return this.syncRecognizeSettings;
        }

        public OperationCallSettings.Builder<AsyncRecognizeRequest, AsyncRecognizeResponse, AsyncRecognizeMetadata> asyncRecognizeSettings() {
            return this.asyncRecognizeSettings;
        }

        public StreamingCallSettings.Builder<StreamingRecognizeRequest, StreamingRecognizeResponse> streamingRecognizeSettings() {
            return this.streamingRecognizeSettings;
        }

        public SpeechSettings build() throws IOException {
            return new SpeechSettings(this);
        }

        static {
            ImmutableMap.Builder definitions = ImmutableMap.builder();
            definitions.put((Object)"idempotent", (Object)Sets.immutableEnumSet((Iterable)Lists.newArrayList((Object[])new Status.Code[]{Status.Code.DEADLINE_EXCEEDED, Status.Code.UNAVAILABLE})));
            definitions.put((Object)"non_idempotent", (Object)Sets.immutableEnumSet((Iterable)Lists.newArrayList()));
            RETRYABLE_CODE_DEFINITIONS = definitions.build();
            definitions = ImmutableMap.builder();
            RetrySettings.Builder settingsBuilder = null;
            settingsBuilder = RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)100L)).setRetryDelayMultiplier(1.3).setMaxRetryDelay(Duration.ofMillis((long)60000L)).setInitialRpcTimeout(Duration.ofMillis((long)190000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ofMillis((long)190000L)).setTotalTimeout(Duration.ofMillis((long)600000L));
            definitions.put((Object)"default", (Object)settingsBuilder);
            RETRY_PARAM_DEFINITIONS = definitions.build();
        }
    }
}

