/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.speech.v1;

import com.google.api.core.BetaApi;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.FixedCredentialsProvider;
import com.google.api.gax.grpc.ChannelAndExecutor;
import com.google.api.gax.grpc.ChannelProvider;
import com.google.api.gax.grpc.ClientContext;
import com.google.api.gax.grpc.ExecutorProvider;
import com.google.api.gax.grpc.FixedChannelProvider;
import com.google.api.gax.grpc.FixedExecutorProvider;
import com.google.api.gax.grpc.OperationCallable;
import com.google.api.gax.grpc.OperationFuture;
import com.google.api.gax.grpc.SimpleCallSettings;
import com.google.api.gax.grpc.StreamingCallable;
import com.google.api.gax.grpc.UnaryCallable;
import com.google.auth.Credentials;
import com.google.cloud.speech.v1.LongRunningRecognizeRequest;
import com.google.cloud.speech.v1.LongRunningRecognizeResponse;
import com.google.cloud.speech.v1.RecognitionAudio;
import com.google.cloud.speech.v1.RecognitionConfig;
import com.google.cloud.speech.v1.RecognizeRequest;
import com.google.cloud.speech.v1.RecognizeResponse;
import com.google.cloud.speech.v1.SpeechSettings;
import com.google.cloud.speech.v1.StreamingRecognizeRequest;
import com.google.cloud.speech.v1.StreamingRecognizeResponse;
import com.google.longrunning.Operation;
import com.google.longrunning.OperationsClient;
import com.google.longrunning.OperationsSettings;
import io.grpc.Channel;
import io.grpc.ManagedChannel;
import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ScheduledExecutorService;

@BetaApi
public class SpeechClient
implements AutoCloseable {
    private final SpeechSettings settings;
    private final ScheduledExecutorService executor;
    private final ManagedChannel channel;
    private final OperationsClient operationsClient;
    private final List<AutoCloseable> closeables = new ArrayList<AutoCloseable>();
    private final UnaryCallable<RecognizeRequest, RecognizeResponse> recognizeCallable;
    private final UnaryCallable<LongRunningRecognizeRequest, Operation> longRunningRecognizeCallable;
    private final OperationCallable<LongRunningRecognizeRequest, LongRunningRecognizeResponse> longRunningRecognizeOperationCallable;
    private final StreamingCallable<StreamingRecognizeRequest, StreamingRecognizeResponse> streamingRecognizeCallable;

    public static final SpeechClient create() throws IOException {
        return SpeechClient.create(SpeechSettings.defaultBuilder().build());
    }

    public static final SpeechClient create(SpeechSettings settings) throws IOException {
        return new SpeechClient(settings);
    }

    protected SpeechClient(SpeechSettings settings) throws IOException {
        this.settings = settings;
        ChannelAndExecutor channelAndExecutor = settings.getChannelAndExecutor();
        this.executor = channelAndExecutor.getExecutor();
        this.channel = channelAndExecutor.getChannel();
        Credentials credentials = settings.getCredentialsProvider().getCredentials();
        ClientContext clientContext = ClientContext.newBuilder().setExecutor(this.executor).setChannel((Channel)this.channel).setCredentials(credentials).build();
        OperationsSettings operationsSettings = OperationsSettings.defaultBuilder().setExecutorProvider((ExecutorProvider)FixedExecutorProvider.create((ScheduledExecutorService)this.executor)).setChannelProvider((ChannelProvider)FixedChannelProvider.create((ManagedChannel)this.channel)).setCredentialsProvider((CredentialsProvider)FixedCredentialsProvider.create((Credentials)credentials)).build();
        this.operationsClient = OperationsClient.create((OperationsSettings)operationsSettings);
        this.recognizeCallable = UnaryCallable.create(settings.recognizeSettings(), (ClientContext)clientContext);
        this.longRunningRecognizeCallable = UnaryCallable.create((SimpleCallSettings)settings.longRunningRecognizeSettings().getInitialCallSettings(), (ClientContext)clientContext);
        this.longRunningRecognizeOperationCallable = OperationCallable.create(settings.longRunningRecognizeSettings(), (ClientContext)clientContext, (OperationsClient)this.operationsClient);
        this.streamingRecognizeCallable = StreamingCallable.create(settings.streamingRecognizeSettings(), (ClientContext)clientContext);
        if (settings.getChannelProvider().shouldAutoClose()) {
            this.closeables.add(new Closeable(){

                @Override
                public void close() throws IOException {
                    SpeechClient.this.channel.shutdown();
                }
            });
        }
        if (settings.getExecutorProvider().shouldAutoClose()) {
            this.closeables.add(new Closeable(){

                @Override
                public void close() throws IOException {
                    SpeechClient.this.executor.shutdown();
                }
            });
        }
    }

    public final SpeechSettings getSettings() {
        return this.settings;
    }

    public final OperationsClient getOperationsClient() {
        return this.operationsClient;
    }

    public final RecognizeResponse recognize(RecognitionConfig config, RecognitionAudio audio) {
        RecognizeRequest request = RecognizeRequest.newBuilder().setConfig(config).setAudio(audio).build();
        return this.recognize(request);
    }

    public final RecognizeResponse recognize(RecognizeRequest request) {
        return (RecognizeResponse)this.recognizeCallable().call((Object)request);
    }

    public final UnaryCallable<RecognizeRequest, RecognizeResponse> recognizeCallable() {
        return this.recognizeCallable;
    }

    public final OperationFuture<LongRunningRecognizeResponse> longRunningRecognizeAsync(RecognitionConfig config, RecognitionAudio audio) {
        LongRunningRecognizeRequest request = LongRunningRecognizeRequest.newBuilder().setConfig(config).setAudio(audio).build();
        return this.longRunningRecognizeAsync(request);
    }

    public final OperationFuture<LongRunningRecognizeResponse> longRunningRecognizeAsync(LongRunningRecognizeRequest request) {
        return this.longRunningRecognizeOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<LongRunningRecognizeRequest, LongRunningRecognizeResponse> longRunningRecognizeOperationCallable() {
        return this.longRunningRecognizeOperationCallable;
    }

    public final UnaryCallable<LongRunningRecognizeRequest, Operation> longRunningRecognizeCallable() {
        return this.longRunningRecognizeCallable;
    }

    public final StreamingCallable<StreamingRecognizeRequest, StreamingRecognizeResponse> streamingRecognizeCallable() {
        return this.streamingRecognizeCallable;
    }

    @Override
    public final void close() throws Exception {
        for (AutoCloseable closeable : this.closeables) {
            closeable.close();
        }
    }
}

