/*
 * Decompiled with CFR 0.152.
 */
package com.google.spanner.adapter.v1.stub;

import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.core.BackgroundResourceAggregation;
import com.google.api.gax.grpc.GrpcCallSettings;
import com.google.api.gax.grpc.GrpcStubCallableFactory;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.RequestParamsBuilder;
import com.google.api.gax.rpc.ServerStreamingCallable;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.longrunning.stub.GrpcOperationsStub;
import com.google.protobuf.Message;
import com.google.spanner.adapter.v1.AdaptMessageRequest;
import com.google.spanner.adapter.v1.AdaptMessageResponse;
import com.google.spanner.adapter.v1.CreateSessionRequest;
import com.google.spanner.adapter.v1.Session;
import com.google.spanner.adapter.v1.stub.AdapterStub;
import com.google.spanner.adapter.v1.stub.AdapterStubSettings;
import com.google.spanner.adapter.v1.stub.GrpcAdapterCallableFactory;
import io.grpc.MethodDescriptor;
import io.grpc.protobuf.ProtoUtils;
import java.io.IOException;
import java.util.concurrent.TimeUnit;

public class GrpcAdapterStub
extends AdapterStub {
    private static final MethodDescriptor<CreateSessionRequest, Session> createSessionMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.spanner.adapter.v1.Adapter/CreateSession").setRequestMarshaller(ProtoUtils.marshaller((Message)CreateSessionRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Session.getDefaultInstance())).build();
    private static final MethodDescriptor<AdaptMessageRequest, AdaptMessageResponse> adaptMessageMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.SERVER_STREAMING).setFullMethodName("google.spanner.adapter.v1.Adapter/AdaptMessage").setRequestMarshaller(ProtoUtils.marshaller((Message)AdaptMessageRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)AdaptMessageResponse.getDefaultInstance())).build();
    private final UnaryCallable<CreateSessionRequest, Session> createSessionCallable;
    private final ServerStreamingCallable<AdaptMessageRequest, AdaptMessageResponse> adaptMessageCallable;
    private final BackgroundResource backgroundResources;
    private final GrpcOperationsStub operationsStub;
    private final GrpcStubCallableFactory callableFactory;

    public static final GrpcAdapterStub create(AdapterStubSettings settings) throws IOException {
        return new GrpcAdapterStub(settings, ClientContext.create((StubSettings)settings));
    }

    public static final GrpcAdapterStub create(ClientContext clientContext) throws IOException {
        return new GrpcAdapterStub(AdapterStubSettings.newBuilder().build(), clientContext);
    }

    public static final GrpcAdapterStub create(ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        return new GrpcAdapterStub(AdapterStubSettings.newBuilder().build(), clientContext, callableFactory);
    }

    protected GrpcAdapterStub(AdapterStubSettings settings, ClientContext clientContext) throws IOException {
        this(settings, clientContext, new GrpcAdapterCallableFactory());
    }

    protected GrpcAdapterStub(AdapterStubSettings settings, ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        this.callableFactory = callableFactory;
        this.operationsStub = GrpcOperationsStub.create((ClientContext)clientContext, (GrpcStubCallableFactory)callableFactory);
        GrpcCallSettings createSessionTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(createSessionMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parent", String.valueOf(request.getParent()));
            return builder.build();
        }).build();
        GrpcCallSettings adaptMessageTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(adaptMessageMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        this.createSessionCallable = callableFactory.createUnaryCallable(createSessionTransportSettings, settings.createSessionSettings(), clientContext);
        this.adaptMessageCallable = callableFactory.createServerStreamingCallable(adaptMessageTransportSettings, settings.adaptMessageSettings(), clientContext);
        this.backgroundResources = new BackgroundResourceAggregation(clientContext.getBackgroundResources());
    }

    public GrpcOperationsStub getOperationsStub() {
        return this.operationsStub;
    }

    @Override
    public UnaryCallable<CreateSessionRequest, Session> createSessionCallable() {
        return this.createSessionCallable;
    }

    @Override
    public ServerStreamingCallable<AdaptMessageRequest, AdaptMessageResponse> adaptMessageCallable() {
        return this.adaptMessageCallable;
    }

    @Override
    public final void close() {
        try {
            this.backgroundResources.close();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to close resource", e);
        }
    }

    public void shutdown() {
        this.backgroundResources.shutdown();
    }

    public boolean isShutdown() {
        return this.backgroundResources.isShutdown();
    }

    public boolean isTerminated() {
        return this.backgroundResources.isTerminated();
    }

    public void shutdownNow() {
        this.backgroundResources.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.backgroundResources.awaitTermination(duration, unit);
    }
}

