/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner.spi.v1;

import com.google.api.gax.grpc.GrpcCallContext;
import com.google.api.gax.tracing.ApiTracer;
import com.google.cloud.spanner.BuiltInMetricsConstant;
import com.google.cloud.spanner.CompositeTracer;
import com.google.cloud.spanner.SpannerExceptionFactory;
import com.google.cloud.spanner.SpannerRpcMetrics;
import com.google.cloud.spanner.spi.v1.GapicSpannerRpc;
import com.google.cloud.spanner.spi.v1.SpannerRpcViews;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.spanner.admin.database.v1.DatabaseName;
import io.grpc.CallOptions;
import io.grpc.Channel;
import io.grpc.ClientCall;
import io.grpc.ClientInterceptor;
import io.grpc.ForwardingClientCall;
import io.grpc.ForwardingClientCallListener;
import io.grpc.Grpc;
import io.grpc.Metadata;
import io.grpc.MethodDescriptor;
import io.opencensus.stats.MeasureMap;
import io.opencensus.stats.Stats;
import io.opencensus.stats.StatsRecorder;
import io.opencensus.tags.TagContext;
import io.opencensus.tags.TagValue;
import io.opencensus.tags.Tagger;
import io.opencensus.tags.Tags;
import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.api.common.AttributesBuilder;
import io.opentelemetry.api.trace.Span;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

class HeaderInterceptor
implements ClientInterceptor {
    private static final DatabaseName UNDEFINED_DATABASE_NAME = DatabaseName.of((String)"undefined-project", (String)"undefined-instance", (String)"undefined-database");
    private static final Metadata.Key<String> SERVER_TIMING_HEADER_KEY = Metadata.Key.of((String)"server-timing", (Metadata.AsciiMarshaller)Metadata.ASCII_STRING_MARSHALLER);
    private static final String GFE_TIMING_HEADER = "gfet4t7";
    private static final String AFE_TIMING_HEADER = "afe";
    private static final Metadata.Key<String> GOOGLE_CLOUD_RESOURCE_PREFIX_KEY = Metadata.Key.of((String)"google-cloud-resource-prefix", (Metadata.AsciiMarshaller)Metadata.ASCII_STRING_MARSHALLER);
    private static final Pattern SERVER_TIMING_PATTERN = Pattern.compile("(?<metricName>[a-zA-Z0-9_-]+);\\s*dur=(?<duration>\\d+(\\.\\d+)?)");
    private static final Pattern GOOGLE_CLOUD_RESOURCE_PREFIX_PATTERN = Pattern.compile(".*projects/(?<project>\\p{ASCII}[^/]*)(/instances/(?<instance>\\p{ASCII}[^/]*))?(/databases/(?<database>\\p{ASCII}[^/]*))?");
    private final Cache<String, DatabaseName> databaseNameCache = CacheBuilder.newBuilder().maximumSize(100L).build();
    private final Cache<String, TagContext> tagsCache = CacheBuilder.newBuilder().maximumSize(1000L).build();
    private final Cache<String, Attributes> attributesCache = CacheBuilder.newBuilder().maximumSize(1000L).build();
    private final Cache<String, Map<String, String>> builtInAttributesCache = CacheBuilder.newBuilder().maximumSize(1000L).build();
    private final Cache<DatabaseName, Cache<String, String>> keyCache = CacheBuilder.newBuilder().maximumSize(1000L).build();
    private static final Tagger TAGGER = Tags.getTagger();
    private static final StatsRecorder STATS_RECORDER = Stats.getStatsRecorder();
    private static final Logger LOGGER = Logger.getLogger(HeaderInterceptor.class.getName());
    private static final Level LEVEL = Level.INFO;
    private final SpannerRpcMetrics spannerRpcMetrics;
    private final Supplier<Boolean> directPathEnabledSupplier;

    HeaderInterceptor(SpannerRpcMetrics spannerRpcMetrics, Supplier<Boolean> directPathEnabledSupplier) {
        this.spannerRpcMetrics = spannerRpcMetrics;
        this.directPathEnabledSupplier = directPathEnabledSupplier;
    }

    public <ReqT, RespT> ClientCall<ReqT, RespT> interceptCall(final MethodDescriptor<ReqT, RespT> method, CallOptions callOptions, Channel next) {
        ApiTracer tracer = (ApiTracer)callOptions.getOption(GrpcCallContext.TRACER_KEY);
        final CompositeTracer compositeTracer = tracer instanceof CompositeTracer ? (CompositeTracer)tracer : null;
        return new ForwardingClientCall.SimpleForwardingClientCall<ReqT, RespT>(next.newCall(method, callOptions)){

            public void start(ClientCall.Listener<RespT> responseListener, Metadata headers) {
                try {
                    final Span span = Span.current();
                    DatabaseName databaseName = HeaderInterceptor.this.extractDatabaseName(headers);
                    String key = HeaderInterceptor.this.extractKey(databaseName, method.getFullMethodName());
                    final TagContext tagContext = HeaderInterceptor.this.getTagContext(key, method.getFullMethodName(), databaseName);
                    final Attributes attributes = HeaderInterceptor.this.getMetricAttributes(key, method.getFullMethodName(), databaseName);
                    Map builtInMetricsAttributes = HeaderInterceptor.this.getBuiltInMetricAttributes(key, databaseName);
                    HeaderInterceptor.this.addBuiltInMetricAttributes(compositeTracer, builtInMetricsAttributes);
                    super.start((ClientCall.Listener)new ForwardingClientCallListener.SimpleForwardingClientCallListener<RespT>(responseListener){

                        public void onHeaders(Metadata metadata) {
                            Boolean isDirectPathUsed = HeaderInterceptor.this.isDirectPathUsed((SocketAddress)this.getAttributes().get(Grpc.TRANSPORT_ATTR_REMOTE_ADDR));
                            HeaderInterceptor.this.addDirectPathUsedAttribute(compositeTracer, isDirectPathUsed);
                            HeaderInterceptor.this.processHeader(metadata, tagContext, attributes, span, compositeTracer, isDirectPathUsed);
                            super.onHeaders(metadata);
                        }
                    }, headers);
                }
                catch (ExecutionException executionException) {
                    throw SpannerExceptionFactory.asSpannerException(executionException.getCause());
                }
            }
        };
    }

    private void processHeader(Metadata metadata, TagContext tagContext, Attributes attributes, Span span, CompositeTracer compositeTracer, boolean isDirectPathUsed) {
        MeasureMap measureMap = STATS_RECORDER.newMeasureMap();
        String serverTiming = (String)metadata.get(SERVER_TIMING_HEADER_KEY);
        try {
            Map<String, Float> serverTimingMetrics = this.parseServerTimingHeader(serverTiming);
            if (serverTimingMetrics.containsKey(GFE_TIMING_HEADER)) {
                float gfeLatency = serverTimingMetrics.get(GFE_TIMING_HEADER).floatValue();
                measureMap.put(SpannerRpcViews.SPANNER_GFE_LATENCY, (long)gfeLatency);
                measureMap.put(SpannerRpcViews.SPANNER_GFE_HEADER_MISSING_COUNT, 0L);
                measureMap.record(tagContext);
                this.spannerRpcMetrics.recordGfeLatency((long)gfeLatency, attributes);
                this.spannerRpcMetrics.recordGfeHeaderMissingCount(0L, attributes);
                if (compositeTracer != null && !isDirectPathUsed) {
                    compositeTracer.recordGFELatency(Float.valueOf(gfeLatency));
                }
                if (span != null) {
                    span.setAttribute("gfe_latency", String.valueOf(gfeLatency));
                }
            } else {
                measureMap.put(SpannerRpcViews.SPANNER_GFE_HEADER_MISSING_COUNT, 1L).record(tagContext);
                this.spannerRpcMetrics.recordGfeHeaderMissingCount(1L, attributes);
                if (compositeTracer != null && !isDirectPathUsed) {
                    compositeTracer.recordGfeHeaderMissingCount(1L);
                }
            }
            if (compositeTracer != null && GapicSpannerRpc.isEnableAFEServerTiming()) {
                if (serverTimingMetrics.containsKey(AFE_TIMING_HEADER)) {
                    float afeLatency = serverTimingMetrics.get(AFE_TIMING_HEADER).floatValue();
                    compositeTracer.recordAFELatency(Float.valueOf(afeLatency));
                } else {
                    compositeTracer.recordAfeHeaderMissingCount(1L);
                }
            }
        }
        catch (NumberFormatException e) {
            LOGGER.log(LEVEL, "Invalid server-timing object in header: {}", serverTiming);
        }
    }

    private Map<String, Float> parseServerTimingHeader(String serverTiming) {
        HashMap<String, Float> serverTimingMetrics = new HashMap<String, Float>();
        if (serverTiming != null) {
            Matcher matcher = SERVER_TIMING_PATTERN.matcher(serverTiming);
            while (matcher.find()) {
                String metricName = matcher.group("metricName");
                String durationStr = matcher.group("duration");
                if (metricName == null || durationStr == null) continue;
                serverTimingMetrics.put(metricName, Float.valueOf(durationStr));
            }
        }
        return serverTimingMetrics;
    }

    private String extractKey(DatabaseName databaseName, String methodName) throws ExecutionException {
        Cache keys = (Cache)this.keyCache.get((Object)databaseName, () -> CacheBuilder.newBuilder().maximumSize(1000L).build());
        return (String)keys.get((Object)methodName, () -> databaseName + methodName);
    }

    private DatabaseName extractDatabaseName(Metadata headers) throws ExecutionException {
        String googleResourcePrefix = (String)headers.get(GOOGLE_CLOUD_RESOURCE_PREFIX_KEY);
        if (googleResourcePrefix != null) {
            return (DatabaseName)this.databaseNameCache.get((Object)googleResourcePrefix, () -> {
                String projectId = "undefined-project";
                String instanceId = "undefined-database";
                String databaseId = "undefined-database";
                Matcher matcher = GOOGLE_CLOUD_RESOURCE_PREFIX_PATTERN.matcher(googleResourcePrefix);
                if (matcher.find()) {
                    projectId = matcher.group("project");
                    if (matcher.group("instance") != null) {
                        instanceId = matcher.group("instance");
                    }
                    if (matcher.group("database") != null) {
                        databaseId = matcher.group("database");
                    }
                } else {
                    LOGGER.log(LEVEL, "Error parsing google cloud resource header: " + googleResourcePrefix);
                }
                return DatabaseName.of((String)projectId, (String)instanceId, (String)databaseId);
            });
        }
        return UNDEFINED_DATABASE_NAME;
    }

    private TagContext getTagContext(String key, String method, DatabaseName databaseName) throws ExecutionException {
        return (TagContext)this.tagsCache.get((Object)key, () -> TAGGER.currentBuilder().putLocal(SpannerRpcViews.PROJECT_ID, TagValue.create((String)databaseName.getProject())).putLocal(SpannerRpcViews.INSTANCE_ID, TagValue.create((String)databaseName.getInstance())).putLocal(SpannerRpcViews.DATABASE_ID, TagValue.create((String)databaseName.getDatabase())).putLocal(SpannerRpcViews.METHOD, TagValue.create((String)method)).build());
    }

    private Attributes getMetricAttributes(String key, String method, DatabaseName databaseName) throws ExecutionException {
        return (Attributes)this.attributesCache.get((Object)key, () -> {
            AttributesBuilder attributesBuilder = Attributes.builder();
            attributesBuilder.put("database", databaseName.getDatabase());
            attributesBuilder.put("instance_id", databaseName.getInstance());
            attributesBuilder.put("project_id", databaseName.getProject());
            attributesBuilder.put("method", method);
            return attributesBuilder.build();
        });
    }

    private Map<String, String> getBuiltInMetricAttributes(String key, DatabaseName databaseName) throws ExecutionException {
        return (Map)this.builtInAttributesCache.get((Object)key, () -> {
            HashMap<String, String> attributes = new HashMap<String, String>();
            attributes.put(BuiltInMetricsConstant.DATABASE_KEY.getKey(), databaseName.getDatabase());
            attributes.put(BuiltInMetricsConstant.INSTANCE_ID_KEY.getKey(), databaseName.getInstance());
            attributes.put(BuiltInMetricsConstant.DIRECT_PATH_ENABLED_KEY.getKey(), String.valueOf(this.directPathEnabledSupplier.get()));
            return attributes;
        });
    }

    private void addBuiltInMetricAttributes(CompositeTracer compositeTracer, Map<String, String> builtInMetricsAttributes) {
        if (compositeTracer != null) {
            compositeTracer.addAttributes(builtInMetricsAttributes);
        }
    }

    private void addDirectPathUsedAttribute(CompositeTracer compositeTracer, Boolean isDirectPathUsed) {
        if (compositeTracer != null) {
            compositeTracer.addAttributes(BuiltInMetricsConstant.DIRECT_PATH_USED_KEY.getKey(), Boolean.toString(isDirectPathUsed));
        }
    }

    private Boolean isDirectPathUsed(SocketAddress remoteAddr) {
        if (remoteAddr instanceof InetSocketAddress) {
            InetAddress inetAddress = ((InetSocketAddress)remoteAddr).getAddress();
            String addr = inetAddress.getHostAddress();
            return addr.startsWith("34.126") || addr.startsWith("2001:4860:8040");
        }
        return false;
    }
}

