/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner.connection;

import com.google.cloud.Timestamp;
import com.google.cloud.spanner.DatabaseClient;
import com.google.cloud.spanner.ErrorCode;
import com.google.cloud.spanner.Mutation;
import com.google.cloud.spanner.ReadContext;
import com.google.cloud.spanner.SpannerException;
import com.google.cloud.spanner.SpannerExceptionFactory;
import com.google.cloud.spanner.TimestampBound;
import com.google.cloud.spanner.connection.AbstractBaseUnitOfWork;
import com.google.cloud.spanner.connection.AbstractMultiUseTransaction;
import com.google.cloud.spanner.connection.ConnectionPreconditions;
import com.google.cloud.spanner.connection.StatementParser;
import com.google.cloud.spanner.connection.UnitOfWork;
import com.google.common.base.Preconditions;

class ReadOnlyTransaction
extends AbstractMultiUseTransaction {
    private final DatabaseClient dbClient;
    private final TimestampBound readOnlyStaleness;
    private com.google.cloud.spanner.ReadOnlyTransaction transaction;
    private UnitOfWork.UnitOfWorkState state = UnitOfWork.UnitOfWorkState.STARTED;

    static Builder newBuilder() {
        return new Builder();
    }

    private ReadOnlyTransaction(Builder builder) {
        super(builder);
        this.dbClient = builder.dbClient;
        this.readOnlyStaleness = builder.readOnlyStaleness;
    }

    @Override
    public UnitOfWork.UnitOfWorkState getState() {
        return this.state;
    }

    @Override
    public boolean isReadOnly() {
        return true;
    }

    @Override
    void checkValidTransaction() {
        if (this.transaction == null) {
            this.transaction = this.dbClient.readOnlyTransaction(this.readOnlyStaleness);
        }
    }

    @Override
    ReadContext getReadContext() {
        ConnectionPreconditions.checkState(this.transaction != null, "Missing read-only transaction");
        return this.transaction;
    }

    @Override
    public Timestamp getReadTimestamp() {
        ConnectionPreconditions.checkState(this.transaction != null, "There is no read timestamp available for this transaction.");
        ConnectionPreconditions.checkState(this.state != UnitOfWork.UnitOfWorkState.ROLLED_BACK, "This transaction was rolled back");
        return this.transaction.getReadTimestamp();
    }

    @Override
    public Timestamp getReadTimestampOrNull() {
        if (this.transaction != null && this.state != UnitOfWork.UnitOfWorkState.ROLLED_BACK) {
            try {
                return this.transaction.getReadTimestamp();
            }
            catch (SpannerException spannerException) {
                // empty catch block
            }
        }
        return null;
    }

    @Override
    public Timestamp getCommitTimestamp() {
        throw SpannerExceptionFactory.newSpannerException(ErrorCode.FAILED_PRECONDITION, "There is no commit timestamp available for this transaction.");
    }

    @Override
    public Timestamp getCommitTimestampOrNull() {
        return null;
    }

    @Override
    public void executeDdl(StatementParser.ParsedStatement ddl) {
        throw SpannerExceptionFactory.newSpannerException(ErrorCode.FAILED_PRECONDITION, "DDL statements are not allowed for read-only transactions");
    }

    @Override
    public long executeUpdate(StatementParser.ParsedStatement update) {
        throw SpannerExceptionFactory.newSpannerException(ErrorCode.FAILED_PRECONDITION, "Update statements are not allowed for read-only transactions");
    }

    @Override
    public long[] executeBatchUpdate(Iterable<StatementParser.ParsedStatement> updates) {
        throw SpannerExceptionFactory.newSpannerException(ErrorCode.FAILED_PRECONDITION, "Batch updates are not allowed for read-only transactions.");
    }

    @Override
    public void write(Mutation mutation) {
        throw SpannerExceptionFactory.newSpannerException(ErrorCode.FAILED_PRECONDITION, "Mutations are not allowed for read-only transactions");
    }

    @Override
    public void write(Iterable<Mutation> mutations) {
        throw SpannerExceptionFactory.newSpannerException(ErrorCode.FAILED_PRECONDITION, "Mutations are not allowed for read-only transactions");
    }

    @Override
    public void commit() {
        if (this.transaction != null) {
            this.transaction.close();
        }
        this.state = UnitOfWork.UnitOfWorkState.COMMITTED;
    }

    @Override
    public void rollback() {
        if (this.transaction != null) {
            this.transaction.close();
        }
        this.state = UnitOfWork.UnitOfWorkState.ROLLED_BACK;
    }

    static class Builder
    extends AbstractBaseUnitOfWork.Builder<Builder, ReadOnlyTransaction> {
        private DatabaseClient dbClient;
        private TimestampBound readOnlyStaleness;

        private Builder() {
        }

        Builder setDatabaseClient(DatabaseClient client) {
            Preconditions.checkNotNull((Object)client);
            this.dbClient = client;
            return this;
        }

        Builder setReadOnlyStaleness(TimestampBound staleness) {
            Preconditions.checkNotNull((Object)staleness);
            this.readOnlyStaleness = staleness;
            return this;
        }

        @Override
        ReadOnlyTransaction build() {
            Preconditions.checkState((this.dbClient != null ? 1 : 0) != 0, (Object)"No DatabaseClient client specified");
            Preconditions.checkState((this.readOnlyStaleness != null ? 1 : 0) != 0, (Object)"No ReadOnlyStaleness specified");
            return new ReadOnlyTransaction(this);
        }
    }
}

