/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner.connection;

import com.google.cloud.spanner.ErrorCode;
import com.google.cloud.spanner.SpannerExceptionFactory;
import com.google.cloud.spanner.connection.ClientSideStatementExecutor;
import com.google.cloud.spanner.connection.ClientSideStatementImpl;
import com.google.cloud.spanner.connection.ClientSideStatementValueConverter;
import com.google.cloud.spanner.connection.ConnectionStatementExecutor;
import com.google.cloud.spanner.connection.StatementResult;
import com.google.common.base.Preconditions;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

class ClientSideStatementSetExecutor<T>
implements ClientSideStatementExecutor {
    private ClientSideStatementImpl statement;
    private Method method;
    private ClientSideStatementValueConverter<T> converter;
    private Pattern allowedValuesPattern;

    ClientSideStatementSetExecutor() {
    }

    @Override
    public void compile(ClientSideStatementImpl statement) throws ClientSideStatementImpl.CompileException {
        Preconditions.checkNotNull((Object)statement.getSetStatement());
        try {
            this.statement = statement;
            this.allowedValuesPattern = Pattern.compile(String.format("(?is)\\A\\s*set\\s+%s\\s*%s\\s*%s\\s*\\z", statement.getSetStatement().getPropertyName(), statement.getSetStatement().getSeparator(), statement.getSetStatement().getAllowedValues()));
            Class<?> converterClass = Class.forName(this.getClass().getPackage().getName() + "." + statement.getSetStatement().getConverterName());
            Constructor<?> constructor = converterClass.getConstructor(String.class);
            this.converter = (ClientSideStatementValueConverter)constructor.newInstance(statement.getSetStatement().getAllowedValues());
            this.method = ConnectionStatementExecutor.class.getDeclaredMethod(statement.getMethodName(), this.converter.getParameterClass());
        }
        catch (Exception e) {
            throw new ClientSideStatementImpl.CompileException(e, statement);
        }
    }

    @Override
    public StatementResult execute(ConnectionStatementExecutor connection, String sql) throws Exception {
        return (StatementResult)this.method.invoke((Object)connection, this.getParameterValue(sql));
    }

    T getParameterValue(String sql) {
        Matcher matcher = this.allowedValuesPattern.matcher(sql);
        if (matcher.find() && matcher.groupCount() >= 1) {
            String value = matcher.group(1);
            T res = this.converter.convert(value);
            if (res != null) {
                return res;
            }
            throw SpannerExceptionFactory.newSpannerException(ErrorCode.INVALID_ARGUMENT, String.format("Unknown value for %s: %s", this.statement.getSetStatement().getPropertyName(), value));
        }
        Matcher invalidMatcher = this.statement.getPattern().matcher(sql);
        if (invalidMatcher.find() && invalidMatcher.groupCount() == 1) {
            String invalidValue = invalidMatcher.group(1);
            throw SpannerExceptionFactory.newSpannerException(ErrorCode.INVALID_ARGUMENT, String.format("Unknown value for %s: %s", this.statement.getSetStatement().getPropertyName(), invalidValue));
        }
        throw SpannerExceptionFactory.newSpannerException(ErrorCode.INVALID_ARGUMENT, String.format("Unknown statement: %s", sql));
    }
}

