/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.shell.v1.stub;

import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.core.BackgroundResourceAggregation;
import com.google.api.gax.grpc.GrpcCallSettings;
import com.google.api.gax.grpc.GrpcStubCallableFactory;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.OperationCallable;
import com.google.api.gax.rpc.RequestParamsBuilder;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.shell.v1.AddPublicKeyMetadata;
import com.google.cloud.shell.v1.AddPublicKeyRequest;
import com.google.cloud.shell.v1.AddPublicKeyResponse;
import com.google.cloud.shell.v1.AuthorizeEnvironmentMetadata;
import com.google.cloud.shell.v1.AuthorizeEnvironmentRequest;
import com.google.cloud.shell.v1.AuthorizeEnvironmentResponse;
import com.google.cloud.shell.v1.Environment;
import com.google.cloud.shell.v1.GetEnvironmentRequest;
import com.google.cloud.shell.v1.RemovePublicKeyMetadata;
import com.google.cloud.shell.v1.RemovePublicKeyRequest;
import com.google.cloud.shell.v1.RemovePublicKeyResponse;
import com.google.cloud.shell.v1.StartEnvironmentMetadata;
import com.google.cloud.shell.v1.StartEnvironmentRequest;
import com.google.cloud.shell.v1.StartEnvironmentResponse;
import com.google.cloud.shell.v1.stub.CloudShellServiceStub;
import com.google.cloud.shell.v1.stub.CloudShellServiceStubSettings;
import com.google.cloud.shell.v1.stub.GrpcCloudShellServiceCallableFactory;
import com.google.longrunning.Operation;
import com.google.longrunning.stub.GrpcOperationsStub;
import com.google.longrunning.stub.OperationsStub;
import com.google.protobuf.Message;
import io.grpc.MethodDescriptor;
import io.grpc.protobuf.ProtoUtils;
import java.io.IOException;
import java.util.concurrent.TimeUnit;

public class GrpcCloudShellServiceStub
extends CloudShellServiceStub {
    private static final MethodDescriptor<GetEnvironmentRequest, Environment> getEnvironmentMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.shell.v1.CloudShellService/GetEnvironment").setRequestMarshaller(ProtoUtils.marshaller((Message)GetEnvironmentRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Environment.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private static final MethodDescriptor<StartEnvironmentRequest, Operation> startEnvironmentMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.shell.v1.CloudShellService/StartEnvironment").setRequestMarshaller(ProtoUtils.marshaller((Message)StartEnvironmentRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Operation.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private static final MethodDescriptor<AuthorizeEnvironmentRequest, Operation> authorizeEnvironmentMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.shell.v1.CloudShellService/AuthorizeEnvironment").setRequestMarshaller(ProtoUtils.marshaller((Message)AuthorizeEnvironmentRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Operation.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private static final MethodDescriptor<AddPublicKeyRequest, Operation> addPublicKeyMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.shell.v1.CloudShellService/AddPublicKey").setRequestMarshaller(ProtoUtils.marshaller((Message)AddPublicKeyRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Operation.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private static final MethodDescriptor<RemovePublicKeyRequest, Operation> removePublicKeyMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.shell.v1.CloudShellService/RemovePublicKey").setRequestMarshaller(ProtoUtils.marshaller((Message)RemovePublicKeyRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Operation.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private final UnaryCallable<GetEnvironmentRequest, Environment> getEnvironmentCallable;
    private final UnaryCallable<StartEnvironmentRequest, Operation> startEnvironmentCallable;
    private final OperationCallable<StartEnvironmentRequest, StartEnvironmentResponse, StartEnvironmentMetadata> startEnvironmentOperationCallable;
    private final UnaryCallable<AuthorizeEnvironmentRequest, Operation> authorizeEnvironmentCallable;
    private final OperationCallable<AuthorizeEnvironmentRequest, AuthorizeEnvironmentResponse, AuthorizeEnvironmentMetadata> authorizeEnvironmentOperationCallable;
    private final UnaryCallable<AddPublicKeyRequest, Operation> addPublicKeyCallable;
    private final OperationCallable<AddPublicKeyRequest, AddPublicKeyResponse, AddPublicKeyMetadata> addPublicKeyOperationCallable;
    private final UnaryCallable<RemovePublicKeyRequest, Operation> removePublicKeyCallable;
    private final OperationCallable<RemovePublicKeyRequest, RemovePublicKeyResponse, RemovePublicKeyMetadata> removePublicKeyOperationCallable;
    private final BackgroundResource backgroundResources;
    private final GrpcOperationsStub operationsStub;
    private final GrpcStubCallableFactory callableFactory;

    public static final GrpcCloudShellServiceStub create(CloudShellServiceStubSettings settings) throws IOException {
        return new GrpcCloudShellServiceStub(settings, ClientContext.create((StubSettings)settings));
    }

    public static final GrpcCloudShellServiceStub create(ClientContext clientContext) throws IOException {
        return new GrpcCloudShellServiceStub(CloudShellServiceStubSettings.newBuilder().build(), clientContext);
    }

    public static final GrpcCloudShellServiceStub create(ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        return new GrpcCloudShellServiceStub(CloudShellServiceStubSettings.newBuilder().build(), clientContext, callableFactory);
    }

    protected GrpcCloudShellServiceStub(CloudShellServiceStubSettings settings, ClientContext clientContext) throws IOException {
        this(settings, clientContext, new GrpcCloudShellServiceCallableFactory());
    }

    protected GrpcCloudShellServiceStub(CloudShellServiceStubSettings settings, ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        this.callableFactory = callableFactory;
        this.operationsStub = GrpcOperationsStub.create((ClientContext)clientContext, (GrpcStubCallableFactory)callableFactory);
        GrpcCallSettings getEnvironmentTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(getEnvironmentMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        GrpcCallSettings startEnvironmentTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(startEnvironmentMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        GrpcCallSettings authorizeEnvironmentTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(authorizeEnvironmentMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        GrpcCallSettings addPublicKeyTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(addPublicKeyMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("environment", String.valueOf(request.getEnvironment()));
            return builder.build();
        }).build();
        GrpcCallSettings removePublicKeyTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(removePublicKeyMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("environment", String.valueOf(request.getEnvironment()));
            return builder.build();
        }).build();
        this.getEnvironmentCallable = callableFactory.createUnaryCallable(getEnvironmentTransportSettings, settings.getEnvironmentSettings(), clientContext);
        this.startEnvironmentCallable = callableFactory.createUnaryCallable(startEnvironmentTransportSettings, settings.startEnvironmentSettings(), clientContext);
        this.startEnvironmentOperationCallable = callableFactory.createOperationCallable(startEnvironmentTransportSettings, settings.startEnvironmentOperationSettings(), clientContext, (OperationsStub)this.operationsStub);
        this.authorizeEnvironmentCallable = callableFactory.createUnaryCallable(authorizeEnvironmentTransportSettings, settings.authorizeEnvironmentSettings(), clientContext);
        this.authorizeEnvironmentOperationCallable = callableFactory.createOperationCallable(authorizeEnvironmentTransportSettings, settings.authorizeEnvironmentOperationSettings(), clientContext, (OperationsStub)this.operationsStub);
        this.addPublicKeyCallable = callableFactory.createUnaryCallable(addPublicKeyTransportSettings, settings.addPublicKeySettings(), clientContext);
        this.addPublicKeyOperationCallable = callableFactory.createOperationCallable(addPublicKeyTransportSettings, settings.addPublicKeyOperationSettings(), clientContext, (OperationsStub)this.operationsStub);
        this.removePublicKeyCallable = callableFactory.createUnaryCallable(removePublicKeyTransportSettings, settings.removePublicKeySettings(), clientContext);
        this.removePublicKeyOperationCallable = callableFactory.createOperationCallable(removePublicKeyTransportSettings, settings.removePublicKeyOperationSettings(), clientContext, (OperationsStub)this.operationsStub);
        this.backgroundResources = new BackgroundResourceAggregation(clientContext.getBackgroundResources());
    }

    public GrpcOperationsStub getOperationsStub() {
        return this.operationsStub;
    }

    @Override
    public UnaryCallable<GetEnvironmentRequest, Environment> getEnvironmentCallable() {
        return this.getEnvironmentCallable;
    }

    @Override
    public UnaryCallable<StartEnvironmentRequest, Operation> startEnvironmentCallable() {
        return this.startEnvironmentCallable;
    }

    @Override
    public OperationCallable<StartEnvironmentRequest, StartEnvironmentResponse, StartEnvironmentMetadata> startEnvironmentOperationCallable() {
        return this.startEnvironmentOperationCallable;
    }

    @Override
    public UnaryCallable<AuthorizeEnvironmentRequest, Operation> authorizeEnvironmentCallable() {
        return this.authorizeEnvironmentCallable;
    }

    @Override
    public OperationCallable<AuthorizeEnvironmentRequest, AuthorizeEnvironmentResponse, AuthorizeEnvironmentMetadata> authorizeEnvironmentOperationCallable() {
        return this.authorizeEnvironmentOperationCallable;
    }

    @Override
    public UnaryCallable<AddPublicKeyRequest, Operation> addPublicKeyCallable() {
        return this.addPublicKeyCallable;
    }

    @Override
    public OperationCallable<AddPublicKeyRequest, AddPublicKeyResponse, AddPublicKeyMetadata> addPublicKeyOperationCallable() {
        return this.addPublicKeyOperationCallable;
    }

    @Override
    public UnaryCallable<RemovePublicKeyRequest, Operation> removePublicKeyCallable() {
        return this.removePublicKeyCallable;
    }

    @Override
    public OperationCallable<RemovePublicKeyRequest, RemovePublicKeyResponse, RemovePublicKeyMetadata> removePublicKeyOperationCallable() {
        return this.removePublicKeyOperationCallable;
    }

    @Override
    public final void close() {
        try {
            this.backgroundResources.close();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to close resource", e);
        }
    }

    public void shutdown() {
        this.backgroundResources.shutdown();
    }

    public boolean isShutdown() {
        return this.backgroundResources.isShutdown();
    }

    public boolean isTerminated() {
        return this.backgroundResources.isTerminated();
    }

    public void shutdownNow() {
        this.backgroundResources.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.backgroundResources.awaitTermination(duration, unit);
    }
}

